/*-
 * SPDX-License-Identifier: BSD-2-Clause-FreeBSD
 *
 * Copyright (c) 2005 Robert N. M. Watson
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD: stable/12/lib/libmemstat/memstat_all.c 326219 2017-11-26 02:00:33Z pfg $
 */

#include <sys/types.h>
#include <sys/queue.h>

#include "memstat.h"

/*
 * Query all available memory allocator sources.  Currently this consists of
 * malloc(9) and UMA(9).
 */
int
memstat_sysctl_all(struct memory_type_list *mtlp, int flags)
{

	if (memstat_sysctl_malloc(mtlp, flags) < 0)
		return (-1);
	if (memstat_sysctl_uma(mtlp, flags) < 0)
		return (-1);
	return (0);
}

int
memstat_kvm_all(struct memory_type_list *mtlp, void *kvm_handle)
{

	if (memstat_kvm_malloc(mtlp, kvm_handle) < 0)
		return (-1);
	if (memstat_kvm_uma(mtlp, kvm_handle) < 0)
		return (-1);
	return (0);
}
