/*
 *  Copyright (C) 2021 - This file is part of libecc project
 *
 *  Authors:
 *      Arnaud EBALARD <arnaud.ebalard@ssi.gouv.fr>
 *      Ryad BENADJILA <ryadbenadjila@gmail.com>
 *
 *  This software is licensed under a dual BSD and GPL v2 license.
 *  See LICENSE file at the root folder of the project.
 */
#include <libecc/lib_ecc_config.h>
#ifdef WITH_CURVE_WEI25519

#ifndef __EC_PARAMS_WEI25519_H__
#define __EC_PARAMS_WEI25519_H__
#include <libecc/curves/known/ec_params_external.h>
static const u8 wei25519_p[] = {
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xed,
};

TO_EC_STR_PARAM(wei25519_p);

#define CURVE_WEI25519_P_BITLEN 255
static const u8 wei25519_p_bitlen[] = {
	0xff,
};

TO_EC_STR_PARAM(wei25519_p_bitlen);

#if (WORD_BYTES == 8)     /* 64-bit words */
static const u8 wei25519_r[] = {
	0x26,
};

TO_EC_STR_PARAM(wei25519_r);

static const u8 wei25519_r_square[] = {
	0x05, 0xa4,
};

TO_EC_STR_PARAM(wei25519_r_square);

static const u8 wei25519_mpinv[] = {
	0x86, 0xbc, 0xa1, 0xaf, 0x28, 0x6b, 0xca, 0x1b,
};

TO_EC_STR_PARAM(wei25519_mpinv);

static const u8 wei25519_p_shift[] = {
	0x01,
};

TO_EC_STR_PARAM(wei25519_p_shift);

static const u8 wei25519_p_normalized[] = {
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,
};

TO_EC_STR_PARAM(wei25519_p_normalized);

static const u8 wei25519_p_reciprocal[] = {
	0x00,
};

TO_EC_STR_PARAM(wei25519_p_reciprocal);

#elif (WORD_BYTES == 4)   /* 32-bit words */
static const u8 wei25519_r[] = {
	0x26,
};

TO_EC_STR_PARAM(wei25519_r);

static const u8 wei25519_r_square[] = {
	0x05, 0xa4,
};

TO_EC_STR_PARAM(wei25519_r_square);

static const u8 wei25519_mpinv[] = {
	0x28, 0x6b, 0xca, 0x1b,
};

TO_EC_STR_PARAM(wei25519_mpinv);

static const u8 wei25519_p_shift[] = {
	0x01,
};

TO_EC_STR_PARAM(wei25519_p_shift);

static const u8 wei25519_p_normalized[] = {
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,
};

TO_EC_STR_PARAM(wei25519_p_normalized);

static const u8 wei25519_p_reciprocal[] = {
	0x00,
};

TO_EC_STR_PARAM(wei25519_p_reciprocal);

#elif (WORD_BYTES == 2)   /* 16-bit words */
static const u8 wei25519_r[] = {
	0x26,
};

TO_EC_STR_PARAM(wei25519_r);

static const u8 wei25519_r_square[] = {
	0x05, 0xa4,
};

TO_EC_STR_PARAM(wei25519_r_square);

static const u8 wei25519_mpinv[] = {
	0xca, 0x1b,
};

TO_EC_STR_PARAM(wei25519_mpinv);

static const u8 wei25519_p_shift[] = {
	0x01,
};

TO_EC_STR_PARAM(wei25519_p_shift);

static const u8 wei25519_p_normalized[] = {
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,
};

TO_EC_STR_PARAM(wei25519_p_normalized);

static const u8 wei25519_p_reciprocal[] = {
	0x00,
};

TO_EC_STR_PARAM(wei25519_p_reciprocal);

#else                     /* unknown word size */
#error "Unsupported word size"
#endif

static const u8 wei25519_a[] = {
	0x2a, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
	0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
	0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
	0xaa, 0xaa, 0xaa, 0x98, 0x49, 0x14, 0xa1, 0x44,
};

TO_EC_STR_PARAM(wei25519_a);

static const u8 wei25519_b[] = {
	0x7b, 0x42, 0x5e, 0xd0, 0x97, 0xb4, 0x25, 0xed,
	0x09, 0x7b, 0x42, 0x5e, 0xd0, 0x97, 0xb4, 0x25,
	0xed, 0x09, 0x7b, 0x42, 0x5e, 0xd0, 0x97, 0xb4,
	0x26, 0x0b, 0x5e, 0x9c, 0x77, 0x10, 0xc8, 0x64,
};

TO_EC_STR_PARAM(wei25519_b);

#define CURVE_WEI25519_CURVE_ORDER_BITLEN 256
static const u8 wei25519_curve_order[] = {
	0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xa6, 0xf7, 0xce, 0xf5, 0x17, 0xbc, 0xe6, 0xb2,
	0xc0, 0x93, 0x18, 0xd2, 0xe7, 0xae, 0x9f, 0x68,
};

TO_EC_STR_PARAM(wei25519_curve_order);

static const u8 wei25519_gx[] = {
	0x2a, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
	0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
	0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
	0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xad, 0x24, 0x5a,
};

TO_EC_STR_PARAM(wei25519_gx);

static const u8 wei25519_gy[] = {
	0x20, 0xae, 0x19, 0xa1, 0xb8, 0xa0, 0x86, 0xb4,
	0xe0, 0x1e, 0xdd, 0x2c, 0x77, 0x48, 0xd1, 0x4c,
	0x92, 0x3d, 0x4d, 0x7e, 0x6d, 0x7c, 0x61, 0xb2,
	0x29, 0xe9, 0xc5, 0xa2, 0x7e, 0xce, 0xd3, 0xd9,
};

TO_EC_STR_PARAM(wei25519_gy);

static const u8 wei25519_gz[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
};

TO_EC_STR_PARAM(wei25519_gz);

static const u8 wei25519_gen_order[] = {
	0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x14, 0xde, 0xf9, 0xde, 0xa2, 0xf7, 0x9c, 0xd6,
	0x58, 0x12, 0x63, 0x1a, 0x5c, 0xf5, 0xd3, 0xed,
};

TO_EC_STR_PARAM(wei25519_gen_order);

#define CURVE_WEI25519_Q_BITLEN 253
static const u8 wei25519_gen_order_bitlen[] = {
	0xfd,
};

TO_EC_STR_PARAM(wei25519_gen_order_bitlen);

static const u8 wei25519_cofactor[] = {
	0x08,
};

TO_EC_STR_PARAM(wei25519_cofactor);

static const u8 wei25519_alpha_montgomery[] = {
        0x2a, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
        0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
        0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
        0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xad, 0x24, 0x51,
};

TO_EC_STR_PARAM(wei25519_alpha_montgomery);

static const u8 wei25519_gamma_montgomery[] = {
	0x01,
};

TO_EC_STR_PARAM(wei25519_gamma_montgomery);

static const u8 wei25519_alpha_edwards[] = {
	0x70, 0xd9, 0x12, 0x0b, 0x9f, 0x5f, 0xf9, 0x44,
	0x2d, 0x84, 0xf7, 0x23, 0xfc, 0x03, 0xb0, 0x81,
	0x3a, 0x5e, 0x2c, 0x2e, 0xb4, 0x82, 0xe5, 0x7d,
	0x33, 0x91, 0xfb, 0x55, 0x00, 0xba, 0x81, 0xe7
};

TO_EC_STR_PARAM(wei25519_alpha_edwards);

static const u8 wei25519_name[] = "WEI25519";
TO_EC_STR_PARAM(wei25519_name);

static const u8 wei25519_oid[] = "";
TO_EC_STR_PARAM(wei25519_oid);

static const ec_str_params wei25519_str_params = {
	.p = &wei25519_p_str_param,
	.p_bitlen = &wei25519_p_bitlen_str_param,
	.r = &wei25519_r_str_param,
	.r_square = &wei25519_r_square_str_param,
	.mpinv = &wei25519_mpinv_str_param,
	.p_shift = &wei25519_p_shift_str_param,
	.p_normalized = &wei25519_p_normalized_str_param,
	.p_reciprocal = &wei25519_p_reciprocal_str_param,
	.a = &wei25519_a_str_param,
	.b = &wei25519_b_str_param,
	.curve_order = &wei25519_curve_order_str_param,
	.gx = &wei25519_gx_str_param,
	.gy = &wei25519_gy_str_param,
	.gz = &wei25519_gz_str_param,
	.gen_order = &wei25519_gen_order_str_param,
	.gen_order_bitlen = &wei25519_gen_order_bitlen_str_param,
	.cofactor = &wei25519_cofactor_str_param,
	.alpha_montgomery = &wei25519_alpha_montgomery_str_param,
	.gamma_montgomery = &wei25519_gamma_montgomery_str_param,
	.alpha_edwards = &wei25519_alpha_edwards_str_param,
	.oid = &wei25519_oid_str_param,
	.name = &wei25519_name_str_param,
};

/*
 * Compute max bit length of all curves for p and q
 */
#ifndef CURVES_MAX_P_BIT_LEN
#define CURVES_MAX_P_BIT_LEN    0
#endif
#if (CURVES_MAX_P_BIT_LEN < CURVE_WEI25519_P_BITLEN)
#undef CURVES_MAX_P_BIT_LEN
#define CURVES_MAX_P_BIT_LEN CURVE_WEI25519_P_BITLEN
#endif
#ifndef CURVES_MAX_Q_BIT_LEN
#define CURVES_MAX_Q_BIT_LEN    0
#endif
#if (CURVES_MAX_Q_BIT_LEN < CURVE_WEI25519_Q_BITLEN)
#undef CURVES_MAX_Q_BIT_LEN
#define CURVES_MAX_Q_BIT_LEN CURVE_WEI25519_Q_BITLEN
#endif
#ifndef CURVES_MAX_CURVE_ORDER_BIT_LEN
#define CURVES_MAX_CURVE_ORDER_BIT_LEN    0
#endif
#if (CURVES_MAX_CURVE_ORDER_BIT_LEN < CURVE_WEI25519_CURVE_ORDER_BITLEN)
#undef CURVES_MAX_CURVE_ORDER_BIT_LEN
#define CURVES_MAX_CURVE_ORDER_BIT_LEN CURVE_WEI25519_CURVE_ORDER_BITLEN
#endif

/*
 * Compute and adapt max name and oid length
 */
#ifndef MAX_CURVE_OID_LEN
#define MAX_CURVE_OID_LEN 0
#endif
#ifndef MAX_CURVE_NAME_LEN
#define MAX_CURVE_NAME_LEN 0
#endif
#if (MAX_CURVE_OID_LEN < 1)
#undef MAX_CURVE_OID_LEN
#define MAX_CURVE_OID_LEN 1
#endif
#if (MAX_CURVE_NAME_LEN < 22)
#undef MAX_CURVE_NAME_LEN
#define MAX_CURVE_NAME_LEN 22
#endif

#endif /* __EC_PARAMS_WEI25519_H__ */

#endif /* WITH_CURVE_WEI25519 */
