# $FreeBSD: stable/3/gnu/usr.bin/perl/Makefile.inc 50569 1999-08-29 14:49:43Z peter $

PERL5SRC?= ${.CURDIR}/../../../../contrib/perl5

BINDIR?=	/usr/bin

SHLIB_MAJOR?=	3
SHLIB_MINOR?=	0

HEADERS=EXTERN.h INTERN.h XSUB.h XSlock.h av.h bytecode.h byterun.h \
	cc_runtime.h cop.h cv.h dosish.h embed.h embedvar.h fakethr.h form.h \
	gv.h handy.h hv.h intrpvar.h iperlsys.h keywords.h mg.h nostdio.h \
	objXSUB.h objpp.h op.h opcode.h patchlevel.h perl.h perlio.h \
	perlsdio.h perlsfio.h perlvars.h perly.h pp.h pp_proto.h proto.h \
	regcomp.h regexp.h regnodes.h scope.h sv.h thrdvar.h thread.h \
	unixish.h util.h

DEPEND_H=

.for I in ${HEADERS}
${.OBJDIR}/${I}: ${I}
	@ln -sf ${.OODATE} ${.TARGET}

CLEANFILES+= ${.OBJDIR}/${I}
DEPEND_H+= ${.OBJDIR}/${I}
.endfor

linkfarm: ${DEPEND_H}
	@for d in ${CLEANDIRS} ; do \
		rm -rf $${d} ;\
		for i in `cd ${PERL5SRC}; find $${d} -type d -a \! -name CVS` ;\
		do \
			mkdir -p $${i} ;\
		done ;\
		for i in `cd ${PERL5SRC}; find $${d} -type f | grep -v CVS` ;\
		do \
			ln -s ${PERL5SRC}/$${i} $${i} ;\
		done ;\
	done
	@mkdir lib/auto
	@mkdir build
	@ln -sf ${PERL5SRC}/config_h.SH config_h.sh
	@ln -sf ${PERL5SRC}/cflags.SH cflags.sh
	@ln -sf ${PERL5SRC}/ext/re/re.pm lib/re.pm
	@ln -sf ${PERL5SRC}/myconfig myconfig
	@ln -sf ${PERL5SRC}/miniperlmain.c miniperlmain.c
	@ln -sf ${PERL5SRC}/writemain.SH writemain.sh
	@ln -sf ${PERL5SRC}/regcomp.c regcomp.c
	@ln -sf ${PERL5SRC}/regexec.c regexec.c
	@ln -sf ${.CURDIR}/../libperl/config.SH-${OBJFORMAT}.${MACHINE_ARCH} \
		config.sh
	@touch ${.TARGET}

CLEANFILES+=	linkfarm
CLEANDIRS+=	lib ext Porting hints build
