/*-
 * Copyright (C) 2009-2012 Semihalf
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD: stable/10/sys/dev/nand/nandsim_log.h 235537 2012-05-17 10:11:18Z gber $
 */

#ifndef _NANDSIM_LOG_H
#define _NANDSIM_LOG_H

#include <dev/nand/nandsim_chip.h>

#define NANDSIM_ENTRY_SIZE	128
#define NANDSIM_ENTRY_COUNT	1024
#define NANDSIM_RAM_LOG_SIZE	16384
#define TIME_STR_SIZE		40

#define NANDSIM_LOG_ERR		1
#define NANDSIM_LOG_SM		5
#define NANDSIM_LOG_EV		10
#define NANDSIM_LOG_DATA	15

extern int nandsim_log_level;
extern int nandsim_log_output;

int nandsim_log_init(struct nandsim_softc *, char *);
void nandsim_log_close(struct nandsim_softc *);
void nandsim_log(struct nandsim_chip *, int, const char *, ...);

#endif /*  _NANDSIM_LOG_H */

