/*-
 * SPDX-License-Identifier: BSD-2-Clause-FreeBSD
 *
 * Copyright (c) 2010, Aleksandr Rybalko <ray@ddteam.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice unmodified, this list of conditions, and the following
 *    disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD: stable/12/sys/dev/bhnd/cores/usb/bhnd_usbvar.h 326695 2017-12-08 15:57:29Z pfg $
 *
 */

#ifndef _BHND_USBVAR_H_
#define _BHND_USBVAR_H_

struct bhnd_usb_softc {
	bus_space_tag_t		 sc_bt;
	bus_space_handle_t	 sc_bh;
	bus_addr_t		 sc_maddr;
	bus_size_t		 sc_msize;
	bus_addr_t		 sc_irqn;
	struct intr_event	*sc_events; /* IRQ events structs */

	struct resource *sc_mem;
	struct resource *sc_irq;
	struct rman 		 mem_rman;
	struct rman 		 irq_rman;
	int 			devid;

};

struct bhnd_usb_devinfo {
	struct resource_list	sdi_rl;
	uint8_t			sdi_unit;	/* core index on bus */
	rman_res_t		sdi_irq;	/**< child IRQ, if mapped */
	bool			sdi_irq_mapped;	/**< true if IRQ mapped, false otherwise */
	char 			sdi_name[8];
	rman_res_t 		sdi_maddr;
	rman_res_t 		sdi_msize;
};

#endif /* _BHND_USBVAR_H_ */
