/* SPDX-License-Identifier: BSD-3-Clause */
/*  Copyright (c) 2020, Intel Corporation
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions are met:
 *
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *
 *   3. Neither the name of the Intel Corporation nor the names of its
 *      contributors may be used to endorse or promote products derived from
 *      this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 *  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 *  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 *  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 *  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */
/*$FreeBSD: stable/12/sys/dev/ice/ice_hw_autogen.h 365731 2020-09-14 21:33:11Z erj $*/

/* Machine-generated file; do not edit */
#ifndef _ICE_HW_AUTOGEN_H_
#define _ICE_HW_AUTOGEN_H_

#define GL_RDPU_CNTRL				0x00052054 /* Reset Source: CORER */
#define GL_RDPU_CNTRL_RX_PAD_EN_S		0
#define GL_RDPU_CNTRL_RX_PAD_EN_M		BIT(0)
#define GL_RDPU_CNTRL_UDP_ZERO_EN_S		1
#define GL_RDPU_CNTRL_UDP_ZERO_EN_M		BIT(1)
#define GL_RDPU_CNTRL_BLNC_EN_S			2
#define GL_RDPU_CNTRL_BLNC_EN_M			BIT(2)
#define GL_RDPU_CNTRL_RECIPE_BYPASS_S		3
#define GL_RDPU_CNTRL_RECIPE_BYPASS_M		BIT(3)
#define GL_RDPU_CNTRL_RLAN_ACK_REQ_PM_TH_S	4
#define GL_RDPU_CNTRL_RLAN_ACK_REQ_PM_TH_M	MAKEMASK(0x3F, 4)
#define GL_RDPU_CNTRL_PE_ACK_REQ_PM_TH_S	10
#define GL_RDPU_CNTRL_PE_ACK_REQ_PM_TH_M	MAKEMASK(0x3F, 10)
#define GL_RDPU_CNTRL_REQ_WB_PM_TH_S		16
#define GL_RDPU_CNTRL_REQ_WB_PM_TH_M		MAKEMASK(0x1F, 16)
#define GL_RDPU_CNTRL_ECO_S			21
#define GL_RDPU_CNTRL_ECO_M			MAKEMASK(0x7FF, 21)
#define MSIX_PBA(_i)				(0x00008000 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: FLR */
#define MSIX_PBA_MAX_INDEX			2
#define MSIX_PBA_PENBIT_S			0
#define MSIX_PBA_PENBIT_M			MAKEMASK(0xFFFFFFFF, 0)
#define MSIX_TADD(_i)				(0x00000000 + ((_i) * 16)) /* _i=0...64 */ /* Reset Source: FLR */
#define MSIX_TADD_MAX_INDEX			64
#define MSIX_TADD_MSIXTADD10_S			0
#define MSIX_TADD_MSIXTADD10_M			MAKEMASK(0x3, 0)
#define MSIX_TADD_MSIXTADD_S			2
#define MSIX_TADD_MSIXTADD_M			MAKEMASK(0x3FFFFFFF, 2)
#define MSIX_TUADD(_i)				(0x00000004 + ((_i) * 16)) /* _i=0...64 */ /* Reset Source: FLR */
#define MSIX_TUADD_MAX_INDEX			64
#define MSIX_TUADD_MSIXTUADD_S			0
#define MSIX_TUADD_MSIXTUADD_M			MAKEMASK(0xFFFFFFFF, 0)
#define MSIX_TVCTRL(_i)				(0x0000000C + ((_i) * 16)) /* _i=0...64 */ /* Reset Source: FLR */
#define MSIX_TVCTRL_MAX_INDEX			64
#define MSIX_TVCTRL_MASK_S			0
#define MSIX_TVCTRL_MASK_M			BIT(0)
#define PF0_FW_HLP_ARQBAH_PAGE			0x02D00180 /* Reset Source: EMPR */
#define PF0_FW_HLP_ARQBAH_PAGE_ARQBAH_S		0
#define PF0_FW_HLP_ARQBAH_PAGE_ARQBAH_M		MAKEMASK(0xFFFFFFFF, 0)
#define PF0_FW_HLP_ARQBAL_PAGE			0x02D00080 /* Reset Source: EMPR */
#define PF0_FW_HLP_ARQBAL_PAGE_ARQBAL_LSB_S	0
#define PF0_FW_HLP_ARQBAL_PAGE_ARQBAL_LSB_M	MAKEMASK(0x3F, 0)
#define PF0_FW_HLP_ARQBAL_PAGE_ARQBAL_S		6
#define PF0_FW_HLP_ARQBAL_PAGE_ARQBAL_M		MAKEMASK(0x3FFFFFF, 6)
#define PF0_FW_HLP_ARQH_PAGE			0x02D00380 /* Reset Source: EMPR */
#define PF0_FW_HLP_ARQH_PAGE_ARQH_S		0
#define PF0_FW_HLP_ARQH_PAGE_ARQH_M		MAKEMASK(0x3FF, 0)
#define PF0_FW_HLP_ARQLEN_PAGE			0x02D00280 /* Reset Source: EMPR */
#define PF0_FW_HLP_ARQLEN_PAGE_ARQLEN_S		0
#define PF0_FW_HLP_ARQLEN_PAGE_ARQLEN_M		MAKEMASK(0x3FF, 0)
#define PF0_FW_HLP_ARQLEN_PAGE_ARQVFE_S		28
#define PF0_FW_HLP_ARQLEN_PAGE_ARQVFE_M		BIT(28)
#define PF0_FW_HLP_ARQLEN_PAGE_ARQOVFL_S	29
#define PF0_FW_HLP_ARQLEN_PAGE_ARQOVFL_M	BIT(29)
#define PF0_FW_HLP_ARQLEN_PAGE_ARQCRIT_S	30
#define PF0_FW_HLP_ARQLEN_PAGE_ARQCRIT_M	BIT(30)
#define PF0_FW_HLP_ARQLEN_PAGE_ARQENABLE_S	31
#define PF0_FW_HLP_ARQLEN_PAGE_ARQENABLE_M	BIT(31)
#define PF0_FW_HLP_ARQT_PAGE			0x02D00480 /* Reset Source: EMPR */
#define PF0_FW_HLP_ARQT_PAGE_ARQT_S		0
#define PF0_FW_HLP_ARQT_PAGE_ARQT_M		MAKEMASK(0x3FF, 0)
#define PF0_FW_HLP_ATQBAH_PAGE			0x02D00100 /* Reset Source: EMPR */
#define PF0_FW_HLP_ATQBAH_PAGE_ATQBAH_S		0
#define PF0_FW_HLP_ATQBAH_PAGE_ATQBAH_M		MAKEMASK(0xFFFFFFFF, 0)
#define PF0_FW_HLP_ATQBAL_PAGE			0x02D00000 /* Reset Source: EMPR */
#define PF0_FW_HLP_ATQBAL_PAGE_ATQBAL_LSB_S	0
#define PF0_FW_HLP_ATQBAL_PAGE_ATQBAL_LSB_M	MAKEMASK(0x3F, 0)
#define PF0_FW_HLP_ATQBAL_PAGE_ATQBAL_S		6
#define PF0_FW_HLP_ATQBAL_PAGE_ATQBAL_M		MAKEMASK(0x3FFFFFF, 6)
#define PF0_FW_HLP_ATQH_PAGE			0x02D00300 /* Reset Source: EMPR */
#define PF0_FW_HLP_ATQH_PAGE_ATQH_S		0
#define PF0_FW_HLP_ATQH_PAGE_ATQH_M		MAKEMASK(0x3FF, 0)
#define PF0_FW_HLP_ATQLEN_PAGE			0x02D00200 /* Reset Source: EMPR */
#define PF0_FW_HLP_ATQLEN_PAGE_ATQLEN_S		0
#define PF0_FW_HLP_ATQLEN_PAGE_ATQLEN_M		MAKEMASK(0x3FF, 0)
#define PF0_FW_HLP_ATQLEN_PAGE_ATQVFE_S		28
#define PF0_FW_HLP_ATQLEN_PAGE_ATQVFE_M		BIT(28)
#define PF0_FW_HLP_ATQLEN_PAGE_ATQOVFL_S	29
#define PF0_FW_HLP_ATQLEN_PAGE_ATQOVFL_M	BIT(29)
#define PF0_FW_HLP_ATQLEN_PAGE_ATQCRIT_S	30
#define PF0_FW_HLP_ATQLEN_PAGE_ATQCRIT_M	BIT(30)
#define PF0_FW_HLP_ATQLEN_PAGE_ATQENABLE_S	31
#define PF0_FW_HLP_ATQLEN_PAGE_ATQENABLE_M	BIT(31)
#define PF0_FW_HLP_ATQT_PAGE			0x02D00400 /* Reset Source: EMPR */
#define PF0_FW_HLP_ATQT_PAGE_ATQT_S		0
#define PF0_FW_HLP_ATQT_PAGE_ATQT_M		MAKEMASK(0x3FF, 0)
#define PF0_FW_PSM_ARQBAH_PAGE			0x02D40180 /* Reset Source: EMPR */
#define PF0_FW_PSM_ARQBAH_PAGE_ARQBAH_S		0
#define PF0_FW_PSM_ARQBAH_PAGE_ARQBAH_M		MAKEMASK(0xFFFFFFFF, 0)
#define PF0_FW_PSM_ARQBAL_PAGE			0x02D40080 /* Reset Source: EMPR */
#define PF0_FW_PSM_ARQBAL_PAGE_ARQBAL_LSB_S	0
#define PF0_FW_PSM_ARQBAL_PAGE_ARQBAL_LSB_M	MAKEMASK(0x3F, 0)
#define PF0_FW_PSM_ARQBAL_PAGE_ARQBAL_S		6
#define PF0_FW_PSM_ARQBAL_PAGE_ARQBAL_M		MAKEMASK(0x3FFFFFF, 6)
#define PF0_FW_PSM_ARQH_PAGE			0x02D40380 /* Reset Source: EMPR */
#define PF0_FW_PSM_ARQH_PAGE_ARQH_S		0
#define PF0_FW_PSM_ARQH_PAGE_ARQH_M		MAKEMASK(0x3FF, 0)
#define PF0_FW_PSM_ARQLEN_PAGE			0x02D40280 /* Reset Source: EMPR */
#define PF0_FW_PSM_ARQLEN_PAGE_ARQLEN_S		0
#define PF0_FW_PSM_ARQLEN_PAGE_ARQLEN_M		MAKEMASK(0x3FF, 0)
#define PF0_FW_PSM_ARQLEN_PAGE_ARQVFE_S		28
#define PF0_FW_PSM_ARQLEN_PAGE_ARQVFE_M		BIT(28)
#define PF0_FW_PSM_ARQLEN_PAGE_ARQOVFL_S	29
#define PF0_FW_PSM_ARQLEN_PAGE_ARQOVFL_M	BIT(29)
#define PF0_FW_PSM_ARQLEN_PAGE_ARQCRIT_S	30
#define PF0_FW_PSM_ARQLEN_PAGE_ARQCRIT_M	BIT(30)
#define PF0_FW_PSM_ARQLEN_PAGE_ARQENABLE_S	31
#define PF0_FW_PSM_ARQLEN_PAGE_ARQENABLE_M	BIT(31)
#define PF0_FW_PSM_ARQT_PAGE			0x02D40480 /* Reset Source: EMPR */
#define PF0_FW_PSM_ARQT_PAGE_ARQT_S		0
#define PF0_FW_PSM_ARQT_PAGE_ARQT_M		MAKEMASK(0x3FF, 0)
#define PF0_FW_PSM_ATQBAH_PAGE			0x02D40100 /* Reset Source: EMPR */
#define PF0_FW_PSM_ATQBAH_PAGE_ATQBAH_S		0
#define PF0_FW_PSM_ATQBAH_PAGE_ATQBAH_M		MAKEMASK(0xFFFFFFFF, 0)
#define PF0_FW_PSM_ATQBAL_PAGE			0x02D40000 /* Reset Source: EMPR */
#define PF0_FW_PSM_ATQBAL_PAGE_ATQBAL_LSB_S	0
#define PF0_FW_PSM_ATQBAL_PAGE_ATQBAL_LSB_M	MAKEMASK(0x3F, 0)
#define PF0_FW_PSM_ATQBAL_PAGE_ATQBAL_S		6
#define PF0_FW_PSM_ATQBAL_PAGE_ATQBAL_M		MAKEMASK(0x3FFFFFF, 6)
#define PF0_FW_PSM_ATQH_PAGE			0x02D40300 /* Reset Source: EMPR */
#define PF0_FW_PSM_ATQH_PAGE_ATQH_S		0
#define PF0_FW_PSM_ATQH_PAGE_ATQH_M		MAKEMASK(0x3FF, 0)
#define PF0_FW_PSM_ATQLEN_PAGE			0x02D40200 /* Reset Source: EMPR */
#define PF0_FW_PSM_ATQLEN_PAGE_ATQLEN_S		0
#define PF0_FW_PSM_ATQLEN_PAGE_ATQLEN_M		MAKEMASK(0x3FF, 0)
#define PF0_FW_PSM_ATQLEN_PAGE_ATQVFE_S		28
#define PF0_FW_PSM_ATQLEN_PAGE_ATQVFE_M		BIT(28)
#define PF0_FW_PSM_ATQLEN_PAGE_ATQOVFL_S	29
#define PF0_FW_PSM_ATQLEN_PAGE_ATQOVFL_M	BIT(29)
#define PF0_FW_PSM_ATQLEN_PAGE_ATQCRIT_S	30
#define PF0_FW_PSM_ATQLEN_PAGE_ATQCRIT_M	BIT(30)
#define PF0_FW_PSM_ATQLEN_PAGE_ATQENABLE_S	31
#define PF0_FW_PSM_ATQLEN_PAGE_ATQENABLE_M	BIT(31)
#define PF0_FW_PSM_ATQT_PAGE			0x02D40400 /* Reset Source: EMPR */
#define PF0_FW_PSM_ATQT_PAGE_ATQT_S		0
#define PF0_FW_PSM_ATQT_PAGE_ATQT_M		MAKEMASK(0x3FF, 0)
#define PF0_MBX_CPM_ARQBAH_PAGE			0x02D80190 /* Reset Source: CORER */
#define PF0_MBX_CPM_ARQBAH_PAGE_ARQBAH_S	0
#define PF0_MBX_CPM_ARQBAH_PAGE_ARQBAH_M	MAKEMASK(0xFFFFFFFF, 0)
#define PF0_MBX_CPM_ARQBAL_PAGE			0x02D80090 /* Reset Source: CORER */
#define PF0_MBX_CPM_ARQBAL_PAGE_ARQBAL_LSB_S	0
#define PF0_MBX_CPM_ARQBAL_PAGE_ARQBAL_LSB_M	MAKEMASK(0x3F, 0)
#define PF0_MBX_CPM_ARQBAL_PAGE_ARQBAL_S	6
#define PF0_MBX_CPM_ARQBAL_PAGE_ARQBAL_M	MAKEMASK(0x3FFFFFF, 6)
#define PF0_MBX_CPM_ARQH_PAGE			0x02D80390 /* Reset Source: CORER */
#define PF0_MBX_CPM_ARQH_PAGE_ARQH_S		0
#define PF0_MBX_CPM_ARQH_PAGE_ARQH_M		MAKEMASK(0x3FF, 0)
#define PF0_MBX_CPM_ARQLEN_PAGE			0x02D80290 /* Reset Source: PFR */
#define PF0_MBX_CPM_ARQLEN_PAGE_ARQLEN_S	0
#define PF0_MBX_CPM_ARQLEN_PAGE_ARQLEN_M	MAKEMASK(0x3FF, 0)
#define PF0_MBX_CPM_ARQLEN_PAGE_ARQVFE_S	28
#define PF0_MBX_CPM_ARQLEN_PAGE_ARQVFE_M	BIT(28)
#define PF0_MBX_CPM_ARQLEN_PAGE_ARQOVFL_S	29
#define PF0_MBX_CPM_ARQLEN_PAGE_ARQOVFL_M	BIT(29)
#define PF0_MBX_CPM_ARQLEN_PAGE_ARQCRIT_S	30
#define PF0_MBX_CPM_ARQLEN_PAGE_ARQCRIT_M	BIT(30)
#define PF0_MBX_CPM_ARQLEN_PAGE_ARQENABLE_S	31
#define PF0_MBX_CPM_ARQLEN_PAGE_ARQENABLE_M	BIT(31)
#define PF0_MBX_CPM_ARQT_PAGE			0x02D80490 /* Reset Source: CORER */
#define PF0_MBX_CPM_ARQT_PAGE_ARQT_S		0
#define PF0_MBX_CPM_ARQT_PAGE_ARQT_M		MAKEMASK(0x3FF, 0)
#define PF0_MBX_CPM_ATQBAH_PAGE			0x02D80110 /* Reset Source: CORER */
#define PF0_MBX_CPM_ATQBAH_PAGE_ATQBAH_S	0
#define PF0_MBX_CPM_ATQBAH_PAGE_ATQBAH_M	MAKEMASK(0xFFFFFFFF, 0)
#define PF0_MBX_CPM_ATQBAL_PAGE			0x02D80010 /* Reset Source: CORER */
#define PF0_MBX_CPM_ATQBAL_PAGE_ATQBAL_S	6
#define PF0_MBX_CPM_ATQBAL_PAGE_ATQBAL_M	MAKEMASK(0x3FFFFFF, 6)
#define PF0_MBX_CPM_ATQH_PAGE			0x02D80310 /* Reset Source: CORER */
#define PF0_MBX_CPM_ATQH_PAGE_ATQH_S		0
#define PF0_MBX_CPM_ATQH_PAGE_ATQH_M		MAKEMASK(0x3FF, 0)
#define PF0_MBX_CPM_ATQLEN_PAGE			0x02D80210 /* Reset Source: PFR */
#define PF0_MBX_CPM_ATQLEN_PAGE_ATQLEN_S	0
#define PF0_MBX_CPM_ATQLEN_PAGE_ATQLEN_M	MAKEMASK(0x3FF, 0)
#define PF0_MBX_CPM_ATQLEN_PAGE_ATQVFE_S	28
#define PF0_MBX_CPM_ATQLEN_PAGE_ATQVFE_M	BIT(28)
#define PF0_MBX_CPM_ATQLEN_PAGE_ATQOVFL_S	29
#define PF0_MBX_CPM_ATQLEN_PAGE_ATQOVFL_M	BIT(29)
#define PF0_MBX_CPM_ATQLEN_PAGE_ATQCRIT_S	30
#define PF0_MBX_CPM_ATQLEN_PAGE_ATQCRIT_M	BIT(30)
#define PF0_MBX_CPM_ATQLEN_PAGE_ATQENABLE_S	31
#define PF0_MBX_CPM_ATQLEN_PAGE_ATQENABLE_M	BIT(31)
#define PF0_MBX_CPM_ATQT_PAGE			0x02D80410 /* Reset Source: CORER */
#define PF0_MBX_CPM_ATQT_PAGE_ATQT_S		0
#define PF0_MBX_CPM_ATQT_PAGE_ATQT_M		MAKEMASK(0x3FF, 0)
#define PF0_MBX_HLP_ARQBAH_PAGE			0x02D00190 /* Reset Source: CORER */
#define PF0_MBX_HLP_ARQBAH_PAGE_ARQBAH_S	0
#define PF0_MBX_HLP_ARQBAH_PAGE_ARQBAH_M	MAKEMASK(0xFFFFFFFF, 0)
#define PF0_MBX_HLP_ARQBAL_PAGE			0x02D00090 /* Reset Source: CORER */
#define PF0_MBX_HLP_ARQBAL_PAGE_ARQBAL_LSB_S	0
#define PF0_MBX_HLP_ARQBAL_PAGE_ARQBAL_LSB_M	MAKEMASK(0x3F, 0)
#define PF0_MBX_HLP_ARQBAL_PAGE_ARQBAL_S	6
#define PF0_MBX_HLP_ARQBAL_PAGE_ARQBAL_M	MAKEMASK(0x3FFFFFF, 6)
#define PF0_MBX_HLP_ARQH_PAGE			0x02D00390 /* Reset Source: CORER */
#define PF0_MBX_HLP_ARQH_PAGE_ARQH_S		0
#define PF0_MBX_HLP_ARQH_PAGE_ARQH_M		MAKEMASK(0x3FF, 0)
#define PF0_MBX_HLP_ARQLEN_PAGE			0x02D00290 /* Reset Source: PFR */
#define PF0_MBX_HLP_ARQLEN_PAGE_ARQLEN_S	0
#define PF0_MBX_HLP_ARQLEN_PAGE_ARQLEN_M	MAKEMASK(0x3FF, 0)
#define PF0_MBX_HLP_ARQLEN_PAGE_ARQVFE_S	28
#define PF0_MBX_HLP_ARQLEN_PAGE_ARQVFE_M	BIT(28)
#define PF0_MBX_HLP_ARQLEN_PAGE_ARQOVFL_S	29
#define PF0_MBX_HLP_ARQLEN_PAGE_ARQOVFL_M	BIT(29)
#define PF0_MBX_HLP_ARQLEN_PAGE_ARQCRIT_S	30
#define PF0_MBX_HLP_ARQLEN_PAGE_ARQCRIT_M	BIT(30)
#define PF0_MBX_HLP_ARQLEN_PAGE_ARQENABLE_S	31
#define PF0_MBX_HLP_ARQLEN_PAGE_ARQENABLE_M	BIT(31)
#define PF0_MBX_HLP_ARQT_PAGE			0x02D00490 /* Reset Source: CORER */
#define PF0_MBX_HLP_ARQT_PAGE_ARQT_S		0
#define PF0_MBX_HLP_ARQT_PAGE_ARQT_M		MAKEMASK(0x3FF, 0)
#define PF0_MBX_HLP_ATQBAH_PAGE			0x02D00110 /* Reset Source: CORER */
#define PF0_MBX_HLP_ATQBAH_PAGE_ATQBAH_S	0
#define PF0_MBX_HLP_ATQBAH_PAGE_ATQBAH_M	MAKEMASK(0xFFFFFFFF, 0)
#define PF0_MBX_HLP_ATQBAL_PAGE			0x02D00010 /* Reset Source: CORER */
#define PF0_MBX_HLP_ATQBAL_PAGE_ATQBAL_S	6
#define PF0_MBX_HLP_ATQBAL_PAGE_ATQBAL_M	MAKEMASK(0x3FFFFFF, 6)
#define PF0_MBX_HLP_ATQH_PAGE			0x02D00310 /* Reset Source: CORER */
#define PF0_MBX_HLP_ATQH_PAGE_ATQH_S		0
#define PF0_MBX_HLP_ATQH_PAGE_ATQH_M		MAKEMASK(0x3FF, 0)
#define PF0_MBX_HLP_ATQLEN_PAGE			0x02D00210 /* Reset Source: PFR */
#define PF0_MBX_HLP_ATQLEN_PAGE_ATQLEN_S	0
#define PF0_MBX_HLP_ATQLEN_PAGE_ATQLEN_M	MAKEMASK(0x3FF, 0)
#define PF0_MBX_HLP_ATQLEN_PAGE_ATQVFE_S	28
#define PF0_MBX_HLP_ATQLEN_PAGE_ATQVFE_M	BIT(28)
#define PF0_MBX_HLP_ATQLEN_PAGE_ATQOVFL_S	29
#define PF0_MBX_HLP_ATQLEN_PAGE_ATQOVFL_M	BIT(29)
#define PF0_MBX_HLP_ATQLEN_PAGE_ATQCRIT_S	30
#define PF0_MBX_HLP_ATQLEN_PAGE_ATQCRIT_M	BIT(30)
#define PF0_MBX_HLP_ATQLEN_PAGE_ATQENABLE_S	31
#define PF0_MBX_HLP_ATQLEN_PAGE_ATQENABLE_M	BIT(31)
#define PF0_MBX_HLP_ATQT_PAGE			0x02D00410 /* Reset Source: CORER */
#define PF0_MBX_HLP_ATQT_PAGE_ATQT_S		0
#define PF0_MBX_HLP_ATQT_PAGE_ATQT_M		MAKEMASK(0x3FF, 0)
#define PF0_MBX_PSM_ARQBAH_PAGE			0x02D40190 /* Reset Source: CORER */
#define PF0_MBX_PSM_ARQBAH_PAGE_ARQBAH_S	0
#define PF0_MBX_PSM_ARQBAH_PAGE_ARQBAH_M	MAKEMASK(0xFFFFFFFF, 0)
#define PF0_MBX_PSM_ARQBAL_PAGE			0x02D40090 /* Reset Source: CORER */
#define PF0_MBX_PSM_ARQBAL_PAGE_ARQBAL_LSB_S	0
#define PF0_MBX_PSM_ARQBAL_PAGE_ARQBAL_LSB_M	MAKEMASK(0x3F, 0)
#define PF0_MBX_PSM_ARQBAL_PAGE_ARQBAL_S	6
#define PF0_MBX_PSM_ARQBAL_PAGE_ARQBAL_M	MAKEMASK(0x3FFFFFF, 6)
#define PF0_MBX_PSM_ARQH_PAGE			0x02D40390 /* Reset Source: CORER */
#define PF0_MBX_PSM_ARQH_PAGE_ARQH_S		0
#define PF0_MBX_PSM_ARQH_PAGE_ARQH_M		MAKEMASK(0x3FF, 0)
#define PF0_MBX_PSM_ARQLEN_PAGE			0x02D40290 /* Reset Source: PFR */
#define PF0_MBX_PSM_ARQLEN_PAGE_ARQLEN_S	0
#define PF0_MBX_PSM_ARQLEN_PAGE_ARQLEN_M	MAKEMASK(0x3FF, 0)
#define PF0_MBX_PSM_ARQLEN_PAGE_ARQVFE_S	28
#define PF0_MBX_PSM_ARQLEN_PAGE_ARQVFE_M	BIT(28)
#define PF0_MBX_PSM_ARQLEN_PAGE_ARQOVFL_S	29
#define PF0_MBX_PSM_ARQLEN_PAGE_ARQOVFL_M	BIT(29)
#define PF0_MBX_PSM_ARQLEN_PAGE_ARQCRIT_S	30
#define PF0_MBX_PSM_ARQLEN_PAGE_ARQCRIT_M	BIT(30)
#define PF0_MBX_PSM_ARQLEN_PAGE_ARQENABLE_S	31
#define PF0_MBX_PSM_ARQLEN_PAGE_ARQENABLE_M	BIT(31)
#define PF0_MBX_PSM_ARQT_PAGE			0x02D40490 /* Reset Source: CORER */
#define PF0_MBX_PSM_ARQT_PAGE_ARQT_S		0
#define PF0_MBX_PSM_ARQT_PAGE_ARQT_M		MAKEMASK(0x3FF, 0)
#define PF0_MBX_PSM_ATQBAH_PAGE			0x02D40110 /* Reset Source: CORER */
#define PF0_MBX_PSM_ATQBAH_PAGE_ATQBAH_S	0
#define PF0_MBX_PSM_ATQBAH_PAGE_ATQBAH_M	MAKEMASK(0xFFFFFFFF, 0)
#define PF0_MBX_PSM_ATQBAL_PAGE			0x02D40010 /* Reset Source: CORER */
#define PF0_MBX_PSM_ATQBAL_PAGE_ATQBAL_S	6
#define PF0_MBX_PSM_ATQBAL_PAGE_ATQBAL_M	MAKEMASK(0x3FFFFFF, 6)
#define PF0_MBX_PSM_ATQH_PAGE			0x02D40310 /* Reset Source: CORER */
#define PF0_MBX_PSM_ATQH_PAGE_ATQH_S		0
#define PF0_MBX_PSM_ATQH_PAGE_ATQH_M		MAKEMASK(0x3FF, 0)
#define PF0_MBX_PSM_ATQLEN_PAGE			0x02D40210 /* Reset Source: PFR */
#define PF0_MBX_PSM_ATQLEN_PAGE_ATQLEN_S	0
#define PF0_MBX_PSM_ATQLEN_PAGE_ATQLEN_M	MAKEMASK(0x3FF, 0)
#define PF0_MBX_PSM_ATQLEN_PAGE_ATQVFE_S	28
#define PF0_MBX_PSM_ATQLEN_PAGE_ATQVFE_M	BIT(28)
#define PF0_MBX_PSM_ATQLEN_PAGE_ATQOVFL_S	29
#define PF0_MBX_PSM_ATQLEN_PAGE_ATQOVFL_M	BIT(29)
#define PF0_MBX_PSM_ATQLEN_PAGE_ATQCRIT_S	30
#define PF0_MBX_PSM_ATQLEN_PAGE_ATQCRIT_M	BIT(30)
#define PF0_MBX_PSM_ATQLEN_PAGE_ATQENABLE_S	31
#define PF0_MBX_PSM_ATQLEN_PAGE_ATQENABLE_M	BIT(31)
#define PF0_MBX_PSM_ATQT_PAGE			0x02D40410 /* Reset Source: CORER */
#define PF0_MBX_PSM_ATQT_PAGE_ATQT_S		0
#define PF0_MBX_PSM_ATQT_PAGE_ATQT_M		MAKEMASK(0x3FF, 0)
#define PF0_SB_CPM_ARQBAH_PAGE			0x02D801A0 /* Reset Source: CORER */
#define PF0_SB_CPM_ARQBAH_PAGE_ARQBAH_S		0
#define PF0_SB_CPM_ARQBAH_PAGE_ARQBAH_M		MAKEMASK(0xFFFFFFFF, 0)
#define PF0_SB_CPM_ARQBAL_PAGE			0x02D800A0 /* Reset Source: CORER */
#define PF0_SB_CPM_ARQBAL_PAGE_ARQBAL_LSB_S	0
#define PF0_SB_CPM_ARQBAL_PAGE_ARQBAL_LSB_M	MAKEMASK(0x3F, 0)
#define PF0_SB_CPM_ARQBAL_PAGE_ARQBAL_S		6
#define PF0_SB_CPM_ARQBAL_PAGE_ARQBAL_M		MAKEMASK(0x3FFFFFF, 6)
#define PF0_SB_CPM_ARQH_PAGE			0x02D803A0 /* Reset Source: CORER */
#define PF0_SB_CPM_ARQH_PAGE_ARQH_S		0
#define PF0_SB_CPM_ARQH_PAGE_ARQH_M		MAKEMASK(0x3FF, 0)
#define PF0_SB_CPM_ARQLEN_PAGE			0x02D802A0 /* Reset Source: PFR */
#define PF0_SB_CPM_ARQLEN_PAGE_ARQLEN_S		0
#define PF0_SB_CPM_ARQLEN_PAGE_ARQLEN_M		MAKEMASK(0x3FF, 0)
#define PF0_SB_CPM_ARQLEN_PAGE_ARQVFE_S		28
#define PF0_SB_CPM_ARQLEN_PAGE_ARQVFE_M		BIT(28)
#define PF0_SB_CPM_ARQLEN_PAGE_ARQOVFL_S	29
#define PF0_SB_CPM_ARQLEN_PAGE_ARQOVFL_M	BIT(29)
#define PF0_SB_CPM_ARQLEN_PAGE_ARQCRIT_S	30
#define PF0_SB_CPM_ARQLEN_PAGE_ARQCRIT_M	BIT(30)
#define PF0_SB_CPM_ARQLEN_PAGE_ARQENABLE_S	31
#define PF0_SB_CPM_ARQLEN_PAGE_ARQENABLE_M	BIT(31)
#define PF0_SB_CPM_ARQT_PAGE			0x02D804A0 /* Reset Source: CORER */
#define PF0_SB_CPM_ARQT_PAGE_ARQT_S		0
#define PF0_SB_CPM_ARQT_PAGE_ARQT_M		MAKEMASK(0x3FF, 0)
#define PF0_SB_CPM_ATQBAH_PAGE			0x02D80120 /* Reset Source: CORER */
#define PF0_SB_CPM_ATQBAH_PAGE_ATQBAH_S		0
#define PF0_SB_CPM_ATQBAH_PAGE_ATQBAH_M		MAKEMASK(0xFFFFFFFF, 0)
#define PF0_SB_CPM_ATQBAL_PAGE			0x02D80020 /* Reset Source: CORER */
#define PF0_SB_CPM_ATQBAL_PAGE_ATQBAL_S		6
#define PF0_SB_CPM_ATQBAL_PAGE_ATQBAL_M		MAKEMASK(0x3FFFFFF, 6)
#define PF0_SB_CPM_ATQH_PAGE			0x02D80320 /* Reset Source: CORER */
#define PF0_SB_CPM_ATQH_PAGE_ATQH_S		0
#define PF0_SB_CPM_ATQH_PAGE_ATQH_M		MAKEMASK(0x3FF, 0)
#define PF0_SB_CPM_ATQLEN_PAGE			0x02D80220 /* Reset Source: PFR */
#define PF0_SB_CPM_ATQLEN_PAGE_ATQLEN_S		0
#define PF0_SB_CPM_ATQLEN_PAGE_ATQLEN_M		MAKEMASK(0x3FF, 0)
#define PF0_SB_CPM_ATQLEN_PAGE_ATQVFE_S		28
#define PF0_SB_CPM_ATQLEN_PAGE_ATQVFE_M		BIT(28)
#define PF0_SB_CPM_ATQLEN_PAGE_ATQOVFL_S	29
#define PF0_SB_CPM_ATQLEN_PAGE_ATQOVFL_M	BIT(29)
#define PF0_SB_CPM_ATQLEN_PAGE_ATQCRIT_S	30
#define PF0_SB_CPM_ATQLEN_PAGE_ATQCRIT_M	BIT(30)
#define PF0_SB_CPM_ATQLEN_PAGE_ATQENABLE_S	31
#define PF0_SB_CPM_ATQLEN_PAGE_ATQENABLE_M	BIT(31)
#define PF0_SB_CPM_ATQT_PAGE			0x02D80420 /* Reset Source: CORER */
#define PF0_SB_CPM_ATQT_PAGE_ATQT_S		0
#define PF0_SB_CPM_ATQT_PAGE_ATQT_M		MAKEMASK(0x3FF, 0)
#define PF0_SB_HLP_ARQBAH_PAGE			0x02D001A0 /* Reset Source: CORER */
#define PF0_SB_HLP_ARQBAH_PAGE_ARQBAH_S		0
#define PF0_SB_HLP_ARQBAH_PAGE_ARQBAH_M		MAKEMASK(0xFFFFFFFF, 0)
#define PF0_SB_HLP_ARQBAL_PAGE			0x02D000A0 /* Reset Source: CORER */
#define PF0_SB_HLP_ARQBAL_PAGE_ARQBAL_LSB_S	0
#define PF0_SB_HLP_ARQBAL_PAGE_ARQBAL_LSB_M	MAKEMASK(0x3F, 0)
#define PF0_SB_HLP_ARQBAL_PAGE_ARQBAL_S		6
#define PF0_SB_HLP_ARQBAL_PAGE_ARQBAL_M		MAKEMASK(0x3FFFFFF, 6)
#define PF0_SB_HLP_ARQH_PAGE			0x02D003A0 /* Reset Source: CORER */
#define PF0_SB_HLP_ARQH_PAGE_ARQH_S		0
#define PF0_SB_HLP_ARQH_PAGE_ARQH_M		MAKEMASK(0x3FF, 0)
#define PF0_SB_HLP_ARQLEN_PAGE			0x02D002A0 /* Reset Source: PFR */
#define PF0_SB_HLP_ARQLEN_PAGE_ARQLEN_S		0
#define PF0_SB_HLP_ARQLEN_PAGE_ARQLEN_M		MAKEMASK(0x3FF, 0)
#define PF0_SB_HLP_ARQLEN_PAGE_ARQVFE_S		28
#define PF0_SB_HLP_ARQLEN_PAGE_ARQVFE_M		BIT(28)
#define PF0_SB_HLP_ARQLEN_PAGE_ARQOVFL_S	29
#define PF0_SB_HLP_ARQLEN_PAGE_ARQOVFL_M	BIT(29)
#define PF0_SB_HLP_ARQLEN_PAGE_ARQCRIT_S	30
#define PF0_SB_HLP_ARQLEN_PAGE_ARQCRIT_M	BIT(30)
#define PF0_SB_HLP_ARQLEN_PAGE_ARQENABLE_S	31
#define PF0_SB_HLP_ARQLEN_PAGE_ARQENABLE_M	BIT(31)
#define PF0_SB_HLP_ARQT_PAGE			0x02D004A0 /* Reset Source: CORER */
#define PF0_SB_HLP_ARQT_PAGE_ARQT_S		0
#define PF0_SB_HLP_ARQT_PAGE_ARQT_M		MAKEMASK(0x3FF, 0)
#define PF0_SB_HLP_ATQBAH_PAGE			0x02D00120 /* Reset Source: CORER */
#define PF0_SB_HLP_ATQBAH_PAGE_ATQBAH_S		0
#define PF0_SB_HLP_ATQBAH_PAGE_ATQBAH_M		MAKEMASK(0xFFFFFFFF, 0)
#define PF0_SB_HLP_ATQBAL_PAGE			0x02D00020 /* Reset Source: CORER */
#define PF0_SB_HLP_ATQBAL_PAGE_ATQBAL_S		6
#define PF0_SB_HLP_ATQBAL_PAGE_ATQBAL_M		MAKEMASK(0x3FFFFFF, 6)
#define PF0_SB_HLP_ATQH_PAGE			0x02D00320 /* Reset Source: CORER */
#define PF0_SB_HLP_ATQH_PAGE_ATQH_S		0
#define PF0_SB_HLP_ATQH_PAGE_ATQH_M		MAKEMASK(0x3FF, 0)
#define PF0_SB_HLP_ATQLEN_PAGE			0x02D00220 /* Reset Source: PFR */
#define PF0_SB_HLP_ATQLEN_PAGE_ATQLEN_S		0
#define PF0_SB_HLP_ATQLEN_PAGE_ATQLEN_M		MAKEMASK(0x3FF, 0)
#define PF0_SB_HLP_ATQLEN_PAGE_ATQVFE_S		28
#define PF0_SB_HLP_ATQLEN_PAGE_ATQVFE_M		BIT(28)
#define PF0_SB_HLP_ATQLEN_PAGE_ATQOVFL_S	29
#define PF0_SB_HLP_ATQLEN_PAGE_ATQOVFL_M	BIT(29)
#define PF0_SB_HLP_ATQLEN_PAGE_ATQCRIT_S	30
#define PF0_SB_HLP_ATQLEN_PAGE_ATQCRIT_M	BIT(30)
#define PF0_SB_HLP_ATQLEN_PAGE_ATQENABLE_S	31
#define PF0_SB_HLP_ATQLEN_PAGE_ATQENABLE_M	BIT(31)
#define PF0_SB_HLP_ATQT_PAGE			0x02D00420 /* Reset Source: CORER */
#define PF0_SB_HLP_ATQT_PAGE_ATQT_S		0
#define PF0_SB_HLP_ATQT_PAGE_ATQT_M		MAKEMASK(0x3FF, 0)
#define PF0INT_DYN_CTL(_i)			(0x03000000 + ((_i) * 4096)) /* _i=0...2047 */ /* Reset Source: CORER */
#define PF0INT_DYN_CTL_MAX_INDEX		2047
#define PF0INT_DYN_CTL_INTENA_S			0
#define PF0INT_DYN_CTL_INTENA_M			BIT(0)
#define PF0INT_DYN_CTL_CLEARPBA_S		1
#define PF0INT_DYN_CTL_CLEARPBA_M		BIT(1)
#define PF0INT_DYN_CTL_SWINT_TRIG_S		2
#define PF0INT_DYN_CTL_SWINT_TRIG_M		BIT(2)
#define PF0INT_DYN_CTL_ITR_INDX_S		3
#define PF0INT_DYN_CTL_ITR_INDX_M		MAKEMASK(0x3, 3)
#define PF0INT_DYN_CTL_INTERVAL_S		5
#define PF0INT_DYN_CTL_INTERVAL_M		MAKEMASK(0xFFF, 5)
#define PF0INT_DYN_CTL_SW_ITR_INDX_ENA_S	24
#define PF0INT_DYN_CTL_SW_ITR_INDX_ENA_M	BIT(24)
#define PF0INT_DYN_CTL_SW_ITR_INDX_S		25
#define PF0INT_DYN_CTL_SW_ITR_INDX_M		MAKEMASK(0x3, 25)
#define PF0INT_DYN_CTL_WB_ON_ITR_S		30
#define PF0INT_DYN_CTL_WB_ON_ITR_M		BIT(30)
#define PF0INT_DYN_CTL_INTENA_MSK_S		31
#define PF0INT_DYN_CTL_INTENA_MSK_M		BIT(31)
#define PF0INT_ITR_0(_i)			(0x03000004 + ((_i) * 4096)) /* _i=0...2047 */ /* Reset Source: CORER */
#define PF0INT_ITR_0_MAX_INDEX			2047
#define PF0INT_ITR_0_INTERVAL_S			0
#define PF0INT_ITR_0_INTERVAL_M			MAKEMASK(0xFFF, 0)
#define PF0INT_ITR_1(_i)			(0x03000008 + ((_i) * 4096)) /* _i=0...2047 */ /* Reset Source: CORER */
#define PF0INT_ITR_1_MAX_INDEX			2047
#define PF0INT_ITR_1_INTERVAL_S			0
#define PF0INT_ITR_1_INTERVAL_M			MAKEMASK(0xFFF, 0)
#define PF0INT_ITR_2(_i)			(0x0300000C + ((_i) * 4096)) /* _i=0...2047 */ /* Reset Source: CORER */
#define PF0INT_ITR_2_MAX_INDEX			2047
#define PF0INT_ITR_2_INTERVAL_S			0
#define PF0INT_ITR_2_INTERVAL_M			MAKEMASK(0xFFF, 0)
#define PF0INT_OICR_CPM_PAGE			0x02D03000 /* Reset Source: CORER */
#define PF0INT_OICR_CPM_PAGE_INTEVENT_S		0
#define PF0INT_OICR_CPM_PAGE_INTEVENT_M		BIT(0)
#define PF0INT_OICR_CPM_PAGE_QUEUE_S		1
#define PF0INT_OICR_CPM_PAGE_QUEUE_M		BIT(1)
#define PF0INT_OICR_CPM_PAGE_RSV1_S		2
#define PF0INT_OICR_CPM_PAGE_RSV1_M		MAKEMASK(0xFF, 2)
#define PF0INT_OICR_CPM_PAGE_HH_COMP_S		10
#define PF0INT_OICR_CPM_PAGE_HH_COMP_M		BIT(10)
#define PF0INT_OICR_CPM_PAGE_TSYN_TX_S		11
#define PF0INT_OICR_CPM_PAGE_TSYN_TX_M		BIT(11)
#define PF0INT_OICR_CPM_PAGE_TSYN_EVNT_S	12
#define PF0INT_OICR_CPM_PAGE_TSYN_EVNT_M	BIT(12)
#define PF0INT_OICR_CPM_PAGE_TSYN_TGT_S		13
#define PF0INT_OICR_CPM_PAGE_TSYN_TGT_M		BIT(13)
#define PF0INT_OICR_CPM_PAGE_HLP_RDY_S		14
#define PF0INT_OICR_CPM_PAGE_HLP_RDY_M		BIT(14)
#define PF0INT_OICR_CPM_PAGE_CPM_RDY_S		15
#define PF0INT_OICR_CPM_PAGE_CPM_RDY_M		BIT(15)
#define PF0INT_OICR_CPM_PAGE_ECC_ERR_S		16
#define PF0INT_OICR_CPM_PAGE_ECC_ERR_M		BIT(16)
#define PF0INT_OICR_CPM_PAGE_RSV2_S		17
#define PF0INT_OICR_CPM_PAGE_RSV2_M		MAKEMASK(0x3, 17)
#define PF0INT_OICR_CPM_PAGE_MAL_DETECT_S	19
#define PF0INT_OICR_CPM_PAGE_MAL_DETECT_M	BIT(19)
#define PF0INT_OICR_CPM_PAGE_GRST_S		20
#define PF0INT_OICR_CPM_PAGE_GRST_M		BIT(20)
#define PF0INT_OICR_CPM_PAGE_PCI_EXCEPTION_S	21
#define PF0INT_OICR_CPM_PAGE_PCI_EXCEPTION_M	BIT(21)
#define PF0INT_OICR_CPM_PAGE_GPIO_S		22
#define PF0INT_OICR_CPM_PAGE_GPIO_M		BIT(22)
#define PF0INT_OICR_CPM_PAGE_RSV3_S		23
#define PF0INT_OICR_CPM_PAGE_RSV3_M		BIT(23)
#define PF0INT_OICR_CPM_PAGE_STORM_DETECT_S	24
#define PF0INT_OICR_CPM_PAGE_STORM_DETECT_M	BIT(24)
#define PF0INT_OICR_CPM_PAGE_LINK_STAT_CHANGE_S 25
#define PF0INT_OICR_CPM_PAGE_LINK_STAT_CHANGE_M BIT(25)
#define PF0INT_OICR_CPM_PAGE_HMC_ERR_S		26
#define PF0INT_OICR_CPM_PAGE_HMC_ERR_M		BIT(26)
#define PF0INT_OICR_CPM_PAGE_PE_PUSH_S		27
#define PF0INT_OICR_CPM_PAGE_PE_PUSH_M		BIT(27)
#define PF0INT_OICR_CPM_PAGE_PE_CRITERR_S	28
#define PF0INT_OICR_CPM_PAGE_PE_CRITERR_M	BIT(28)
#define PF0INT_OICR_CPM_PAGE_VFLR_S		29
#define PF0INT_OICR_CPM_PAGE_VFLR_M		BIT(29)
#define PF0INT_OICR_CPM_PAGE_XLR_HW_DONE_S	30
#define PF0INT_OICR_CPM_PAGE_XLR_HW_DONE_M	BIT(30)
#define PF0INT_OICR_CPM_PAGE_SWINT_S		31
#define PF0INT_OICR_CPM_PAGE_SWINT_M		BIT(31)
#define PF0INT_OICR_ENA_CPM_PAGE		0x02D03100 /* Reset Source: CORER */
#define PF0INT_OICR_ENA_CPM_PAGE_RSV0_S		0
#define PF0INT_OICR_ENA_CPM_PAGE_RSV0_M		BIT(0)
#define PF0INT_OICR_ENA_CPM_PAGE_INT_ENA_S	1
#define PF0INT_OICR_ENA_CPM_PAGE_INT_ENA_M	MAKEMASK(0x7FFFFFFF, 1)
#define PF0INT_OICR_ENA_HLP_PAGE		0x02D01100 /* Reset Source: CORER */
#define PF0INT_OICR_ENA_HLP_PAGE_RSV0_S		0
#define PF0INT_OICR_ENA_HLP_PAGE_RSV0_M		BIT(0)
#define PF0INT_OICR_ENA_HLP_PAGE_INT_ENA_S	1
#define PF0INT_OICR_ENA_HLP_PAGE_INT_ENA_M	MAKEMASK(0x7FFFFFFF, 1)
#define PF0INT_OICR_ENA_PSM_PAGE		0x02D02100 /* Reset Source: CORER */
#define PF0INT_OICR_ENA_PSM_PAGE_RSV0_S		0
#define PF0INT_OICR_ENA_PSM_PAGE_RSV0_M		BIT(0)
#define PF0INT_OICR_ENA_PSM_PAGE_INT_ENA_S	1
#define PF0INT_OICR_ENA_PSM_PAGE_INT_ENA_M	MAKEMASK(0x7FFFFFFF, 1)
#define PF0INT_OICR_HLP_PAGE			0x02D01000 /* Reset Source: CORER */
#define PF0INT_OICR_HLP_PAGE_INTEVENT_S		0
#define PF0INT_OICR_HLP_PAGE_INTEVENT_M		BIT(0)
#define PF0INT_OICR_HLP_PAGE_QUEUE_S		1
#define PF0INT_OICR_HLP_PAGE_QUEUE_M		BIT(1)
#define PF0INT_OICR_HLP_PAGE_RSV1_S		2
#define PF0INT_OICR_HLP_PAGE_RSV1_M		MAKEMASK(0xFF, 2)
#define PF0INT_OICR_HLP_PAGE_HH_COMP_S		10
#define PF0INT_OICR_HLP_PAGE_HH_COMP_M		BIT(10)
#define PF0INT_OICR_HLP_PAGE_TSYN_TX_S		11
#define PF0INT_OICR_HLP_PAGE_TSYN_TX_M		BIT(11)
#define PF0INT_OICR_HLP_PAGE_TSYN_EVNT_S	12
#define PF0INT_OICR_HLP_PAGE_TSYN_EVNT_M	BIT(12)
#define PF0INT_OICR_HLP_PAGE_TSYN_TGT_S		13
#define PF0INT_OICR_HLP_PAGE_TSYN_TGT_M		BIT(13)
#define PF0INT_OICR_HLP_PAGE_HLP_RDY_S		14
#define PF0INT_OICR_HLP_PAGE_HLP_RDY_M		BIT(14)
#define PF0INT_OICR_HLP_PAGE_CPM_RDY_S		15
#define PF0INT_OICR_HLP_PAGE_CPM_RDY_M		BIT(15)
#define PF0INT_OICR_HLP_PAGE_ECC_ERR_S		16
#define PF0INT_OICR_HLP_PAGE_ECC_ERR_M		BIT(16)
#define PF0INT_OICR_HLP_PAGE_RSV2_S		17
#define PF0INT_OICR_HLP_PAGE_RSV2_M		MAKEMASK(0x3, 17)
#define PF0INT_OICR_HLP_PAGE_MAL_DETECT_S	19
#define PF0INT_OICR_HLP_PAGE_MAL_DETECT_M	BIT(19)
#define PF0INT_OICR_HLP_PAGE_GRST_S		20
#define PF0INT_OICR_HLP_PAGE_GRST_M		BIT(20)
#define PF0INT_OICR_HLP_PAGE_PCI_EXCEPTION_S	21
#define PF0INT_OICR_HLP_PAGE_PCI_EXCEPTION_M	BIT(21)
#define PF0INT_OICR_HLP_PAGE_GPIO_S		22
#define PF0INT_OICR_HLP_PAGE_GPIO_M		BIT(22)
#define PF0INT_OICR_HLP_PAGE_RSV3_S		23
#define PF0INT_OICR_HLP_PAGE_RSV3_M		BIT(23)
#define PF0INT_OICR_HLP_PAGE_STORM_DETECT_S	24
#define PF0INT_OICR_HLP_PAGE_STORM_DETECT_M	BIT(24)
#define PF0INT_OICR_HLP_PAGE_LINK_STAT_CHANGE_S 25
#define PF0INT_OICR_HLP_PAGE_LINK_STAT_CHANGE_M BIT(25)
#define PF0INT_OICR_HLP_PAGE_HMC_ERR_S		26
#define PF0INT_OICR_HLP_PAGE_HMC_ERR_M		BIT(26)
#define PF0INT_OICR_HLP_PAGE_PE_PUSH_S		27
#define PF0INT_OICR_HLP_PAGE_PE_PUSH_M		BIT(27)
#define PF0INT_OICR_HLP_PAGE_PE_CRITERR_S	28
#define PF0INT_OICR_HLP_PAGE_PE_CRITERR_M	BIT(28)
#define PF0INT_OICR_HLP_PAGE_VFLR_S		29
#define PF0INT_OICR_HLP_PAGE_VFLR_M		BIT(29)
#define PF0INT_OICR_HLP_PAGE_XLR_HW_DONE_S	30
#define PF0INT_OICR_HLP_PAGE_XLR_HW_DONE_M	BIT(30)
#define PF0INT_OICR_HLP_PAGE_SWINT_S		31
#define PF0INT_OICR_HLP_PAGE_SWINT_M		BIT(31)
#define PF0INT_OICR_PSM_PAGE			0x02D02000 /* Reset Source: CORER */
#define PF0INT_OICR_PSM_PAGE_INTEVENT_S		0
#define PF0INT_OICR_PSM_PAGE_INTEVENT_M		BIT(0)
#define PF0INT_OICR_PSM_PAGE_QUEUE_S		1
#define PF0INT_OICR_PSM_PAGE_QUEUE_M		BIT(1)
#define PF0INT_OICR_PSM_PAGE_RSV1_S		2
#define PF0INT_OICR_PSM_PAGE_RSV1_M		MAKEMASK(0xFF, 2)
#define PF0INT_OICR_PSM_PAGE_HH_COMP_S		10
#define PF0INT_OICR_PSM_PAGE_HH_COMP_M		BIT(10)
#define PF0INT_OICR_PSM_PAGE_TSYN_TX_S		11
#define PF0INT_OICR_PSM_PAGE_TSYN_TX_M		BIT(11)
#define PF0INT_OICR_PSM_PAGE_TSYN_EVNT_S	12
#define PF0INT_OICR_PSM_PAGE_TSYN_EVNT_M	BIT(12)
#define PF0INT_OICR_PSM_PAGE_TSYN_TGT_S		13
#define PF0INT_OICR_PSM_PAGE_TSYN_TGT_M		BIT(13)
#define PF0INT_OICR_PSM_PAGE_HLP_RDY_S		14
#define PF0INT_OICR_PSM_PAGE_HLP_RDY_M		BIT(14)
#define PF0INT_OICR_PSM_PAGE_CPM_RDY_S		15
#define PF0INT_OICR_PSM_PAGE_CPM_RDY_M		BIT(15)
#define PF0INT_OICR_PSM_PAGE_ECC_ERR_S		16
#define PF0INT_OICR_PSM_PAGE_ECC_ERR_M		BIT(16)
#define PF0INT_OICR_PSM_PAGE_RSV2_S		17
#define PF0INT_OICR_PSM_PAGE_RSV2_M		MAKEMASK(0x3, 17)
#define PF0INT_OICR_PSM_PAGE_MAL_DETECT_S	19
#define PF0INT_OICR_PSM_PAGE_MAL_DETECT_M	BIT(19)
#define PF0INT_OICR_PSM_PAGE_GRST_S		20
#define PF0INT_OICR_PSM_PAGE_GRST_M		BIT(20)
#define PF0INT_OICR_PSM_PAGE_PCI_EXCEPTION_S	21
#define PF0INT_OICR_PSM_PAGE_PCI_EXCEPTION_M	BIT(21)
#define PF0INT_OICR_PSM_PAGE_GPIO_S		22
#define PF0INT_OICR_PSM_PAGE_GPIO_M		BIT(22)
#define PF0INT_OICR_PSM_PAGE_RSV3_S		23
#define PF0INT_OICR_PSM_PAGE_RSV3_M		BIT(23)
#define PF0INT_OICR_PSM_PAGE_STORM_DETECT_S	24
#define PF0INT_OICR_PSM_PAGE_STORM_DETECT_M	BIT(24)
#define PF0INT_OICR_PSM_PAGE_LINK_STAT_CHANGE_S 25
#define PF0INT_OICR_PSM_PAGE_LINK_STAT_CHANGE_M BIT(25)
#define PF0INT_OICR_PSM_PAGE_HMC_ERR_S		26
#define PF0INT_OICR_PSM_PAGE_HMC_ERR_M		BIT(26)
#define PF0INT_OICR_PSM_PAGE_PE_PUSH_S		27
#define PF0INT_OICR_PSM_PAGE_PE_PUSH_M		BIT(27)
#define PF0INT_OICR_PSM_PAGE_PE_CRITERR_S	28
#define PF0INT_OICR_PSM_PAGE_PE_CRITERR_M	BIT(28)
#define PF0INT_OICR_PSM_PAGE_VFLR_S		29
#define PF0INT_OICR_PSM_PAGE_VFLR_M		BIT(29)
#define PF0INT_OICR_PSM_PAGE_XLR_HW_DONE_S	30
#define PF0INT_OICR_PSM_PAGE_XLR_HW_DONE_M	BIT(30)
#define PF0INT_OICR_PSM_PAGE_SWINT_S		31
#define PF0INT_OICR_PSM_PAGE_SWINT_M		BIT(31)
#define QRX_TAIL_PAGE(_QRX)			(0x03800000 + ((_QRX) * 4096)) /* _i=0...2047 */ /* Reset Source: CORER */
#define QRX_TAIL_PAGE_MAX_INDEX			2047
#define QRX_TAIL_PAGE_TAIL_S			0
#define QRX_TAIL_PAGE_TAIL_M			MAKEMASK(0x1FFF, 0)
#define QTX_COMM_DBELL_PAGE(_DBQM)		(0x04000000 + ((_DBQM) * 4096)) /* _i=0...16383 */ /* Reset Source: CORER */
#define QTX_COMM_DBELL_PAGE_MAX_INDEX		16383
#define QTX_COMM_DBELL_PAGE_QTX_COMM_DBELL_S	0
#define QTX_COMM_DBELL_PAGE_QTX_COMM_DBELL_M	MAKEMASK(0xFFFFFFFF, 0)
#define QTX_COMM_DBLQ_DBELL_PAGE(_DBLQ)		(0x02F00000 + ((_DBLQ) * 4096)) /* _i=0...255 */ /* Reset Source: CORER */
#define QTX_COMM_DBLQ_DBELL_PAGE_MAX_INDEX	255
#define QTX_COMM_DBLQ_DBELL_PAGE_TAIL_S		0
#define QTX_COMM_DBLQ_DBELL_PAGE_TAIL_M		MAKEMASK(0x1FFF, 0)
#define VSI_MBX_ARQBAH(_VSI)			(0x02000018 + ((_VSI) * 4096)) /* _i=0...767 */ /* Reset Source: CORER */
#define VSI_MBX_ARQBAH_MAX_INDEX		767
#define VSI_MBX_ARQBAH_ARQBAH_S			0
#define VSI_MBX_ARQBAH_ARQBAH_M			MAKEMASK(0xFFFFFFFF, 0)
#define VSI_MBX_ARQBAL(_VSI)			(0x02000014 + ((_VSI) * 4096)) /* _i=0...767 */ /* Reset Source: CORER */
#define VSI_MBX_ARQBAL_MAX_INDEX		767
#define VSI_MBX_ARQBAL_ARQBAL_LSB_S		0
#define VSI_MBX_ARQBAL_ARQBAL_LSB_M		MAKEMASK(0x3F, 0)
#define VSI_MBX_ARQBAL_ARQBAL_S			6
#define VSI_MBX_ARQBAL_ARQBAL_M			MAKEMASK(0x3FFFFFF, 6)
#define VSI_MBX_ARQH(_VSI)			(0x02000020 + ((_VSI) * 4096)) /* _i=0...767 */ /* Reset Source: CORER */
#define VSI_MBX_ARQH_MAX_INDEX			767
#define VSI_MBX_ARQH_ARQH_S			0
#define VSI_MBX_ARQH_ARQH_M			MAKEMASK(0x3FF, 0)
#define VSI_MBX_ARQLEN(_VSI)			(0x0200001C + ((_VSI) * 4096)) /* _i=0...767 */ /* Reset Source: PFR */
#define VSI_MBX_ARQLEN_MAX_INDEX		767
#define VSI_MBX_ARQLEN_ARQLEN_S			0
#define VSI_MBX_ARQLEN_ARQLEN_M			MAKEMASK(0x3FF, 0)
#define VSI_MBX_ARQLEN_ARQVFE_S			28
#define VSI_MBX_ARQLEN_ARQVFE_M			BIT(28)
#define VSI_MBX_ARQLEN_ARQOVFL_S		29
#define VSI_MBX_ARQLEN_ARQOVFL_M		BIT(29)
#define VSI_MBX_ARQLEN_ARQCRIT_S		30
#define VSI_MBX_ARQLEN_ARQCRIT_M		BIT(30)
#define VSI_MBX_ARQLEN_ARQENABLE_S		31
#define VSI_MBX_ARQLEN_ARQENABLE_M		BIT(31)
#define VSI_MBX_ARQT(_VSI)			(0x02000024 + ((_VSI) * 4096)) /* _i=0...767 */ /* Reset Source: CORER */
#define VSI_MBX_ARQT_MAX_INDEX			767
#define VSI_MBX_ARQT_ARQT_S			0
#define VSI_MBX_ARQT_ARQT_M			MAKEMASK(0x3FF, 0)
#define VSI_MBX_ATQBAH(_VSI)			(0x02000004 + ((_VSI) * 4096)) /* _i=0...767 */ /* Reset Source: CORER */
#define VSI_MBX_ATQBAH_MAX_INDEX		767
#define VSI_MBX_ATQBAH_ATQBAH_S			0
#define VSI_MBX_ATQBAH_ATQBAH_M			MAKEMASK(0xFFFFFFFF, 0)
#define VSI_MBX_ATQBAL(_VSI)			(0x02000000 + ((_VSI) * 4096)) /* _i=0...767 */ /* Reset Source: CORER */
#define VSI_MBX_ATQBAL_MAX_INDEX		767
#define VSI_MBX_ATQBAL_ATQBAL_S			6
#define VSI_MBX_ATQBAL_ATQBAL_M			MAKEMASK(0x3FFFFFF, 6)
#define VSI_MBX_ATQH(_VSI)			(0x0200000C + ((_VSI) * 4096)) /* _i=0...767 */ /* Reset Source: CORER */
#define VSI_MBX_ATQH_MAX_INDEX			767
#define VSI_MBX_ATQH_ATQH_S			0
#define VSI_MBX_ATQH_ATQH_M			MAKEMASK(0x3FF, 0)
#define VSI_MBX_ATQLEN(_VSI)			(0x02000008 + ((_VSI) * 4096)) /* _i=0...767 */ /* Reset Source: PFR */
#define VSI_MBX_ATQLEN_MAX_INDEX		767
#define VSI_MBX_ATQLEN_ATQLEN_S			0
#define VSI_MBX_ATQLEN_ATQLEN_M			MAKEMASK(0x3FF, 0)
#define VSI_MBX_ATQLEN_ATQVFE_S			28
#define VSI_MBX_ATQLEN_ATQVFE_M			BIT(28)
#define VSI_MBX_ATQLEN_ATQOVFL_S		29
#define VSI_MBX_ATQLEN_ATQOVFL_M		BIT(29)
#define VSI_MBX_ATQLEN_ATQCRIT_S		30
#define VSI_MBX_ATQLEN_ATQCRIT_M		BIT(30)
#define VSI_MBX_ATQLEN_ATQENABLE_S		31
#define VSI_MBX_ATQLEN_ATQENABLE_M		BIT(31)
#define VSI_MBX_ATQT(_VSI)			(0x02000010 + ((_VSI) * 4096)) /* _i=0...767 */ /* Reset Source: CORER */
#define VSI_MBX_ATQT_MAX_INDEX			767
#define VSI_MBX_ATQT_ATQT_S			0
#define VSI_MBX_ATQT_ATQT_M			MAKEMASK(0x3FF, 0)
#define GL_ACL_ACCESS_CMD			0x00391000 /* Reset Source: CORER */
#define GL_ACL_ACCESS_CMD_TABLE_ID_S		0
#define GL_ACL_ACCESS_CMD_TABLE_ID_M		MAKEMASK(0xFF, 0)
#define GL_ACL_ACCESS_CMD_ENTRY_INDEX_S		8
#define GL_ACL_ACCESS_CMD_ENTRY_INDEX_M		MAKEMASK(0xFFF, 8)
#define GL_ACL_ACCESS_CMD_OPERATION_S		20
#define GL_ACL_ACCESS_CMD_OPERATION_M		BIT(20)
#define GL_ACL_ACCESS_CMD_OBJ_TYPE_S		24
#define GL_ACL_ACCESS_CMD_OBJ_TYPE_M		MAKEMASK(0xF, 24)
#define GL_ACL_ACCESS_CMD_EXECUTE_S		31
#define GL_ACL_ACCESS_CMD_EXECUTE_M		BIT(31)
#define GL_ACL_ACCESS_STATUS			0x00391004 /* Reset Source: CORER */
#define GL_ACL_ACCESS_STATUS_BUSY_S		0
#define GL_ACL_ACCESS_STATUS_BUSY_M		BIT(0)
#define GL_ACL_ACCESS_STATUS_DONE_S		1
#define GL_ACL_ACCESS_STATUS_DONE_M		BIT(1)
#define GL_ACL_ACCESS_STATUS_ERROR_S		2
#define GL_ACL_ACCESS_STATUS_ERROR_M		BIT(2)
#define GL_ACL_ACCESS_STATUS_OPERATION_S	3
#define GL_ACL_ACCESS_STATUS_OPERATION_M	BIT(3)
#define GL_ACL_ACCESS_STATUS_ERROR_CODE_S	4
#define GL_ACL_ACCESS_STATUS_ERROR_CODE_M	MAKEMASK(0xF, 4)
#define GL_ACL_ACCESS_STATUS_TABLE_ID_S		8
#define GL_ACL_ACCESS_STATUS_TABLE_ID_M		MAKEMASK(0xFF, 8)
#define GL_ACL_ACCESS_STATUS_ENTRY_INDEX_S	16
#define GL_ACL_ACCESS_STATUS_ENTRY_INDEX_M	MAKEMASK(0xFFF, 16)
#define GL_ACL_ACCESS_STATUS_OBJ_TYPE_S		28
#define GL_ACL_ACCESS_STATUS_OBJ_TYPE_M		MAKEMASK(0xF, 28)
#define GL_ACL_ACTMEM_ACT(_i)			(0x00393824 + ((_i) * 4)) /* _i=0...1 */ /* Reset Source: CORER */
#define GL_ACL_ACTMEM_ACT_MAX_INDEX		1
#define GL_ACL_ACTMEM_ACT_VALUE_S		0
#define GL_ACL_ACTMEM_ACT_VALUE_M		MAKEMASK(0xFFFF, 0)
#define GL_ACL_ACTMEM_ACT_MDID_S		20
#define GL_ACL_ACTMEM_ACT_MDID_M		MAKEMASK(0x3F, 20)
#define GL_ACL_ACTMEM_ACT_PRIORITY_S		28
#define GL_ACL_ACTMEM_ACT_PRIORITY_M		MAKEMASK(0x7, 28)
#define GL_ACL_CHICKEN_REGISTER			0x00393810 /* Reset Source: CORER */
#define GL_ACL_CHICKEN_REGISTER_TCAM_DATA_POL_CH_S 0
#define GL_ACL_CHICKEN_REGISTER_TCAM_DATA_POL_CH_M BIT(0)
#define GL_ACL_CHICKEN_REGISTER_TCAM_ADDR_POL_CH_S 1
#define GL_ACL_CHICKEN_REGISTER_TCAM_ADDR_POL_CH_M BIT(1)
#define GL_ACL_DEFAULT_ACT(_i)			(0x00391168 + ((_i) * 4)) /* _i=0...15 */ /* Reset Source: CORER */
#define GL_ACL_DEFAULT_ACT_MAX_INDEX		15
#define GL_ACL_DEFAULT_ACT_VALUE_S		0
#define GL_ACL_DEFAULT_ACT_VALUE_M		MAKEMASK(0xFFFF, 0)
#define GL_ACL_DEFAULT_ACT_MDID_S		20
#define GL_ACL_DEFAULT_ACT_MDID_M		MAKEMASK(0x3F, 20)
#define GL_ACL_DEFAULT_ACT_PRIORITY_S		28
#define GL_ACL_DEFAULT_ACT_PRIORITY_M		MAKEMASK(0x7, 28)
#define GL_ACL_PROFILE_BWSB_SEL(_i)		(0x00391008 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GL_ACL_PROFILE_BWSB_SEL_MAX_INDEX	31
#define GL_ACL_PROFILE_BWSB_SEL_BSB_SRC_OFF_S	0
#define GL_ACL_PROFILE_BWSB_SEL_BSB_SRC_OFF_M	MAKEMASK(0x3F, 0)
#define GL_ACL_PROFILE_BWSB_SEL_WSB_SRC_OFF_S	8
#define GL_ACL_PROFILE_BWSB_SEL_WSB_SRC_OFF_M	MAKEMASK(0x1F, 8)
#define GL_ACL_PROFILE_DWSB_SEL(_i)		(0x00391088 + ((_i) * 4)) /* _i=0...15 */ /* Reset Source: CORER */
#define GL_ACL_PROFILE_DWSB_SEL_MAX_INDEX	15
#define GL_ACL_PROFILE_DWSB_SEL_DWORD_SEL_OFF_S 0
#define GL_ACL_PROFILE_DWSB_SEL_DWORD_SEL_OFF_M MAKEMASK(0xF, 0)
#define GL_ACL_PROFILE_PF_CFG(_i)		(0x003910C8 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GL_ACL_PROFILE_PF_CFG_MAX_INDEX		7
#define GL_ACL_PROFILE_PF_CFG_SCEN_SEL_S	0
#define GL_ACL_PROFILE_PF_CFG_SCEN_SEL_M	MAKEMASK(0x3F, 0)
#define GL_ACL_PROFILE_RC_CFG(_i)		(0x003910E8 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GL_ACL_PROFILE_RC_CFG_MAX_INDEX		7
#define GL_ACL_PROFILE_RC_CFG_LOW_BOUND_S	0
#define GL_ACL_PROFILE_RC_CFG_LOW_BOUND_M	MAKEMASK(0xFFFF, 0)
#define GL_ACL_PROFILE_RC_CFG_HIGH_BOUND_S	16
#define GL_ACL_PROFILE_RC_CFG_HIGH_BOUND_M	MAKEMASK(0xFFFF, 16)
#define GL_ACL_PROFILE_RCF_MASK(_i)		(0x00391108 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GL_ACL_PROFILE_RCF_MASK_MAX_INDEX	7
#define GL_ACL_PROFILE_RCF_MASK_MASK_S		0
#define GL_ACL_PROFILE_RCF_MASK_MASK_M		MAKEMASK(0xFFFF, 0)
#define GL_ACL_SCENARIO_ACT_CFG(_i)		(0x003938AC + ((_i) * 4)) /* _i=0...19 */ /* Reset Source: CORER */
#define GL_ACL_SCENARIO_ACT_CFG_MAX_INDEX	19
#define GL_ACL_SCENARIO_ACT_CFG_ACTMEM_SEL_S	0
#define GL_ACL_SCENARIO_ACT_CFG_ACTMEM_SEL_M	MAKEMASK(0xF, 0)
#define GL_ACL_SCENARIO_ACT_CFG_ACTMEM_EN_S	8
#define GL_ACL_SCENARIO_ACT_CFG_ACTMEM_EN_M	BIT(8)
#define GL_ACL_SCENARIO_CFG_H(_i)		(0x0039386C + ((_i) * 4)) /* _i=0...15 */ /* Reset Source: CORER */
#define GL_ACL_SCENARIO_CFG_H_MAX_INDEX		15
#define GL_ACL_SCENARIO_CFG_H_SELECT4_S		0
#define GL_ACL_SCENARIO_CFG_H_SELECT4_M		MAKEMASK(0x1F, 0)
#define GL_ACL_SCENARIO_CFG_H_CHUNKMASK_S	8
#define GL_ACL_SCENARIO_CFG_H_CHUNKMASK_M	MAKEMASK(0xFF, 8)
#define GL_ACL_SCENARIO_CFG_H_START_COMPARE_S	24
#define GL_ACL_SCENARIO_CFG_H_START_COMPARE_M	BIT(24)
#define GL_ACL_SCENARIO_CFG_H_START_SET_S	28
#define GL_ACL_SCENARIO_CFG_H_START_SET_M	BIT(28)
#define GL_ACL_SCENARIO_CFG_L(_i)		(0x0039382C + ((_i) * 4)) /* _i=0...15 */ /* Reset Source: CORER */
#define GL_ACL_SCENARIO_CFG_L_MAX_INDEX		15
#define GL_ACL_SCENARIO_CFG_L_SELECT0_S		0
#define GL_ACL_SCENARIO_CFG_L_SELECT0_M		MAKEMASK(0x7F, 0)
#define GL_ACL_SCENARIO_CFG_L_SELECT1_S		8
#define GL_ACL_SCENARIO_CFG_L_SELECT1_M		MAKEMASK(0x7F, 8)
#define GL_ACL_SCENARIO_CFG_L_SELECT2_S		16
#define GL_ACL_SCENARIO_CFG_L_SELECT2_M		MAKEMASK(0x7F, 16)
#define GL_ACL_SCENARIO_CFG_L_SELECT3_S		24
#define GL_ACL_SCENARIO_CFG_L_SELECT3_M		MAKEMASK(0x7F, 24)
#define GL_ACL_TCAM_KEY_H			0x00393818 /* Reset Source: CORER */
#define GL_ACL_TCAM_KEY_H_GL_ACL_FFU_TCAM_KEY_H_S 0
#define GL_ACL_TCAM_KEY_H_GL_ACL_FFU_TCAM_KEY_H_M MAKEMASK(0xFF, 0)
#define GL_ACL_TCAM_KEY_INV_H			0x00393820 /* Reset Source: CORER */
#define GL_ACL_TCAM_KEY_INV_H_GL_ACL_FFU_TCAM_KEY_INV_H_S 0
#define GL_ACL_TCAM_KEY_INV_H_GL_ACL_FFU_TCAM_KEY_INV_H_M MAKEMASK(0xFF, 0)
#define GL_ACL_TCAM_KEY_INV_L			0x0039381C /* Reset Source: CORER */
#define GL_ACL_TCAM_KEY_INV_L_GL_ACL_FFU_TCAM_KEY_INV_L_S 0
#define GL_ACL_TCAM_KEY_INV_L_GL_ACL_FFU_TCAM_KEY_INV_L_M MAKEMASK(0xFFFFFFFF, 0)
#define GL_ACL_TCAM_KEY_L			0x00393814 /* Reset Source: CORER */
#define GL_ACL_TCAM_KEY_L_GL_ACL_FFU_TCAM_KEY_L_S 0
#define GL_ACL_TCAM_KEY_L_GL_ACL_FFU_TCAM_KEY_L_M MAKEMASK(0xFFFFFFFF, 0)
#define VSI_ACL_DEF_SEL(_VSI)			(0x00391800 + ((_VSI) * 4)) /* _i=0...767 */ /* Reset Source: CORER */
#define VSI_ACL_DEF_SEL_MAX_INDEX		767
#define VSI_ACL_DEF_SEL_RX_PROFILE_MISS_SEL_S	0
#define VSI_ACL_DEF_SEL_RX_PROFILE_MISS_SEL_M	MAKEMASK(0x3, 0)
#define VSI_ACL_DEF_SEL_RX_TABLES_MISS_SEL_S	4
#define VSI_ACL_DEF_SEL_RX_TABLES_MISS_SEL_M	MAKEMASK(0x3, 4)
#define VSI_ACL_DEF_SEL_TX_PROFILE_MISS_SEL_S	8
#define VSI_ACL_DEF_SEL_TX_PROFILE_MISS_SEL_M	MAKEMASK(0x3, 8)
#define VSI_ACL_DEF_SEL_TX_TABLES_MISS_SEL_S	12
#define VSI_ACL_DEF_SEL_TX_TABLES_MISS_SEL_M	MAKEMASK(0x3, 12)
#define GL_SWT_L2TAG0(_i)			(0x000492A8 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GL_SWT_L2TAG0_MAX_INDEX			7
#define GL_SWT_L2TAG0_DATA_S			0
#define GL_SWT_L2TAG0_DATA_M			MAKEMASK(0xFFFFFFFF, 0)
#define GL_SWT_L2TAG1(_i)			(0x000492C8 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GL_SWT_L2TAG1_MAX_INDEX			7
#define GL_SWT_L2TAG1_DATA_S			0
#define GL_SWT_L2TAG1_DATA_M			MAKEMASK(0xFFFFFFFF, 0)
#define GL_SWT_L2TAGCTRL(_i)			(0x001D2660 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GL_SWT_L2TAGCTRL_MAX_INDEX		7
#define GL_SWT_L2TAGCTRL_LENGTH_S		0
#define GL_SWT_L2TAGCTRL_LENGTH_M		MAKEMASK(0x7F, 0)
#define GL_SWT_L2TAGCTRL_HAS_UP_S		7
#define GL_SWT_L2TAGCTRL_HAS_UP_M		BIT(7)
#define GL_SWT_L2TAGCTRL_ISVLAN_S		9
#define GL_SWT_L2TAGCTRL_ISVLAN_M		BIT(9)
#define GL_SWT_L2TAGCTRL_INNERUP_S		10
#define GL_SWT_L2TAGCTRL_INNERUP_M		BIT(10)
#define GL_SWT_L2TAGCTRL_OUTERUP_S		11
#define GL_SWT_L2TAGCTRL_OUTERUP_M		BIT(11)
#define GL_SWT_L2TAGCTRL_LONG_S			12
#define GL_SWT_L2TAGCTRL_LONG_M			BIT(12)
#define GL_SWT_L2TAGCTRL_ISMPLS_S		13
#define GL_SWT_L2TAGCTRL_ISMPLS_M		BIT(13)
#define GL_SWT_L2TAGCTRL_ISNSH_S		14
#define GL_SWT_L2TAGCTRL_ISNSH_M		BIT(14)
#define GL_SWT_L2TAGCTRL_ETHERTYPE_S		16
#define GL_SWT_L2TAGCTRL_ETHERTYPE_M		MAKEMASK(0xFFFF, 16)
#define GL_SWT_L2TAGRXEB(_i)			(0x00052000 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GL_SWT_L2TAGRXEB_MAX_INDEX		7
#define GL_SWT_L2TAGRXEB_OFFSET_S		0
#define GL_SWT_L2TAGRXEB_OFFSET_M		MAKEMASK(0xFF, 0)
#define GL_SWT_L2TAGRXEB_LENGTH_S		8
#define GL_SWT_L2TAGRXEB_LENGTH_M		MAKEMASK(0x3, 8)
#define GL_SWT_L2TAGTXIB(_i)			(0x000492E8 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GL_SWT_L2TAGTXIB_MAX_INDEX		7
#define GL_SWT_L2TAGTXIB_OFFSET_S		0
#define GL_SWT_L2TAGTXIB_OFFSET_M		MAKEMASK(0xFF, 0)
#define GL_SWT_L2TAGTXIB_LENGTH_S		8
#define GL_SWT_L2TAGTXIB_LENGTH_M		MAKEMASK(0x3, 8)
#define GLCM_PE_CACHESIZE			0x005046B4 /* Reset Source: CORER */
#define GLCM_PE_CACHESIZE_WORD_SIZE_S		0
#define GLCM_PE_CACHESIZE_WORD_SIZE_M		MAKEMASK(0xFFF, 0)
#define GLCM_PE_CACHESIZE_SETS_S		12
#define GLCM_PE_CACHESIZE_SETS_M		MAKEMASK(0xF, 12)
#define GLCM_PE_CACHESIZE_WAYS_S		16
#define GLCM_PE_CACHESIZE_WAYS_M		MAKEMASK(0x1FF, 16)
#define GLCOMM_CQ_CTL(_CQ)			(0x000F0000 + ((_CQ) * 4)) /* _i=0...511 */ /* Reset Source: CORER */
#define GLCOMM_CQ_CTL_MAX_INDEX			511
#define GLCOMM_CQ_CTL_COMP_TYPE_S		0
#define GLCOMM_CQ_CTL_COMP_TYPE_M		MAKEMASK(0x7, 0)
#define GLCOMM_CQ_CTL_CMD_S			4
#define GLCOMM_CQ_CTL_CMD_M			MAKEMASK(0x7, 4)
#define GLCOMM_CQ_CTL_ID_S			16
#define GLCOMM_CQ_CTL_ID_M			MAKEMASK(0x3FFF, 16)
#define GLCOMM_MIN_MAX_PKT			0x000FC064 /* Reset Source: CORER */
#define GLCOMM_MIN_MAX_PKT_MAHDL_S		0
#define GLCOMM_MIN_MAX_PKT_MAHDL_M		MAKEMASK(0x3FFF, 0)
#define GLCOMM_MIN_MAX_PKT_MIHDL_S		16
#define GLCOMM_MIN_MAX_PKT_MIHDL_M		MAKEMASK(0x3F, 16)
#define GLCOMM_MIN_MAX_PKT_LSO_COMS_MIHDL_S	22
#define GLCOMM_MIN_MAX_PKT_LSO_COMS_MIHDL_M	MAKEMASK(0x3FF, 22)
#define GLCOMM_PKT_SHAPER_PROF(_i)		(0x002D2DA8 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLCOMM_PKT_SHAPER_PROF_MAX_INDEX	7
#define GLCOMM_PKT_SHAPER_PROF_PKTCNT_S		0
#define GLCOMM_PKT_SHAPER_PROF_PKTCNT_M		MAKEMASK(0x3F, 0)
#define GLCOMM_QTX_CNTX_CTL			0x002D2DC8 /* Reset Source: CORER */
#define GLCOMM_QTX_CNTX_CTL_QUEUE_ID_S		0
#define GLCOMM_QTX_CNTX_CTL_QUEUE_ID_M		MAKEMASK(0x3FFF, 0)
#define GLCOMM_QTX_CNTX_CTL_CMD_S		16
#define GLCOMM_QTX_CNTX_CTL_CMD_M		MAKEMASK(0x7, 16)
#define GLCOMM_QTX_CNTX_CTL_CMD_EXEC_S		19
#define GLCOMM_QTX_CNTX_CTL_CMD_EXEC_M		BIT(19)
#define GLCOMM_QTX_CNTX_DATA(_i)		(0x002D2D40 + ((_i) * 4)) /* _i=0...9 */ /* Reset Source: CORER */
#define GLCOMM_QTX_CNTX_DATA_MAX_INDEX		9
#define GLCOMM_QTX_CNTX_DATA_DATA_S		0
#define GLCOMM_QTX_CNTX_DATA_DATA_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLCOMM_QTX_CNTX_STAT			0x002D2DCC /* Reset Source: CORER */
#define GLCOMM_QTX_CNTX_STAT_CMD_IN_PROG_S	0
#define GLCOMM_QTX_CNTX_STAT_CMD_IN_PROG_M	BIT(0)
#define GLCOMM_QUANTA_PROF(_i)			(0x002D2D68 + ((_i) * 4)) /* _i=0...15 */ /* Reset Source: CORER */
#define GLCOMM_QUANTA_PROF_MAX_INDEX		15
#define GLCOMM_QUANTA_PROF_QUANTA_SIZE_S	0
#define GLCOMM_QUANTA_PROF_QUANTA_SIZE_M	MAKEMASK(0x3FFF, 0)
#define GLCOMM_QUANTA_PROF_MAX_CMD_S		16
#define GLCOMM_QUANTA_PROF_MAX_CMD_M		MAKEMASK(0xFF, 16)
#define GLCOMM_QUANTA_PROF_MAX_DESC_S		24
#define GLCOMM_QUANTA_PROF_MAX_DESC_M		MAKEMASK(0x3F, 24)
#define GLLAN_TCLAN_CACHE_CTL			0x000FC0B8 /* Reset Source: CORER */
#define GLLAN_TCLAN_CACHE_CTL_MIN_FETCH_THRESH_S 0
#define GLLAN_TCLAN_CACHE_CTL_MIN_FETCH_THRESH_M MAKEMASK(0x3F, 0)
#define GLLAN_TCLAN_CACHE_CTL_FETCH_CL_ALIGN_S	6
#define GLLAN_TCLAN_CACHE_CTL_FETCH_CL_ALIGN_M	BIT(6)
#define GLLAN_TCLAN_CACHE_CTL_MIN_ALLOC_THRESH_S 7
#define GLLAN_TCLAN_CACHE_CTL_MIN_ALLOC_THRESH_M MAKEMASK(0x7F, 7)
#define GLLAN_TCLAN_CACHE_CTL_CACHE_ENTRY_CNT_S 14
#define GLLAN_TCLAN_CACHE_CTL_CACHE_ENTRY_CNT_M MAKEMASK(0xFF, 14)
#define GLLAN_TCLAN_CACHE_CTL_CACHE_DESC_LIM_S	22
#define GLLAN_TCLAN_CACHE_CTL_CACHE_DESC_LIM_M	MAKEMASK(0x3FF, 22)
#define GLTCLAN_CQ_CNTX0(_CQ)			(0x000F0800 + ((_CQ) * 4)) /* _i=0...511 */ /* Reset Source: CORER */
#define GLTCLAN_CQ_CNTX0_MAX_INDEX		511
#define GLTCLAN_CQ_CNTX0_RING_ADDR_LSB_S	0
#define GLTCLAN_CQ_CNTX0_RING_ADDR_LSB_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLTCLAN_CQ_CNTX1(_CQ)			(0x000F1000 + ((_CQ) * 4)) /* _i=0...511 */ /* Reset Source: CORER */
#define GLTCLAN_CQ_CNTX1_MAX_INDEX		511
#define GLTCLAN_CQ_CNTX1_RING_ADDR_MSB_S	0
#define GLTCLAN_CQ_CNTX1_RING_ADDR_MSB_M	MAKEMASK(0x1FFFFFF, 0)
#define GLTCLAN_CQ_CNTX10(_CQ)			(0x000F5800 + ((_CQ) * 4)) /* _i=0...511 */ /* Reset Source: CORER */
#define GLTCLAN_CQ_CNTX10_MAX_INDEX		511
#define GLTCLAN_CQ_CNTX10_CQ_CACHLINE_S		0
#define GLTCLAN_CQ_CNTX10_CQ_CACHLINE_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLTCLAN_CQ_CNTX11(_CQ)			(0x000F6000 + ((_CQ) * 4)) /* _i=0...511 */ /* Reset Source: CORER */
#define GLTCLAN_CQ_CNTX11_MAX_INDEX		511
#define GLTCLAN_CQ_CNTX11_CQ_CACHLINE_S		0
#define GLTCLAN_CQ_CNTX11_CQ_CACHLINE_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLTCLAN_CQ_CNTX12(_CQ)			(0x000F6800 + ((_CQ) * 4)) /* _i=0...511 */ /* Reset Source: CORER */
#define GLTCLAN_CQ_CNTX12_MAX_INDEX		511
#define GLTCLAN_CQ_CNTX12_CQ_CACHLINE_S		0
#define GLTCLAN_CQ_CNTX12_CQ_CACHLINE_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLTCLAN_CQ_CNTX13(_CQ)			(0x000F7000 + ((_CQ) * 4)) /* _i=0...511 */ /* Reset Source: CORER */
#define GLTCLAN_CQ_CNTX13_MAX_INDEX		511
#define GLTCLAN_CQ_CNTX13_CQ_CACHLINE_S		0
#define GLTCLAN_CQ_CNTX13_CQ_CACHLINE_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLTCLAN_CQ_CNTX14(_CQ)			(0x000F7800 + ((_CQ) * 4)) /* _i=0...511 */ /* Reset Source: CORER */
#define GLTCLAN_CQ_CNTX14_MAX_INDEX		511
#define GLTCLAN_CQ_CNTX14_CQ_CACHLINE_S		0
#define GLTCLAN_CQ_CNTX14_CQ_CACHLINE_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLTCLAN_CQ_CNTX15(_CQ)			(0x000F8000 + ((_CQ) * 4)) /* _i=0...511 */ /* Reset Source: CORER */
#define GLTCLAN_CQ_CNTX15_MAX_INDEX		511
#define GLTCLAN_CQ_CNTX15_CQ_CACHLINE_S		0
#define GLTCLAN_CQ_CNTX15_CQ_CACHLINE_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLTCLAN_CQ_CNTX16(_CQ)			(0x000F8800 + ((_CQ) * 4)) /* _i=0...511 */ /* Reset Source: CORER */
#define GLTCLAN_CQ_CNTX16_MAX_INDEX		511
#define GLTCLAN_CQ_CNTX16_CQ_CACHLINE_S		0
#define GLTCLAN_CQ_CNTX16_CQ_CACHLINE_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLTCLAN_CQ_CNTX17(_CQ)			(0x000F9000 + ((_CQ) * 4)) /* _i=0...511 */ /* Reset Source: CORER */
#define GLTCLAN_CQ_CNTX17_MAX_INDEX		511
#define GLTCLAN_CQ_CNTX17_CQ_CACHLINE_S		0
#define GLTCLAN_CQ_CNTX17_CQ_CACHLINE_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLTCLAN_CQ_CNTX18(_CQ)			(0x000F9800 + ((_CQ) * 4)) /* _i=0...511 */ /* Reset Source: CORER */
#define GLTCLAN_CQ_CNTX18_MAX_INDEX		511
#define GLTCLAN_CQ_CNTX18_CQ_CACHLINE_S		0
#define GLTCLAN_CQ_CNTX18_CQ_CACHLINE_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLTCLAN_CQ_CNTX19(_CQ)			(0x000FA000 + ((_CQ) * 4)) /* _i=0...511 */ /* Reset Source: CORER */
#define GLTCLAN_CQ_CNTX19_MAX_INDEX		511
#define GLTCLAN_CQ_CNTX19_CQ_CACHLINE_S		0
#define GLTCLAN_CQ_CNTX19_CQ_CACHLINE_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLTCLAN_CQ_CNTX2(_CQ)			(0x000F1800 + ((_CQ) * 4)) /* _i=0...511 */ /* Reset Source: CORER */
#define GLTCLAN_CQ_CNTX2_MAX_INDEX		511
#define GLTCLAN_CQ_CNTX2_RING_LEN_S		0
#define GLTCLAN_CQ_CNTX2_RING_LEN_M		MAKEMASK(0x3FFFF, 0)
#define GLTCLAN_CQ_CNTX20(_CQ)			(0x000FA800 + ((_CQ) * 4)) /* _i=0...511 */ /* Reset Source: CORER */
#define GLTCLAN_CQ_CNTX20_MAX_INDEX		511
#define GLTCLAN_CQ_CNTX20_CQ_CACHLINE_S		0
#define GLTCLAN_CQ_CNTX20_CQ_CACHLINE_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLTCLAN_CQ_CNTX21(_CQ)			(0x000FB000 + ((_CQ) * 4)) /* _i=0...511 */ /* Reset Source: CORER */
#define GLTCLAN_CQ_CNTX21_MAX_INDEX		511
#define GLTCLAN_CQ_CNTX21_CQ_CACHLINE_S		0
#define GLTCLAN_CQ_CNTX21_CQ_CACHLINE_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLTCLAN_CQ_CNTX3(_CQ)			(0x000F2000 + ((_CQ) * 4)) /* _i=0...511 */ /* Reset Source: CORER */
#define GLTCLAN_CQ_CNTX3_MAX_INDEX		511
#define GLTCLAN_CQ_CNTX3_GENERATION_S		0
#define GLTCLAN_CQ_CNTX3_GENERATION_M		BIT(0)
#define GLTCLAN_CQ_CNTX3_CQ_WR_PTR_S		1
#define GLTCLAN_CQ_CNTX3_CQ_WR_PTR_M		MAKEMASK(0x3FFFFF, 1)
#define GLTCLAN_CQ_CNTX4(_CQ)			(0x000F2800 + ((_CQ) * 4)) /* _i=0...511 */ /* Reset Source: CORER */
#define GLTCLAN_CQ_CNTX4_MAX_INDEX		511
#define GLTCLAN_CQ_CNTX4_PF_NUM_S		0
#define GLTCLAN_CQ_CNTX4_PF_NUM_M		MAKEMASK(0x7, 0)
#define GLTCLAN_CQ_CNTX4_VMVF_NUM_S		3
#define GLTCLAN_CQ_CNTX4_VMVF_NUM_M		MAKEMASK(0x3FF, 3)
#define GLTCLAN_CQ_CNTX4_VMVF_TYPE_S		13
#define GLTCLAN_CQ_CNTX4_VMVF_TYPE_M		MAKEMASK(0x3, 13)
#define GLTCLAN_CQ_CNTX5(_CQ)			(0x000F3000 + ((_CQ) * 4)) /* _i=0...511 */ /* Reset Source: CORER */
#define GLTCLAN_CQ_CNTX5_MAX_INDEX		511
#define GLTCLAN_CQ_CNTX5_TPH_EN_S		0
#define GLTCLAN_CQ_CNTX5_TPH_EN_M		BIT(0)
#define GLTCLAN_CQ_CNTX5_CPU_ID_S		1
#define GLTCLAN_CQ_CNTX5_CPU_ID_M		MAKEMASK(0xFF, 1)
#define GLTCLAN_CQ_CNTX5_FLUSH_ON_ITR_DIS_S	9
#define GLTCLAN_CQ_CNTX5_FLUSH_ON_ITR_DIS_M	BIT(9)
#define GLTCLAN_CQ_CNTX6(_CQ)			(0x000F3800 + ((_CQ) * 4)) /* _i=0...511 */ /* Reset Source: CORER */
#define GLTCLAN_CQ_CNTX6_MAX_INDEX		511
#define GLTCLAN_CQ_CNTX6_CQ_CACHLINE_S		0
#define GLTCLAN_CQ_CNTX6_CQ_CACHLINE_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLTCLAN_CQ_CNTX7(_CQ)			(0x000F4000 + ((_CQ) * 4)) /* _i=0...511 */ /* Reset Source: CORER */
#define GLTCLAN_CQ_CNTX7_MAX_INDEX		511
#define GLTCLAN_CQ_CNTX7_CQ_CACHLINE_S		0
#define GLTCLAN_CQ_CNTX7_CQ_CACHLINE_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLTCLAN_CQ_CNTX8(_CQ)			(0x000F4800 + ((_CQ) * 4)) /* _i=0...511 */ /* Reset Source: CORER */
#define GLTCLAN_CQ_CNTX8_MAX_INDEX		511
#define GLTCLAN_CQ_CNTX8_CQ_CACHLINE_S		0
#define GLTCLAN_CQ_CNTX8_CQ_CACHLINE_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLTCLAN_CQ_CNTX9(_CQ)			(0x000F5000 + ((_CQ) * 4)) /* _i=0...511 */ /* Reset Source: CORER */
#define GLTCLAN_CQ_CNTX9_MAX_INDEX		511
#define GLTCLAN_CQ_CNTX9_CQ_CACHLINE_S		0
#define GLTCLAN_CQ_CNTX9_CQ_CACHLINE_M		MAKEMASK(0xFFFFFFFF, 0)
#define QTX_COMM_DBELL(_DBQM)			(0x002C0000 + ((_DBQM) * 4)) /* _i=0...16383 */ /* Reset Source: CORER */
#define QTX_COMM_DBELL_MAX_INDEX		16383
#define QTX_COMM_DBELL_QTX_COMM_DBELL_S		0
#define QTX_COMM_DBELL_QTX_COMM_DBELL_M		MAKEMASK(0xFFFFFFFF, 0)
#define QTX_COMM_DBLQ_CNTX(_i, _DBLQ)		(0x002D0000 + ((_i) * 1024 + (_DBLQ) * 4)) /* _i=0...4, _DBLQ=0...255 */ /* Reset Source: CORER */
#define QTX_COMM_DBLQ_CNTX_MAX_INDEX		4
#define QTX_COMM_DBLQ_CNTX_DATA_S		0
#define QTX_COMM_DBLQ_CNTX_DATA_M		MAKEMASK(0xFFFFFFFF, 0)
#define QTX_COMM_DBLQ_DBELL(_DBLQ)		(0x002D1400 + ((_DBLQ) * 4)) /* _i=0...255 */ /* Reset Source: CORER */
#define QTX_COMM_DBLQ_DBELL_MAX_INDEX		255
#define QTX_COMM_DBLQ_DBELL_TAIL_S		0
#define QTX_COMM_DBLQ_DBELL_TAIL_M		MAKEMASK(0x1FFF, 0)
#define QTX_COMM_HEAD(_DBQM)			(0x000E0000 + ((_DBQM) * 4)) /* _i=0...16383 */ /* Reset Source: CORER */
#define QTX_COMM_HEAD_MAX_INDEX			16383
#define QTX_COMM_HEAD_HEAD_S			0
#define QTX_COMM_HEAD_HEAD_M			MAKEMASK(0x1FFF, 0)
#define QTX_COMM_HEAD_RS_PENDING_S		16
#define QTX_COMM_HEAD_RS_PENDING_M		BIT(16)
#define GL_FW_TOOL_ARQBAH			0x000801C0 /* Reset Source: EMPR */
#define GL_FW_TOOL_ARQBAH_ARQBAH_S		0
#define GL_FW_TOOL_ARQBAH_ARQBAH_M		MAKEMASK(0xFFFFFFFF, 0)
#define GL_FW_TOOL_ARQBAL			0x000800C0 /* Reset Source: EMPR */
#define GL_FW_TOOL_ARQBAL_ARQBAL_LSB_S		0
#define GL_FW_TOOL_ARQBAL_ARQBAL_LSB_M		MAKEMASK(0x3F, 0)
#define GL_FW_TOOL_ARQBAL_ARQBAL_S		6
#define GL_FW_TOOL_ARQBAL_ARQBAL_M		MAKEMASK(0x3FFFFFF, 6)
#define GL_FW_TOOL_ARQH				0x000803C0 /* Reset Source: EMPR */
#define GL_FW_TOOL_ARQH_ARQH_S			0
#define GL_FW_TOOL_ARQH_ARQH_M			MAKEMASK(0x3FF, 0)
#define GL_FW_TOOL_ARQLEN			0x000802C0 /* Reset Source: EMPR */
#define GL_FW_TOOL_ARQLEN_ARQLEN_S		0
#define GL_FW_TOOL_ARQLEN_ARQLEN_M		MAKEMASK(0x3FF, 0)
#define GL_FW_TOOL_ARQLEN_ARQVFE_S		28
#define GL_FW_TOOL_ARQLEN_ARQVFE_M		BIT(28)
#define GL_FW_TOOL_ARQLEN_ARQOVFL_S		29
#define GL_FW_TOOL_ARQLEN_ARQOVFL_M		BIT(29)
#define GL_FW_TOOL_ARQLEN_ARQCRIT_S		30
#define GL_FW_TOOL_ARQLEN_ARQCRIT_M		BIT(30)
#define GL_FW_TOOL_ARQLEN_ARQENABLE_S		31
#define GL_FW_TOOL_ARQLEN_ARQENABLE_M		BIT(31)
#define GL_FW_TOOL_ARQT				0x000804C0 /* Reset Source: EMPR */
#define GL_FW_TOOL_ARQT_ARQT_S			0
#define GL_FW_TOOL_ARQT_ARQT_M			MAKEMASK(0x3FF, 0)
#define GL_FW_TOOL_ATQBAH			0x00080140 /* Reset Source: EMPR */
#define GL_FW_TOOL_ATQBAH_ATQBAH_S		0
#define GL_FW_TOOL_ATQBAH_ATQBAH_M		MAKEMASK(0xFFFFFFFF, 0)
#define GL_FW_TOOL_ATQBAL			0x00080040 /* Reset Source: EMPR */
#define GL_FW_TOOL_ATQBAL_ATQBAL_LSB_S		0
#define GL_FW_TOOL_ATQBAL_ATQBAL_LSB_M		MAKEMASK(0x3F, 0)
#define GL_FW_TOOL_ATQBAL_ATQBAL_S		6
#define GL_FW_TOOL_ATQBAL_ATQBAL_M		MAKEMASK(0x3FFFFFF, 6)
#define GL_FW_TOOL_ATQH				0x00080340 /* Reset Source: EMPR */
#define GL_FW_TOOL_ATQH_ATQH_S			0
#define GL_FW_TOOL_ATQH_ATQH_M			MAKEMASK(0x3FF, 0)
#define GL_FW_TOOL_ATQLEN			0x00080240 /* Reset Source: EMPR */
#define GL_FW_TOOL_ATQLEN_ATQLEN_S		0
#define GL_FW_TOOL_ATQLEN_ATQLEN_M		MAKEMASK(0x3FF, 0)
#define GL_FW_TOOL_ATQLEN_ATQVFE_S		28
#define GL_FW_TOOL_ATQLEN_ATQVFE_M		BIT(28)
#define GL_FW_TOOL_ATQLEN_ATQOVFL_S		29
#define GL_FW_TOOL_ATQLEN_ATQOVFL_M		BIT(29)
#define GL_FW_TOOL_ATQLEN_ATQCRIT_S		30
#define GL_FW_TOOL_ATQLEN_ATQCRIT_M		BIT(30)
#define GL_FW_TOOL_ATQLEN_ATQENABLE_S		31
#define GL_FW_TOOL_ATQLEN_ATQENABLE_M		BIT(31)
#define GL_FW_TOOL_ATQT				0x00080440 /* Reset Source: EMPR */
#define GL_FW_TOOL_ATQT_ATQT_S			0
#define GL_FW_TOOL_ATQT_ATQT_M			MAKEMASK(0x3FF, 0)
#define GL_MBX_PASID				0x00231EC0 /* Reset Source: CORER */
#define GL_MBX_PASID_PASID_MODE_S		0
#define GL_MBX_PASID_PASID_MODE_M		BIT(0)
#define GL_MBX_PASID_PASID_MODE_VALID_S		1
#define GL_MBX_PASID_PASID_MODE_VALID_M		BIT(1)
#define PF_FW_ARQBAH				0x00080180 /* Reset Source: EMPR */
#define PF_FW_ARQBAH_ARQBAH_S			0
#define PF_FW_ARQBAH_ARQBAH_M			MAKEMASK(0xFFFFFFFF, 0)
#define PF_FW_ARQBAL				0x00080080 /* Reset Source: EMPR */
#define PF_FW_ARQBAL_ARQBAL_LSB_S		0
#define PF_FW_ARQBAL_ARQBAL_LSB_M		MAKEMASK(0x3F, 0)
#define PF_FW_ARQBAL_ARQBAL_S			6
#define PF_FW_ARQBAL_ARQBAL_M			MAKEMASK(0x3FFFFFF, 6)
#define PF_FW_ARQH				0x00080380 /* Reset Source: EMPR */
#define PF_FW_ARQH_ARQH_S			0
#define PF_FW_ARQH_ARQH_M			MAKEMASK(0x3FF, 0)
#define PF_FW_ARQLEN				0x00080280 /* Reset Source: EMPR */
#define PF_FW_ARQLEN_ARQLEN_S			0
#define PF_FW_ARQLEN_ARQLEN_M			MAKEMASK(0x3FF, 0)
#define PF_FW_ARQLEN_ARQVFE_S			28
#define PF_FW_ARQLEN_ARQVFE_M			BIT(28)
#define PF_FW_ARQLEN_ARQOVFL_S			29
#define PF_FW_ARQLEN_ARQOVFL_M			BIT(29)
#define PF_FW_ARQLEN_ARQCRIT_S			30
#define PF_FW_ARQLEN_ARQCRIT_M			BIT(30)
#define PF_FW_ARQLEN_ARQENABLE_S		31
#define PF_FW_ARQLEN_ARQENABLE_M		BIT(31)
#define PF_FW_ARQT				0x00080480 /* Reset Source: EMPR */
#define PF_FW_ARQT_ARQT_S			0
#define PF_FW_ARQT_ARQT_M			MAKEMASK(0x3FF, 0)
#define PF_FW_ATQBAH				0x00080100 /* Reset Source: EMPR */
#define PF_FW_ATQBAH_ATQBAH_S			0
#define PF_FW_ATQBAH_ATQBAH_M			MAKEMASK(0xFFFFFFFF, 0)
#define PF_FW_ATQBAL				0x00080000 /* Reset Source: EMPR */
#define PF_FW_ATQBAL_ATQBAL_LSB_S		0
#define PF_FW_ATQBAL_ATQBAL_LSB_M		MAKEMASK(0x3F, 0)
#define PF_FW_ATQBAL_ATQBAL_S			6
#define PF_FW_ATQBAL_ATQBAL_M			MAKEMASK(0x3FFFFFF, 6)
#define PF_FW_ATQH				0x00080300 /* Reset Source: EMPR */
#define PF_FW_ATQH_ATQH_S			0
#define PF_FW_ATQH_ATQH_M			MAKEMASK(0x3FF, 0)
#define PF_FW_ATQLEN				0x00080200 /* Reset Source: EMPR */
#define PF_FW_ATQLEN_ATQLEN_S			0
#define PF_FW_ATQLEN_ATQLEN_M			MAKEMASK(0x3FF, 0)
#define PF_FW_ATQLEN_ATQVFE_S			28
#define PF_FW_ATQLEN_ATQVFE_M			BIT(28)
#define PF_FW_ATQLEN_ATQOVFL_S			29
#define PF_FW_ATQLEN_ATQOVFL_M			BIT(29)
#define PF_FW_ATQLEN_ATQCRIT_S			30
#define PF_FW_ATQLEN_ATQCRIT_M			BIT(30)
#define PF_FW_ATQLEN_ATQENABLE_S		31
#define PF_FW_ATQLEN_ATQENABLE_M		BIT(31)
#define PF_FW_ATQT				0x00080400 /* Reset Source: EMPR */
#define PF_FW_ATQT_ATQT_S			0
#define PF_FW_ATQT_ATQT_M			MAKEMASK(0x3FF, 0)
#define PF_MBX_ARQBAH				0x0022E400 /* Reset Source: CORER */
#define PF_MBX_ARQBAH_ARQBAH_S			0
#define PF_MBX_ARQBAH_ARQBAH_M			MAKEMASK(0xFFFFFFFF, 0)
#define PF_MBX_ARQBAL				0x0022E380 /* Reset Source: CORER */
#define PF_MBX_ARQBAL_ARQBAL_LSB_S		0
#define PF_MBX_ARQBAL_ARQBAL_LSB_M		MAKEMASK(0x3F, 0)
#define PF_MBX_ARQBAL_ARQBAL_S			6
#define PF_MBX_ARQBAL_ARQBAL_M			MAKEMASK(0x3FFFFFF, 6)
#define PF_MBX_ARQH				0x0022E500 /* Reset Source: CORER */
#define PF_MBX_ARQH_ARQH_S			0
#define PF_MBX_ARQH_ARQH_M			MAKEMASK(0x3FF, 0)
#define PF_MBX_ARQLEN				0x0022E480 /* Reset Source: PFR */
#define PF_MBX_ARQLEN_ARQLEN_S			0
#define PF_MBX_ARQLEN_ARQLEN_M			MAKEMASK(0x3FF, 0)
#define PF_MBX_ARQLEN_ARQVFE_S			28
#define PF_MBX_ARQLEN_ARQVFE_M			BIT(28)
#define PF_MBX_ARQLEN_ARQOVFL_S			29
#define PF_MBX_ARQLEN_ARQOVFL_M			BIT(29)
#define PF_MBX_ARQLEN_ARQCRIT_S			30
#define PF_MBX_ARQLEN_ARQCRIT_M			BIT(30)
#define PF_MBX_ARQLEN_ARQENABLE_S		31
#define PF_MBX_ARQLEN_ARQENABLE_M		BIT(31)
#define PF_MBX_ARQT				0x0022E580 /* Reset Source: CORER */
#define PF_MBX_ARQT_ARQT_S			0
#define PF_MBX_ARQT_ARQT_M			MAKEMASK(0x3FF, 0)
#define PF_MBX_ATQBAH				0x0022E180 /* Reset Source: CORER */
#define PF_MBX_ATQBAH_ATQBAH_S			0
#define PF_MBX_ATQBAH_ATQBAH_M			MAKEMASK(0xFFFFFFFF, 0)
#define PF_MBX_ATQBAL				0x0022E100 /* Reset Source: CORER */
#define PF_MBX_ATQBAL_ATQBAL_S			6
#define PF_MBX_ATQBAL_ATQBAL_M			MAKEMASK(0x3FFFFFF, 6)
#define PF_MBX_ATQH				0x0022E280 /* Reset Source: CORER */
#define PF_MBX_ATQH_ATQH_S			0
#define PF_MBX_ATQH_ATQH_M			MAKEMASK(0x3FF, 0)
#define PF_MBX_ATQLEN				0x0022E200 /* Reset Source: PFR */
#define PF_MBX_ATQLEN_ATQLEN_S			0
#define PF_MBX_ATQLEN_ATQLEN_M			MAKEMASK(0x3FF, 0)
#define PF_MBX_ATQLEN_ATQVFE_S			28
#define PF_MBX_ATQLEN_ATQVFE_M			BIT(28)
#define PF_MBX_ATQLEN_ATQOVFL_S			29
#define PF_MBX_ATQLEN_ATQOVFL_M			BIT(29)
#define PF_MBX_ATQLEN_ATQCRIT_S			30
#define PF_MBX_ATQLEN_ATQCRIT_M			BIT(30)
#define PF_MBX_ATQLEN_ATQENABLE_S		31
#define PF_MBX_ATQLEN_ATQENABLE_M		BIT(31)
#define PF_MBX_ATQT				0x0022E300 /* Reset Source: CORER */
#define PF_MBX_ATQT_ATQT_S			0
#define PF_MBX_ATQT_ATQT_M			MAKEMASK(0x3FF, 0)
#define PF_SB_ARQBAH				0x0022FF00 /* Reset Source: CORER */
#define PF_SB_ARQBAH_ARQBAH_S			0
#define PF_SB_ARQBAH_ARQBAH_M			MAKEMASK(0xFFFFFFFF, 0)
#define PF_SB_ARQBAL				0x0022FE80 /* Reset Source: CORER */
#define PF_SB_ARQBAL_ARQBAL_LSB_S		0
#define PF_SB_ARQBAL_ARQBAL_LSB_M		MAKEMASK(0x3F, 0)
#define PF_SB_ARQBAL_ARQBAL_S			6
#define PF_SB_ARQBAL_ARQBAL_M			MAKEMASK(0x3FFFFFF, 6)
#define PF_SB_ARQH				0x00230000 /* Reset Source: CORER */
#define PF_SB_ARQH_ARQH_S			0
#define PF_SB_ARQH_ARQH_M			MAKEMASK(0x3FF, 0)
#define PF_SB_ARQLEN				0x0022FF80 /* Reset Source: PFR */
#define PF_SB_ARQLEN_ARQLEN_S			0
#define PF_SB_ARQLEN_ARQLEN_M			MAKEMASK(0x3FF, 0)
#define PF_SB_ARQLEN_ARQVFE_S			28
#define PF_SB_ARQLEN_ARQVFE_M			BIT(28)
#define PF_SB_ARQLEN_ARQOVFL_S			29
#define PF_SB_ARQLEN_ARQOVFL_M			BIT(29)
#define PF_SB_ARQLEN_ARQCRIT_S			30
#define PF_SB_ARQLEN_ARQCRIT_M			BIT(30)
#define PF_SB_ARQLEN_ARQENABLE_S		31
#define PF_SB_ARQLEN_ARQENABLE_M		BIT(31)
#define PF_SB_ARQT				0x00230080 /* Reset Source: CORER */
#define PF_SB_ARQT_ARQT_S			0
#define PF_SB_ARQT_ARQT_M			MAKEMASK(0x3FF, 0)
#define PF_SB_ATQBAH				0x0022FC80 /* Reset Source: CORER */
#define PF_SB_ATQBAH_ATQBAH_S			0
#define PF_SB_ATQBAH_ATQBAH_M			MAKEMASK(0xFFFFFFFF, 0)
#define PF_SB_ATQBAL				0x0022FC00 /* Reset Source: CORER */
#define PF_SB_ATQBAL_ATQBAL_S			6
#define PF_SB_ATQBAL_ATQBAL_M			MAKEMASK(0x3FFFFFF, 6)
#define PF_SB_ATQH				0x0022FD80 /* Reset Source: CORER */
#define PF_SB_ATQH_ATQH_S			0
#define PF_SB_ATQH_ATQH_M			MAKEMASK(0x3FF, 0)
#define PF_SB_ATQLEN				0x0022FD00 /* Reset Source: PFR */
#define PF_SB_ATQLEN_ATQLEN_S			0
#define PF_SB_ATQLEN_ATQLEN_M			MAKEMASK(0x3FF, 0)
#define PF_SB_ATQLEN_ATQVFE_S			28
#define PF_SB_ATQLEN_ATQVFE_M			BIT(28)
#define PF_SB_ATQLEN_ATQOVFL_S			29
#define PF_SB_ATQLEN_ATQOVFL_M			BIT(29)
#define PF_SB_ATQLEN_ATQCRIT_S			30
#define PF_SB_ATQLEN_ATQCRIT_M			BIT(30)
#define PF_SB_ATQLEN_ATQENABLE_S		31
#define PF_SB_ATQLEN_ATQENABLE_M		BIT(31)
#define PF_SB_ATQT				0x0022FE00 /* Reset Source: CORER */
#define PF_SB_ATQT_ATQT_S			0
#define PF_SB_ATQT_ATQT_M			MAKEMASK(0x3FF, 0)
#define PF_SB_REM_DEV_CTL			0x002300F0 /* Reset Source: CORER */
#define PF_SB_REM_DEV_CTL_DEST_EN_S		0
#define PF_SB_REM_DEV_CTL_DEST_EN_M		MAKEMASK(0xFFFF, 0)
#define PF0_FW_HLP_ARQBAH			0x000801C8 /* Reset Source: EMPR */
#define PF0_FW_HLP_ARQBAH_ARQBAH_S		0
#define PF0_FW_HLP_ARQBAH_ARQBAH_M		MAKEMASK(0xFFFFFFFF, 0)
#define PF0_FW_HLP_ARQBAL			0x000800C8 /* Reset Source: EMPR */
#define PF0_FW_HLP_ARQBAL_ARQBAL_LSB_S		0
#define PF0_FW_HLP_ARQBAL_ARQBAL_LSB_M		MAKEMASK(0x3F, 0)
#define PF0_FW_HLP_ARQBAL_ARQBAL_S		6
#define PF0_FW_HLP_ARQBAL_ARQBAL_M		MAKEMASK(0x3FFFFFF, 6)
#define PF0_FW_HLP_ARQH				0x000803C8 /* Reset Source: EMPR */
#define PF0_FW_HLP_ARQH_ARQH_S			0
#define PF0_FW_HLP_ARQH_ARQH_M			MAKEMASK(0x3FF, 0)
#define PF0_FW_HLP_ARQLEN			0x000802C8 /* Reset Source: EMPR */
#define PF0_FW_HLP_ARQLEN_ARQLEN_S		0
#define PF0_FW_HLP_ARQLEN_ARQLEN_M		MAKEMASK(0x3FF, 0)
#define PF0_FW_HLP_ARQLEN_ARQVFE_S		28
#define PF0_FW_HLP_ARQLEN_ARQVFE_M		BIT(28)
#define PF0_FW_HLP_ARQLEN_ARQOVFL_S		29
#define PF0_FW_HLP_ARQLEN_ARQOVFL_M		BIT(29)
#define PF0_FW_HLP_ARQLEN_ARQCRIT_S		30
#define PF0_FW_HLP_ARQLEN_ARQCRIT_M		BIT(30)
#define PF0_FW_HLP_ARQLEN_ARQENABLE_S		31
#define PF0_FW_HLP_ARQLEN_ARQENABLE_M		BIT(31)
#define PF0_FW_HLP_ARQT				0x000804C8 /* Reset Source: EMPR */
#define PF0_FW_HLP_ARQT_ARQT_S			0
#define PF0_FW_HLP_ARQT_ARQT_M			MAKEMASK(0x3FF, 0)
#define PF0_FW_HLP_ATQBAH			0x00080148 /* Reset Source: EMPR */
#define PF0_FW_HLP_ATQBAH_ATQBAH_S		0
#define PF0_FW_HLP_ATQBAH_ATQBAH_M		MAKEMASK(0xFFFFFFFF, 0)
#define PF0_FW_HLP_ATQBAL			0x00080048 /* Reset Source: EMPR */
#define PF0_FW_HLP_ATQBAL_ATQBAL_LSB_S		0
#define PF0_FW_HLP_ATQBAL_ATQBAL_LSB_M		MAKEMASK(0x3F, 0)
#define PF0_FW_HLP_ATQBAL_ATQBAL_S		6
#define PF0_FW_HLP_ATQBAL_ATQBAL_M		MAKEMASK(0x3FFFFFF, 6)
#define PF0_FW_HLP_ATQH				0x00080348 /* Reset Source: EMPR */
#define PF0_FW_HLP_ATQH_ATQH_S			0
#define PF0_FW_HLP_ATQH_ATQH_M			MAKEMASK(0x3FF, 0)
#define PF0_FW_HLP_ATQLEN			0x00080248 /* Reset Source: EMPR */
#define PF0_FW_HLP_ATQLEN_ATQLEN_S		0
#define PF0_FW_HLP_ATQLEN_ATQLEN_M		MAKEMASK(0x3FF, 0)
#define PF0_FW_HLP_ATQLEN_ATQVFE_S		28
#define PF0_FW_HLP_ATQLEN_ATQVFE_M		BIT(28)
#define PF0_FW_HLP_ATQLEN_ATQOVFL_S		29
#define PF0_FW_HLP_ATQLEN_ATQOVFL_M		BIT(29)
#define PF0_FW_HLP_ATQLEN_ATQCRIT_S		30
#define PF0_FW_HLP_ATQLEN_ATQCRIT_M		BIT(30)
#define PF0_FW_HLP_ATQLEN_ATQENABLE_S		31
#define PF0_FW_HLP_ATQLEN_ATQENABLE_M		BIT(31)
#define PF0_FW_HLP_ATQT				0x00080448 /* Reset Source: EMPR */
#define PF0_FW_HLP_ATQT_ATQT_S			0
#define PF0_FW_HLP_ATQT_ATQT_M			MAKEMASK(0x3FF, 0)
#define PF0_FW_PSM_ARQBAH			0x000801C4 /* Reset Source: EMPR */
#define PF0_FW_PSM_ARQBAH_ARQBAH_S		0
#define PF0_FW_PSM_ARQBAH_ARQBAH_M		MAKEMASK(0xFFFFFFFF, 0)
#define PF0_FW_PSM_ARQBAL			0x000800C4 /* Reset Source: EMPR */
#define PF0_FW_PSM_ARQBAL_ARQBAL_LSB_S		0
#define PF0_FW_PSM_ARQBAL_ARQBAL_LSB_M		MAKEMASK(0x3F, 0)
#define PF0_FW_PSM_ARQBAL_ARQBAL_S		6
#define PF0_FW_PSM_ARQBAL_ARQBAL_M		MAKEMASK(0x3FFFFFF, 6)
#define PF0_FW_PSM_ARQH				0x000803C4 /* Reset Source: EMPR */
#define PF0_FW_PSM_ARQH_ARQH_S			0
#define PF0_FW_PSM_ARQH_ARQH_M			MAKEMASK(0x3FF, 0)
#define PF0_FW_PSM_ARQLEN			0x000802C4 /* Reset Source: EMPR */
#define PF0_FW_PSM_ARQLEN_ARQLEN_S		0
#define PF0_FW_PSM_ARQLEN_ARQLEN_M		MAKEMASK(0x3FF, 0)
#define PF0_FW_PSM_ARQLEN_ARQVFE_S		28
#define PF0_FW_PSM_ARQLEN_ARQVFE_M		BIT(28)
#define PF0_FW_PSM_ARQLEN_ARQOVFL_S		29
#define PF0_FW_PSM_ARQLEN_ARQOVFL_M		BIT(29)
#define PF0_FW_PSM_ARQLEN_ARQCRIT_S		30
#define PF0_FW_PSM_ARQLEN_ARQCRIT_M		BIT(30)
#define PF0_FW_PSM_ARQLEN_ARQENABLE_S		31
#define PF0_FW_PSM_ARQLEN_ARQENABLE_M		BIT(31)
#define PF0_FW_PSM_ARQT				0x000804C4 /* Reset Source: EMPR */
#define PF0_FW_PSM_ARQT_ARQT_S			0
#define PF0_FW_PSM_ARQT_ARQT_M			MAKEMASK(0x3FF, 0)
#define PF0_FW_PSM_ATQBAH			0x00080144 /* Reset Source: EMPR */
#define PF0_FW_PSM_ATQBAH_ATQBAH_S		0
#define PF0_FW_PSM_ATQBAH_ATQBAH_M		MAKEMASK(0xFFFFFFFF, 0)
#define PF0_FW_PSM_ATQBAL			0x00080044 /* Reset Source: EMPR */
#define PF0_FW_PSM_ATQBAL_ATQBAL_LSB_S		0
#define PF0_FW_PSM_ATQBAL_ATQBAL_LSB_M		MAKEMASK(0x3F, 0)
#define PF0_FW_PSM_ATQBAL_ATQBAL_S		6
#define PF0_FW_PSM_ATQBAL_ATQBAL_M		MAKEMASK(0x3FFFFFF, 6)
#define PF0_FW_PSM_ATQH				0x00080344 /* Reset Source: EMPR */
#define PF0_FW_PSM_ATQH_ATQH_S			0
#define PF0_FW_PSM_ATQH_ATQH_M			MAKEMASK(0x3FF, 0)
#define PF0_FW_PSM_ATQLEN			0x00080244 /* Reset Source: EMPR */
#define PF0_FW_PSM_ATQLEN_ATQLEN_S		0
#define PF0_FW_PSM_ATQLEN_ATQLEN_M		MAKEMASK(0x3FF, 0)
#define PF0_FW_PSM_ATQLEN_ATQVFE_S		28
#define PF0_FW_PSM_ATQLEN_ATQVFE_M		BIT(28)
#define PF0_FW_PSM_ATQLEN_ATQOVFL_S		29
#define PF0_FW_PSM_ATQLEN_ATQOVFL_M		BIT(29)
#define PF0_FW_PSM_ATQLEN_ATQCRIT_S		30
#define PF0_FW_PSM_ATQLEN_ATQCRIT_M		BIT(30)
#define PF0_FW_PSM_ATQLEN_ATQENABLE_S		31
#define PF0_FW_PSM_ATQLEN_ATQENABLE_M		BIT(31)
#define PF0_FW_PSM_ATQT				0x00080444 /* Reset Source: EMPR */
#define PF0_FW_PSM_ATQT_ATQT_S			0
#define PF0_FW_PSM_ATQT_ATQT_M			MAKEMASK(0x3FF, 0)
#define PF0_MBX_CPM_ARQBAH			0x0022E5D8 /* Reset Source: CORER */
#define PF0_MBX_CPM_ARQBAH_ARQBAH_S		0
#define PF0_MBX_CPM_ARQBAH_ARQBAH_M		MAKEMASK(0xFFFFFFFF, 0)
#define PF0_MBX_CPM_ARQBAL			0x0022E5D4 /* Reset Source: CORER */
#define PF0_MBX_CPM_ARQBAL_ARQBAL_LSB_S		0
#define PF0_MBX_CPM_ARQBAL_ARQBAL_LSB_M		MAKEMASK(0x3F, 0)
#define PF0_MBX_CPM_ARQBAL_ARQBAL_S		6
#define PF0_MBX_CPM_ARQBAL_ARQBAL_M		MAKEMASK(0x3FFFFFF, 6)
#define PF0_MBX_CPM_ARQH			0x0022E5E0 /* Reset Source: CORER */
#define PF0_MBX_CPM_ARQH_ARQH_S			0
#define PF0_MBX_CPM_ARQH_ARQH_M			MAKEMASK(0x3FF, 0)
#define PF0_MBX_CPM_ARQLEN			0x0022E5DC /* Reset Source: PFR */
#define PF0_MBX_CPM_ARQLEN_ARQLEN_S		0
#define PF0_MBX_CPM_ARQLEN_ARQLEN_M		MAKEMASK(0x3FF, 0)
#define PF0_MBX_CPM_ARQLEN_ARQVFE_S		28
#define PF0_MBX_CPM_ARQLEN_ARQVFE_M		BIT(28)
#define PF0_MBX_CPM_ARQLEN_ARQOVFL_S		29
#define PF0_MBX_CPM_ARQLEN_ARQOVFL_M		BIT(29)
#define PF0_MBX_CPM_ARQLEN_ARQCRIT_S		30
#define PF0_MBX_CPM_ARQLEN_ARQCRIT_M		BIT(30)
#define PF0_MBX_CPM_ARQLEN_ARQENABLE_S		31
#define PF0_MBX_CPM_ARQLEN_ARQENABLE_M		BIT(31)
#define PF0_MBX_CPM_ARQT			0x0022E5E4 /* Reset Source: CORER */
#define PF0_MBX_CPM_ARQT_ARQT_S			0
#define PF0_MBX_CPM_ARQT_ARQT_M			MAKEMASK(0x3FF, 0)
#define PF0_MBX_CPM_ATQBAH			0x0022E5C4 /* Reset Source: CORER */
#define PF0_MBX_CPM_ATQBAH_ATQBAH_S		0
#define PF0_MBX_CPM_ATQBAH_ATQBAH_M		MAKEMASK(0xFFFFFFFF, 0)
#define PF0_MBX_CPM_ATQBAL			0x0022E5C0 /* Reset Source: CORER */
#define PF0_MBX_CPM_ATQBAL_ATQBAL_S		6
#define PF0_MBX_CPM_ATQBAL_ATQBAL_M		MAKEMASK(0x3FFFFFF, 6)
#define PF0_MBX_CPM_ATQH			0x0022E5CC /* Reset Source: CORER */
#define PF0_MBX_CPM_ATQH_ATQH_S			0
#define PF0_MBX_CPM_ATQH_ATQH_M			MAKEMASK(0x3FF, 0)
#define PF0_MBX_CPM_ATQLEN			0x0022E5C8 /* Reset Source: PFR */
#define PF0_MBX_CPM_ATQLEN_ATQLEN_S		0
#define PF0_MBX_CPM_ATQLEN_ATQLEN_M		MAKEMASK(0x3FF, 0)
#define PF0_MBX_CPM_ATQLEN_ATQVFE_S		28
#define PF0_MBX_CPM_ATQLEN_ATQVFE_M		BIT(28)
#define PF0_MBX_CPM_ATQLEN_ATQOVFL_S		29
#define PF0_MBX_CPM_ATQLEN_ATQOVFL_M		BIT(29)
#define PF0_MBX_CPM_ATQLEN_ATQCRIT_S		30
#define PF0_MBX_CPM_ATQLEN_ATQCRIT_M		BIT(30)
#define PF0_MBX_CPM_ATQLEN_ATQENABLE_S		31
#define PF0_MBX_CPM_ATQLEN_ATQENABLE_M		BIT(31)
#define PF0_MBX_CPM_ATQT			0x0022E5D0 /* Reset Source: CORER */
#define PF0_MBX_CPM_ATQT_ATQT_S			0
#define PF0_MBX_CPM_ATQT_ATQT_M			MAKEMASK(0x3FF, 0)
#define PF0_MBX_HLP_ARQBAH			0x0022E600 /* Reset Source: CORER */
#define PF0_MBX_HLP_ARQBAH_ARQBAH_S		0
#define PF0_MBX_HLP_ARQBAH_ARQBAH_M		MAKEMASK(0xFFFFFFFF, 0)
#define PF0_MBX_HLP_ARQBAL			0x0022E5FC /* Reset Source: CORER */
#define PF0_MBX_HLP_ARQBAL_ARQBAL_LSB_S		0
#define PF0_MBX_HLP_ARQBAL_ARQBAL_LSB_M		MAKEMASK(0x3F, 0)
#define PF0_MBX_HLP_ARQBAL_ARQBAL_S		6
#define PF0_MBX_HLP_ARQBAL_ARQBAL_M		MAKEMASK(0x3FFFFFF, 6)
#define PF0_MBX_HLP_ARQH			0x0022E608 /* Reset Source: CORER */
#define PF0_MBX_HLP_ARQH_ARQH_S			0
#define PF0_MBX_HLP_ARQH_ARQH_M			MAKEMASK(0x3FF, 0)
#define PF0_MBX_HLP_ARQLEN			0x0022E604 /* Reset Source: PFR */
#define PF0_MBX_HLP_ARQLEN_ARQLEN_S		0
#define PF0_MBX_HLP_ARQLEN_ARQLEN_M		MAKEMASK(0x3FF, 0)
#define PF0_MBX_HLP_ARQLEN_ARQVFE_S		28
#define PF0_MBX_HLP_ARQLEN_ARQVFE_M		BIT(28)
#define PF0_MBX_HLP_ARQLEN_ARQOVFL_S		29
#define PF0_MBX_HLP_ARQLEN_ARQOVFL_M		BIT(29)
#define PF0_MBX_HLP_ARQLEN_ARQCRIT_S		30
#define PF0_MBX_HLP_ARQLEN_ARQCRIT_M		BIT(30)
#define PF0_MBX_HLP_ARQLEN_ARQENABLE_S		31
#define PF0_MBX_HLP_ARQLEN_ARQENABLE_M		BIT(31)
#define PF0_MBX_HLP_ARQT			0x0022E60C /* Reset Source: CORER */
#define PF0_MBX_HLP_ARQT_ARQT_S			0
#define PF0_MBX_HLP_ARQT_ARQT_M			MAKEMASK(0x3FF, 0)
#define PF0_MBX_HLP_ATQBAH			0x0022E5EC /* Reset Source: CORER */
#define PF0_MBX_HLP_ATQBAH_ATQBAH_S		0
#define PF0_MBX_HLP_ATQBAH_ATQBAH_M		MAKEMASK(0xFFFFFFFF, 0)
#define PF0_MBX_HLP_ATQBAL			0x0022E5E8 /* Reset Source: CORER */
#define PF0_MBX_HLP_ATQBAL_ATQBAL_S		6
#define PF0_MBX_HLP_ATQBAL_ATQBAL_M		MAKEMASK(0x3FFFFFF, 6)
#define PF0_MBX_HLP_ATQH			0x0022E5F4 /* Reset Source: CORER */
#define PF0_MBX_HLP_ATQH_ATQH_S			0
#define PF0_MBX_HLP_ATQH_ATQH_M			MAKEMASK(0x3FF, 0)
#define PF0_MBX_HLP_ATQLEN			0x0022E5F0 /* Reset Source: PFR */
#define PF0_MBX_HLP_ATQLEN_ATQLEN_S		0
#define PF0_MBX_HLP_ATQLEN_ATQLEN_M		MAKEMASK(0x3FF, 0)
#define PF0_MBX_HLP_ATQLEN_ATQVFE_S		28
#define PF0_MBX_HLP_ATQLEN_ATQVFE_M		BIT(28)
#define PF0_MBX_HLP_ATQLEN_ATQOVFL_S		29
#define PF0_MBX_HLP_ATQLEN_ATQOVFL_M		BIT(29)
#define PF0_MBX_HLP_ATQLEN_ATQCRIT_S		30
#define PF0_MBX_HLP_ATQLEN_ATQCRIT_M		BIT(30)
#define PF0_MBX_HLP_ATQLEN_ATQENABLE_S		31
#define PF0_MBX_HLP_ATQLEN_ATQENABLE_M		BIT(31)
#define PF0_MBX_HLP_ATQT			0x0022E5F8 /* Reset Source: CORER */
#define PF0_MBX_HLP_ATQT_ATQT_S			0
#define PF0_MBX_HLP_ATQT_ATQT_M			MAKEMASK(0x3FF, 0)
#define PF0_MBX_PSM_ARQBAH			0x0022E628 /* Reset Source: CORER */
#define PF0_MBX_PSM_ARQBAH_ARQBAH_S		0
#define PF0_MBX_PSM_ARQBAH_ARQBAH_M		MAKEMASK(0xFFFFFFFF, 0)
#define PF0_MBX_PSM_ARQBAL			0x0022E624 /* Reset Source: CORER */
#define PF0_MBX_PSM_ARQBAL_ARQBAL_LSB_S		0
#define PF0_MBX_PSM_ARQBAL_ARQBAL_LSB_M		MAKEMASK(0x3F, 0)
#define PF0_MBX_PSM_ARQBAL_ARQBAL_S		6
#define PF0_MBX_PSM_ARQBAL_ARQBAL_M		MAKEMASK(0x3FFFFFF, 6)
#define PF0_MBX_PSM_ARQH			0x0022E630 /* Reset Source: CORER */
#define PF0_MBX_PSM_ARQH_ARQH_S			0
#define PF0_MBX_PSM_ARQH_ARQH_M			MAKEMASK(0x3FF, 0)
#define PF0_MBX_PSM_ARQLEN			0x0022E62C /* Reset Source: PFR */
#define PF0_MBX_PSM_ARQLEN_ARQLEN_S		0
#define PF0_MBX_PSM_ARQLEN_ARQLEN_M		MAKEMASK(0x3FF, 0)
#define PF0_MBX_PSM_ARQLEN_ARQVFE_S		28
#define PF0_MBX_PSM_ARQLEN_ARQVFE_M		BIT(28)
#define PF0_MBX_PSM_ARQLEN_ARQOVFL_S		29
#define PF0_MBX_PSM_ARQLEN_ARQOVFL_M		BIT(29)
#define PF0_MBX_PSM_ARQLEN_ARQCRIT_S		30
#define PF0_MBX_PSM_ARQLEN_ARQCRIT_M		BIT(30)
#define PF0_MBX_PSM_ARQLEN_ARQENABLE_S		31
#define PF0_MBX_PSM_ARQLEN_ARQENABLE_M		BIT(31)
#define PF0_MBX_PSM_ARQT			0x0022E634 /* Reset Source: CORER */
#define PF0_MBX_PSM_ARQT_ARQT_S			0
#define PF0_MBX_PSM_ARQT_ARQT_M			MAKEMASK(0x3FF, 0)
#define PF0_MBX_PSM_ATQBAH			0x0022E614 /* Reset Source: CORER */
#define PF0_MBX_PSM_ATQBAH_ATQBAH_S		0
#define PF0_MBX_PSM_ATQBAH_ATQBAH_M		MAKEMASK(0xFFFFFFFF, 0)
#define PF0_MBX_PSM_ATQBAL			0x0022E610 /* Reset Source: CORER */
#define PF0_MBX_PSM_ATQBAL_ATQBAL_S		6
#define PF0_MBX_PSM_ATQBAL_ATQBAL_M		MAKEMASK(0x3FFFFFF, 6)
#define PF0_MBX_PSM_ATQH			0x0022E61C /* Reset Source: CORER */
#define PF0_MBX_PSM_ATQH_ATQH_S			0
#define PF0_MBX_PSM_ATQH_ATQH_M			MAKEMASK(0x3FF, 0)
#define PF0_MBX_PSM_ATQLEN			0x0022E618 /* Reset Source: PFR */
#define PF0_MBX_PSM_ATQLEN_ATQLEN_S		0
#define PF0_MBX_PSM_ATQLEN_ATQLEN_M		MAKEMASK(0x3FF, 0)
#define PF0_MBX_PSM_ATQLEN_ATQVFE_S		28
#define PF0_MBX_PSM_ATQLEN_ATQVFE_M		BIT(28)
#define PF0_MBX_PSM_ATQLEN_ATQOVFL_S		29
#define PF0_MBX_PSM_ATQLEN_ATQOVFL_M		BIT(29)
#define PF0_MBX_PSM_ATQLEN_ATQCRIT_S		30
#define PF0_MBX_PSM_ATQLEN_ATQCRIT_M		BIT(30)
#define PF0_MBX_PSM_ATQLEN_ATQENABLE_S		31
#define PF0_MBX_PSM_ATQLEN_ATQENABLE_M		BIT(31)
#define PF0_MBX_PSM_ATQT			0x0022E620 /* Reset Source: CORER */
#define PF0_MBX_PSM_ATQT_ATQT_S			0
#define PF0_MBX_PSM_ATQT_ATQT_M			MAKEMASK(0x3FF, 0)
#define PF0_SB_CPM_ARQBAH			0x0022E650 /* Reset Source: CORER */
#define PF0_SB_CPM_ARQBAH_ARQBAH_S		0
#define PF0_SB_CPM_ARQBAH_ARQBAH_M		MAKEMASK(0xFFFFFFFF, 0)
#define PF0_SB_CPM_ARQBAL			0x0022E64C /* Reset Source: CORER */
#define PF0_SB_CPM_ARQBAL_ARQBAL_LSB_S		0
#define PF0_SB_CPM_ARQBAL_ARQBAL_LSB_M		MAKEMASK(0x3F, 0)
#define PF0_SB_CPM_ARQBAL_ARQBAL_S		6
#define PF0_SB_CPM_ARQBAL_ARQBAL_M		MAKEMASK(0x3FFFFFF, 6)
#define PF0_SB_CPM_ARQH				0x0022E658 /* Reset Source: CORER */
#define PF0_SB_CPM_ARQH_ARQH_S			0
#define PF0_SB_CPM_ARQH_ARQH_M			MAKEMASK(0x3FF, 0)
#define PF0_SB_CPM_ARQLEN			0x0022E654 /* Reset Source: PFR */
#define PF0_SB_CPM_ARQLEN_ARQLEN_S		0
#define PF0_SB_CPM_ARQLEN_ARQLEN_M		MAKEMASK(0x3FF, 0)
#define PF0_SB_CPM_ARQLEN_ARQVFE_S		28
#define PF0_SB_CPM_ARQLEN_ARQVFE_M		BIT(28)
#define PF0_SB_CPM_ARQLEN_ARQOVFL_S		29
#define PF0_SB_CPM_ARQLEN_ARQOVFL_M		BIT(29)
#define PF0_SB_CPM_ARQLEN_ARQCRIT_S		30
#define PF0_SB_CPM_ARQLEN_ARQCRIT_M		BIT(30)
#define PF0_SB_CPM_ARQLEN_ARQENABLE_S		31
#define PF0_SB_CPM_ARQLEN_ARQENABLE_M		BIT(31)
#define PF0_SB_CPM_ARQT				0x0022E65C /* Reset Source: CORER */
#define PF0_SB_CPM_ARQT_ARQT_S			0
#define PF0_SB_CPM_ARQT_ARQT_M			MAKEMASK(0x3FF, 0)
#define PF0_SB_CPM_ATQBAH			0x0022E63C /* Reset Source: CORER */
#define PF0_SB_CPM_ATQBAH_ATQBAH_S		0
#define PF0_SB_CPM_ATQBAH_ATQBAH_M		MAKEMASK(0xFFFFFFFF, 0)
#define PF0_SB_CPM_ATQBAL			0x0022E638 /* Reset Source: CORER */
#define PF0_SB_CPM_ATQBAL_ATQBAL_S		6
#define PF0_SB_CPM_ATQBAL_ATQBAL_M		MAKEMASK(0x3FFFFFF, 6)
#define PF0_SB_CPM_ATQH				0x0022E644 /* Reset Source: CORER */
#define PF0_SB_CPM_ATQH_ATQH_S			0
#define PF0_SB_CPM_ATQH_ATQH_M			MAKEMASK(0x3FF, 0)
#define PF0_SB_CPM_ATQLEN			0x0022E640 /* Reset Source: PFR */
#define PF0_SB_CPM_ATQLEN_ATQLEN_S		0
#define PF0_SB_CPM_ATQLEN_ATQLEN_M		MAKEMASK(0x3FF, 0)
#define PF0_SB_CPM_ATQLEN_ATQVFE_S		28
#define PF0_SB_CPM_ATQLEN_ATQVFE_M		BIT(28)
#define PF0_SB_CPM_ATQLEN_ATQOVFL_S		29
#define PF0_SB_CPM_ATQLEN_ATQOVFL_M		BIT(29)
#define PF0_SB_CPM_ATQLEN_ATQCRIT_S		30
#define PF0_SB_CPM_ATQLEN_ATQCRIT_M		BIT(30)
#define PF0_SB_CPM_ATQLEN_ATQENABLE_S		31
#define PF0_SB_CPM_ATQLEN_ATQENABLE_M		BIT(31)
#define PF0_SB_CPM_ATQT				0x0022E648 /* Reset Source: CORER */
#define PF0_SB_CPM_ATQT_ATQT_S			0
#define PF0_SB_CPM_ATQT_ATQT_M			MAKEMASK(0x3FF, 0)
#define PF0_SB_CPM_REM_DEV_CTL			0x002300F4 /* Reset Source: CORER */
#define PF0_SB_CPM_REM_DEV_CTL_DEST_EN_S	0
#define PF0_SB_CPM_REM_DEV_CTL_DEST_EN_M	MAKEMASK(0xFFFF, 0)
#define PF0_SB_HLP_ARQBAH			0x002300D8 /* Reset Source: CORER */
#define PF0_SB_HLP_ARQBAH_ARQBAH_S		0
#define PF0_SB_HLP_ARQBAH_ARQBAH_M		MAKEMASK(0xFFFFFFFF, 0)
#define PF0_SB_HLP_ARQBAL			0x002300D4 /* Reset Source: CORER */
#define PF0_SB_HLP_ARQBAL_ARQBAL_LSB_S		0
#define PF0_SB_HLP_ARQBAL_ARQBAL_LSB_M		MAKEMASK(0x3F, 0)
#define PF0_SB_HLP_ARQBAL_ARQBAL_S		6
#define PF0_SB_HLP_ARQBAL_ARQBAL_M		MAKEMASK(0x3FFFFFF, 6)
#define PF0_SB_HLP_ARQH				0x002300E0 /* Reset Source: CORER */
#define PF0_SB_HLP_ARQH_ARQH_S			0
#define PF0_SB_HLP_ARQH_ARQH_M			MAKEMASK(0x3FF, 0)
#define PF0_SB_HLP_ARQLEN			0x002300DC /* Reset Source: PFR */
#define PF0_SB_HLP_ARQLEN_ARQLEN_S		0
#define PF0_SB_HLP_ARQLEN_ARQLEN_M		MAKEMASK(0x3FF, 0)
#define PF0_SB_HLP_ARQLEN_ARQVFE_S		28
#define PF0_SB_HLP_ARQLEN_ARQVFE_M		BIT(28)
#define PF0_SB_HLP_ARQLEN_ARQOVFL_S		29
#define PF0_SB_HLP_ARQLEN_ARQOVFL_M		BIT(29)
#define PF0_SB_HLP_ARQLEN_ARQCRIT_S		30
#define PF0_SB_HLP_ARQLEN_ARQCRIT_M		BIT(30)
#define PF0_SB_HLP_ARQLEN_ARQENABLE_S		31
#define PF0_SB_HLP_ARQLEN_ARQENABLE_M		BIT(31)
#define PF0_SB_HLP_ARQT				0x002300E4 /* Reset Source: CORER */
#define PF0_SB_HLP_ARQT_ARQT_S			0
#define PF0_SB_HLP_ARQT_ARQT_M			MAKEMASK(0x3FF, 0)
#define PF0_SB_HLP_ATQBAH			0x002300C4 /* Reset Source: CORER */
#define PF0_SB_HLP_ATQBAH_ATQBAH_S		0
#define PF0_SB_HLP_ATQBAH_ATQBAH_M		MAKEMASK(0xFFFFFFFF, 0)
#define PF0_SB_HLP_ATQBAL			0x002300C0 /* Reset Source: CORER */
#define PF0_SB_HLP_ATQBAL_ATQBAL_S		6
#define PF0_SB_HLP_ATQBAL_ATQBAL_M		MAKEMASK(0x3FFFFFF, 6)
#define PF0_SB_HLP_ATQH				0x002300CC /* Reset Source: CORER */
#define PF0_SB_HLP_ATQH_ATQH_S			0
#define PF0_SB_HLP_ATQH_ATQH_M			MAKEMASK(0x3FF, 0)
#define PF0_SB_HLP_ATQLEN			0x002300C8 /* Reset Source: PFR */
#define PF0_SB_HLP_ATQLEN_ATQLEN_S		0
#define PF0_SB_HLP_ATQLEN_ATQLEN_M		MAKEMASK(0x3FF, 0)
#define PF0_SB_HLP_ATQLEN_ATQVFE_S		28
#define PF0_SB_HLP_ATQLEN_ATQVFE_M		BIT(28)
#define PF0_SB_HLP_ATQLEN_ATQOVFL_S		29
#define PF0_SB_HLP_ATQLEN_ATQOVFL_M		BIT(29)
#define PF0_SB_HLP_ATQLEN_ATQCRIT_S		30
#define PF0_SB_HLP_ATQLEN_ATQCRIT_M		BIT(30)
#define PF0_SB_HLP_ATQLEN_ATQENABLE_S		31
#define PF0_SB_HLP_ATQLEN_ATQENABLE_M		BIT(31)
#define PF0_SB_HLP_ATQT				0x002300D0 /* Reset Source: CORER */
#define PF0_SB_HLP_ATQT_ATQT_S			0
#define PF0_SB_HLP_ATQT_ATQT_M			MAKEMASK(0x3FF, 0)
#define PF0_SB_HLP_REM_DEV_CTL			0x002300E8 /* Reset Source: CORER */
#define PF0_SB_HLP_REM_DEV_CTL_DEST_EN_S	0
#define PF0_SB_HLP_REM_DEV_CTL_DEST_EN_M	MAKEMASK(0xFFFF, 0)
#define SB_REM_DEV_DEST(_i)			(0x002300F8 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define SB_REM_DEV_DEST_MAX_INDEX		7
#define SB_REM_DEV_DEST_DEST_S			0
#define SB_REM_DEV_DEST_DEST_M			MAKEMASK(0xF, 0)
#define SB_REM_DEV_DEST_DEST_VALID_S		31
#define SB_REM_DEV_DEST_DEST_VALID_M		BIT(31)
#define VF_MBX_ARQBAH(_VF)			(0x0022B800 + ((_VF) * 4)) /* _i=0...255 */ /* Reset Source: CORER */
#define VF_MBX_ARQBAH_MAX_INDEX			255
#define VF_MBX_ARQBAH_ARQBAH_S			0
#define VF_MBX_ARQBAH_ARQBAH_M			MAKEMASK(0xFFFFFFFF, 0)
#define VF_MBX_ARQBAL(_VF)			(0x0022B400 + ((_VF) * 4)) /* _i=0...255 */ /* Reset Source: CORER */
#define VF_MBX_ARQBAL_MAX_INDEX			255
#define VF_MBX_ARQBAL_ARQBAL_LSB_S		0
#define VF_MBX_ARQBAL_ARQBAL_LSB_M		MAKEMASK(0x3F, 0)
#define VF_MBX_ARQBAL_ARQBAL_S			6
#define VF_MBX_ARQBAL_ARQBAL_M			MAKEMASK(0x3FFFFFF, 6)
#define VF_MBX_ARQH(_VF)			(0x0022C000 + ((_VF) * 4)) /* _i=0...255 */ /* Reset Source: CORER */
#define VF_MBX_ARQH_MAX_INDEX			255
#define VF_MBX_ARQH_ARQH_S			0
#define VF_MBX_ARQH_ARQH_M			MAKEMASK(0x3FF, 0)
#define VF_MBX_ARQLEN(_VF)			(0x0022BC00 + ((_VF) * 4)) /* _i=0...255 */ /* Reset Source: PFR */
#define VF_MBX_ARQLEN_MAX_INDEX			255
#define VF_MBX_ARQLEN_ARQLEN_S			0
#define VF_MBX_ARQLEN_ARQLEN_M			MAKEMASK(0x3FF, 0)
#define VF_MBX_ARQLEN_ARQVFE_S			28
#define VF_MBX_ARQLEN_ARQVFE_M			BIT(28)
#define VF_MBX_ARQLEN_ARQOVFL_S			29
#define VF_MBX_ARQLEN_ARQOVFL_M			BIT(29)
#define VF_MBX_ARQLEN_ARQCRIT_S			30
#define VF_MBX_ARQLEN_ARQCRIT_M			BIT(30)
#define VF_MBX_ARQLEN_ARQENABLE_S		31
#define VF_MBX_ARQLEN_ARQENABLE_M		BIT(31)
#define VF_MBX_ARQT(_VF)			(0x0022C400 + ((_VF) * 4)) /* _i=0...255 */ /* Reset Source: CORER */
#define VF_MBX_ARQT_MAX_INDEX			255
#define VF_MBX_ARQT_ARQT_S			0
#define VF_MBX_ARQT_ARQT_M			MAKEMASK(0x3FF, 0)
#define VF_MBX_ATQBAH(_VF)			(0x0022A400 + ((_VF) * 4)) /* _i=0...255 */ /* Reset Source: CORER */
#define VF_MBX_ATQBAH_MAX_INDEX			255
#define VF_MBX_ATQBAH_ATQBAH_S			0
#define VF_MBX_ATQBAH_ATQBAH_M			MAKEMASK(0xFFFFFFFF, 0)
#define VF_MBX_ATQBAL(_VF)			(0x0022A000 + ((_VF) * 4)) /* _i=0...255 */ /* Reset Source: CORER */
#define VF_MBX_ATQBAL_MAX_INDEX			255
#define VF_MBX_ATQBAL_ATQBAL_S			6
#define VF_MBX_ATQBAL_ATQBAL_M			MAKEMASK(0x3FFFFFF, 6)
#define VF_MBX_ATQH(_VF)			(0x0022AC00 + ((_VF) * 4)) /* _i=0...255 */ /* Reset Source: CORER */
#define VF_MBX_ATQH_MAX_INDEX			255
#define VF_MBX_ATQH_ATQH_S			0
#define VF_MBX_ATQH_ATQH_M			MAKEMASK(0x3FF, 0)
#define VF_MBX_ATQLEN(_VF)			(0x0022A800 + ((_VF) * 4)) /* _i=0...255 */ /* Reset Source: PFR */
#define VF_MBX_ATQLEN_MAX_INDEX			255
#define VF_MBX_ATQLEN_ATQLEN_S			0
#define VF_MBX_ATQLEN_ATQLEN_M			MAKEMASK(0x3FF, 0)
#define VF_MBX_ATQLEN_ATQVFE_S			28
#define VF_MBX_ATQLEN_ATQVFE_M			BIT(28)
#define VF_MBX_ATQLEN_ATQOVFL_S			29
#define VF_MBX_ATQLEN_ATQOVFL_M			BIT(29)
#define VF_MBX_ATQLEN_ATQCRIT_S			30
#define VF_MBX_ATQLEN_ATQCRIT_M			BIT(30)
#define VF_MBX_ATQLEN_ATQENABLE_S		31
#define VF_MBX_ATQLEN_ATQENABLE_M		BIT(31)
#define VF_MBX_ATQT(_VF)			(0x0022B000 + ((_VF) * 4)) /* _i=0...255 */ /* Reset Source: CORER */
#define VF_MBX_ATQT_MAX_INDEX			255
#define VF_MBX_ATQT_ATQT_S			0
#define VF_MBX_ATQT_ATQT_M			MAKEMASK(0x3FF, 0)
#define VF_MBX_CPM_ARQBAH(_VF128)		(0x0022D400 + ((_VF128) * 4)) /* _i=0...127 */ /* Reset Source: CORER */
#define VF_MBX_CPM_ARQBAH_MAX_INDEX		127
#define VF_MBX_CPM_ARQBAH_ARQBAH_S		0
#define VF_MBX_CPM_ARQBAH_ARQBAH_M		MAKEMASK(0xFFFFFFFF, 0)
#define VF_MBX_CPM_ARQBAL(_VF128)		(0x0022D200 + ((_VF128) * 4)) /* _i=0...127 */ /* Reset Source: CORER */
#define VF_MBX_CPM_ARQBAL_MAX_INDEX		127
#define VF_MBX_CPM_ARQBAL_ARQBAL_LSB_S		0
#define VF_MBX_CPM_ARQBAL_ARQBAL_LSB_M		MAKEMASK(0x3F, 0)
#define VF_MBX_CPM_ARQBAL_ARQBAL_S		6
#define VF_MBX_CPM_ARQBAL_ARQBAL_M		MAKEMASK(0x3FFFFFF, 6)
#define VF_MBX_CPM_ARQH(_VF128)			(0x0022D800 + ((_VF128) * 4)) /* _i=0...127 */ /* Reset Source: CORER */
#define VF_MBX_CPM_ARQH_MAX_INDEX		127
#define VF_MBX_CPM_ARQH_ARQH_S			0
#define VF_MBX_CPM_ARQH_ARQH_M			MAKEMASK(0x3FF, 0)
#define VF_MBX_CPM_ARQLEN(_VF128)		(0x0022D600 + ((_VF128) * 4)) /* _i=0...127 */ /* Reset Source: PFR */
#define VF_MBX_CPM_ARQLEN_MAX_INDEX		127
#define VF_MBX_CPM_ARQLEN_ARQLEN_S		0
#define VF_MBX_CPM_ARQLEN_ARQLEN_M		MAKEMASK(0x3FF, 0)
#define VF_MBX_CPM_ARQLEN_ARQVFE_S		28
#define VF_MBX_CPM_ARQLEN_ARQVFE_M		BIT(28)
#define VF_MBX_CPM_ARQLEN_ARQOVFL_S		29
#define VF_MBX_CPM_ARQLEN_ARQOVFL_M		BIT(29)
#define VF_MBX_CPM_ARQLEN_ARQCRIT_S		30
#define VF_MBX_CPM_ARQLEN_ARQCRIT_M		BIT(30)
#define VF_MBX_CPM_ARQLEN_ARQENABLE_S		31
#define VF_MBX_CPM_ARQLEN_ARQENABLE_M		BIT(31)
#define VF_MBX_CPM_ARQT(_VF128)			(0x0022DA00 + ((_VF128) * 4)) /* _i=0...127 */ /* Reset Source: CORER */
#define VF_MBX_CPM_ARQT_MAX_INDEX		127
#define VF_MBX_CPM_ARQT_ARQT_S			0
#define VF_MBX_CPM_ARQT_ARQT_M			MAKEMASK(0x3FF, 0)
#define VF_MBX_CPM_ATQBAH(_VF128)		(0x0022CA00 + ((_VF128) * 4)) /* _i=0...127 */ /* Reset Source: CORER */
#define VF_MBX_CPM_ATQBAH_MAX_INDEX		127
#define VF_MBX_CPM_ATQBAH_ATQBAH_S		0
#define VF_MBX_CPM_ATQBAH_ATQBAH_M		MAKEMASK(0xFFFFFFFF, 0)
#define VF_MBX_CPM_ATQBAL(_VF128)		(0x0022C800 + ((_VF128) * 4)) /* _i=0...127 */ /* Reset Source: CORER */
#define VF_MBX_CPM_ATQBAL_MAX_INDEX		127
#define VF_MBX_CPM_ATQBAL_ATQBAL_S		6
#define VF_MBX_CPM_ATQBAL_ATQBAL_M		MAKEMASK(0x3FFFFFF, 6)
#define VF_MBX_CPM_ATQH(_VF128)			(0x0022CE00 + ((_VF128) * 4)) /* _i=0...127 */ /* Reset Source: CORER */
#define VF_MBX_CPM_ATQH_MAX_INDEX		127
#define VF_MBX_CPM_ATQH_ATQH_S			0
#define VF_MBX_CPM_ATQH_ATQH_M			MAKEMASK(0x3FF, 0)
#define VF_MBX_CPM_ATQLEN(_VF128)		(0x0022CC00 + ((_VF128) * 4)) /* _i=0...127 */ /* Reset Source: PFR */
#define VF_MBX_CPM_ATQLEN_MAX_INDEX		127
#define VF_MBX_CPM_ATQLEN_ATQLEN_S		0
#define VF_MBX_CPM_ATQLEN_ATQLEN_M		MAKEMASK(0x3FF, 0)
#define VF_MBX_CPM_ATQLEN_ATQVFE_S		28
#define VF_MBX_CPM_ATQLEN_ATQVFE_M		BIT(28)
#define VF_MBX_CPM_ATQLEN_ATQOVFL_S		29
#define VF_MBX_CPM_ATQLEN_ATQOVFL_M		BIT(29)
#define VF_MBX_CPM_ATQLEN_ATQCRIT_S		30
#define VF_MBX_CPM_ATQLEN_ATQCRIT_M		BIT(30)
#define VF_MBX_CPM_ATQLEN_ATQENABLE_S		31
#define VF_MBX_CPM_ATQLEN_ATQENABLE_M		BIT(31)
#define VF_MBX_CPM_ATQT(_VF128)			(0x0022D000 + ((_VF128) * 4)) /* _i=0...127 */ /* Reset Source: CORER */
#define VF_MBX_CPM_ATQT_MAX_INDEX		127
#define VF_MBX_CPM_ATQT_ATQT_S			0
#define VF_MBX_CPM_ATQT_ATQT_M			MAKEMASK(0x3FF, 0)
#define VF_MBX_HLP_ARQBAH(_VF16)		(0x0022DD80 + ((_VF16) * 4)) /* _i=0...15 */ /* Reset Source: CORER */
#define VF_MBX_HLP_ARQBAH_MAX_INDEX		15
#define VF_MBX_HLP_ARQBAH_ARQBAH_S		0
#define VF_MBX_HLP_ARQBAH_ARQBAH_M		MAKEMASK(0xFFFFFFFF, 0)
#define VF_MBX_HLP_ARQBAL(_VF16)		(0x0022DD40 + ((_VF16) * 4)) /* _i=0...15 */ /* Reset Source: CORER */
#define VF_MBX_HLP_ARQBAL_MAX_INDEX		15
#define VF_MBX_HLP_ARQBAL_ARQBAL_LSB_S		0
#define VF_MBX_HLP_ARQBAL_ARQBAL_LSB_M		MAKEMASK(0x3F, 0)
#define VF_MBX_HLP_ARQBAL_ARQBAL_S		6
#define VF_MBX_HLP_ARQBAL_ARQBAL_M		MAKEMASK(0x3FFFFFF, 6)
#define VF_MBX_HLP_ARQH(_VF16)			(0x0022DE00 + ((_VF16) * 4)) /* _i=0...15 */ /* Reset Source: CORER */
#define VF_MBX_HLP_ARQH_MAX_INDEX		15
#define VF_MBX_HLP_ARQH_ARQH_S			0
#define VF_MBX_HLP_ARQH_ARQH_M			MAKEMASK(0x3FF, 0)
#define VF_MBX_HLP_ARQLEN(_VF16)		(0x0022DDC0 + ((_VF16) * 4)) /* _i=0...15 */ /* Reset Source: PFR */
#define VF_MBX_HLP_ARQLEN_MAX_INDEX		15
#define VF_MBX_HLP_ARQLEN_ARQLEN_S		0
#define VF_MBX_HLP_ARQLEN_ARQLEN_M		MAKEMASK(0x3FF, 0)
#define VF_MBX_HLP_ARQLEN_ARQVFE_S		28
#define VF_MBX_HLP_ARQLEN_ARQVFE_M		BIT(28)
#define VF_MBX_HLP_ARQLEN_ARQOVFL_S		29
#define VF_MBX_HLP_ARQLEN_ARQOVFL_M		BIT(29)
#define VF_MBX_HLP_ARQLEN_ARQCRIT_S		30
#define VF_MBX_HLP_ARQLEN_ARQCRIT_M		BIT(30)
#define VF_MBX_HLP_ARQLEN_ARQENABLE_S		31
#define VF_MBX_HLP_ARQLEN_ARQENABLE_M		BIT(31)
#define VF_MBX_HLP_ARQT(_VF16)			(0x0022DE40 + ((_VF16) * 4)) /* _i=0...15 */ /* Reset Source: CORER */
#define VF_MBX_HLP_ARQT_MAX_INDEX		15
#define VF_MBX_HLP_ARQT_ARQT_S			0
#define VF_MBX_HLP_ARQT_ARQT_M			MAKEMASK(0x3FF, 0)
#define VF_MBX_HLP_ATQBAH(_VF16)		(0x0022DC40 + ((_VF16) * 4)) /* _i=0...15 */ /* Reset Source: CORER */
#define VF_MBX_HLP_ATQBAH_MAX_INDEX		15
#define VF_MBX_HLP_ATQBAH_ATQBAH_S		0
#define VF_MBX_HLP_ATQBAH_ATQBAH_M		MAKEMASK(0xFFFFFFFF, 0)
#define VF_MBX_HLP_ATQBAL(_VF16)		(0x0022DC00 + ((_VF16) * 4)) /* _i=0...15 */ /* Reset Source: CORER */
#define VF_MBX_HLP_ATQBAL_MAX_INDEX		15
#define VF_MBX_HLP_ATQBAL_ATQBAL_S		6
#define VF_MBX_HLP_ATQBAL_ATQBAL_M		MAKEMASK(0x3FFFFFF, 6)
#define VF_MBX_HLP_ATQH(_VF16)			(0x0022DCC0 + ((_VF16) * 4)) /* _i=0...15 */ /* Reset Source: CORER */
#define VF_MBX_HLP_ATQH_MAX_INDEX		15
#define VF_MBX_HLP_ATQH_ATQH_S			0
#define VF_MBX_HLP_ATQH_ATQH_M			MAKEMASK(0x3FF, 0)
#define VF_MBX_HLP_ATQLEN(_VF16)		(0x0022DC80 + ((_VF16) * 4)) /* _i=0...15 */ /* Reset Source: PFR */
#define VF_MBX_HLP_ATQLEN_MAX_INDEX		15
#define VF_MBX_HLP_ATQLEN_ATQLEN_S		0
#define VF_MBX_HLP_ATQLEN_ATQLEN_M		MAKEMASK(0x3FF, 0)
#define VF_MBX_HLP_ATQLEN_ATQVFE_S		28
#define VF_MBX_HLP_ATQLEN_ATQVFE_M		BIT(28)
#define VF_MBX_HLP_ATQLEN_ATQOVFL_S		29
#define VF_MBX_HLP_ATQLEN_ATQOVFL_M		BIT(29)
#define VF_MBX_HLP_ATQLEN_ATQCRIT_S		30
#define VF_MBX_HLP_ATQLEN_ATQCRIT_M		BIT(30)
#define VF_MBX_HLP_ATQLEN_ATQENABLE_S		31
#define VF_MBX_HLP_ATQLEN_ATQENABLE_M		BIT(31)
#define VF_MBX_HLP_ATQT(_VF16)			(0x0022DD00 + ((_VF16) * 4)) /* _i=0...15 */ /* Reset Source: CORER */
#define VF_MBX_HLP_ATQT_MAX_INDEX		15
#define VF_MBX_HLP_ATQT_ATQT_S			0
#define VF_MBX_HLP_ATQT_ATQT_M			MAKEMASK(0x3FF, 0)
#define VF_MBX_PSM_ARQBAH(_VF16)		(0x0022E000 + ((_VF16) * 4)) /* _i=0...15 */ /* Reset Source: CORER */
#define VF_MBX_PSM_ARQBAH_MAX_INDEX		15
#define VF_MBX_PSM_ARQBAH_ARQBAH_S		0
#define VF_MBX_PSM_ARQBAH_ARQBAH_M		MAKEMASK(0xFFFFFFFF, 0)
#define VF_MBX_PSM_ARQBAL(_VF16)		(0x0022DFC0 + ((_VF16) * 4)) /* _i=0...15 */ /* Reset Source: CORER */
#define VF_MBX_PSM_ARQBAL_MAX_INDEX		15
#define VF_MBX_PSM_ARQBAL_ARQBAL_LSB_S		0
#define VF_MBX_PSM_ARQBAL_ARQBAL_LSB_M		MAKEMASK(0x3F, 0)
#define VF_MBX_PSM_ARQBAL_ARQBAL_S		6
#define VF_MBX_PSM_ARQBAL_ARQBAL_M		MAKEMASK(0x3FFFFFF, 6)
#define VF_MBX_PSM_ARQH(_VF16)			(0x0022E080 + ((_VF16) * 4)) /* _i=0...15 */ /* Reset Source: CORER */
#define VF_MBX_PSM_ARQH_MAX_INDEX		15
#define VF_MBX_PSM_ARQH_ARQH_S			0
#define VF_MBX_PSM_ARQH_ARQH_M			MAKEMASK(0x3FF, 0)
#define VF_MBX_PSM_ARQLEN(_VF16)		(0x0022E040 + ((_VF16) * 4)) /* _i=0...15 */ /* Reset Source: PFR */
#define VF_MBX_PSM_ARQLEN_MAX_INDEX		15
#define VF_MBX_PSM_ARQLEN_ARQLEN_S		0
#define VF_MBX_PSM_ARQLEN_ARQLEN_M		MAKEMASK(0x3FF, 0)
#define VF_MBX_PSM_ARQLEN_ARQVFE_S		28
#define VF_MBX_PSM_ARQLEN_ARQVFE_M		BIT(28)
#define VF_MBX_PSM_ARQLEN_ARQOVFL_S		29
#define VF_MBX_PSM_ARQLEN_ARQOVFL_M		BIT(29)
#define VF_MBX_PSM_ARQLEN_ARQCRIT_S		30
#define VF_MBX_PSM_ARQLEN_ARQCRIT_M		BIT(30)
#define VF_MBX_PSM_ARQLEN_ARQENABLE_S		31
#define VF_MBX_PSM_ARQLEN_ARQENABLE_M		BIT(31)
#define VF_MBX_PSM_ARQT(_VF16)			(0x0022E0C0 + ((_VF16) * 4)) /* _i=0...15 */ /* Reset Source: CORER */
#define VF_MBX_PSM_ARQT_MAX_INDEX		15
#define VF_MBX_PSM_ARQT_ARQT_S			0
#define VF_MBX_PSM_ARQT_ARQT_M			MAKEMASK(0x3FF, 0)
#define VF_MBX_PSM_ATQBAH(_VF16)		(0x0022DEC0 + ((_VF16) * 4)) /* _i=0...15 */ /* Reset Source: CORER */
#define VF_MBX_PSM_ATQBAH_MAX_INDEX		15
#define VF_MBX_PSM_ATQBAH_ATQBAH_S		0
#define VF_MBX_PSM_ATQBAH_ATQBAH_M		MAKEMASK(0xFFFFFFFF, 0)
#define VF_MBX_PSM_ATQBAL(_VF16)		(0x0022DE80 + ((_VF16) * 4)) /* _i=0...15 */ /* Reset Source: CORER */
#define VF_MBX_PSM_ATQBAL_MAX_INDEX		15
#define VF_MBX_PSM_ATQBAL_ATQBAL_S		6
#define VF_MBX_PSM_ATQBAL_ATQBAL_M		MAKEMASK(0x3FFFFFF, 6)
#define VF_MBX_PSM_ATQH(_VF16)			(0x0022DF40 + ((_VF16) * 4)) /* _i=0...15 */ /* Reset Source: CORER */
#define VF_MBX_PSM_ATQH_MAX_INDEX		15
#define VF_MBX_PSM_ATQH_ATQH_S			0
#define VF_MBX_PSM_ATQH_ATQH_M			MAKEMASK(0x3FF, 0)
#define VF_MBX_PSM_ATQLEN(_VF16)		(0x0022DF00 + ((_VF16) * 4)) /* _i=0...15 */ /* Reset Source: PFR */
#define VF_MBX_PSM_ATQLEN_MAX_INDEX		15
#define VF_MBX_PSM_ATQLEN_ATQLEN_S		0
#define VF_MBX_PSM_ATQLEN_ATQLEN_M		MAKEMASK(0x3FF, 0)
#define VF_MBX_PSM_ATQLEN_ATQVFE_S		28
#define VF_MBX_PSM_ATQLEN_ATQVFE_M		BIT(28)
#define VF_MBX_PSM_ATQLEN_ATQOVFL_S		29
#define VF_MBX_PSM_ATQLEN_ATQOVFL_M		BIT(29)
#define VF_MBX_PSM_ATQLEN_ATQCRIT_S		30
#define VF_MBX_PSM_ATQLEN_ATQCRIT_M		BIT(30)
#define VF_MBX_PSM_ATQLEN_ATQENABLE_S		31
#define VF_MBX_PSM_ATQLEN_ATQENABLE_M		BIT(31)
#define VF_MBX_PSM_ATQT(_VF16)			(0x0022DF80 + ((_VF16) * 4)) /* _i=0...15 */ /* Reset Source: CORER */
#define VF_MBX_PSM_ATQT_MAX_INDEX		15
#define VF_MBX_PSM_ATQT_ATQT_S			0
#define VF_MBX_PSM_ATQT_ATQT_M			MAKEMASK(0x3FF, 0)
#define VF_SB_CPM_ARQBAH(_VF128)		(0x0022F400 + ((_VF128) * 4)) /* _i=0...127 */ /* Reset Source: CORER */
#define VF_SB_CPM_ARQBAH_MAX_INDEX		127
#define VF_SB_CPM_ARQBAH_ARQBAH_S		0
#define VF_SB_CPM_ARQBAH_ARQBAH_M		MAKEMASK(0xFFFFFFFF, 0)
#define VF_SB_CPM_ARQBAL(_VF128)		(0x0022F200 + ((_VF128) * 4)) /* _i=0...127 */ /* Reset Source: CORER */
#define VF_SB_CPM_ARQBAL_MAX_INDEX		127
#define VF_SB_CPM_ARQBAL_ARQBAL_LSB_S		0
#define VF_SB_CPM_ARQBAL_ARQBAL_LSB_M		MAKEMASK(0x3F, 0)
#define VF_SB_CPM_ARQBAL_ARQBAL_S		6
#define VF_SB_CPM_ARQBAL_ARQBAL_M		MAKEMASK(0x3FFFFFF, 6)
#define VF_SB_CPM_ARQH(_VF128)			(0x0022F800 + ((_VF128) * 4)) /* _i=0...127 */ /* Reset Source: CORER */
#define VF_SB_CPM_ARQH_MAX_INDEX		127
#define VF_SB_CPM_ARQH_ARQH_S			0
#define VF_SB_CPM_ARQH_ARQH_M			MAKEMASK(0x3FF, 0)
#define VF_SB_CPM_ARQLEN(_VF128)		(0x0022F600 + ((_VF128) * 4)) /* _i=0...127 */ /* Reset Source: PFR */
#define VF_SB_CPM_ARQLEN_MAX_INDEX		127
#define VF_SB_CPM_ARQLEN_ARQLEN_S		0
#define VF_SB_CPM_ARQLEN_ARQLEN_M		MAKEMASK(0x3FF, 0)
#define VF_SB_CPM_ARQLEN_ARQVFE_S		28
#define VF_SB_CPM_ARQLEN_ARQVFE_M		BIT(28)
#define VF_SB_CPM_ARQLEN_ARQOVFL_S		29
#define VF_SB_CPM_ARQLEN_ARQOVFL_M		BIT(29)
#define VF_SB_CPM_ARQLEN_ARQCRIT_S		30
#define VF_SB_CPM_ARQLEN_ARQCRIT_M		BIT(30)
#define VF_SB_CPM_ARQLEN_ARQENABLE_S		31
#define VF_SB_CPM_ARQLEN_ARQENABLE_M		BIT(31)
#define VF_SB_CPM_ARQT(_VF128)			(0x0022FA00 + ((_VF128) * 4)) /* _i=0...127 */ /* Reset Source: CORER */
#define VF_SB_CPM_ARQT_MAX_INDEX		127
#define VF_SB_CPM_ARQT_ARQT_S			0
#define VF_SB_CPM_ARQT_ARQT_M			MAKEMASK(0x3FF, 0)
#define VF_SB_CPM_ATQBAH(_VF128)		(0x0022EA00 + ((_VF128) * 4)) /* _i=0...127 */ /* Reset Source: CORER */
#define VF_SB_CPM_ATQBAH_MAX_INDEX		127
#define VF_SB_CPM_ATQBAH_ATQBAH_S		0
#define VF_SB_CPM_ATQBAH_ATQBAH_M		MAKEMASK(0xFFFFFFFF, 0)
#define VF_SB_CPM_ATQBAL(_VF128)		(0x0022E800 + ((_VF128) * 4)) /* _i=0...127 */ /* Reset Source: CORER */
#define VF_SB_CPM_ATQBAL_MAX_INDEX		127
#define VF_SB_CPM_ATQBAL_ATQBAL_S		6
#define VF_SB_CPM_ATQBAL_ATQBAL_M		MAKEMASK(0x3FFFFFF, 6)
#define VF_SB_CPM_ATQH(_VF128)			(0x0022EE00 + ((_VF128) * 4)) /* _i=0...127 */ /* Reset Source: CORER */
#define VF_SB_CPM_ATQH_MAX_INDEX		127
#define VF_SB_CPM_ATQH_ATQH_S			0
#define VF_SB_CPM_ATQH_ATQH_M			MAKEMASK(0x3FF, 0)
#define VF_SB_CPM_ATQLEN(_VF128)		(0x0022EC00 + ((_VF128) * 4)) /* _i=0...127 */ /* Reset Source: PFR */
#define VF_SB_CPM_ATQLEN_MAX_INDEX		127
#define VF_SB_CPM_ATQLEN_ATQLEN_S		0
#define VF_SB_CPM_ATQLEN_ATQLEN_M		MAKEMASK(0x3FF, 0)
#define VF_SB_CPM_ATQLEN_ATQVFE_S		28
#define VF_SB_CPM_ATQLEN_ATQVFE_M		BIT(28)
#define VF_SB_CPM_ATQLEN_ATQOVFL_S		29
#define VF_SB_CPM_ATQLEN_ATQOVFL_M		BIT(29)
#define VF_SB_CPM_ATQLEN_ATQCRIT_S		30
#define VF_SB_CPM_ATQLEN_ATQCRIT_M		BIT(30)
#define VF_SB_CPM_ATQLEN_ATQENABLE_S		31
#define VF_SB_CPM_ATQLEN_ATQENABLE_M		BIT(31)
#define VF_SB_CPM_ATQT(_VF128)			(0x0022F000 + ((_VF128) * 4)) /* _i=0...127 */ /* Reset Source: CORER */
#define VF_SB_CPM_ATQT_MAX_INDEX		127
#define VF_SB_CPM_ATQT_ATQT_S			0
#define VF_SB_CPM_ATQT_ATQT_M			MAKEMASK(0x3FF, 0)
#define VF_SB_CPM_REM_DEV_CTL			0x002300EC /* Reset Source: CORER */
#define VF_SB_CPM_REM_DEV_CTL_DEST_EN_S		0
#define VF_SB_CPM_REM_DEV_CTL_DEST_EN_M		MAKEMASK(0xFFFF, 0)
#define VP_MBX_CPM_PF_VF_CTRL(_VP128)		(0x00231800 + ((_VP128) * 4)) /* _i=0...127 */ /* Reset Source: CORER */
#define VP_MBX_CPM_PF_VF_CTRL_MAX_INDEX		127
#define VP_MBX_CPM_PF_VF_CTRL_QUEUE_EN_S	0
#define VP_MBX_CPM_PF_VF_CTRL_QUEUE_EN_M	BIT(0)
#define VP_MBX_HLP_PF_VF_CTRL(_VP16)		(0x00231A00 + ((_VP16) * 4)) /* _i=0...15 */ /* Reset Source: CORER */
#define VP_MBX_HLP_PF_VF_CTRL_MAX_INDEX		15
#define VP_MBX_HLP_PF_VF_CTRL_QUEUE_EN_S	0
#define VP_MBX_HLP_PF_VF_CTRL_QUEUE_EN_M	BIT(0)
#define VP_MBX_PF_VF_CTRL(_VSI)			(0x00230800 + ((_VSI) * 4)) /* _i=0...767 */ /* Reset Source: CORER */
#define VP_MBX_PF_VF_CTRL_MAX_INDEX		767
#define VP_MBX_PF_VF_CTRL_QUEUE_EN_S		0
#define VP_MBX_PF_VF_CTRL_QUEUE_EN_M		BIT(0)
#define VP_MBX_PSM_PF_VF_CTRL(_VP16)		(0x00231A40 + ((_VP16) * 4)) /* _i=0...15 */ /* Reset Source: CORER */
#define VP_MBX_PSM_PF_VF_CTRL_MAX_INDEX		15
#define VP_MBX_PSM_PF_VF_CTRL_QUEUE_EN_S	0
#define VP_MBX_PSM_PF_VF_CTRL_QUEUE_EN_M	BIT(0)
#define VP_SB_CPM_PF_VF_CTRL(_VP128)		(0x00231C00 + ((_VP128) * 4)) /* _i=0...127 */ /* Reset Source: CORER */
#define VP_SB_CPM_PF_VF_CTRL_MAX_INDEX		127
#define VP_SB_CPM_PF_VF_CTRL_QUEUE_EN_S		0
#define VP_SB_CPM_PF_VF_CTRL_QUEUE_EN_M		BIT(0)
#define GL_DCB_TDSCP2TC_BLOCK_DIS		0x00049218 /* Reset Source: CORER */
#define GL_DCB_TDSCP2TC_BLOCK_DIS_DSCP2TC_BLOCK_DIS_S 0
#define GL_DCB_TDSCP2TC_BLOCK_DIS_DSCP2TC_BLOCK_DIS_M BIT(0)
#define GL_DCB_TDSCP2TC_BLOCK_IPV4(_i)		(0x00049018 + ((_i) * 4)) /* _i=0...63 */ /* Reset Source: CORER */
#define GL_DCB_TDSCP2TC_BLOCK_IPV4_MAX_INDEX	63
#define GL_DCB_TDSCP2TC_BLOCK_IPV4_TC_BLOCK_LUT_S 0
#define GL_DCB_TDSCP2TC_BLOCK_IPV4_TC_BLOCK_LUT_M MAKEMASK(0xFFFFFFFF, 0)
#define GL_DCB_TDSCP2TC_BLOCK_IPV6(_i)		(0x00049118 + ((_i) * 4)) /* _i=0...63 */ /* Reset Source: CORER */
#define GL_DCB_TDSCP2TC_BLOCK_IPV6_MAX_INDEX	63
#define GL_DCB_TDSCP2TC_BLOCK_IPV6_TC_BLOCK_LUT_S 0
#define GL_DCB_TDSCP2TC_BLOCK_IPV6_TC_BLOCK_LUT_M MAKEMASK(0xFFFFFFFF, 0)
#define GLDCB_GENC				0x00083044 /* Reset Source: CORER */
#define GLDCB_GENC_PCIRTT_S			0
#define GLDCB_GENC_PCIRTT_M			MAKEMASK(0xFFFF, 0)
#define GLDCB_PRS_RETSTCC(_i)			(0x002000B0 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLDCB_PRS_RETSTCC_MAX_INDEX		31
#define GLDCB_PRS_RETSTCC_BWSHARE_S		0
#define GLDCB_PRS_RETSTCC_BWSHARE_M		MAKEMASK(0x7F, 0)
#define GLDCB_PRS_RETSTCC_ETSTC_S		31
#define GLDCB_PRS_RETSTCC_ETSTC_M		BIT(31)
#define GLDCB_PRS_RSPMC				0x00200160 /* Reset Source: CORER */
#define GLDCB_PRS_RSPMC_RSPM_S			0
#define GLDCB_PRS_RSPMC_RSPM_M			MAKEMASK(0xFF, 0)
#define GLDCB_PRS_RSPMC_RPM_MODE_S		8
#define GLDCB_PRS_RSPMC_RPM_MODE_M		MAKEMASK(0x3, 8)
#define GLDCB_PRS_RSPMC_PRR_MAX_EXP_S		10
#define GLDCB_PRS_RSPMC_PRR_MAX_EXP_M		MAKEMASK(0xF, 10)
#define GLDCB_PRS_RSPMC_PFCTIMER_S		14
#define GLDCB_PRS_RSPMC_PFCTIMER_M		MAKEMASK(0x3FFF, 14)
#define GLDCB_PRS_RSPMC_RPM_DIS_S		31
#define GLDCB_PRS_RSPMC_RPM_DIS_M		BIT(31)
#define GLDCB_RETSTCC(_i)			(0x00122140 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLDCB_RETSTCC_MAX_INDEX			31
#define GLDCB_RETSTCC_BWSHARE_S			0
#define GLDCB_RETSTCC_BWSHARE_M			MAKEMASK(0x7F, 0)
#define GLDCB_RETSTCC_ETSTC_S			31
#define GLDCB_RETSTCC_ETSTC_M			BIT(31)
#define GLDCB_RETSTCS(_i)			(0x001221C0 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLDCB_RETSTCS_MAX_INDEX			31
#define GLDCB_RETSTCS_CREDITS_S			0
#define GLDCB_RETSTCS_CREDITS_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLDCB_RTC2PFC_RCB			0x00122100 /* Reset Source: CORER */
#define GLDCB_RTC2PFC_RCB_TC2PFC_S		0
#define GLDCB_RTC2PFC_RCB_TC2PFC_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLDCB_SWT_RETSTCC(_i)			(0x0020A040 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLDCB_SWT_RETSTCC_MAX_INDEX		31
#define GLDCB_SWT_RETSTCC_BWSHARE_S		0
#define GLDCB_SWT_RETSTCC_BWSHARE_M		MAKEMASK(0x7F, 0)
#define GLDCB_SWT_RETSTCC_ETSTC_S		31
#define GLDCB_SWT_RETSTCC_ETSTC_M		BIT(31)
#define GLDCB_TC2PFC				0x001D2694 /* Reset Source: CORER */
#define GLDCB_TC2PFC_TC2PFC_S			0
#define GLDCB_TC2PFC_TC2PFC_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLDCB_TCB_MNG_SP			0x000AE12C /* Reset Source: CORER */
#define GLDCB_TCB_MNG_SP_MNG_SP_S		0
#define GLDCB_TCB_MNG_SP_MNG_SP_M		BIT(0)
#define GLDCB_TCB_TCLL_CFG			0x000AE134 /* Reset Source: CORER */
#define GLDCB_TCB_TCLL_CFG_LLTC_S		0
#define GLDCB_TCB_TCLL_CFG_LLTC_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLDCB_TCB_WB_SP				0x000AE310 /* Reset Source: CORER */
#define GLDCB_TCB_WB_SP_WB_SP_S			0
#define GLDCB_TCB_WB_SP_WB_SP_M			BIT(0)
#define GLDCB_TCUPM_IMM_EN			0x000BC824 /* Reset Source: CORER */
#define GLDCB_TCUPM_IMM_EN_IMM_EN_S		0
#define GLDCB_TCUPM_IMM_EN_IMM_EN_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLDCB_TCUPM_LEGACY_TC			0x000BC828 /* Reset Source: CORER */
#define GLDCB_TCUPM_LEGACY_TC_LEGTC_S		0
#define GLDCB_TCUPM_LEGACY_TC_LEGTC_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLDCB_TCUPM_NO_EXCEED_DIS		0x000BC830 /* Reset Source: CORER */
#define GLDCB_TCUPM_NO_EXCEED_DIS_NON_EXCEED_DIS_S 0
#define GLDCB_TCUPM_NO_EXCEED_DIS_NON_EXCEED_DIS_M BIT(0)
#define GLDCB_TCUPM_WB_DIS			0x000BC834 /* Reset Source: CORER */
#define GLDCB_TCUPM_WB_DIS_PORT_DISABLE_S	0
#define GLDCB_TCUPM_WB_DIS_PORT_DISABLE_M	BIT(0)
#define GLDCB_TCUPM_WB_DIS_TC_DISABLE_S		1
#define GLDCB_TCUPM_WB_DIS_TC_DISABLE_M		BIT(1)
#define GLDCB_TFPFCI				0x0009949C /* Reset Source: CORER */
#define GLDCB_TFPFCI_GLDCB_TFPFCI_S		0
#define GLDCB_TFPFCI_GLDCB_TFPFCI_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLDCB_TLPM_IMM_TCB			0x000A0190 /* Reset Source: CORER */
#define GLDCB_TLPM_IMM_TCB_IMM_EN_S		0
#define GLDCB_TLPM_IMM_TCB_IMM_EN_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLDCB_TLPM_IMM_TCUPM			0x000A018C /* Reset Source: CORER */
#define GLDCB_TLPM_IMM_TCUPM_IMM_EN_S		0
#define GLDCB_TLPM_IMM_TCUPM_IMM_EN_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLDCB_TLPM_PCI_DM			0x000A0180 /* Reset Source: CORER */
#define GLDCB_TLPM_PCI_DM_MONITOR_S		0
#define GLDCB_TLPM_PCI_DM_MONITOR_M		MAKEMASK(0x7FFFF, 0)
#define GLDCB_TLPM_PCI_DTHR			0x000A0184 /* Reset Source: CORER */
#define GLDCB_TLPM_PCI_DTHR_PCI_TDATA_S		0
#define GLDCB_TLPM_PCI_DTHR_PCI_TDATA_M		MAKEMASK(0xFFF, 0)
#define GLDCB_TPB_IMM_TLPM			0x00099468 /* Reset Source: CORER */
#define GLDCB_TPB_IMM_TLPM_IMM_EN_S		0
#define GLDCB_TPB_IMM_TLPM_IMM_EN_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLDCB_TPB_IMM_TPB			0x0009946C /* Reset Source: CORER */
#define GLDCB_TPB_IMM_TPB_IMM_EN_S		0
#define GLDCB_TPB_IMM_TPB_IMM_EN_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLDCB_TPB_TCLL_CFG			0x00099464 /* Reset Source: CORER */
#define GLDCB_TPB_TCLL_CFG_LLTC_S		0
#define GLDCB_TPB_TCLL_CFG_LLTC_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLTCB_BULK_DWRR_REG_QUANTA		0x000AE0E0 /* Reset Source: CORER */
#define GLTCB_BULK_DWRR_REG_QUANTA_QUANTA_S	0
#define GLTCB_BULK_DWRR_REG_QUANTA_QUANTA_M	MAKEMASK(0x7FF, 0)
#define GLTCB_BULK_DWRR_REG_SAT			0x000AE0F0 /* Reset Source: CORER */
#define GLTCB_BULK_DWRR_REG_SAT_SATURATION_S	0
#define GLTCB_BULK_DWRR_REG_SAT_SATURATION_M	MAKEMASK(0x1FFFF, 0)
#define GLTCB_BULK_DWRR_WB_QUANTA		0x000AE0E4 /* Reset Source: CORER */
#define GLTCB_BULK_DWRR_WB_QUANTA_QUANTA_S	0
#define GLTCB_BULK_DWRR_WB_QUANTA_QUANTA_M	MAKEMASK(0x7FF, 0)
#define GLTCB_BULK_DWRR_WB_SAT			0x000AE0F4 /* Reset Source: CORER */
#define GLTCB_BULK_DWRR_WB_SAT_SATURATION_S	0
#define GLTCB_BULK_DWRR_WB_SAT_SATURATION_M	MAKEMASK(0x1FFFF, 0)
#define GLTCB_CREDIT_EXP_CTL			0x000AE120 /* Reset Source: CORER */
#define GLTCB_CREDIT_EXP_CTL_EN_S		0
#define GLTCB_CREDIT_EXP_CTL_EN_M		BIT(0)
#define GLTCB_CREDIT_EXP_CTL_MIN_PKT_S		1
#define GLTCB_CREDIT_EXP_CTL_MIN_PKT_M		MAKEMASK(0x1FF, 1)
#define GLTCB_LL_DWRR_REG_QUANTA		0x000AE0E8 /* Reset Source: CORER */
#define GLTCB_LL_DWRR_REG_QUANTA_QUANTA_S	0
#define GLTCB_LL_DWRR_REG_QUANTA_QUANTA_M	MAKEMASK(0x7FF, 0)
#define GLTCB_LL_DWRR_REG_SAT			0x000AE0F8 /* Reset Source: CORER */
#define GLTCB_LL_DWRR_REG_SAT_SATURATION_S	0
#define GLTCB_LL_DWRR_REG_SAT_SATURATION_M	MAKEMASK(0x1FFFF, 0)
#define GLTCB_LL_DWRR_WB_QUANTA			0x000AE0EC /* Reset Source: CORER */
#define GLTCB_LL_DWRR_WB_QUANTA_QUANTA_S	0
#define GLTCB_LL_DWRR_WB_QUANTA_QUANTA_M	MAKEMASK(0x7FF, 0)
#define GLTCB_LL_DWRR_WB_SAT			0x000AE0FC /* Reset Source: CORER */
#define GLTCB_LL_DWRR_WB_SAT_SATURATION_S	0
#define GLTCB_LL_DWRR_WB_SAT_SATURATION_M	MAKEMASK(0x1FFFF, 0)
#define GLTCB_WB_RL				0x000AE238 /* Reset Source: CORER */
#define GLTCB_WB_RL_PERIOD_S			0
#define GLTCB_WB_RL_PERIOD_M			MAKEMASK(0xFFFF, 0)
#define GLTCB_WB_RL_EN_S			16
#define GLTCB_WB_RL_EN_M			BIT(16)
#define GLTPB_WB_RL				0x00099460 /* Reset Source: CORER */
#define GLTPB_WB_RL_PERIOD_S			0
#define GLTPB_WB_RL_PERIOD_M			MAKEMASK(0xFFFF, 0)
#define GLTPB_WB_RL_EN_S			16
#define GLTPB_WB_RL_EN_M			BIT(16)
#define PRTDCB_FCCFG				0x001E4640 /* Reset Source: GLOBR */
#define PRTDCB_FCCFG_TFCE_S			3
#define PRTDCB_FCCFG_TFCE_M			MAKEMASK(0x3, 3)
#define PRTDCB_FCRTV				0x001E4600 /* Reset Source: GLOBR */
#define PRTDCB_FCRTV_FC_REFRESH_TH_S		0
#define PRTDCB_FCRTV_FC_REFRESH_TH_M		MAKEMASK(0xFFFF, 0)
#define PRTDCB_FCTTVN(_i)			(0x001E4580 + ((_i) * 32)) /* _i=0...3 */ /* Reset Source: GLOBR */
#define PRTDCB_FCTTVN_MAX_INDEX			3
#define PRTDCB_FCTTVN_TTV_2N_S			0
#define PRTDCB_FCTTVN_TTV_2N_M			MAKEMASK(0xFFFF, 0)
#define PRTDCB_FCTTVN_TTV_2N_P1_S		16
#define PRTDCB_FCTTVN_TTV_2N_P1_M		MAKEMASK(0xFFFF, 16)
#define PRTDCB_GENC				0x00083000 /* Reset Source: CORER */
#define PRTDCB_GENC_NUMTC_S			2
#define PRTDCB_GENC_NUMTC_M			MAKEMASK(0xF, 2)
#define PRTDCB_GENC_FCOEUP_S			6
#define PRTDCB_GENC_FCOEUP_M			MAKEMASK(0x7, 6)
#define PRTDCB_GENC_FCOEUP_VALID_S		9
#define PRTDCB_GENC_FCOEUP_VALID_M		BIT(9)
#define PRTDCB_GENC_PFCLDA_S			16
#define PRTDCB_GENC_PFCLDA_M			MAKEMASK(0xFFFF, 16)
#define PRTDCB_GENS				0x00083020 /* Reset Source: CORER */
#define PRTDCB_GENS_DCBX_STATUS_S		0
#define PRTDCB_GENS_DCBX_STATUS_M		MAKEMASK(0x7, 0)
#define PRTDCB_PRS_RETSC			0x002001A0 /* Reset Source: CORER */
#define PRTDCB_PRS_RETSC_ETS_MODE_S		0
#define PRTDCB_PRS_RETSC_ETS_MODE_M		BIT(0)
#define PRTDCB_PRS_RETSC_NON_ETS_MODE_S		1
#define PRTDCB_PRS_RETSC_NON_ETS_MODE_M		BIT(1)
#define PRTDCB_PRS_RETSC_ETS_MAX_EXP_S		2
#define PRTDCB_PRS_RETSC_ETS_MAX_EXP_M		MAKEMASK(0xF, 2)
#define PRTDCB_PRS_RPRRC			0x00200180 /* Reset Source: CORER */
#define PRTDCB_PRS_RPRRC_BWSHARE_S		0
#define PRTDCB_PRS_RPRRC_BWSHARE_M		MAKEMASK(0x3FF, 0)
#define PRTDCB_PRS_RPRRC_BWSHARE_DIS_S		31
#define PRTDCB_PRS_RPRRC_BWSHARE_DIS_M		BIT(31)
#define PRTDCB_RETSC				0x001222A0 /* Reset Source: CORER */
#define PRTDCB_RETSC_ETS_MODE_S			0
#define PRTDCB_RETSC_ETS_MODE_M			BIT(0)
#define PRTDCB_RETSC_NON_ETS_MODE_S		1
#define PRTDCB_RETSC_NON_ETS_MODE_M		BIT(1)
#define PRTDCB_RETSC_ETS_MAX_EXP_S		2
#define PRTDCB_RETSC_ETS_MAX_EXP_M		MAKEMASK(0xF, 2)
#define PRTDCB_RPRRC				0x001220C0 /* Reset Source: CORER */
#define PRTDCB_RPRRC_BWSHARE_S			0
#define PRTDCB_RPRRC_BWSHARE_M			MAKEMASK(0x3FF, 0)
#define PRTDCB_RPRRC_BWSHARE_DIS_S		31
#define PRTDCB_RPRRC_BWSHARE_DIS_M		BIT(31)
#define PRTDCB_RPRRS				0x001220E0 /* Reset Source: CORER */
#define PRTDCB_RPRRS_CREDITS_S			0
#define PRTDCB_RPRRS_CREDITS_M			MAKEMASK(0xFFFFFFFF, 0)
#define PRTDCB_RUP_TDPU				0x00040960 /* Reset Source: CORER */
#define PRTDCB_RUP_TDPU_NOVLANUP_S		0
#define PRTDCB_RUP_TDPU_NOVLANUP_M		MAKEMASK(0x7, 0)
#define PRTDCB_RUP2TC				0x001D2640 /* Reset Source: CORER */
#define PRTDCB_RUP2TC_UP0TC_S			0
#define PRTDCB_RUP2TC_UP0TC_M			MAKEMASK(0x7, 0)
#define PRTDCB_RUP2TC_UP1TC_S			3
#define PRTDCB_RUP2TC_UP1TC_M			MAKEMASK(0x7, 3)
#define PRTDCB_RUP2TC_UP2TC_S			6
#define PRTDCB_RUP2TC_UP2TC_M			MAKEMASK(0x7, 6)
#define PRTDCB_RUP2TC_UP3TC_S			9
#define PRTDCB_RUP2TC_UP3TC_M			MAKEMASK(0x7, 9)
#define PRTDCB_RUP2TC_UP4TC_S			12
#define PRTDCB_RUP2TC_UP4TC_M			MAKEMASK(0x7, 12)
#define PRTDCB_RUP2TC_UP5TC_S			15
#define PRTDCB_RUP2TC_UP5TC_M			MAKEMASK(0x7, 15)
#define PRTDCB_RUP2TC_UP6TC_S			18
#define PRTDCB_RUP2TC_UP6TC_M			MAKEMASK(0x7, 18)
#define PRTDCB_RUP2TC_UP7TC_S			21
#define PRTDCB_RUP2TC_UP7TC_M			MAKEMASK(0x7, 21)
#define PRTDCB_SWT_RETSC			0x0020A140 /* Reset Source: CORER */
#define PRTDCB_SWT_RETSC_ETS_MODE_S		0
#define PRTDCB_SWT_RETSC_ETS_MODE_M		BIT(0)
#define PRTDCB_SWT_RETSC_NON_ETS_MODE_S		1
#define PRTDCB_SWT_RETSC_NON_ETS_MODE_M		BIT(1)
#define PRTDCB_SWT_RETSC_ETS_MAX_EXP_S		2
#define PRTDCB_SWT_RETSC_ETS_MAX_EXP_M		MAKEMASK(0xF, 2)
#define PRTDCB_TCB_DWRR_CREDITS			0x000AE000 /* Reset Source: CORER */
#define PRTDCB_TCB_DWRR_CREDITS_CREDITS_S	0
#define PRTDCB_TCB_DWRR_CREDITS_CREDITS_M	MAKEMASK(0x3FFFF, 0)
#define PRTDCB_TCB_DWRR_QUANTA			0x000AE020 /* Reset Source: CORER */
#define PRTDCB_TCB_DWRR_QUANTA_QUANTA_S		0
#define PRTDCB_TCB_DWRR_QUANTA_QUANTA_M		MAKEMASK(0x7FF, 0)
#define PRTDCB_TCB_DWRR_SAT			0x000AE040 /* Reset Source: CORER */
#define PRTDCB_TCB_DWRR_SAT_SATURATION_S	0
#define PRTDCB_TCB_DWRR_SAT_SATURATION_M	MAKEMASK(0x1FFFF, 0)
#define PRTDCB_TCUPM_NO_EXCEED_DM		0x000BC3C0 /* Reset Source: CORER */
#define PRTDCB_TCUPM_NO_EXCEED_DM_MONITOR_S	0
#define PRTDCB_TCUPM_NO_EXCEED_DM_MONITOR_M	MAKEMASK(0x7FFFF, 0)
#define PRTDCB_TCUPM_REG_CM			0x000BC360 /* Reset Source: CORER */
#define PRTDCB_TCUPM_REG_CM_MONITOR_S		0
#define PRTDCB_TCUPM_REG_CM_MONITOR_M		MAKEMASK(0x7FFF, 0)
#define PRTDCB_TCUPM_REG_CTHR			0x000BC380 /* Reset Source: CORER */
#define PRTDCB_TCUPM_REG_CTHR_PORTOFFTH_H_S	0
#define PRTDCB_TCUPM_REG_CTHR_PORTOFFTH_H_M	MAKEMASK(0x7FFF, 0)
#define PRTDCB_TCUPM_REG_CTHR_PORTOFFTH_L_S	15
#define PRTDCB_TCUPM_REG_CTHR_PORTOFFTH_L_M	MAKEMASK(0x7FFF, 15)
#define PRTDCB_TCUPM_REG_DM			0x000BC3A0 /* Reset Source: CORER */
#define PRTDCB_TCUPM_REG_DM_MONITOR_S		0
#define PRTDCB_TCUPM_REG_DM_MONITOR_M		MAKEMASK(0x7FFFF, 0)
#define PRTDCB_TCUPM_REG_DTHR			0x000BC3E0 /* Reset Source: CORER */
#define PRTDCB_TCUPM_REG_DTHR_PORTOFFTH_H_S	0
#define PRTDCB_TCUPM_REG_DTHR_PORTOFFTH_H_M	MAKEMASK(0xFFF, 0)
#define PRTDCB_TCUPM_REG_DTHR_PORTOFFTH_L_S	12
#define PRTDCB_TCUPM_REG_DTHR_PORTOFFTH_L_M	MAKEMASK(0xFFF, 12)
#define PRTDCB_TCUPM_REG_PE_HB_DM		0x000BC400 /* Reset Source: CORER */
#define PRTDCB_TCUPM_REG_PE_HB_DM_MONITOR_S	0
#define PRTDCB_TCUPM_REG_PE_HB_DM_MONITOR_M	MAKEMASK(0xFFF, 0)
#define PRTDCB_TCUPM_REG_PE_HB_DTHR		0x000BC420 /* Reset Source: CORER */
#define PRTDCB_TCUPM_REG_PE_HB_DTHR_PORTOFFTH_H_S 0
#define PRTDCB_TCUPM_REG_PE_HB_DTHR_PORTOFFTH_H_M MAKEMASK(0xFFF, 0)
#define PRTDCB_TCUPM_REG_PE_HB_DTHR_PORTOFFTH_L_S 12
#define PRTDCB_TCUPM_REG_PE_HB_DTHR_PORTOFFTH_L_M MAKEMASK(0xFFF, 12)
#define PRTDCB_TCUPM_WAIT_PFC_CM		0x000BC440 /* Reset Source: CORER */
#define PRTDCB_TCUPM_WAIT_PFC_CM_MONITOR_S	0
#define PRTDCB_TCUPM_WAIT_PFC_CM_MONITOR_M	MAKEMASK(0x7FFF, 0)
#define PRTDCB_TCUPM_WAIT_PFC_CTHR		0x000BC460 /* Reset Source: CORER */
#define PRTDCB_TCUPM_WAIT_PFC_CTHR_PORTOFFTH_S	0
#define PRTDCB_TCUPM_WAIT_PFC_CTHR_PORTOFFTH_M	MAKEMASK(0x7FFF, 0)
#define PRTDCB_TCUPM_WAIT_PFC_DM		0x000BC480 /* Reset Source: CORER */
#define PRTDCB_TCUPM_WAIT_PFC_DM_MONITOR_S	0
#define PRTDCB_TCUPM_WAIT_PFC_DM_MONITOR_M	MAKEMASK(0x7FFFF, 0)
#define PRTDCB_TCUPM_WAIT_PFC_DTHR		0x000BC4A0 /* Reset Source: CORER */
#define PRTDCB_TCUPM_WAIT_PFC_DTHR_PORTOFFTH_S	0
#define PRTDCB_TCUPM_WAIT_PFC_DTHR_PORTOFFTH_M	MAKEMASK(0xFFF, 0)
#define PRTDCB_TCUPM_WAIT_PFC_PE_HB_DM		0x000BC4C0 /* Reset Source: CORER */
#define PRTDCB_TCUPM_WAIT_PFC_PE_HB_DM_MONITOR_S 0
#define PRTDCB_TCUPM_WAIT_PFC_PE_HB_DM_MONITOR_M MAKEMASK(0xFFF, 0)
#define PRTDCB_TCUPM_WAIT_PFC_PE_HB_DTHR	0x000BC4E0 /* Reset Source: CORER */
#define PRTDCB_TCUPM_WAIT_PFC_PE_HB_DTHR_PORTOFFTH_S 0
#define PRTDCB_TCUPM_WAIT_PFC_PE_HB_DTHR_PORTOFFTH_M MAKEMASK(0xFFF, 0)
#define PRTDCB_TDPUC				0x00040940 /* Reset Source: CORER */
#define PRTDCB_TDPUC_MAX_TXFRAME_S		0
#define PRTDCB_TDPUC_MAX_TXFRAME_M		MAKEMASK(0xFFFF, 0)
#define PRTDCB_TDPUC_MAL_LENGTH_S		16
#define PRTDCB_TDPUC_MAL_LENGTH_M		BIT(16)
#define PRTDCB_TDPUC_MAL_CMD_S			17
#define PRTDCB_TDPUC_MAL_CMD_M			BIT(17)
#define PRTDCB_TDPUC_TTL_DROP_S			18
#define PRTDCB_TDPUC_TTL_DROP_M			BIT(18)
#define PRTDCB_TDPUC_UR_DROP_S			19
#define PRTDCB_TDPUC_UR_DROP_M			BIT(19)
#define PRTDCB_TDPUC_DUMMY_S			20
#define PRTDCB_TDPUC_DUMMY_M			BIT(20)
#define PRTDCB_TDPUC_BIG_PKT_SIZE_S		21
#define PRTDCB_TDPUC_BIG_PKT_SIZE_M		BIT(21)
#define PRTDCB_TDPUC_L2_ACCEPT_FAIL_S		22
#define PRTDCB_TDPUC_L2_ACCEPT_FAIL_M		BIT(22)
#define PRTDCB_TDPUC_DSCP_CHECK_FAIL_S		23
#define PRTDCB_TDPUC_DSCP_CHECK_FAIL_M		BIT(23)
#define PRTDCB_TDPUC_RCU_ANTISPOOF_S		24
#define PRTDCB_TDPUC_RCU_ANTISPOOF_M		BIT(24)
#define PRTDCB_TDPUC_NIC_DSI_S			25
#define PRTDCB_TDPUC_NIC_DSI_M			BIT(25)
#define PRTDCB_TDPUC_NIC_IPSEC_S		26
#define PRTDCB_TDPUC_NIC_IPSEC_M		BIT(26)
#define PRTDCB_TDPUC_CLEAR_DROP_S		31
#define PRTDCB_TDPUC_CLEAR_DROP_M		BIT(31)
#define PRTDCB_TFCS				0x001E4560 /* Reset Source: GLOBR */
#define PRTDCB_TFCS_TXOFF_S			0
#define PRTDCB_TFCS_TXOFF_M			BIT(0)
#define PRTDCB_TFCS_TXOFF0_S			8
#define PRTDCB_TFCS_TXOFF0_M			BIT(8)
#define PRTDCB_TFCS_TXOFF1_S			9
#define PRTDCB_TFCS_TXOFF1_M			BIT(9)
#define PRTDCB_TFCS_TXOFF2_S			10
#define PRTDCB_TFCS_TXOFF2_M			BIT(10)
#define PRTDCB_TFCS_TXOFF3_S			11
#define PRTDCB_TFCS_TXOFF3_M			BIT(11)
#define PRTDCB_TFCS_TXOFF4_S			12
#define PRTDCB_TFCS_TXOFF4_M			BIT(12)
#define PRTDCB_TFCS_TXOFF5_S			13
#define PRTDCB_TFCS_TXOFF5_M			BIT(13)
#define PRTDCB_TFCS_TXOFF6_S			14
#define PRTDCB_TFCS_TXOFF6_M			BIT(14)
#define PRTDCB_TFCS_TXOFF7_S			15
#define PRTDCB_TFCS_TXOFF7_M			BIT(15)
#define PRTDCB_TLPM_REG_DM			0x000A0000 /* Reset Source: CORER */
#define PRTDCB_TLPM_REG_DM_MONITOR_S		0
#define PRTDCB_TLPM_REG_DM_MONITOR_M		MAKEMASK(0x7FFFF, 0)
#define PRTDCB_TLPM_REG_DTHR			0x000A0020 /* Reset Source: CORER */
#define PRTDCB_TLPM_REG_DTHR_PORTOFFTH_H_S	0
#define PRTDCB_TLPM_REG_DTHR_PORTOFFTH_H_M	MAKEMASK(0xFFF, 0)
#define PRTDCB_TLPM_REG_DTHR_PORTOFFTH_L_S	12
#define PRTDCB_TLPM_REG_DTHR_PORTOFFTH_L_M	MAKEMASK(0xFFF, 12)
#define PRTDCB_TLPM_WAIT_PFC_DM			0x000A0040 /* Reset Source: CORER */
#define PRTDCB_TLPM_WAIT_PFC_DM_MONITOR_S	0
#define PRTDCB_TLPM_WAIT_PFC_DM_MONITOR_M	MAKEMASK(0x7FFFF, 0)
#define PRTDCB_TLPM_WAIT_PFC_DTHR		0x000A0060 /* Reset Source: CORER */
#define PRTDCB_TLPM_WAIT_PFC_DTHR_PORTOFFTH_S	0
#define PRTDCB_TLPM_WAIT_PFC_DTHR_PORTOFFTH_M	MAKEMASK(0xFFF, 0)
#define PRTDCB_TPFCTS(_i)			(0x001E4660 + ((_i) * 32)) /* _i=0...7 */ /* Reset Source: GLOBR */
#define PRTDCB_TPFCTS_MAX_INDEX			7
#define PRTDCB_TPFCTS_PFCTIMER_S		0
#define PRTDCB_TPFCTS_PFCTIMER_M		MAKEMASK(0x3FFF, 0)
#define PRTDCB_TUP2TC				0x001D26C0 /* Reset Source: CORER */
#define PRTDCB_TUP2TC_UP0TC_S			0
#define PRTDCB_TUP2TC_UP0TC_M			MAKEMASK(0x7, 0)
#define PRTDCB_TUP2TC_UP1TC_S			3
#define PRTDCB_TUP2TC_UP1TC_M			MAKEMASK(0x7, 3)
#define PRTDCB_TUP2TC_UP2TC_S			6
#define PRTDCB_TUP2TC_UP2TC_M			MAKEMASK(0x7, 6)
#define PRTDCB_TUP2TC_UP3TC_S			9
#define PRTDCB_TUP2TC_UP3TC_M			MAKEMASK(0x7, 9)
#define PRTDCB_TUP2TC_UP4TC_S			12
#define PRTDCB_TUP2TC_UP4TC_M			MAKEMASK(0x7, 12)
#define PRTDCB_TUP2TC_UP5TC_S			15
#define PRTDCB_TUP2TC_UP5TC_M			MAKEMASK(0x7, 15)
#define PRTDCB_TUP2TC_UP6TC_S			18
#define PRTDCB_TUP2TC_UP6TC_M			MAKEMASK(0x7, 18)
#define PRTDCB_TUP2TC_UP7TC_S			21
#define PRTDCB_TUP2TC_UP7TC_M			MAKEMASK(0x7, 21)
#define PRTDCB_TX_DSCP2UP_CTL			0x00040980 /* Reset Source: CORER */
#define PRTDCB_TX_DSCP2UP_CTL_DSCP2UP_ENA_S	0
#define PRTDCB_TX_DSCP2UP_CTL_DSCP2UP_ENA_M	BIT(0)
#define PRTDCB_TX_DSCP2UP_CTL_DSCP_DEFAULT_UP_S 1
#define PRTDCB_TX_DSCP2UP_CTL_DSCP_DEFAULT_UP_M MAKEMASK(0x7, 1)
#define PRTDCB_TX_DSCP2UP_IPV4_LUT(_i)		(0x000409A0 + ((_i) * 32)) /* _i=0...7 */ /* Reset Source: CORER */
#define PRTDCB_TX_DSCP2UP_IPV4_LUT_MAX_INDEX	7
#define PRTDCB_TX_DSCP2UP_IPV4_LUT_DSCP2UP_LUT_0_S 0
#define PRTDCB_TX_DSCP2UP_IPV4_LUT_DSCP2UP_LUT_0_M MAKEMASK(0x7, 0)
#define PRTDCB_TX_DSCP2UP_IPV4_LUT_DSCP2UP_LUT_1_S 4
#define PRTDCB_TX_DSCP2UP_IPV4_LUT_DSCP2UP_LUT_1_M MAKEMASK(0x7, 4)
#define PRTDCB_TX_DSCP2UP_IPV4_LUT_DSCP2UP_LUT_2_S 8
#define PRTDCB_TX_DSCP2UP_IPV4_LUT_DSCP2UP_LUT_2_M MAKEMASK(0x7, 8)
#define PRTDCB_TX_DSCP2UP_IPV4_LUT_DSCP2UP_LUT_3_S 12
#define PRTDCB_TX_DSCP2UP_IPV4_LUT_DSCP2UP_LUT_3_M MAKEMASK(0x7, 12)
#define PRTDCB_TX_DSCP2UP_IPV4_LUT_DSCP2UP_LUT_4_S 16
#define PRTDCB_TX_DSCP2UP_IPV4_LUT_DSCP2UP_LUT_4_M MAKEMASK(0x7, 16)
#define PRTDCB_TX_DSCP2UP_IPV4_LUT_DSCP2UP_LUT_5_S 20
#define PRTDCB_TX_DSCP2UP_IPV4_LUT_DSCP2UP_LUT_5_M MAKEMASK(0x7, 20)
#define PRTDCB_TX_DSCP2UP_IPV4_LUT_DSCP2UP_LUT_6_S 24
#define PRTDCB_TX_DSCP2UP_IPV4_LUT_DSCP2UP_LUT_6_M MAKEMASK(0x7, 24)
#define PRTDCB_TX_DSCP2UP_IPV4_LUT_DSCP2UP_LUT_7_S 28
#define PRTDCB_TX_DSCP2UP_IPV4_LUT_DSCP2UP_LUT_7_M MAKEMASK(0x7, 28)
#define PRTDCB_TX_DSCP2UP_IPV6_LUT(_i)		(0x00040AA0 + ((_i) * 32)) /* _i=0...7 */ /* Reset Source: CORER */
#define PRTDCB_TX_DSCP2UP_IPV6_LUT_MAX_INDEX	7
#define PRTDCB_TX_DSCP2UP_IPV6_LUT_DSCP2UP_LUT_0_S 0
#define PRTDCB_TX_DSCP2UP_IPV6_LUT_DSCP2UP_LUT_0_M MAKEMASK(0x7, 0)
#define PRTDCB_TX_DSCP2UP_IPV6_LUT_DSCP2UP_LUT_1_S 4
#define PRTDCB_TX_DSCP2UP_IPV6_LUT_DSCP2UP_LUT_1_M MAKEMASK(0x7, 4)
#define PRTDCB_TX_DSCP2UP_IPV6_LUT_DSCP2UP_LUT_2_S 8
#define PRTDCB_TX_DSCP2UP_IPV6_LUT_DSCP2UP_LUT_2_M MAKEMASK(0x7, 8)
#define PRTDCB_TX_DSCP2UP_IPV6_LUT_DSCP2UP_LUT_3_S 12
#define PRTDCB_TX_DSCP2UP_IPV6_LUT_DSCP2UP_LUT_3_M MAKEMASK(0x7, 12)
#define PRTDCB_TX_DSCP2UP_IPV6_LUT_DSCP2UP_LUT_4_S 16
#define PRTDCB_TX_DSCP2UP_IPV6_LUT_DSCP2UP_LUT_4_M MAKEMASK(0x7, 16)
#define PRTDCB_TX_DSCP2UP_IPV6_LUT_DSCP2UP_LUT_5_S 20
#define PRTDCB_TX_DSCP2UP_IPV6_LUT_DSCP2UP_LUT_5_M MAKEMASK(0x7, 20)
#define PRTDCB_TX_DSCP2UP_IPV6_LUT_DSCP2UP_LUT_6_S 24
#define PRTDCB_TX_DSCP2UP_IPV6_LUT_DSCP2UP_LUT_6_M MAKEMASK(0x7, 24)
#define PRTDCB_TX_DSCP2UP_IPV6_LUT_DSCP2UP_LUT_7_S 28
#define PRTDCB_TX_DSCP2UP_IPV6_LUT_DSCP2UP_LUT_7_M MAKEMASK(0x7, 28)
#define PRTTCB_BULK_DWRR_REG_CREDITS		0x000AE060 /* Reset Source: CORER */
#define PRTTCB_BULK_DWRR_REG_CREDITS_CREDITS_S	0
#define PRTTCB_BULK_DWRR_REG_CREDITS_CREDITS_M	MAKEMASK(0x3FFFF, 0)
#define PRTTCB_BULK_DWRR_WB_CREDITS		0x000AE080 /* Reset Source: CORER */
#define PRTTCB_BULK_DWRR_WB_CREDITS_CREDITS_S	0
#define PRTTCB_BULK_DWRR_WB_CREDITS_CREDITS_M	MAKEMASK(0x3FFFF, 0)
#define PRTTCB_CREDIT_EXP			0x000AE100 /* Reset Source: CORER */
#define PRTTCB_CREDIT_EXP_EXPANSION_S		0
#define PRTTCB_CREDIT_EXP_EXPANSION_M		MAKEMASK(0xFF, 0)
#define PRTTCB_LL_DWRR_REG_CREDITS		0x000AE0A0 /* Reset Source: CORER */
#define PRTTCB_LL_DWRR_REG_CREDITS_CREDITS_S	0
#define PRTTCB_LL_DWRR_REG_CREDITS_CREDITS_M	MAKEMASK(0x3FFFF, 0)
#define PRTTCB_LL_DWRR_WB_CREDITS		0x000AE0C0 /* Reset Source: CORER */
#define PRTTCB_LL_DWRR_WB_CREDITS_CREDITS_S	0
#define PRTTCB_LL_DWRR_WB_CREDITS_CREDITS_M	MAKEMASK(0x3FFFF, 0)
#define TCDCB_TCUPM_WAIT_CM(_i)			(0x000BC520 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define TCDCB_TCUPM_WAIT_CM_MAX_INDEX		31
#define TCDCB_TCUPM_WAIT_CM_MONITOR_S		0
#define TCDCB_TCUPM_WAIT_CM_MONITOR_M		MAKEMASK(0x7FFF, 0)
#define TCDCB_TCUPM_WAIT_CTHR(_i)		(0x000BC5A0 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define TCDCB_TCUPM_WAIT_CTHR_MAX_INDEX		31
#define TCDCB_TCUPM_WAIT_CTHR_TCOFFTH_S		0
#define TCDCB_TCUPM_WAIT_CTHR_TCOFFTH_M		MAKEMASK(0x7FFF, 0)
#define TCDCB_TCUPM_WAIT_DM(_i)			(0x000BC620 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define TCDCB_TCUPM_WAIT_DM_MAX_INDEX		31
#define TCDCB_TCUPM_WAIT_DM_MONITOR_S		0
#define TCDCB_TCUPM_WAIT_DM_MONITOR_M		MAKEMASK(0x7FFFF, 0)
#define TCDCB_TCUPM_WAIT_DTHR(_i)		(0x000BC6A0 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define TCDCB_TCUPM_WAIT_DTHR_MAX_INDEX		31
#define TCDCB_TCUPM_WAIT_DTHR_TCOFFTH_S		0
#define TCDCB_TCUPM_WAIT_DTHR_TCOFFTH_M		MAKEMASK(0xFFF, 0)
#define TCDCB_TCUPM_WAIT_PE_HB_DM(_i)		(0x000BC720 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define TCDCB_TCUPM_WAIT_PE_HB_DM_MAX_INDEX	31
#define TCDCB_TCUPM_WAIT_PE_HB_DM_MONITOR_S	0
#define TCDCB_TCUPM_WAIT_PE_HB_DM_MONITOR_M	MAKEMASK(0xFFF, 0)
#define TCDCB_TCUPM_WAIT_PE_HB_DTHR(_i)		(0x000BC7A0 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define TCDCB_TCUPM_WAIT_PE_HB_DTHR_MAX_INDEX	31
#define TCDCB_TCUPM_WAIT_PE_HB_DTHR_TCOFFTH_S	0
#define TCDCB_TCUPM_WAIT_PE_HB_DTHR_TCOFFTH_M	MAKEMASK(0xFFF, 0)
#define TCDCB_TLPM_WAIT_DM(_i)			(0x000A0080 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define TCDCB_TLPM_WAIT_DM_MAX_INDEX		31
#define TCDCB_TLPM_WAIT_DM_MONITOR_S		0
#define TCDCB_TLPM_WAIT_DM_MONITOR_M		MAKEMASK(0x7FFFF, 0)
#define TCDCB_TLPM_WAIT_DTHR(_i)		(0x000A0100 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define TCDCB_TLPM_WAIT_DTHR_MAX_INDEX		31
#define TCDCB_TLPM_WAIT_DTHR_TCOFFTH_S		0
#define TCDCB_TLPM_WAIT_DTHR_TCOFFTH_M		MAKEMASK(0xFFF, 0)
#define TCTCB_WB_RL_TC_CFG(_i)			(0x000AE138 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define TCTCB_WB_RL_TC_CFG_MAX_INDEX		31
#define TCTCB_WB_RL_TC_CFG_TOKENS_S		0
#define TCTCB_WB_RL_TC_CFG_TOKENS_M		MAKEMASK(0xFFF, 0)
#define TCTCB_WB_RL_TC_CFG_BURST_SIZE_S		12
#define TCTCB_WB_RL_TC_CFG_BURST_SIZE_M		MAKEMASK(0x3FF, 12)
#define TCTCB_WB_RL_TC_STAT(_i)			(0x000AE1B8 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define TCTCB_WB_RL_TC_STAT_MAX_INDEX		31
#define TCTCB_WB_RL_TC_STAT_BUCKET_S		0
#define TCTCB_WB_RL_TC_STAT_BUCKET_M		MAKEMASK(0x1FFFF, 0)
#define TPB_BULK_DWRR_REG_QUANTA		0x00099340 /* Reset Source: CORER */
#define TPB_BULK_DWRR_REG_QUANTA_QUANTA_S	0
#define TPB_BULK_DWRR_REG_QUANTA_QUANTA_M	MAKEMASK(0x7FF, 0)
#define TPB_BULK_DWRR_REG_SAT			0x00099350 /* Reset Source: CORER */
#define TPB_BULK_DWRR_REG_SAT_SATURATION_S	0
#define TPB_BULK_DWRR_REG_SAT_SATURATION_M	MAKEMASK(0x1FFFF, 0)
#define TPB_BULK_DWRR_WB_QUANTA			0x00099344 /* Reset Source: CORER */
#define TPB_BULK_DWRR_WB_QUANTA_QUANTA_S	0
#define TPB_BULK_DWRR_WB_QUANTA_QUANTA_M	MAKEMASK(0x7FF, 0)
#define TPB_BULK_DWRR_WB_SAT			0x00099354 /* Reset Source: CORER */
#define TPB_BULK_DWRR_WB_SAT_SATURATION_S	0
#define TPB_BULK_DWRR_WB_SAT_SATURATION_M	MAKEMASK(0x1FFFF, 0)
#define TPB_GLDCB_TCB_WB_SP			0x0009966C /* Reset Source: CORER */
#define TPB_GLDCB_TCB_WB_SP_WB_SP_S		0
#define TPB_GLDCB_TCB_WB_SP_WB_SP_M		BIT(0)
#define TPB_GLTCB_CREDIT_EXP_CTL		0x00099664 /* Reset Source: CORER */
#define TPB_GLTCB_CREDIT_EXP_CTL_EN_S		0
#define TPB_GLTCB_CREDIT_EXP_CTL_EN_M		BIT(0)
#define TPB_GLTCB_CREDIT_EXP_CTL_MIN_PKT_S	1
#define TPB_GLTCB_CREDIT_EXP_CTL_MIN_PKT_M	MAKEMASK(0x1FF, 1)
#define TPB_LL_DWRR_REG_QUANTA			0x00099348 /* Reset Source: CORER */
#define TPB_LL_DWRR_REG_QUANTA_QUANTA_S		0
#define TPB_LL_DWRR_REG_QUANTA_QUANTA_M		MAKEMASK(0x7FF, 0)
#define TPB_LL_DWRR_REG_SAT			0x00099358 /* Reset Source: CORER */
#define TPB_LL_DWRR_REG_SAT_SATURATION_S	0
#define TPB_LL_DWRR_REG_SAT_SATURATION_M	MAKEMASK(0x1FFFF, 0)
#define TPB_LL_DWRR_WB_QUANTA			0x0009934C /* Reset Source: CORER */
#define TPB_LL_DWRR_WB_QUANTA_QUANTA_S		0
#define TPB_LL_DWRR_WB_QUANTA_QUANTA_M		MAKEMASK(0x7FF, 0)
#define TPB_LL_DWRR_WB_SAT			0x0009935C /* Reset Source: CORER */
#define TPB_LL_DWRR_WB_SAT_SATURATION_S		0
#define TPB_LL_DWRR_WB_SAT_SATURATION_M		MAKEMASK(0x1FFFF, 0)
#define TPB_PRTDCB_TCB_DWRR_CREDITS		0x000991C0 /* Reset Source: CORER */
#define TPB_PRTDCB_TCB_DWRR_CREDITS_CREDITS_S	0
#define TPB_PRTDCB_TCB_DWRR_CREDITS_CREDITS_M	MAKEMASK(0x3FFFF, 0)
#define TPB_PRTDCB_TCB_DWRR_QUANTA		0x00099220 /* Reset Source: CORER */
#define TPB_PRTDCB_TCB_DWRR_QUANTA_QUANTA_S	0
#define TPB_PRTDCB_TCB_DWRR_QUANTA_QUANTA_M	MAKEMASK(0x7FF, 0)
#define TPB_PRTDCB_TCB_DWRR_SAT			0x00099260 /* Reset Source: CORER */
#define TPB_PRTDCB_TCB_DWRR_SAT_SATURATION_S	0
#define TPB_PRTDCB_TCB_DWRR_SAT_SATURATION_M	MAKEMASK(0x1FFFF, 0)
#define TPB_PRTTCB_BULK_DWRR_REG_CREDITS	0x000992A0 /* Reset Source: CORER */
#define TPB_PRTTCB_BULK_DWRR_REG_CREDITS_CREDITS_S 0
#define TPB_PRTTCB_BULK_DWRR_REG_CREDITS_CREDITS_M MAKEMASK(0x3FFFF, 0)
#define TPB_PRTTCB_BULK_DWRR_WB_CREDITS		0x000992C0 /* Reset Source: CORER */
#define TPB_PRTTCB_BULK_DWRR_WB_CREDITS_CREDITS_S 0
#define TPB_PRTTCB_BULK_DWRR_WB_CREDITS_CREDITS_M MAKEMASK(0x3FFFF, 0)
#define TPB_PRTTCB_CREDIT_EXP			0x00099644 /* Reset Source: CORER */
#define TPB_PRTTCB_CREDIT_EXP_EXPANSION_S	0
#define TPB_PRTTCB_CREDIT_EXP_EXPANSION_M	MAKEMASK(0xFF, 0)
#define TPB_PRTTCB_LL_DWRR_REG_CREDITS		0x00099300 /* Reset Source: CORER */
#define TPB_PRTTCB_LL_DWRR_REG_CREDITS_CREDITS_S 0
#define TPB_PRTTCB_LL_DWRR_REG_CREDITS_CREDITS_M MAKEMASK(0x3FFFF, 0)
#define TPB_PRTTCB_LL_DWRR_WB_CREDITS		0x00099320 /* Reset Source: CORER */
#define TPB_PRTTCB_LL_DWRR_WB_CREDITS_CREDITS_S 0
#define TPB_PRTTCB_LL_DWRR_WB_CREDITS_CREDITS_M MAKEMASK(0x3FFFF, 0)
#define TPB_WB_RL_TC_CFG(_i)			(0x00099360 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define TPB_WB_RL_TC_CFG_MAX_INDEX		31
#define TPB_WB_RL_TC_CFG_TOKENS_S		0
#define TPB_WB_RL_TC_CFG_TOKENS_M		MAKEMASK(0xFFF, 0)
#define TPB_WB_RL_TC_CFG_BURST_SIZE_S		12
#define TPB_WB_RL_TC_CFG_BURST_SIZE_M		MAKEMASK(0x3FF, 12)
#define TPB_WB_RL_TC_STAT(_i)			(0x000993E0 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define TPB_WB_RL_TC_STAT_MAX_INDEX		31
#define TPB_WB_RL_TC_STAT_BUCKET_S		0
#define TPB_WB_RL_TC_STAT_BUCKET_M		MAKEMASK(0x1FFFF, 0)
#define GL_ACLEXT_CDMD_L1SEL(_i)		(0x00210054 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_ACLEXT_CDMD_L1SEL_MAX_INDEX		2
#define GL_ACLEXT_CDMD_L1SEL_RX_SEL_S		0
#define GL_ACLEXT_CDMD_L1SEL_RX_SEL_M		MAKEMASK(0x1F, 0)
#define GL_ACLEXT_CDMD_L1SEL_TX_SEL_S		8
#define GL_ACLEXT_CDMD_L1SEL_TX_SEL_M		MAKEMASK(0x1F, 8)
#define GL_ACLEXT_CDMD_L1SEL_AUX0_SEL_S		16
#define GL_ACLEXT_CDMD_L1SEL_AUX0_SEL_M		MAKEMASK(0x1F, 16)
#define GL_ACLEXT_CDMD_L1SEL_AUX1_SEL_S		24
#define GL_ACLEXT_CDMD_L1SEL_AUX1_SEL_M		MAKEMASK(0x1F, 24)
#define GL_ACLEXT_CDMD_L1SEL_BIDIR_ENA_S	30
#define GL_ACLEXT_CDMD_L1SEL_BIDIR_ENA_M	MAKEMASK(0x3, 30)
#define GL_ACLEXT_CTLTBL_L2ADDR(_i)		(0x00210084 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_ACLEXT_CTLTBL_L2ADDR_MAX_INDEX	2
#define GL_ACLEXT_CTLTBL_L2ADDR_LINE_OFF_S	0
#define GL_ACLEXT_CTLTBL_L2ADDR_LINE_OFF_M	MAKEMASK(0x7, 0)
#define GL_ACLEXT_CTLTBL_L2ADDR_LINE_IDX_S	8
#define GL_ACLEXT_CTLTBL_L2ADDR_LINE_IDX_M	MAKEMASK(0x7, 8)
#define GL_ACLEXT_CTLTBL_L2ADDR_AUTO_INC_S	31
#define GL_ACLEXT_CTLTBL_L2ADDR_AUTO_INC_M	BIT(31)
#define GL_ACLEXT_CTLTBL_L2DATA(_i)		(0x00210090 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_ACLEXT_CTLTBL_L2DATA_MAX_INDEX	2
#define GL_ACLEXT_CTLTBL_L2DATA_DATA_S		0
#define GL_ACLEXT_CTLTBL_L2DATA_DATA_M		MAKEMASK(0xFFFFFFFF, 0)
#define GL_ACLEXT_DFLT_L2PRFL(_i)		(0x00210138 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_ACLEXT_DFLT_L2PRFL_MAX_INDEX		2
#define GL_ACLEXT_DFLT_L2PRFL_DFLT_PRFL_S	0
#define GL_ACLEXT_DFLT_L2PRFL_DFLT_PRFL_M	MAKEMASK(0xFFFF, 0)
#define GL_ACLEXT_DFLT_L2PRFL_ACL(_i)		(0x00393800 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_ACLEXT_DFLT_L2PRFL_ACL_MAX_INDEX	2
#define GL_ACLEXT_DFLT_L2PRFL_ACL_DFLT_PRFL_S	0
#define GL_ACLEXT_DFLT_L2PRFL_ACL_DFLT_PRFL_M	MAKEMASK(0xFFFF, 0)
#define GL_ACLEXT_FLGS_L1SEL0_1(_i)		(0x0021006C + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_ACLEXT_FLGS_L1SEL0_1_MAX_INDEX	2
#define GL_ACLEXT_FLGS_L1SEL0_1_FLS0_S		0
#define GL_ACLEXT_FLGS_L1SEL0_1_FLS0_M		MAKEMASK(0x1FF, 0)
#define GL_ACLEXT_FLGS_L1SEL0_1_FLS1_S		16
#define GL_ACLEXT_FLGS_L1SEL0_1_FLS1_M		MAKEMASK(0x1FF, 16)
#define GL_ACLEXT_FLGS_L1SEL2_3(_i)		(0x00210078 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_ACLEXT_FLGS_L1SEL2_3_MAX_INDEX	2
#define GL_ACLEXT_FLGS_L1SEL2_3_FLS2_S		0
#define GL_ACLEXT_FLGS_L1SEL2_3_FLS2_M		MAKEMASK(0x1FF, 0)
#define GL_ACLEXT_FLGS_L1SEL2_3_FLS3_S		16
#define GL_ACLEXT_FLGS_L1SEL2_3_FLS3_M		MAKEMASK(0x1FF, 16)
#define GL_ACLEXT_FLGS_L1TBL(_i)		(0x00210060 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_ACLEXT_FLGS_L1TBL_MAX_INDEX		2
#define GL_ACLEXT_FLGS_L1TBL_LSB_S		0
#define GL_ACLEXT_FLGS_L1TBL_LSB_M		MAKEMASK(0xFFFF, 0)
#define GL_ACLEXT_FLGS_L1TBL_MSB_S		16
#define GL_ACLEXT_FLGS_L1TBL_MSB_M		MAKEMASK(0xFFFF, 16)
#define GL_ACLEXT_FORCE_L1CDID(_i)		(0x00210018 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_ACLEXT_FORCE_L1CDID_MAX_INDEX	2
#define GL_ACLEXT_FORCE_L1CDID_STATIC_CDID_S	0
#define GL_ACLEXT_FORCE_L1CDID_STATIC_CDID_M	MAKEMASK(0xF, 0)
#define GL_ACLEXT_FORCE_L1CDID_STATIC_CDID_EN_S 31
#define GL_ACLEXT_FORCE_L1CDID_STATIC_CDID_EN_M BIT(31)
#define GL_ACLEXT_FORCE_PID(_i)			(0x00210000 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_ACLEXT_FORCE_PID_MAX_INDEX		2
#define GL_ACLEXT_FORCE_PID_STATIC_PID_S	0
#define GL_ACLEXT_FORCE_PID_STATIC_PID_M	MAKEMASK(0xFFFF, 0)
#define GL_ACLEXT_FORCE_PID_STATIC_PID_EN_S	31
#define GL_ACLEXT_FORCE_PID_STATIC_PID_EN_M	BIT(31)
#define GL_ACLEXT_K2N_L2ADDR(_i)		(0x00210144 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_ACLEXT_K2N_L2ADDR_MAX_INDEX		2
#define GL_ACLEXT_K2N_L2ADDR_LINE_IDX_S		0
#define GL_ACLEXT_K2N_L2ADDR_LINE_IDX_M		MAKEMASK(0x7F, 0)
#define GL_ACLEXT_K2N_L2ADDR_AUTO_INC_S		31
#define GL_ACLEXT_K2N_L2ADDR_AUTO_INC_M		BIT(31)
#define GL_ACLEXT_K2N_L2DATA(_i)		(0x00210150 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_ACLEXT_K2N_L2DATA_MAX_INDEX		2
#define GL_ACLEXT_K2N_L2DATA_DATA0_S		0
#define GL_ACLEXT_K2N_L2DATA_DATA0_M		MAKEMASK(0xFF, 0)
#define GL_ACLEXT_K2N_L2DATA_DATA1_S		8
#define GL_ACLEXT_K2N_L2DATA_DATA1_M		MAKEMASK(0xFF, 8)
#define GL_ACLEXT_K2N_L2DATA_DATA2_S		16
#define GL_ACLEXT_K2N_L2DATA_DATA2_M		MAKEMASK(0xFF, 16)
#define GL_ACLEXT_K2N_L2DATA_DATA3_S		24
#define GL_ACLEXT_K2N_L2DATA_DATA3_M		MAKEMASK(0xFF, 24)
#define GL_ACLEXT_L2_PMASK0(_i)			(0x002100FC + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_ACLEXT_L2_PMASK0_MAX_INDEX		2
#define GL_ACLEXT_L2_PMASK0_BITMASK_S		0
#define GL_ACLEXT_L2_PMASK0_BITMASK_M		MAKEMASK(0xFFFFFFFF, 0)
#define GL_ACLEXT_L2_PMASK1(_i)			(0x00210108 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_ACLEXT_L2_PMASK1_MAX_INDEX		2
#define GL_ACLEXT_L2_PMASK1_BITMASK_S		0
#define GL_ACLEXT_L2_PMASK1_BITMASK_M		MAKEMASK(0xFFFF, 0)
#define GL_ACLEXT_L2_TMASK0(_i)			(0x00210498 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_ACLEXT_L2_TMASK0_MAX_INDEX		2
#define GL_ACLEXT_L2_TMASK0_BITMASK_S		0
#define GL_ACLEXT_L2_TMASK0_BITMASK_M		MAKEMASK(0xFFFFFFFF, 0)
#define GL_ACLEXT_L2_TMASK1(_i)			(0x002104A4 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_ACLEXT_L2_TMASK1_MAX_INDEX		2
#define GL_ACLEXT_L2_TMASK1_BITMASK_S		0
#define GL_ACLEXT_L2_TMASK1_BITMASK_M		MAKEMASK(0xFF, 0)
#define GL_ACLEXT_L2BMP0_3(_i)			(0x002100A8 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_ACLEXT_L2BMP0_3_MAX_INDEX		2
#define GL_ACLEXT_L2BMP0_3_BMP0_S		0
#define GL_ACLEXT_L2BMP0_3_BMP0_M		MAKEMASK(0xFF, 0)
#define GL_ACLEXT_L2BMP0_3_BMP1_S		8
#define GL_ACLEXT_L2BMP0_3_BMP1_M		MAKEMASK(0xFF, 8)
#define GL_ACLEXT_L2BMP0_3_BMP2_S		16
#define GL_ACLEXT_L2BMP0_3_BMP2_M		MAKEMASK(0xFF, 16)
#define GL_ACLEXT_L2BMP0_3_BMP3_S		24
#define GL_ACLEXT_L2BMP0_3_BMP3_M		MAKEMASK(0xFF, 24)
#define GL_ACLEXT_L2BMP4_7(_i)			(0x002100B4 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_ACLEXT_L2BMP4_7_MAX_INDEX		2
#define GL_ACLEXT_L2BMP4_7_BMP4_S		0
#define GL_ACLEXT_L2BMP4_7_BMP4_M		MAKEMASK(0xFF, 0)
#define GL_ACLEXT_L2BMP4_7_BMP5_S		8
#define GL_ACLEXT_L2BMP4_7_BMP5_M		MAKEMASK(0xFF, 8)
#define GL_ACLEXT_L2BMP4_7_BMP6_S		16
#define GL_ACLEXT_L2BMP4_7_BMP6_M		MAKEMASK(0xFF, 16)
#define GL_ACLEXT_L2BMP4_7_BMP7_S		24
#define GL_ACLEXT_L2BMP4_7_BMP7_M		MAKEMASK(0xFF, 24)
#define GL_ACLEXT_L2PRTMOD(_i)			(0x0021009C + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_ACLEXT_L2PRTMOD_MAX_INDEX		2
#define GL_ACLEXT_L2PRTMOD_XLT1_S		0
#define GL_ACLEXT_L2PRTMOD_XLT1_M		MAKEMASK(0x3, 0)
#define GL_ACLEXT_L2PRTMOD_XLT2_S		8
#define GL_ACLEXT_L2PRTMOD_XLT2_M		MAKEMASK(0x3, 8)
#define GL_ACLEXT_N2N_L2ADDR(_i)		(0x0021015C + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_ACLEXT_N2N_L2ADDR_MAX_INDEX		2
#define GL_ACLEXT_N2N_L2ADDR_LINE_IDX_S		0
#define GL_ACLEXT_N2N_L2ADDR_LINE_IDX_M		MAKEMASK(0x3F, 0)
#define GL_ACLEXT_N2N_L2ADDR_AUTO_INC_S		31
#define GL_ACLEXT_N2N_L2ADDR_AUTO_INC_M		BIT(31)
#define GL_ACLEXT_N2N_L2DATA(_i)		(0x00210168 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_ACLEXT_N2N_L2DATA_MAX_INDEX		2
#define GL_ACLEXT_N2N_L2DATA_DATA0_S		0
#define GL_ACLEXT_N2N_L2DATA_DATA0_M		MAKEMASK(0xFF, 0)
#define GL_ACLEXT_N2N_L2DATA_DATA1_S		8
#define GL_ACLEXT_N2N_L2DATA_DATA1_M		MAKEMASK(0xFF, 8)
#define GL_ACLEXT_N2N_L2DATA_DATA2_S		16
#define GL_ACLEXT_N2N_L2DATA_DATA2_M		MAKEMASK(0xFF, 16)
#define GL_ACLEXT_N2N_L2DATA_DATA3_S		24
#define GL_ACLEXT_N2N_L2DATA_DATA3_M		MAKEMASK(0xFF, 24)
#define GL_ACLEXT_P2P_L1ADDR(_i)		(0x00210024 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_ACLEXT_P2P_L1ADDR_MAX_INDEX		2
#define GL_ACLEXT_P2P_L1ADDR_LINE_IDX_S		0
#define GL_ACLEXT_P2P_L1ADDR_LINE_IDX_M		BIT(0)
#define GL_ACLEXT_P2P_L1ADDR_AUTO_INC_S		31
#define GL_ACLEXT_P2P_L1ADDR_AUTO_INC_M		BIT(31)
#define GL_ACLEXT_P2P_L1DATA(_i)		(0x00210030 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_ACLEXT_P2P_L1DATA_MAX_INDEX		2
#define GL_ACLEXT_P2P_L1DATA_DATA_S		0
#define GL_ACLEXT_P2P_L1DATA_DATA_M		MAKEMASK(0xFFFFFFFF, 0)
#define GL_ACLEXT_PID_L2GKTYPE(_i)		(0x002100F0 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_ACLEXT_PID_L2GKTYPE_MAX_INDEX	2
#define GL_ACLEXT_PID_L2GKTYPE_PID_GKTYPE_S	0
#define GL_ACLEXT_PID_L2GKTYPE_PID_GKTYPE_M	MAKEMASK(0x3, 0)
#define GL_ACLEXT_PLVL_SEL(_i)			(0x0021000C + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_ACLEXT_PLVL_SEL_MAX_INDEX		2
#define GL_ACLEXT_PLVL_SEL_PLVL_SEL_S		0
#define GL_ACLEXT_PLVL_SEL_PLVL_SEL_M		BIT(0)
#define GL_ACLEXT_TCAM_L2ADDR(_i)		(0x00210114 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_ACLEXT_TCAM_L2ADDR_MAX_INDEX		2
#define GL_ACLEXT_TCAM_L2ADDR_LINE_IDX_S	0
#define GL_ACLEXT_TCAM_L2ADDR_LINE_IDX_M	MAKEMASK(0x3FF, 0)
#define GL_ACLEXT_TCAM_L2ADDR_AUTO_INC_S	31
#define GL_ACLEXT_TCAM_L2ADDR_AUTO_INC_M	BIT(31)
#define GL_ACLEXT_TCAM_L2DATALSB(_i)		(0x00210120 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_ACLEXT_TCAM_L2DATALSB_MAX_INDEX	2
#define GL_ACLEXT_TCAM_L2DATALSB_DATALSB_S	0
#define GL_ACLEXT_TCAM_L2DATALSB_DATALSB_M	MAKEMASK(0xFFFFFFFF, 0)
#define GL_ACLEXT_TCAM_L2DATAMSB(_i)		(0x0021012C + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_ACLEXT_TCAM_L2DATAMSB_MAX_INDEX	2
#define GL_ACLEXT_TCAM_L2DATAMSB_DATAMSB_S	0
#define GL_ACLEXT_TCAM_L2DATAMSB_DATAMSB_M	MAKEMASK(0xFF, 0)
#define GL_ACLEXT_XLT0_L1ADDR(_i)		(0x0021003C + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_ACLEXT_XLT0_L1ADDR_MAX_INDEX		2
#define GL_ACLEXT_XLT0_L1ADDR_LINE_IDX_S	0
#define GL_ACLEXT_XLT0_L1ADDR_LINE_IDX_M	MAKEMASK(0xFF, 0)
#define GL_ACLEXT_XLT0_L1ADDR_AUTO_INC_S	31
#define GL_ACLEXT_XLT0_L1ADDR_AUTO_INC_M	BIT(31)
#define GL_ACLEXT_XLT0_L1DATA(_i)		(0x00210048 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_ACLEXT_XLT0_L1DATA_MAX_INDEX		2
#define GL_ACLEXT_XLT0_L1DATA_DATA_S		0
#define GL_ACLEXT_XLT0_L1DATA_DATA_M		MAKEMASK(0xFFFFFFFF, 0)
#define GL_ACLEXT_XLT1_L2ADDR(_i)		(0x002100C0 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_ACLEXT_XLT1_L2ADDR_MAX_INDEX		2
#define GL_ACLEXT_XLT1_L2ADDR_LINE_IDX_S	0
#define GL_ACLEXT_XLT1_L2ADDR_LINE_IDX_M	MAKEMASK(0x7FF, 0)
#define GL_ACLEXT_XLT1_L2ADDR_AUTO_INC_S	31
#define GL_ACLEXT_XLT1_L2ADDR_AUTO_INC_M	BIT(31)
#define GL_ACLEXT_XLT1_L2DATA(_i)		(0x002100CC + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_ACLEXT_XLT1_L2DATA_MAX_INDEX		2
#define GL_ACLEXT_XLT1_L2DATA_DATA_S		0
#define GL_ACLEXT_XLT1_L2DATA_DATA_M		MAKEMASK(0xFFFFFFFF, 0)
#define GL_ACLEXT_XLT2_L2ADDR(_i)		(0x002100D8 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_ACLEXT_XLT2_L2ADDR_MAX_INDEX		2
#define GL_ACLEXT_XLT2_L2ADDR_LINE_IDX_S	0
#define GL_ACLEXT_XLT2_L2ADDR_LINE_IDX_M	MAKEMASK(0x1FF, 0)
#define GL_ACLEXT_XLT2_L2ADDR_AUTO_INC_S	31
#define GL_ACLEXT_XLT2_L2ADDR_AUTO_INC_M	BIT(31)
#define GL_ACLEXT_XLT2_L2DATA(_i)		(0x002100E4 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_ACLEXT_XLT2_L2DATA_MAX_INDEX		2
#define GL_ACLEXT_XLT2_L2DATA_DATA_S		0
#define GL_ACLEXT_XLT2_L2DATA_DATA_M		MAKEMASK(0xFFFFFFFF, 0)
#define GL_PREEXT_CDMD_L1SEL(_i)		(0x0020F054 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PREEXT_CDMD_L1SEL_MAX_INDEX		2
#define GL_PREEXT_CDMD_L1SEL_RX_SEL_S		0
#define GL_PREEXT_CDMD_L1SEL_RX_SEL_M		MAKEMASK(0x1F, 0)
#define GL_PREEXT_CDMD_L1SEL_TX_SEL_S		8
#define GL_PREEXT_CDMD_L1SEL_TX_SEL_M		MAKEMASK(0x1F, 8)
#define GL_PREEXT_CDMD_L1SEL_AUX0_SEL_S		16
#define GL_PREEXT_CDMD_L1SEL_AUX0_SEL_M		MAKEMASK(0x1F, 16)
#define GL_PREEXT_CDMD_L1SEL_AUX1_SEL_S		24
#define GL_PREEXT_CDMD_L1SEL_AUX1_SEL_M		MAKEMASK(0x1F, 24)
#define GL_PREEXT_CDMD_L1SEL_BIDIR_ENA_S	30
#define GL_PREEXT_CDMD_L1SEL_BIDIR_ENA_M	MAKEMASK(0x3, 30)
#define GL_PREEXT_CTLTBL_L2ADDR(_i)		(0x0020F084 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PREEXT_CTLTBL_L2ADDR_MAX_INDEX	2
#define GL_PREEXT_CTLTBL_L2ADDR_LINE_OFF_S	0
#define GL_PREEXT_CTLTBL_L2ADDR_LINE_OFF_M	MAKEMASK(0x7, 0)
#define GL_PREEXT_CTLTBL_L2ADDR_LINE_IDX_S	8
#define GL_PREEXT_CTLTBL_L2ADDR_LINE_IDX_M	MAKEMASK(0x7, 8)
#define GL_PREEXT_CTLTBL_L2ADDR_AUTO_INC_S	31
#define GL_PREEXT_CTLTBL_L2ADDR_AUTO_INC_M	BIT(31)
#define GL_PREEXT_CTLTBL_L2DATA(_i)		(0x0020F090 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PREEXT_CTLTBL_L2DATA_MAX_INDEX	2
#define GL_PREEXT_CTLTBL_L2DATA_DATA_S		0
#define GL_PREEXT_CTLTBL_L2DATA_DATA_M		MAKEMASK(0xFFFFFFFF, 0)
#define GL_PREEXT_DFLT_L2PRFL(_i)		(0x0020F138 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PREEXT_DFLT_L2PRFL_MAX_INDEX		2
#define GL_PREEXT_DFLT_L2PRFL_DFLT_PRFL_S	0
#define GL_PREEXT_DFLT_L2PRFL_DFLT_PRFL_M	MAKEMASK(0xFFFF, 0)
#define GL_PREEXT_FLGS_L1SEL0_1(_i)		(0x0020F06C + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PREEXT_FLGS_L1SEL0_1_MAX_INDEX	2
#define GL_PREEXT_FLGS_L1SEL0_1_FLS0_S		0
#define GL_PREEXT_FLGS_L1SEL0_1_FLS0_M		MAKEMASK(0x1FF, 0)
#define GL_PREEXT_FLGS_L1SEL0_1_FLS1_S		16
#define GL_PREEXT_FLGS_L1SEL0_1_FLS1_M		MAKEMASK(0x1FF, 16)
#define GL_PREEXT_FLGS_L1SEL2_3(_i)		(0x0020F078 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PREEXT_FLGS_L1SEL2_3_MAX_INDEX	2
#define GL_PREEXT_FLGS_L1SEL2_3_FLS2_S		0
#define GL_PREEXT_FLGS_L1SEL2_3_FLS2_M		MAKEMASK(0x1FF, 0)
#define GL_PREEXT_FLGS_L1SEL2_3_FLS3_S		16
#define GL_PREEXT_FLGS_L1SEL2_3_FLS3_M		MAKEMASK(0x1FF, 16)
#define GL_PREEXT_FLGS_L1TBL(_i)		(0x0020F060 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PREEXT_FLGS_L1TBL_MAX_INDEX		2
#define GL_PREEXT_FLGS_L1TBL_LSB_S		0
#define GL_PREEXT_FLGS_L1TBL_LSB_M		MAKEMASK(0xFFFF, 0)
#define GL_PREEXT_FLGS_L1TBL_MSB_S		16
#define GL_PREEXT_FLGS_L1TBL_MSB_M		MAKEMASK(0xFFFF, 16)
#define GL_PREEXT_FORCE_L1CDID(_i)		(0x0020F018 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PREEXT_FORCE_L1CDID_MAX_INDEX	2
#define GL_PREEXT_FORCE_L1CDID_STATIC_CDID_S	0
#define GL_PREEXT_FORCE_L1CDID_STATIC_CDID_M	MAKEMASK(0xF, 0)
#define GL_PREEXT_FORCE_L1CDID_STATIC_CDID_EN_S 31
#define GL_PREEXT_FORCE_L1CDID_STATIC_CDID_EN_M BIT(31)
#define GL_PREEXT_FORCE_PID(_i)			(0x0020F000 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PREEXT_FORCE_PID_MAX_INDEX		2
#define GL_PREEXT_FORCE_PID_STATIC_PID_S	0
#define GL_PREEXT_FORCE_PID_STATIC_PID_M	MAKEMASK(0xFFFF, 0)
#define GL_PREEXT_FORCE_PID_STATIC_PID_EN_S	31
#define GL_PREEXT_FORCE_PID_STATIC_PID_EN_M	BIT(31)
#define GL_PREEXT_K2N_L2ADDR(_i)		(0x0020F144 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PREEXT_K2N_L2ADDR_MAX_INDEX		2
#define GL_PREEXT_K2N_L2ADDR_LINE_IDX_S		0
#define GL_PREEXT_K2N_L2ADDR_LINE_IDX_M		MAKEMASK(0x7F, 0)
#define GL_PREEXT_K2N_L2ADDR_AUTO_INC_S		31
#define GL_PREEXT_K2N_L2ADDR_AUTO_INC_M		BIT(31)
#define GL_PREEXT_K2N_L2DATA(_i)		(0x0020F150 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PREEXT_K2N_L2DATA_MAX_INDEX		2
#define GL_PREEXT_K2N_L2DATA_DATA0_S		0
#define GL_PREEXT_K2N_L2DATA_DATA0_M		MAKEMASK(0xFF, 0)
#define GL_PREEXT_K2N_L2DATA_DATA1_S		8
#define GL_PREEXT_K2N_L2DATA_DATA1_M		MAKEMASK(0xFF, 8)
#define GL_PREEXT_K2N_L2DATA_DATA2_S		16
#define GL_PREEXT_K2N_L2DATA_DATA2_M		MAKEMASK(0xFF, 16)
#define GL_PREEXT_K2N_L2DATA_DATA3_S		24
#define GL_PREEXT_K2N_L2DATA_DATA3_M		MAKEMASK(0xFF, 24)
#define GL_PREEXT_L2_PMASK0(_i)			(0x0020F0FC + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PREEXT_L2_PMASK0_MAX_INDEX		2
#define GL_PREEXT_L2_PMASK0_BITMASK_S		0
#define GL_PREEXT_L2_PMASK0_BITMASK_M		MAKEMASK(0xFFFFFFFF, 0)
#define GL_PREEXT_L2_PMASK1(_i)			(0x0020F108 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PREEXT_L2_PMASK1_MAX_INDEX		2
#define GL_PREEXT_L2_PMASK1_BITMASK_S		0
#define GL_PREEXT_L2_PMASK1_BITMASK_M		MAKEMASK(0xFFFF, 0)
#define GL_PREEXT_L2_TMASK0(_i)			(0x0020F498 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PREEXT_L2_TMASK0_MAX_INDEX		2
#define GL_PREEXT_L2_TMASK0_BITMASK_S		0
#define GL_PREEXT_L2_TMASK0_BITMASK_M		MAKEMASK(0xFFFFFFFF, 0)
#define GL_PREEXT_L2_TMASK1(_i)			(0x0020F4A4 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PREEXT_L2_TMASK1_MAX_INDEX		2
#define GL_PREEXT_L2_TMASK1_BITMASK_S		0
#define GL_PREEXT_L2_TMASK1_BITMASK_M		MAKEMASK(0xFF, 0)
#define GL_PREEXT_L2BMP0_3(_i)			(0x0020F0A8 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PREEXT_L2BMP0_3_MAX_INDEX		2
#define GL_PREEXT_L2BMP0_3_BMP0_S		0
#define GL_PREEXT_L2BMP0_3_BMP0_M		MAKEMASK(0xFF, 0)
#define GL_PREEXT_L2BMP0_3_BMP1_S		8
#define GL_PREEXT_L2BMP0_3_BMP1_M		MAKEMASK(0xFF, 8)
#define GL_PREEXT_L2BMP0_3_BMP2_S		16
#define GL_PREEXT_L2BMP0_3_BMP2_M		MAKEMASK(0xFF, 16)
#define GL_PREEXT_L2BMP0_3_BMP3_S		24
#define GL_PREEXT_L2BMP0_3_BMP3_M		MAKEMASK(0xFF, 24)
#define GL_PREEXT_L2BMP4_7(_i)			(0x0020F0B4 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PREEXT_L2BMP4_7_MAX_INDEX		2
#define GL_PREEXT_L2BMP4_7_BMP4_S		0
#define GL_PREEXT_L2BMP4_7_BMP4_M		MAKEMASK(0xFF, 0)
#define GL_PREEXT_L2BMP4_7_BMP5_S		8
#define GL_PREEXT_L2BMP4_7_BMP5_M		MAKEMASK(0xFF, 8)
#define GL_PREEXT_L2BMP4_7_BMP6_S		16
#define GL_PREEXT_L2BMP4_7_BMP6_M		MAKEMASK(0xFF, 16)
#define GL_PREEXT_L2BMP4_7_BMP7_S		24
#define GL_PREEXT_L2BMP4_7_BMP7_M		MAKEMASK(0xFF, 24)
#define GL_PREEXT_L2PRTMOD(_i)			(0x0020F09C + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PREEXT_L2PRTMOD_MAX_INDEX		2
#define GL_PREEXT_L2PRTMOD_XLT1_S		0
#define GL_PREEXT_L2PRTMOD_XLT1_M		MAKEMASK(0x3, 0)
#define GL_PREEXT_L2PRTMOD_XLT2_S		8
#define GL_PREEXT_L2PRTMOD_XLT2_M		MAKEMASK(0x3, 8)
#define GL_PREEXT_N2N_L2ADDR(_i)		(0x0020F15C + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PREEXT_N2N_L2ADDR_MAX_INDEX		2
#define GL_PREEXT_N2N_L2ADDR_LINE_IDX_S		0
#define GL_PREEXT_N2N_L2ADDR_LINE_IDX_M		MAKEMASK(0x3F, 0)
#define GL_PREEXT_N2N_L2ADDR_AUTO_INC_S		31
#define GL_PREEXT_N2N_L2ADDR_AUTO_INC_M		BIT(31)
#define GL_PREEXT_N2N_L2DATA(_i)		(0x0020F168 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PREEXT_N2N_L2DATA_MAX_INDEX		2
#define GL_PREEXT_N2N_L2DATA_DATA0_S		0
#define GL_PREEXT_N2N_L2DATA_DATA0_M		MAKEMASK(0xFF, 0)
#define GL_PREEXT_N2N_L2DATA_DATA1_S		8
#define GL_PREEXT_N2N_L2DATA_DATA1_M		MAKEMASK(0xFF, 8)
#define GL_PREEXT_N2N_L2DATA_DATA2_S		16
#define GL_PREEXT_N2N_L2DATA_DATA2_M		MAKEMASK(0xFF, 16)
#define GL_PREEXT_N2N_L2DATA_DATA3_S		24
#define GL_PREEXT_N2N_L2DATA_DATA3_M		MAKEMASK(0xFF, 24)
#define GL_PREEXT_P2P_L1ADDR(_i)		(0x0020F024 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PREEXT_P2P_L1ADDR_MAX_INDEX		2
#define GL_PREEXT_P2P_L1ADDR_LINE_IDX_S		0
#define GL_PREEXT_P2P_L1ADDR_LINE_IDX_M		BIT(0)
#define GL_PREEXT_P2P_L1ADDR_AUTO_INC_S		31
#define GL_PREEXT_P2P_L1ADDR_AUTO_INC_M		BIT(31)
#define GL_PREEXT_P2P_L1DATA(_i)		(0x0020F030 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PREEXT_P2P_L1DATA_MAX_INDEX		2
#define GL_PREEXT_P2P_L1DATA_DATA_S		0
#define GL_PREEXT_P2P_L1DATA_DATA_M		MAKEMASK(0xFFFFFFFF, 0)
#define GL_PREEXT_PID_L2GKTYPE(_i)		(0x0020F0F0 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PREEXT_PID_L2GKTYPE_MAX_INDEX	2
#define GL_PREEXT_PID_L2GKTYPE_PID_GKTYPE_S	0
#define GL_PREEXT_PID_L2GKTYPE_PID_GKTYPE_M	MAKEMASK(0x3, 0)
#define GL_PREEXT_PLVL_SEL(_i)			(0x0020F00C + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PREEXT_PLVL_SEL_MAX_INDEX		2
#define GL_PREEXT_PLVL_SEL_PLVL_SEL_S		0
#define GL_PREEXT_PLVL_SEL_PLVL_SEL_M		BIT(0)
#define GL_PREEXT_TCAM_L2ADDR(_i)		(0x0020F114 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PREEXT_TCAM_L2ADDR_MAX_INDEX		2
#define GL_PREEXT_TCAM_L2ADDR_LINE_IDX_S	0
#define GL_PREEXT_TCAM_L2ADDR_LINE_IDX_M	MAKEMASK(0x3FF, 0)
#define GL_PREEXT_TCAM_L2ADDR_AUTO_INC_S	31
#define GL_PREEXT_TCAM_L2ADDR_AUTO_INC_M	BIT(31)
#define GL_PREEXT_TCAM_L2DATALSB(_i)		(0x0020F120 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PREEXT_TCAM_L2DATALSB_MAX_INDEX	2
#define GL_PREEXT_TCAM_L2DATALSB_DATALSB_S	0
#define GL_PREEXT_TCAM_L2DATALSB_DATALSB_M	MAKEMASK(0xFFFFFFFF, 0)
#define GL_PREEXT_TCAM_L2DATAMSB(_i)		(0x0020F12C + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PREEXT_TCAM_L2DATAMSB_MAX_INDEX	2
#define GL_PREEXT_TCAM_L2DATAMSB_DATAMSB_S	0
#define GL_PREEXT_TCAM_L2DATAMSB_DATAMSB_M	MAKEMASK(0xFF, 0)
#define GL_PREEXT_XLT0_L1ADDR(_i)		(0x0020F03C + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PREEXT_XLT0_L1ADDR_MAX_INDEX		2
#define GL_PREEXT_XLT0_L1ADDR_LINE_IDX_S	0
#define GL_PREEXT_XLT0_L1ADDR_LINE_IDX_M	MAKEMASK(0xFF, 0)
#define GL_PREEXT_XLT0_L1ADDR_AUTO_INC_S	31
#define GL_PREEXT_XLT0_L1ADDR_AUTO_INC_M	BIT(31)
#define GL_PREEXT_XLT0_L1DATA(_i)		(0x0020F048 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PREEXT_XLT0_L1DATA_MAX_INDEX		2
#define GL_PREEXT_XLT0_L1DATA_DATA_S		0
#define GL_PREEXT_XLT0_L1DATA_DATA_M		MAKEMASK(0xFFFFFFFF, 0)
#define GL_PREEXT_XLT1_L2ADDR(_i)		(0x0020F0C0 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PREEXT_XLT1_L2ADDR_MAX_INDEX		2
#define GL_PREEXT_XLT1_L2ADDR_LINE_IDX_S	0
#define GL_PREEXT_XLT1_L2ADDR_LINE_IDX_M	MAKEMASK(0x7FF, 0)
#define GL_PREEXT_XLT1_L2ADDR_AUTO_INC_S	31
#define GL_PREEXT_XLT1_L2ADDR_AUTO_INC_M	BIT(31)
#define GL_PREEXT_XLT1_L2DATA(_i)		(0x0020F0CC + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PREEXT_XLT1_L2DATA_MAX_INDEX		2
#define GL_PREEXT_XLT1_L2DATA_DATA_S		0
#define GL_PREEXT_XLT1_L2DATA_DATA_M		MAKEMASK(0xFFFFFFFF, 0)
#define GL_PREEXT_XLT2_L2ADDR(_i)		(0x0020F0D8 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PREEXT_XLT2_L2ADDR_MAX_INDEX		2
#define GL_PREEXT_XLT2_L2ADDR_LINE_IDX_S	0
#define GL_PREEXT_XLT2_L2ADDR_LINE_IDX_M	MAKEMASK(0x1FF, 0)
#define GL_PREEXT_XLT2_L2ADDR_AUTO_INC_S	31
#define GL_PREEXT_XLT2_L2ADDR_AUTO_INC_M	BIT(31)
#define GL_PREEXT_XLT2_L2DATA(_i)		(0x0020F0E4 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PREEXT_XLT2_L2DATA_MAX_INDEX		2
#define GL_PREEXT_XLT2_L2DATA_DATA_S		0
#define GL_PREEXT_XLT2_L2DATA_DATA_M		MAKEMASK(0xFFFFFFFF, 0)
#define GL_PSTEXT_CDMD_L1SEL(_i)		(0x0020E054 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PSTEXT_CDMD_L1SEL_MAX_INDEX		2
#define GL_PSTEXT_CDMD_L1SEL_RX_SEL_S		0
#define GL_PSTEXT_CDMD_L1SEL_RX_SEL_M		MAKEMASK(0x1F, 0)
#define GL_PSTEXT_CDMD_L1SEL_TX_SEL_S		8
#define GL_PSTEXT_CDMD_L1SEL_TX_SEL_M		MAKEMASK(0x1F, 8)
#define GL_PSTEXT_CDMD_L1SEL_AUX0_SEL_S		16
#define GL_PSTEXT_CDMD_L1SEL_AUX0_SEL_M		MAKEMASK(0x1F, 16)
#define GL_PSTEXT_CDMD_L1SEL_AUX1_SEL_S		24
#define GL_PSTEXT_CDMD_L1SEL_AUX1_SEL_M		MAKEMASK(0x1F, 24)
#define GL_PSTEXT_CDMD_L1SEL_BIDIR_ENA_S	30
#define GL_PSTEXT_CDMD_L1SEL_BIDIR_ENA_M	MAKEMASK(0x3, 30)
#define GL_PSTEXT_CTLTBL_L2ADDR(_i)		(0x0020E084 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PSTEXT_CTLTBL_L2ADDR_MAX_INDEX	2
#define GL_PSTEXT_CTLTBL_L2ADDR_LINE_OFF_S	0
#define GL_PSTEXT_CTLTBL_L2ADDR_LINE_OFF_M	MAKEMASK(0x7, 0)
#define GL_PSTEXT_CTLTBL_L2ADDR_LINE_IDX_S	8
#define GL_PSTEXT_CTLTBL_L2ADDR_LINE_IDX_M	MAKEMASK(0x7, 8)
#define GL_PSTEXT_CTLTBL_L2ADDR_AUTO_INC_S	31
#define GL_PSTEXT_CTLTBL_L2ADDR_AUTO_INC_M	BIT(31)
#define GL_PSTEXT_CTLTBL_L2DATA(_i)		(0x0020E090 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PSTEXT_CTLTBL_L2DATA_MAX_INDEX	2
#define GL_PSTEXT_CTLTBL_L2DATA_DATA_S		0
#define GL_PSTEXT_CTLTBL_L2DATA_DATA_M		MAKEMASK(0xFFFFFFFF, 0)
#define GL_PSTEXT_DFLT_L2PRFL(_i)		(0x0020E138 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PSTEXT_DFLT_L2PRFL_MAX_INDEX		2
#define GL_PSTEXT_DFLT_L2PRFL_DFLT_PRFL_S	0
#define GL_PSTEXT_DFLT_L2PRFL_DFLT_PRFL_M	MAKEMASK(0xFFFF, 0)
#define GL_PSTEXT_FL15_BMPLSB(_i)		(0x0020E480 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PSTEXT_FL15_BMPLSB_MAX_INDEX		2
#define GL_PSTEXT_FL15_BMPLSB_BMPLSB_S		0
#define GL_PSTEXT_FL15_BMPLSB_BMPLSB_M		MAKEMASK(0xFFFFFFFF, 0)
#define GL_PSTEXT_FL15_BMPMSB(_i)		(0x0020E48C + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PSTEXT_FL15_BMPMSB_MAX_INDEX		2
#define GL_PSTEXT_FL15_BMPMSB_BMPMSB_S		0
#define GL_PSTEXT_FL15_BMPMSB_BMPMSB_M		MAKEMASK(0xFFFFFFFF, 0)
#define GL_PSTEXT_FLGS_L1SEL0_1(_i)		(0x0020E06C + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PSTEXT_FLGS_L1SEL0_1_MAX_INDEX	2
#define GL_PSTEXT_FLGS_L1SEL0_1_FLS0_S		0
#define GL_PSTEXT_FLGS_L1SEL0_1_FLS0_M		MAKEMASK(0x1FF, 0)
#define GL_PSTEXT_FLGS_L1SEL0_1_FLS1_S		16
#define GL_PSTEXT_FLGS_L1SEL0_1_FLS1_M		MAKEMASK(0x1FF, 16)
#define GL_PSTEXT_FLGS_L1SEL2_3(_i)		(0x0020E078 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PSTEXT_FLGS_L1SEL2_3_MAX_INDEX	2
#define GL_PSTEXT_FLGS_L1SEL2_3_FLS2_S		0
#define GL_PSTEXT_FLGS_L1SEL2_3_FLS2_M		MAKEMASK(0x1FF, 0)
#define GL_PSTEXT_FLGS_L1SEL2_3_FLS3_S		16
#define GL_PSTEXT_FLGS_L1SEL2_3_FLS3_M		MAKEMASK(0x1FF, 16)
#define GL_PSTEXT_FLGS_L1TBL(_i)		(0x0020E060 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PSTEXT_FLGS_L1TBL_MAX_INDEX		2
#define GL_PSTEXT_FLGS_L1TBL_LSB_S		0
#define GL_PSTEXT_FLGS_L1TBL_LSB_M		MAKEMASK(0xFFFF, 0)
#define GL_PSTEXT_FLGS_L1TBL_MSB_S		16
#define GL_PSTEXT_FLGS_L1TBL_MSB_M		MAKEMASK(0xFFFF, 16)
#define GL_PSTEXT_FORCE_L1CDID(_i)		(0x0020E018 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PSTEXT_FORCE_L1CDID_MAX_INDEX	2
#define GL_PSTEXT_FORCE_L1CDID_STATIC_CDID_S	0
#define GL_PSTEXT_FORCE_L1CDID_STATIC_CDID_M	MAKEMASK(0xF, 0)
#define GL_PSTEXT_FORCE_L1CDID_STATIC_CDID_EN_S 31
#define GL_PSTEXT_FORCE_L1CDID_STATIC_CDID_EN_M BIT(31)
#define GL_PSTEXT_FORCE_PID(_i)			(0x0020E000 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PSTEXT_FORCE_PID_MAX_INDEX		2
#define GL_PSTEXT_FORCE_PID_STATIC_PID_S	0
#define GL_PSTEXT_FORCE_PID_STATIC_PID_M	MAKEMASK(0xFFFF, 0)
#define GL_PSTEXT_FORCE_PID_STATIC_PID_EN_S	31
#define GL_PSTEXT_FORCE_PID_STATIC_PID_EN_M	BIT(31)
#define GL_PSTEXT_K2N_L2ADDR(_i)		(0x0020E144 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PSTEXT_K2N_L2ADDR_MAX_INDEX		2
#define GL_PSTEXT_K2N_L2ADDR_LINE_IDX_S		0
#define GL_PSTEXT_K2N_L2ADDR_LINE_IDX_M		MAKEMASK(0x7F, 0)
#define GL_PSTEXT_K2N_L2ADDR_AUTO_INC_S		31
#define GL_PSTEXT_K2N_L2ADDR_AUTO_INC_M		BIT(31)
#define GL_PSTEXT_K2N_L2DATA(_i)		(0x0020E150 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PSTEXT_K2N_L2DATA_MAX_INDEX		2
#define GL_PSTEXT_K2N_L2DATA_DATA0_S		0
#define GL_PSTEXT_K2N_L2DATA_DATA0_M		MAKEMASK(0xFF, 0)
#define GL_PSTEXT_K2N_L2DATA_DATA1_S		8
#define GL_PSTEXT_K2N_L2DATA_DATA1_M		MAKEMASK(0xFF, 8)
#define GL_PSTEXT_K2N_L2DATA_DATA2_S		16
#define GL_PSTEXT_K2N_L2DATA_DATA2_M		MAKEMASK(0xFF, 16)
#define GL_PSTEXT_K2N_L2DATA_DATA3_S		24
#define GL_PSTEXT_K2N_L2DATA_DATA3_M		MAKEMASK(0xFF, 24)
#define GL_PSTEXT_L2_PMASK0(_i)			(0x0020E0FC + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PSTEXT_L2_PMASK0_MAX_INDEX		2
#define GL_PSTEXT_L2_PMASK0_BITMASK_S		0
#define GL_PSTEXT_L2_PMASK0_BITMASK_M		MAKEMASK(0xFFFFFFFF, 0)
#define GL_PSTEXT_L2_PMASK1(_i)			(0x0020E108 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PSTEXT_L2_PMASK1_MAX_INDEX		2
#define GL_PSTEXT_L2_PMASK1_BITMASK_S		0
#define GL_PSTEXT_L2_PMASK1_BITMASK_M		MAKEMASK(0xFFFF, 0)
#define GL_PSTEXT_L2_TMASK0(_i)			(0x0020E498 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PSTEXT_L2_TMASK0_MAX_INDEX		2
#define GL_PSTEXT_L2_TMASK0_BITMASK_S		0
#define GL_PSTEXT_L2_TMASK0_BITMASK_M		MAKEMASK(0xFFFFFFFF, 0)
#define GL_PSTEXT_L2_TMASK1(_i)			(0x0020E4A4 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PSTEXT_L2_TMASK1_MAX_INDEX		2
#define GL_PSTEXT_L2_TMASK1_BITMASK_S		0
#define GL_PSTEXT_L2_TMASK1_BITMASK_M		MAKEMASK(0xFF, 0)
#define GL_PSTEXT_L2PRTMOD(_i)			(0x0020E09C + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PSTEXT_L2PRTMOD_MAX_INDEX		2
#define GL_PSTEXT_L2PRTMOD_XLT1_S		0
#define GL_PSTEXT_L2PRTMOD_XLT1_M		MAKEMASK(0x3, 0)
#define GL_PSTEXT_L2PRTMOD_XLT2_S		8
#define GL_PSTEXT_L2PRTMOD_XLT2_M		MAKEMASK(0x3, 8)
#define GL_PSTEXT_N2N_L2ADDR(_i)		(0x0020E15C + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PSTEXT_N2N_L2ADDR_MAX_INDEX		2
#define GL_PSTEXT_N2N_L2ADDR_LINE_IDX_S		0
#define GL_PSTEXT_N2N_L2ADDR_LINE_IDX_M		MAKEMASK(0x3F, 0)
#define GL_PSTEXT_N2N_L2ADDR_AUTO_INC_S		31
#define GL_PSTEXT_N2N_L2ADDR_AUTO_INC_M		BIT(31)
#define GL_PSTEXT_N2N_L2DATA(_i)		(0x0020E168 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PSTEXT_N2N_L2DATA_MAX_INDEX		2
#define GL_PSTEXT_N2N_L2DATA_DATA0_S		0
#define GL_PSTEXT_N2N_L2DATA_DATA0_M		MAKEMASK(0xFF, 0)
#define GL_PSTEXT_N2N_L2DATA_DATA1_S		8
#define GL_PSTEXT_N2N_L2DATA_DATA1_M		MAKEMASK(0xFF, 8)
#define GL_PSTEXT_N2N_L2DATA_DATA2_S		16
#define GL_PSTEXT_N2N_L2DATA_DATA2_M		MAKEMASK(0xFF, 16)
#define GL_PSTEXT_N2N_L2DATA_DATA3_S		24
#define GL_PSTEXT_N2N_L2DATA_DATA3_M		MAKEMASK(0xFF, 24)
#define GL_PSTEXT_P2P_L1ADDR(_i)		(0x0020E024 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PSTEXT_P2P_L1ADDR_MAX_INDEX		2
#define GL_PSTEXT_P2P_L1ADDR_LINE_IDX_S		0
#define GL_PSTEXT_P2P_L1ADDR_LINE_IDX_M		BIT(0)
#define GL_PSTEXT_P2P_L1ADDR_AUTO_INC_S		31
#define GL_PSTEXT_P2P_L1ADDR_AUTO_INC_M		BIT(31)
#define GL_PSTEXT_P2P_L1DATA(_i)		(0x0020E030 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PSTEXT_P2P_L1DATA_MAX_INDEX		2
#define GL_PSTEXT_P2P_L1DATA_DATA_S		0
#define GL_PSTEXT_P2P_L1DATA_DATA_M		MAKEMASK(0xFFFFFFFF, 0)
#define GL_PSTEXT_PID_L2GKTYPE(_i)		(0x0020E0F0 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PSTEXT_PID_L2GKTYPE_MAX_INDEX	2
#define GL_PSTEXT_PID_L2GKTYPE_PID_GKTYPE_S	0
#define GL_PSTEXT_PID_L2GKTYPE_PID_GKTYPE_M	MAKEMASK(0x3, 0)
#define GL_PSTEXT_PLVL_SEL(_i)			(0x0020E00C + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PSTEXT_PLVL_SEL_MAX_INDEX		2
#define GL_PSTEXT_PLVL_SEL_PLVL_SEL_S		0
#define GL_PSTEXT_PLVL_SEL_PLVL_SEL_M		BIT(0)
#define GL_PSTEXT_PRFLM_CTRL(_i)		(0x0020E474 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PSTEXT_PRFLM_CTRL_MAX_INDEX		2
#define GL_PSTEXT_PRFLM_CTRL_PRFL_IDX_S		0
#define GL_PSTEXT_PRFLM_CTRL_PRFL_IDX_M		MAKEMASK(0xFF, 0)
#define GL_PSTEXT_PRFLM_CTRL_RD_REQ_S		30
#define GL_PSTEXT_PRFLM_CTRL_RD_REQ_M		BIT(30)
#define GL_PSTEXT_PRFLM_CTRL_WR_REQ_S		31
#define GL_PSTEXT_PRFLM_CTRL_WR_REQ_M		BIT(31)
#define GL_PSTEXT_PRFLM_DATA_0(_i)		(0x0020E174 + ((_i) * 4)) /* _i=0...63 */ /* Reset Source: CORER */
#define GL_PSTEXT_PRFLM_DATA_0_MAX_INDEX	63
#define GL_PSTEXT_PRFLM_DATA_0_PROT_S		0
#define GL_PSTEXT_PRFLM_DATA_0_PROT_M		MAKEMASK(0xFF, 0)
#define GL_PSTEXT_PRFLM_DATA_0_OFF_S		16
#define GL_PSTEXT_PRFLM_DATA_0_OFF_M		MAKEMASK(0x1FF, 16)
#define GL_PSTEXT_PRFLM_DATA_1(_i)		(0x0020E274 + ((_i) * 4)) /* _i=0...63 */ /* Reset Source: CORER */
#define GL_PSTEXT_PRFLM_DATA_1_MAX_INDEX	63
#define GL_PSTEXT_PRFLM_DATA_1_PROT_S		0
#define GL_PSTEXT_PRFLM_DATA_1_PROT_M		MAKEMASK(0xFF, 0)
#define GL_PSTEXT_PRFLM_DATA_1_OFF_S		16
#define GL_PSTEXT_PRFLM_DATA_1_OFF_M		MAKEMASK(0x1FF, 16)
#define GL_PSTEXT_PRFLM_DATA_2(_i)		(0x0020E374 + ((_i) * 4)) /* _i=0...63 */ /* Reset Source: CORER */
#define GL_PSTEXT_PRFLM_DATA_2_MAX_INDEX	63
#define GL_PSTEXT_PRFLM_DATA_2_PROT_S		0
#define GL_PSTEXT_PRFLM_DATA_2_PROT_M		MAKEMASK(0xFF, 0)
#define GL_PSTEXT_PRFLM_DATA_2_OFF_S		16
#define GL_PSTEXT_PRFLM_DATA_2_OFF_M		MAKEMASK(0x1FF, 16)
#define GL_PSTEXT_TCAM_L2ADDR(_i)		(0x0020E114 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PSTEXT_TCAM_L2ADDR_MAX_INDEX		2
#define GL_PSTEXT_TCAM_L2ADDR_LINE_IDX_S	0
#define GL_PSTEXT_TCAM_L2ADDR_LINE_IDX_M	MAKEMASK(0x3FF, 0)
#define GL_PSTEXT_TCAM_L2ADDR_AUTO_INC_S	31
#define GL_PSTEXT_TCAM_L2ADDR_AUTO_INC_M	BIT(31)
#define GL_PSTEXT_TCAM_L2DATALSB(_i)		(0x0020E120 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PSTEXT_TCAM_L2DATALSB_MAX_INDEX	2
#define GL_PSTEXT_TCAM_L2DATALSB_DATALSB_S	0
#define GL_PSTEXT_TCAM_L2DATALSB_DATALSB_M	MAKEMASK(0xFFFFFFFF, 0)
#define GL_PSTEXT_TCAM_L2DATAMSB(_i)		(0x0020E12C + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PSTEXT_TCAM_L2DATAMSB_MAX_INDEX	2
#define GL_PSTEXT_TCAM_L2DATAMSB_DATAMSB_S	0
#define GL_PSTEXT_TCAM_L2DATAMSB_DATAMSB_M	MAKEMASK(0xFF, 0)
#define GL_PSTEXT_XLT0_L1ADDR(_i)		(0x0020E03C + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PSTEXT_XLT0_L1ADDR_MAX_INDEX		2
#define GL_PSTEXT_XLT0_L1ADDR_LINE_IDX_S	0
#define GL_PSTEXT_XLT0_L1ADDR_LINE_IDX_M	MAKEMASK(0xFF, 0)
#define GL_PSTEXT_XLT0_L1ADDR_AUTO_INC_S	31
#define GL_PSTEXT_XLT0_L1ADDR_AUTO_INC_M	BIT(31)
#define GL_PSTEXT_XLT0_L1DATA(_i)		(0x0020E048 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PSTEXT_XLT0_L1DATA_MAX_INDEX		2
#define GL_PSTEXT_XLT0_L1DATA_DATA_S		0
#define GL_PSTEXT_XLT0_L1DATA_DATA_M		MAKEMASK(0xFFFFFFFF, 0)
#define GL_PSTEXT_XLT1_L2ADDR(_i)		(0x0020E0C0 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PSTEXT_XLT1_L2ADDR_MAX_INDEX		2
#define GL_PSTEXT_XLT1_L2ADDR_LINE_IDX_S	0
#define GL_PSTEXT_XLT1_L2ADDR_LINE_IDX_M	MAKEMASK(0x7FF, 0)
#define GL_PSTEXT_XLT1_L2ADDR_AUTO_INC_S	31
#define GL_PSTEXT_XLT1_L2ADDR_AUTO_INC_M	BIT(31)
#define GL_PSTEXT_XLT1_L2DATA(_i)		(0x0020E0CC + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PSTEXT_XLT1_L2DATA_MAX_INDEX		2
#define GL_PSTEXT_XLT1_L2DATA_DATA_S		0
#define GL_PSTEXT_XLT1_L2DATA_DATA_M		MAKEMASK(0xFFFFFFFF, 0)
#define GL_PSTEXT_XLT2_L2ADDR(_i)		(0x0020E0D8 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PSTEXT_XLT2_L2ADDR_MAX_INDEX		2
#define GL_PSTEXT_XLT2_L2ADDR_LINE_IDX_S	0
#define GL_PSTEXT_XLT2_L2ADDR_LINE_IDX_M	MAKEMASK(0x1FF, 0)
#define GL_PSTEXT_XLT2_L2ADDR_AUTO_INC_S	31
#define GL_PSTEXT_XLT2_L2ADDR_AUTO_INC_M	BIT(31)
#define GL_PSTEXT_XLT2_L2DATA(_i)		(0x0020E0E4 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GL_PSTEXT_XLT2_L2DATA_MAX_INDEX		2
#define GL_PSTEXT_XLT2_L2DATA_DATA_S		0
#define GL_PSTEXT_XLT2_L2DATA_DATA_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLFLXP_PTYPE_TRANSLATION(_i)		(0x0045C000 + ((_i) * 4)) /* _i=0...255 */ /* Reset Source: CORER */
#define GLFLXP_PTYPE_TRANSLATION_MAX_INDEX	255
#define GLFLXP_PTYPE_TRANSLATION_PTYPE_4N_S	0
#define GLFLXP_PTYPE_TRANSLATION_PTYPE_4N_M	MAKEMASK(0xFF, 0)
#define GLFLXP_PTYPE_TRANSLATION_PTYPE_4N_1_S	8
#define GLFLXP_PTYPE_TRANSLATION_PTYPE_4N_1_M	MAKEMASK(0xFF, 8)
#define GLFLXP_PTYPE_TRANSLATION_PTYPE_4N_2_S	16
#define GLFLXP_PTYPE_TRANSLATION_PTYPE_4N_2_M	MAKEMASK(0xFF, 16)
#define GLFLXP_PTYPE_TRANSLATION_PTYPE_4N_3_S	24
#define GLFLXP_PTYPE_TRANSLATION_PTYPE_4N_3_M	MAKEMASK(0xFF, 24)
#define GLFLXP_RX_CMD_LX_PROT_IDX(_i)		(0x0045C400 + ((_i) * 4)) /* _i=0...255 */ /* Reset Source: CORER */
#define GLFLXP_RX_CMD_LX_PROT_IDX_MAX_INDEX	255
#define GLFLXP_RX_CMD_LX_PROT_IDX_INNER_CLOUD_OFFSET_INDEX_S 0
#define GLFLXP_RX_CMD_LX_PROT_IDX_INNER_CLOUD_OFFSET_INDEX_M MAKEMASK(0x7, 0)
#define GLFLXP_RX_CMD_LX_PROT_IDX_L4_OFFSET_INDEX_S 4
#define GLFLXP_RX_CMD_LX_PROT_IDX_L4_OFFSET_INDEX_M MAKEMASK(0x7, 4)
#define GLFLXP_RX_CMD_LX_PROT_IDX_PAYLOAD_OFFSET_INDEX_S 8
#define GLFLXP_RX_CMD_LX_PROT_IDX_PAYLOAD_OFFSET_INDEX_M MAKEMASK(0x7, 8)
#define GLFLXP_RX_CMD_LX_PROT_IDX_L3_PROTOCOL_S 12
#define GLFLXP_RX_CMD_LX_PROT_IDX_L3_PROTOCOL_M MAKEMASK(0x3, 12)
#define GLFLXP_RX_CMD_LX_PROT_IDX_L4_PROTOCOL_S 14
#define GLFLXP_RX_CMD_LX_PROT_IDX_L4_PROTOCOL_M MAKEMASK(0x3, 14)
#define GLFLXP_RX_CMD_PROTIDS(_i, _j)		(0x0045A000 + ((_i) * 4 + (_j) * 1024)) /* _i=0...255, _j=0...5 */ /* Reset Source: CORER */
#define GLFLXP_RX_CMD_PROTIDS_MAX_INDEX		255
#define GLFLXP_RX_CMD_PROTIDS_PROTID_4N_S	0
#define GLFLXP_RX_CMD_PROTIDS_PROTID_4N_M	MAKEMASK(0xFF, 0)
#define GLFLXP_RX_CMD_PROTIDS_PROTID_4N_1_S	8
#define GLFLXP_RX_CMD_PROTIDS_PROTID_4N_1_M	MAKEMASK(0xFF, 8)
#define GLFLXP_RX_CMD_PROTIDS_PROTID_4N_2_S	16
#define GLFLXP_RX_CMD_PROTIDS_PROTID_4N_2_M	MAKEMASK(0xFF, 16)
#define GLFLXP_RX_CMD_PROTIDS_PROTID_4N_3_S	24
#define GLFLXP_RX_CMD_PROTIDS_PROTID_4N_3_M	MAKEMASK(0xFF, 24)
#define GLFLXP_RXDID_FLAGS(_i, _j)		(0x0045D000 + ((_i) * 4 + (_j) * 256)) /* _i=0...63, _j=0...4 */ /* Reset Source: CORER */
#define GLFLXP_RXDID_FLAGS_MAX_INDEX		63
#define GLFLXP_RXDID_FLAGS_FLEXIFLAG_4N_S	0
#define GLFLXP_RXDID_FLAGS_FLEXIFLAG_4N_M	MAKEMASK(0x3F, 0)
#define GLFLXP_RXDID_FLAGS_FLEXIFLAG_4N_1_S	8
#define GLFLXP_RXDID_FLAGS_FLEXIFLAG_4N_1_M	MAKEMASK(0x3F, 8)
#define GLFLXP_RXDID_FLAGS_FLEXIFLAG_4N_2_S	16
#define GLFLXP_RXDID_FLAGS_FLEXIFLAG_4N_2_M	MAKEMASK(0x3F, 16)
#define GLFLXP_RXDID_FLAGS_FLEXIFLAG_4N_3_S	24
#define GLFLXP_RXDID_FLAGS_FLEXIFLAG_4N_3_M	MAKEMASK(0x3F, 24)
#define GLFLXP_RXDID_FLAGS1_OVERRIDE(_i)	(0x0045D600 + ((_i) * 4)) /* _i=0...63 */ /* Reset Source: CORER */
#define GLFLXP_RXDID_FLAGS1_OVERRIDE_MAX_INDEX	63
#define GLFLXP_RXDID_FLAGS1_OVERRIDE_FLEXIFLAGS1_OVERRIDE_S 0
#define GLFLXP_RXDID_FLAGS1_OVERRIDE_FLEXIFLAGS1_OVERRIDE_M MAKEMASK(0xF, 0)
#define GLFLXP_RXDID_FLX_WRD_0(_i)		(0x0045C800 + ((_i) * 4)) /* _i=0...63 */ /* Reset Source: CORER */
#define GLFLXP_RXDID_FLX_WRD_0_MAX_INDEX	63
#define GLFLXP_RXDID_FLX_WRD_0_PROT_MDID_S	0
#define GLFLXP_RXDID_FLX_WRD_0_PROT_MDID_M	MAKEMASK(0xFF, 0)
#define GLFLXP_RXDID_FLX_WRD_0_EXTRACTION_OFFSET_S 8
#define GLFLXP_RXDID_FLX_WRD_0_EXTRACTION_OFFSET_M MAKEMASK(0x3FF, 8)
#define GLFLXP_RXDID_FLX_WRD_0_RXDID_OPCODE_S	30
#define GLFLXP_RXDID_FLX_WRD_0_RXDID_OPCODE_M	MAKEMASK(0x3, 30)
#define GLFLXP_RXDID_FLX_WRD_1(_i)		(0x0045C900 + ((_i) * 4)) /* _i=0...63 */ /* Reset Source: CORER */
#define GLFLXP_RXDID_FLX_WRD_1_MAX_INDEX	63
#define GLFLXP_RXDID_FLX_WRD_1_PROT_MDID_S	0
#define GLFLXP_RXDID_FLX_WRD_1_PROT_MDID_M	MAKEMASK(0xFF, 0)
#define GLFLXP_RXDID_FLX_WRD_1_EXTRACTION_OFFSET_S 8
#define GLFLXP_RXDID_FLX_WRD_1_EXTRACTION_OFFSET_M MAKEMASK(0x3FF, 8)
#define GLFLXP_RXDID_FLX_WRD_1_RXDID_OPCODE_S	30
#define GLFLXP_RXDID_FLX_WRD_1_RXDID_OPCODE_M	MAKEMASK(0x3, 30)
#define GLFLXP_RXDID_FLX_WRD_2(_i)		(0x0045CA00 + ((_i) * 4)) /* _i=0...63 */ /* Reset Source: CORER */
#define GLFLXP_RXDID_FLX_WRD_2_MAX_INDEX	63
#define GLFLXP_RXDID_FLX_WRD_2_PROT_MDID_S	0
#define GLFLXP_RXDID_FLX_WRD_2_PROT_MDID_M	MAKEMASK(0xFF, 0)
#define GLFLXP_RXDID_FLX_WRD_2_EXTRACTION_OFFSET_S 8
#define GLFLXP_RXDID_FLX_WRD_2_EXTRACTION_OFFSET_M MAKEMASK(0x3FF, 8)
#define GLFLXP_RXDID_FLX_WRD_2_RXDID_OPCODE_S	30
#define GLFLXP_RXDID_FLX_WRD_2_RXDID_OPCODE_M	MAKEMASK(0x3, 30)
#define GLFLXP_RXDID_FLX_WRD_3(_i)		(0x0045CB00 + ((_i) * 4)) /* _i=0...63 */ /* Reset Source: CORER */
#define GLFLXP_RXDID_FLX_WRD_3_MAX_INDEX	63
#define GLFLXP_RXDID_FLX_WRD_3_PROT_MDID_S	0
#define GLFLXP_RXDID_FLX_WRD_3_PROT_MDID_M	MAKEMASK(0xFF, 0)
#define GLFLXP_RXDID_FLX_WRD_3_EXTRACTION_OFFSET_S 8
#define GLFLXP_RXDID_FLX_WRD_3_EXTRACTION_OFFSET_M MAKEMASK(0x3FF, 8)
#define GLFLXP_RXDID_FLX_WRD_3_RXDID_OPCODE_S	30
#define GLFLXP_RXDID_FLX_WRD_3_RXDID_OPCODE_M	MAKEMASK(0x3, 30)
#define GLFLXP_RXDID_FLX_WRD_4(_i)		(0x0045CC00 + ((_i) * 4)) /* _i=0...63 */ /* Reset Source: CORER */
#define GLFLXP_RXDID_FLX_WRD_4_MAX_INDEX	63
#define GLFLXP_RXDID_FLX_WRD_4_PROT_MDID_S	0
#define GLFLXP_RXDID_FLX_WRD_4_PROT_MDID_M	MAKEMASK(0xFF, 0)
#define GLFLXP_RXDID_FLX_WRD_4_EXTRACTION_OFFSET_S 8
#define GLFLXP_RXDID_FLX_WRD_4_EXTRACTION_OFFSET_M MAKEMASK(0x3FF, 8)
#define GLFLXP_RXDID_FLX_WRD_4_RXDID_OPCODE_S	30
#define GLFLXP_RXDID_FLX_WRD_4_RXDID_OPCODE_M	MAKEMASK(0x3, 30)
#define GLFLXP_RXDID_FLX_WRD_5(_i)		(0x0045CD00 + ((_i) * 4)) /* _i=0...63 */ /* Reset Source: CORER */
#define GLFLXP_RXDID_FLX_WRD_5_MAX_INDEX	63
#define GLFLXP_RXDID_FLX_WRD_5_PROT_MDID_S	0
#define GLFLXP_RXDID_FLX_WRD_5_PROT_MDID_M	MAKEMASK(0xFF, 0)
#define GLFLXP_RXDID_FLX_WRD_5_EXTRACTION_OFFSET_S 8
#define GLFLXP_RXDID_FLX_WRD_5_EXTRACTION_OFFSET_M MAKEMASK(0x3FF, 8)
#define GLFLXP_RXDID_FLX_WRD_5_RXDID_OPCODE_S	30
#define GLFLXP_RXDID_FLX_WRD_5_RXDID_OPCODE_M	MAKEMASK(0x3, 30)
#define GLFLXP_TX_SCHED_CORRECT(_i, _j)		(0x00458000 + ((_i) * 4 + (_j) * 256)) /* _i=0...63, _j=0...31 */ /* Reset Source: CORER */
#define GLFLXP_TX_SCHED_CORRECT_MAX_INDEX	63
#define GLFLXP_TX_SCHED_CORRECT_PROTD_ID_2N_S	0
#define GLFLXP_TX_SCHED_CORRECT_PROTD_ID_2N_M	MAKEMASK(0xFF, 0)
#define GLFLXP_TX_SCHED_CORRECT_RECIPE_2N_S	8
#define GLFLXP_TX_SCHED_CORRECT_RECIPE_2N_M	MAKEMASK(0x1F, 8)
#define GLFLXP_TX_SCHED_CORRECT_PROTD_ID_2N_1_S 16
#define GLFLXP_TX_SCHED_CORRECT_PROTD_ID_2N_1_M MAKEMASK(0xFF, 16)
#define GLFLXP_TX_SCHED_CORRECT_RECIPE_2N_1_S	24
#define GLFLXP_TX_SCHED_CORRECT_RECIPE_2N_1_M	MAKEMASK(0x1F, 24)
#define QRXFLXP_CNTXT(_QRX)			(0x00480000 + ((_QRX) * 4)) /* _i=0...2047 */ /* Reset Source: CORER */
#define QRXFLXP_CNTXT_MAX_INDEX			2047
#define QRXFLXP_CNTXT_RXDID_IDX_S		0
#define QRXFLXP_CNTXT_RXDID_IDX_M		MAKEMASK(0x3F, 0)
#define QRXFLXP_CNTXT_RXDID_PRIO_S		8
#define QRXFLXP_CNTXT_RXDID_PRIO_M		MAKEMASK(0x7, 8)
#define QRXFLXP_CNTXT_TS_S			11
#define QRXFLXP_CNTXT_TS_M			BIT(11)
#define GL_FWSTS				0x00083048 /* Reset Source: POR */
#define GL_FWSTS_FWS0B_S			0
#define GL_FWSTS_FWS0B_M			MAKEMASK(0xFF, 0)
#define GL_FWSTS_FWROWD_S			8
#define GL_FWSTS_FWROWD_M			BIT(8)
#define GL_FWSTS_FWRI_S				9
#define GL_FWSTS_FWRI_M				BIT(9)
#define GL_FWSTS_FWS1B_S			16
#define GL_FWSTS_FWS1B_M			MAKEMASK(0xFF, 16)
#define GL_TCVMLR_DRAIN_CNTR_CTL		0x000A21E0 /* Reset Source: CORER */
#define GL_TCVMLR_DRAIN_CNTR_CTL_OP_S		0
#define GL_TCVMLR_DRAIN_CNTR_CTL_OP_M		BIT(0)
#define GL_TCVMLR_DRAIN_CNTR_CTL_PORT_S		1
#define GL_TCVMLR_DRAIN_CNTR_CTL_PORT_M		MAKEMASK(0x7, 1)
#define GL_TCVMLR_DRAIN_CNTR_CTL_VALUE_S	4
#define GL_TCVMLR_DRAIN_CNTR_CTL_VALUE_M	MAKEMASK(0x3FFF, 4)
#define GL_TCVMLR_DRAIN_DONE_DEC		0x000A21A8 /* Reset Source: CORER */
#define GL_TCVMLR_DRAIN_DONE_DEC_TARGET_S	0
#define GL_TCVMLR_DRAIN_DONE_DEC_TARGET_M	BIT(0)
#define GL_TCVMLR_DRAIN_DONE_DEC_INDEX_S	1
#define GL_TCVMLR_DRAIN_DONE_DEC_INDEX_M	MAKEMASK(0x1F, 1)
#define GL_TCVMLR_DRAIN_DONE_DEC_VALUE_S	6
#define GL_TCVMLR_DRAIN_DONE_DEC_VALUE_M	MAKEMASK(0xFF, 6)
#define GL_TCVMLR_DRAIN_DONE_TCLAN(_i)		(0x000A20A8 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GL_TCVMLR_DRAIN_DONE_TCLAN_MAX_INDEX	31
#define GL_TCVMLR_DRAIN_DONE_TCLAN_COUNT_S	0
#define GL_TCVMLR_DRAIN_DONE_TCLAN_COUNT_M	MAKEMASK(0xFF, 0)
#define GL_TCVMLR_DRAIN_DONE_TPB(_i)		(0x000A2128 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GL_TCVMLR_DRAIN_DONE_TPB_MAX_INDEX	31
#define GL_TCVMLR_DRAIN_DONE_TPB_COUNT_S	0
#define GL_TCVMLR_DRAIN_DONE_TPB_COUNT_M	MAKEMASK(0xFF, 0)
#define GL_TCVMLR_DRAIN_MARKER			0x000A2008 /* Reset Source: CORER */
#define GL_TCVMLR_DRAIN_MARKER_PORT_S		0
#define GL_TCVMLR_DRAIN_MARKER_PORT_M		MAKEMASK(0x7, 0)
#define GL_TCVMLR_DRAIN_MARKER_TC_S		3
#define GL_TCVMLR_DRAIN_MARKER_TC_M		MAKEMASK(0x1F, 3)
#define GL_TCVMLR_ERR_STAT			0x000A2024 /* Reset Source: CORER */
#define GL_TCVMLR_ERR_STAT_ERROR_S		0
#define GL_TCVMLR_ERR_STAT_ERROR_M		BIT(0)
#define GL_TCVMLR_ERR_STAT_FW_REQ_S		1
#define GL_TCVMLR_ERR_STAT_FW_REQ_M		BIT(1)
#define GL_TCVMLR_ERR_STAT_STAT_S		2
#define GL_TCVMLR_ERR_STAT_STAT_M		MAKEMASK(0x7, 2)
#define GL_TCVMLR_ERR_STAT_ENT_TYPE_S		5
#define GL_TCVMLR_ERR_STAT_ENT_TYPE_M		MAKEMASK(0x7, 5)
#define GL_TCVMLR_ERR_STAT_ENT_ID_S		8
#define GL_TCVMLR_ERR_STAT_ENT_ID_M		MAKEMASK(0x3FFF, 8)
#define GL_TCVMLR_QCFG				0x000A2010 /* Reset Source: CORER */
#define GL_TCVMLR_QCFG_QID_S			0
#define GL_TCVMLR_QCFG_QID_M			MAKEMASK(0x3FFF, 0)
#define GL_TCVMLR_QCFG_OP_S			14
#define GL_TCVMLR_QCFG_OP_M			BIT(14)
#define GL_TCVMLR_QCFG_PORT_S			15
#define GL_TCVMLR_QCFG_PORT_M			MAKEMASK(0x7, 15)
#define GL_TCVMLR_QCFG_TC_S			18
#define GL_TCVMLR_QCFG_TC_M			MAKEMASK(0x1F, 18)
#define GL_TCVMLR_QCFG_RD			0x000A2014 /* Reset Source: CORER */
#define GL_TCVMLR_QCFG_RD_QID_S			0
#define GL_TCVMLR_QCFG_RD_QID_M			MAKEMASK(0x3FFF, 0)
#define GL_TCVMLR_QCFG_RD_PORT_S		14
#define GL_TCVMLR_QCFG_RD_PORT_M		MAKEMASK(0x7, 14)
#define GL_TCVMLR_QCFG_RD_TC_S			17
#define GL_TCVMLR_QCFG_RD_TC_M			MAKEMASK(0x1F, 17)
#define GL_TCVMLR_QCNTR				0x000A200C /* Reset Source: CORER */
#define GL_TCVMLR_QCNTR_CNTR_S			0
#define GL_TCVMLR_QCNTR_CNTR_M			MAKEMASK(0x7FFF, 0)
#define GL_TCVMLR_QCTL				0x000A2004 /* Reset Source: CORER */
#define GL_TCVMLR_QCTL_QID_S			0
#define GL_TCVMLR_QCTL_QID_M			MAKEMASK(0x3FFF, 0)
#define GL_TCVMLR_QCTL_OP_S			14
#define GL_TCVMLR_QCTL_OP_M			BIT(14)
#define GL_TCVMLR_REQ_STAT			0x000A2018 /* Reset Source: CORER */
#define GL_TCVMLR_REQ_STAT_ENT_TYPE_S		0
#define GL_TCVMLR_REQ_STAT_ENT_TYPE_M		MAKEMASK(0x7, 0)
#define GL_TCVMLR_REQ_STAT_ENT_ID_S		3
#define GL_TCVMLR_REQ_STAT_ENT_ID_M		MAKEMASK(0x3FFF, 3)
#define GL_TCVMLR_REQ_STAT_OP_S			17
#define GL_TCVMLR_REQ_STAT_OP_M			BIT(17)
#define GL_TCVMLR_REQ_STAT_WRITE_STATUS_S	18
#define GL_TCVMLR_REQ_STAT_WRITE_STATUS_M	MAKEMASK(0x7, 18)
#define GL_TCVMLR_STAT				0x000A201C /* Reset Source: CORER */
#define GL_TCVMLR_STAT_ENT_TYPE_S		0
#define GL_TCVMLR_STAT_ENT_TYPE_M		MAKEMASK(0x7, 0)
#define GL_TCVMLR_STAT_ENT_ID_S			3
#define GL_TCVMLR_STAT_ENT_ID_M			MAKEMASK(0x3FFF, 3)
#define GL_TCVMLR_STAT_STATUS_S			17
#define GL_TCVMLR_STAT_STATUS_M			MAKEMASK(0x7, 17)
#define GL_XLR_MARKER_TRIG_TCVMLR		0x000A2000 /* Reset Source: CORER */
#define GL_XLR_MARKER_TRIG_TCVMLR_VM_VF_NUM_S	0
#define GL_XLR_MARKER_TRIG_TCVMLR_VM_VF_NUM_M	MAKEMASK(0x3FF, 0)
#define GL_XLR_MARKER_TRIG_TCVMLR_VM_VF_TYPE_S	10
#define GL_XLR_MARKER_TRIG_TCVMLR_VM_VF_TYPE_M	MAKEMASK(0x3, 10)
#define GL_XLR_MARKER_TRIG_TCVMLR_PF_NUM_S	12
#define GL_XLR_MARKER_TRIG_TCVMLR_PF_NUM_M	MAKEMASK(0x7, 12)
#define GL_XLR_MARKER_TRIG_TCVMLR_PORT_NUM_S	16
#define GL_XLR_MARKER_TRIG_TCVMLR_PORT_NUM_M	MAKEMASK(0x7, 16)
#define GL_XLR_MARKER_TRIG_VMLR			0x00093804 /* Reset Source: CORER */
#define GL_XLR_MARKER_TRIG_VMLR_VM_VF_NUM_S	0
#define GL_XLR_MARKER_TRIG_VMLR_VM_VF_NUM_M	MAKEMASK(0x3FF, 0)
#define GL_XLR_MARKER_TRIG_VMLR_VM_VF_TYPE_S	10
#define GL_XLR_MARKER_TRIG_VMLR_VM_VF_TYPE_M	MAKEMASK(0x3, 10)
#define GL_XLR_MARKER_TRIG_VMLR_PF_NUM_S	12
#define GL_XLR_MARKER_TRIG_VMLR_PF_NUM_M	MAKEMASK(0x7, 12)
#define GL_XLR_MARKER_TRIG_VMLR_PORT_NUM_S	16
#define GL_XLR_MARKER_TRIG_VMLR_PORT_NUM_M	MAKEMASK(0x7, 16)
#define GLGEN_ANA_ABORT_PTYPE			0x0020C21C /* Reset Source: CORER */
#define GLGEN_ANA_ABORT_PTYPE_ABORT_S		0
#define GLGEN_ANA_ABORT_PTYPE_ABORT_M		MAKEMASK(0x3FF, 0)
#define GLGEN_ANA_ALU_ACCSS_OUT_OF_PKT		0x0020C208 /* Reset Source: CORER */
#define GLGEN_ANA_ALU_ACCSS_OUT_OF_PKT_NPC_S	0
#define GLGEN_ANA_ALU_ACCSS_OUT_OF_PKT_NPC_M	MAKEMASK(0xFF, 0)
#define GLGEN_ANA_CFG_CTRL			0x0020C104 /* Reset Source: CORER */
#define GLGEN_ANA_CFG_CTRL_LINE_IDX_S		0
#define GLGEN_ANA_CFG_CTRL_LINE_IDX_M		MAKEMASK(0x3FFFF, 0)
#define GLGEN_ANA_CFG_CTRL_TABLE_ID_S		18
#define GLGEN_ANA_CFG_CTRL_TABLE_ID_M		MAKEMASK(0xFF, 18)
#define GLGEN_ANA_CFG_CTRL_RESRVED_S		26
#define GLGEN_ANA_CFG_CTRL_RESRVED_M		MAKEMASK(0x7, 26)
#define GLGEN_ANA_CFG_CTRL_OPERATION_ID_S	29
#define GLGEN_ANA_CFG_CTRL_OPERATION_ID_M	MAKEMASK(0x7, 29)
#define GLGEN_ANA_CFG_HTBL_LU_RESULT		0x0020C158 /* Reset Source: CORER */
#define GLGEN_ANA_CFG_HTBL_LU_RESULT_HIT_S	0
#define GLGEN_ANA_CFG_HTBL_LU_RESULT_HIT_M	BIT(0)
#define GLGEN_ANA_CFG_HTBL_LU_RESULT_PG_MEM_IDX_S 1
#define GLGEN_ANA_CFG_HTBL_LU_RESULT_PG_MEM_IDX_M MAKEMASK(0x7, 1)
#define GLGEN_ANA_CFG_HTBL_LU_RESULT_ADDR_S	4
#define GLGEN_ANA_CFG_HTBL_LU_RESULT_ADDR_M	MAKEMASK(0x1FF, 4)
#define GLGEN_ANA_CFG_LU_KEY(_i)		(0x0020C14C + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GLGEN_ANA_CFG_LU_KEY_MAX_INDEX		2
#define GLGEN_ANA_CFG_LU_KEY_LU_KEY_S		0
#define GLGEN_ANA_CFG_LU_KEY_LU_KEY_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLGEN_ANA_CFG_RDDATA(_i)		(0x0020C10C + ((_i) * 4)) /* _i=0...15 */ /* Reset Source: CORER */
#define GLGEN_ANA_CFG_RDDATA_MAX_INDEX		15
#define GLGEN_ANA_CFG_RDDATA_RD_DATA_S		0
#define GLGEN_ANA_CFG_RDDATA_RD_DATA_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLGEN_ANA_CFG_SPLBUF_LU_RESULT		0x0020C15C /* Reset Source: CORER */
#define GLGEN_ANA_CFG_SPLBUF_LU_RESULT_HIT_S	0
#define GLGEN_ANA_CFG_SPLBUF_LU_RESULT_HIT_M	BIT(0)
#define GLGEN_ANA_CFG_SPLBUF_LU_RESULT_RSV_S	1
#define GLGEN_ANA_CFG_SPLBUF_LU_RESULT_RSV_M	MAKEMASK(0x7, 1)
#define GLGEN_ANA_CFG_SPLBUF_LU_RESULT_ADDR_S	4
#define GLGEN_ANA_CFG_SPLBUF_LU_RESULT_ADDR_M	MAKEMASK(0x1FF, 4)
#define GLGEN_ANA_CFG_WRDATA			0x0020C108 /* Reset Source: CORER */
#define GLGEN_ANA_CFG_WRDATA_WR_DATA_S		0
#define GLGEN_ANA_CFG_WRDATA_WR_DATA_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLGEN_ANA_DEF_PTYPE			0x0020C100 /* Reset Source: CORER */
#define GLGEN_ANA_DEF_PTYPE_DEF_PTYPE_S		0
#define GLGEN_ANA_DEF_PTYPE_DEF_PTYPE_M		MAKEMASK(0x3FF, 0)
#define GLGEN_ANA_ERR_CTRL			0x0020C220 /* Reset Source: CORER */
#define GLGEN_ANA_ERR_CTRL_ERR_MASK_EN_S	0
#define GLGEN_ANA_ERR_CTRL_ERR_MASK_EN_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLGEN_ANA_FLAG_MAP(_i)			(0x0020C000 + ((_i) * 4)) /* _i=0...63 */ /* Reset Source: CORER */
#define GLGEN_ANA_FLAG_MAP_MAX_INDEX		63
#define GLGEN_ANA_FLAG_MAP_FLAG_EN_S		0
#define GLGEN_ANA_FLAG_MAP_FLAG_EN_M		BIT(0)
#define GLGEN_ANA_FLAG_MAP_EXT_FLAG_ID_S	1
#define GLGEN_ANA_FLAG_MAP_EXT_FLAG_ID_M	MAKEMASK(0x3F, 1)
#define GLGEN_ANA_INV_NODE_PTYPE		0x0020C210 /* Reset Source: CORER */
#define GLGEN_ANA_INV_NODE_PTYPE_INV_NODE_PTYPE_S 0
#define GLGEN_ANA_INV_NODE_PTYPE_INV_NODE_PTYPE_M MAKEMASK(0x7FF, 0)
#define GLGEN_ANA_INV_PTYPE_MARKER		0x0020C218 /* Reset Source: CORER */
#define GLGEN_ANA_INV_PTYPE_MARKER_INV_PTYPE_MARKER_S 0
#define GLGEN_ANA_INV_PTYPE_MARKER_INV_PTYPE_MARKER_M MAKEMASK(0x7F, 0)
#define GLGEN_ANA_LAST_PROT_ID(_i)		(0x0020C1E4 + ((_i) * 4)) /* _i=0...5 */ /* Reset Source: CORER */
#define GLGEN_ANA_LAST_PROT_ID_MAX_INDEX	5
#define GLGEN_ANA_LAST_PROT_ID_EN_S		0
#define GLGEN_ANA_LAST_PROT_ID_EN_M		BIT(0)
#define GLGEN_ANA_LAST_PROT_ID_PROT_ID_S	1
#define GLGEN_ANA_LAST_PROT_ID_PROT_ID_M	MAKEMASK(0xFF, 1)
#define GLGEN_ANA_NMPG_KEYMASK(_i)		(0x0020C1D0 + ((_i) * 4)) /* _i=0...3 */ /* Reset Source: CORER */
#define GLGEN_ANA_NMPG_KEYMASK_MAX_INDEX	3
#define GLGEN_ANA_NMPG_KEYMASK_HASH_KEY_S	0
#define GLGEN_ANA_NMPG_KEYMASK_HASH_KEY_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLGEN_ANA_NMPG0_HASHKEY(_i)		(0x0020C1B0 + ((_i) * 4)) /* _i=0...3 */ /* Reset Source: CORER */
#define GLGEN_ANA_NMPG0_HASHKEY_MAX_INDEX	3
#define GLGEN_ANA_NMPG0_HASHKEY_HASH_KEY_S	0
#define GLGEN_ANA_NMPG0_HASHKEY_HASH_KEY_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLGEN_ANA_NO_HIT_PG_NM_PG		0x0020C204 /* Reset Source: CORER */
#define GLGEN_ANA_NO_HIT_PG_NM_PG_NPC_S		0
#define GLGEN_ANA_NO_HIT_PG_NM_PG_NPC_M		MAKEMASK(0xFF, 0)
#define GLGEN_ANA_OUT_OF_PKT			0x0020C200 /* Reset Source: CORER */
#define GLGEN_ANA_OUT_OF_PKT_NPC_S		0
#define GLGEN_ANA_OUT_OF_PKT_NPC_M		MAKEMASK(0xFF, 0)
#define GLGEN_ANA_P2P(_i)			(0x0020C160 + ((_i) * 4)) /* _i=0...15 */ /* Reset Source: CORER */
#define GLGEN_ANA_P2P_MAX_INDEX			15
#define GLGEN_ANA_P2P_TARGET_PROF_S		0
#define GLGEN_ANA_P2P_TARGET_PROF_M		MAKEMASK(0xF, 0)
#define GLGEN_ANA_PG_KEYMASK(_i)		(0x0020C1C0 + ((_i) * 4)) /* _i=0...3 */ /* Reset Source: CORER */
#define GLGEN_ANA_PG_KEYMASK_MAX_INDEX		3
#define GLGEN_ANA_PG_KEYMASK_HASH_KEY_S		0
#define GLGEN_ANA_PG_KEYMASK_HASH_KEY_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLGEN_ANA_PG0_HASHKEY(_i)		(0x0020C1A0 + ((_i) * 4)) /* _i=0...3 */ /* Reset Source: CORER */
#define GLGEN_ANA_PG0_HASHKEY_MAX_INDEX		3
#define GLGEN_ANA_PG0_HASHKEY_HASH_KEY_S	0
#define GLGEN_ANA_PG0_HASHKEY_HASH_KEY_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLGEN_ANA_PROFIL_CTRL			0x0020C1FC /* Reset Source: CORER */
#define GLGEN_ANA_PROFIL_CTRL_PROFILE_SELECT_MDID_S 0
#define GLGEN_ANA_PROFIL_CTRL_PROFILE_SELECT_MDID_M MAKEMASK(0x1F, 0)
#define GLGEN_ANA_PROFIL_CTRL_PROFILE_SELECT_MDSTART_S 5
#define GLGEN_ANA_PROFIL_CTRL_PROFILE_SELECT_MDSTART_M MAKEMASK(0xF, 5)
#define GLGEN_ANA_PROFIL_CTRL_PROFILE_SELECT_MD_LEN_S 9
#define GLGEN_ANA_PROFIL_CTRL_PROFILE_SELECT_MD_LEN_M MAKEMASK(0x1F, 9)
#define GLGEN_ANA_PROFIL_CTRL_NUM_CTRL_DOMAIN_S 14
#define GLGEN_ANA_PROFIL_CTRL_NUM_CTRL_DOMAIN_M MAKEMASK(0x3, 14)
#define GLGEN_ANA_PROFIL_CTRL_DEF_PROF_ID_S	16
#define GLGEN_ANA_PROFIL_CTRL_DEF_PROF_ID_M	MAKEMASK(0xF, 16)
#define GLGEN_ANA_PROFIL_CTRL_SEL_DEF_PROF_ID_S 20
#define GLGEN_ANA_PROFIL_CTRL_SEL_DEF_PROF_ID_M BIT(20)
#define GLGEN_ANA_TX_ABORT_PTYPE		0x0020D21C /* Reset Source: CORER */
#define GLGEN_ANA_TX_ABORT_PTYPE_ABORT_S	0
#define GLGEN_ANA_TX_ABORT_PTYPE_ABORT_M	MAKEMASK(0x3FF, 0)
#define GLGEN_ANA_TX_ALU_ACCSS_OUT_OF_PKT	0x0020D208 /* Reset Source: CORER */
#define GLGEN_ANA_TX_ALU_ACCSS_OUT_OF_PKT_NPC_S 0
#define GLGEN_ANA_TX_ALU_ACCSS_OUT_OF_PKT_NPC_M MAKEMASK(0xFF, 0)
#define GLGEN_ANA_TX_CFG_CTRL			0x0020D104 /* Reset Source: CORER */
#define GLGEN_ANA_TX_CFG_CTRL_LINE_IDX_S	0
#define GLGEN_ANA_TX_CFG_CTRL_LINE_IDX_M	MAKEMASK(0x3FFFF, 0)
#define GLGEN_ANA_TX_CFG_CTRL_TABLE_ID_S	18
#define GLGEN_ANA_TX_CFG_CTRL_TABLE_ID_M	MAKEMASK(0xFF, 18)
#define GLGEN_ANA_TX_CFG_CTRL_RESRVED_S		26
#define GLGEN_ANA_TX_CFG_CTRL_RESRVED_M		MAKEMASK(0x7, 26)
#define GLGEN_ANA_TX_CFG_CTRL_OPERATION_ID_S	29
#define GLGEN_ANA_TX_CFG_CTRL_OPERATION_ID_M	MAKEMASK(0x7, 29)
#define GLGEN_ANA_TX_CFG_HTBL_LU_RESULT		0x0020D158 /* Reset Source: CORER */
#define GLGEN_ANA_TX_CFG_HTBL_LU_RESULT_HIT_S	0
#define GLGEN_ANA_TX_CFG_HTBL_LU_RESULT_HIT_M	BIT(0)
#define GLGEN_ANA_TX_CFG_HTBL_LU_RESULT_PG_MEM_IDX_S 1
#define GLGEN_ANA_TX_CFG_HTBL_LU_RESULT_PG_MEM_IDX_M MAKEMASK(0x7, 1)
#define GLGEN_ANA_TX_CFG_HTBL_LU_RESULT_ADDR_S	4
#define GLGEN_ANA_TX_CFG_HTBL_LU_RESULT_ADDR_M	MAKEMASK(0x1FF, 4)
#define GLGEN_ANA_TX_CFG_LU_KEY(_i)		(0x0020D14C + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define GLGEN_ANA_TX_CFG_LU_KEY_MAX_INDEX	2
#define GLGEN_ANA_TX_CFG_LU_KEY_LU_KEY_S	0
#define GLGEN_ANA_TX_CFG_LU_KEY_LU_KEY_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLGEN_ANA_TX_CFG_RDDATA(_i)		(0x0020D10C + ((_i) * 4)) /* _i=0...15 */ /* Reset Source: CORER */
#define GLGEN_ANA_TX_CFG_RDDATA_MAX_INDEX	15
#define GLGEN_ANA_TX_CFG_RDDATA_RD_DATA_S	0
#define GLGEN_ANA_TX_CFG_RDDATA_RD_DATA_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLGEN_ANA_TX_CFG_SPLBUF_LU_RESULT	0x0020D15C /* Reset Source: CORER */
#define GLGEN_ANA_TX_CFG_SPLBUF_LU_RESULT_HIT_S 0
#define GLGEN_ANA_TX_CFG_SPLBUF_LU_RESULT_HIT_M BIT(0)
#define GLGEN_ANA_TX_CFG_SPLBUF_LU_RESULT_RSV_S 1
#define GLGEN_ANA_TX_CFG_SPLBUF_LU_RESULT_RSV_M MAKEMASK(0x7, 1)
#define GLGEN_ANA_TX_CFG_SPLBUF_LU_RESULT_ADDR_S 4
#define GLGEN_ANA_TX_CFG_SPLBUF_LU_RESULT_ADDR_M MAKEMASK(0x1FF, 4)
#define GLGEN_ANA_TX_CFG_WRDATA			0x0020D108 /* Reset Source: CORER */
#define GLGEN_ANA_TX_CFG_WRDATA_WR_DATA_S	0
#define GLGEN_ANA_TX_CFG_WRDATA_WR_DATA_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLGEN_ANA_TX_DEF_PTYPE			0x0020D100 /* Reset Source: CORER */
#define GLGEN_ANA_TX_DEF_PTYPE_DEF_PTYPE_S	0
#define GLGEN_ANA_TX_DEF_PTYPE_DEF_PTYPE_M	MAKEMASK(0x3FF, 0)
#define GLGEN_ANA_TX_DFD_PACE_OUT		0x0020D4CC /* Reset Source: CORER */
#define GLGEN_ANA_TX_DFD_PACE_OUT_PUSH_S	0
#define GLGEN_ANA_TX_DFD_PACE_OUT_PUSH_M	BIT(0)
#define GLGEN_ANA_TX_ERR_CTRL			0x0020D220 /* Reset Source: CORER */
#define GLGEN_ANA_TX_ERR_CTRL_ERR_MASK_EN_S	0
#define GLGEN_ANA_TX_ERR_CTRL_ERR_MASK_EN_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLGEN_ANA_TX_FLAG_MAP(_i)		(0x0020D000 + ((_i) * 4)) /* _i=0...63 */ /* Reset Source: CORER */
#define GLGEN_ANA_TX_FLAG_MAP_MAX_INDEX		63
#define GLGEN_ANA_TX_FLAG_MAP_FLAG_EN_S		0
#define GLGEN_ANA_TX_FLAG_MAP_FLAG_EN_M		BIT(0)
#define GLGEN_ANA_TX_FLAG_MAP_EXT_FLAG_ID_S	1
#define GLGEN_ANA_TX_FLAG_MAP_EXT_FLAG_ID_M	MAKEMASK(0x3F, 1)
#define GLGEN_ANA_TX_INV_NODE_PTYPE		0x0020D210 /* Reset Source: CORER */
#define GLGEN_ANA_TX_INV_NODE_PTYPE_INV_NODE_PTYPE_S 0
#define GLGEN_ANA_TX_INV_NODE_PTYPE_INV_NODE_PTYPE_M MAKEMASK(0x7FF, 0)
#define GLGEN_ANA_TX_INV_PROT_ID		0x0020D214 /* Reset Source: CORER */
#define GLGEN_ANA_TX_INV_PROT_ID_INV_PROT_ID_S	0
#define GLGEN_ANA_TX_INV_PROT_ID_INV_PROT_ID_M	MAKEMASK(0xFF, 0)
#define GLGEN_ANA_TX_INV_PTYPE_MARKER		0x0020D218 /* Reset Source: CORER */
#define GLGEN_ANA_TX_INV_PTYPE_MARKER_INV_PTYPE_MARKER_S 0
#define GLGEN_ANA_TX_INV_PTYPE_MARKER_INV_PTYPE_MARKER_M MAKEMASK(0x7F, 0)
#define GLGEN_ANA_TX_NMPG_KEYMASK(_i)		(0x0020D1D0 + ((_i) * 4)) /* _i=0...3 */ /* Reset Source: CORER */
#define GLGEN_ANA_TX_NMPG_KEYMASK_MAX_INDEX	3
#define GLGEN_ANA_TX_NMPG_KEYMASK_HASH_KEY_S	0
#define GLGEN_ANA_TX_NMPG_KEYMASK_HASH_KEY_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLGEN_ANA_TX_NMPG0_HASHKEY(_i)		(0x0020D1B0 + ((_i) * 4)) /* _i=0...3 */ /* Reset Source: CORER */
#define GLGEN_ANA_TX_NMPG0_HASHKEY_MAX_INDEX	3
#define GLGEN_ANA_TX_NMPG0_HASHKEY_HASH_KEY_S	0
#define GLGEN_ANA_TX_NMPG0_HASHKEY_HASH_KEY_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLGEN_ANA_TX_NO_HIT_PG_NM_PG		0x0020D204 /* Reset Source: CORER */
#define GLGEN_ANA_TX_NO_HIT_PG_NM_PG_NPC_S	0
#define GLGEN_ANA_TX_NO_HIT_PG_NM_PG_NPC_M	MAKEMASK(0xFF, 0)
#define GLGEN_ANA_TX_P2P(_i)			(0x0020D160 + ((_i) * 4)) /* _i=0...15 */ /* Reset Source: CORER */
#define GLGEN_ANA_TX_P2P_MAX_INDEX		15
#define GLGEN_ANA_TX_P2P_TARGET_PROF_S		0
#define GLGEN_ANA_TX_P2P_TARGET_PROF_M		MAKEMASK(0xF, 0)
#define GLGEN_ANA_TX_PG_KEYMASK(_i)		(0x0020D1C0 + ((_i) * 4)) /* _i=0...3 */ /* Reset Source: CORER */
#define GLGEN_ANA_TX_PG_KEYMASK_MAX_INDEX	3
#define GLGEN_ANA_TX_PG_KEYMASK_HASH_KEY_S	0
#define GLGEN_ANA_TX_PG_KEYMASK_HASH_KEY_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLGEN_ANA_TX_PG0_HASHKEY(_i)		(0x0020D1A0 + ((_i) * 4)) /* _i=0...3 */ /* Reset Source: CORER */
#define GLGEN_ANA_TX_PG0_HASHKEY_MAX_INDEX	3
#define GLGEN_ANA_TX_PG0_HASHKEY_HASH_KEY_S	0
#define GLGEN_ANA_TX_PG0_HASHKEY_HASH_KEY_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLGEN_ANA_TX_PROFIL_CTRL		0x0020D1FC /* Reset Source: CORER */
#define GLGEN_ANA_TX_PROFIL_CTRL_PROFILE_SELECT_MDID_S 0
#define GLGEN_ANA_TX_PROFIL_CTRL_PROFILE_SELECT_MDID_M MAKEMASK(0x1F, 0)
#define GLGEN_ANA_TX_PROFIL_CTRL_PROFILE_SELECT_MDSTART_S 5
#define GLGEN_ANA_TX_PROFIL_CTRL_PROFILE_SELECT_MDSTART_M MAKEMASK(0xF, 5)
#define GLGEN_ANA_TX_PROFIL_CTRL_PROFILE_SELECT_MD_LEN_S 9
#define GLGEN_ANA_TX_PROFIL_CTRL_PROFILE_SELECT_MD_LEN_M MAKEMASK(0x1F, 9)
#define GLGEN_ANA_TX_PROFIL_CTRL_NUM_CTRL_DOMAIN_S 14
#define GLGEN_ANA_TX_PROFIL_CTRL_NUM_CTRL_DOMAIN_M MAKEMASK(0x3, 14)
#define GLGEN_ANA_TX_PROFIL_CTRL_DEF_PROF_ID_S	16
#define GLGEN_ANA_TX_PROFIL_CTRL_DEF_PROF_ID_M	MAKEMASK(0xF, 16)
#define GLGEN_ANA_TX_PROFIL_CTRL_SEL_DEF_PROF_ID_S 20
#define GLGEN_ANA_TX_PROFIL_CTRL_SEL_DEF_PROF_ID_M BIT(20)
#define GLGEN_ASSERT_HLP			0x000B81E4 /* Reset Source: POR */
#define GLGEN_ASSERT_HLP_CORE_ON_RST_S		0
#define GLGEN_ASSERT_HLP_CORE_ON_RST_M		BIT(0)
#define GLGEN_ASSERT_HLP_FULL_ON_RST_S		1
#define GLGEN_ASSERT_HLP_FULL_ON_RST_M		BIT(1)
#define GLGEN_CLKSTAT				0x000B8184 /* Reset Source: POR */
#define GLGEN_CLKSTAT_U_CLK_SPEED_S		0
#define GLGEN_CLKSTAT_U_CLK_SPEED_M		MAKEMASK(0x7, 0)
#define GLGEN_CLKSTAT_L_CLK_SPEED_S		3
#define GLGEN_CLKSTAT_L_CLK_SPEED_M		MAKEMASK(0x7, 3)
#define GLGEN_CLKSTAT_PSM_CLK_SPEED_S		6
#define GLGEN_CLKSTAT_PSM_CLK_SPEED_M		MAKEMASK(0x7, 6)
#define GLGEN_CLKSTAT_RXCTL_CLK_SPEED_S		9
#define GLGEN_CLKSTAT_RXCTL_CLK_SPEED_M		MAKEMASK(0x7, 9)
#define GLGEN_CLKSTAT_UANA_CLK_SPEED_S		12
#define GLGEN_CLKSTAT_UANA_CLK_SPEED_M		MAKEMASK(0x7, 12)
#define GLGEN_CLKSTAT_PE_CLK_SPEED_S		18
#define GLGEN_CLKSTAT_PE_CLK_SPEED_M		MAKEMASK(0x7, 18)
#define GLGEN_CLKSTAT_SRC			0x000B826C /* Reset Source: POR */
#define GLGEN_CLKSTAT_SRC_U_CLK_SRC_S		0
#define GLGEN_CLKSTAT_SRC_U_CLK_SRC_M		MAKEMASK(0x3, 0)
#define GLGEN_CLKSTAT_SRC_L_CLK_SRC_S		2
#define GLGEN_CLKSTAT_SRC_L_CLK_SRC_M		MAKEMASK(0x3, 2)
#define GLGEN_CLKSTAT_SRC_PSM_CLK_SRC_S		4
#define GLGEN_CLKSTAT_SRC_PSM_CLK_SRC_M		MAKEMASK(0x3, 4)
#define GLGEN_CLKSTAT_SRC_RXCTL_CLK_SRC_S	6
#define GLGEN_CLKSTAT_SRC_RXCTL_CLK_SRC_M	MAKEMASK(0x3, 6)
#define GLGEN_CLKSTAT_SRC_UANA_CLK_SRC_S	8
#define GLGEN_CLKSTAT_SRC_UANA_CLK_SRC_M	MAKEMASK(0xF, 8)
#define GLGEN_ECC_ERR_INT_TOG_MASK_H		0x00093A00 /* Reset Source: CORER */
#define GLGEN_ECC_ERR_INT_TOG_MASK_H_CLIENT_NUM_S 0
#define GLGEN_ECC_ERR_INT_TOG_MASK_H_CLIENT_NUM_M MAKEMASK(0x7F, 0)
#define GLGEN_ECC_ERR_INT_TOG_MASK_L		0x000939FC /* Reset Source: CORER */
#define GLGEN_ECC_ERR_INT_TOG_MASK_L_CLIENT_NUM_S 0
#define GLGEN_ECC_ERR_INT_TOG_MASK_L_CLIENT_NUM_M MAKEMASK(0xFFFFFFFF, 0)
#define GLGEN_ECC_ERR_RST_MASK_H		0x000939F8 /* Reset Source: CORER */
#define GLGEN_ECC_ERR_RST_MASK_H_CLIENT_NUM_S	0
#define GLGEN_ECC_ERR_RST_MASK_H_CLIENT_NUM_M	MAKEMASK(0x7F, 0)
#define GLGEN_ECC_ERR_RST_MASK_L		0x000939F4 /* Reset Source: CORER */
#define GLGEN_ECC_ERR_RST_MASK_L_CLIENT_NUM_S	0
#define GLGEN_ECC_ERR_RST_MASK_L_CLIENT_NUM_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLGEN_GPIO_CTL(_i)			(0x000880C8 + ((_i) * 4)) /* _i=0...6 */ /* Reset Source: POR */
#define GLGEN_GPIO_CTL_MAX_INDEX		6
#define GLGEN_GPIO_CTL_IN_VALUE_S		0
#define GLGEN_GPIO_CTL_IN_VALUE_M		BIT(0)
#define GLGEN_GPIO_CTL_IN_TRANSIT_S		1
#define GLGEN_GPIO_CTL_IN_TRANSIT_M		BIT(1)
#define GLGEN_GPIO_CTL_OUT_VALUE_S		2
#define GLGEN_GPIO_CTL_OUT_VALUE_M		BIT(2)
#define GLGEN_GPIO_CTL_NO_P_UP_S		3
#define GLGEN_GPIO_CTL_NO_P_UP_M		BIT(3)
#define GLGEN_GPIO_CTL_PIN_DIR_S		4
#define GLGEN_GPIO_CTL_PIN_DIR_M		BIT(4)
#define GLGEN_GPIO_CTL_TRI_CTL_S		5
#define GLGEN_GPIO_CTL_TRI_CTL_M		BIT(5)
#define GLGEN_GPIO_CTL_PIN_FUNC_S		8
#define GLGEN_GPIO_CTL_PIN_FUNC_M		MAKEMASK(0xF, 8)
#define GLGEN_GPIO_CTL_INT_MODE_S		12
#define GLGEN_GPIO_CTL_INT_MODE_M		MAKEMASK(0x3, 12)
#define GLGEN_MARKER_COUNT			0x000939E8 /* Reset Source: CORER */
#define GLGEN_MARKER_COUNT_MARKER_COUNT_S	0
#define GLGEN_MARKER_COUNT_MARKER_COUNT_M	MAKEMASK(0xFF, 0)
#define GLGEN_MARKER_COUNT_MARKER_COUNT_EN_S	31
#define GLGEN_MARKER_COUNT_MARKER_COUNT_EN_M	BIT(31)
#define GLGEN_RSTAT				0x000B8188 /* Reset Source: POR */
#define GLGEN_RSTAT_DEVSTATE_S			0
#define GLGEN_RSTAT_DEVSTATE_M			MAKEMASK(0x3, 0)
#define GLGEN_RSTAT_RESET_TYPE_S		2
#define GLGEN_RSTAT_RESET_TYPE_M		MAKEMASK(0x3, 2)
#define GLGEN_RSTAT_CORERCNT_S			4
#define GLGEN_RSTAT_CORERCNT_M			MAKEMASK(0x3, 4)
#define GLGEN_RSTAT_GLOBRCNT_S			6
#define GLGEN_RSTAT_GLOBRCNT_M			MAKEMASK(0x3, 6)
#define GLGEN_RSTAT_EMPRCNT_S			8
#define GLGEN_RSTAT_EMPRCNT_M			MAKEMASK(0x3, 8)
#define GLGEN_RSTAT_TIME_TO_RST_S		10
#define GLGEN_RSTAT_TIME_TO_RST_M		MAKEMASK(0x3F, 10)
#define GLGEN_RSTAT_RTRIG_FLR_S			16
#define GLGEN_RSTAT_RTRIG_FLR_M			BIT(16)
#define GLGEN_RSTAT_RTRIG_ECC_S			17
#define GLGEN_RSTAT_RTRIG_ECC_M			BIT(17)
#define GLGEN_RSTAT_RTRIG_FW_AUX_S		18
#define GLGEN_RSTAT_RTRIG_FW_AUX_M		BIT(18)
#define GLGEN_RSTCTL				0x000B8180 /* Reset Source: POR */
#define GLGEN_RSTCTL_GRSTDEL_S			0
#define GLGEN_RSTCTL_GRSTDEL_M			MAKEMASK(0x3F, 0)
#define GLGEN_RSTCTL_ECC_RST_ENA_S		8
#define GLGEN_RSTCTL_ECC_RST_ENA_M		BIT(8)
#define GLGEN_RSTCTL_ECC_RT_EN_S		30
#define GLGEN_RSTCTL_ECC_RT_EN_M		BIT(30)
#define GLGEN_RSTCTL_FLR_RT_EN_S		31
#define GLGEN_RSTCTL_FLR_RT_EN_M		BIT(31)
#define GLGEN_RTRIG				0x000B8190 /* Reset Source: CORER */
#define GLGEN_RTRIG_CORER_S			0
#define GLGEN_RTRIG_CORER_M			BIT(0)
#define GLGEN_RTRIG_GLOBR_S			1
#define GLGEN_RTRIG_GLOBR_M			BIT(1)
#define GLGEN_RTRIG_EMPFWR_S			2
#define GLGEN_RTRIG_EMPFWR_M			BIT(2)
#define GLGEN_STAT				0x000B612C /* Reset Source: POR */
#define GLGEN_STAT_RSVD4FW_S			0
#define GLGEN_STAT_RSVD4FW_M			MAKEMASK(0xFF, 0)
#define GLGEN_VFLRSTAT(_i)			(0x00093A04 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLGEN_VFLRSTAT_MAX_INDEX		7
#define GLGEN_VFLRSTAT_VFLRS_S			0
#define GLGEN_VFLRSTAT_VFLRS_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLGEN_XLR_MSK2HLP_RDY			0x000939F0 /* Reset Source: CORER */
#define GLGEN_XLR_MSK2HLP_RDY_GLGEN_XLR_MSK2HLP_RDY_S 0
#define GLGEN_XLR_MSK2HLP_RDY_GLGEN_XLR_MSK2HLP_RDY_M BIT(0)
#define GLGEN_XLR_TRNS_WAIT_COUNT		0x000939EC /* Reset Source: CORER */
#define GLGEN_XLR_TRNS_WAIT_COUNT_W_BTWN_TRNS_COUNT_S 0
#define GLGEN_XLR_TRNS_WAIT_COUNT_W_BTWN_TRNS_COUNT_M MAKEMASK(0x1F, 0)
#define GLGEN_XLR_TRNS_WAIT_COUNT_W_PEND_TRNS_COUNT_S 8
#define GLGEN_XLR_TRNS_WAIT_COUNT_W_PEND_TRNS_COUNT_M MAKEMASK(0xFF, 8)
#define GLVFGEN_TIMER				0x000B8214 /* Reset Source: POR */
#define GLVFGEN_TIMER_GTIME_S			0
#define GLVFGEN_TIMER_GTIME_M			MAKEMASK(0xFFFFFFFF, 0)
#define PFGEN_CTRL				0x00091000 /* Reset Source: CORER */
#define PFGEN_CTRL_PFSWR_S			0
#define PFGEN_CTRL_PFSWR_M			BIT(0)
#define PFGEN_DRUN				0x00091180 /* Reset Source: CORER */
#define PFGEN_DRUN_DRVUNLD_S			0
#define PFGEN_DRUN_DRVUNLD_M			BIT(0)
#define PFGEN_PFRSTAT				0x00091080 /* Reset Source: CORER */
#define PFGEN_PFRSTAT_PFRD_S			0
#define PFGEN_PFRSTAT_PFRD_M			BIT(0)
#define PFGEN_PORTNUM				0x001D2400 /* Reset Source: CORER */
#define PFGEN_PORTNUM_PORT_NUM_S		0
#define PFGEN_PORTNUM_PORT_NUM_M		MAKEMASK(0x7, 0)
#define PFGEN_STATE				0x00088000 /* Reset Source: CORER */
#define PFGEN_STATE_PFPEEN_S			0
#define PFGEN_STATE_PFPEEN_M			BIT(0)
#define PFGEN_STATE_RSVD_S			1
#define PFGEN_STATE_RSVD_M			BIT(1)
#define PFGEN_STATE_PFLINKEN_S			2
#define PFGEN_STATE_PFLINKEN_M			BIT(2)
#define PFGEN_STATE_PFSCEN_S			3
#define PFGEN_STATE_PFSCEN_M			BIT(3)
#define PRT_TCVMLR_DRAIN_CNTR			0x000A21C0 /* Reset Source: CORER */
#define PRT_TCVMLR_DRAIN_CNTR_CNTR_S		0
#define PRT_TCVMLR_DRAIN_CNTR_CNTR_M		MAKEMASK(0x3FFF, 0)
#define PRTGEN_CNF				0x000B8120 /* Reset Source: POR */
#define PRTGEN_CNF_PORT_DIS_S			0
#define PRTGEN_CNF_PORT_DIS_M			BIT(0)
#define PRTGEN_CNF_ALLOW_PORT_DIS_S		1
#define PRTGEN_CNF_ALLOW_PORT_DIS_M		BIT(1)
#define PRTGEN_CNF_EMP_PORT_DIS_S		2
#define PRTGEN_CNF_EMP_PORT_DIS_M		BIT(2)
#define PRTGEN_CNF2				0x000B8160 /* Reset Source: POR */
#define PRTGEN_CNF2_ACTIVATE_PORT_LINK_S	0
#define PRTGEN_CNF2_ACTIVATE_PORT_LINK_M	BIT(0)
#define PRTGEN_CNF3				0x000B8280 /* Reset Source: POR */
#define PRTGEN_CNF3_PORT_STAGERING_EN_S		0
#define PRTGEN_CNF3_PORT_STAGERING_EN_M		BIT(0)
#define PRTGEN_STATUS				0x000B8100 /* Reset Source: POR */
#define PRTGEN_STATUS_PORT_VALID_S		0
#define PRTGEN_STATUS_PORT_VALID_M		BIT(0)
#define PRTGEN_STATUS_PORT_ACTIVE_S		1
#define PRTGEN_STATUS_PORT_ACTIVE_M		BIT(1)
#define VFGEN_RSTAT(_VF)			(0x00074000 + ((_VF) * 4)) /* _i=0...255 */ /* Reset Source: VFR */
#define VFGEN_RSTAT_MAX_INDEX			255
#define VFGEN_RSTAT_VFR_STATE_S			0
#define VFGEN_RSTAT_VFR_STATE_M			MAKEMASK(0x3, 0)
#define VPGEN_VFRSTAT(_VF)			(0x00090800 + ((_VF) * 4)) /* _i=0...255 */ /* Reset Source: CORER */
#define VPGEN_VFRSTAT_MAX_INDEX			255
#define VPGEN_VFRSTAT_VFRD_S			0
#define VPGEN_VFRSTAT_VFRD_M			BIT(0)
#define VPGEN_VFRTRIG(_VF)			(0x00090000 + ((_VF) * 4)) /* _i=0...255 */ /* Reset Source: CORER */
#define VPGEN_VFRTRIG_MAX_INDEX			255
#define VPGEN_VFRTRIG_VFSWR_S			0
#define VPGEN_VFRTRIG_VFSWR_M			BIT(0)
#define VSIGEN_RSTAT(_VSI)			(0x00092800 + ((_VSI) * 4)) /* _i=0...767 */ /* Reset Source: CORER */
#define VSIGEN_RSTAT_MAX_INDEX			767
#define VSIGEN_RSTAT_VMRD_S			0
#define VSIGEN_RSTAT_VMRD_M			BIT(0)
#define VSIGEN_RTRIG(_VSI)			(0x00091800 + ((_VSI) * 4)) /* _i=0...767 */ /* Reset Source: CORER */
#define VSIGEN_RTRIG_MAX_INDEX			767
#define VSIGEN_RTRIG_VMSWR_S			0
#define VSIGEN_RTRIG_VMSWR_M			BIT(0)
#define GLHMC_APBVTINUSEBASE(_i)		(0x00524A00 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLHMC_APBVTINUSEBASE_MAX_INDEX		7
#define GLHMC_APBVTINUSEBASE_FPMAPBINUSEBASE_S	0
#define GLHMC_APBVTINUSEBASE_FPMAPBINUSEBASE_M	MAKEMASK(0xFFFFFF, 0)
#define GLHMC_CEQPART(_i)			(0x005031C0 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLHMC_CEQPART_MAX_INDEX			7
#define GLHMC_CEQPART_PMCEQBASE_S		0
#define GLHMC_CEQPART_PMCEQBASE_M		MAKEMASK(0x3FF, 0)
#define GLHMC_CEQPART_PMCEQSIZE_S		16
#define GLHMC_CEQPART_PMCEQSIZE_M		MAKEMASK(0x3FF, 16)
#define GLHMC_DBCQMAX				0x005220F0 /* Reset Source: CORER */
#define GLHMC_DBCQMAX_GLHMC_DBCQMAX_S		0
#define GLHMC_DBCQMAX_GLHMC_DBCQMAX_M		MAKEMASK(0xFFFFF, 0)
#define GLHMC_DBCQPART(_i)			(0x00503180 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLHMC_DBCQPART_MAX_INDEX		7
#define GLHMC_DBCQPART_PMDBCQBASE_S		0
#define GLHMC_DBCQPART_PMDBCQBASE_M		MAKEMASK(0x3FFF, 0)
#define GLHMC_DBCQPART_PMDBCQSIZE_S		16
#define GLHMC_DBCQPART_PMDBCQSIZE_M		MAKEMASK(0x7FFF, 16)
#define GLHMC_DBQPMAX				0x005220EC /* Reset Source: CORER */
#define GLHMC_DBQPMAX_GLHMC_DBQPMAX_S		0
#define GLHMC_DBQPMAX_GLHMC_DBQPMAX_M		MAKEMASK(0x7FFFF, 0)
#define GLHMC_DBQPPART(_i)			(0x005044C0 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLHMC_DBQPPART_MAX_INDEX		7
#define GLHMC_DBQPPART_PMDBQPBASE_S		0
#define GLHMC_DBQPPART_PMDBQPBASE_M		MAKEMASK(0x3FFF, 0)
#define GLHMC_DBQPPART_PMDBQPSIZE_S		16
#define GLHMC_DBQPPART_PMDBQPSIZE_M		MAKEMASK(0x7FFF, 16)
#define GLHMC_FSIAVBASE(_i)			(0x00525600 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLHMC_FSIAVBASE_MAX_INDEX		7
#define GLHMC_FSIAVBASE_FPMFSIAVBASE_S		0
#define GLHMC_FSIAVBASE_FPMFSIAVBASE_M		MAKEMASK(0xFFFFFF, 0)
#define GLHMC_FSIAVCNT(_i)			(0x00525700 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLHMC_FSIAVCNT_MAX_INDEX		7
#define GLHMC_FSIAVCNT_FPMFSIAVCNT_S		0
#define GLHMC_FSIAVCNT_FPMFSIAVCNT_M		MAKEMASK(0x1FFFFFFF, 0)
#define GLHMC_FSIAVMAX				0x00522068 /* Reset Source: CORER */
#define GLHMC_FSIAVMAX_PMFSIAVMAX_S		0
#define GLHMC_FSIAVMAX_PMFSIAVMAX_M		MAKEMASK(0x3FFFF, 0)
#define GLHMC_FSIAVOBJSZ			0x00522064 /* Reset Source: CORER */
#define GLHMC_FSIAVOBJSZ_PMFSIAVOBJSZ_S		0
#define GLHMC_FSIAVOBJSZ_PMFSIAVOBJSZ_M		MAKEMASK(0xF, 0)
#define GLHMC_FSIMCBASE(_i)			(0x00526000 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLHMC_FSIMCBASE_MAX_INDEX		7
#define GLHMC_FSIMCBASE_FPMFSIMCBASE_S		0
#define GLHMC_FSIMCBASE_FPMFSIMCBASE_M		MAKEMASK(0xFFFFFF, 0)
#define GLHMC_FSIMCCNT(_i)			(0x00526100 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLHMC_FSIMCCNT_MAX_INDEX		7
#define GLHMC_FSIMCCNT_FPMFSIMCSZ_S		0
#define GLHMC_FSIMCCNT_FPMFSIMCSZ_M		MAKEMASK(0x1FFFFFFF, 0)
#define GLHMC_FSIMCMAX				0x00522060 /* Reset Source: CORER */
#define GLHMC_FSIMCMAX_PMFSIMCMAX_S		0
#define GLHMC_FSIMCMAX_PMFSIMCMAX_M		MAKEMASK(0x3FFF, 0)
#define GLHMC_FSIMCOBJSZ			0x0052205C /* Reset Source: CORER */
#define GLHMC_FSIMCOBJSZ_PMFSIMCOBJSZ_S		0
#define GLHMC_FSIMCOBJSZ_PMFSIMCOBJSZ_M		MAKEMASK(0xF, 0)
#define GLHMC_FWPDINV				0x0052207C /* Reset Source: CORER */
#define GLHMC_FWPDINV_PMSDIDX_S			0
#define GLHMC_FWPDINV_PMSDIDX_M			MAKEMASK(0xFFF, 0)
#define GLHMC_FWPDINV_PMSDPARTSEL_S		15
#define GLHMC_FWPDINV_PMSDPARTSEL_M		BIT(15)
#define GLHMC_FWPDINV_PMPDIDX_S			16
#define GLHMC_FWPDINV_PMPDIDX_M			MAKEMASK(0x1FF, 16)
#define GLHMC_FWPDINV_FPMAT			0x0010207C /* Reset Source: CORER */
#define GLHMC_FWPDINV_FPMAT_PMSDIDX_S		0
#define GLHMC_FWPDINV_FPMAT_PMSDIDX_M		MAKEMASK(0xFFF, 0)
#define GLHMC_FWPDINV_FPMAT_PMSDPARTSEL_S	15
#define GLHMC_FWPDINV_FPMAT_PMSDPARTSEL_M	BIT(15)
#define GLHMC_FWPDINV_FPMAT_PMPDIDX_S		16
#define GLHMC_FWPDINV_FPMAT_PMPDIDX_M		MAKEMASK(0x1FF, 16)
#define GLHMC_FWSDDATAHIGH			0x00522078 /* Reset Source: CORER */
#define GLHMC_FWSDDATAHIGH_PMSDDATAHIGH_S	0
#define GLHMC_FWSDDATAHIGH_PMSDDATAHIGH_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLHMC_FWSDDATAHIGH_FPMAT		0x00102078 /* Reset Source: CORER */
#define GLHMC_FWSDDATAHIGH_FPMAT_PMSDDATAHIGH_S 0
#define GLHMC_FWSDDATAHIGH_FPMAT_PMSDDATAHIGH_M MAKEMASK(0xFFFFFFFF, 0)
#define GLHMC_FWSDDATALOW			0x00522074 /* Reset Source: CORER */
#define GLHMC_FWSDDATALOW_PMSDVALID_S		0
#define GLHMC_FWSDDATALOW_PMSDVALID_M		BIT(0)
#define GLHMC_FWSDDATALOW_PMSDTYPE_S		1
#define GLHMC_FWSDDATALOW_PMSDTYPE_M		BIT(1)
#define GLHMC_FWSDDATALOW_PMSDBPCOUNT_S		2
#define GLHMC_FWSDDATALOW_PMSDBPCOUNT_M		MAKEMASK(0x3FF, 2)
#define GLHMC_FWSDDATALOW_PMSDDATALOW_S		12
#define GLHMC_FWSDDATALOW_PMSDDATALOW_M		MAKEMASK(0xFFFFF, 12)
#define GLHMC_FWSDDATALOW_FPMAT			0x00102074 /* Reset Source: CORER */
#define GLHMC_FWSDDATALOW_FPMAT_PMSDVALID_S	0
#define GLHMC_FWSDDATALOW_FPMAT_PMSDVALID_M	BIT(0)
#define GLHMC_FWSDDATALOW_FPMAT_PMSDTYPE_S	1
#define GLHMC_FWSDDATALOW_FPMAT_PMSDTYPE_M	BIT(1)
#define GLHMC_FWSDDATALOW_FPMAT_PMSDBPCOUNT_S	2
#define GLHMC_FWSDDATALOW_FPMAT_PMSDBPCOUNT_M	MAKEMASK(0x3FF, 2)
#define GLHMC_FWSDDATALOW_FPMAT_PMSDDATALOW_S	12
#define GLHMC_FWSDDATALOW_FPMAT_PMSDDATALOW_M	MAKEMASK(0xFFFFF, 12)
#define GLHMC_PEARPBASE(_i)			(0x00524800 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLHMC_PEARPBASE_MAX_INDEX		7
#define GLHMC_PEARPBASE_FPMPEARPBASE_S		0
#define GLHMC_PEARPBASE_FPMPEARPBASE_M		MAKEMASK(0xFFFFFF, 0)
#define GLHMC_PEARPCNT(_i)			(0x00524900 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLHMC_PEARPCNT_MAX_INDEX		7
#define GLHMC_PEARPCNT_FPMPEARPCNT_S		0
#define GLHMC_PEARPCNT_FPMPEARPCNT_M		MAKEMASK(0x1FFFFFFF, 0)
#define GLHMC_PEARPMAX				0x00522038 /* Reset Source: CORER */
#define GLHMC_PEARPMAX_PMPEARPMAX_S		0
#define GLHMC_PEARPMAX_PMPEARPMAX_M		MAKEMASK(0x1FFFF, 0)
#define GLHMC_PEARPOBJSZ			0x00522034 /* Reset Source: CORER */
#define GLHMC_PEARPOBJSZ_PMPEARPOBJSZ_S		0
#define GLHMC_PEARPOBJSZ_PMPEARPOBJSZ_M		MAKEMASK(0x7, 0)
#define GLHMC_PECQBASE(_i)			(0x00524200 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLHMC_PECQBASE_MAX_INDEX		7
#define GLHMC_PECQBASE_FPMPECQBASE_S		0
#define GLHMC_PECQBASE_FPMPECQBASE_M		MAKEMASK(0xFFFFFF, 0)
#define GLHMC_PECQCNT(_i)			(0x00524300 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLHMC_PECQCNT_MAX_INDEX			7
#define GLHMC_PECQCNT_FPMPECQCNT_S		0
#define GLHMC_PECQCNT_FPMPECQCNT_M		MAKEMASK(0x1FFFFFFF, 0)
#define GLHMC_PECQOBJSZ				0x00522020 /* Reset Source: CORER */
#define GLHMC_PECQOBJSZ_PMPECQOBJSZ_S		0
#define GLHMC_PECQOBJSZ_PMPECQOBJSZ_M		MAKEMASK(0xF, 0)
#define GLHMC_PEHDRBASE(_i)			(0x00526200 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLHMC_PEHDRBASE_MAX_INDEX		7
#define GLHMC_PEHDRBASE_GLHMC_PEHDRBASE_S	0
#define GLHMC_PEHDRBASE_GLHMC_PEHDRBASE_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLHMC_PEHDRCNT(_i)			(0x00526300 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLHMC_PEHDRCNT_MAX_INDEX		7
#define GLHMC_PEHDRCNT_GLHMC_PEHDRCNT_S		0
#define GLHMC_PEHDRCNT_GLHMC_PEHDRCNT_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLHMC_PEHDRMAX				0x00522008 /* Reset Source: CORER */
#define GLHMC_PEHDRMAX_PMPEHDRMAX_S		0
#define GLHMC_PEHDRMAX_PMPEHDRMAX_M		MAKEMASK(0x7FFFF, 0)
#define GLHMC_PEHDRMAX_RSVD_S			19
#define GLHMC_PEHDRMAX_RSVD_M			MAKEMASK(0x1FFF, 19)
#define GLHMC_PEHDROBJSZ			0x00522004 /* Reset Source: CORER */
#define GLHMC_PEHDROBJSZ_PMPEHDROBJSZ_S		0
#define GLHMC_PEHDROBJSZ_PMPEHDROBJSZ_M		MAKEMASK(0xF, 0)
#define GLHMC_PEHDROBJSZ_RSVD_S			4
#define GLHMC_PEHDROBJSZ_RSVD_M			MAKEMASK(0xFFFFFFF, 4)
#define GLHMC_PEHTCNT(_i)			(0x00524700 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLHMC_PEHTCNT_MAX_INDEX			7
#define GLHMC_PEHTCNT_FPMPEHTCNT_S		0
#define GLHMC_PEHTCNT_FPMPEHTCNT_M		MAKEMASK(0x1FFFFFFF, 0)
#define GLHMC_PEHTCNT_FPMAT(_i)			(0x00104700 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLHMC_PEHTCNT_FPMAT_MAX_INDEX		7
#define GLHMC_PEHTCNT_FPMAT_FPMPEHTCNT_S	0
#define GLHMC_PEHTCNT_FPMAT_FPMPEHTCNT_M	MAKEMASK(0x1FFFFFFF, 0)
#define GLHMC_PEHTEBASE(_i)			(0x00524600 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLHMC_PEHTEBASE_MAX_INDEX		7
#define GLHMC_PEHTEBASE_FPMPEHTEBASE_S		0
#define GLHMC_PEHTEBASE_FPMPEHTEBASE_M		MAKEMASK(0xFFFFFF, 0)
#define GLHMC_PEHTEBASE_FPMAT(_i)		(0x00104600 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLHMC_PEHTEBASE_FPMAT_MAX_INDEX		7
#define GLHMC_PEHTEBASE_FPMAT_FPMPEHTEBASE_S	0
#define GLHMC_PEHTEBASE_FPMAT_FPMPEHTEBASE_M	MAKEMASK(0xFFFFFF, 0)
#define GLHMC_PEHTEOBJSZ			0x0052202C /* Reset Source: CORER */
#define GLHMC_PEHTEOBJSZ_PMPEHTEOBJSZ_S		0
#define GLHMC_PEHTEOBJSZ_PMPEHTEOBJSZ_M		MAKEMASK(0xF, 0)
#define GLHMC_PEHTEOBJSZ_FPMAT			0x0010202C /* Reset Source: CORER */
#define GLHMC_PEHTEOBJSZ_FPMAT_PMPEHTEOBJSZ_S	0
#define GLHMC_PEHTEOBJSZ_FPMAT_PMPEHTEOBJSZ_M	MAKEMASK(0xF, 0)
#define GLHMC_PEHTMAX				0x00522030 /* Reset Source: CORER */
#define GLHMC_PEHTMAX_PMPEHTMAX_S		0
#define GLHMC_PEHTMAX_PMPEHTMAX_M		MAKEMASK(0x1FFFFF, 0)
#define GLHMC_PEHTMAX_FPMAT			0x00102030 /* Reset Source: CORER */
#define GLHMC_PEHTMAX_FPMAT_PMPEHTMAX_S		0
#define GLHMC_PEHTMAX_FPMAT_PMPEHTMAX_M		MAKEMASK(0x1FFFFF, 0)
#define GLHMC_PEMDBASE(_i)			(0x00526400 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLHMC_PEMDBASE_MAX_INDEX		7
#define GLHMC_PEMDBASE_GLHMC_PEMDBASE_S		0
#define GLHMC_PEMDBASE_GLHMC_PEMDBASE_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLHMC_PEMDCNT(_i)			(0x00526500 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLHMC_PEMDCNT_MAX_INDEX			7
#define GLHMC_PEMDCNT_GLHMC_PEMDCNT_S		0
#define GLHMC_PEMDCNT_GLHMC_PEMDCNT_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLHMC_PEMDMAX				0x00522010 /* Reset Source: CORER */
#define GLHMC_PEMDMAX_PMPEMDMAX_S		0
#define GLHMC_PEMDMAX_PMPEMDMAX_M		MAKEMASK(0xFFFFFF, 0)
#define GLHMC_PEMDMAX_RSVD_S			24
#define GLHMC_PEMDMAX_RSVD_M			MAKEMASK(0xFF, 24)
#define GLHMC_PEMDOBJSZ				0x0052200C /* Reset Source: CORER */
#define GLHMC_PEMDOBJSZ_PMPEMDOBJSZ_S		0
#define GLHMC_PEMDOBJSZ_PMPEMDOBJSZ_M		MAKEMASK(0xF, 0)
#define GLHMC_PEMDOBJSZ_RSVD_S			4
#define GLHMC_PEMDOBJSZ_RSVD_M			MAKEMASK(0xFFFFFFF, 4)
#define GLHMC_PEMRBASE(_i)			(0x00524C00 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLHMC_PEMRBASE_MAX_INDEX		7
#define GLHMC_PEMRBASE_FPMPEMRBASE_S		0
#define GLHMC_PEMRBASE_FPMPEMRBASE_M		MAKEMASK(0xFFFFFF, 0)
#define GLHMC_PEMRCNT(_i)			(0x00524D00 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLHMC_PEMRCNT_MAX_INDEX			7
#define GLHMC_PEMRCNT_FPMPEMRSZ_S		0
#define GLHMC_PEMRCNT_FPMPEMRSZ_M		MAKEMASK(0x1FFFFFFF, 0)
#define GLHMC_PEMRMAX				0x00522040 /* Reset Source: CORER */
#define GLHMC_PEMRMAX_PMPEMRMAX_S		0
#define GLHMC_PEMRMAX_PMPEMRMAX_M		MAKEMASK(0x7FFFFF, 0)
#define GLHMC_PEMROBJSZ				0x0052203C /* Reset Source: CORER */
#define GLHMC_PEMROBJSZ_PMPEMROBJSZ_S		0
#define GLHMC_PEMROBJSZ_PMPEMROBJSZ_M		MAKEMASK(0xF, 0)
#define GLHMC_PEOOISCBASE(_i)			(0x00526600 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLHMC_PEOOISCBASE_MAX_INDEX		7
#define GLHMC_PEOOISCBASE_GLHMC_PEOOISCBASE_S	0
#define GLHMC_PEOOISCBASE_GLHMC_PEOOISCBASE_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLHMC_PEOOISCCNT(_i)			(0x00526700 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLHMC_PEOOISCCNT_MAX_INDEX		7
#define GLHMC_PEOOISCCNT_GLHMC_PEOOISCCNT_S	0
#define GLHMC_PEOOISCCNT_GLHMC_PEOOISCCNT_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLHMC_PEOOISCFFLBASE(_i)		(0x00526C00 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLHMC_PEOOISCFFLBASE_MAX_INDEX		7
#define GLHMC_PEOOISCFFLBASE_GLHMC_PEOOISCFFLBASE_S 0
#define GLHMC_PEOOISCFFLBASE_GLHMC_PEOOISCFFLBASE_M MAKEMASK(0xFFFFFFFF, 0)
#define GLHMC_PEOOISCFFLCNT_PMAT(_i)		(0x00526D00 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLHMC_PEOOISCFFLCNT_PMAT_MAX_INDEX	7
#define GLHMC_PEOOISCFFLCNT_PMAT_FPMPEOOISCFLCNT_S 0
#define GLHMC_PEOOISCFFLCNT_PMAT_FPMPEOOISCFLCNT_M MAKEMASK(0x1FFFFFFF, 0)
#define GLHMC_PEOOISCFFLMAX			0x005220A4 /* Reset Source: CORER */
#define GLHMC_PEOOISCFFLMAX_PMPEOOISCFFLMAX_S	0
#define GLHMC_PEOOISCFFLMAX_PMPEOOISCFFLMAX_M	MAKEMASK(0x7FFFF, 0)
#define GLHMC_PEOOISCFFLMAX_RSVD_S		19
#define GLHMC_PEOOISCFFLMAX_RSVD_M		MAKEMASK(0x1FFF, 19)
#define GLHMC_PEOOISCMAX			0x00522018 /* Reset Source: CORER */
#define GLHMC_PEOOISCMAX_PMPEOOISCMAX_S		0
#define GLHMC_PEOOISCMAX_PMPEOOISCMAX_M		MAKEMASK(0x7FFFF, 0)
#define GLHMC_PEOOISCMAX_RSVD_S			19
#define GLHMC_PEOOISCMAX_RSVD_M			MAKEMASK(0x1FFF, 19)
#define GLHMC_PEOOISCOBJSZ			0x00522014 /* Reset Source: CORER */
#define GLHMC_PEOOISCOBJSZ_PMPEOOISCOBJSZ_S	0
#define GLHMC_PEOOISCOBJSZ_PMPEOOISCOBJSZ_M	MAKEMASK(0xF, 0)
#define GLHMC_PEOOISCOBJSZ_RSVD_S		4
#define GLHMC_PEOOISCOBJSZ_RSVD_M		MAKEMASK(0xFFFFFFF, 4)
#define GLHMC_PEPBLBASE(_i)			(0x00525800 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLHMC_PEPBLBASE_MAX_INDEX		7
#define GLHMC_PEPBLBASE_FPMPEPBLBASE_S		0
#define GLHMC_PEPBLBASE_FPMPEPBLBASE_M		MAKEMASK(0xFFFFFF, 0)
#define GLHMC_PEPBLCNT(_i)			(0x00525900 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLHMC_PEPBLCNT_MAX_INDEX		7
#define GLHMC_PEPBLCNT_FPMPEPBLCNT_S		0
#define GLHMC_PEPBLCNT_FPMPEPBLCNT_M		MAKEMASK(0x1FFFFFFF, 0)
#define GLHMC_PEPBLMAX				0x0052206C /* Reset Source: CORER */
#define GLHMC_PEPBLMAX_PMPEPBLMAX_S		0
#define GLHMC_PEPBLMAX_PMPEPBLMAX_M		MAKEMASK(0x1FFFFFFF, 0)
#define GLHMC_PEQ1BASE(_i)			(0x00525200 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLHMC_PEQ1BASE_MAX_INDEX		7
#define GLHMC_PEQ1BASE_FPMPEQ1BASE_S		0
#define GLHMC_PEQ1BASE_FPMPEQ1BASE_M		MAKEMASK(0xFFFFFF, 0)
#define GLHMC_PEQ1CNT(_i)			(0x00525300 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLHMC_PEQ1CNT_MAX_INDEX			7
#define GLHMC_PEQ1CNT_FPMPEQ1CNT_S		0
#define GLHMC_PEQ1CNT_FPMPEQ1CNT_M		MAKEMASK(0x1FFFFFFF, 0)
#define GLHMC_PEQ1FLBASE(_i)			(0x00525400 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLHMC_PEQ1FLBASE_MAX_INDEX		7
#define GLHMC_PEQ1FLBASE_FPMPEQ1FLBASE_S	0
#define GLHMC_PEQ1FLBASE_FPMPEQ1FLBASE_M	MAKEMASK(0xFFFFFF, 0)
#define GLHMC_PEQ1FLMAX				0x00522058 /* Reset Source: CORER */
#define GLHMC_PEQ1FLMAX_PMPEQ1FLMAX_S		0
#define GLHMC_PEQ1FLMAX_PMPEQ1FLMAX_M		MAKEMASK(0x3FFFFFF, 0)
#define GLHMC_PEQ1MAX				0x00522054 /* Reset Source: CORER */
#define GLHMC_PEQ1MAX_PMPEQ1MAX_S		0
#define GLHMC_PEQ1MAX_PMPEQ1MAX_M		MAKEMASK(0xFFFFFFF, 0)
#define GLHMC_PEQ1OBJSZ				0x00522050 /* Reset Source: CORER */
#define GLHMC_PEQ1OBJSZ_PMPEQ1OBJSZ_S		0
#define GLHMC_PEQ1OBJSZ_PMPEQ1OBJSZ_M		MAKEMASK(0xF, 0)
#define GLHMC_PEQPBASE(_i)			(0x00524000 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLHMC_PEQPBASE_MAX_INDEX		7
#define GLHMC_PEQPBASE_FPMPEQPBASE_S		0
#define GLHMC_PEQPBASE_FPMPEQPBASE_M		MAKEMASK(0xFFFFFF, 0)
#define GLHMC_PEQPCNT(_i)			(0x00524100 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLHMC_PEQPCNT_MAX_INDEX			7
#define GLHMC_PEQPCNT_FPMPEQPCNT_S		0
#define GLHMC_PEQPCNT_FPMPEQPCNT_M		MAKEMASK(0x1FFFFFFF, 0)
#define GLHMC_PEQPOBJSZ				0x0052201C /* Reset Source: CORER */
#define GLHMC_PEQPOBJSZ_PMPEQPOBJSZ_S		0
#define GLHMC_PEQPOBJSZ_PMPEQPOBJSZ_M		MAKEMASK(0xF, 0)
#define GLHMC_PERRFBASE(_i)			(0x00526800 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLHMC_PERRFBASE_MAX_INDEX		7
#define GLHMC_PERRFBASE_GLHMC_PERRFBASE_S	0
#define GLHMC_PERRFBASE_GLHMC_PERRFBASE_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLHMC_PERRFCNT(_i)			(0x00526900 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLHMC_PERRFCNT_MAX_INDEX		7
#define GLHMC_PERRFCNT_GLHMC_PERRFCNT_S		0
#define GLHMC_PERRFCNT_GLHMC_PERRFCNT_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLHMC_PERRFFLBASE(_i)			(0x00526A00 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLHMC_PERRFFLBASE_MAX_INDEX		7
#define GLHMC_PERRFFLBASE_GLHMC_PERRFFLBASE_S	0
#define GLHMC_PERRFFLBASE_GLHMC_PERRFFLBASE_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLHMC_PERRFFLCNT_PMAT(_i)		(0x00526B00 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLHMC_PERRFFLCNT_PMAT_MAX_INDEX		7
#define GLHMC_PERRFFLCNT_PMAT_FPMPERRFFLCNT_S	0
#define GLHMC_PERRFFLCNT_PMAT_FPMPERRFFLCNT_M	MAKEMASK(0x1FFFFFFF, 0)
#define GLHMC_PERRFFLMAX			0x005220A0 /* Reset Source: CORER */
#define GLHMC_PERRFFLMAX_PMPERRFFLMAX_S		0
#define GLHMC_PERRFFLMAX_PMPERRFFLMAX_M		MAKEMASK(0x3FFFFFF, 0)
#define GLHMC_PERRFFLMAX_RSVD_S			26
#define GLHMC_PERRFFLMAX_RSVD_M			MAKEMASK(0x3F, 26)
#define GLHMC_PERRFMAX				0x0052209C /* Reset Source: CORER */
#define GLHMC_PERRFMAX_PMPERRFMAX_S		0
#define GLHMC_PERRFMAX_PMPERRFMAX_M		MAKEMASK(0xFFFFFFF, 0)
#define GLHMC_PERRFMAX_RSVD_S			28
#define GLHMC_PERRFMAX_RSVD_M			MAKEMASK(0xF, 28)
#define GLHMC_PERRFOBJSZ			0x00522098 /* Reset Source: CORER */
#define GLHMC_PERRFOBJSZ_PMPERRFOBJSZ_S		0
#define GLHMC_PERRFOBJSZ_PMPERRFOBJSZ_M		MAKEMASK(0xF, 0)
#define GLHMC_PERRFOBJSZ_RSVD_S			4
#define GLHMC_PERRFOBJSZ_RSVD_M			MAKEMASK(0xFFFFFFF, 4)
#define GLHMC_PETIMERBASE(_i)			(0x00525A00 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLHMC_PETIMERBASE_MAX_INDEX		7
#define GLHMC_PETIMERBASE_FPMPETIMERBASE_S	0
#define GLHMC_PETIMERBASE_FPMPETIMERBASE_M	MAKEMASK(0xFFFFFF, 0)
#define GLHMC_PETIMERCNT(_i)			(0x00525B00 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLHMC_PETIMERCNT_MAX_INDEX		7
#define GLHMC_PETIMERCNT_FPMPETIMERCNT_S	0
#define GLHMC_PETIMERCNT_FPMPETIMERCNT_M	MAKEMASK(0x1FFFFFFF, 0)
#define GLHMC_PETIMERMAX			0x00522084 /* Reset Source: CORER */
#define GLHMC_PETIMERMAX_PMPETIMERMAX_S		0
#define GLHMC_PETIMERMAX_PMPETIMERMAX_M		MAKEMASK(0x1FFFFFFF, 0)
#define GLHMC_PETIMEROBJSZ			0x00522080 /* Reset Source: CORER */
#define GLHMC_PETIMEROBJSZ_PMPETIMEROBJSZ_S	0
#define GLHMC_PETIMEROBJSZ_PMPETIMEROBJSZ_M	MAKEMASK(0xF, 0)
#define GLHMC_PEXFBASE(_i)			(0x00524E00 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLHMC_PEXFBASE_MAX_INDEX		7
#define GLHMC_PEXFBASE_FPMPEXFBASE_S		0
#define GLHMC_PEXFBASE_FPMPEXFBASE_M		MAKEMASK(0xFFFFFF, 0)
#define GLHMC_PEXFCNT(_i)			(0x00524F00 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLHMC_PEXFCNT_MAX_INDEX			7
#define GLHMC_PEXFCNT_FPMPEXFCNT_S		0
#define GLHMC_PEXFCNT_FPMPEXFCNT_M		MAKEMASK(0x1FFFFFFF, 0)
#define GLHMC_PEXFFLBASE(_i)			(0x00525000 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLHMC_PEXFFLBASE_MAX_INDEX		7
#define GLHMC_PEXFFLBASE_FPMPEXFFLBASE_S	0
#define GLHMC_PEXFFLBASE_FPMPEXFFLBASE_M	MAKEMASK(0xFFFFFF, 0)
#define GLHMC_PEXFFLMAX				0x0052204C /* Reset Source: CORER */
#define GLHMC_PEXFFLMAX_PMPEXFFLMAX_S		0
#define GLHMC_PEXFFLMAX_PMPEXFFLMAX_M		MAKEMASK(0xFFFFFFF, 0)
#define GLHMC_PEXFMAX				0x00522048 /* Reset Source: CORER */
#define GLHMC_PEXFMAX_PMPEXFMAX_S		0
#define GLHMC_PEXFMAX_PMPEXFMAX_M		MAKEMASK(0xFFFFFFF, 0)
#define GLHMC_PEXFOBJSZ				0x00522044 /* Reset Source: CORER */
#define GLHMC_PEXFOBJSZ_PMPEXFOBJSZ_S		0
#define GLHMC_PEXFOBJSZ_PMPEXFOBJSZ_M		MAKEMASK(0xF, 0)
#define GLHMC_PFPESDPART(_i)			(0x00520880 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLHMC_PFPESDPART_MAX_INDEX		7
#define GLHMC_PFPESDPART_PMSDBASE_S		0
#define GLHMC_PFPESDPART_PMSDBASE_M		MAKEMASK(0xFFF, 0)
#define GLHMC_PFPESDPART_PMSDSIZE_S		16
#define GLHMC_PFPESDPART_PMSDSIZE_M		MAKEMASK(0x1FFF, 16)
#define GLHMC_PFPESDPART_FPMAT(_i)		(0x00100880 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLHMC_PFPESDPART_FPMAT_MAX_INDEX	7
#define GLHMC_PFPESDPART_FPMAT_PMSDBASE_S	0
#define GLHMC_PFPESDPART_FPMAT_PMSDBASE_M	MAKEMASK(0xFFF, 0)
#define GLHMC_PFPESDPART_FPMAT_PMSDSIZE_S	16
#define GLHMC_PFPESDPART_FPMAT_PMSDSIZE_M	MAKEMASK(0x1FFF, 16)
#define GLHMC_SDPART(_i)			(0x00520800 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLHMC_SDPART_MAX_INDEX			7
#define GLHMC_SDPART_PMSDBASE_S			0
#define GLHMC_SDPART_PMSDBASE_M			MAKEMASK(0xFFF, 0)
#define GLHMC_SDPART_PMSDSIZE_S			16
#define GLHMC_SDPART_PMSDSIZE_M			MAKEMASK(0x1FFF, 16)
#define GLHMC_SDPART_FPMAT(_i)			(0x00100800 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLHMC_SDPART_FPMAT_MAX_INDEX		7
#define GLHMC_SDPART_FPMAT_PMSDBASE_S		0
#define GLHMC_SDPART_FPMAT_PMSDBASE_M		MAKEMASK(0xFFF, 0)
#define GLHMC_SDPART_FPMAT_PMSDSIZE_S		16
#define GLHMC_SDPART_FPMAT_PMSDSIZE_M		MAKEMASK(0x1FFF, 16)
#define GLHMC_VFAPBVTINUSEBASE(_i)		(0x0052CA00 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLHMC_VFAPBVTINUSEBASE_MAX_INDEX	31
#define GLHMC_VFAPBVTINUSEBASE_FPMAPBINUSEBASE_S 0
#define GLHMC_VFAPBVTINUSEBASE_FPMAPBINUSEBASE_M MAKEMASK(0xFFFFFF, 0)
#define GLHMC_VFCEQPART(_i)			(0x00502F00 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLHMC_VFCEQPART_MAX_INDEX		31
#define GLHMC_VFCEQPART_PMCEQBASE_S		0
#define GLHMC_VFCEQPART_PMCEQBASE_M		MAKEMASK(0x3FF, 0)
#define GLHMC_VFCEQPART_PMCEQSIZE_S		16
#define GLHMC_VFCEQPART_PMCEQSIZE_M		MAKEMASK(0x3FF, 16)
#define GLHMC_VFDBCQPART(_i)			(0x00502E00 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLHMC_VFDBCQPART_MAX_INDEX		31
#define GLHMC_VFDBCQPART_PMDBCQBASE_S		0
#define GLHMC_VFDBCQPART_PMDBCQBASE_M		MAKEMASK(0x3FFF, 0)
#define GLHMC_VFDBCQPART_PMDBCQSIZE_S		16
#define GLHMC_VFDBCQPART_PMDBCQSIZE_M		MAKEMASK(0x7FFF, 16)
#define GLHMC_VFDBQPPART(_i)			(0x00504520 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLHMC_VFDBQPPART_MAX_INDEX		31
#define GLHMC_VFDBQPPART_PMDBQPBASE_S		0
#define GLHMC_VFDBQPPART_PMDBQPBASE_M		MAKEMASK(0x3FFF, 0)
#define GLHMC_VFDBQPPART_PMDBQPSIZE_S		16
#define GLHMC_VFDBQPPART_PMDBQPSIZE_M		MAKEMASK(0x7FFF, 16)
#define GLHMC_VFFSIAVBASE(_i)			(0x0052D600 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLHMC_VFFSIAVBASE_MAX_INDEX		31
#define GLHMC_VFFSIAVBASE_FPMFSIAVBASE_S	0
#define GLHMC_VFFSIAVBASE_FPMFSIAVBASE_M	MAKEMASK(0xFFFFFF, 0)
#define GLHMC_VFFSIAVCNT(_i)			(0x0052D700 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLHMC_VFFSIAVCNT_MAX_INDEX		31
#define GLHMC_VFFSIAVCNT_FPMFSIAVCNT_S		0
#define GLHMC_VFFSIAVCNT_FPMFSIAVCNT_M		MAKEMASK(0x1FFFFFFF, 0)
#define GLHMC_VFFSIMCBASE(_i)			(0x0052E000 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLHMC_VFFSIMCBASE_MAX_INDEX		31
#define GLHMC_VFFSIMCBASE_FPMFSIMCBASE_S	0
#define GLHMC_VFFSIMCBASE_FPMFSIMCBASE_M	MAKEMASK(0xFFFFFF, 0)
#define GLHMC_VFFSIMCCNT(_i)			(0x0052E100 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLHMC_VFFSIMCCNT_MAX_INDEX		31
#define GLHMC_VFFSIMCCNT_FPMFSIMCSZ_S		0
#define GLHMC_VFFSIMCCNT_FPMFSIMCSZ_M		MAKEMASK(0x1FFFFFFF, 0)
#define GLHMC_VFPDINV(_i)			(0x00528300 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLHMC_VFPDINV_MAX_INDEX			31
#define GLHMC_VFPDINV_PMSDIDX_S			0
#define GLHMC_VFPDINV_PMSDIDX_M			MAKEMASK(0xFFF, 0)
#define GLHMC_VFPDINV_PMSDPARTSEL_S		15
#define GLHMC_VFPDINV_PMSDPARTSEL_M		BIT(15)
#define GLHMC_VFPDINV_PMPDIDX_S			16
#define GLHMC_VFPDINV_PMPDIDX_M			MAKEMASK(0x1FF, 16)
#define GLHMC_VFPDINV_FPMAT(_i)			(0x00108300 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLHMC_VFPDINV_FPMAT_MAX_INDEX		31
#define GLHMC_VFPDINV_FPMAT_PMSDIDX_S		0
#define GLHMC_VFPDINV_FPMAT_PMSDIDX_M		MAKEMASK(0xFFF, 0)
#define GLHMC_VFPDINV_FPMAT_PMSDPARTSEL_S	15
#define GLHMC_VFPDINV_FPMAT_PMSDPARTSEL_M	BIT(15)
#define GLHMC_VFPDINV_FPMAT_PMPDIDX_S		16
#define GLHMC_VFPDINV_FPMAT_PMPDIDX_M		MAKEMASK(0x1FF, 16)
#define GLHMC_VFPEARPBASE(_i)			(0x0052C800 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLHMC_VFPEARPBASE_MAX_INDEX		31
#define GLHMC_VFPEARPBASE_FPMPEARPBASE_S	0
#define GLHMC_VFPEARPBASE_FPMPEARPBASE_M	MAKEMASK(0xFFFFFF, 0)
#define GLHMC_VFPEARPCNT(_i)			(0x0052C900 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLHMC_VFPEARPCNT_MAX_INDEX		31
#define GLHMC_VFPEARPCNT_FPMPEARPCNT_S		0
#define GLHMC_VFPEARPCNT_FPMPEARPCNT_M		MAKEMASK(0x1FFFFFFF, 0)
#define GLHMC_VFPECQBASE(_i)			(0x0052C200 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLHMC_VFPECQBASE_MAX_INDEX		31
#define GLHMC_VFPECQBASE_FPMPECQBASE_S		0
#define GLHMC_VFPECQBASE_FPMPECQBASE_M		MAKEMASK(0xFFFFFF, 0)
#define GLHMC_VFPECQCNT(_i)			(0x0052C300 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLHMC_VFPECQCNT_MAX_INDEX		31
#define GLHMC_VFPECQCNT_FPMPECQCNT_S		0
#define GLHMC_VFPECQCNT_FPMPECQCNT_M		MAKEMASK(0x1FFFFFFF, 0)
#define GLHMC_VFPEHDRBASE(_i)			(0x0052E200 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLHMC_VFPEHDRBASE_MAX_INDEX		31
#define GLHMC_VFPEHDRBASE_GLHMC_PEHDRBASE_S	0
#define GLHMC_VFPEHDRBASE_GLHMC_PEHDRBASE_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLHMC_VFPEHDRCNT(_i)			(0x0052E300 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLHMC_VFPEHDRCNT_MAX_INDEX		31
#define GLHMC_VFPEHDRCNT_GLHMC_PEHDRCNT_S	0
#define GLHMC_VFPEHDRCNT_GLHMC_PEHDRCNT_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLHMC_VFPEHTCNT(_i)			(0x0052C700 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLHMC_VFPEHTCNT_MAX_INDEX		31
#define GLHMC_VFPEHTCNT_FPMPEHTCNT_S		0
#define GLHMC_VFPEHTCNT_FPMPEHTCNT_M		MAKEMASK(0x1FFFFFFF, 0)
#define GLHMC_VFPEHTCNT_FPMAT(_i)		(0x0010C700 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLHMC_VFPEHTCNT_FPMAT_MAX_INDEX		31
#define GLHMC_VFPEHTCNT_FPMAT_FPMPEHTCNT_S	0
#define GLHMC_VFPEHTCNT_FPMAT_FPMPEHTCNT_M	MAKEMASK(0x1FFFFFFF, 0)
#define GLHMC_VFPEHTEBASE(_i)			(0x0052C600 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLHMC_VFPEHTEBASE_MAX_INDEX		31
#define GLHMC_VFPEHTEBASE_FPMPEHTEBASE_S	0
#define GLHMC_VFPEHTEBASE_FPMPEHTEBASE_M	MAKEMASK(0xFFFFFF, 0)
#define GLHMC_VFPEHTEBASE_FPMAT(_i)		(0x0010C600 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLHMC_VFPEHTEBASE_FPMAT_MAX_INDEX	31
#define GLHMC_VFPEHTEBASE_FPMAT_FPMPEHTEBASE_S	0
#define GLHMC_VFPEHTEBASE_FPMAT_FPMPEHTEBASE_M	MAKEMASK(0xFFFFFF, 0)
#define GLHMC_VFPEMDBASE(_i)			(0x0052E400 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLHMC_VFPEMDBASE_MAX_INDEX		31
#define GLHMC_VFPEMDBASE_GLHMC_PEMDBASE_S	0
#define GLHMC_VFPEMDBASE_GLHMC_PEMDBASE_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLHMC_VFPEMDCNT(_i)			(0x0052E500 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLHMC_VFPEMDCNT_MAX_INDEX		31
#define GLHMC_VFPEMDCNT_GLHMC_PEMDCNT_S		0
#define GLHMC_VFPEMDCNT_GLHMC_PEMDCNT_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLHMC_VFPEMRBASE(_i)			(0x0052CC00 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLHMC_VFPEMRBASE_MAX_INDEX		31
#define GLHMC_VFPEMRBASE_FPMPEMRBASE_S		0
#define GLHMC_VFPEMRBASE_FPMPEMRBASE_M		MAKEMASK(0xFFFFFF, 0)
#define GLHMC_VFPEMRCNT(_i)			(0x0052CD00 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLHMC_VFPEMRCNT_MAX_INDEX		31
#define GLHMC_VFPEMRCNT_FPMPEMRSZ_S		0
#define GLHMC_VFPEMRCNT_FPMPEMRSZ_M		MAKEMASK(0x1FFFFFFF, 0)
#define GLHMC_VFPEOOISCBASE(_i)			(0x0052E600 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLHMC_VFPEOOISCBASE_MAX_INDEX		31
#define GLHMC_VFPEOOISCBASE_GLHMC_PEOOISCBASE_S 0
#define GLHMC_VFPEOOISCBASE_GLHMC_PEOOISCBASE_M MAKEMASK(0xFFFFFFFF, 0)
#define GLHMC_VFPEOOISCCNT(_i)			(0x0052E700 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLHMC_VFPEOOISCCNT_MAX_INDEX		31
#define GLHMC_VFPEOOISCCNT_GLHMC_PEOOISCCNT_S	0
#define GLHMC_VFPEOOISCCNT_GLHMC_PEOOISCCNT_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLHMC_VFPEOOISCFFLBASE(_i)		(0x0052EC00 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLHMC_VFPEOOISCFFLBASE_MAX_INDEX	31
#define GLHMC_VFPEOOISCFFLBASE_GLHMC_PEOOISCFFLBASE_S 0
#define GLHMC_VFPEOOISCFFLBASE_GLHMC_PEOOISCFFLBASE_M MAKEMASK(0xFFFFFFFF, 0)
#define GLHMC_VFPEPBLBASE(_i)			(0x0052D800 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLHMC_VFPEPBLBASE_MAX_INDEX		31
#define GLHMC_VFPEPBLBASE_FPMPEPBLBASE_S	0
#define GLHMC_VFPEPBLBASE_FPMPEPBLBASE_M	MAKEMASK(0xFFFFFF, 0)
#define GLHMC_VFPEPBLCNT(_i)			(0x0052D900 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLHMC_VFPEPBLCNT_MAX_INDEX		31
#define GLHMC_VFPEPBLCNT_FPMPEPBLCNT_S		0
#define GLHMC_VFPEPBLCNT_FPMPEPBLCNT_M		MAKEMASK(0x1FFFFFFF, 0)
#define GLHMC_VFPEQ1BASE(_i)			(0x0052D200 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLHMC_VFPEQ1BASE_MAX_INDEX		31
#define GLHMC_VFPEQ1BASE_FPMPEQ1BASE_S		0
#define GLHMC_VFPEQ1BASE_FPMPEQ1BASE_M		MAKEMASK(0xFFFFFF, 0)
#define GLHMC_VFPEQ1CNT(_i)			(0x0052D300 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLHMC_VFPEQ1CNT_MAX_INDEX		31
#define GLHMC_VFPEQ1CNT_FPMPEQ1CNT_S		0
#define GLHMC_VFPEQ1CNT_FPMPEQ1CNT_M		MAKEMASK(0x1FFFFFFF, 0)
#define GLHMC_VFPEQ1FLBASE(_i)			(0x0052D400 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLHMC_VFPEQ1FLBASE_MAX_INDEX		31
#define GLHMC_VFPEQ1FLBASE_FPMPEQ1FLBASE_S	0
#define GLHMC_VFPEQ1FLBASE_FPMPEQ1FLBASE_M	MAKEMASK(0xFFFFFF, 0)
#define GLHMC_VFPEQPBASE(_i)			(0x0052C000 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLHMC_VFPEQPBASE_MAX_INDEX		31
#define GLHMC_VFPEQPBASE_FPMPEQPBASE_S		0
#define GLHMC_VFPEQPBASE_FPMPEQPBASE_M		MAKEMASK(0xFFFFFF, 0)
#define GLHMC_VFPEQPCNT(_i)			(0x0052C100 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLHMC_VFPEQPCNT_MAX_INDEX		31
#define GLHMC_VFPEQPCNT_FPMPEQPCNT_S		0
#define GLHMC_VFPEQPCNT_FPMPEQPCNT_M		MAKEMASK(0x1FFFFFFF, 0)
#define GLHMC_VFPERRFBASE(_i)			(0x0052E800 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLHMC_VFPERRFBASE_MAX_INDEX		31
#define GLHMC_VFPERRFBASE_GLHMC_PERRFBASE_S	0
#define GLHMC_VFPERRFBASE_GLHMC_PERRFBASE_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLHMC_VFPERRFCNT(_i)			(0x0052E900 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLHMC_VFPERRFCNT_MAX_INDEX		31
#define GLHMC_VFPERRFCNT_GLHMC_PERRFCNT_S	0
#define GLHMC_VFPERRFCNT_GLHMC_PERRFCNT_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLHMC_VFPERRFFLBASE(_i)			(0x0052EA00 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLHMC_VFPERRFFLBASE_MAX_INDEX		31
#define GLHMC_VFPERRFFLBASE_GLHMC_PERRFFLBASE_S 0
#define GLHMC_VFPERRFFLBASE_GLHMC_PERRFFLBASE_M MAKEMASK(0xFFFFFFFF, 0)
#define GLHMC_VFPETIMERBASE(_i)			(0x0052DA00 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLHMC_VFPETIMERBASE_MAX_INDEX		31
#define GLHMC_VFPETIMERBASE_FPMPETIMERBASE_S	0
#define GLHMC_VFPETIMERBASE_FPMPETIMERBASE_M	MAKEMASK(0xFFFFFF, 0)
#define GLHMC_VFPETIMERCNT(_i)			(0x0052DB00 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLHMC_VFPETIMERCNT_MAX_INDEX		31
#define GLHMC_VFPETIMERCNT_FPMPETIMERCNT_S	0
#define GLHMC_VFPETIMERCNT_FPMPETIMERCNT_M	MAKEMASK(0x1FFFFFFF, 0)
#define GLHMC_VFPEXFBASE(_i)			(0x0052CE00 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLHMC_VFPEXFBASE_MAX_INDEX		31
#define GLHMC_VFPEXFBASE_FPMPEXFBASE_S		0
#define GLHMC_VFPEXFBASE_FPMPEXFBASE_M		MAKEMASK(0xFFFFFF, 0)
#define GLHMC_VFPEXFCNT(_i)			(0x0052CF00 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLHMC_VFPEXFCNT_MAX_INDEX		31
#define GLHMC_VFPEXFCNT_FPMPEXFCNT_S		0
#define GLHMC_VFPEXFCNT_FPMPEXFCNT_M		MAKEMASK(0x1FFFFFFF, 0)
#define GLHMC_VFPEXFFLBASE(_i)			(0x0052D000 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLHMC_VFPEXFFLBASE_MAX_INDEX		31
#define GLHMC_VFPEXFFLBASE_FPMPEXFFLBASE_S	0
#define GLHMC_VFPEXFFLBASE_FPMPEXFFLBASE_M	MAKEMASK(0xFFFFFF, 0)
#define GLHMC_VFSDDATAHIGH(_i)			(0x00528200 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLHMC_VFSDDATAHIGH_MAX_INDEX		31
#define GLHMC_VFSDDATAHIGH_PMSDDATAHIGH_S	0
#define GLHMC_VFSDDATAHIGH_PMSDDATAHIGH_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLHMC_VFSDDATAHIGH_FPMAT(_i)		(0x00108200 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLHMC_VFSDDATAHIGH_FPMAT_MAX_INDEX	31
#define GLHMC_VFSDDATAHIGH_FPMAT_PMSDDATAHIGH_S 0
#define GLHMC_VFSDDATAHIGH_FPMAT_PMSDDATAHIGH_M MAKEMASK(0xFFFFFFFF, 0)
#define GLHMC_VFSDDATALOW(_i)			(0x00528100 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLHMC_VFSDDATALOW_MAX_INDEX		31
#define GLHMC_VFSDDATALOW_PMSDVALID_S		0
#define GLHMC_VFSDDATALOW_PMSDVALID_M		BIT(0)
#define GLHMC_VFSDDATALOW_PMSDTYPE_S		1
#define GLHMC_VFSDDATALOW_PMSDTYPE_M		BIT(1)
#define GLHMC_VFSDDATALOW_PMSDBPCOUNT_S		2
#define GLHMC_VFSDDATALOW_PMSDBPCOUNT_M		MAKEMASK(0x3FF, 2)
#define GLHMC_VFSDDATALOW_PMSDDATALOW_S		12
#define GLHMC_VFSDDATALOW_PMSDDATALOW_M		MAKEMASK(0xFFFFF, 12)
#define GLHMC_VFSDDATALOW_FPMAT(_i)		(0x00108100 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLHMC_VFSDDATALOW_FPMAT_MAX_INDEX	31
#define GLHMC_VFSDDATALOW_FPMAT_PMSDVALID_S	0
#define GLHMC_VFSDDATALOW_FPMAT_PMSDVALID_M	BIT(0)
#define GLHMC_VFSDDATALOW_FPMAT_PMSDTYPE_S	1
#define GLHMC_VFSDDATALOW_FPMAT_PMSDTYPE_M	BIT(1)
#define GLHMC_VFSDDATALOW_FPMAT_PMSDBPCOUNT_S	2
#define GLHMC_VFSDDATALOW_FPMAT_PMSDBPCOUNT_M	MAKEMASK(0x3FF, 2)
#define GLHMC_VFSDDATALOW_FPMAT_PMSDDATALOW_S	12
#define GLHMC_VFSDDATALOW_FPMAT_PMSDDATALOW_M	MAKEMASK(0xFFFFF, 12)
#define GLHMC_VFSDPART(_i)			(0x00528800 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLHMC_VFSDPART_MAX_INDEX		31
#define GLHMC_VFSDPART_PMSDBASE_S		0
#define GLHMC_VFSDPART_PMSDBASE_M		MAKEMASK(0xFFF, 0)
#define GLHMC_VFSDPART_PMSDSIZE_S		16
#define GLHMC_VFSDPART_PMSDSIZE_M		MAKEMASK(0x1FFF, 16)
#define GLHMC_VFSDPART_FPMAT(_i)		(0x00108800 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLHMC_VFSDPART_FPMAT_MAX_INDEX		31
#define GLHMC_VFSDPART_FPMAT_PMSDBASE_S		0
#define GLHMC_VFSDPART_FPMAT_PMSDBASE_M		MAKEMASK(0xFFF, 0)
#define GLHMC_VFSDPART_FPMAT_PMSDSIZE_S		16
#define GLHMC_VFSDPART_FPMAT_PMSDSIZE_M		MAKEMASK(0x1FFF, 16)
#define GLMDOC_CACHESIZE			0x0051C06C /* Reset Source: CORER */
#define GLMDOC_CACHESIZE_WORD_SIZE_S		0
#define GLMDOC_CACHESIZE_WORD_SIZE_M		MAKEMASK(0xFF, 0)
#define GLMDOC_CACHESIZE_SETS_S			8
#define GLMDOC_CACHESIZE_SETS_M			MAKEMASK(0xFFF, 8)
#define GLMDOC_CACHESIZE_WAYS_S			20
#define GLMDOC_CACHESIZE_WAYS_M			MAKEMASK(0xF, 20)
#define GLPBLOC0_CACHESIZE			0x00518074 /* Reset Source: CORER */
#define GLPBLOC0_CACHESIZE_WORD_SIZE_S		0
#define GLPBLOC0_CACHESIZE_WORD_SIZE_M		MAKEMASK(0xFF, 0)
#define GLPBLOC0_CACHESIZE_SETS_S		8
#define GLPBLOC0_CACHESIZE_SETS_M		MAKEMASK(0xFFF, 8)
#define GLPBLOC0_CACHESIZE_WAYS_S		20
#define GLPBLOC0_CACHESIZE_WAYS_M		MAKEMASK(0xF, 20)
#define GLPBLOC1_CACHESIZE			0x0051A074 /* Reset Source: CORER */
#define GLPBLOC1_CACHESIZE_WORD_SIZE_S		0
#define GLPBLOC1_CACHESIZE_WORD_SIZE_M		MAKEMASK(0xFF, 0)
#define GLPBLOC1_CACHESIZE_SETS_S		8
#define GLPBLOC1_CACHESIZE_SETS_M		MAKEMASK(0xFFF, 8)
#define GLPBLOC1_CACHESIZE_WAYS_S		20
#define GLPBLOC1_CACHESIZE_WAYS_M		MAKEMASK(0xF, 20)
#define GLPDOC_CACHESIZE			0x00530048 /* Reset Source: CORER */
#define GLPDOC_CACHESIZE_WORD_SIZE_S		0
#define GLPDOC_CACHESIZE_WORD_SIZE_M		MAKEMASK(0xFF, 0)
#define GLPDOC_CACHESIZE_SETS_S			8
#define GLPDOC_CACHESIZE_SETS_M			MAKEMASK(0xFFF, 8)
#define GLPDOC_CACHESIZE_WAYS_S			20
#define GLPDOC_CACHESIZE_WAYS_M			MAKEMASK(0xF, 20)
#define GLPDOC_CACHESIZE_FPMAT			0x00110088 /* Reset Source: CORER */
#define GLPDOC_CACHESIZE_FPMAT_WORD_SIZE_S	0
#define GLPDOC_CACHESIZE_FPMAT_WORD_SIZE_M	MAKEMASK(0xFF, 0)
#define GLPDOC_CACHESIZE_FPMAT_SETS_S		8
#define GLPDOC_CACHESIZE_FPMAT_SETS_M		MAKEMASK(0xFFF, 8)
#define GLPDOC_CACHESIZE_FPMAT_WAYS_S		20
#define GLPDOC_CACHESIZE_FPMAT_WAYS_M		MAKEMASK(0xF, 20)
#define GLPEOC0_CACHESIZE			0x005140A8 /* Reset Source: CORER */
#define GLPEOC0_CACHESIZE_WORD_SIZE_S		0
#define GLPEOC0_CACHESIZE_WORD_SIZE_M		MAKEMASK(0xFF, 0)
#define GLPEOC0_CACHESIZE_SETS_S		8
#define GLPEOC0_CACHESIZE_SETS_M		MAKEMASK(0xFFF, 8)
#define GLPEOC0_CACHESIZE_WAYS_S		20
#define GLPEOC0_CACHESIZE_WAYS_M		MAKEMASK(0xF, 20)
#define GLPEOC1_CACHESIZE			0x005160A8 /* Reset Source: CORER */
#define GLPEOC1_CACHESIZE_WORD_SIZE_S		0
#define GLPEOC1_CACHESIZE_WORD_SIZE_M		MAKEMASK(0xFF, 0)
#define GLPEOC1_CACHESIZE_SETS_S		8
#define GLPEOC1_CACHESIZE_SETS_M		MAKEMASK(0xFFF, 8)
#define GLPEOC1_CACHESIZE_WAYS_S		20
#define GLPEOC1_CACHESIZE_WAYS_M		MAKEMASK(0xF, 20)
#define PFHMC_ERRORDATA				0x00520500 /* Reset Source: PFR */
#define PFHMC_ERRORDATA_HMC_ERROR_DATA_S	0
#define PFHMC_ERRORDATA_HMC_ERROR_DATA_M	MAKEMASK(0x3FFFFFFF, 0)
#define PFHMC_ERRORDATA_FPMAT			0x00100500 /* Reset Source: PFR */
#define PFHMC_ERRORDATA_FPMAT_HMC_ERROR_DATA_S	0
#define PFHMC_ERRORDATA_FPMAT_HMC_ERROR_DATA_M	MAKEMASK(0x3FFFFFFF, 0)
#define PFHMC_ERRORINFO				0x00520400 /* Reset Source: PFR */
#define PFHMC_ERRORINFO_PMF_INDEX_S		0
#define PFHMC_ERRORINFO_PMF_INDEX_M		MAKEMASK(0x1F, 0)
#define PFHMC_ERRORINFO_PMF_ISVF_S		7
#define PFHMC_ERRORINFO_PMF_ISVF_M		BIT(7)
#define PFHMC_ERRORINFO_HMC_ERROR_TYPE_S	8
#define PFHMC_ERRORINFO_HMC_ERROR_TYPE_M	MAKEMASK(0xF, 8)
#define PFHMC_ERRORINFO_HMC_OBJECT_TYPE_S	16
#define PFHMC_ERRORINFO_HMC_OBJECT_TYPE_M	MAKEMASK(0x1F, 16)
#define PFHMC_ERRORINFO_ERROR_DETECTED_S	31
#define PFHMC_ERRORINFO_ERROR_DETECTED_M	BIT(31)
#define PFHMC_ERRORINFO_FPMAT			0x00100400 /* Reset Source: PFR */
#define PFHMC_ERRORINFO_FPMAT_PMF_INDEX_S	0
#define PFHMC_ERRORINFO_FPMAT_PMF_INDEX_M	MAKEMASK(0x1F, 0)
#define PFHMC_ERRORINFO_FPMAT_PMF_ISVF_S	7
#define PFHMC_ERRORINFO_FPMAT_PMF_ISVF_M	BIT(7)
#define PFHMC_ERRORINFO_FPMAT_HMC_ERROR_TYPE_S	8
#define PFHMC_ERRORINFO_FPMAT_HMC_ERROR_TYPE_M	MAKEMASK(0xF, 8)
#define PFHMC_ERRORINFO_FPMAT_HMC_OBJECT_TYPE_S 16
#define PFHMC_ERRORINFO_FPMAT_HMC_OBJECT_TYPE_M MAKEMASK(0x1F, 16)
#define PFHMC_ERRORINFO_FPMAT_ERROR_DETECTED_S	31
#define PFHMC_ERRORINFO_FPMAT_ERROR_DETECTED_M	BIT(31)
#define PFHMC_PDINV				0x00520300 /* Reset Source: PFR */
#define PFHMC_PDINV_PMSDIDX_S			0
#define PFHMC_PDINV_PMSDIDX_M			MAKEMASK(0xFFF, 0)
#define PFHMC_PDINV_PMSDPARTSEL_S		15
#define PFHMC_PDINV_PMSDPARTSEL_M		BIT(15)
#define PFHMC_PDINV_PMPDIDX_S			16
#define PFHMC_PDINV_PMPDIDX_M			MAKEMASK(0x1FF, 16)
#define PFHMC_PDINV_FPMAT			0x00100300 /* Reset Source: PFR */
#define PFHMC_PDINV_FPMAT_PMSDIDX_S		0
#define PFHMC_PDINV_FPMAT_PMSDIDX_M		MAKEMASK(0xFFF, 0)
#define PFHMC_PDINV_FPMAT_PMSDPARTSEL_S		15
#define PFHMC_PDINV_FPMAT_PMSDPARTSEL_M		BIT(15)
#define PFHMC_PDINV_FPMAT_PMPDIDX_S		16
#define PFHMC_PDINV_FPMAT_PMPDIDX_M		MAKEMASK(0x1FF, 16)
#define PFHMC_SDCMD				0x00520000 /* Reset Source: PFR */
#define PFHMC_SDCMD_PMSDIDX_S			0
#define PFHMC_SDCMD_PMSDIDX_M			MAKEMASK(0xFFF, 0)
#define PFHMC_SDCMD_PMSDPARTSEL_S		15
#define PFHMC_SDCMD_PMSDPARTSEL_M		BIT(15)
#define PFHMC_SDCMD_PMSDWR_S			31
#define PFHMC_SDCMD_PMSDWR_M			BIT(31)
#define PFHMC_SDCMD_FPMAT			0x00100000 /* Reset Source: PFR */
#define PFHMC_SDCMD_FPMAT_PMSDIDX_S		0
#define PFHMC_SDCMD_FPMAT_PMSDIDX_M		MAKEMASK(0xFFF, 0)
#define PFHMC_SDCMD_FPMAT_PMSDPARTSEL_S		15
#define PFHMC_SDCMD_FPMAT_PMSDPARTSEL_M		BIT(15)
#define PFHMC_SDCMD_FPMAT_PMSDWR_S		31
#define PFHMC_SDCMD_FPMAT_PMSDWR_M		BIT(31)
#define PFHMC_SDDATAHIGH			0x00520200 /* Reset Source: PFR */
#define PFHMC_SDDATAHIGH_PMSDDATAHIGH_S		0
#define PFHMC_SDDATAHIGH_PMSDDATAHIGH_M		MAKEMASK(0xFFFFFFFF, 0)
#define PFHMC_SDDATAHIGH_FPMAT			0x00100200 /* Reset Source: PFR */
#define PFHMC_SDDATAHIGH_FPMAT_PMSDDATAHIGH_S	0
#define PFHMC_SDDATAHIGH_FPMAT_PMSDDATAHIGH_M	MAKEMASK(0xFFFFFFFF, 0)
#define PFHMC_SDDATALOW				0x00520100 /* Reset Source: PFR */
#define PFHMC_SDDATALOW_PMSDVALID_S		0
#define PFHMC_SDDATALOW_PMSDVALID_M		BIT(0)
#define PFHMC_SDDATALOW_PMSDTYPE_S		1
#define PFHMC_SDDATALOW_PMSDTYPE_M		BIT(1)
#define PFHMC_SDDATALOW_PMSDBPCOUNT_S		2
#define PFHMC_SDDATALOW_PMSDBPCOUNT_M		MAKEMASK(0x3FF, 2)
#define PFHMC_SDDATALOW_PMSDDATALOW_S		12
#define PFHMC_SDDATALOW_PMSDDATALOW_M		MAKEMASK(0xFFFFF, 12)
#define PFHMC_SDDATALOW_FPMAT			0x00100100 /* Reset Source: PFR */
#define PFHMC_SDDATALOW_FPMAT_PMSDVALID_S	0
#define PFHMC_SDDATALOW_FPMAT_PMSDVALID_M	BIT(0)
#define PFHMC_SDDATALOW_FPMAT_PMSDTYPE_S	1
#define PFHMC_SDDATALOW_FPMAT_PMSDTYPE_M	BIT(1)
#define PFHMC_SDDATALOW_FPMAT_PMSDBPCOUNT_S	2
#define PFHMC_SDDATALOW_FPMAT_PMSDBPCOUNT_M	MAKEMASK(0x3FF, 2)
#define PFHMC_SDDATALOW_FPMAT_PMSDDATALOW_S	12
#define PFHMC_SDDATALOW_FPMAT_PMSDDATALOW_M	MAKEMASK(0xFFFFF, 12)
#define GL_DSI_REPC				0x00294208 /* Reset Source: CORER */
#define GL_DSI_REPC_NO_DESC_CNT_S		0
#define GL_DSI_REPC_NO_DESC_CNT_M		MAKEMASK(0xFFFF, 0)
#define GL_DSI_REPC_ERROR_CNT_S			16
#define GL_DSI_REPC_ERROR_CNT_M			MAKEMASK(0xFFFF, 16)
#define GL_MDCK_TDAT_TCLAN			0x000FC0DC /* Reset Source: CORER */
#define GL_MDCK_TDAT_TCLAN_WRONG_ORDER_FORMAT_DESC_S 0
#define GL_MDCK_TDAT_TCLAN_WRONG_ORDER_FORMAT_DESC_M BIT(0)
#define GL_MDCK_TDAT_TCLAN_UR_S			1
#define GL_MDCK_TDAT_TCLAN_UR_M			BIT(1)
#define GL_MDCK_TDAT_TCLAN_TAIL_DESC_NOT_DDESC_EOP_NOP_S 2
#define GL_MDCK_TDAT_TCLAN_TAIL_DESC_NOT_DDESC_EOP_NOP_M BIT(2)
#define GL_MDCK_TDAT_TCLAN_FALSE_SCHEDULING_S	3
#define GL_MDCK_TDAT_TCLAN_FALSE_SCHEDULING_M	BIT(3)
#define GL_MDCK_TDAT_TCLAN_TAIL_VALUE_BIGGER_THAN_RING_LEN_S 4
#define GL_MDCK_TDAT_TCLAN_TAIL_VALUE_BIGGER_THAN_RING_LEN_M BIT(4)
#define GL_MDCK_TDAT_TCLAN_MORE_THAN_8_DCMDS_IN_PKT_S 5
#define GL_MDCK_TDAT_TCLAN_MORE_THAN_8_DCMDS_IN_PKT_M BIT(5)
#define GL_MDCK_TDAT_TCLAN_NO_HEAD_UPDATE_IN_QUANTA_S 6
#define GL_MDCK_TDAT_TCLAN_NO_HEAD_UPDATE_IN_QUANTA_M BIT(6)
#define GL_MDCK_TDAT_TCLAN_PKT_LEN_NOT_LEGAL_S	7
#define GL_MDCK_TDAT_TCLAN_PKT_LEN_NOT_LEGAL_M	BIT(7)
#define GL_MDCK_TDAT_TCLAN_TSO_TLEN_NOT_COHERENT_WITH_SUM_BUFS_S 8
#define GL_MDCK_TDAT_TCLAN_TSO_TLEN_NOT_COHERENT_WITH_SUM_BUFS_M BIT(8)
#define GL_MDCK_TDAT_TCLAN_TSO_TAIL_REACHED_BEFORE_TLEN_END_S 9
#define GL_MDCK_TDAT_TCLAN_TSO_TAIL_REACHED_BEFORE_TLEN_END_M BIT(9)
#define GL_MDCK_TDAT_TCLAN_TSO_MORE_THAN_3_HDRS_S 10
#define GL_MDCK_TDAT_TCLAN_TSO_MORE_THAN_3_HDRS_M BIT(10)
#define GL_MDCK_TDAT_TCLAN_TSO_SUM_BUFFS_LT_SUM_HDRS_S 11
#define GL_MDCK_TDAT_TCLAN_TSO_SUM_BUFFS_LT_SUM_HDRS_M BIT(11)
#define GL_MDCK_TDAT_TCLAN_TSO_ZERO_MSS_TLEN_HDRS_S 12
#define GL_MDCK_TDAT_TCLAN_TSO_ZERO_MSS_TLEN_HDRS_M BIT(12)
#define GL_MDCK_TDAT_TCLAN_TSO_CTX_DESC_IPSEC_S 13
#define GL_MDCK_TDAT_TCLAN_TSO_CTX_DESC_IPSEC_M BIT(13)
#define GL_MDCK_TDAT_TCLAN_SSO_COMS_NOT_WHOLE_PKT_NUM_IN_QUANTA_S 14
#define GL_MDCK_TDAT_TCLAN_SSO_COMS_NOT_WHOLE_PKT_NUM_IN_QUANTA_M BIT(14)
#define GL_MDCK_TDAT_TCLAN_COMS_QUANTA_BYTES_EXCEED_PKTLEN_X_64_S 15
#define GL_MDCK_TDAT_TCLAN_COMS_QUANTA_BYTES_EXCEED_PKTLEN_X_64_M BIT(15)
#define GL_MDCK_TDAT_TCLAN_COMS_QUANTA_CMDS_EXCEED_S 16
#define GL_MDCK_TDAT_TCLAN_COMS_QUANTA_CMDS_EXCEED_M BIT(16)
#define GL_MDCK_TDAT_TCLAN_TSO_COMS_TSO_DESCS_LAST_LSO_QUANTA_S 17
#define GL_MDCK_TDAT_TCLAN_TSO_COMS_TSO_DESCS_LAST_LSO_QUANTA_M BIT(17)
#define GL_MDCK_TDAT_TCLAN_TSO_COMS_TSO_DESCS_TLEN_S 18
#define GL_MDCK_TDAT_TCLAN_TSO_COMS_TSO_DESCS_TLEN_M BIT(18)
#define GL_MDCK_TDAT_TCLAN_TSO_COMS_QUANTA_FINISHED_TOO_EARLY_S 19
#define GL_MDCK_TDAT_TCLAN_TSO_COMS_QUANTA_FINISHED_TOO_EARLY_M BIT(19)
#define GL_MDCK_TDAT_TCLAN_COMS_NUM_PKTS_IN_QUANTA_S 20
#define GL_MDCK_TDAT_TCLAN_COMS_NUM_PKTS_IN_QUANTA_M BIT(20)
#define GLCORE_CLKCTL_H				0x000B81E8 /* Reset Source: POR */
#define GLCORE_CLKCTL_H_UPPER_CLK_SRC_H_S	0
#define GLCORE_CLKCTL_H_UPPER_CLK_SRC_H_M	MAKEMASK(0x3, 0)
#define GLCORE_CLKCTL_H_LOWER_CLK_SRC_H_S	2
#define GLCORE_CLKCTL_H_LOWER_CLK_SRC_H_M	MAKEMASK(0x3, 2)
#define GLCORE_CLKCTL_H_PSM_CLK_SRC_H_S		4
#define GLCORE_CLKCTL_H_PSM_CLK_SRC_H_M		MAKEMASK(0x3, 4)
#define GLCORE_CLKCTL_H_RXCTL_CLK_SRC_H_S	6
#define GLCORE_CLKCTL_H_RXCTL_CLK_SRC_H_M	MAKEMASK(0x3, 6)
#define GLCORE_CLKCTL_H_UANA_CLK_SRC_H_S	8
#define GLCORE_CLKCTL_H_UANA_CLK_SRC_H_M	MAKEMASK(0x7, 8)
#define GLCORE_CLKCTL_L				0x000B8254 /* Reset Source: POR */
#define GLCORE_CLKCTL_L_UPPER_CLK_SRC_L_S	0
#define GLCORE_CLKCTL_L_UPPER_CLK_SRC_L_M	MAKEMASK(0x3, 0)
#define GLCORE_CLKCTL_L_LOWER_CLK_SRC_L_S	2
#define GLCORE_CLKCTL_L_LOWER_CLK_SRC_L_M	MAKEMASK(0x3, 2)
#define GLCORE_CLKCTL_L_PSM_CLK_SRC_L_S		4
#define GLCORE_CLKCTL_L_PSM_CLK_SRC_L_M		MAKEMASK(0x3, 4)
#define GLCORE_CLKCTL_L_RXCTL_CLK_SRC_L_S	6
#define GLCORE_CLKCTL_L_RXCTL_CLK_SRC_L_M	MAKEMASK(0x3, 6)
#define GLCORE_CLKCTL_L_UANA_CLK_SRC_L_S	8
#define GLCORE_CLKCTL_L_UANA_CLK_SRC_L_M	MAKEMASK(0x7, 8)
#define GLCORE_CLKCTL_M				0x000B8258 /* Reset Source: POR */
#define GLCORE_CLKCTL_M_UPPER_CLK_SRC_M_S	0
#define GLCORE_CLKCTL_M_UPPER_CLK_SRC_M_M	MAKEMASK(0x3, 0)
#define GLCORE_CLKCTL_M_LOWER_CLK_SRC_M_S	2
#define GLCORE_CLKCTL_M_LOWER_CLK_SRC_M_M	MAKEMASK(0x3, 2)
#define GLCORE_CLKCTL_M_PSM_CLK_SRC_M_S		4
#define GLCORE_CLKCTL_M_PSM_CLK_SRC_M_M		MAKEMASK(0x3, 4)
#define GLCORE_CLKCTL_M_RXCTL_CLK_SRC_M_S	6
#define GLCORE_CLKCTL_M_RXCTL_CLK_SRC_M_M	MAKEMASK(0x3, 6)
#define GLCORE_CLKCTL_M_UANA_CLK_SRC_M_S	8
#define GLCORE_CLKCTL_M_UANA_CLK_SRC_M_M	MAKEMASK(0x7, 8)
#define GLFOC_CACHESIZE				0x000AA074 /* Reset Source: CORER */
#define GLFOC_CACHESIZE_WORD_SIZE_S		0
#define GLFOC_CACHESIZE_WORD_SIZE_M		MAKEMASK(0xFF, 0)
#define GLFOC_CACHESIZE_SETS_S			8
#define GLFOC_CACHESIZE_SETS_M			MAKEMASK(0xFFF, 8)
#define GLFOC_CACHESIZE_WAYS_S			20
#define GLFOC_CACHESIZE_WAYS_M			MAKEMASK(0xF, 20)
#define GLMAC_CLKSTAT				0x000B8210 /* Reset Source: POR */
#define GLMAC_CLKSTAT_P0_CLK_SPEED_S		0
#define GLMAC_CLKSTAT_P0_CLK_SPEED_M		MAKEMASK(0xF, 0)
#define GLMAC_CLKSTAT_P1_CLK_SPEED_S		4
#define GLMAC_CLKSTAT_P1_CLK_SPEED_M		MAKEMASK(0xF, 4)
#define GLMAC_CLKSTAT_P2_CLK_SPEED_S		8
#define GLMAC_CLKSTAT_P2_CLK_SPEED_M		MAKEMASK(0xF, 8)
#define GLMAC_CLKSTAT_P3_CLK_SPEED_S		12
#define GLMAC_CLKSTAT_P3_CLK_SPEED_M		MAKEMASK(0xF, 12)
#define GLMAC_CLKSTAT_P4_CLK_SPEED_S		16
#define GLMAC_CLKSTAT_P4_CLK_SPEED_M		MAKEMASK(0xF, 16)
#define GLMAC_CLKSTAT_P5_CLK_SPEED_S		20
#define GLMAC_CLKSTAT_P5_CLK_SPEED_M		MAKEMASK(0xF, 20)
#define GLMAC_CLKSTAT_P6_CLK_SPEED_S		24
#define GLMAC_CLKSTAT_P6_CLK_SPEED_M		MAKEMASK(0xF, 24)
#define GLMAC_CLKSTAT_P7_CLK_SPEED_S		28
#define GLMAC_CLKSTAT_P7_CLK_SPEED_M		MAKEMASK(0xF, 28)
#define GLTPB_100G_MAC_FC_THRESH		0x00099510 /* Reset Source: CORER */
#define GLTPB_100G_MAC_FC_THRESH_PORT0_FC_THRESH_S 0
#define GLTPB_100G_MAC_FC_THRESH_PORT0_FC_THRESH_M MAKEMASK(0xFFFF, 0)
#define GLTPB_100G_MAC_FC_THRESH_PORT1_FC_THRESH_S 16
#define GLTPB_100G_MAC_FC_THRESH_PORT1_FC_THRESH_M MAKEMASK(0xFFFF, 16)
#define GLTPB_100G_RPB_FC_THRESH		0x0009963C /* Reset Source: CORER */
#define GLTPB_100G_RPB_FC_THRESH_PORT0_FC_THRESH_S 0
#define GLTPB_100G_RPB_FC_THRESH_PORT0_FC_THRESH_M MAKEMASK(0xFFFF, 0)
#define GLTPB_100G_RPB_FC_THRESH_PORT1_FC_THRESH_S 16
#define GLTPB_100G_RPB_FC_THRESH_PORT1_FC_THRESH_M MAKEMASK(0xFFFF, 16)
#define GLTPB_PACING_10G			0x000994E4 /* Reset Source: CORER */
#define GLTPB_PACING_10G_N_S			0
#define GLTPB_PACING_10G_N_M			MAKEMASK(0xFF, 0)
#define GLTPB_PACING_10G_K_S			8
#define GLTPB_PACING_10G_K_M			MAKEMASK(0xFF, 8)
#define GLTPB_PACING_10G_S_S			16
#define GLTPB_PACING_10G_S_M			MAKEMASK(0x1FF, 16)
#define GLTPB_PACING_25G			0x000994E0 /* Reset Source: CORER */
#define GLTPB_PACING_25G_N_S			0
#define GLTPB_PACING_25G_N_M			MAKEMASK(0xFF, 0)
#define GLTPB_PACING_25G_K_S			8
#define GLTPB_PACING_25G_K_M			MAKEMASK(0xFF, 8)
#define GLTPB_PACING_25G_S_S			16
#define GLTPB_PACING_25G_S_M			MAKEMASK(0x1FF, 16)
#define GLTPB_PORT_PACING_SPEED			0x000994E8 /* Reset Source: CORER */
#define GLTPB_PORT_PACING_SPEED_PORT0_SPEED_S	0
#define GLTPB_PORT_PACING_SPEED_PORT0_SPEED_M	BIT(0)
#define GLTPB_PORT_PACING_SPEED_PORT1_SPEED_S	1
#define GLTPB_PORT_PACING_SPEED_PORT1_SPEED_M	BIT(1)
#define GLTPB_PORT_PACING_SPEED_PORT2_SPEED_S	2
#define GLTPB_PORT_PACING_SPEED_PORT2_SPEED_M	BIT(2)
#define GLTPB_PORT_PACING_SPEED_PORT3_SPEED_S	3
#define GLTPB_PORT_PACING_SPEED_PORT3_SPEED_M	BIT(3)
#define GLTPB_PORT_PACING_SPEED_PORT4_SPEED_S	4
#define GLTPB_PORT_PACING_SPEED_PORT4_SPEED_M	BIT(4)
#define GLTPB_PORT_PACING_SPEED_PORT5_SPEED_S	5
#define GLTPB_PORT_PACING_SPEED_PORT5_SPEED_M	BIT(5)
#define GLTPB_PORT_PACING_SPEED_PORT6_SPEED_S	6
#define GLTPB_PORT_PACING_SPEED_PORT6_SPEED_M	BIT(6)
#define GLTPB_PORT_PACING_SPEED_PORT7_SPEED_S	7
#define GLTPB_PORT_PACING_SPEED_PORT7_SPEED_M	BIT(7)
#define TPB_CFG_SCHEDULED_BC_THRESHOLD		0x00099494 /* Reset Source: CORER */
#define TPB_CFG_SCHEDULED_BC_THRESHOLD_THRESHOLD_S 0
#define TPB_CFG_SCHEDULED_BC_THRESHOLD_THRESHOLD_M MAKEMASK(0x7FFF, 0)
#define GL_UFUSE_SOC				0x000A400C /* Reset Source: POR */
#define GL_UFUSE_SOC_PORT_MODE_S		0
#define GL_UFUSE_SOC_PORT_MODE_M		MAKEMASK(0x3, 0)
#define GL_UFUSE_SOC_BANDWIDTH_S		2
#define GL_UFUSE_SOC_BANDWIDTH_M		MAKEMASK(0x3, 2)
#define GL_UFUSE_SOC_PE_DISABLE_S		4
#define GL_UFUSE_SOC_PE_DISABLE_M		BIT(4)
#define GL_UFUSE_SOC_SWITCH_MODE_S		5
#define GL_UFUSE_SOC_SWITCH_MODE_M		BIT(5)
#define GL_UFUSE_SOC_CSR_PROTECTION_ENABLE_S	6
#define GL_UFUSE_SOC_CSR_PROTECTION_ENABLE_M	BIT(6)
#define GL_UFUSE_SOC_SERIAL_50G_S		7
#define GL_UFUSE_SOC_SERIAL_50G_M		BIT(7)
#define GL_UFUSE_SOC_NIC_ID_S			8
#define GL_UFUSE_SOC_NIC_ID_M			BIT(8)
#define GL_UFUSE_SOC_BLOCK_BME_TO_FW_S		9
#define GL_UFUSE_SOC_BLOCK_BME_TO_FW_M		BIT(9)
#define GL_UFUSE_SOC_SOC_TYPE_S			10
#define GL_UFUSE_SOC_SOC_TYPE_M			BIT(10)
#define GL_UFUSE_SOC_BTS_MODE_S			11
#define GL_UFUSE_SOC_BTS_MODE_M			BIT(11)
#define GL_UFUSE_SOC_SPARE_FUSES_S		12
#define GL_UFUSE_SOC_SPARE_FUSES_M		MAKEMASK(0xF, 12)
#define EMPINT_GPIO_ENA				0x000880C0 /* Reset Source: POR */
#define EMPINT_GPIO_ENA_GPIO0_ENA_S		0
#define EMPINT_GPIO_ENA_GPIO0_ENA_M		BIT(0)
#define EMPINT_GPIO_ENA_GPIO1_ENA_S		1
#define EMPINT_GPIO_ENA_GPIO1_ENA_M		BIT(1)
#define EMPINT_GPIO_ENA_GPIO2_ENA_S		2
#define EMPINT_GPIO_ENA_GPIO2_ENA_M		BIT(2)
#define EMPINT_GPIO_ENA_GPIO3_ENA_S		3
#define EMPINT_GPIO_ENA_GPIO3_ENA_M		BIT(3)
#define EMPINT_GPIO_ENA_GPIO4_ENA_S		4
#define EMPINT_GPIO_ENA_GPIO4_ENA_M		BIT(4)
#define EMPINT_GPIO_ENA_GPIO5_ENA_S		5
#define EMPINT_GPIO_ENA_GPIO5_ENA_M		BIT(5)
#define EMPINT_GPIO_ENA_GPIO6_ENA_S		6
#define EMPINT_GPIO_ENA_GPIO6_ENA_M		BIT(6)
#define GLGEN_MAC_LINK_TOPO			0x000B81DC /* Reset Source: GLOBR */
#define GLGEN_MAC_LINK_TOPO_LINK_TOPO_S		0
#define GLGEN_MAC_LINK_TOPO_LINK_TOPO_M		MAKEMASK(0x3, 0)
#define GLINT_CEQCTL(_INT)			(0x0015C000 + ((_INT) * 4)) /* _i=0...2047 */ /* Reset Source: CORER */
#define GLINT_CEQCTL_MAX_INDEX			2047
#define GLINT_CEQCTL_MSIX_INDX_S		0
#define GLINT_CEQCTL_MSIX_INDX_M		MAKEMASK(0x7FF, 0)
#define GLINT_CEQCTL_ITR_INDX_S			11
#define GLINT_CEQCTL_ITR_INDX_M			MAKEMASK(0x3, 11)
#define GLINT_CEQCTL_CAUSE_ENA_S		30
#define GLINT_CEQCTL_CAUSE_ENA_M		BIT(30)
#define GLINT_CEQCTL_INTEVENT_S			31
#define GLINT_CEQCTL_INTEVENT_M			BIT(31)
#define GLINT_CTL				0x0016CC54 /* Reset Source: CORER */
#define GLINT_CTL_DIS_AUTOMASK_S		0
#define GLINT_CTL_DIS_AUTOMASK_M		BIT(0)
#define GLINT_CTL_RSVD_S			1
#define GLINT_CTL_RSVD_M			MAKEMASK(0x7FFF, 1)
#define GLINT_CTL_ITR_GRAN_200_S		16
#define GLINT_CTL_ITR_GRAN_200_M		MAKEMASK(0xF, 16)
#define GLINT_CTL_ITR_GRAN_100_S		20
#define GLINT_CTL_ITR_GRAN_100_M		MAKEMASK(0xF, 20)
#define GLINT_CTL_ITR_GRAN_50_S			24
#define GLINT_CTL_ITR_GRAN_50_M			MAKEMASK(0xF, 24)
#define GLINT_CTL_ITR_GRAN_25_S			28
#define GLINT_CTL_ITR_GRAN_25_M			MAKEMASK(0xF, 28)
#define GLINT_DYN_CTL(_INT)			(0x00160000 + ((_INT) * 4)) /* _i=0...2047 */ /* Reset Source: CORER */
#define GLINT_DYN_CTL_MAX_INDEX			2047
#define GLINT_DYN_CTL_INTENA_S			0
#define GLINT_DYN_CTL_INTENA_M			BIT(0)
#define GLINT_DYN_CTL_CLEARPBA_S		1
#define GLINT_DYN_CTL_CLEARPBA_M		BIT(1)
#define GLINT_DYN_CTL_SWINT_TRIG_S		2
#define GLINT_DYN_CTL_SWINT_TRIG_M		BIT(2)
#define GLINT_DYN_CTL_ITR_INDX_S		3
#define GLINT_DYN_CTL_ITR_INDX_M		MAKEMASK(0x3, 3)
#define GLINT_DYN_CTL_INTERVAL_S		5
#define GLINT_DYN_CTL_INTERVAL_M		MAKEMASK(0xFFF, 5)
#define GLINT_DYN_CTL_SW_ITR_INDX_ENA_S		24
#define GLINT_DYN_CTL_SW_ITR_INDX_ENA_M		BIT(24)
#define GLINT_DYN_CTL_SW_ITR_INDX_S		25
#define GLINT_DYN_CTL_SW_ITR_INDX_M		MAKEMASK(0x3, 25)
#define GLINT_DYN_CTL_WB_ON_ITR_S		30
#define GLINT_DYN_CTL_WB_ON_ITR_M		BIT(30)
#define GLINT_DYN_CTL_INTENA_MSK_S		31
#define GLINT_DYN_CTL_INTENA_MSK_M		BIT(31)
#define GLINT_FW_TOOL_CTL			0x0016C840 /* Reset Source: CORER */
#define GLINT_FW_TOOL_CTL_MSIX_INDX_S		0
#define GLINT_FW_TOOL_CTL_MSIX_INDX_M		MAKEMASK(0x7FF, 0)
#define GLINT_FW_TOOL_CTL_ITR_INDX_S		11
#define GLINT_FW_TOOL_CTL_ITR_INDX_M		MAKEMASK(0x3, 11)
#define GLINT_FW_TOOL_CTL_CAUSE_ENA_S		30
#define GLINT_FW_TOOL_CTL_CAUSE_ENA_M		BIT(30)
#define GLINT_FW_TOOL_CTL_INTEVENT_S		31
#define GLINT_FW_TOOL_CTL_INTEVENT_M		BIT(31)
#define GLINT_ITR(_i, _INT)			(0x00154000 + ((_i) * 8192 + (_INT) * 4)) /* _i=0...2, _INT=0...2047 */ /* Reset Source: CORER */
#define GLINT_ITR_MAX_INDEX			2
#define GLINT_ITR_INTERVAL_S			0
#define GLINT_ITR_INTERVAL_M			MAKEMASK(0xFFF, 0)
#define GLINT_RATE(_INT)			(0x0015A000 + ((_INT) * 4)) /* _i=0...2047 */ /* Reset Source: CORER */
#define GLINT_RATE_MAX_INDEX			2047
#define GLINT_RATE_INTERVAL_S			0
#define GLINT_RATE_INTERVAL_M			MAKEMASK(0x3F, 0)
#define GLINT_RATE_INTRL_ENA_S			6
#define GLINT_RATE_INTRL_ENA_M			BIT(6)
#define GLINT_TSYN_PFMSTR(_i)			(0x0016CCC0 + ((_i) * 4)) /* _i=0...1 */ /* Reset Source: CORER */
#define GLINT_TSYN_PFMSTR_MAX_INDEX		1
#define GLINT_TSYN_PFMSTR_PF_MASTER_S		0
#define GLINT_TSYN_PFMSTR_PF_MASTER_M		MAKEMASK(0x7, 0)
#define GLINT_TSYN_PHY				0x0016CC50 /* Reset Source: CORER */
#define GLINT_TSYN_PHY_PHY_INDX_S		0
#define GLINT_TSYN_PHY_PHY_INDX_M		MAKEMASK(0x1F, 0)
#define GLINT_VECT2FUNC(_INT)			(0x00162000 + ((_INT) * 4)) /* _i=0...2047 */ /* Reset Source: CORER */
#define GLINT_VECT2FUNC_MAX_INDEX		2047
#define GLINT_VECT2FUNC_VF_NUM_S		0
#define GLINT_VECT2FUNC_VF_NUM_M		MAKEMASK(0xFF, 0)
#define GLINT_VECT2FUNC_PF_NUM_S		12
#define GLINT_VECT2FUNC_PF_NUM_M		MAKEMASK(0x7, 12)
#define GLINT_VECT2FUNC_IS_PF_S			16
#define GLINT_VECT2FUNC_IS_PF_M			BIT(16)
#define PF0INT_FW_HLP_CTL			0x0016C844 /* Reset Source: CORER */
#define PF0INT_FW_HLP_CTL_MSIX_INDX_S		0
#define PF0INT_FW_HLP_CTL_MSIX_INDX_M		MAKEMASK(0x7FF, 0)
#define PF0INT_FW_HLP_CTL_ITR_INDX_S		11
#define PF0INT_FW_HLP_CTL_ITR_INDX_M		MAKEMASK(0x3, 11)
#define PF0INT_FW_HLP_CTL_CAUSE_ENA_S		30
#define PF0INT_FW_HLP_CTL_CAUSE_ENA_M		BIT(30)
#define PF0INT_FW_HLP_CTL_INTEVENT_S		31
#define PF0INT_FW_HLP_CTL_INTEVENT_M		BIT(31)
#define PF0INT_FW_PSM_CTL			0x0016C848 /* Reset Source: CORER */
#define PF0INT_FW_PSM_CTL_MSIX_INDX_S		0
#define PF0INT_FW_PSM_CTL_MSIX_INDX_M		MAKEMASK(0x7FF, 0)
#define PF0INT_FW_PSM_CTL_ITR_INDX_S		11
#define PF0INT_FW_PSM_CTL_ITR_INDX_M		MAKEMASK(0x3, 11)
#define PF0INT_FW_PSM_CTL_CAUSE_ENA_S		30
#define PF0INT_FW_PSM_CTL_CAUSE_ENA_M		BIT(30)
#define PF0INT_FW_PSM_CTL_INTEVENT_S		31
#define PF0INT_FW_PSM_CTL_INTEVENT_M		BIT(31)
#define PF0INT_MBX_CPM_CTL			0x0016B2C0 /* Reset Source: CORER */
#define PF0INT_MBX_CPM_CTL_MSIX_INDX_S		0
#define PF0INT_MBX_CPM_CTL_MSIX_INDX_M		MAKEMASK(0x7FF, 0)
#define PF0INT_MBX_CPM_CTL_ITR_INDX_S		11
#define PF0INT_MBX_CPM_CTL_ITR_INDX_M		MAKEMASK(0x3, 11)
#define PF0INT_MBX_CPM_CTL_CAUSE_ENA_S		30
#define PF0INT_MBX_CPM_CTL_CAUSE_ENA_M		BIT(30)
#define PF0INT_MBX_CPM_CTL_INTEVENT_S		31
#define PF0INT_MBX_CPM_CTL_INTEVENT_M		BIT(31)
#define PF0INT_MBX_HLP_CTL			0x0016B2C4 /* Reset Source: CORER */
#define PF0INT_MBX_HLP_CTL_MSIX_INDX_S		0
#define PF0INT_MBX_HLP_CTL_MSIX_INDX_M		MAKEMASK(0x7FF, 0)
#define PF0INT_MBX_HLP_CTL_ITR_INDX_S		11
#define PF0INT_MBX_HLP_CTL_ITR_INDX_M		MAKEMASK(0x3, 11)
#define PF0INT_MBX_HLP_CTL_CAUSE_ENA_S		30
#define PF0INT_MBX_HLP_CTL_CAUSE_ENA_M		BIT(30)
#define PF0INT_MBX_HLP_CTL_INTEVENT_S		31
#define PF0INT_MBX_HLP_CTL_INTEVENT_M		BIT(31)
#define PF0INT_MBX_PSM_CTL			0x0016B2C8 /* Reset Source: CORER */
#define PF0INT_MBX_PSM_CTL_MSIX_INDX_S		0
#define PF0INT_MBX_PSM_CTL_MSIX_INDX_M		MAKEMASK(0x7FF, 0)
#define PF0INT_MBX_PSM_CTL_ITR_INDX_S		11
#define PF0INT_MBX_PSM_CTL_ITR_INDX_M		MAKEMASK(0x3, 11)
#define PF0INT_MBX_PSM_CTL_CAUSE_ENA_S		30
#define PF0INT_MBX_PSM_CTL_CAUSE_ENA_M		BIT(30)
#define PF0INT_MBX_PSM_CTL_INTEVENT_S		31
#define PF0INT_MBX_PSM_CTL_INTEVENT_M		BIT(31)
#define PF0INT_OICR_CPM				0x0016CC40 /* Reset Source: CORER */
#define PF0INT_OICR_CPM_INTEVENT_S		0
#define PF0INT_OICR_CPM_INTEVENT_M		BIT(0)
#define PF0INT_OICR_CPM_QUEUE_S			1
#define PF0INT_OICR_CPM_QUEUE_M			BIT(1)
#define PF0INT_OICR_CPM_RSV1_S			2
#define PF0INT_OICR_CPM_RSV1_M			MAKEMASK(0xFF, 2)
#define PF0INT_OICR_CPM_HH_COMP_S		10
#define PF0INT_OICR_CPM_HH_COMP_M		BIT(10)
#define PF0INT_OICR_CPM_TSYN_TX_S		11
#define PF0INT_OICR_CPM_TSYN_TX_M		BIT(11)
#define PF0INT_OICR_CPM_TSYN_EVNT_S		12
#define PF0INT_OICR_CPM_TSYN_EVNT_M		BIT(12)
#define PF0INT_OICR_CPM_TSYN_TGT_S		13
#define PF0INT_OICR_CPM_TSYN_TGT_M		BIT(13)
#define PF0INT_OICR_CPM_HLP_RDY_S		14
#define PF0INT_OICR_CPM_HLP_RDY_M		BIT(14)
#define PF0INT_OICR_CPM_CPM_RDY_S		15
#define PF0INT_OICR_CPM_CPM_RDY_M		BIT(15)
#define PF0INT_OICR_CPM_ECC_ERR_S		16
#define PF0INT_OICR_CPM_ECC_ERR_M		BIT(16)
#define PF0INT_OICR_CPM_RSV2_S			17
#define PF0INT_OICR_CPM_RSV2_M			MAKEMASK(0x3, 17)
#define PF0INT_OICR_CPM_MAL_DETECT_S		19
#define PF0INT_OICR_CPM_MAL_DETECT_M		BIT(19)
#define PF0INT_OICR_CPM_GRST_S			20
#define PF0INT_OICR_CPM_GRST_M			BIT(20)
#define PF0INT_OICR_CPM_PCI_EXCEPTION_S		21
#define PF0INT_OICR_CPM_PCI_EXCEPTION_M		BIT(21)
#define PF0INT_OICR_CPM_GPIO_S			22
#define PF0INT_OICR_CPM_GPIO_M			BIT(22)
#define PF0INT_OICR_CPM_RSV3_S			23
#define PF0INT_OICR_CPM_RSV3_M			BIT(23)
#define PF0INT_OICR_CPM_STORM_DETECT_S		24
#define PF0INT_OICR_CPM_STORM_DETECT_M		BIT(24)
#define PF0INT_OICR_CPM_LINK_STAT_CHANGE_S	25
#define PF0INT_OICR_CPM_LINK_STAT_CHANGE_M	BIT(25)
#define PF0INT_OICR_CPM_HMC_ERR_S		26
#define PF0INT_OICR_CPM_HMC_ERR_M		BIT(26)
#define PF0INT_OICR_CPM_PE_PUSH_S		27
#define PF0INT_OICR_CPM_PE_PUSH_M		BIT(27)
#define PF0INT_OICR_CPM_PE_CRITERR_S		28
#define PF0INT_OICR_CPM_PE_CRITERR_M		BIT(28)
#define PF0INT_OICR_CPM_VFLR_S			29
#define PF0INT_OICR_CPM_VFLR_M			BIT(29)
#define PF0INT_OICR_CPM_XLR_HW_DONE_S		30
#define PF0INT_OICR_CPM_XLR_HW_DONE_M		BIT(30)
#define PF0INT_OICR_CPM_SWINT_S			31
#define PF0INT_OICR_CPM_SWINT_M			BIT(31)
#define PF0INT_OICR_CTL_CPM			0x0016CC48 /* Reset Source: CORER */
#define PF0INT_OICR_CTL_CPM_MSIX_INDX_S		0
#define PF0INT_OICR_CTL_CPM_MSIX_INDX_M		MAKEMASK(0x7FF, 0)
#define PF0INT_OICR_CTL_CPM_ITR_INDX_S		11
#define PF0INT_OICR_CTL_CPM_ITR_INDX_M		MAKEMASK(0x3, 11)
#define PF0INT_OICR_CTL_CPM_CAUSE_ENA_S		30
#define PF0INT_OICR_CTL_CPM_CAUSE_ENA_M		BIT(30)
#define PF0INT_OICR_CTL_CPM_INTEVENT_S		31
#define PF0INT_OICR_CTL_CPM_INTEVENT_M		BIT(31)
#define PF0INT_OICR_CTL_HLP			0x0016CC5C /* Reset Source: CORER */
#define PF0INT_OICR_CTL_HLP_MSIX_INDX_S		0
#define PF0INT_OICR_CTL_HLP_MSIX_INDX_M		MAKEMASK(0x7FF, 0)
#define PF0INT_OICR_CTL_HLP_ITR_INDX_S		11
#define PF0INT_OICR_CTL_HLP_ITR_INDX_M		MAKEMASK(0x3, 11)
#define PF0INT_OICR_CTL_HLP_CAUSE_ENA_S		30
#define PF0INT_OICR_CTL_HLP_CAUSE_ENA_M		BIT(30)
#define PF0INT_OICR_CTL_HLP_INTEVENT_S		31
#define PF0INT_OICR_CTL_HLP_INTEVENT_M		BIT(31)
#define PF0INT_OICR_CTL_PSM			0x0016CC64 /* Reset Source: CORER */
#define PF0INT_OICR_CTL_PSM_MSIX_INDX_S		0
#define PF0INT_OICR_CTL_PSM_MSIX_INDX_M		MAKEMASK(0x7FF, 0)
#define PF0INT_OICR_CTL_PSM_ITR_INDX_S		11
#define PF0INT_OICR_CTL_PSM_ITR_INDX_M		MAKEMASK(0x3, 11)
#define PF0INT_OICR_CTL_PSM_CAUSE_ENA_S		30
#define PF0INT_OICR_CTL_PSM_CAUSE_ENA_M		BIT(30)
#define PF0INT_OICR_CTL_PSM_INTEVENT_S		31
#define PF0INT_OICR_CTL_PSM_INTEVENT_M		BIT(31)
#define PF0INT_OICR_ENA_CPM			0x0016CC60 /* Reset Source: CORER */
#define PF0INT_OICR_ENA_CPM_RSV0_S		0
#define PF0INT_OICR_ENA_CPM_RSV0_M		BIT(0)
#define PF0INT_OICR_ENA_CPM_INT_ENA_S		1
#define PF0INT_OICR_ENA_CPM_INT_ENA_M		MAKEMASK(0x7FFFFFFF, 1)
#define PF0INT_OICR_ENA_HLP			0x0016CC4C /* Reset Source: CORER */
#define PF0INT_OICR_ENA_HLP_RSV0_S		0
#define PF0INT_OICR_ENA_HLP_RSV0_M		BIT(0)
#define PF0INT_OICR_ENA_HLP_INT_ENA_S		1
#define PF0INT_OICR_ENA_HLP_INT_ENA_M		MAKEMASK(0x7FFFFFFF, 1)
#define PF0INT_OICR_ENA_PSM			0x0016CC58 /* Reset Source: CORER */
#define PF0INT_OICR_ENA_PSM_RSV0_S		0
#define PF0INT_OICR_ENA_PSM_RSV0_M		BIT(0)
#define PF0INT_OICR_ENA_PSM_INT_ENA_S		1
#define PF0INT_OICR_ENA_PSM_INT_ENA_M		MAKEMASK(0x7FFFFFFF, 1)
#define PF0INT_OICR_HLP				0x0016CC68 /* Reset Source: CORER */
#define PF0INT_OICR_HLP_INTEVENT_S		0
#define PF0INT_OICR_HLP_INTEVENT_M		BIT(0)
#define PF0INT_OICR_HLP_QUEUE_S			1
#define PF0INT_OICR_HLP_QUEUE_M			BIT(1)
#define PF0INT_OICR_HLP_RSV1_S			2
#define PF0INT_OICR_HLP_RSV1_M			MAKEMASK(0xFF, 2)
#define PF0INT_OICR_HLP_HH_COMP_S		10
#define PF0INT_OICR_HLP_HH_COMP_M		BIT(10)
#define PF0INT_OICR_HLP_TSYN_TX_S		11
#define PF0INT_OICR_HLP_TSYN_TX_M		BIT(11)
#define PF0INT_OICR_HLP_TSYN_EVNT_S		12
#define PF0INT_OICR_HLP_TSYN_EVNT_M		BIT(12)
#define PF0INT_OICR_HLP_TSYN_TGT_S		13
#define PF0INT_OICR_HLP_TSYN_TGT_M		BIT(13)
#define PF0INT_OICR_HLP_HLP_RDY_S		14
#define PF0INT_OICR_HLP_HLP_RDY_M		BIT(14)
#define PF0INT_OICR_HLP_CPM_RDY_S		15
#define PF0INT_OICR_HLP_CPM_RDY_M		BIT(15)
#define PF0INT_OICR_HLP_ECC_ERR_S		16
#define PF0INT_OICR_HLP_ECC_ERR_M		BIT(16)
#define PF0INT_OICR_HLP_RSV2_S			17
#define PF0INT_OICR_HLP_RSV2_M			MAKEMASK(0x3, 17)
#define PF0INT_OICR_HLP_MAL_DETECT_S		19
#define PF0INT_OICR_HLP_MAL_DETECT_M		BIT(19)
#define PF0INT_OICR_HLP_GRST_S			20
#define PF0INT_OICR_HLP_GRST_M			BIT(20)
#define PF0INT_OICR_HLP_PCI_EXCEPTION_S		21
#define PF0INT_OICR_HLP_PCI_EXCEPTION_M		BIT(21)
#define PF0INT_OICR_HLP_GPIO_S			22
#define PF0INT_OICR_HLP_GPIO_M			BIT(22)
#define PF0INT_OICR_HLP_RSV3_S			23
#define PF0INT_OICR_HLP_RSV3_M			BIT(23)
#define PF0INT_OICR_HLP_STORM_DETECT_S		24
#define PF0INT_OICR_HLP_STORM_DETECT_M		BIT(24)
#define PF0INT_OICR_HLP_LINK_STAT_CHANGE_S	25
#define PF0INT_OICR_HLP_LINK_STAT_CHANGE_M	BIT(25)
#define PF0INT_OICR_HLP_HMC_ERR_S		26
#define PF0INT_OICR_HLP_HMC_ERR_M		BIT(26)
#define PF0INT_OICR_HLP_PE_PUSH_S		27
#define PF0INT_OICR_HLP_PE_PUSH_M		BIT(27)
#define PF0INT_OICR_HLP_PE_CRITERR_S		28
#define PF0INT_OICR_HLP_PE_CRITERR_M		BIT(28)
#define PF0INT_OICR_HLP_VFLR_S			29
#define PF0INT_OICR_HLP_VFLR_M			BIT(29)
#define PF0INT_OICR_HLP_XLR_HW_DONE_S		30
#define PF0INT_OICR_HLP_XLR_HW_DONE_M		BIT(30)
#define PF0INT_OICR_HLP_SWINT_S			31
#define PF0INT_OICR_HLP_SWINT_M			BIT(31)
#define PF0INT_OICR_PSM				0x0016CC44 /* Reset Source: CORER */
#define PF0INT_OICR_PSM_INTEVENT_S		0
#define PF0INT_OICR_PSM_INTEVENT_M		BIT(0)
#define PF0INT_OICR_PSM_QUEUE_S			1
#define PF0INT_OICR_PSM_QUEUE_M			BIT(1)
#define PF0INT_OICR_PSM_RSV1_S			2
#define PF0INT_OICR_PSM_RSV1_M			MAKEMASK(0xFF, 2)
#define PF0INT_OICR_PSM_HH_COMP_S		10
#define PF0INT_OICR_PSM_HH_COMP_M		BIT(10)
#define PF0INT_OICR_PSM_TSYN_TX_S		11
#define PF0INT_OICR_PSM_TSYN_TX_M		BIT(11)
#define PF0INT_OICR_PSM_TSYN_EVNT_S		12
#define PF0INT_OICR_PSM_TSYN_EVNT_M		BIT(12)
#define PF0INT_OICR_PSM_TSYN_TGT_S		13
#define PF0INT_OICR_PSM_TSYN_TGT_M		BIT(13)
#define PF0INT_OICR_PSM_HLP_RDY_S		14
#define PF0INT_OICR_PSM_HLP_RDY_M		BIT(14)
#define PF0INT_OICR_PSM_CPM_RDY_S		15
#define PF0INT_OICR_PSM_CPM_RDY_M		BIT(15)
#define PF0INT_OICR_PSM_ECC_ERR_S		16
#define PF0INT_OICR_PSM_ECC_ERR_M		BIT(16)
#define PF0INT_OICR_PSM_RSV2_S			17
#define PF0INT_OICR_PSM_RSV2_M			MAKEMASK(0x3, 17)
#define PF0INT_OICR_PSM_MAL_DETECT_S		19
#define PF0INT_OICR_PSM_MAL_DETECT_M		BIT(19)
#define PF0INT_OICR_PSM_GRST_S			20
#define PF0INT_OICR_PSM_GRST_M			BIT(20)
#define PF0INT_OICR_PSM_PCI_EXCEPTION_S		21
#define PF0INT_OICR_PSM_PCI_EXCEPTION_M		BIT(21)
#define PF0INT_OICR_PSM_GPIO_S			22
#define PF0INT_OICR_PSM_GPIO_M			BIT(22)
#define PF0INT_OICR_PSM_RSV3_S			23
#define PF0INT_OICR_PSM_RSV3_M			BIT(23)
#define PF0INT_OICR_PSM_STORM_DETECT_S		24
#define PF0INT_OICR_PSM_STORM_DETECT_M		BIT(24)
#define PF0INT_OICR_PSM_LINK_STAT_CHANGE_S	25
#define PF0INT_OICR_PSM_LINK_STAT_CHANGE_M	BIT(25)
#define PF0INT_OICR_PSM_HMC_ERR_S		26
#define PF0INT_OICR_PSM_HMC_ERR_M		BIT(26)
#define PF0INT_OICR_PSM_PE_PUSH_S		27
#define PF0INT_OICR_PSM_PE_PUSH_M		BIT(27)
#define PF0INT_OICR_PSM_PE_CRITERR_S		28
#define PF0INT_OICR_PSM_PE_CRITERR_M		BIT(28)
#define PF0INT_OICR_PSM_VFLR_S			29
#define PF0INT_OICR_PSM_VFLR_M			BIT(29)
#define PF0INT_OICR_PSM_XLR_HW_DONE_S		30
#define PF0INT_OICR_PSM_XLR_HW_DONE_M		BIT(30)
#define PF0INT_OICR_PSM_SWINT_S			31
#define PF0INT_OICR_PSM_SWINT_M			BIT(31)
#define PF0INT_SB_CPM_CTL			0x0016B2CC /* Reset Source: CORER */
#define PF0INT_SB_CPM_CTL_MSIX_INDX_S		0
#define PF0INT_SB_CPM_CTL_MSIX_INDX_M		MAKEMASK(0x7FF, 0)
#define PF0INT_SB_CPM_CTL_ITR_INDX_S		11
#define PF0INT_SB_CPM_CTL_ITR_INDX_M		MAKEMASK(0x3, 11)
#define PF0INT_SB_CPM_CTL_CAUSE_ENA_S		30
#define PF0INT_SB_CPM_CTL_CAUSE_ENA_M		BIT(30)
#define PF0INT_SB_CPM_CTL_INTEVENT_S		31
#define PF0INT_SB_CPM_CTL_INTEVENT_M		BIT(31)
#define PF0INT_SB_HLP_CTL			0x0016B640 /* Reset Source: CORER */
#define PF0INT_SB_HLP_CTL_MSIX_INDX_S		0
#define PF0INT_SB_HLP_CTL_MSIX_INDX_M		MAKEMASK(0x7FF, 0)
#define PF0INT_SB_HLP_CTL_ITR_INDX_S		11
#define PF0INT_SB_HLP_CTL_ITR_INDX_M		MAKEMASK(0x3, 11)
#define PF0INT_SB_HLP_CTL_CAUSE_ENA_S		30
#define PF0INT_SB_HLP_CTL_CAUSE_ENA_M		BIT(30)
#define PF0INT_SB_HLP_CTL_INTEVENT_S		31
#define PF0INT_SB_HLP_CTL_INTEVENT_M		BIT(31)
#define PFINT_AEQCTL				0x0016CB00 /* Reset Source: CORER */
#define PFINT_AEQCTL_MSIX_INDX_S		0
#define PFINT_AEQCTL_MSIX_INDX_M		MAKEMASK(0x7FF, 0)
#define PFINT_AEQCTL_ITR_INDX_S			11
#define PFINT_AEQCTL_ITR_INDX_M			MAKEMASK(0x3, 11)
#define PFINT_AEQCTL_CAUSE_ENA_S		30
#define PFINT_AEQCTL_CAUSE_ENA_M		BIT(30)
#define PFINT_AEQCTL_INTEVENT_S			31
#define PFINT_AEQCTL_INTEVENT_M			BIT(31)
#define PFINT_ALLOC				0x001D2600 /* Reset Source: CORER */
#define PFINT_ALLOC_FIRST_S			0
#define PFINT_ALLOC_FIRST_M			MAKEMASK(0x7FF, 0)
#define PFINT_ALLOC_LAST_S			12
#define PFINT_ALLOC_LAST_M			MAKEMASK(0x7FF, 12)
#define PFINT_ALLOC_VALID_S			31
#define PFINT_ALLOC_VALID_M			BIT(31)
#define PFINT_ALLOC_PCI				0x0009D800 /* Reset Source: PCIR */
#define PFINT_ALLOC_PCI_FIRST_S			0
#define PFINT_ALLOC_PCI_FIRST_M			MAKEMASK(0x7FF, 0)
#define PFINT_ALLOC_PCI_LAST_S			12
#define PFINT_ALLOC_PCI_LAST_M			MAKEMASK(0x7FF, 12)
#define PFINT_ALLOC_PCI_VALID_S			31
#define PFINT_ALLOC_PCI_VALID_M			BIT(31)
#define PFINT_FW_CTL				0x0016C800 /* Reset Source: CORER */
#define PFINT_FW_CTL_MSIX_INDX_S		0
#define PFINT_FW_CTL_MSIX_INDX_M		MAKEMASK(0x7FF, 0)
#define PFINT_FW_CTL_ITR_INDX_S			11
#define PFINT_FW_CTL_ITR_INDX_M			MAKEMASK(0x3, 11)
#define PFINT_FW_CTL_CAUSE_ENA_S		30
#define PFINT_FW_CTL_CAUSE_ENA_M		BIT(30)
#define PFINT_FW_CTL_INTEVENT_S			31
#define PFINT_FW_CTL_INTEVENT_M			BIT(31)
#define PFINT_GPIO_ENA				0x00088080 /* Reset Source: CORER */
#define PFINT_GPIO_ENA_GPIO0_ENA_S		0
#define PFINT_GPIO_ENA_GPIO0_ENA_M		BIT(0)
#define PFINT_GPIO_ENA_GPIO1_ENA_S		1
#define PFINT_GPIO_ENA_GPIO1_ENA_M		BIT(1)
#define PFINT_GPIO_ENA_GPIO2_ENA_S		2
#define PFINT_GPIO_ENA_GPIO2_ENA_M		BIT(2)
#define PFINT_GPIO_ENA_GPIO3_ENA_S		3
#define PFINT_GPIO_ENA_GPIO3_ENA_M		BIT(3)
#define PFINT_GPIO_ENA_GPIO4_ENA_S		4
#define PFINT_GPIO_ENA_GPIO4_ENA_M		BIT(4)
#define PFINT_GPIO_ENA_GPIO5_ENA_S		5
#define PFINT_GPIO_ENA_GPIO5_ENA_M		BIT(5)
#define PFINT_GPIO_ENA_GPIO6_ENA_S		6
#define PFINT_GPIO_ENA_GPIO6_ENA_M		BIT(6)
#define PFINT_MBX_CTL				0x0016B280 /* Reset Source: CORER */
#define PFINT_MBX_CTL_MSIX_INDX_S		0
#define PFINT_MBX_CTL_MSIX_INDX_M		MAKEMASK(0x7FF, 0)
#define PFINT_MBX_CTL_ITR_INDX_S		11
#define PFINT_MBX_CTL_ITR_INDX_M		MAKEMASK(0x3, 11)
#define PFINT_MBX_CTL_CAUSE_ENA_S		30
#define PFINT_MBX_CTL_CAUSE_ENA_M		BIT(30)
#define PFINT_MBX_CTL_INTEVENT_S		31
#define PFINT_MBX_CTL_INTEVENT_M		BIT(31)
#define PFINT_OICR				0x0016CA00 /* Reset Source: CORER */
#define PFINT_OICR_INTEVENT_S			0
#define PFINT_OICR_INTEVENT_M			BIT(0)
#define PFINT_OICR_QUEUE_S			1
#define PFINT_OICR_QUEUE_M			BIT(1)
#define PFINT_OICR_RSV1_S			2
#define PFINT_OICR_RSV1_M			MAKEMASK(0xFF, 2)
#define PFINT_OICR_HH_COMP_S			10
#define PFINT_OICR_HH_COMP_M			BIT(10)
#define PFINT_OICR_TSYN_TX_S			11
#define PFINT_OICR_TSYN_TX_M			BIT(11)
#define PFINT_OICR_TSYN_EVNT_S			12
#define PFINT_OICR_TSYN_EVNT_M			BIT(12)
#define PFINT_OICR_TSYN_TGT_S			13
#define PFINT_OICR_TSYN_TGT_M			BIT(13)
#define PFINT_OICR_HLP_RDY_S			14
#define PFINT_OICR_HLP_RDY_M			BIT(14)
#define PFINT_OICR_CPM_RDY_S			15
#define PFINT_OICR_CPM_RDY_M			BIT(15)
#define PFINT_OICR_ECC_ERR_S			16
#define PFINT_OICR_ECC_ERR_M			BIT(16)
#define PFINT_OICR_RSV2_S			17
#define PFINT_OICR_RSV2_M			MAKEMASK(0x3, 17)
#define PFINT_OICR_MAL_DETECT_S			19
#define PFINT_OICR_MAL_DETECT_M			BIT(19)
#define PFINT_OICR_GRST_S			20
#define PFINT_OICR_GRST_M			BIT(20)
#define PFINT_OICR_PCI_EXCEPTION_S		21
#define PFINT_OICR_PCI_EXCEPTION_M		BIT(21)
#define PFINT_OICR_GPIO_S			22
#define PFINT_OICR_GPIO_M			BIT(22)
#define PFINT_OICR_RSV3_S			23
#define PFINT_OICR_RSV3_M			BIT(23)
#define PFINT_OICR_STORM_DETECT_S		24
#define PFINT_OICR_STORM_DETECT_M		BIT(24)
#define PFINT_OICR_LINK_STAT_CHANGE_S		25
#define PFINT_OICR_LINK_STAT_CHANGE_M		BIT(25)
#define PFINT_OICR_HMC_ERR_S			26
#define PFINT_OICR_HMC_ERR_M			BIT(26)
#define PFINT_OICR_PE_PUSH_S			27
#define PFINT_OICR_PE_PUSH_M			BIT(27)
#define PFINT_OICR_PE_CRITERR_S			28
#define PFINT_OICR_PE_CRITERR_M			BIT(28)
#define PFINT_OICR_VFLR_S			29
#define PFINT_OICR_VFLR_M			BIT(29)
#define PFINT_OICR_XLR_HW_DONE_S		30
#define PFINT_OICR_XLR_HW_DONE_M		BIT(30)
#define PFINT_OICR_SWINT_S			31
#define PFINT_OICR_SWINT_M			BIT(31)
#define PFINT_OICR_CTL				0x0016CA80 /* Reset Source: CORER */
#define PFINT_OICR_CTL_MSIX_INDX_S		0
#define PFINT_OICR_CTL_MSIX_INDX_M		MAKEMASK(0x7FF, 0)
#define PFINT_OICR_CTL_ITR_INDX_S		11
#define PFINT_OICR_CTL_ITR_INDX_M		MAKEMASK(0x3, 11)
#define PFINT_OICR_CTL_CAUSE_ENA_S		30
#define PFINT_OICR_CTL_CAUSE_ENA_M		BIT(30)
#define PFINT_OICR_CTL_INTEVENT_S		31
#define PFINT_OICR_CTL_INTEVENT_M		BIT(31)
#define PFINT_OICR_ENA				0x0016C900 /* Reset Source: CORER */
#define PFINT_OICR_ENA_RSV0_S			0
#define PFINT_OICR_ENA_RSV0_M			BIT(0)
#define PFINT_OICR_ENA_INT_ENA_S		1
#define PFINT_OICR_ENA_INT_ENA_M		MAKEMASK(0x7FFFFFFF, 1)
#define PFINT_SB_CTL				0x0016B600 /* Reset Source: CORER */
#define PFINT_SB_CTL_MSIX_INDX_S		0
#define PFINT_SB_CTL_MSIX_INDX_M		MAKEMASK(0x7FF, 0)
#define PFINT_SB_CTL_ITR_INDX_S			11
#define PFINT_SB_CTL_ITR_INDX_M			MAKEMASK(0x3, 11)
#define PFINT_SB_CTL_CAUSE_ENA_S		30
#define PFINT_SB_CTL_CAUSE_ENA_M		BIT(30)
#define PFINT_SB_CTL_INTEVENT_S			31
#define PFINT_SB_CTL_INTEVENT_M			BIT(31)
#define PFINT_TSYN_MSK				0x0016C980 /* Reset Source: CORER */
#define PFINT_TSYN_MSK_PHY_INDX_S		0
#define PFINT_TSYN_MSK_PHY_INDX_M		MAKEMASK(0x1F, 0)
#define QINT_RQCTL(_QRX)			(0x00150000 + ((_QRX) * 4)) /* _i=0...2047 */ /* Reset Source: CORER */
#define QINT_RQCTL_MAX_INDEX			2047
#define QINT_RQCTL_MSIX_INDX_S			0
#define QINT_RQCTL_MSIX_INDX_M			MAKEMASK(0x7FF, 0)
#define QINT_RQCTL_ITR_INDX_S			11
#define QINT_RQCTL_ITR_INDX_M			MAKEMASK(0x3, 11)
#define QINT_RQCTL_CAUSE_ENA_S			30
#define QINT_RQCTL_CAUSE_ENA_M			BIT(30)
#define QINT_RQCTL_INTEVENT_S			31
#define QINT_RQCTL_INTEVENT_M			BIT(31)
#define QINT_TQCTL(_DBQM)			(0x00140000 + ((_DBQM) * 4)) /* _i=0...16383 */ /* Reset Source: CORER */
#define QINT_TQCTL_MAX_INDEX			16383
#define QINT_TQCTL_MSIX_INDX_S			0
#define QINT_TQCTL_MSIX_INDX_M			MAKEMASK(0x7FF, 0)
#define QINT_TQCTL_ITR_INDX_S			11
#define QINT_TQCTL_ITR_INDX_M			MAKEMASK(0x3, 11)
#define QINT_TQCTL_CAUSE_ENA_S			30
#define QINT_TQCTL_CAUSE_ENA_M			BIT(30)
#define QINT_TQCTL_INTEVENT_S			31
#define QINT_TQCTL_INTEVENT_M			BIT(31)
#define VPINT_AEQCTL(_VF)			(0x0016B800 + ((_VF) * 4)) /* _i=0...255 */ /* Reset Source: CORER */
#define VPINT_AEQCTL_MAX_INDEX			255
#define VPINT_AEQCTL_MSIX_INDX_S		0
#define VPINT_AEQCTL_MSIX_INDX_M		MAKEMASK(0x7FF, 0)
#define VPINT_AEQCTL_ITR_INDX_S			11
#define VPINT_AEQCTL_ITR_INDX_M			MAKEMASK(0x3, 11)
#define VPINT_AEQCTL_CAUSE_ENA_S		30
#define VPINT_AEQCTL_CAUSE_ENA_M		BIT(30)
#define VPINT_AEQCTL_INTEVENT_S			31
#define VPINT_AEQCTL_INTEVENT_M			BIT(31)
#define VPINT_ALLOC(_VF)			(0x001D1000 + ((_VF) * 4)) /* _i=0...255 */ /* Reset Source: CORER */
#define VPINT_ALLOC_MAX_INDEX			255
#define VPINT_ALLOC_FIRST_S			0
#define VPINT_ALLOC_FIRST_M			MAKEMASK(0x7FF, 0)
#define VPINT_ALLOC_LAST_S			12
#define VPINT_ALLOC_LAST_M			MAKEMASK(0x7FF, 12)
#define VPINT_ALLOC_VALID_S			31
#define VPINT_ALLOC_VALID_M			BIT(31)
#define VPINT_ALLOC_PCI(_VF)			(0x0009D000 + ((_VF) * 4)) /* _i=0...255 */ /* Reset Source: PCIR */
#define VPINT_ALLOC_PCI_MAX_INDEX		255
#define VPINT_ALLOC_PCI_FIRST_S			0
#define VPINT_ALLOC_PCI_FIRST_M			MAKEMASK(0x7FF, 0)
#define VPINT_ALLOC_PCI_LAST_S			12
#define VPINT_ALLOC_PCI_LAST_M			MAKEMASK(0x7FF, 12)
#define VPINT_ALLOC_PCI_VALID_S			31
#define VPINT_ALLOC_PCI_VALID_M			BIT(31)
#define VPINT_MBX_CPM_CTL(_VP128)		(0x0016B000 + ((_VP128) * 4)) /* _i=0...127 */ /* Reset Source: CORER */
#define VPINT_MBX_CPM_CTL_MAX_INDEX		127
#define VPINT_MBX_CPM_CTL_MSIX_INDX_S		0
#define VPINT_MBX_CPM_CTL_MSIX_INDX_M		MAKEMASK(0x7FF, 0)
#define VPINT_MBX_CPM_CTL_ITR_INDX_S		11
#define VPINT_MBX_CPM_CTL_ITR_INDX_M		MAKEMASK(0x3, 11)
#define VPINT_MBX_CPM_CTL_CAUSE_ENA_S		30
#define VPINT_MBX_CPM_CTL_CAUSE_ENA_M		BIT(30)
#define VPINT_MBX_CPM_CTL_INTEVENT_S		31
#define VPINT_MBX_CPM_CTL_INTEVENT_M		BIT(31)
#define VPINT_MBX_CTL(_VSI)			(0x0016A000 + ((_VSI) * 4)) /* _i=0...767 */ /* Reset Source: CORER */
#define VPINT_MBX_CTL_MAX_INDEX			767
#define VPINT_MBX_CTL_MSIX_INDX_S		0
#define VPINT_MBX_CTL_MSIX_INDX_M		MAKEMASK(0x7FF, 0)
#define VPINT_MBX_CTL_ITR_INDX_S		11
#define VPINT_MBX_CTL_ITR_INDX_M		MAKEMASK(0x3, 11)
#define VPINT_MBX_CTL_CAUSE_ENA_S		30
#define VPINT_MBX_CTL_CAUSE_ENA_M		BIT(30)
#define VPINT_MBX_CTL_INTEVENT_S		31
#define VPINT_MBX_CTL_INTEVENT_M		BIT(31)
#define VPINT_MBX_HLP_CTL(_VP16)		(0x0016B200 + ((_VP16) * 4)) /* _i=0...15 */ /* Reset Source: CORER */
#define VPINT_MBX_HLP_CTL_MAX_INDEX		15
#define VPINT_MBX_HLP_CTL_MSIX_INDX_S		0
#define VPINT_MBX_HLP_CTL_MSIX_INDX_M		MAKEMASK(0x7FF, 0)
#define VPINT_MBX_HLP_CTL_ITR_INDX_S		11
#define VPINT_MBX_HLP_CTL_ITR_INDX_M		MAKEMASK(0x3, 11)
#define VPINT_MBX_HLP_CTL_CAUSE_ENA_S		30
#define VPINT_MBX_HLP_CTL_CAUSE_ENA_M		BIT(30)
#define VPINT_MBX_HLP_CTL_INTEVENT_S		31
#define VPINT_MBX_HLP_CTL_INTEVENT_M		BIT(31)
#define VPINT_MBX_PSM_CTL(_VP16)		(0x0016B240 + ((_VP16) * 4)) /* _i=0...15 */ /* Reset Source: CORER */
#define VPINT_MBX_PSM_CTL_MAX_INDEX		15
#define VPINT_MBX_PSM_CTL_MSIX_INDX_S		0
#define VPINT_MBX_PSM_CTL_MSIX_INDX_M		MAKEMASK(0x7FF, 0)
#define VPINT_MBX_PSM_CTL_ITR_INDX_S		11
#define VPINT_MBX_PSM_CTL_ITR_INDX_M		MAKEMASK(0x3, 11)
#define VPINT_MBX_PSM_CTL_CAUSE_ENA_S		30
#define VPINT_MBX_PSM_CTL_CAUSE_ENA_M		BIT(30)
#define VPINT_MBX_PSM_CTL_INTEVENT_S		31
#define VPINT_MBX_PSM_CTL_INTEVENT_M		BIT(31)
#define VPINT_SB_CPM_CTL(_VP128)		(0x0016B400 + ((_VP128) * 4)) /* _i=0...127 */ /* Reset Source: CORER */
#define VPINT_SB_CPM_CTL_MAX_INDEX		127
#define VPINT_SB_CPM_CTL_MSIX_INDX_S		0
#define VPINT_SB_CPM_CTL_MSIX_INDX_M		MAKEMASK(0x7FF, 0)
#define VPINT_SB_CPM_CTL_ITR_INDX_S		11
#define VPINT_SB_CPM_CTL_ITR_INDX_M		MAKEMASK(0x3, 11)
#define VPINT_SB_CPM_CTL_CAUSE_ENA_S		30
#define VPINT_SB_CPM_CTL_CAUSE_ENA_M		BIT(30)
#define VPINT_SB_CPM_CTL_INTEVENT_S		31
#define VPINT_SB_CPM_CTL_INTEVENT_M		BIT(31)
#define GL_HLP_PRT_IPG_PREAMBLE_SIZE(_i)	(0x00049240 + ((_i) * 4)) /* _i=0...20 */ /* Reset Source: CORER */
#define GL_HLP_PRT_IPG_PREAMBLE_SIZE_MAX_INDEX	20
#define GL_HLP_PRT_IPG_PREAMBLE_SIZE_IPG_PREAMBLE_SIZE_S 0
#define GL_HLP_PRT_IPG_PREAMBLE_SIZE_IPG_PREAMBLE_SIZE_M MAKEMASK(0xFF, 0)
#define GL_TDPU_PSM_DEFAULT_RECIPE(_i)		(0x00049294 + ((_i) * 4)) /* _i=0...3 */ /* Reset Source: CORER */
#define GL_TDPU_PSM_DEFAULT_RECIPE_MAX_INDEX	3
#define GL_TDPU_PSM_DEFAULT_RECIPE_ADD_IPG_S	0
#define GL_TDPU_PSM_DEFAULT_RECIPE_ADD_IPG_M	BIT(0)
#define GL_TDPU_PSM_DEFAULT_RECIPE_SUB_CRC_S	1
#define GL_TDPU_PSM_DEFAULT_RECIPE_SUB_CRC_M	BIT(1)
#define GL_TDPU_PSM_DEFAULT_RECIPE_SUB_ESP_TRAILER_S 2
#define GL_TDPU_PSM_DEFAULT_RECIPE_SUB_ESP_TRAILER_M BIT(2)
#define GL_TDPU_PSM_DEFAULT_RECIPE_INCLUDE_L2_PAD_S 3
#define GL_TDPU_PSM_DEFAULT_RECIPE_INCLUDE_L2_PAD_M BIT(3)
#define GL_TDPU_PSM_DEFAULT_RECIPE_DEFAULT_UPDATE_MODE_S 4
#define GL_TDPU_PSM_DEFAULT_RECIPE_DEFAULT_UPDATE_MODE_M BIT(4)
#define GLLAN_PF_RECIPE(_i)			(0x0029420C + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLLAN_PF_RECIPE_MAX_INDEX		7
#define GLLAN_PF_RECIPE_RECIPE_S		0
#define GLLAN_PF_RECIPE_RECIPE_M		MAKEMASK(0x3, 0)
#define GLLAN_RCTL_0				0x002941F8 /* Reset Source: CORER */
#define GLLAN_RCTL_0_PXE_MODE_S			0
#define GLLAN_RCTL_0_PXE_MODE_M			BIT(0)
#define GLLAN_RCTL_1				0x002941FC /* Reset Source: CORER */
#define GLLAN_RCTL_1_RXMAX_EXPANSION_S		12
#define GLLAN_RCTL_1_RXMAX_EXPANSION_M		MAKEMASK(0xF, 12)
#define GLLAN_RCTL_1_RXDRDCTL_S			17
#define GLLAN_RCTL_1_RXDRDCTL_M			BIT(17)
#define GLLAN_RCTL_1_RXDESCRDROEN_S		18
#define GLLAN_RCTL_1_RXDESCRDROEN_M		BIT(18)
#define GLLAN_RCTL_1_RXDATAWRROEN_S		19
#define GLLAN_RCTL_1_RXDATAWRROEN_M		BIT(19)
#define GLLAN_TSOMSK_F				0x00049308 /* Reset Source: CORER */
#define GLLAN_TSOMSK_F_TCPMSKF_S		0
#define GLLAN_TSOMSK_F_TCPMSKF_M		MAKEMASK(0xFFF, 0)
#define GLLAN_TSOMSK_L				0x00049310 /* Reset Source: CORER */
#define GLLAN_TSOMSK_L_TCPMSKL_S		0
#define GLLAN_TSOMSK_L_TCPMSKL_M		MAKEMASK(0xFFF, 0)
#define GLLAN_TSOMSK_M				0x0004930C /* Reset Source: CORER */
#define GLLAN_TSOMSK_M_TCPMSKM_S		0
#define GLLAN_TSOMSK_M_TCPMSKM_M		MAKEMASK(0xFFF, 0)
#define PFLAN_CP_QALLOC				0x00075700 /* Reset Source: CORER */
#define PFLAN_CP_QALLOC_FIRSTQ_S		0
#define PFLAN_CP_QALLOC_FIRSTQ_M		MAKEMASK(0x1FF, 0)
#define PFLAN_CP_QALLOC_LASTQ_S			16
#define PFLAN_CP_QALLOC_LASTQ_M			MAKEMASK(0x1FF, 16)
#define PFLAN_CP_QALLOC_VALID_S			31
#define PFLAN_CP_QALLOC_VALID_M			BIT(31)
#define PFLAN_DB_QALLOC				0x00075680 /* Reset Source: CORER */
#define PFLAN_DB_QALLOC_FIRSTQ_S		0
#define PFLAN_DB_QALLOC_FIRSTQ_M		MAKEMASK(0xFF, 0)
#define PFLAN_DB_QALLOC_LASTQ_S			16
#define PFLAN_DB_QALLOC_LASTQ_M			MAKEMASK(0xFF, 16)
#define PFLAN_DB_QALLOC_VALID_S			31
#define PFLAN_DB_QALLOC_VALID_M			BIT(31)
#define PFLAN_RX_QALLOC				0x001D2500 /* Reset Source: CORER */
#define PFLAN_RX_QALLOC_FIRSTQ_S		0
#define PFLAN_RX_QALLOC_FIRSTQ_M		MAKEMASK(0x7FF, 0)
#define PFLAN_RX_QALLOC_LASTQ_S			16
#define PFLAN_RX_QALLOC_LASTQ_M			MAKEMASK(0x7FF, 16)
#define PFLAN_RX_QALLOC_VALID_S			31
#define PFLAN_RX_QALLOC_VALID_M			BIT(31)
#define PFLAN_TX_QALLOC				0x001D2580 /* Reset Source: CORER */
#define PFLAN_TX_QALLOC_FIRSTQ_S		0
#define PFLAN_TX_QALLOC_FIRSTQ_M		MAKEMASK(0x3FFF, 0)
#define PFLAN_TX_QALLOC_LASTQ_S			16
#define PFLAN_TX_QALLOC_LASTQ_M			MAKEMASK(0x3FFF, 16)
#define PFLAN_TX_QALLOC_VALID_S			31
#define PFLAN_TX_QALLOC_VALID_M			BIT(31)
#define PRT_TDPUL2TAGSEN			0x00040BA0 /* Reset Source: CORER */
#define PRT_TDPUL2TAGSEN_ENABLE_S		0
#define PRT_TDPUL2TAGSEN_ENABLE_M		MAKEMASK(0xFF, 0)
#define PRT_TDPUL2TAGSEN_NONLAST_TAG_S		8
#define PRT_TDPUL2TAGSEN_NONLAST_TAG_M		MAKEMASK(0xFF, 8)
#define QRX_CONTEXT(_i, _QRX)			(0x00280000 + ((_i) * 8192 + (_QRX) * 4)) /* _i=0...7, _QRX=0...2047 */ /* Reset Source: CORER */
#define QRX_CONTEXT_MAX_INDEX			7
#define QRX_CONTEXT_RXQ_CONTEXT_S		0
#define QRX_CONTEXT_RXQ_CONTEXT_M		MAKEMASK(0xFFFFFFFF, 0)
#define QRX_CTRL(_QRX)				(0x00120000 + ((_QRX) * 4)) /* _i=0...2047 */ /* Reset Source: PFR */
#define QRX_CTRL_MAX_INDEX			2047
#define QRX_CTRL_QENA_REQ_S			0
#define QRX_CTRL_QENA_REQ_M			BIT(0)
#define QRX_CTRL_FAST_QDIS_S			1
#define QRX_CTRL_FAST_QDIS_M			BIT(1)
#define QRX_CTRL_QENA_STAT_S			2
#define QRX_CTRL_QENA_STAT_M			BIT(2)
#define QRX_CTRL_CDE_S				3
#define QRX_CTRL_CDE_M				BIT(3)
#define QRX_CTRL_CDS_S				4
#define QRX_CTRL_CDS_M				BIT(4)
#define QRX_ITR(_QRX)				(0x00292000 + ((_QRX) * 4)) /* _i=0...2047 */ /* Reset Source: CORER */
#define QRX_ITR_MAX_INDEX			2047
#define QRX_ITR_NO_EXPR_S			0
#define QRX_ITR_NO_EXPR_M			BIT(0)
#define QRX_TAIL(_QRX)				(0x00290000 + ((_QRX) * 4)) /* _i=0...2047 */ /* Reset Source: CORER */
#define QRX_TAIL_MAX_INDEX			2047
#define QRX_TAIL_TAIL_S				0
#define QRX_TAIL_TAIL_M				MAKEMASK(0x1FFF, 0)
#define VPDSI_RX_QTABLE(_i, _VP16)		(0x00074C00 + ((_i) * 64 + (_VP16) * 4)) /* _i=0...15, _VP16=0...15 */ /* Reset Source: CORER */
#define VPDSI_RX_QTABLE_MAX_INDEX		15
#define VPDSI_RX_QTABLE_PAGE_INDEX0_S		0
#define VPDSI_RX_QTABLE_PAGE_INDEX0_M		MAKEMASK(0x7F, 0)
#define VPDSI_RX_QTABLE_PAGE_INDEX1_S		8
#define VPDSI_RX_QTABLE_PAGE_INDEX1_M		MAKEMASK(0x7F, 8)
#define VPDSI_RX_QTABLE_PAGE_INDEX2_S		16
#define VPDSI_RX_QTABLE_PAGE_INDEX2_M		MAKEMASK(0x7F, 16)
#define VPDSI_RX_QTABLE_PAGE_INDEX3_S		24
#define VPDSI_RX_QTABLE_PAGE_INDEX3_M		MAKEMASK(0x7F, 24)
#define VPDSI_TX_QTABLE(_i, _VP16)		(0x001D2000 + ((_i) * 64 + (_VP16) * 4)) /* _i=0...15, _VP16=0...15 */ /* Reset Source: CORER */
#define VPDSI_TX_QTABLE_MAX_INDEX		15
#define VPDSI_TX_QTABLE_PAGE_INDEX0_S		0
#define VPDSI_TX_QTABLE_PAGE_INDEX0_M		MAKEMASK(0x7F, 0)
#define VPDSI_TX_QTABLE_PAGE_INDEX1_S		8
#define VPDSI_TX_QTABLE_PAGE_INDEX1_M		MAKEMASK(0x7F, 8)
#define VPDSI_TX_QTABLE_PAGE_INDEX2_S		16
#define VPDSI_TX_QTABLE_PAGE_INDEX2_M		MAKEMASK(0x7F, 16)
#define VPDSI_TX_QTABLE_PAGE_INDEX3_S		24
#define VPDSI_TX_QTABLE_PAGE_INDEX3_M		MAKEMASK(0x7F, 24)
#define VPLAN_DB_QTABLE(_i, _VF)		(0x00070000 + ((_i) * 2048 + (_VF) * 4)) /* _i=0...3, _VF=0...255 */ /* Reset Source: CORER */
#define VPLAN_DB_QTABLE_MAX_INDEX		3
#define VPLAN_DB_QTABLE_QINDEX_S		0
#define VPLAN_DB_QTABLE_QINDEX_M		MAKEMASK(0x1FF, 0)
#define VPLAN_DSI_VF_MODE(_VP16)		(0x002D2C00 + ((_VP16) * 4)) /* _i=0...15 */ /* Reset Source: CORER */
#define VPLAN_DSI_VF_MODE_MAX_INDEX		15
#define VPLAN_DSI_VF_MODE_LAN_DSI_VF_MODE_S	0
#define VPLAN_DSI_VF_MODE_LAN_DSI_VF_MODE_M	BIT(0)
#define VPLAN_RX_QBASE(_VF)			(0x00072000 + ((_VF) * 4)) /* _i=0...255 */ /* Reset Source: CORER */
#define VPLAN_RX_QBASE_MAX_INDEX		255
#define VPLAN_RX_QBASE_VFFIRSTQ_S		0
#define VPLAN_RX_QBASE_VFFIRSTQ_M		MAKEMASK(0x7FF, 0)
#define VPLAN_RX_QBASE_VFNUMQ_S			16
#define VPLAN_RX_QBASE_VFNUMQ_M			MAKEMASK(0xFF, 16)
#define VPLAN_RX_QBASE_VFQTABLE_ENA_S		31
#define VPLAN_RX_QBASE_VFQTABLE_ENA_M		BIT(31)
#define VPLAN_RX_QTABLE(_i, _VF)		(0x00060000 + ((_i) * 2048 + (_VF) * 4)) /* _i=0...15, _VF=0...255 */ /* Reset Source: CORER */
#define VPLAN_RX_QTABLE_MAX_INDEX		15
#define VPLAN_RX_QTABLE_QINDEX_S		0
#define VPLAN_RX_QTABLE_QINDEX_M		MAKEMASK(0xFFF, 0)
#define VPLAN_RXQ_MAPENA(_VF)			(0x00073000 + ((_VF) * 4)) /* _i=0...255 */ /* Reset Source: CORER */
#define VPLAN_RXQ_MAPENA_MAX_INDEX		255
#define VPLAN_RXQ_MAPENA_RX_ENA_S		0
#define VPLAN_RXQ_MAPENA_RX_ENA_M		BIT(0)
#define VPLAN_TX_QBASE(_VF)			(0x001D1800 + ((_VF) * 4)) /* _i=0...255 */ /* Reset Source: CORER */
#define VPLAN_TX_QBASE_MAX_INDEX		255
#define VPLAN_TX_QBASE_VFFIRSTQ_S		0
#define VPLAN_TX_QBASE_VFFIRSTQ_M		MAKEMASK(0x3FFF, 0)
#define VPLAN_TX_QBASE_VFNUMQ_S			16
#define VPLAN_TX_QBASE_VFNUMQ_M			MAKEMASK(0xFF, 16)
#define VPLAN_TX_QBASE_VFQTABLE_ENA_S		31
#define VPLAN_TX_QBASE_VFQTABLE_ENA_M		BIT(31)
#define VPLAN_TX_QTABLE(_i, _VF)		(0x001C0000 + ((_i) * 2048 + (_VF) * 4)) /* _i=0...15, _VF=0...255 */ /* Reset Source: CORER */
#define VPLAN_TX_QTABLE_MAX_INDEX		15
#define VPLAN_TX_QTABLE_QINDEX_S		0
#define VPLAN_TX_QTABLE_QINDEX_M		MAKEMASK(0x7FFF, 0)
#define VPLAN_TXQ_MAPENA(_VF)			(0x00073800 + ((_VF) * 4)) /* _i=0...255 */ /* Reset Source: CORER */
#define VPLAN_TXQ_MAPENA_MAX_INDEX		255
#define VPLAN_TXQ_MAPENA_TX_ENA_S		0
#define VPLAN_TXQ_MAPENA_TX_ENA_M		BIT(0)
#define VSILAN_QBASE(_VSI)			(0x0044C000 + ((_VSI) * 4)) /* _i=0...767 */ /* Reset Source: PFR */
#define VSILAN_QBASE_MAX_INDEX			767
#define VSILAN_QBASE_VSIBASE_S			0
#define VSILAN_QBASE_VSIBASE_M			MAKEMASK(0x7FF, 0)
#define VSILAN_QBASE_VSIQTABLE_ENA_S		11
#define VSILAN_QBASE_VSIQTABLE_ENA_M		BIT(11)
#define VSILAN_QTABLE(_i, _VSI)			(0x00440000 + ((_i) * 4096 + (_VSI) * 4)) /* _i=0...7, _VSI=0...767 */ /* Reset Source: PFR */
#define VSILAN_QTABLE_MAX_INDEX			7
#define VSILAN_QTABLE_QINDEX_0_S		0
#define VSILAN_QTABLE_QINDEX_0_M		MAKEMASK(0x7FF, 0)
#define VSILAN_QTABLE_QINDEX_1_S		16
#define VSILAN_QTABLE_QINDEX_1_M		MAKEMASK(0x7FF, 16)
#define PRTMAC_HSEC_CTL_RX_ENABLE_GCP		0x001E31C0 /* Reset Source: GLOBR */
#define PRTMAC_HSEC_CTL_RX_ENABLE_GCP_HSEC_CTL_RX_ENABLE_GCP_S 0
#define PRTMAC_HSEC_CTL_RX_ENABLE_GCP_HSEC_CTL_RX_ENABLE_GCP_M BIT(0)
#define PRTMAC_HSEC_CTL_RX_ENABLE_GPP		0x001E34C0 /* Reset Source: GLOBR */
#define PRTMAC_HSEC_CTL_RX_ENABLE_GPP_HSEC_CTL_RX_ENABLE_GPP_S 0
#define PRTMAC_HSEC_CTL_RX_ENABLE_GPP_HSEC_CTL_RX_ENABLE_GPP_M BIT(0)
#define PRTMAC_HSEC_CTL_RX_ENABLE_PPP		0x001E35C0 /* Reset Source: GLOBR */
#define PRTMAC_HSEC_CTL_RX_ENABLE_PPP_HSEC_CTL_RX_ENABLE_PPP_S 0
#define PRTMAC_HSEC_CTL_RX_ENABLE_PPP_HSEC_CTL_RX_ENABLE_PPP_M BIT(0)
#define PRTMAC_HSEC_CTL_RX_FORWARD_CONTROL	0x001E36C0 /* Reset Source: GLOBR */
#define PRTMAC_HSEC_CTL_RX_FORWARD_CONTROL_HSEC_CTL_RX_FORWARD_CONTROL_S 0
#define PRTMAC_HSEC_CTL_RX_FORWARD_CONTROL_HSEC_CTL_RX_FORWARD_CONTROL_M BIT(0)
#define PRTMAC_HSEC_CTL_RX_PAUSE_DA_UCAST_PART1 0x001E3220 /* Reset Source: GLOBR */
#define PRTMAC_HSEC_CTL_RX_PAUSE_DA_UCAST_PART1_HSEC_CTL_RX_PAUSE_DA_UCAST_PART1_S 0
#define PRTMAC_HSEC_CTL_RX_PAUSE_DA_UCAST_PART1_HSEC_CTL_RX_PAUSE_DA_UCAST_PART1_M MAKEMASK(0xFFFFFFFF, 0)
#define PRTMAC_HSEC_CTL_RX_PAUSE_DA_UCAST_PART2 0x001E3240 /* Reset Source: GLOBR */
#define PRTMAC_HSEC_CTL_RX_PAUSE_DA_UCAST_PART2_HSEC_CTL_RX_PAUSE_DA_UCAST_PART2_S 0
#define PRTMAC_HSEC_CTL_RX_PAUSE_DA_UCAST_PART2_HSEC_CTL_RX_PAUSE_DA_UCAST_PART2_M MAKEMASK(0xFFFF, 0)
#define PRTMAC_HSEC_CTL_RX_PAUSE_ENABLE		0x001E3180 /* Reset Source: GLOBR */
#define PRTMAC_HSEC_CTL_RX_PAUSE_ENABLE_HSEC_CTL_RX_PAUSE_ENABLE_S 0
#define PRTMAC_HSEC_CTL_RX_PAUSE_ENABLE_HSEC_CTL_RX_PAUSE_ENABLE_M MAKEMASK(0x1FF, 0)
#define PRTMAC_HSEC_CTL_RX_PAUSE_SA_PART1	0x001E3280 /* Reset Source: GLOBR */
#define PRTMAC_HSEC_CTL_RX_PAUSE_SA_PART1_HSEC_CTL_RX_PAUSE_SA_PART1_S 0
#define PRTMAC_HSEC_CTL_RX_PAUSE_SA_PART1_HSEC_CTL_RX_PAUSE_SA_PART1_M MAKEMASK(0xFFFFFFFF, 0)
#define PRTMAC_HSEC_CTL_RX_PAUSE_SA_PART2	0x001E32A0 /* Reset Source: GLOBR */
#define PRTMAC_HSEC_CTL_RX_PAUSE_SA_PART2_HSEC_CTL_RX_PAUSE_SA_PART2_S 0
#define PRTMAC_HSEC_CTL_RX_PAUSE_SA_PART2_HSEC_CTL_RX_PAUSE_SA_PART2_M MAKEMASK(0xFFFF, 0)
#define PRTMAC_HSEC_CTL_RX_QUANTA_S		0x001E3C40 /* Reset Source: GLOBR */
#define PRTMAC_HSEC_CTL_RX_QUANTA_SHIFT_PRTMAC_HSEC_CTL_RX_QUANTA_SHIFT_S 0
#define PRTMAC_HSEC_CTL_RX_QUANTA_SHIFT_PRTMAC_HSEC_CTL_RX_QUANTA_SHIFT_M MAKEMASK(0xFFFF, 0)
#define PRTMAC_HSEC_CTL_TX_PAUSE_ENABLE		0x001E31A0 /* Reset Source: GLOBR */
#define PRTMAC_HSEC_CTL_TX_PAUSE_ENABLE_HSEC_CTL_TX_PAUSE_ENABLE_S 0
#define PRTMAC_HSEC_CTL_TX_PAUSE_ENABLE_HSEC_CTL_TX_PAUSE_ENABLE_M MAKEMASK(0x1FF, 0)
#define PRTMAC_HSEC_CTL_TX_PAUSE_QUANTA(_i)	(0x001E36E0 + ((_i) * 32)) /* _i=0...8 */ /* Reset Source: GLOBR */
#define PRTMAC_HSEC_CTL_TX_PAUSE_QUANTA_MAX_INDEX 8
#define PRTMAC_HSEC_CTL_TX_PAUSE_QUANTA_HSEC_CTL_TX_PAUSE_QUANTA_S 0
#define PRTMAC_HSEC_CTL_TX_PAUSE_QUANTA_HSEC_CTL_TX_PAUSE_QUANTA_M MAKEMASK(0xFFFF, 0)
#define PRTMAC_HSEC_CTL_TX_PAUSE_REFRESH_TIMER(_i) (0x001E3800 + ((_i) * 32)) /* _i=0...8 */ /* Reset Source: GLOBR */
#define PRTMAC_HSEC_CTL_TX_PAUSE_REFRESH_TIMER_MAX_INDEX 8
#define PRTMAC_HSEC_CTL_TX_PAUSE_REFRESH_TIMER_S 0
#define PRTMAC_HSEC_CTL_TX_PAUSE_REFRESH_TIMER_M MAKEMASK(0xFFFF, 0)
#define PRTMAC_HSEC_CTL_TX_SA_PART1		0x001E3960 /* Reset Source: GLOBR */
#define PRTMAC_HSEC_CTL_TX_SA_PART1_HSEC_CTL_TX_SA_PART1_S 0
#define PRTMAC_HSEC_CTL_TX_SA_PART1_HSEC_CTL_TX_SA_PART1_M MAKEMASK(0xFFFFFFFF, 0)
#define PRTMAC_HSEC_CTL_TX_SA_PART2		0x001E3980 /* Reset Source: GLOBR */
#define PRTMAC_HSEC_CTL_TX_SA_PART2_HSEC_CTL_TX_SA_PART2_S 0
#define PRTMAC_HSEC_CTL_TX_SA_PART2_HSEC_CTL_TX_SA_PART2_M MAKEMASK(0xFFFF, 0)
#define PRTMAC_LINK_DOWN_COUNTER		0x001E47C0 /* Reset Source: GLOBR */
#define PRTMAC_LINK_DOWN_COUNTER_LINK_DOWN_COUNTER_S 0
#define PRTMAC_LINK_DOWN_COUNTER_LINK_DOWN_COUNTER_M MAKEMASK(0xFFFF, 0)
#define PRTMAC_MD_OVRRIDE_ENABLE(_i)		(0x001E3C60 + ((_i) * 32)) /* _i=0...7 */ /* Reset Source: GLOBR */
#define PRTMAC_MD_OVRRIDE_ENABLE_MAX_INDEX	7
#define PRTMAC_MD_OVRRIDE_ENABLE_PRTMAC_MD_OVRRIDE_ENABLE_S 0
#define PRTMAC_MD_OVRRIDE_ENABLE_PRTMAC_MD_OVRRIDE_ENABLE_M MAKEMASK(0xFFFFFFFF, 0)
#define PRTMAC_MD_OVRRIDE_VAL(_i)		(0x001E3D60 + ((_i) * 32)) /* _i=0...7 */ /* Reset Source: GLOBR */
#define PRTMAC_MD_OVRRIDE_VAL_MAX_INDEX		7
#define PRTMAC_MD_OVRRIDE_VAL_PRTMAC_MD_OVRRIDE_ENABLE_S 0
#define PRTMAC_MD_OVRRIDE_VAL_PRTMAC_MD_OVRRIDE_ENABLE_M MAKEMASK(0xFFFFFFFF, 0)
#define PRTMAC_RX_CNT_MRKR			0x001E48E0 /* Reset Source: GLOBR */
#define PRTMAC_RX_CNT_MRKR_RX_CNT_MRKR_S	0
#define PRTMAC_RX_CNT_MRKR_RX_CNT_MRKR_M	MAKEMASK(0xFFFF, 0)
#define PRTMAC_RX_PKT_DRP_CNT			0x001E3C20 /* Reset Source: GLOBR */
#define PRTMAC_RX_PKT_DRP_CNT_RX_PKT_DRP_CNT_S	0
#define PRTMAC_RX_PKT_DRP_CNT_RX_PKT_DRP_CNT_M	MAKEMASK(0xFFFF, 0)
#define PRTMAC_RX_PKT_DRP_CNT_RX_MKR_PKT_DRP_CNT_S 16
#define PRTMAC_RX_PKT_DRP_CNT_RX_MKR_PKT_DRP_CNT_M MAKEMASK(0xFFFF, 16)
#define PRTMAC_TX_CNT_MRKR			0x001E48C0 /* Reset Source: GLOBR */
#define PRTMAC_TX_CNT_MRKR_TX_CNT_MRKR_S	0
#define PRTMAC_TX_CNT_MRKR_TX_CNT_MRKR_M	MAKEMASK(0xFFFF, 0)
#define PRTMAC_TX_LNK_UP_CNT			0x001E4840 /* Reset Source: GLOBR */
#define PRTMAC_TX_LNK_UP_CNT_TX_LINK_UP_CNT_S	0
#define PRTMAC_TX_LNK_UP_CNT_TX_LINK_UP_CNT_M	MAKEMASK(0xFFFF, 0)
#define GL_MDCK_CFG1_TX_PQM			0x002D2DF4 /* Reset Source: CORER */
#define GL_MDCK_CFG1_TX_PQM_SSO_MAX_DATA_LEN_S	0
#define GL_MDCK_CFG1_TX_PQM_SSO_MAX_DATA_LEN_M	MAKEMASK(0xFF, 0)
#define GL_MDCK_CFG1_TX_PQM_SSO_MAX_PKT_CNT_S	8
#define GL_MDCK_CFG1_TX_PQM_SSO_MAX_PKT_CNT_M	MAKEMASK(0x3F, 8)
#define GL_MDCK_CFG1_TX_PQM_SSO_MAX_DESC_CNT_S	16
#define GL_MDCK_CFG1_TX_PQM_SSO_MAX_DESC_CNT_M	MAKEMASK(0x3F, 16)
#define GL_MDCK_EN_TX_PQM			0x002D2DFC /* Reset Source: CORER */
#define GL_MDCK_EN_TX_PQM_PCI_DUMMY_COMP_S	0
#define GL_MDCK_EN_TX_PQM_PCI_DUMMY_COMP_M	BIT(0)
#define GL_MDCK_EN_TX_PQM_PCI_UR_COMP_S		1
#define GL_MDCK_EN_TX_PQM_PCI_UR_COMP_M		BIT(1)
#define GL_MDCK_EN_TX_PQM_RCV_SH_BE_LSO_S	3
#define GL_MDCK_EN_TX_PQM_RCV_SH_BE_LSO_M	BIT(3)
#define GL_MDCK_EN_TX_PQM_Q_FL_MNG_EPY_CH_S	4
#define GL_MDCK_EN_TX_PQM_Q_FL_MNG_EPY_CH_M	BIT(4)
#define GL_MDCK_EN_TX_PQM_Q_EPY_MNG_FL_CH_S	5
#define GL_MDCK_EN_TX_PQM_Q_EPY_MNG_FL_CH_M	BIT(5)
#define GL_MDCK_EN_TX_PQM_LSO_NUMDESCS_ZERO_S	6
#define GL_MDCK_EN_TX_PQM_LSO_NUMDESCS_ZERO_M	BIT(6)
#define GL_MDCK_EN_TX_PQM_LSO_LENGTH_ZERO_S	7
#define GL_MDCK_EN_TX_PQM_LSO_LENGTH_ZERO_M	BIT(7)
#define GL_MDCK_EN_TX_PQM_LSO_MSS_BELOW_MIN_S	8
#define GL_MDCK_EN_TX_PQM_LSO_MSS_BELOW_MIN_M	BIT(8)
#define GL_MDCK_EN_TX_PQM_LSO_MSS_ABOVE_MAX_S	9
#define GL_MDCK_EN_TX_PQM_LSO_MSS_ABOVE_MAX_M	BIT(9)
#define GL_MDCK_EN_TX_PQM_LSO_HDR_SIZE_ZERO_S	10
#define GL_MDCK_EN_TX_PQM_LSO_HDR_SIZE_ZERO_M	BIT(10)
#define GL_MDCK_EN_TX_PQM_RCV_CNT_BE_LSO_S	11
#define GL_MDCK_EN_TX_PQM_RCV_CNT_BE_LSO_M	BIT(11)
#define GL_MDCK_EN_TX_PQM_SKIP_ONE_QT_ONLY_S	12
#define GL_MDCK_EN_TX_PQM_SKIP_ONE_QT_ONLY_M	BIT(12)
#define GL_MDCK_EN_TX_PQM_LSO_PKTCNT_ZERO_S	13
#define GL_MDCK_EN_TX_PQM_LSO_PKTCNT_ZERO_M	BIT(13)
#define GL_MDCK_EN_TX_PQM_SSO_LENGTH_ZERO_S	14
#define GL_MDCK_EN_TX_PQM_SSO_LENGTH_ZERO_M	BIT(14)
#define GL_MDCK_EN_TX_PQM_SSO_LENGTH_EXCEED_S	15
#define GL_MDCK_EN_TX_PQM_SSO_LENGTH_EXCEED_M	BIT(15)
#define GL_MDCK_EN_TX_PQM_SSO_PKTCNT_ZERO_S	16
#define GL_MDCK_EN_TX_PQM_SSO_PKTCNT_ZERO_M	BIT(16)
#define GL_MDCK_EN_TX_PQM_SSO_PKTCNT_EXCEED_S	17
#define GL_MDCK_EN_TX_PQM_SSO_PKTCNT_EXCEED_M	BIT(17)
#define GL_MDCK_EN_TX_PQM_SSO_NUMDESCS_ZERO_S	18
#define GL_MDCK_EN_TX_PQM_SSO_NUMDESCS_ZERO_M	BIT(18)
#define GL_MDCK_EN_TX_PQM_SSO_NUMDESCS_EXCEED_S 19
#define GL_MDCK_EN_TX_PQM_SSO_NUMDESCS_EXCEED_M BIT(19)
#define GL_MDCK_EN_TX_PQM_TAIL_GT_RING_LENGTH_S 20
#define GL_MDCK_EN_TX_PQM_TAIL_GT_RING_LENGTH_M BIT(20)
#define GL_MDCK_EN_TX_PQM_RESERVED_DBL_TYPE_S	21
#define GL_MDCK_EN_TX_PQM_RESERVED_DBL_TYPE_M	BIT(21)
#define GL_MDCK_EN_TX_PQM_ILLEGAL_HEAD_DROP_DBL_S 22
#define GL_MDCK_EN_TX_PQM_ILLEGAL_HEAD_DROP_DBL_M BIT(22)
#define GL_MDCK_EN_TX_PQM_LSO_OVER_COMMS_Q_S	23
#define GL_MDCK_EN_TX_PQM_LSO_OVER_COMMS_Q_M	BIT(23)
#define GL_MDCK_EN_TX_PQM_ILLEGAL_VF_QNUM_S	24
#define GL_MDCK_EN_TX_PQM_ILLEGAL_VF_QNUM_M	BIT(24)
#define GL_MDCK_EN_TX_PQM_QTAIL_GT_RING_LENGTH_S 25
#define GL_MDCK_EN_TX_PQM_QTAIL_GT_RING_LENGTH_M BIT(25)
#define GL_MDCK_EN_TX_PQM_RSVD_S		26
#define GL_MDCK_EN_TX_PQM_RSVD_M		MAKEMASK(0x3F, 26)
#define GL_MDCK_RX				0x0029422C /* Reset Source: CORER */
#define GL_MDCK_RX_DESC_ADDR_S			0
#define GL_MDCK_RX_DESC_ADDR_M			BIT(0)
#define GL_MDCK_TX_TDPU				0x00049348 /* Reset Source: CORER */
#define GL_MDCK_TX_TDPU_TTL_ERR_ITR_DIS_S	0
#define GL_MDCK_TX_TDPU_TTL_ERR_ITR_DIS_M	BIT(0)
#define GL_MDCK_TX_TDPU_RCU_ANTISPOOF_ITR_DIS_S 1
#define GL_MDCK_TX_TDPU_RCU_ANTISPOOF_ITR_DIS_M BIT(1)
#define GL_MDCK_TX_TDPU_PCIE_UR_ITR_DIS_S	2
#define GL_MDCK_TX_TDPU_PCIE_UR_ITR_DIS_M	BIT(2)
#define GL_MDCK_TX_TDPU_MAL_OFFSET_ITR_DIS_S	3
#define GL_MDCK_TX_TDPU_MAL_OFFSET_ITR_DIS_M	BIT(3)
#define GL_MDCK_TX_TDPU_MAL_CMD_ITR_DIS_S	4
#define GL_MDCK_TX_TDPU_MAL_CMD_ITR_DIS_M	BIT(4)
#define GL_MDCK_TX_TDPU_BIG_PKT_SIZE_ITR_DIS_S	5
#define GL_MDCK_TX_TDPU_BIG_PKT_SIZE_ITR_DIS_M	BIT(5)
#define GL_MDCK_TX_TDPU_L2_ACCEPT_FAIL_ITR_DIS_S 6
#define GL_MDCK_TX_TDPU_L2_ACCEPT_FAIL_ITR_DIS_M BIT(6)
#define GL_MDCK_TX_TDPU_NIC_DSI_ITR_DIS_S	7
#define GL_MDCK_TX_TDPU_NIC_DSI_ITR_DIS_M	BIT(7)
#define GL_MDCK_TX_TDPU_MAL_IPSEC_CMD_ITR_DIS_S 8
#define GL_MDCK_TX_TDPU_MAL_IPSEC_CMD_ITR_DIS_M BIT(8)
#define GL_MDCK_TX_TDPU_DSCP_CHECK_FAIL_ITR_DIS_S 9
#define GL_MDCK_TX_TDPU_DSCP_CHECK_FAIL_ITR_DIS_M BIT(9)
#define GL_MDCK_TX_TDPU_NIC_IPSEC_ITR_DIS_S	10
#define GL_MDCK_TX_TDPU_NIC_IPSEC_ITR_DIS_M	BIT(10)
#define GL_MDET_RX				0x00294C00 /* Reset Source: CORER */
#define GL_MDET_RX_QNUM_S			0
#define GL_MDET_RX_QNUM_M			MAKEMASK(0x7FFF, 0)
#define GL_MDET_RX_VF_NUM_S			15
#define GL_MDET_RX_VF_NUM_M			MAKEMASK(0xFF, 15)
#define GL_MDET_RX_PF_NUM_S			23
#define GL_MDET_RX_PF_NUM_M			MAKEMASK(0x7, 23)
#define GL_MDET_RX_MAL_TYPE_S			26
#define GL_MDET_RX_MAL_TYPE_M			MAKEMASK(0x1F, 26)
#define GL_MDET_RX_VALID_S			31
#define GL_MDET_RX_VALID_M			BIT(31)
#define GL_MDET_TX_PQM				0x002D2E00 /* Reset Source: CORER */
#define GL_MDET_TX_PQM_PF_NUM_S			0
#define GL_MDET_TX_PQM_PF_NUM_M			MAKEMASK(0x7, 0)
#define GL_MDET_TX_PQM_VF_NUM_S			4
#define GL_MDET_TX_PQM_VF_NUM_M			MAKEMASK(0xFF, 4)
#define GL_MDET_TX_PQM_QNUM_S			12
#define GL_MDET_TX_PQM_QNUM_M			MAKEMASK(0x3FFF, 12)
#define GL_MDET_TX_PQM_MAL_TYPE_S		26
#define GL_MDET_TX_PQM_MAL_TYPE_M		MAKEMASK(0x1F, 26)
#define GL_MDET_TX_PQM_VALID_S			31
#define GL_MDET_TX_PQM_VALID_M			BIT(31)
#define GL_MDET_TX_TCLAN			0x000FC068 /* Reset Source: CORER */
#define GL_MDET_TX_TCLAN_QNUM_S			0
#define GL_MDET_TX_TCLAN_QNUM_M			MAKEMASK(0x7FFF, 0)
#define GL_MDET_TX_TCLAN_VF_NUM_S		15
#define GL_MDET_TX_TCLAN_VF_NUM_M		MAKEMASK(0xFF, 15)
#define GL_MDET_TX_TCLAN_PF_NUM_S		23
#define GL_MDET_TX_TCLAN_PF_NUM_M		MAKEMASK(0x7, 23)
#define GL_MDET_TX_TCLAN_MAL_TYPE_S		26
#define GL_MDET_TX_TCLAN_MAL_TYPE_M		MAKEMASK(0x1F, 26)
#define GL_MDET_TX_TCLAN_VALID_S		31
#define GL_MDET_TX_TCLAN_VALID_M		BIT(31)
#define GL_MDET_TX_TDPU				0x00049350 /* Reset Source: CORER */
#define GL_MDET_TX_TDPU_QNUM_S			0
#define GL_MDET_TX_TDPU_QNUM_M			MAKEMASK(0x7FFF, 0)
#define GL_MDET_TX_TDPU_VF_NUM_S		15
#define GL_MDET_TX_TDPU_VF_NUM_M		MAKEMASK(0xFF, 15)
#define GL_MDET_TX_TDPU_PF_NUM_S		23
#define GL_MDET_TX_TDPU_PF_NUM_M		MAKEMASK(0x7, 23)
#define GL_MDET_TX_TDPU_MAL_TYPE_S		26
#define GL_MDET_TX_TDPU_MAL_TYPE_M		MAKEMASK(0x1F, 26)
#define GL_MDET_TX_TDPU_VALID_S			31
#define GL_MDET_TX_TDPU_VALID_M			BIT(31)
#define GLRLAN_MDET				0x00294200 /* Reset Source: CORER */
#define GLRLAN_MDET_PCKT_EXTRCT_ERR_S		0
#define GLRLAN_MDET_PCKT_EXTRCT_ERR_M		BIT(0)
#define PF_MDET_RX				0x00294280 /* Reset Source: CORER */
#define PF_MDET_RX_VALID_S			0
#define PF_MDET_RX_VALID_M			BIT(0)
#define PF_MDET_TX_PQM				0x002D2C80 /* Reset Source: CORER */
#define PF_MDET_TX_PQM_VALID_S			0
#define PF_MDET_TX_PQM_VALID_M			BIT(0)
#define PF_MDET_TX_TCLAN			0x000FC000 /* Reset Source: CORER */
#define PF_MDET_TX_TCLAN_VALID_S		0
#define PF_MDET_TX_TCLAN_VALID_M		BIT(0)
#define PF_MDET_TX_TDPU				0x00040800 /* Reset Source: CORER */
#define PF_MDET_TX_TDPU_VALID_S			0
#define PF_MDET_TX_TDPU_VALID_M			BIT(0)
#define VP_MDET_RX(_VF)				(0x00294400 + ((_VF) * 4)) /* _i=0...255 */ /* Reset Source: CORER */
#define VP_MDET_RX_MAX_INDEX			255
#define VP_MDET_RX_VALID_S			0
#define VP_MDET_RX_VALID_M			BIT(0)
#define VP_MDET_TX_PQM(_VF)			(0x002D2000 + ((_VF) * 4)) /* _i=0...255 */ /* Reset Source: CORER */
#define VP_MDET_TX_PQM_MAX_INDEX		255
#define VP_MDET_TX_PQM_VALID_S			0
#define VP_MDET_TX_PQM_VALID_M			BIT(0)
#define VP_MDET_TX_TCLAN(_VF)			(0x000FB800 + ((_VF) * 4)) /* _i=0...255 */ /* Reset Source: CORER */
#define VP_MDET_TX_TCLAN_MAX_INDEX		255
#define VP_MDET_TX_TCLAN_VALID_S		0
#define VP_MDET_TX_TCLAN_VALID_M		BIT(0)
#define VP_MDET_TX_TDPU(_VF)			(0x00040000 + ((_VF) * 4)) /* _i=0...255 */ /* Reset Source: CORER */
#define VP_MDET_TX_TDPU_MAX_INDEX		255
#define VP_MDET_TX_TDPU_VALID_S			0
#define VP_MDET_TX_TDPU_VALID_M			BIT(0)
#define GENERAL_MNG_FW_DBG_CSR(_i)		(0x000B6180 + ((_i) * 4)) /* _i=0...9 */ /* Reset Source: POR */
#define GENERAL_MNG_FW_DBG_CSR_MAX_INDEX	9
#define GENERAL_MNG_FW_DBG_CSR_GENERAL_FW_DBG_S 0
#define GENERAL_MNG_FW_DBG_CSR_GENERAL_FW_DBG_M MAKEMASK(0xFFFFFFFF, 0)
#define GL_FWRESETCNT				0x00083100 /* Reset Source: POR */
#define GL_FWRESETCNT_FWRESETCNT_S		0
#define GL_FWRESETCNT_FWRESETCNT_M		MAKEMASK(0xFFFFFFFF, 0)
#define GL_MNG_FW_RAM_STAT			0x0008309C /* Reset Source: POR */
#define GL_MNG_FW_RAM_STAT_FW_RAM_RST_STAT_S	0
#define GL_MNG_FW_RAM_STAT_FW_RAM_RST_STAT_M	BIT(0)
#define GL_MNG_FW_RAM_STAT_MNG_MEM_ECC_ERR_S	1
#define GL_MNG_FW_RAM_STAT_MNG_MEM_ECC_ERR_M	BIT(1)
#define GL_MNG_FWSM				0x000B6134 /* Reset Source: POR */
#define GL_MNG_FWSM_FW_MODES_S			0
#define GL_MNG_FWSM_FW_MODES_M			MAKEMASK(0x7, 0)
#define GL_MNG_FWSM_RSV0_S			3
#define GL_MNG_FWSM_RSV0_M			MAKEMASK(0x7F, 3)
#define GL_MNG_FWSM_EEP_RELOAD_IND_S		10
#define GL_MNG_FWSM_EEP_RELOAD_IND_M		BIT(10)
#define GL_MNG_FWSM_RSV1_S			11
#define GL_MNG_FWSM_RSV1_M			MAKEMASK(0xF, 11)
#define GL_MNG_FWSM_RSV2_S			15
#define GL_MNG_FWSM_RSV2_M			BIT(15)
#define GL_MNG_FWSM_PCIR_AL_FAILURE_S		16
#define GL_MNG_FWSM_PCIR_AL_FAILURE_M		BIT(16)
#define GL_MNG_FWSM_POR_AL_FAILURE_S		17
#define GL_MNG_FWSM_POR_AL_FAILURE_M		BIT(17)
#define GL_MNG_FWSM_RSV3_S			18
#define GL_MNG_FWSM_RSV3_M			BIT(18)
#define GL_MNG_FWSM_EXT_ERR_IND_S		19
#define GL_MNG_FWSM_EXT_ERR_IND_M		MAKEMASK(0x3F, 19)
#define GL_MNG_FWSM_RSV4_S			25
#define GL_MNG_FWSM_RSV4_M			BIT(25)
#define GL_MNG_FWSM_RESERVED_11_S		26
#define GL_MNG_FWSM_RESERVED_11_M		MAKEMASK(0xF, 26)
#define GL_MNG_FWSM_RSV5_S			30
#define GL_MNG_FWSM_RSV5_M			MAKEMASK(0x3, 30)
#define GL_MNG_HWARB_CTRL			0x000B6130 /* Reset Source: POR */
#define GL_MNG_HWARB_CTRL_NCSI_ARB_EN_S		0
#define GL_MNG_HWARB_CTRL_NCSI_ARB_EN_M		BIT(0)
#define GL_MNG_SHA_EXTEND(_i)			(0x00083120 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: EMPR */
#define GL_MNG_SHA_EXTEND_MAX_INDEX		7
#define GL_MNG_SHA_EXTEND_GL_MNG_SHA_EXTEND_S	0
#define GL_MNG_SHA_EXTEND_GL_MNG_SHA_EXTEND_M	MAKEMASK(0xFFFFFFFF, 0)
#define GL_MNG_SHA_EXTEND_ROM(_i)		(0x00083160 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: EMPR */
#define GL_MNG_SHA_EXTEND_ROM_MAX_INDEX		7
#define GL_MNG_SHA_EXTEND_ROM_GL_MNG_SHA_EXTEND_ROM_S 0
#define GL_MNG_SHA_EXTEND_ROM_GL_MNG_SHA_EXTEND_ROM_M MAKEMASK(0xFFFFFFFF, 0)
#define GL_MNG_SHA_EXTEND_STATUS		0x00083148 /* Reset Source: EMPR */
#define GL_MNG_SHA_EXTEND_STATUS_STAGE_S	0
#define GL_MNG_SHA_EXTEND_STATUS_STAGE_M	MAKEMASK(0x7, 0)
#define GL_MNG_SHA_EXTEND_STATUS_FW_HALTED_S	30
#define GL_MNG_SHA_EXTEND_STATUS_FW_HALTED_M	BIT(30)
#define GL_MNG_SHA_EXTEND_STATUS_DONE_S		31
#define GL_MNG_SHA_EXTEND_STATUS_DONE_M		BIT(31)
#define GL_SWT_PRT2MDEF(_i)			(0x00216018 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: POR */
#define GL_SWT_PRT2MDEF_MAX_INDEX		31
#define GL_SWT_PRT2MDEF_MDEFIDX_S		0
#define GL_SWT_PRT2MDEF_MDEFIDX_M		MAKEMASK(0x7, 0)
#define GL_SWT_PRT2MDEF_MDEFENA_S		31
#define GL_SWT_PRT2MDEF_MDEFENA_M		BIT(31)
#define PRT_MNG_MANC				0x00214720 /* Reset Source: POR */
#define PRT_MNG_MANC_FLOW_CONTROL_DISCARD_S	0
#define PRT_MNG_MANC_FLOW_CONTROL_DISCARD_M	BIT(0)
#define PRT_MNG_MANC_NCSI_DISCARD_S		1
#define PRT_MNG_MANC_NCSI_DISCARD_M		BIT(1)
#define PRT_MNG_MANC_RCV_TCO_EN_S		17
#define PRT_MNG_MANC_RCV_TCO_EN_M		BIT(17)
#define PRT_MNG_MANC_RCV_ALL_S			19
#define PRT_MNG_MANC_RCV_ALL_M			BIT(19)
#define PRT_MNG_MANC_FIXED_NET_TYPE_S		25
#define PRT_MNG_MANC_FIXED_NET_TYPE_M		BIT(25)
#define PRT_MNG_MANC_NET_TYPE_S			26
#define PRT_MNG_MANC_NET_TYPE_M			BIT(26)
#define PRT_MNG_MANC_EN_BMC2OS_S		28
#define PRT_MNG_MANC_EN_BMC2OS_M		BIT(28)
#define PRT_MNG_MANC_EN_BMC2NET_S		29
#define PRT_MNG_MANC_EN_BMC2NET_M		BIT(29)
#define PRT_MNG_MAVTV(_i)			(0x00214780 + ((_i) * 32)) /* _i=0...7 */ /* Reset Source: POR */
#define PRT_MNG_MAVTV_MAX_INDEX			7
#define PRT_MNG_MAVTV_VID_S			0
#define PRT_MNG_MAVTV_VID_M			MAKEMASK(0xFFF, 0)
#define PRT_MNG_MDEF(_i)			(0x00214880 + ((_i) * 32)) /* _i=0...7 */ /* Reset Source: POR */
#define PRT_MNG_MDEF_MAX_INDEX			7
#define PRT_MNG_MDEF_MAC_EXACT_AND_S		0
#define PRT_MNG_MDEF_MAC_EXACT_AND_M		MAKEMASK(0xF, 0)
#define PRT_MNG_MDEF_BROADCAST_AND_S		4
#define PRT_MNG_MDEF_BROADCAST_AND_M		BIT(4)
#define PRT_MNG_MDEF_VLAN_AND_S			5
#define PRT_MNG_MDEF_VLAN_AND_M			MAKEMASK(0xFF, 5)
#define PRT_MNG_MDEF_IPV4_ADDRESS_AND_S		13
#define PRT_MNG_MDEF_IPV4_ADDRESS_AND_M		MAKEMASK(0xF, 13)
#define PRT_MNG_MDEF_IPV6_ADDRESS_AND_S		17
#define PRT_MNG_MDEF_IPV6_ADDRESS_AND_M		MAKEMASK(0xF, 17)
#define PRT_MNG_MDEF_MAC_EXACT_OR_S		21
#define PRT_MNG_MDEF_MAC_EXACT_OR_M		MAKEMASK(0xF, 21)
#define PRT_MNG_MDEF_BROADCAST_OR_S		25
#define PRT_MNG_MDEF_BROADCAST_OR_M		BIT(25)
#define PRT_MNG_MDEF_MULTICAST_AND_S		26
#define PRT_MNG_MDEF_MULTICAST_AND_M		BIT(26)
#define PRT_MNG_MDEF_ARP_REQUEST_OR_S		27
#define PRT_MNG_MDEF_ARP_REQUEST_OR_M		BIT(27)
#define PRT_MNG_MDEF_ARP_RESPONSE_OR_S		28
#define PRT_MNG_MDEF_ARP_RESPONSE_OR_M		BIT(28)
#define PRT_MNG_MDEF_NEIGHBOR_DISCOVERY_134_OR_S 29
#define PRT_MNG_MDEF_NEIGHBOR_DISCOVERY_134_OR_M BIT(29)
#define PRT_MNG_MDEF_PORT_0X298_OR_S		30
#define PRT_MNG_MDEF_PORT_0X298_OR_M		BIT(30)
#define PRT_MNG_MDEF_PORT_0X26F_OR_S		31
#define PRT_MNG_MDEF_PORT_0X26F_OR_M		BIT(31)
#define PRT_MNG_MDEF_EXT(_i)			(0x00214A00 + ((_i) * 32)) /* _i=0...7 */ /* Reset Source: POR */
#define PRT_MNG_MDEF_EXT_MAX_INDEX		7
#define PRT_MNG_MDEF_EXT_L2_ETHERTYPE_AND_S	0
#define PRT_MNG_MDEF_EXT_L2_ETHERTYPE_AND_M	MAKEMASK(0xF, 0)
#define PRT_MNG_MDEF_EXT_L2_ETHERTYPE_OR_S	4
#define PRT_MNG_MDEF_EXT_L2_ETHERTYPE_OR_M	MAKEMASK(0xF, 4)
#define PRT_MNG_MDEF_EXT_FLEX_PORT_OR_S		8
#define PRT_MNG_MDEF_EXT_FLEX_PORT_OR_M		MAKEMASK(0xFFFF, 8)
#define PRT_MNG_MDEF_EXT_FLEX_TCO_S		24
#define PRT_MNG_MDEF_EXT_FLEX_TCO_M		BIT(24)
#define PRT_MNG_MDEF_EXT_NEIGHBOR_DISCOVERY_135_OR_S 25
#define PRT_MNG_MDEF_EXT_NEIGHBOR_DISCOVERY_135_OR_M BIT(25)
#define PRT_MNG_MDEF_EXT_NEIGHBOR_DISCOVERY_136_OR_S 26
#define PRT_MNG_MDEF_EXT_NEIGHBOR_DISCOVERY_136_OR_M BIT(26)
#define PRT_MNG_MDEF_EXT_NEIGHBOR_DISCOVERY_137_OR_S 27
#define PRT_MNG_MDEF_EXT_NEIGHBOR_DISCOVERY_137_OR_M BIT(27)
#define PRT_MNG_MDEF_EXT_ICMP_OR_S		28
#define PRT_MNG_MDEF_EXT_ICMP_OR_M		BIT(28)
#define PRT_MNG_MDEF_EXT_MLD_S			29
#define PRT_MNG_MDEF_EXT_MLD_M			BIT(29)
#define PRT_MNG_MDEF_EXT_APPLY_TO_NETWORK_TRAFFIC_S 30
#define PRT_MNG_MDEF_EXT_APPLY_TO_NETWORK_TRAFFIC_M BIT(30)
#define PRT_MNG_MDEF_EXT_APPLY_TO_HOST_TRAFFIC_S 31
#define PRT_MNG_MDEF_EXT_APPLY_TO_HOST_TRAFFIC_M BIT(31)
#define PRT_MNG_MDEFVSI(_i)			(0x00214980 + ((_i) * 32)) /* _i=0...3 */ /* Reset Source: POR */
#define PRT_MNG_MDEFVSI_MAX_INDEX		3
#define PRT_MNG_MDEFVSI_MDEFVSI_2N_S		0
#define PRT_MNG_MDEFVSI_MDEFVSI_2N_M		MAKEMASK(0xFFFF, 0)
#define PRT_MNG_MDEFVSI_MDEFVSI_2NP1_S		16
#define PRT_MNG_MDEFVSI_MDEFVSI_2NP1_M		MAKEMASK(0xFFFF, 16)
#define PRT_MNG_METF(_i)			(0x00214120 + ((_i) * 32)) /* _i=0...3 */ /* Reset Source: POR */
#define PRT_MNG_METF_MAX_INDEX			3
#define PRT_MNG_METF_ETYPE_S			0
#define PRT_MNG_METF_ETYPE_M			MAKEMASK(0xFFFF, 0)
#define PRT_MNG_METF_POLARITY_S			30
#define PRT_MNG_METF_POLARITY_M			BIT(30)
#define PRT_MNG_MFUTP(_i)			(0x00214320 + ((_i) * 32)) /* _i=0...15 */ /* Reset Source: POR */
#define PRT_MNG_MFUTP_MAX_INDEX			15
#define PRT_MNG_MFUTP_MFUTP_N_S			0
#define PRT_MNG_MFUTP_MFUTP_N_M			MAKEMASK(0xFFFF, 0)
#define PRT_MNG_MFUTP_UDP_S			16
#define PRT_MNG_MFUTP_UDP_M			BIT(16)
#define PRT_MNG_MFUTP_TCP_S			17
#define PRT_MNG_MFUTP_TCP_M			BIT(17)
#define PRT_MNG_MFUTP_SOURCE_DESTINATION_S	18
#define PRT_MNG_MFUTP_SOURCE_DESTINATION_M	BIT(18)
#define PRT_MNG_MIPAF4(_i)			(0x002141A0 + ((_i) * 32)) /* _i=0...3 */ /* Reset Source: POR */
#define PRT_MNG_MIPAF4_MAX_INDEX		3
#define PRT_MNG_MIPAF4_MIPAF_S			0
#define PRT_MNG_MIPAF4_MIPAF_M			MAKEMASK(0xFFFFFFFF, 0)
#define PRT_MNG_MIPAF6(_i)			(0x00214520 + ((_i) * 32)) /* _i=0...15 */ /* Reset Source: POR */
#define PRT_MNG_MIPAF6_MAX_INDEX		15
#define PRT_MNG_MIPAF6_MIPAF_S			0
#define PRT_MNG_MIPAF6_MIPAF_M			MAKEMASK(0xFFFFFFFF, 0)
#define PRT_MNG_MMAH(_i)			(0x00214220 + ((_i) * 32)) /* _i=0...3 */ /* Reset Source: POR */
#define PRT_MNG_MMAH_MAX_INDEX			3
#define PRT_MNG_MMAH_MMAH_S			0
#define PRT_MNG_MMAH_MMAH_M			MAKEMASK(0xFFFF, 0)
#define PRT_MNG_MMAL(_i)			(0x002142A0 + ((_i) * 32)) /* _i=0...3 */ /* Reset Source: POR */
#define PRT_MNG_MMAL_MAX_INDEX			3
#define PRT_MNG_MMAL_MMAL_S			0
#define PRT_MNG_MMAL_MMAL_M			MAKEMASK(0xFFFFFFFF, 0)
#define PRT_MNG_MNGONLY				0x00214740 /* Reset Source: POR */
#define PRT_MNG_MNGONLY_EXCLUSIVE_TO_MANAGEABILITY_S 0
#define PRT_MNG_MNGONLY_EXCLUSIVE_TO_MANAGEABILITY_M MAKEMASK(0xFF, 0)
#define PRT_MNG_MSFM				0x00214760 /* Reset Source: POR */
#define PRT_MNG_MSFM_PORT_26F_UDP_S		0
#define PRT_MNG_MSFM_PORT_26F_UDP_M		BIT(0)
#define PRT_MNG_MSFM_PORT_26F_TCP_S		1
#define PRT_MNG_MSFM_PORT_26F_TCP_M		BIT(1)
#define PRT_MNG_MSFM_PORT_298_UDP_S		2
#define PRT_MNG_MSFM_PORT_298_UDP_M		BIT(2)
#define PRT_MNG_MSFM_PORT_298_TCP_S		3
#define PRT_MNG_MSFM_PORT_298_TCP_M		BIT(3)
#define PRT_MNG_MSFM_IPV6_0_MASK_S		4
#define PRT_MNG_MSFM_IPV6_0_MASK_M		BIT(4)
#define PRT_MNG_MSFM_IPV6_1_MASK_S		5
#define PRT_MNG_MSFM_IPV6_1_MASK_M		BIT(5)
#define PRT_MNG_MSFM_IPV6_2_MASK_S		6
#define PRT_MNG_MSFM_IPV6_2_MASK_M		BIT(6)
#define PRT_MNG_MSFM_IPV6_3_MASK_S		7
#define PRT_MNG_MSFM_IPV6_3_MASK_M		BIT(7)
#define MSIX_PBA_PAGE(_i)			(0x02E08000 + ((_i) * 4)) /* _i=0...63 */ /* Reset Source: FLR */
#define MSIX_PBA_PAGE_MAX_INDEX			63
#define MSIX_PBA_PAGE_PENBIT_S			0
#define MSIX_PBA_PAGE_PENBIT_M			MAKEMASK(0xFFFFFFFF, 0)
#define MSIX_PBA1(_i)				(0x00008000 + ((_i) * 4)) /* _i=0...63 */ /* Reset Source: FLR */
#define MSIX_PBA1_MAX_INDEX			63
#define MSIX_PBA1_PENBIT_S			0
#define MSIX_PBA1_PENBIT_M			MAKEMASK(0xFFFFFFFF, 0)
#define MSIX_TADD_PAGE(_i)			(0x02E00000 + ((_i) * 16)) /* _i=0...2047 */ /* Reset Source: FLR */
#define MSIX_TADD_PAGE_MAX_INDEX		2047
#define MSIX_TADD_PAGE_MSIXTADD10_S		0
#define MSIX_TADD_PAGE_MSIXTADD10_M		MAKEMASK(0x3, 0)
#define MSIX_TADD_PAGE_MSIXTADD_S		2
#define MSIX_TADD_PAGE_MSIXTADD_M		MAKEMASK(0x3FFFFFFF, 2)
#define MSIX_TADD1(_i)				(0x00000000 + ((_i) * 16)) /* _i=0...2047 */ /* Reset Source: FLR */
#define MSIX_TADD1_MAX_INDEX			2047
#define MSIX_TADD1_MSIXTADD10_S			0
#define MSIX_TADD1_MSIXTADD10_M			MAKEMASK(0x3, 0)
#define MSIX_TADD1_MSIXTADD_S			2
#define MSIX_TADD1_MSIXTADD_M			MAKEMASK(0x3FFFFFFF, 2)
#define MSIX_TMSG(_i)				(0x00000008 + ((_i) * 16)) /* _i=0...2047 */ /* Reset Source: FLR */
#define MSIX_TMSG_MAX_INDEX			2047
#define MSIX_TMSG_MSIXTMSG_S			0
#define MSIX_TMSG_MSIXTMSG_M			MAKEMASK(0xFFFFFFFF, 0)
#define MSIX_TMSG_PAGE(_i)			(0x02E00008 + ((_i) * 16)) /* _i=0...2047 */ /* Reset Source: FLR */
#define MSIX_TMSG_PAGE_MAX_INDEX		2047
#define MSIX_TMSG_PAGE_MSIXTMSG_S		0
#define MSIX_TMSG_PAGE_MSIXTMSG_M		MAKEMASK(0xFFFFFFFF, 0)
#define MSIX_TUADD_PAGE(_i)			(0x02E00004 + ((_i) * 16)) /* _i=0...2047 */ /* Reset Source: FLR */
#define MSIX_TUADD_PAGE_MAX_INDEX		2047
#define MSIX_TUADD_PAGE_MSIXTUADD_S		0
#define MSIX_TUADD_PAGE_MSIXTUADD_M		MAKEMASK(0xFFFFFFFF, 0)
#define MSIX_TUADD1(_i)				(0x00000004 + ((_i) * 16)) /* _i=0...2047 */ /* Reset Source: FLR */
#define MSIX_TUADD1_MAX_INDEX			2047
#define MSIX_TUADD1_MSIXTUADD_S			0
#define MSIX_TUADD1_MSIXTUADD_M			MAKEMASK(0xFFFFFFFF, 0)
#define MSIX_TVCTRL_PAGE(_i)			(0x02E0000C + ((_i) * 16)) /* _i=0...2047 */ /* Reset Source: FLR */
#define MSIX_TVCTRL_PAGE_MAX_INDEX		2047
#define MSIX_TVCTRL_PAGE_MASK_S			0
#define MSIX_TVCTRL_PAGE_MASK_M			BIT(0)
#define MSIX_TVCTRL1(_i)			(0x0000000C + ((_i) * 16)) /* _i=0...2047 */ /* Reset Source: FLR */
#define MSIX_TVCTRL1_MAX_INDEX			2047
#define MSIX_TVCTRL1_MASK_S			0
#define MSIX_TVCTRL1_MASK_M			BIT(0)
#define GLNVM_AL_DONE_HLP			0x000824C4 /* Reset Source: POR */
#define GLNVM_AL_DONE_HLP_HLP_CORER_S		0
#define GLNVM_AL_DONE_HLP_HLP_CORER_M		BIT(0)
#define GLNVM_AL_DONE_HLP_HLP_FULLR_S		1
#define GLNVM_AL_DONE_HLP_HLP_FULLR_M		BIT(1)
#define GLNVM_ALTIMERS				0x000B6140 /* Reset Source: POR */
#define GLNVM_ALTIMERS_PCI_ALTIMER_S		0
#define GLNVM_ALTIMERS_PCI_ALTIMER_M		MAKEMASK(0xFFF, 0)
#define GLNVM_ALTIMERS_GEN_ALTIMER_S		12
#define GLNVM_ALTIMERS_GEN_ALTIMER_M		MAKEMASK(0xFFFFF, 12)
#define GLNVM_FLA				0x000B6108 /* Reset Source: POR */
#define GLNVM_FLA_LOCKED_S			6
#define GLNVM_FLA_LOCKED_M			BIT(6)
#define GLNVM_GENS				0x000B6100 /* Reset Source: POR */
#define GLNVM_GENS_NVM_PRES_S			0
#define GLNVM_GENS_NVM_PRES_M			BIT(0)
#define GLNVM_GENS_SR_SIZE_S			5
#define GLNVM_GENS_SR_SIZE_M			MAKEMASK(0x7, 5)
#define GLNVM_GENS_BANK1VAL_S			8
#define GLNVM_GENS_BANK1VAL_M			BIT(8)
#define GLNVM_GENS_ALT_PRST_S			23
#define GLNVM_GENS_ALT_PRST_M			BIT(23)
#define GLNVM_GENS_FL_AUTO_RD_S			25
#define GLNVM_GENS_FL_AUTO_RD_M			BIT(25)
#define GLNVM_PROTCSR(_i)			(0x000B6010 + ((_i) * 4)) /* _i=0...59 */ /* Reset Source: POR */
#define GLNVM_PROTCSR_MAX_INDEX			59
#define GLNVM_PROTCSR_ADDR_BLOCK_S		0
#define GLNVM_PROTCSR_ADDR_BLOCK_M		MAKEMASK(0xFFFFFF, 0)
#define GLNVM_ULD				0x000B6008 /* Reset Source: POR */
#define GLNVM_ULD_PCIER_DONE_S			0
#define GLNVM_ULD_PCIER_DONE_M			BIT(0)
#define GLNVM_ULD_PCIER_DONE_1_S		1
#define GLNVM_ULD_PCIER_DONE_1_M		BIT(1)
#define GLNVM_ULD_CORER_DONE_S			3
#define GLNVM_ULD_CORER_DONE_M			BIT(3)
#define GLNVM_ULD_GLOBR_DONE_S			4
#define GLNVM_ULD_GLOBR_DONE_M			BIT(4)
#define GLNVM_ULD_POR_DONE_S			5
#define GLNVM_ULD_POR_DONE_M			BIT(5)
#define GLNVM_ULD_POR_DONE_1_S			8
#define GLNVM_ULD_POR_DONE_1_M			BIT(8)
#define GLNVM_ULD_PCIER_DONE_2_S		9
#define GLNVM_ULD_PCIER_DONE_2_M		BIT(9)
#define GLNVM_ULD_PE_DONE_S			10
#define GLNVM_ULD_PE_DONE_M			BIT(10)
#define GLNVM_ULD_HLP_CORE_DONE_S		11
#define GLNVM_ULD_HLP_CORE_DONE_M		BIT(11)
#define GLNVM_ULD_HLP_FULL_DONE_S		12
#define GLNVM_ULD_HLP_FULL_DONE_M		BIT(12)
#define GLNVM_ULT				0x000B6154 /* Reset Source: POR */
#define GLNVM_ULT_CONF_PCIR_AE_S		0
#define GLNVM_ULT_CONF_PCIR_AE_M		BIT(0)
#define GLNVM_ULT_CONF_PCIRTL_AE_S		1
#define GLNVM_ULT_CONF_PCIRTL_AE_M		BIT(1)
#define GLNVM_ULT_RESERVED_1_S			2
#define GLNVM_ULT_RESERVED_1_M			BIT(2)
#define GLNVM_ULT_CONF_CORE_AE_S		3
#define GLNVM_ULT_CONF_CORE_AE_M		BIT(3)
#define GLNVM_ULT_CONF_GLOBAL_AE_S		4
#define GLNVM_ULT_CONF_GLOBAL_AE_M		BIT(4)
#define GLNVM_ULT_CONF_POR_AE_S			5
#define GLNVM_ULT_CONF_POR_AE_M			BIT(5)
#define GLNVM_ULT_RESERVED_2_S			6
#define GLNVM_ULT_RESERVED_2_M			BIT(6)
#define GLNVM_ULT_RESERVED_3_S			7
#define GLNVM_ULT_RESERVED_3_M			BIT(7)
#define GLNVM_ULT_RESERVED_5_S			8
#define GLNVM_ULT_RESERVED_5_M			BIT(8)
#define GLNVM_ULT_CONF_PCIALT_AE_S		9
#define GLNVM_ULT_CONF_PCIALT_AE_M		BIT(9)
#define GLNVM_ULT_CONF_PE_AE_S			10
#define GLNVM_ULT_CONF_PE_AE_M			BIT(10)
#define GLNVM_ULT_RESERVED_4_S			11
#define GLNVM_ULT_RESERVED_4_M			MAKEMASK(0x1FFFFF, 11)
#define GL_COTF_MARKER_STATUS			0x00200200 /* Reset Source: CORER */
#define GL_COTF_MARKER_STATUS_MRKR_BUSY_S	0
#define GL_COTF_MARKER_STATUS_MRKR_BUSY_M	MAKEMASK(0xFF, 0)
#define GL_COTF_MARKER_TRIG_RCU_PRS(_i)		(0x002001D4 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GL_COTF_MARKER_TRIG_RCU_PRS_MAX_INDEX	7
#define GL_COTF_MARKER_TRIG_RCU_PRS_SET_RST_S	0
#define GL_COTF_MARKER_TRIG_RCU_PRS_SET_RST_M	BIT(0)
#define GL_PRS_MARKER_ERROR			0x00200204 /* Reset Source: CORER */
#define GL_PRS_MARKER_ERROR_XLR_CFG_ERR_S	0
#define GL_PRS_MARKER_ERROR_XLR_CFG_ERR_M	BIT(0)
#define GL_PRS_MARKER_ERROR_QH_CFG_ERR_S	1
#define GL_PRS_MARKER_ERROR_QH_CFG_ERR_M	BIT(1)
#define GL_PRS_MARKER_ERROR_COTF_CFG_ERR_S	2
#define GL_PRS_MARKER_ERROR_COTF_CFG_ERR_M	BIT(2)
#define GL_PRS_RX_PIPE_INIT0(_i)		(0x0020000C + ((_i) * 4)) /* _i=0...6 */ /* Reset Source: CORER */
#define GL_PRS_RX_PIPE_INIT0_MAX_INDEX		6
#define GL_PRS_RX_PIPE_INIT0_GPCSR_INIT_S	0
#define GL_PRS_RX_PIPE_INIT0_GPCSR_INIT_M	MAKEMASK(0xFFFF, 0)
#define GL_PRS_RX_PIPE_INIT1			0x00200028 /* Reset Source: CORER */
#define GL_PRS_RX_PIPE_INIT1_GPCSR_INIT_S	0
#define GL_PRS_RX_PIPE_INIT1_GPCSR_INIT_M	MAKEMASK(0xFFFF, 0)
#define GL_PRS_RX_PIPE_INIT2			0x0020002C /* Reset Source: CORER */
#define GL_PRS_RX_PIPE_INIT2_GPCSR_INIT_S	0
#define GL_PRS_RX_PIPE_INIT2_GPCSR_INIT_M	MAKEMASK(0xFFFF, 0)
#define GL_PRS_RX_SIZE_CTRL			0x00200004 /* Reset Source: CORER */
#define GL_PRS_RX_SIZE_CTRL_MIN_SIZE_S		0
#define GL_PRS_RX_SIZE_CTRL_MIN_SIZE_M		MAKEMASK(0x3FF, 0)
#define GL_PRS_RX_SIZE_CTRL_MIN_SIZE_EN_S	15
#define GL_PRS_RX_SIZE_CTRL_MIN_SIZE_EN_M	BIT(15)
#define GL_PRS_RX_SIZE_CTRL_MAX_SIZE_S		16
#define GL_PRS_RX_SIZE_CTRL_MAX_SIZE_M		MAKEMASK(0x3FF, 16)
#define GL_PRS_RX_SIZE_CTRL_MAX_SIZE_EN_S	31
#define GL_PRS_RX_SIZE_CTRL_MAX_SIZE_EN_M	BIT(31)
#define GL_PRS_TX_PIPE_INIT0(_i)		(0x00202018 + ((_i) * 4)) /* _i=0...6 */ /* Reset Source: CORER */
#define GL_PRS_TX_PIPE_INIT0_MAX_INDEX		6
#define GL_PRS_TX_PIPE_INIT0_GPCSR_INIT_S	0
#define GL_PRS_TX_PIPE_INIT0_GPCSR_INIT_M	MAKEMASK(0xFFFF, 0)
#define GL_PRS_TX_PIPE_INIT1			0x00202034 /* Reset Source: CORER */
#define GL_PRS_TX_PIPE_INIT1_GPCSR_INIT_S	0
#define GL_PRS_TX_PIPE_INIT1_GPCSR_INIT_M	MAKEMASK(0xFFFF, 0)
#define GL_PRS_TX_PIPE_INIT2			0x00202038 /* Reset Source: CORER */
#define GL_PRS_TX_PIPE_INIT2_GPCSR_INIT_S	0
#define GL_PRS_TX_PIPE_INIT2_GPCSR_INIT_M	MAKEMASK(0xFFFF, 0)
#define GL_PRS_TX_SIZE_CTRL			0x00202014 /* Reset Source: CORER */
#define GL_PRS_TX_SIZE_CTRL_MIN_SIZE_S		0
#define GL_PRS_TX_SIZE_CTRL_MIN_SIZE_M		MAKEMASK(0x3FF, 0)
#define GL_PRS_TX_SIZE_CTRL_MIN_SIZE_EN_S	15
#define GL_PRS_TX_SIZE_CTRL_MIN_SIZE_EN_M	BIT(15)
#define GL_PRS_TX_SIZE_CTRL_MAX_SIZE_S		16
#define GL_PRS_TX_SIZE_CTRL_MAX_SIZE_M		MAKEMASK(0x3FF, 16)
#define GL_PRS_TX_SIZE_CTRL_MAX_SIZE_EN_S	31
#define GL_PRS_TX_SIZE_CTRL_MAX_SIZE_EN_M	BIT(31)
#define GL_QH_MARKER_STATUS			0x002001FC /* Reset Source: CORER */
#define GL_QH_MARKER_STATUS_MRKR_BUSY_S		0
#define GL_QH_MARKER_STATUS_MRKR_BUSY_M		MAKEMASK(0xF, 0)
#define GL_QH_MARKER_TRIG_RCU_PRS(_i)		(0x002001C4 + ((_i) * 4)) /* _i=0...3 */ /* Reset Source: CORER */
#define GL_QH_MARKER_TRIG_RCU_PRS_MAX_INDEX	3
#define GL_QH_MARKER_TRIG_RCU_PRS_QPID_S	0
#define GL_QH_MARKER_TRIG_RCU_PRS_QPID_M	MAKEMASK(0x3FFFF, 0)
#define GL_QH_MARKER_TRIG_RCU_PRS_PE_TAG_S	18
#define GL_QH_MARKER_TRIG_RCU_PRS_PE_TAG_M	MAKEMASK(0xFF, 18)
#define GL_QH_MARKER_TRIG_RCU_PRS_PORT_NUM_S	26
#define GL_QH_MARKER_TRIG_RCU_PRS_PORT_NUM_M	MAKEMASK(0x7, 26)
#define GL_QH_MARKER_TRIG_RCU_PRS_SET_RST_S	31
#define GL_QH_MARKER_TRIG_RCU_PRS_SET_RST_M	BIT(31)
#define GL_RPRS_ANA_CSR_CTRL			0x00200708 /* Reset Source: CORER */
#define GL_RPRS_ANA_CSR_CTRL_SELECT_EN_S	0
#define GL_RPRS_ANA_CSR_CTRL_SELECT_EN_M	BIT(0)
#define GL_RPRS_ANA_CSR_CTRL_SELECTED_ANA_S	1
#define GL_RPRS_ANA_CSR_CTRL_SELECTED_ANA_M	BIT(1)
#define GL_TPRS_ANA_CSR_CTRL			0x00202100 /* Reset Source: CORER */
#define GL_TPRS_ANA_CSR_CTRL_SELECT_EN_S	0
#define GL_TPRS_ANA_CSR_CTRL_SELECT_EN_M	BIT(0)
#define GL_TPRS_ANA_CSR_CTRL_SELECTED_ANA_S	1
#define GL_TPRS_ANA_CSR_CTRL_SELECTED_ANA_M	BIT(1)
#define GL_TPRS_MNG_PM_THR			0x00202004 /* Reset Source: CORER */
#define GL_TPRS_MNG_PM_THR_MNG_PM_THR_S		0
#define GL_TPRS_MNG_PM_THR_MNG_PM_THR_M		MAKEMASK(0x3FFF, 0)
#define GL_TPRS_PM_CNT(_i)			(0x00202008 + ((_i) * 4)) /* _i=0...1 */ /* Reset Source: CORER */
#define GL_TPRS_PM_CNT_MAX_INDEX		1
#define GL_TPRS_PM_CNT_GL_PRS_PM_CNT_S		0
#define GL_TPRS_PM_CNT_GL_PRS_PM_CNT_M		MAKEMASK(0x3FFF, 0)
#define GL_TPRS_PM_THR				0x00202000 /* Reset Source: CORER */
#define GL_TPRS_PM_THR_PM_THR_S			0
#define GL_TPRS_PM_THR_PM_THR_M			MAKEMASK(0x3FFF, 0)
#define GL_XLR_MARKER_LOG_RCU_PRS(_i)		(0x00200208 + ((_i) * 4)) /* _i=0...63 */ /* Reset Source: CORER */
#define GL_XLR_MARKER_LOG_RCU_PRS_MAX_INDEX	63
#define GL_XLR_MARKER_LOG_RCU_PRS_XLR_TRIG_S	0
#define GL_XLR_MARKER_LOG_RCU_PRS_XLR_TRIG_M	MAKEMASK(0xFFFFFFFF, 0)
#define GL_XLR_MARKER_STATUS(_i)		(0x002001F4 + ((_i) * 4)) /* _i=0...1 */ /* Reset Source: CORER */
#define GL_XLR_MARKER_STATUS_MAX_INDEX		1
#define GL_XLR_MARKER_STATUS_MRKR_BUSY_S	0
#define GL_XLR_MARKER_STATUS_MRKR_BUSY_M	MAKEMASK(0xFFFFFFFF, 0)
#define GL_XLR_MARKER_TRIG_PE			0x005008C0 /* Reset Source: CORER */
#define GL_XLR_MARKER_TRIG_PE_VM_VF_NUM_S	0
#define GL_XLR_MARKER_TRIG_PE_VM_VF_NUM_M	MAKEMASK(0x3FF, 0)
#define GL_XLR_MARKER_TRIG_PE_VM_VF_TYPE_S	10
#define GL_XLR_MARKER_TRIG_PE_VM_VF_TYPE_M	MAKEMASK(0x3, 10)
#define GL_XLR_MARKER_TRIG_PE_PF_NUM_S		12
#define GL_XLR_MARKER_TRIG_PE_PF_NUM_M		MAKEMASK(0x7, 12)
#define GL_XLR_MARKER_TRIG_PE_PORT_NUM_S	16
#define GL_XLR_MARKER_TRIG_PE_PORT_NUM_M	MAKEMASK(0x7, 16)
#define GL_XLR_MARKER_TRIG_RCU_PRS		0x002001C0 /* Reset Source: CORER */
#define GL_XLR_MARKER_TRIG_RCU_PRS_VM_VF_NUM_S	0
#define GL_XLR_MARKER_TRIG_RCU_PRS_VM_VF_NUM_M	MAKEMASK(0x3FF, 0)
#define GL_XLR_MARKER_TRIG_RCU_PRS_VM_VF_TYPE_S 10
#define GL_XLR_MARKER_TRIG_RCU_PRS_VM_VF_TYPE_M MAKEMASK(0x3, 10)
#define GL_XLR_MARKER_TRIG_RCU_PRS_PF_NUM_S	12
#define GL_XLR_MARKER_TRIG_RCU_PRS_PF_NUM_M	MAKEMASK(0x7, 12)
#define GL_XLR_MARKER_TRIG_RCU_PRS_PORT_NUM_S	16
#define GL_XLR_MARKER_TRIG_RCU_PRS_PORT_NUM_M	MAKEMASK(0x7, 16)
#define GL_CLKGATE_EVENTS			0x0009DE70 /* Reset Source: PERST */
#define GL_CLKGATE_EVENTS_PRIMARY_CLKGATE_EVENTS_S 0
#define GL_CLKGATE_EVENTS_PRIMARY_CLKGATE_EVENTS_M MAKEMASK(0xFFFF, 0)
#define GL_CLKGATE_EVENTS_SIDEBAND_CLKGATE_EVENTS_S 16
#define GL_CLKGATE_EVENTS_SIDEBAND_CLKGATE_EVENTS_M MAKEMASK(0xFFFF, 16)
#define GLPCI_BYTCTH_NP_C			0x000BFDA8 /* Reset Source: PCIR */
#define GLPCI_BYTCTH_NP_C_PCI_COUNT_BW_BCT_S	0
#define GLPCI_BYTCTH_NP_C_PCI_COUNT_BW_BCT_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLPCI_BYTCTH_P				0x0009E970 /* Reset Source: PCIR */
#define GLPCI_BYTCTH_P_PCI_COUNT_BW_BCT_S	0
#define GLPCI_BYTCTH_P_PCI_COUNT_BW_BCT_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLPCI_BYTCTL_NP_C			0x000BFDAC /* Reset Source: PCIR */
#define GLPCI_BYTCTL_NP_C_PCI_COUNT_BW_BCT_S	0
#define GLPCI_BYTCTL_NP_C_PCI_COUNT_BW_BCT_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLPCI_BYTCTL_P				0x0009E994 /* Reset Source: PCIR */
#define GLPCI_BYTCTL_P_PCI_COUNT_BW_BCT_S	0
#define GLPCI_BYTCTL_P_PCI_COUNT_BW_BCT_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLPCI_CAPCTRL				0x0009DE88 /* Reset Source: PCIR */
#define GLPCI_CAPCTRL_VPD_EN_S			0
#define GLPCI_CAPCTRL_VPD_EN_M			BIT(0)
#define GLPCI_CAPSUP				0x0009DE8C /* Reset Source: PCIR */
#define GLPCI_CAPSUP_PCIE_VER_S			0
#define GLPCI_CAPSUP_PCIE_VER_M			BIT(0)
#define GLPCI_CAPSUP_RESERVED_2_S		1
#define GLPCI_CAPSUP_RESERVED_2_M		BIT(1)
#define GLPCI_CAPSUP_LTR_EN_S			2
#define GLPCI_CAPSUP_LTR_EN_M			BIT(2)
#define GLPCI_CAPSUP_TPH_EN_S			3
#define GLPCI_CAPSUP_TPH_EN_M			BIT(3)
#define GLPCI_CAPSUP_ARI_EN_S			4
#define GLPCI_CAPSUP_ARI_EN_M			BIT(4)
#define GLPCI_CAPSUP_IOV_EN_S			5
#define GLPCI_CAPSUP_IOV_EN_M			BIT(5)
#define GLPCI_CAPSUP_ACS_EN_S			6
#define GLPCI_CAPSUP_ACS_EN_M			BIT(6)
#define GLPCI_CAPSUP_SEC_EN_S			7
#define GLPCI_CAPSUP_SEC_EN_M			BIT(7)
#define GLPCI_CAPSUP_PASID_EN_S			8
#define GLPCI_CAPSUP_PASID_EN_M			BIT(8)
#define GLPCI_CAPSUP_DLFE_EN_S			9
#define GLPCI_CAPSUP_DLFE_EN_M			BIT(9)
#define GLPCI_CAPSUP_GEN4_EXT_EN_S		10
#define GLPCI_CAPSUP_GEN4_EXT_EN_M		BIT(10)
#define GLPCI_CAPSUP_GEN4_MARG_EN_S		11
#define GLPCI_CAPSUP_GEN4_MARG_EN_M		BIT(11)
#define GLPCI_CAPSUP_ECRC_GEN_EN_S		16
#define GLPCI_CAPSUP_ECRC_GEN_EN_M		BIT(16)
#define GLPCI_CAPSUP_ECRC_CHK_EN_S		17
#define GLPCI_CAPSUP_ECRC_CHK_EN_M		BIT(17)
#define GLPCI_CAPSUP_IDO_EN_S			18
#define GLPCI_CAPSUP_IDO_EN_M			BIT(18)
#define GLPCI_CAPSUP_MSI_MASK_S			19
#define GLPCI_CAPSUP_MSI_MASK_M			BIT(19)
#define GLPCI_CAPSUP_CSR_CONF_EN_S		20
#define GLPCI_CAPSUP_CSR_CONF_EN_M		BIT(20)
#define GLPCI_CAPSUP_WAKUP_EN_S			21
#define GLPCI_CAPSUP_WAKUP_EN_M			BIT(21)
#define GLPCI_CAPSUP_LOAD_SUBSYS_ID_S		30
#define GLPCI_CAPSUP_LOAD_SUBSYS_ID_M		BIT(30)
#define GLPCI_CAPSUP_LOAD_DEV_ID_S		31
#define GLPCI_CAPSUP_LOAD_DEV_ID_M		BIT(31)
#define GLPCI_CNF				0x0009DEA0 /* Reset Source: POR */
#define GLPCI_CNF_FLEX10_S			1
#define GLPCI_CNF_FLEX10_M			BIT(1)
#define GLPCI_CNF_WAKE_PIN_EN_S			2
#define GLPCI_CNF_WAKE_PIN_EN_M			BIT(2)
#define GLPCI_CNF_MSIX_ECC_BLOCK_DISABLE_S	3
#define GLPCI_CNF_MSIX_ECC_BLOCK_DISABLE_M	BIT(3)
#define GLPCI_CNF2				0x000BE004 /* Reset Source: PCIR */
#define GLPCI_CNF2_RO_DIS_S			0
#define GLPCI_CNF2_RO_DIS_M			BIT(0)
#define GLPCI_CNF2_CACHELINE_SIZE_S		1
#define GLPCI_CNF2_CACHELINE_SIZE_M		BIT(1)
#define GLPCI_DREVID				0x0009E9AC /* Reset Source: PCIR */
#define GLPCI_DREVID_DEFAULT_REVID_S		0
#define GLPCI_DREVID_DEFAULT_REVID_M		MAKEMASK(0xFF, 0)
#define GLPCI_GSCL_1_NP_C			0x000BFDA4 /* Reset Source: PCIR */
#define GLPCI_GSCL_1_NP_C_RT_MODE_S		8
#define GLPCI_GSCL_1_NP_C_RT_MODE_M		BIT(8)
#define GLPCI_GSCL_1_NP_C_RT_EVENT_S		9
#define GLPCI_GSCL_1_NP_C_RT_EVENT_M		MAKEMASK(0x1F, 9)
#define GLPCI_GSCL_1_NP_C_PCI_COUNT_BW_EN_S	14
#define GLPCI_GSCL_1_NP_C_PCI_COUNT_BW_EN_M	BIT(14)
#define GLPCI_GSCL_1_NP_C_PCI_COUNT_BW_EV_S	15
#define GLPCI_GSCL_1_NP_C_PCI_COUNT_BW_EV_M	MAKEMASK(0x1F, 15)
#define GLPCI_GSCL_1_NP_C_GIO_COUNT_RESET_S	29
#define GLPCI_GSCL_1_NP_C_GIO_COUNT_RESET_M	BIT(29)
#define GLPCI_GSCL_1_NP_C_GIO_COUNT_STOP_S	30
#define GLPCI_GSCL_1_NP_C_GIO_COUNT_STOP_M	BIT(30)
#define GLPCI_GSCL_1_NP_C_GIO_COUNT_START_S	31
#define GLPCI_GSCL_1_NP_C_GIO_COUNT_START_M	BIT(31)
#define GLPCI_GSCL_1_P				0x0009E9B4 /* Reset Source: PCIR */
#define GLPCI_GSCL_1_P_GIO_COUNT_EN_0_S		0
#define GLPCI_GSCL_1_P_GIO_COUNT_EN_0_M		BIT(0)
#define GLPCI_GSCL_1_P_GIO_COUNT_EN_1_S		1
#define GLPCI_GSCL_1_P_GIO_COUNT_EN_1_M		BIT(1)
#define GLPCI_GSCL_1_P_GIO_COUNT_EN_2_S		2
#define GLPCI_GSCL_1_P_GIO_COUNT_EN_2_M		BIT(2)
#define GLPCI_GSCL_1_P_GIO_COUNT_EN_3_S		3
#define GLPCI_GSCL_1_P_GIO_COUNT_EN_3_M		BIT(3)
#define GLPCI_GSCL_1_P_LBC_ENABLE_0_S		4
#define GLPCI_GSCL_1_P_LBC_ENABLE_0_M		BIT(4)
#define GLPCI_GSCL_1_P_LBC_ENABLE_1_S		5
#define GLPCI_GSCL_1_P_LBC_ENABLE_1_M		BIT(5)
#define GLPCI_GSCL_1_P_LBC_ENABLE_2_S		6
#define GLPCI_GSCL_1_P_LBC_ENABLE_2_M		BIT(6)
#define GLPCI_GSCL_1_P_LBC_ENABLE_3_S		7
#define GLPCI_GSCL_1_P_LBC_ENABLE_3_M		BIT(7)
#define GLPCI_GSCL_1_P_PCI_COUNT_BW_EN_S	14
#define GLPCI_GSCL_1_P_PCI_COUNT_BW_EN_M	BIT(14)
#define GLPCI_GSCL_1_P_GIO_64_BIT_EN_S		28
#define GLPCI_GSCL_1_P_GIO_64_BIT_EN_M		BIT(28)
#define GLPCI_GSCL_1_P_GIO_COUNT_RESET_S	29
#define GLPCI_GSCL_1_P_GIO_COUNT_RESET_M	BIT(29)
#define GLPCI_GSCL_1_P_GIO_COUNT_STOP_S		30
#define GLPCI_GSCL_1_P_GIO_COUNT_STOP_M		BIT(30)
#define GLPCI_GSCL_1_P_GIO_COUNT_START_S	31
#define GLPCI_GSCL_1_P_GIO_COUNT_START_M	BIT(31)
#define GLPCI_GSCL_2				0x0009E998 /* Reset Source: PCIR */
#define GLPCI_GSCL_2_GIO_EVENT_NUM_0_S		0
#define GLPCI_GSCL_2_GIO_EVENT_NUM_0_M		MAKEMASK(0xFF, 0)
#define GLPCI_GSCL_2_GIO_EVENT_NUM_1_S		8
#define GLPCI_GSCL_2_GIO_EVENT_NUM_1_M		MAKEMASK(0xFF, 8)
#define GLPCI_GSCL_2_GIO_EVENT_NUM_2_S		16
#define GLPCI_GSCL_2_GIO_EVENT_NUM_2_M		MAKEMASK(0xFF, 16)
#define GLPCI_GSCL_2_GIO_EVENT_NUM_3_S		24
#define GLPCI_GSCL_2_GIO_EVENT_NUM_3_M		MAKEMASK(0xFF, 24)
#define GLPCI_GSCL_5_8(_i)			(0x0009E954 + ((_i) * 4)) /* _i=0...3 */ /* Reset Source: PCIR */
#define GLPCI_GSCL_5_8_MAX_INDEX		3
#define GLPCI_GSCL_5_8_LBC_THRESHOLD_N_S	0
#define GLPCI_GSCL_5_8_LBC_THRESHOLD_N_M	MAKEMASK(0xFFFF, 0)
#define GLPCI_GSCL_5_8_LBC_TIMER_N_S		16
#define GLPCI_GSCL_5_8_LBC_TIMER_N_M		MAKEMASK(0xFFFF, 16)
#define GLPCI_GSCN_0_3(_i)			(0x0009E99C + ((_i) * 4)) /* _i=0...3 */ /* Reset Source: PCIR */
#define GLPCI_GSCN_0_3_MAX_INDEX		3
#define GLPCI_GSCN_0_3_EVENT_COUNTER_S		0
#define GLPCI_GSCN_0_3_EVENT_COUNTER_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLPCI_LATCT_NP_C			0x000BFDA0 /* Reset Source: PCIR */
#define GLPCI_LATCT_NP_C_PCI_LATENCY_COUNT_S	0
#define GLPCI_LATCT_NP_C_PCI_LATENCY_COUNT_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLPCI_LBARCTRL				0x0009DE74 /* Reset Source: POR */
#define GLPCI_LBARCTRL_PREFBAR_S		0
#define GLPCI_LBARCTRL_PREFBAR_M		BIT(0)
#define GLPCI_LBARCTRL_BAR32_S			1
#define GLPCI_LBARCTRL_BAR32_M			BIT(1)
#define GLPCI_LBARCTRL_PAGES_SPACE_EN_PF_S	2
#define GLPCI_LBARCTRL_PAGES_SPACE_EN_PF_M	BIT(2)
#define GLPCI_LBARCTRL_FLASH_EXPOSE_S		3
#define GLPCI_LBARCTRL_FLASH_EXPOSE_M		BIT(3)
#define GLPCI_LBARCTRL_PE_DB_SIZE_S		4
#define GLPCI_LBARCTRL_PE_DB_SIZE_M		MAKEMASK(0x3, 4)
#define GLPCI_LBARCTRL_PAGES_SPACE_EN_VF_S	9
#define GLPCI_LBARCTRL_PAGES_SPACE_EN_VF_M	BIT(9)
#define GLPCI_LBARCTRL_EXROM_SIZE_S		11
#define GLPCI_LBARCTRL_EXROM_SIZE_M		MAKEMASK(0x7, 11)
#define GLPCI_LBARCTRL_VF_PE_DB_SIZE_S		14
#define GLPCI_LBARCTRL_VF_PE_DB_SIZE_M		MAKEMASK(0x3, 14)
#define GLPCI_LINKCAP				0x0009DE90 /* Reset Source: PCIR */
#define GLPCI_LINKCAP_LINK_SPEEDS_VECTOR_S	0
#define GLPCI_LINKCAP_LINK_SPEEDS_VECTOR_M	MAKEMASK(0x3F, 0)
#define GLPCI_LINKCAP_MAX_LINK_WIDTH_S		9
#define GLPCI_LINKCAP_MAX_LINK_WIDTH_M		MAKEMASK(0xF, 9)
#define GLPCI_NPQ_CFG				0x000BFD80 /* Reset Source: PCIR */
#define GLPCI_NPQ_CFG_EXTEND_TO_S		0
#define GLPCI_NPQ_CFG_EXTEND_TO_M		BIT(0)
#define GLPCI_NPQ_CFG_SMALL_TO_S		1
#define GLPCI_NPQ_CFG_SMALL_TO_M		BIT(1)
#define GLPCI_NPQ_CFG_WEIGHT_AVG_S		2
#define GLPCI_NPQ_CFG_WEIGHT_AVG_M		MAKEMASK(0xF, 2)
#define GLPCI_NPQ_CFG_NPQ_SPARE_S		6
#define GLPCI_NPQ_CFG_NPQ_SPARE_M		MAKEMASK(0x3FF, 6)
#define GLPCI_NPQ_CFG_NPQ_ERR_STAT_S		16
#define GLPCI_NPQ_CFG_NPQ_ERR_STAT_M		MAKEMASK(0xF, 16)
#define GLPCI_PKTCT_NP_C			0x000BFD9C /* Reset Source: PCIR */
#define GLPCI_PKTCT_NP_C_PCI_COUNT_BW_PCT_S	0
#define GLPCI_PKTCT_NP_C_PCI_COUNT_BW_PCT_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLPCI_PKTCT_P				0x0009E9B0 /* Reset Source: PCIR */
#define GLPCI_PKTCT_P_PCI_COUNT_BW_PCT_S	0
#define GLPCI_PKTCT_P_PCI_COUNT_BW_PCT_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLPCI_PMSUP				0x0009DE94 /* Reset Source: PCIR */
#define GLPCI_PMSUP_RESERVED_0_S		0
#define GLPCI_PMSUP_RESERVED_0_M		MAKEMASK(0x3, 0)
#define GLPCI_PMSUP_RESERVED_1_S		2
#define GLPCI_PMSUP_RESERVED_1_M		MAKEMASK(0x7, 2)
#define GLPCI_PMSUP_RESERVED_2_S		5
#define GLPCI_PMSUP_RESERVED_2_M		MAKEMASK(0x7, 5)
#define GLPCI_PMSUP_L0S_ACC_LAT_S		8
#define GLPCI_PMSUP_L0S_ACC_LAT_M		MAKEMASK(0x7, 8)
#define GLPCI_PMSUP_L1_ACC_LAT_S		11
#define GLPCI_PMSUP_L1_ACC_LAT_M		MAKEMASK(0x7, 11)
#define GLPCI_PMSUP_RESERVED_3_S		14
#define GLPCI_PMSUP_RESERVED_3_M		BIT(14)
#define GLPCI_PMSUP_OBFF_SUP_S			15
#define GLPCI_PMSUP_OBFF_SUP_M			MAKEMASK(0x3, 15)
#define GLPCI_PUSH_PE_IF_TO_STATUS		0x0009DF44 /* Reset Source: PCIR */
#define GLPCI_PUSH_PE_IF_TO_STATUS_GLPCI_PUSH_PE_IF_TO_STATUS_S 0
#define GLPCI_PUSH_PE_IF_TO_STATUS_GLPCI_PUSH_PE_IF_TO_STATUS_M BIT(0)
#define GLPCI_PWRDATA				0x0009DE7C /* Reset Source: PCIR */
#define GLPCI_PWRDATA_D0_POWER_S		0
#define GLPCI_PWRDATA_D0_POWER_M		MAKEMASK(0xFF, 0)
#define GLPCI_PWRDATA_COMM_POWER_S		8
#define GLPCI_PWRDATA_COMM_POWER_M		MAKEMASK(0xFF, 8)
#define GLPCI_PWRDATA_D3_POWER_S		16
#define GLPCI_PWRDATA_D3_POWER_M		MAKEMASK(0xFF, 16)
#define GLPCI_PWRDATA_DATA_SCALE_S		24
#define GLPCI_PWRDATA_DATA_SCALE_M		MAKEMASK(0x3, 24)
#define GLPCI_REVID				0x0009DE98 /* Reset Source: PCIR */
#define GLPCI_REVID_NVM_REVID_S			0
#define GLPCI_REVID_NVM_REVID_M			MAKEMASK(0xFF, 0)
#define GLPCI_SERH				0x0009DE84 /* Reset Source: PCIR */
#define GLPCI_SERH_SER_NUM_H_S			0
#define GLPCI_SERH_SER_NUM_H_M			MAKEMASK(0xFFFF, 0)
#define GLPCI_SERL				0x0009DE80 /* Reset Source: PCIR */
#define GLPCI_SERL_SER_NUM_L_S			0
#define GLPCI_SERL_SER_NUM_L_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLPCI_SUBVENID				0x0009DEE8 /* Reset Source: PCIR */
#define GLPCI_SUBVENID_SUB_VEN_ID_S		0
#define GLPCI_SUBVENID_SUB_VEN_ID_M		MAKEMASK(0xFFFF, 0)
#define GLPCI_UPADD				0x000BE0D4 /* Reset Source: PCIR */
#define GLPCI_UPADD_ADDRESS_S			1
#define GLPCI_UPADD_ADDRESS_M			MAKEMASK(0x7FFFFFFF, 1)
#define GLPCI_VENDORID				0x0009DEC8 /* Reset Source: PCIR */
#define GLPCI_VENDORID_VENDORID_S		0
#define GLPCI_VENDORID_VENDORID_M		MAKEMASK(0xFFFF, 0)
#define GLPCI_VFSUP				0x0009DE9C /* Reset Source: PCIR */
#define GLPCI_VFSUP_VF_PREFETCH_S		0
#define GLPCI_VFSUP_VF_PREFETCH_M		BIT(0)
#define GLPCI_VFSUP_VR_BAR_TYPE_S		1
#define GLPCI_VFSUP_VR_BAR_TYPE_M		BIT(1)
#define GLPCI_WATMK_CLNT_PIPEMON		0x000BFD90 /* Reset Source: PCIR */
#define GLPCI_WATMK_CLNT_PIPEMON_DATA_LINES_S	0
#define GLPCI_WATMK_CLNT_PIPEMON_DATA_LINES_M	MAKEMASK(0xFFFF, 0)
#define PF_FUNC_RID				0x0009E880 /* Reset Source: PCIR */
#define PF_FUNC_RID_FUNCTION_NUMBER_S		0
#define PF_FUNC_RID_FUNCTION_NUMBER_M		MAKEMASK(0x7, 0)
#define PF_FUNC_RID_DEVICE_NUMBER_S		3
#define PF_FUNC_RID_DEVICE_NUMBER_M		MAKEMASK(0x1F, 3)
#define PF_FUNC_RID_BUS_NUMBER_S		8
#define PF_FUNC_RID_BUS_NUMBER_M		MAKEMASK(0xFF, 8)
#define PF_PCI_CIAA				0x0009E580 /* Reset Source: FLR */
#define PF_PCI_CIAA_ADDRESS_S			0
#define PF_PCI_CIAA_ADDRESS_M			MAKEMASK(0xFFF, 0)
#define PF_PCI_CIAA_VF_NUM_S			12
#define PF_PCI_CIAA_VF_NUM_M			MAKEMASK(0xFF, 12)
#define PF_PCI_CIAD				0x0009E500 /* Reset Source: FLR */
#define PF_PCI_CIAD_DATA_S			0
#define PF_PCI_CIAD_DATA_M			MAKEMASK(0xFFFFFFFF, 0)
#define PFPCI_CLASS				0x0009DB00 /* Reset Source: PCIR */
#define PFPCI_CLASS_STORAGE_CLASS_S		0
#define PFPCI_CLASS_STORAGE_CLASS_M		BIT(0)
#define PFPCI_CLASS_PF_IS_LAN_S			2
#define PFPCI_CLASS_PF_IS_LAN_M			BIT(2)
#define PFPCI_CNF				0x0009DF00 /* Reset Source: PCIR */
#define PFPCI_CNF_MSI_EN_S			2
#define PFPCI_CNF_MSI_EN_M			BIT(2)
#define PFPCI_CNF_EXROM_DIS_S			3
#define PFPCI_CNF_EXROM_DIS_M			BIT(3)
#define PFPCI_CNF_IO_BAR_S			4
#define PFPCI_CNF_IO_BAR_M			BIT(4)
#define PFPCI_CNF_INT_PIN_S			5
#define PFPCI_CNF_INT_PIN_M			MAKEMASK(0x3, 5)
#define PFPCI_DEVID				0x0009DE00 /* Reset Source: PCIR */
#define PFPCI_DEVID_PF_DEV_ID_S			0
#define PFPCI_DEVID_PF_DEV_ID_M			MAKEMASK(0xFFFF, 0)
#define PFPCI_DEVID_VF_DEV_ID_S			16
#define PFPCI_DEVID_VF_DEV_ID_M			MAKEMASK(0xFFFF, 16)
#define PFPCI_FACTPS				0x0009E900 /* Reset Source: FLR */
#define PFPCI_FACTPS_FUNC_POWER_STATE_S		0
#define PFPCI_FACTPS_FUNC_POWER_STATE_M		MAKEMASK(0x3, 0)
#define PFPCI_FACTPS_FUNC_AUX_EN_S		3
#define PFPCI_FACTPS_FUNC_AUX_EN_M		BIT(3)
#define PFPCI_FUNC				0x0009D980 /* Reset Source: POR */
#define PFPCI_FUNC_FUNC_DIS_S			0
#define PFPCI_FUNC_FUNC_DIS_M			BIT(0)
#define PFPCI_FUNC_ALLOW_FUNC_DIS_S		1
#define PFPCI_FUNC_ALLOW_FUNC_DIS_M		BIT(1)
#define PFPCI_FUNC_DIS_FUNC_ON_PORT_DIS_S	2
#define PFPCI_FUNC_DIS_FUNC_ON_PORT_DIS_M	BIT(2)
#define PFPCI_PF_FLUSH_DONE			0x0009E400 /* Reset Source: PCIR */
#define PFPCI_PF_FLUSH_DONE_FLUSH_DONE_S	0
#define PFPCI_PF_FLUSH_DONE_FLUSH_DONE_M	BIT(0)
#define PFPCI_PM				0x0009DA80 /* Reset Source: POR */
#define PFPCI_PM_PME_EN_S			0
#define PFPCI_PM_PME_EN_M			BIT(0)
#define PFPCI_STATUS1				0x0009DA00 /* Reset Source: POR */
#define PFPCI_STATUS1_FUNC_VALID_S		0
#define PFPCI_STATUS1_FUNC_VALID_M		BIT(0)
#define PFPCI_SUBSYSID				0x0009D880 /* Reset Source: PCIR */
#define PFPCI_SUBSYSID_PF_SUBSYS_ID_S		0
#define PFPCI_SUBSYSID_PF_SUBSYS_ID_M		MAKEMASK(0xFFFF, 0)
#define PFPCI_SUBSYSID_VF_SUBSYS_ID_S		16
#define PFPCI_SUBSYSID_VF_SUBSYS_ID_M		MAKEMASK(0xFFFF, 16)
#define PFPCI_VF_FLUSH_DONE(_VF)		(0x0009E000 + ((_VF) * 4)) /* _i=0...255 */ /* Reset Source: PCIR */
#define PFPCI_VF_FLUSH_DONE_MAX_INDEX		255
#define PFPCI_VF_FLUSH_DONE_FLUSH_DONE_S	0
#define PFPCI_VF_FLUSH_DONE_FLUSH_DONE_M	BIT(0)
#define PFPCI_VM_FLUSH_DONE			0x0009E480 /* Reset Source: PCIR */
#define PFPCI_VM_FLUSH_DONE_FLUSH_DONE_S	0
#define PFPCI_VM_FLUSH_DONE_FLUSH_DONE_M	BIT(0)
#define PFPCI_VMINDEX				0x0009E600 /* Reset Source: PCIR */
#define PFPCI_VMINDEX_VMINDEX_S			0
#define PFPCI_VMINDEX_VMINDEX_M			MAKEMASK(0x3FF, 0)
#define PFPCI_VMPEND				0x0009E800 /* Reset Source: PCIR */
#define PFPCI_VMPEND_PENDING_S			0
#define PFPCI_VMPEND_PENDING_M			BIT(0)
#define PQ_FIFO_STATUS				0x0009DF40 /* Reset Source: PCIR */
#define PQ_FIFO_STATUS_PQ_FIFO_COUNT_S		0
#define PQ_FIFO_STATUS_PQ_FIFO_COUNT_M		MAKEMASK(0x7FFFFFFF, 0)
#define PQ_FIFO_STATUS_PQ_FIFO_EMPTY_S		31
#define PQ_FIFO_STATUS_PQ_FIFO_EMPTY_M		BIT(31)
#define GLPE_CPUSTATUS0				0x0050BA5C /* Reset Source: CORER */
#define GLPE_CPUSTATUS0_PECPUSTATUS0_S		0
#define GLPE_CPUSTATUS0_PECPUSTATUS0_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLPE_CPUSTATUS1				0x0050BA60 /* Reset Source: CORER */
#define GLPE_CPUSTATUS1_PECPUSTATUS1_S		0
#define GLPE_CPUSTATUS1_PECPUSTATUS1_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLPE_CPUSTATUS2				0x0050BA64 /* Reset Source: CORER */
#define GLPE_CPUSTATUS2_PECPUSTATUS2_S		0
#define GLPE_CPUSTATUS2_PECPUSTATUS2_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLPE_MDQ_BASE(_i)			(0x00536000 + ((_i) * 4)) /* _i=0...511 */ /* Reset Source: CORER */
#define GLPE_MDQ_BASE_MAX_INDEX			511
#define GLPE_MDQ_BASE_MDOC_INDEX_S		0
#define GLPE_MDQ_BASE_MDOC_INDEX_M		MAKEMASK(0xFFFFFFF, 0)
#define GLPE_MDQ_PTR(_i)			(0x00537000 + ((_i) * 4)) /* _i=0...511 */ /* Reset Source: CORER */
#define GLPE_MDQ_PTR_MAX_INDEX			511
#define GLPE_MDQ_PTR_MDQ_HEAD_S			0
#define GLPE_MDQ_PTR_MDQ_HEAD_M			MAKEMASK(0x3FFF, 0)
#define GLPE_MDQ_PTR_MDQ_TAIL_S			16
#define GLPE_MDQ_PTR_MDQ_TAIL_M			MAKEMASK(0x3FFF, 16)
#define GLPE_MDQ_SIZE(_i)			(0x00536800 + ((_i) * 4)) /* _i=0...511 */ /* Reset Source: CORER */
#define GLPE_MDQ_SIZE_MAX_INDEX			511
#define GLPE_MDQ_SIZE_MDQ_SIZE_S		0
#define GLPE_MDQ_SIZE_MDQ_SIZE_M		MAKEMASK(0x3FFF, 0)
#define GLPE_PEPM_CTRL				0x0050C000 /* Reset Source: PERST */
#define GLPE_PEPM_CTRL_PEPM_ENABLE_S		0
#define GLPE_PEPM_CTRL_PEPM_ENABLE_M		BIT(0)
#define GLPE_PEPM_CTRL_PEPM_HALT_S		8
#define GLPE_PEPM_CTRL_PEPM_HALT_M		BIT(8)
#define GLPE_PEPM_CTRL_PEPM_PUSH_MARGIN_S	16
#define GLPE_PEPM_CTRL_PEPM_PUSH_MARGIN_M	MAKEMASK(0xFF, 16)
#define GLPE_PEPM_DEALLOC			0x0050C004 /* Reset Source: PERST */
#define GLPE_PEPM_DEALLOC_MDQ_CREDITS_S		0
#define GLPE_PEPM_DEALLOC_MDQ_CREDITS_M		MAKEMASK(0x3FFF, 0)
#define GLPE_PEPM_DEALLOC_PSQ_CREDITS_S		14
#define GLPE_PEPM_DEALLOC_PSQ_CREDITS_M		MAKEMASK(0x1F, 14)
#define GLPE_PEPM_DEALLOC_PQID_S		19
#define GLPE_PEPM_DEALLOC_PQID_M		MAKEMASK(0x1FF, 19)
#define GLPE_PEPM_DEALLOC_PORT_S		28
#define GLPE_PEPM_DEALLOC_PORT_M		MAKEMASK(0x7, 28)
#define GLPE_PEPM_DEALLOC_DEALLOC_RDY_S		31
#define GLPE_PEPM_DEALLOC_DEALLOC_RDY_M		BIT(31)
#define GLPE_PEPM_PSQ_COUNT			0x0050C020 /* Reset Source: PERST */
#define GLPE_PEPM_PSQ_COUNT_PEPM_PSQ_COUNT_S	0
#define GLPE_PEPM_PSQ_COUNT_PEPM_PSQ_COUNT_M	MAKEMASK(0xFFFF, 0)
#define GLPE_PEPM_THRESH(_i)			(0x0050C840 + ((_i) * 4)) /* _i=0...511 */ /* Reset Source: PERST */
#define GLPE_PEPM_THRESH_MAX_INDEX		511
#define GLPE_PEPM_THRESH_PEPM_PSQ_THRESH_S	0
#define GLPE_PEPM_THRESH_PEPM_PSQ_THRESH_M	MAKEMASK(0x1F, 0)
#define GLPE_PEPM_THRESH_PEPM_MDQ_THRESH_S	16
#define GLPE_PEPM_THRESH_PEPM_MDQ_THRESH_M	MAKEMASK(0x3FFF, 16)
#define GLPE_PFAEQEDROPCNT(_i)			(0x00503240 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPE_PFAEQEDROPCNT_MAX_INDEX		7
#define GLPE_PFAEQEDROPCNT_AEQEDROPCNT_S	0
#define GLPE_PFAEQEDROPCNT_AEQEDROPCNT_M	MAKEMASK(0xFFFF, 0)
#define GLPE_PFCEQEDROPCNT(_i)			(0x00503220 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPE_PFCEQEDROPCNT_MAX_INDEX		7
#define GLPE_PFCEQEDROPCNT_CEQEDROPCNT_S	0
#define GLPE_PFCEQEDROPCNT_CEQEDROPCNT_M	MAKEMASK(0xFFFF, 0)
#define GLPE_PFCQEDROPCNT(_i)			(0x00503200 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPE_PFCQEDROPCNT_MAX_INDEX		7
#define GLPE_PFCQEDROPCNT_CQEDROPCNT_S		0
#define GLPE_PFCQEDROPCNT_CQEDROPCNT_M		MAKEMASK(0xFFFF, 0)
#define GLPE_PFFLMOOISCALLOCERR(_i)		(0x0050B960 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPE_PFFLMOOISCALLOCERR_MAX_INDEX	7
#define GLPE_PFFLMOOISCALLOCERR_ERROR_COUNT_S	0
#define GLPE_PFFLMOOISCALLOCERR_ERROR_COUNT_M	MAKEMASK(0xFFFF, 0)
#define GLPE_PFFLMQ1ALLOCERR(_i)		(0x0050B920 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPE_PFFLMQ1ALLOCERR_MAX_INDEX		7
#define GLPE_PFFLMQ1ALLOCERR_ERROR_COUNT_S	0
#define GLPE_PFFLMQ1ALLOCERR_ERROR_COUNT_M	MAKEMASK(0xFFFF, 0)
#define GLPE_PFFLMRRFALLOCERR(_i)		(0x0050B940 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPE_PFFLMRRFALLOCERR_MAX_INDEX		7
#define GLPE_PFFLMRRFALLOCERR_ERROR_COUNT_S	0
#define GLPE_PFFLMRRFALLOCERR_ERROR_COUNT_M	MAKEMASK(0xFFFF, 0)
#define GLPE_PFFLMXMITALLOCERR(_i)		(0x0050B900 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPE_PFFLMXMITALLOCERR_MAX_INDEX	7
#define GLPE_PFFLMXMITALLOCERR_ERROR_COUNT_S	0
#define GLPE_PFFLMXMITALLOCERR_ERROR_COUNT_M	MAKEMASK(0xFFFF, 0)
#define GLPE_PFTCPNOW50USCNT(_i)		(0x0050B8C0 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPE_PFTCPNOW50USCNT_MAX_INDEX		7
#define GLPE_PFTCPNOW50USCNT_CNT_S		0
#define GLPE_PFTCPNOW50USCNT_CNT_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLPE_PUSH_PEPM				0x0053241C /* Reset Source: CORER */
#define GLPE_PUSH_PEPM_MDQ_CREDITS_S		0
#define GLPE_PUSH_PEPM_MDQ_CREDITS_M		MAKEMASK(0xFF, 0)
#define GLPE_VFAEQEDROPCNT(_i)			(0x00503100 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLPE_VFAEQEDROPCNT_MAX_INDEX		31
#define GLPE_VFAEQEDROPCNT_AEQEDROPCNT_S	0
#define GLPE_VFAEQEDROPCNT_AEQEDROPCNT_M	MAKEMASK(0xFFFF, 0)
#define GLPE_VFCEQEDROPCNT(_i)			(0x00503080 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLPE_VFCEQEDROPCNT_MAX_INDEX		31
#define GLPE_VFCEQEDROPCNT_CEQEDROPCNT_S	0
#define GLPE_VFCEQEDROPCNT_CEQEDROPCNT_M	MAKEMASK(0xFFFF, 0)
#define GLPE_VFCQEDROPCNT(_i)			(0x00503000 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLPE_VFCQEDROPCNT_MAX_INDEX		31
#define GLPE_VFCQEDROPCNT_CQEDROPCNT_S		0
#define GLPE_VFCQEDROPCNT_CQEDROPCNT_M		MAKEMASK(0xFFFF, 0)
#define GLPE_VFFLMOOISCALLOCERR(_i)		(0x0050B580 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLPE_VFFLMOOISCALLOCERR_MAX_INDEX	31
#define GLPE_VFFLMOOISCALLOCERR_ERROR_COUNT_S	0
#define GLPE_VFFLMOOISCALLOCERR_ERROR_COUNT_M	MAKEMASK(0xFFFF, 0)
#define GLPE_VFFLMQ1ALLOCERR(_i)		(0x0050B480 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLPE_VFFLMQ1ALLOCERR_MAX_INDEX		31
#define GLPE_VFFLMQ1ALLOCERR_ERROR_COUNT_S	0
#define GLPE_VFFLMQ1ALLOCERR_ERROR_COUNT_M	MAKEMASK(0xFFFF, 0)
#define GLPE_VFFLMRRFALLOCERR(_i)		(0x0050B500 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLPE_VFFLMRRFALLOCERR_MAX_INDEX		31
#define GLPE_VFFLMRRFALLOCERR_ERROR_COUNT_S	0
#define GLPE_VFFLMRRFALLOCERR_ERROR_COUNT_M	MAKEMASK(0xFFFF, 0)
#define GLPE_VFFLMXMITALLOCERR(_i)		(0x0050B400 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLPE_VFFLMXMITALLOCERR_MAX_INDEX	31
#define GLPE_VFFLMXMITALLOCERR_ERROR_COUNT_S	0
#define GLPE_VFFLMXMITALLOCERR_ERROR_COUNT_M	MAKEMASK(0xFFFF, 0)
#define GLPE_VFTCPNOW50USCNT(_i)		(0x0050B300 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: PE_CORER */
#define GLPE_VFTCPNOW50USCNT_MAX_INDEX		31
#define GLPE_VFTCPNOW50USCNT_CNT_S		0
#define GLPE_VFTCPNOW50USCNT_CNT_M		MAKEMASK(0xFFFFFFFF, 0)
#define PFPE_AEQALLOC				0x00502D00 /* Reset Source: PFR */
#define PFPE_AEQALLOC_AECOUNT_S			0
#define PFPE_AEQALLOC_AECOUNT_M			MAKEMASK(0xFFFFFFFF, 0)
#define PFPE_CCQPHIGH				0x0050A100 /* Reset Source: PFR */
#define PFPE_CCQPHIGH_PECCQPHIGH_S		0
#define PFPE_CCQPHIGH_PECCQPHIGH_M		MAKEMASK(0xFFFFFFFF, 0)
#define PFPE_CCQPLOW				0x0050A080 /* Reset Source: PFR */
#define PFPE_CCQPLOW_PECCQPLOW_S		0
#define PFPE_CCQPLOW_PECCQPLOW_M		MAKEMASK(0xFFFFFFFF, 0)
#define PFPE_CCQPSTATUS				0x0050A000 /* Reset Source: PFR */
#define PFPE_CCQPSTATUS_CCQP_DONE_S		0
#define PFPE_CCQPSTATUS_CCQP_DONE_M		BIT(0)
#define PFPE_CCQPSTATUS_HMC_PROFILE_S		4
#define PFPE_CCQPSTATUS_HMC_PROFILE_M		MAKEMASK(0x7, 4)
#define PFPE_CCQPSTATUS_RDMA_EN_VFS_S		16
#define PFPE_CCQPSTATUS_RDMA_EN_VFS_M		MAKEMASK(0x3F, 16)
#define PFPE_CCQPSTATUS_CCQP_ERR_S		31
#define PFPE_CCQPSTATUS_CCQP_ERR_M		BIT(31)
#define PFPE_CQACK				0x00502C80 /* Reset Source: PFR */
#define PFPE_CQACK_PECQID_S			0
#define PFPE_CQACK_PECQID_M			MAKEMASK(0x7FFFF, 0)
#define PFPE_CQARM				0x00502C00 /* Reset Source: PFR */
#define PFPE_CQARM_PECQID_S			0
#define PFPE_CQARM_PECQID_M			MAKEMASK(0x7FFFF, 0)
#define PFPE_CQPDB				0x00500800 /* Reset Source: PFR */
#define PFPE_CQPDB_WQHEAD_S			0
#define PFPE_CQPDB_WQHEAD_M			MAKEMASK(0x7FF, 0)
#define PFPE_CQPERRCODES			0x0050A200 /* Reset Source: PFR */
#define PFPE_CQPERRCODES_CQP_MINOR_CODE_S	0
#define PFPE_CQPERRCODES_CQP_MINOR_CODE_M	MAKEMASK(0xFFFF, 0)
#define PFPE_CQPERRCODES_CQP_MAJOR_CODE_S	16
#define PFPE_CQPERRCODES_CQP_MAJOR_CODE_M	MAKEMASK(0xFFFF, 16)
#define PFPE_CQPTAIL				0x00500880 /* Reset Source: PFR */
#define PFPE_CQPTAIL_WQTAIL_S			0
#define PFPE_CQPTAIL_WQTAIL_M			MAKEMASK(0x7FF, 0)
#define PFPE_CQPTAIL_CQP_OP_ERR_S		31
#define PFPE_CQPTAIL_CQP_OP_ERR_M		BIT(31)
#define PFPE_IPCONFIG0				0x0050A180 /* Reset Source: PFR */
#define PFPE_IPCONFIG0_PEIPID_S			0
#define PFPE_IPCONFIG0_PEIPID_M			MAKEMASK(0xFFFF, 0)
#define PFPE_IPCONFIG0_USEENTIREIDRANGE_S	16
#define PFPE_IPCONFIG0_USEENTIREIDRANGE_M	BIT(16)
#define PFPE_IPCONFIG0_UDP_SRC_PORT_MASK_EN_S	17
#define PFPE_IPCONFIG0_UDP_SRC_PORT_MASK_EN_M	BIT(17)
#define PFPE_MRTEIDXMASK			0x0050A300 /* Reset Source: PFR */
#define PFPE_MRTEIDXMASK_MRTEIDXMASKBITS_S	0
#define PFPE_MRTEIDXMASK_MRTEIDXMASKBITS_M	MAKEMASK(0x1F, 0)
#define PFPE_RCVUNEXPECTEDERROR			0x0050A380 /* Reset Source: PFR */
#define PFPE_RCVUNEXPECTEDERROR_TCP_RX_UNEXP_ERR_S 0
#define PFPE_RCVUNEXPECTEDERROR_TCP_RX_UNEXP_ERR_M MAKEMASK(0xFFFFFF, 0)
#define PFPE_TCPNOWTIMER			0x0050A280 /* Reset Source: PFR */
#define PFPE_TCPNOWTIMER_TCP_NOW_S		0
#define PFPE_TCPNOWTIMER_TCP_NOW_M		MAKEMASK(0xFFFFFFFF, 0)
#define PFPE_WQEALLOC				0x00504400 /* Reset Source: PFR */
#define PFPE_WQEALLOC_PEQPID_S			0
#define PFPE_WQEALLOC_PEQPID_M			MAKEMASK(0x3FFFF, 0)
#define PFPE_WQEALLOC_WQE_DESC_INDEX_S		20
#define PFPE_WQEALLOC_WQE_DESC_INDEX_M		MAKEMASK(0xFFF, 20)
#define PRT_PEPM_COUNT(_i)			(0x0050C040 + ((_i) * 4)) /* _i=0...511 */ /* Reset Source: PERST */
#define PRT_PEPM_COUNT_MAX_INDEX		511
#define PRT_PEPM_COUNT_PEPM_PSQ_COUNT_S		0
#define PRT_PEPM_COUNT_PEPM_PSQ_COUNT_M		MAKEMASK(0x1F, 0)
#define PRT_PEPM_COUNT_PEPM_MDQ_COUNT_S		16
#define PRT_PEPM_COUNT_PEPM_MDQ_COUNT_M		MAKEMASK(0x3FFF, 16)
#define VFPE_AEQALLOC(_VF)			(0x00502800 + ((_VF) * 4)) /* _i=0...255 */ /* Reset Source: PFR */
#define VFPE_AEQALLOC_MAX_INDEX			255
#define VFPE_AEQALLOC_AECOUNT_S			0
#define VFPE_AEQALLOC_AECOUNT_M			MAKEMASK(0xFFFFFFFF, 0)
#define VFPE_CCQPHIGH(_VF)			(0x00508800 + ((_VF) * 4)) /* _i=0...255 */ /* Reset Source: PFR */
#define VFPE_CCQPHIGH_MAX_INDEX			255
#define VFPE_CCQPHIGH_PECCQPHIGH_S		0
#define VFPE_CCQPHIGH_PECCQPHIGH_M		MAKEMASK(0xFFFFFFFF, 0)
#define VFPE_CCQPLOW(_VF)			(0x00508400 + ((_VF) * 4)) /* _i=0...255 */ /* Reset Source: PFR */
#define VFPE_CCQPLOW_MAX_INDEX			255
#define VFPE_CCQPLOW_PECCQPLOW_S		0
#define VFPE_CCQPLOW_PECCQPLOW_M		MAKEMASK(0xFFFFFFFF, 0)
#define VFPE_CCQPSTATUS(_VF)			(0x00508000 + ((_VF) * 4)) /* _i=0...255 */ /* Reset Source: PFR */
#define VFPE_CCQPSTATUS_MAX_INDEX		255
#define VFPE_CCQPSTATUS_CCQP_DONE_S		0
#define VFPE_CCQPSTATUS_CCQP_DONE_M		BIT(0)
#define VFPE_CCQPSTATUS_HMC_PROFILE_S		4
#define VFPE_CCQPSTATUS_HMC_PROFILE_M		MAKEMASK(0x7, 4)
#define VFPE_CCQPSTATUS_RDMA_EN_VFS_S		16
#define VFPE_CCQPSTATUS_RDMA_EN_VFS_M		MAKEMASK(0x3F, 16)
#define VFPE_CCQPSTATUS_CCQP_ERR_S		31
#define VFPE_CCQPSTATUS_CCQP_ERR_M		BIT(31)
#define VFPE_CQACK(_VF)				(0x00502400 + ((_VF) * 4)) /* _i=0...255 */ /* Reset Source: PFR */
#define VFPE_CQACK_MAX_INDEX			255
#define VFPE_CQACK_PECQID_S			0
#define VFPE_CQACK_PECQID_M			MAKEMASK(0x7FFFF, 0)
#define VFPE_CQARM(_VF)				(0x00502000 + ((_VF) * 4)) /* _i=0...255 */ /* Reset Source: PFR */
#define VFPE_CQARM_MAX_INDEX			255
#define VFPE_CQARM_PECQID_S			0
#define VFPE_CQARM_PECQID_M			MAKEMASK(0x7FFFF, 0)
#define VFPE_CQPDB(_VF)				(0x00500000 + ((_VF) * 4)) /* _i=0...255 */ /* Reset Source: PFR */
#define VFPE_CQPDB_MAX_INDEX			255
#define VFPE_CQPDB_WQHEAD_S			0
#define VFPE_CQPDB_WQHEAD_M			MAKEMASK(0x7FF, 0)
#define VFPE_CQPERRCODES(_VF)			(0x00509000 + ((_VF) * 4)) /* _i=0...255 */ /* Reset Source: PFR */
#define VFPE_CQPERRCODES_MAX_INDEX		255
#define VFPE_CQPERRCODES_CQP_MINOR_CODE_S	0
#define VFPE_CQPERRCODES_CQP_MINOR_CODE_M	MAKEMASK(0xFFFF, 0)
#define VFPE_CQPERRCODES_CQP_MAJOR_CODE_S	16
#define VFPE_CQPERRCODES_CQP_MAJOR_CODE_M	MAKEMASK(0xFFFF, 16)
#define VFPE_CQPTAIL(_VF)			(0x00500400 + ((_VF) * 4)) /* _i=0...255 */ /* Reset Source: PFR */
#define VFPE_CQPTAIL_MAX_INDEX			255
#define VFPE_CQPTAIL_WQTAIL_S			0
#define VFPE_CQPTAIL_WQTAIL_M			MAKEMASK(0x7FF, 0)
#define VFPE_CQPTAIL_CQP_OP_ERR_S		31
#define VFPE_CQPTAIL_CQP_OP_ERR_M		BIT(31)
#define VFPE_IPCONFIG0(_VF)			(0x00508C00 + ((_VF) * 4)) /* _i=0...255 */ /* Reset Source: PFR */
#define VFPE_IPCONFIG0_MAX_INDEX		255
#define VFPE_IPCONFIG0_PEIPID_S			0
#define VFPE_IPCONFIG0_PEIPID_M			MAKEMASK(0xFFFF, 0)
#define VFPE_IPCONFIG0_USEENTIREIDRANGE_S	16
#define VFPE_IPCONFIG0_USEENTIREIDRANGE_M	BIT(16)
#define VFPE_IPCONFIG0_UDP_SRC_PORT_MASK_EN_S	17
#define VFPE_IPCONFIG0_UDP_SRC_PORT_MASK_EN_M	BIT(17)
#define VFPE_RCVUNEXPECTEDERROR(_VF)		(0x00509C00 + ((_VF) * 4)) /* _i=0...255 */ /* Reset Source: PFR */
#define VFPE_RCVUNEXPECTEDERROR_MAX_INDEX	255
#define VFPE_RCVUNEXPECTEDERROR_TCP_RX_UNEXP_ERR_S 0
#define VFPE_RCVUNEXPECTEDERROR_TCP_RX_UNEXP_ERR_M MAKEMASK(0xFFFFFF, 0)
#define VFPE_TCPNOWTIMER(_VF)			(0x00509400 + ((_VF) * 4)) /* _i=0...255 */ /* Reset Source: PFR */
#define VFPE_TCPNOWTIMER_MAX_INDEX		255
#define VFPE_TCPNOWTIMER_TCP_NOW_S		0
#define VFPE_TCPNOWTIMER_TCP_NOW_M		MAKEMASK(0xFFFFFFFF, 0)
#define VFPE_WQEALLOC(_VF)			(0x00504000 + ((_VF) * 4)) /* _i=0...255 */ /* Reset Source: PFR */
#define VFPE_WQEALLOC_MAX_INDEX			255
#define VFPE_WQEALLOC_PEQPID_S			0
#define VFPE_WQEALLOC_PEQPID_M			MAKEMASK(0x3FFFF, 0)
#define VFPE_WQEALLOC_WQE_DESC_INDEX_S		20
#define VFPE_WQEALLOC_WQE_DESC_INDEX_M		MAKEMASK(0xFFF, 20)
#define GLPES_PFIP4RXDISCARD(_i)		(0x00541400 + ((_i) * 4)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFIP4RXDISCARD_MAX_INDEX		127
#define GLPES_PFIP4RXDISCARD_IP4RXDISCARD_S	0
#define GLPES_PFIP4RXDISCARD_IP4RXDISCARD_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLPES_PFIP4RXFRAGSHI(_i)		(0x00541C04 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFIP4RXFRAGSHI_MAX_INDEX		127
#define GLPES_PFIP4RXFRAGSHI_IP4RXFRAGSHI_S	0
#define GLPES_PFIP4RXFRAGSHI_IP4RXFRAGSHI_M	MAKEMASK(0xFFFF, 0)
#define GLPES_PFIP4RXFRAGSLO(_i)		(0x00541C00 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFIP4RXFRAGSLO_MAX_INDEX		127
#define GLPES_PFIP4RXFRAGSLO_IP4RXFRAGSLO_S	0
#define GLPES_PFIP4RXFRAGSLO_IP4RXFRAGSLO_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLPES_PFIP4RXMCOCTSHI(_i)		(0x00542404 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFIP4RXMCOCTSHI_MAX_INDEX		127
#define GLPES_PFIP4RXMCOCTSHI_IP4RXMCOCTSHI_S	0
#define GLPES_PFIP4RXMCOCTSHI_IP4RXMCOCTSHI_M	MAKEMASK(0xFFFF, 0)
#define GLPES_PFIP4RXMCOCTSLO(_i)		(0x00542400 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFIP4RXMCOCTSLO_MAX_INDEX		127
#define GLPES_PFIP4RXMCOCTSLO_IP4RXMCOCTSLO_S	0
#define GLPES_PFIP4RXMCOCTSLO_IP4RXMCOCTSLO_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLPES_PFIP4RXMCPKTSHI(_i)		(0x00542C04 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFIP4RXMCPKTSHI_MAX_INDEX		127
#define GLPES_PFIP4RXMCPKTSHI_IP4RXMCPKTSHI_S	0
#define GLPES_PFIP4RXMCPKTSHI_IP4RXMCPKTSHI_M	MAKEMASK(0xFFFF, 0)
#define GLPES_PFIP4RXMCPKTSLO(_i)		(0x00542C00 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFIP4RXMCPKTSLO_MAX_INDEX		127
#define GLPES_PFIP4RXMCPKTSLO_IP4RXMCPKTSLO_S	0
#define GLPES_PFIP4RXMCPKTSLO_IP4RXMCPKTSLO_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLPES_PFIP4RXOCTSHI(_i)			(0x00540404 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFIP4RXOCTSHI_MAX_INDEX		127
#define GLPES_PFIP4RXOCTSHI_IP4RXOCTSHI_S	0
#define GLPES_PFIP4RXOCTSHI_IP4RXOCTSHI_M	MAKEMASK(0xFFFF, 0)
#define GLPES_PFIP4RXOCTSLO(_i)			(0x00540400 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFIP4RXOCTSLO_MAX_INDEX		127
#define GLPES_PFIP4RXOCTSLO_IP4RXOCTSLO_S	0
#define GLPES_PFIP4RXOCTSLO_IP4RXOCTSLO_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLPES_PFIP4RXPKTSHI(_i)			(0x00540C04 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFIP4RXPKTSHI_MAX_INDEX		127
#define GLPES_PFIP4RXPKTSHI_IP4RXPKTSHI_S	0
#define GLPES_PFIP4RXPKTSHI_IP4RXPKTSHI_M	MAKEMASK(0xFFFF, 0)
#define GLPES_PFIP4RXPKTSLO(_i)			(0x00540C00 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFIP4RXPKTSLO_MAX_INDEX		127
#define GLPES_PFIP4RXPKTSLO_IP4RXPKTSLO_S	0
#define GLPES_PFIP4RXPKTSLO_IP4RXPKTSLO_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLPES_PFIP4RXTRUNC(_i)			(0x00541800 + ((_i) * 4)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFIP4RXTRUNC_MAX_INDEX		127
#define GLPES_PFIP4RXTRUNC_IP4RXTRUNC_S		0
#define GLPES_PFIP4RXTRUNC_IP4RXTRUNC_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLPES_PFIP4TXFRAGSHI(_i)		(0x00547404 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFIP4TXFRAGSHI_MAX_INDEX		127
#define GLPES_PFIP4TXFRAGSHI_IP4TXFRAGSHI_S	0
#define GLPES_PFIP4TXFRAGSHI_IP4TXFRAGSHI_M	MAKEMASK(0xFFFF, 0)
#define GLPES_PFIP4TXFRAGSLO(_i)		(0x00547400 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFIP4TXFRAGSLO_MAX_INDEX		127
#define GLPES_PFIP4TXFRAGSLO_IP4TXFRAGSLO_S	0
#define GLPES_PFIP4TXFRAGSLO_IP4TXFRAGSLO_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLPES_PFIP4TXMCOCTSHI(_i)		(0x00547C04 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFIP4TXMCOCTSHI_MAX_INDEX		127
#define GLPES_PFIP4TXMCOCTSHI_IP4TXMCOCTSHI_S	0
#define GLPES_PFIP4TXMCOCTSHI_IP4TXMCOCTSHI_M	MAKEMASK(0xFFFF, 0)
#define GLPES_PFIP4TXMCOCTSLO(_i)		(0x00547C00 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFIP4TXMCOCTSLO_MAX_INDEX		127
#define GLPES_PFIP4TXMCOCTSLO_IP4TXMCOCTSLO_S	0
#define GLPES_PFIP4TXMCOCTSLO_IP4TXMCOCTSLO_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLPES_PFIP4TXMCPKTSHI(_i)		(0x00548404 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFIP4TXMCPKTSHI_MAX_INDEX		127
#define GLPES_PFIP4TXMCPKTSHI_IP4TXMCPKTSHI_S	0
#define GLPES_PFIP4TXMCPKTSHI_IP4TXMCPKTSHI_M	MAKEMASK(0xFFFF, 0)
#define GLPES_PFIP4TXMCPKTSLO(_i)		(0x00548400 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFIP4TXMCPKTSLO_MAX_INDEX		127
#define GLPES_PFIP4TXMCPKTSLO_IP4TXMCPKTSLO_S	0
#define GLPES_PFIP4TXMCPKTSLO_IP4TXMCPKTSLO_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLPES_PFIP4TXNOROUTE(_i)		(0x0054B400 + ((_i) * 4)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFIP4TXNOROUTE_MAX_INDEX		127
#define GLPES_PFIP4TXNOROUTE_IP4TXNOROUTE_S	0
#define GLPES_PFIP4TXNOROUTE_IP4TXNOROUTE_M	MAKEMASK(0xFFFFFF, 0)
#define GLPES_PFIP4TXOCTSHI(_i)			(0x00546404 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFIP4TXOCTSHI_MAX_INDEX		127
#define GLPES_PFIP4TXOCTSHI_IP4TXOCTSHI_S	0
#define GLPES_PFIP4TXOCTSHI_IP4TXOCTSHI_M	MAKEMASK(0xFFFF, 0)
#define GLPES_PFIP4TXOCTSLO(_i)			(0x00546400 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFIP4TXOCTSLO_MAX_INDEX		127
#define GLPES_PFIP4TXOCTSLO_IP4TXOCTSLO_S	0
#define GLPES_PFIP4TXOCTSLO_IP4TXOCTSLO_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLPES_PFIP4TXPKTSHI(_i)			(0x00546C04 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFIP4TXPKTSHI_MAX_INDEX		127
#define GLPES_PFIP4TXPKTSHI_IP4TXPKTSHI_S	0
#define GLPES_PFIP4TXPKTSHI_IP4TXPKTSHI_M	MAKEMASK(0xFFFF, 0)
#define GLPES_PFIP4TXPKTSLO(_i)			(0x00546C00 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFIP4TXPKTSLO_MAX_INDEX		127
#define GLPES_PFIP4TXPKTSLO_IP4TXPKTSLO_S	0
#define GLPES_PFIP4TXPKTSLO_IP4TXPKTSLO_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLPES_PFIP6RXDISCARD(_i)		(0x00544400 + ((_i) * 4)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFIP6RXDISCARD_MAX_INDEX		127
#define GLPES_PFIP6RXDISCARD_IP6RXDISCARD_S	0
#define GLPES_PFIP6RXDISCARD_IP6RXDISCARD_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLPES_PFIP6RXFRAGSHI(_i)		(0x00544C04 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFIP6RXFRAGSHI_MAX_INDEX		127
#define GLPES_PFIP6RXFRAGSHI_IP6RXFRAGSHI_S	0
#define GLPES_PFIP6RXFRAGSHI_IP6RXFRAGSHI_M	MAKEMASK(0xFFFF, 0)
#define GLPES_PFIP6RXFRAGSLO(_i)		(0x00544C00 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFIP6RXFRAGSLO_MAX_INDEX		127
#define GLPES_PFIP6RXFRAGSLO_IP6RXFRAGSLO_S	0
#define GLPES_PFIP6RXFRAGSLO_IP6RXFRAGSLO_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLPES_PFIP6RXMCOCTSHI(_i)		(0x00545404 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFIP6RXMCOCTSHI_MAX_INDEX		127
#define GLPES_PFIP6RXMCOCTSHI_IP6RXMCOCTSHI_S	0
#define GLPES_PFIP6RXMCOCTSHI_IP6RXMCOCTSHI_M	MAKEMASK(0xFFFF, 0)
#define GLPES_PFIP6RXMCOCTSLO(_i)		(0x00545400 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFIP6RXMCOCTSLO_MAX_INDEX		127
#define GLPES_PFIP6RXMCOCTSLO_IP6RXMCOCTSLO_S	0
#define GLPES_PFIP6RXMCOCTSLO_IP6RXMCOCTSLO_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLPES_PFIP6RXMCPKTSHI(_i)		(0x00545C04 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFIP6RXMCPKTSHI_MAX_INDEX		127
#define GLPES_PFIP6RXMCPKTSHI_IP6RXMCPKTSHI_S	0
#define GLPES_PFIP6RXMCPKTSHI_IP6RXMCPKTSHI_M	MAKEMASK(0xFFFF, 0)
#define GLPES_PFIP6RXMCPKTSLO(_i)		(0x00545C00 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFIP6RXMCPKTSLO_MAX_INDEX		127
#define GLPES_PFIP6RXMCPKTSLO_IP6RXMCPKTSLO_S	0
#define GLPES_PFIP6RXMCPKTSLO_IP6RXMCPKTSLO_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLPES_PFIP6RXOCTSHI(_i)			(0x00543404 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFIP6RXOCTSHI_MAX_INDEX		127
#define GLPES_PFIP6RXOCTSHI_IP6RXOCTSHI_S	0
#define GLPES_PFIP6RXOCTSHI_IP6RXOCTSHI_M	MAKEMASK(0xFFFF, 0)
#define GLPES_PFIP6RXOCTSLO(_i)			(0x00543400 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFIP6RXOCTSLO_MAX_INDEX		127
#define GLPES_PFIP6RXOCTSLO_IP6RXOCTSLO_S	0
#define GLPES_PFIP6RXOCTSLO_IP6RXOCTSLO_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLPES_PFIP6RXPKTSHI(_i)			(0x00543C04 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFIP6RXPKTSHI_MAX_INDEX		127
#define GLPES_PFIP6RXPKTSHI_IP6RXPKTSHI_S	0
#define GLPES_PFIP6RXPKTSHI_IP6RXPKTSHI_M	MAKEMASK(0xFFFF, 0)
#define GLPES_PFIP6RXPKTSLO(_i)			(0x00543C00 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFIP6RXPKTSLO_MAX_INDEX		127
#define GLPES_PFIP6RXPKTSLO_IP6RXPKTSLO_S	0
#define GLPES_PFIP6RXPKTSLO_IP6RXPKTSLO_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLPES_PFIP6RXTRUNC(_i)			(0x00544800 + ((_i) * 4)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFIP6RXTRUNC_MAX_INDEX		127
#define GLPES_PFIP6RXTRUNC_IP6RXTRUNC_S		0
#define GLPES_PFIP6RXTRUNC_IP6RXTRUNC_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLPES_PFIP6TXFRAGSHI(_i)		(0x00549C04 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFIP6TXFRAGSHI_MAX_INDEX		127
#define GLPES_PFIP6TXFRAGSHI_IP6TXFRAGSHI_S	0
#define GLPES_PFIP6TXFRAGSHI_IP6TXFRAGSHI_M	MAKEMASK(0xFFFF, 0)
#define GLPES_PFIP6TXFRAGSLO(_i)		(0x00549C00 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFIP6TXFRAGSLO_MAX_INDEX		127
#define GLPES_PFIP6TXFRAGSLO_IP6TXFRAGSLO_S	0
#define GLPES_PFIP6TXFRAGSLO_IP6TXFRAGSLO_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLPES_PFIP6TXMCOCTSHI(_i)		(0x0054A404 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFIP6TXMCOCTSHI_MAX_INDEX		127
#define GLPES_PFIP6TXMCOCTSHI_IP6TXMCOCTSHI_S	0
#define GLPES_PFIP6TXMCOCTSHI_IP6TXMCOCTSHI_M	MAKEMASK(0xFFFF, 0)
#define GLPES_PFIP6TXMCOCTSLO(_i)		(0x0054A400 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFIP6TXMCOCTSLO_MAX_INDEX		127
#define GLPES_PFIP6TXMCOCTSLO_IP6TXMCOCTSLO_S	0
#define GLPES_PFIP6TXMCOCTSLO_IP6TXMCOCTSLO_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLPES_PFIP6TXMCPKTSHI(_i)		(0x0054AC04 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFIP6TXMCPKTSHI_MAX_INDEX		127
#define GLPES_PFIP6TXMCPKTSHI_IP6TXMCPKTSHI_S	0
#define GLPES_PFIP6TXMCPKTSHI_IP6TXMCPKTSHI_M	MAKEMASK(0xFFFF, 0)
#define GLPES_PFIP6TXMCPKTSLO(_i)		(0x0054AC00 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFIP6TXMCPKTSLO_MAX_INDEX		127
#define GLPES_PFIP6TXMCPKTSLO_IP6TXMCPKTSLO_S	0
#define GLPES_PFIP6TXMCPKTSLO_IP6TXMCPKTSLO_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLPES_PFIP6TXNOROUTE(_i)		(0x0054B800 + ((_i) * 4)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFIP6TXNOROUTE_MAX_INDEX		127
#define GLPES_PFIP6TXNOROUTE_IP6TXNOROUTE_S	0
#define GLPES_PFIP6TXNOROUTE_IP6TXNOROUTE_M	MAKEMASK(0xFFFFFF, 0)
#define GLPES_PFIP6TXOCTSHI(_i)			(0x00548C04 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFIP6TXOCTSHI_MAX_INDEX		127
#define GLPES_PFIP6TXOCTSHI_IP6TXOCTSHI_S	0
#define GLPES_PFIP6TXOCTSHI_IP6TXOCTSHI_M	MAKEMASK(0xFFFF, 0)
#define GLPES_PFIP6TXOCTSLO(_i)			(0x00548C00 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFIP6TXOCTSLO_MAX_INDEX		127
#define GLPES_PFIP6TXOCTSLO_IP6TXOCTSLO_S	0
#define GLPES_PFIP6TXOCTSLO_IP6TXOCTSLO_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLPES_PFIP6TXPKTSHI(_i)			(0x00549404 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFIP6TXPKTSHI_MAX_INDEX		127
#define GLPES_PFIP6TXPKTSHI_IP6TXPKTSHI_S	0
#define GLPES_PFIP6TXPKTSHI_IP6TXPKTSHI_M	MAKEMASK(0xFFFF, 0)
#define GLPES_PFIP6TXPKTSLO(_i)			(0x00549400 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFIP6TXPKTSLO_MAX_INDEX		127
#define GLPES_PFIP6TXPKTSLO_IP6TXPKTSLO_S	0
#define GLPES_PFIP6TXPKTSLO_IP6TXPKTSLO_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLPES_PFRDMARXRDSHI(_i)			(0x0054EC04 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFRDMARXRDSHI_MAX_INDEX		127
#define GLPES_PFRDMARXRDSHI_RDMARXRDSHI_S	0
#define GLPES_PFRDMARXRDSHI_RDMARXRDSHI_M	MAKEMASK(0xFFFF, 0)
#define GLPES_PFRDMARXRDSLO(_i)			(0x0054EC00 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFRDMARXRDSLO_MAX_INDEX		127
#define GLPES_PFRDMARXRDSLO_RDMARXRDSLO_S	0
#define GLPES_PFRDMARXRDSLO_RDMARXRDSLO_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLPES_PFRDMARXSNDSHI(_i)		(0x0054F404 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFRDMARXSNDSHI_MAX_INDEX		127
#define GLPES_PFRDMARXSNDSHI_RDMARXSNDSHI_S	0
#define GLPES_PFRDMARXSNDSHI_RDMARXSNDSHI_M	MAKEMASK(0xFFFF, 0)
#define GLPES_PFRDMARXSNDSLO(_i)		(0x0054F400 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFRDMARXSNDSLO_MAX_INDEX		127
#define GLPES_PFRDMARXSNDSLO_RDMARXSNDSLO_S	0
#define GLPES_PFRDMARXSNDSLO_RDMARXSNDSLO_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLPES_PFRDMARXWRSHI(_i)			(0x0054E404 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFRDMARXWRSHI_MAX_INDEX		127
#define GLPES_PFRDMARXWRSHI_RDMARXWRSHI_S	0
#define GLPES_PFRDMARXWRSHI_RDMARXWRSHI_M	MAKEMASK(0xFFFF, 0)
#define GLPES_PFRDMARXWRSLO(_i)			(0x0054E400 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFRDMARXWRSLO_MAX_INDEX		127
#define GLPES_PFRDMARXWRSLO_RDMARXWRSLO_S	0
#define GLPES_PFRDMARXWRSLO_RDMARXWRSLO_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLPES_PFRDMATXRDSHI(_i)			(0x00550404 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFRDMATXRDSHI_MAX_INDEX		127
#define GLPES_PFRDMATXRDSHI_RDMARXRDSHI_S	0
#define GLPES_PFRDMATXRDSHI_RDMARXRDSHI_M	MAKEMASK(0xFFFF, 0)
#define GLPES_PFRDMATXRDSLO(_i)			(0x00550400 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFRDMATXRDSLO_MAX_INDEX		127
#define GLPES_PFRDMATXRDSLO_RDMARXRDSLO_S	0
#define GLPES_PFRDMATXRDSLO_RDMARXRDSLO_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLPES_PFRDMATXSNDSHI(_i)		(0x00550C04 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFRDMATXSNDSHI_MAX_INDEX		127
#define GLPES_PFRDMATXSNDSHI_RDMARXSNDSHI_S	0
#define GLPES_PFRDMATXSNDSHI_RDMARXSNDSHI_M	MAKEMASK(0xFFFF, 0)
#define GLPES_PFRDMATXSNDSLO(_i)		(0x00550C00 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFRDMATXSNDSLO_MAX_INDEX		127
#define GLPES_PFRDMATXSNDSLO_RDMARXSNDSLO_S	0
#define GLPES_PFRDMATXSNDSLO_RDMARXSNDSLO_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLPES_PFRDMATXWRSHI(_i)			(0x0054FC04 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFRDMATXWRSHI_MAX_INDEX		127
#define GLPES_PFRDMATXWRSHI_RDMARXWRSHI_S	0
#define GLPES_PFRDMATXWRSHI_RDMARXWRSHI_M	MAKEMASK(0xFFFF, 0)
#define GLPES_PFRDMATXWRSLO(_i)			(0x0054FC00 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFRDMATXWRSLO_MAX_INDEX		127
#define GLPES_PFRDMATXWRSLO_RDMARXWRSLO_S	0
#define GLPES_PFRDMATXWRSLO_RDMARXWRSLO_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLPES_PFRDMAVBNDHI(_i)			(0x00551404 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFRDMAVBNDHI_MAX_INDEX		127
#define GLPES_PFRDMAVBNDHI_RDMAVBNDHI_S		0
#define GLPES_PFRDMAVBNDHI_RDMAVBNDHI_M		MAKEMASK(0xFFFF, 0)
#define GLPES_PFRDMAVBNDLO(_i)			(0x00551400 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFRDMAVBNDLO_MAX_INDEX		127
#define GLPES_PFRDMAVBNDLO_RDMAVBNDLO_S		0
#define GLPES_PFRDMAVBNDLO_RDMAVBNDLO_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLPES_PFRDMAVINVHI(_i)			(0x00551C04 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFRDMAVINVHI_MAX_INDEX		127
#define GLPES_PFRDMAVINVHI_RDMAVINVHI_S		0
#define GLPES_PFRDMAVINVHI_RDMAVINVHI_M		MAKEMASK(0xFFFF, 0)
#define GLPES_PFRDMAVINVLO(_i)			(0x00551C00 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFRDMAVINVLO_MAX_INDEX		127
#define GLPES_PFRDMAVINVLO_RDMAVINVLO_S		0
#define GLPES_PFRDMAVINVLO_RDMAVINVLO_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLPES_PFRXVLANERR(_i)			(0x00540000 + ((_i) * 4)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFRXVLANERR_MAX_INDEX		127
#define GLPES_PFRXVLANERR_RXVLANERR_S		0
#define GLPES_PFRXVLANERR_RXVLANERR_M		MAKEMASK(0xFFFFFF, 0)
#define GLPES_PFTCPRTXSEG(_i)			(0x00552400 + ((_i) * 4)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFTCPRTXSEG_MAX_INDEX		127
#define GLPES_PFTCPRTXSEG_TCPRTXSEG_S		0
#define GLPES_PFTCPRTXSEG_TCPRTXSEG_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLPES_PFTCPRXOPTERR(_i)			(0x0054C400 + ((_i) * 4)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFTCPRXOPTERR_MAX_INDEX		127
#define GLPES_PFTCPRXOPTERR_TCPRXOPTERR_S	0
#define GLPES_PFTCPRXOPTERR_TCPRXOPTERR_M	MAKEMASK(0xFFFFFF, 0)
#define GLPES_PFTCPRXPROTOERR(_i)		(0x0054C800 + ((_i) * 4)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFTCPRXPROTOERR_MAX_INDEX		127
#define GLPES_PFTCPRXPROTOERR_TCPRXPROTOERR_S	0
#define GLPES_PFTCPRXPROTOERR_TCPRXPROTOERR_M	MAKEMASK(0xFFFFFF, 0)
#define GLPES_PFTCPRXSEGSHI(_i)			(0x0054BC04 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFTCPRXSEGSHI_MAX_INDEX		127
#define GLPES_PFTCPRXSEGSHI_TCPRXSEGSHI_S	0
#define GLPES_PFTCPRXSEGSHI_TCPRXSEGSHI_M	MAKEMASK(0xFFFF, 0)
#define GLPES_PFTCPRXSEGSLO(_i)			(0x0054BC00 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFTCPRXSEGSLO_MAX_INDEX		127
#define GLPES_PFTCPRXSEGSLO_TCPRXSEGSLO_S	0
#define GLPES_PFTCPRXSEGSLO_TCPRXSEGSLO_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLPES_PFTCPTXSEGHI(_i)			(0x0054CC04 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFTCPTXSEGHI_MAX_INDEX		127
#define GLPES_PFTCPTXSEGHI_TCPTXSEGHI_S		0
#define GLPES_PFTCPTXSEGHI_TCPTXSEGHI_M		MAKEMASK(0xFFFF, 0)
#define GLPES_PFTCPTXSEGLO(_i)			(0x0054CC00 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFTCPTXSEGLO_MAX_INDEX		127
#define GLPES_PFTCPTXSEGLO_TCPTXSEGLO_S		0
#define GLPES_PFTCPTXSEGLO_TCPTXSEGLO_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLPES_PFUDPRXPKTSHI(_i)			(0x0054D404 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFUDPRXPKTSHI_MAX_INDEX		127
#define GLPES_PFUDPRXPKTSHI_UDPRXPKTSHI_S	0
#define GLPES_PFUDPRXPKTSHI_UDPRXPKTSHI_M	MAKEMASK(0xFFFF, 0)
#define GLPES_PFUDPRXPKTSLO(_i)			(0x0054D400 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFUDPRXPKTSLO_MAX_INDEX		127
#define GLPES_PFUDPRXPKTSLO_UDPRXPKTSLO_S	0
#define GLPES_PFUDPRXPKTSLO_UDPRXPKTSLO_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLPES_PFUDPTXPKTSHI(_i)			(0x0054DC04 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFUDPTXPKTSHI_MAX_INDEX		127
#define GLPES_PFUDPTXPKTSHI_UDPTXPKTSHI_S	0
#define GLPES_PFUDPTXPKTSHI_UDPTXPKTSHI_M	MAKEMASK(0xFFFF, 0)
#define GLPES_PFUDPTXPKTSLO(_i)			(0x0054DC00 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLPES_PFUDPTXPKTSLO_MAX_INDEX		127
#define GLPES_PFUDPTXPKTSLO_UDPTXPKTSLO_S	0
#define GLPES_PFUDPTXPKTSLO_UDPTXPKTSLO_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLPES_RDMARXMULTFPDUSHI			0x0055E00C /* Reset Source: CORER */
#define GLPES_RDMARXMULTFPDUSHI_RDMARXMULTFPDUSHI_S 0
#define GLPES_RDMARXMULTFPDUSHI_RDMARXMULTFPDUSHI_M MAKEMASK(0xFFFFFF, 0)
#define GLPES_RDMARXMULTFPDUSLO			0x0055E008 /* Reset Source: CORER */
#define GLPES_RDMARXMULTFPDUSLO_RDMARXMULTFPDUSLO_S 0
#define GLPES_RDMARXMULTFPDUSLO_RDMARXMULTFPDUSLO_M MAKEMASK(0xFFFFFFFF, 0)
#define GLPES_RDMARXOOODDPHI			0x0055E014 /* Reset Source: CORER */
#define GLPES_RDMARXOOODDPHI_RDMARXOOODDPHI_S	0
#define GLPES_RDMARXOOODDPHI_RDMARXOOODDPHI_M	MAKEMASK(0xFFFFFF, 0)
#define GLPES_RDMARXOOODDPLO			0x0055E010 /* Reset Source: CORER */
#define GLPES_RDMARXOOODDPLO_RDMARXOOODDPLO_S	0
#define GLPES_RDMARXOOODDPLO_RDMARXOOODDPLO_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLPES_RDMARXOOONOMARK			0x0055E004 /* Reset Source: CORER */
#define GLPES_RDMARXOOONOMARK_RDMAOOONOMARK_S	0
#define GLPES_RDMARXOOONOMARK_RDMAOOONOMARK_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLPES_RDMARXUNALIGN			0x0055E000 /* Reset Source: CORER */
#define GLPES_RDMARXUNALIGN_RDMRXAUNALIGN_S	0
#define GLPES_RDMARXUNALIGN_RDMRXAUNALIGN_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLPES_TCPRXFOURHOLEHI			0x0055E03C /* Reset Source: CORER */
#define GLPES_TCPRXFOURHOLEHI_TCPRXFOURHOLEHI_S 0
#define GLPES_TCPRXFOURHOLEHI_TCPRXFOURHOLEHI_M MAKEMASK(0xFFFFFF, 0)
#define GLPES_TCPRXFOURHOLELO			0x0055E038 /* Reset Source: CORER */
#define GLPES_TCPRXFOURHOLELO_TCPRXFOURHOLELO_S 0
#define GLPES_TCPRXFOURHOLELO_TCPRXFOURHOLELO_M MAKEMASK(0xFFFFFFFF, 0)
#define GLPES_TCPRXONEHOLEHI			0x0055E024 /* Reset Source: CORER */
#define GLPES_TCPRXONEHOLEHI_TCPRXONEHOLEHI_S	0
#define GLPES_TCPRXONEHOLEHI_TCPRXONEHOLEHI_M	MAKEMASK(0xFFFFFF, 0)
#define GLPES_TCPRXONEHOLELO			0x0055E020 /* Reset Source: CORER */
#define GLPES_TCPRXONEHOLELO_TCPRXONEHOLELO_S	0
#define GLPES_TCPRXONEHOLELO_TCPRXONEHOLELO_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLPES_TCPRXPUREACKHI			0x0055E01C /* Reset Source: CORER */
#define GLPES_TCPRXPUREACKHI_TCPRXPUREACKSHI_S	0
#define GLPES_TCPRXPUREACKHI_TCPRXPUREACKSHI_M	MAKEMASK(0xFFFFFF, 0)
#define GLPES_TCPRXPUREACKSLO			0x0055E018 /* Reset Source: CORER */
#define GLPES_TCPRXPUREACKSLO_TCPRXPUREACKLO_S	0
#define GLPES_TCPRXPUREACKSLO_TCPRXPUREACKLO_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLPES_TCPRXTHREEHOLEHI			0x0055E034 /* Reset Source: CORER */
#define GLPES_TCPRXTHREEHOLEHI_TCPRXTHREEHOLEHI_S 0
#define GLPES_TCPRXTHREEHOLEHI_TCPRXTHREEHOLEHI_M MAKEMASK(0xFFFFFF, 0)
#define GLPES_TCPRXTHREEHOLELO			0x0055E030 /* Reset Source: CORER */
#define GLPES_TCPRXTHREEHOLELO_TCPRXTHREEHOLELO_S 0
#define GLPES_TCPRXTHREEHOLELO_TCPRXTHREEHOLELO_M MAKEMASK(0xFFFFFFFF, 0)
#define GLPES_TCPRXTWOHOLEHI			0x0055E02C /* Reset Source: CORER */
#define GLPES_TCPRXTWOHOLEHI_TCPRXTWOHOLEHI_S	0
#define GLPES_TCPRXTWOHOLEHI_TCPRXTWOHOLEHI_M	MAKEMASK(0xFFFFFF, 0)
#define GLPES_TCPRXTWOHOLELO			0x0055E028 /* Reset Source: CORER */
#define GLPES_TCPRXTWOHOLELO_TCPRXTWOHOLELO_S	0
#define GLPES_TCPRXTWOHOLELO_TCPRXTWOHOLELO_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLPES_TCPTXRETRANSFASTHI		0x0055E044 /* Reset Source: CORER */
#define GLPES_TCPTXRETRANSFASTHI_TCPTXRETRANSFASTHI_S 0
#define GLPES_TCPTXRETRANSFASTHI_TCPTXRETRANSFASTHI_M MAKEMASK(0xFFFFFF, 0)
#define GLPES_TCPTXRETRANSFASTLO		0x0055E040 /* Reset Source: CORER */
#define GLPES_TCPTXRETRANSFASTLO_TCPTXRETRANSFASTLO_S 0
#define GLPES_TCPTXRETRANSFASTLO_TCPTXRETRANSFASTLO_M MAKEMASK(0xFFFFFFFF, 0)
#define GLPES_TCPTXTOUTSFASTHI			0x0055E04C /* Reset Source: CORER */
#define GLPES_TCPTXTOUTSFASTHI_TCPTXTOUTSFASTHI_S 0
#define GLPES_TCPTXTOUTSFASTHI_TCPTXTOUTSFASTHI_M MAKEMASK(0xFFFFFF, 0)
#define GLPES_TCPTXTOUTSFASTLO			0x0055E048 /* Reset Source: CORER */
#define GLPES_TCPTXTOUTSFASTLO_TCPTXTOUTSFASTLO_S 0
#define GLPES_TCPTXTOUTSFASTLO_TCPTXTOUTSFASTLO_M MAKEMASK(0xFFFFFFFF, 0)
#define GLPES_TCPTXTOUTSHI			0x0055E054 /* Reset Source: CORER */
#define GLPES_TCPTXTOUTSHI_TCPTXTOUTSHI_S	0
#define GLPES_TCPTXTOUTSHI_TCPTXTOUTSHI_M	MAKEMASK(0xFFFFFF, 0)
#define GLPES_TCPTXTOUTSLO			0x0055E050 /* Reset Source: CORER */
#define GLPES_TCPTXTOUTSLO_TCPTXTOUTSLO_S	0
#define GLPES_TCPTXTOUTSLO_TCPTXTOUTSLO_M	MAKEMASK(0xFFFFFFFF, 0)
#define GL_PWR_MODE_CTL				0x000B820C /* Reset Source: POR */
#define GL_PWR_MODE_CTL_SWITCH_PWR_MODE_EN_S	0
#define GL_PWR_MODE_CTL_SWITCH_PWR_MODE_EN_M	BIT(0)
#define GL_PWR_MODE_CTL_NIC_PWR_MODE_EN_S	1
#define GL_PWR_MODE_CTL_NIC_PWR_MODE_EN_M	BIT(1)
#define GL_PWR_MODE_CTL_S5_PWR_MODE_EN_S	2
#define GL_PWR_MODE_CTL_S5_PWR_MODE_EN_M	BIT(2)
#define GL_PWR_MODE_CTL_CAR_MAX_SW_CONFIG_S	3
#define GL_PWR_MODE_CTL_CAR_MAX_SW_CONFIG_M	MAKEMASK(0x3, 3)
#define GL_PWR_MODE_CTL_CAR_MAX_BW_S		30
#define GL_PWR_MODE_CTL_CAR_MAX_BW_M		MAKEMASK(0x3, 30)
#define GL_PWR_MODE_DIVIDE_CTRL_H_DEFAULT	0x000B825C /* Reset Source: POR */
#define GL_PWR_MODE_DIVIDE_CTRL_H_DEFAULT_DEFAULT_DIV_VAL_PECLK_S 0
#define GL_PWR_MODE_DIVIDE_CTRL_H_DEFAULT_DEFAULT_DIV_VAL_PECLK_M MAKEMASK(0x7, 0)
#define GL_PWR_MODE_DIVIDE_CTRL_H_DEFAULT_DEFAULT_DIV_VAL_UCLK_S 3
#define GL_PWR_MODE_DIVIDE_CTRL_H_DEFAULT_DEFAULT_DIV_VAL_UCLK_M MAKEMASK(0x7, 3)
#define GL_PWR_MODE_DIVIDE_CTRL_H_DEFAULT_DEFAULT_DIV_VAL_LCLK_S 6
#define GL_PWR_MODE_DIVIDE_CTRL_H_DEFAULT_DEFAULT_DIV_VAL_LCLK_M MAKEMASK(0x7, 6)
#define GL_PWR_MODE_DIVIDE_CTRL_H_DEFAULT_DEFAULT_DIV_VAL_PSM_S 9
#define GL_PWR_MODE_DIVIDE_CTRL_H_DEFAULT_DEFAULT_DIV_VAL_PSM_M MAKEMASK(0x7, 9)
#define GL_PWR_MODE_DIVIDE_CTRL_H_DEFAULT_DEFAULT_DIV_VAL_RXCTL_S 12
#define GL_PWR_MODE_DIVIDE_CTRL_H_DEFAULT_DEFAULT_DIV_VAL_RXCTL_M MAKEMASK(0x7, 12)
#define GL_PWR_MODE_DIVIDE_CTRL_H_DEFAULT_DEFAULT_DIV_VAL_UANA_S 15
#define GL_PWR_MODE_DIVIDE_CTRL_H_DEFAULT_DEFAULT_DIV_VAL_UANA_M MAKEMASK(0x7, 15)
#define GL_PWR_MODE_DIVIDE_CTRL_H_DEFAULT_DEFAULT_DIV_VAL_S5_S 18
#define GL_PWR_MODE_DIVIDE_CTRL_H_DEFAULT_DEFAULT_DIV_VAL_S5_M MAKEMASK(0x7, 18)
#define GL_PWR_MODE_DIVIDE_CTRL_L_DEFAULT	0x000B8218 /* Reset Source: POR */
#define GL_PWR_MODE_DIVIDE_CTRL_L_DEFAULT_DEFAULT_DIV_VAL_PECLK_S 0
#define GL_PWR_MODE_DIVIDE_CTRL_L_DEFAULT_DEFAULT_DIV_VAL_PECLK_M MAKEMASK(0x7, 0)
#define GL_PWR_MODE_DIVIDE_CTRL_L_DEFAULT_DEFAULT_DIV_VAL_UCLK_S 3
#define GL_PWR_MODE_DIVIDE_CTRL_L_DEFAULT_DEFAULT_DIV_VAL_UCLK_M MAKEMASK(0x7, 3)
#define GL_PWR_MODE_DIVIDE_CTRL_L_DEFAULT_DEFAULT_DIV_VAL_LCLK_S 6
#define GL_PWR_MODE_DIVIDE_CTRL_L_DEFAULT_DEFAULT_DIV_VAL_LCLK_M MAKEMASK(0x7, 6)
#define GL_PWR_MODE_DIVIDE_CTRL_L_DEFAULT_DEFAULT_DIV_VAL_PSM_S 9
#define GL_PWR_MODE_DIVIDE_CTRL_L_DEFAULT_DEFAULT_DIV_VAL_PSM_M MAKEMASK(0x7, 9)
#define GL_PWR_MODE_DIVIDE_CTRL_L_DEFAULT_DEFAULT_DIV_VAL_RXCTL_S 12
#define GL_PWR_MODE_DIVIDE_CTRL_L_DEFAULT_DEFAULT_DIV_VAL_RXCTL_M MAKEMASK(0x7, 12)
#define GL_PWR_MODE_DIVIDE_CTRL_L_DEFAULT_DEFAULT_DIV_VAL_UANA_S 15
#define GL_PWR_MODE_DIVIDE_CTRL_L_DEFAULT_DEFAULT_DIV_VAL_UANA_M MAKEMASK(0x7, 15)
#define GL_PWR_MODE_DIVIDE_CTRL_L_DEFAULT_DEFAULT_DIV_VAL_S5_S 18
#define GL_PWR_MODE_DIVIDE_CTRL_L_DEFAULT_DEFAULT_DIV_VAL_S5_M MAKEMASK(0x7, 18)
#define GL_PWR_MODE_DIVIDE_CTRL_M_DEFAULT	0x000B8260 /* Reset Source: POR */
#define GL_PWR_MODE_DIVIDE_CTRL_M_DEFAULT_DEFAULT_DIV_VAL_PECLK_S 0
#define GL_PWR_MODE_DIVIDE_CTRL_M_DEFAULT_DEFAULT_DIV_VAL_PECLK_M MAKEMASK(0x7, 0)
#define GL_PWR_MODE_DIVIDE_CTRL_M_DEFAULT_DEFAULT_DIV_VAL_UCLK_S 3
#define GL_PWR_MODE_DIVIDE_CTRL_M_DEFAULT_DEFAULT_DIV_VAL_UCLK_M MAKEMASK(0x7, 3)
#define GL_PWR_MODE_DIVIDE_CTRL_M_DEFAULT_DEFAULT_DIV_VAL_LCLK_S 6
#define GL_PWR_MODE_DIVIDE_CTRL_M_DEFAULT_DEFAULT_DIV_VAL_LCLK_M MAKEMASK(0x7, 6)
#define GL_PWR_MODE_DIVIDE_CTRL_M_DEFAULT_DEFAULT_DIV_VAL_PSM_S 9
#define GL_PWR_MODE_DIVIDE_CTRL_M_DEFAULT_DEFAULT_DIV_VAL_PSM_M MAKEMASK(0x7, 9)
#define GL_PWR_MODE_DIVIDE_CTRL_M_DEFAULT_DEFAULT_DIV_VAL_RXCTL_S 12
#define GL_PWR_MODE_DIVIDE_CTRL_M_DEFAULT_DEFAULT_DIV_VAL_RXCTL_M MAKEMASK(0x7, 12)
#define GL_PWR_MODE_DIVIDE_CTRL_M_DEFAULT_DEFAULT_DIV_VAL_UANA_S 15
#define GL_PWR_MODE_DIVIDE_CTRL_M_DEFAULT_DEFAULT_DIV_VAL_UANA_M MAKEMASK(0x7, 15)
#define GL_PWR_MODE_DIVIDE_CTRL_M_DEFAULT_DEFAULT_DIV_VAL_S5_S 18
#define GL_PWR_MODE_DIVIDE_CTRL_M_DEFAULT_DEFAULT_DIV_VAL_S5_M MAKEMASK(0x7, 18)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_LCLK	0x000B8200 /* Reset Source: POR */
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_LCLK_DIV_VAL_TBW_50G_H_S 0
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_LCLK_DIV_VAL_TBW_50G_H_M MAKEMASK(0x7, 0)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_LCLK_DIV_VAL_TBW_25G_H_S 3
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_LCLK_DIV_VAL_TBW_25G_H_M MAKEMASK(0x7, 3)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_LCLK_DIV_VAL_TBW_10G_H_S 6
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_LCLK_DIV_VAL_TBW_10G_H_M MAKEMASK(0x7, 6)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_LCLK_DIV_VAL_TBW_4G_H_S 9
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_LCLK_DIV_VAL_TBW_4G_H_M MAKEMASK(0x7, 9)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_LCLK_DIV_VAL_TBW_A50G_H_S 12
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_LCLK_DIV_VAL_TBW_A50G_H_M MAKEMASK(0xF, 12)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_PECLK	0x000B81F0 /* Reset Source: POR */
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_PECLK_DIV_VAL_TBW_50G_H_S 0
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_PECLK_DIV_VAL_TBW_50G_H_M MAKEMASK(0x7, 0)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_PECLK_DIV_VAL_TBW_25G_H_S 3
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_PECLK_DIV_VAL_TBW_25G_H_M MAKEMASK(0x7, 3)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_PECLK_DIV_VAL_TBW_10G_H_S 6
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_PECLK_DIV_VAL_TBW_10G_H_M MAKEMASK(0x7, 6)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_PECLK_DIV_VAL_TBW_4G_H_S 9
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_PECLK_DIV_VAL_TBW_4G_H_M MAKEMASK(0x7, 9)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_PECLK_DIV_VAL_TBW_A50G_H_S 12
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_PECLK_DIV_VAL_TBW_A50G_H_M MAKEMASK(0xF, 12)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_PSM	0x000B81FC /* Reset Source: POR */
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_PSM_DIV_VAL_TBW_50G_H_S 0
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_PSM_DIV_VAL_TBW_50G_H_M MAKEMASK(0x7, 0)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_PSM_DIV_VAL_TBW_25G_H_S 3
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_PSM_DIV_VAL_TBW_25G_H_M MAKEMASK(0x7, 3)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_PSM_DIV_VAL_TBW_10G_H_S 6
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_PSM_DIV_VAL_TBW_10G_H_M MAKEMASK(0x7, 6)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_PSM_DIV_VAL_TBW_4G_H_S 9
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_PSM_DIV_VAL_TBW_4G_H_M MAKEMASK(0x7, 9)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_PSM_DIV_VAL_TBW_A50G_H_S 12
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_PSM_DIV_VAL_TBW_A50G_H_M MAKEMASK(0xF, 12)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_RXCTL	0x000B81F8 /* Reset Source: POR */
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_RXCTL_DIV_VAL_TBW_50G_H_S 0
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_RXCTL_DIV_VAL_TBW_50G_H_M MAKEMASK(0x7, 0)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_RXCTL_DIV_VAL_TBW_25G_H_S 3
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_RXCTL_DIV_VAL_TBW_25G_H_M MAKEMASK(0x7, 3)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_RXCTL_DIV_VAL_TBW_10G_H_S 6
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_RXCTL_DIV_VAL_TBW_10G_H_M MAKEMASK(0x7, 6)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_RXCTL_DIV_VAL_TBW_4G_H_S 9
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_RXCTL_DIV_VAL_TBW_4G_H_M MAKEMASK(0x7, 9)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_RXCTL_DIV_VAL_TBW_A50G_H_S 12
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_RXCTL_DIV_VAL_TBW_A50G_H_M MAKEMASK(0xF, 12)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_UANA	0x000B8208 /* Reset Source: POR */
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_UANA_DIV_VAL_TBW_50G_H_S 0
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_UANA_DIV_VAL_TBW_50G_H_M MAKEMASK(0x7, 0)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_UANA_DIV_VAL_TBW_25G_H_S 3
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_UANA_DIV_VAL_TBW_25G_H_M MAKEMASK(0x7, 3)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_UANA_DIV_VAL_TBW_10G_H_S 6
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_UANA_DIV_VAL_TBW_10G_H_M MAKEMASK(0x7, 6)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_UANA_DIV_VAL_TBW_4G_H_S 9
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_UANA_DIV_VAL_TBW_4G_H_M MAKEMASK(0x7, 9)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_UANA_DIV_VAL_TBW_A50G_H_S 12
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_UANA_DIV_VAL_TBW_A50G_H_M MAKEMASK(0xF, 12)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_UCLK	0x000B81F4 /* Reset Source: POR */
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_UCLK_DIV_VAL_TBW_50G_H_S 0
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_UCLK_DIV_VAL_TBW_50G_H_M MAKEMASK(0x7, 0)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_UCLK_DIV_VAL_TBW_25G_H_S 3
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_UCLK_DIV_VAL_TBW_25G_H_M MAKEMASK(0x7, 3)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_UCLK_DIV_VAL_TBW_10G_H_S 6
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_UCLK_DIV_VAL_TBW_10G_H_M MAKEMASK(0x7, 6)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_UCLK_DIV_VAL_TBW_4G_H_S 9
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_UCLK_DIV_VAL_TBW_4G_H_M MAKEMASK(0x7, 9)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_UCLK_DIV_VAL_TBW_A50G_H_S 12
#define GL_PWR_MODE_DIVIDE_S0_CTRL_H_UCLK_DIV_VAL_TBW_A50G_H_M MAKEMASK(0xF, 12)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_LCLK	0x000B8244 /* Reset Source: POR */
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_LCLK_DIV_VAL_TBW_50G_L_S 0
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_LCLK_DIV_VAL_TBW_50G_L_M MAKEMASK(0x7, 0)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_LCLK_DIV_VAL_TBW_25G_L_S 3
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_LCLK_DIV_VAL_TBW_25G_L_M MAKEMASK(0x7, 3)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_LCLK_DIV_VAL_TBW_10G_L_S 6
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_LCLK_DIV_VAL_TBW_10G_L_M MAKEMASK(0x7, 6)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_LCLK_DIV_VAL_TBW_4G_L_S 9
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_LCLK_DIV_VAL_TBW_4G_L_M MAKEMASK(0x7, 9)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_LCLK_DIV_VAL_TBW_A50G_L_S 12
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_LCLK_DIV_VAL_TBW_A50G_L_M MAKEMASK(0x7, 12)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_PECLK	0x000B8220 /* Reset Source: POR */
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_PECLK_DIV_VAL_TBW_50G_L_S 0
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_PECLK_DIV_VAL_TBW_50G_L_M MAKEMASK(0x7, 0)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_PECLK_DIV_VAL_TBW_25G_L_S 3
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_PECLK_DIV_VAL_TBW_25G_L_M MAKEMASK(0x7, 3)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_PECLK_DIV_VAL_TBW_10G_L_S 6
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_PECLK_DIV_VAL_TBW_10G_L_M MAKEMASK(0x7, 6)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_PECLK_DIV_VAL_TBW_4G_L_S 9
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_PECLK_DIV_VAL_TBW_4G_L_M MAKEMASK(0x7, 9)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_PECLK_DIV_VAL_TBW_A50G_L_S 12
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_PECLK_DIV_VAL_TBW_A50G_L_M MAKEMASK(0x7, 12)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_PSM	0x000B8240 /* Reset Source: POR */
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_PSM_DIV_VAL_TBW_50G_L_S 0
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_PSM_DIV_VAL_TBW_50G_L_M MAKEMASK(0x7, 0)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_PSM_DIV_VAL_TBW_25G_L_S 3
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_PSM_DIV_VAL_TBW_25G_L_M MAKEMASK(0x7, 3)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_PSM_DIV_VAL_TBW_10G_L_S 6
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_PSM_DIV_VAL_TBW_10G_L_M MAKEMASK(0x7, 6)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_PSM_DIV_VAL_TBW_4G_L_S 9
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_PSM_DIV_VAL_TBW_4G_L_M MAKEMASK(0x7, 9)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_PSM_DIV_VAL_TBW_A50G_L_S 12
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_PSM_DIV_VAL_TBW_A50G_L_M MAKEMASK(0x7, 12)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_RXCTL	0x000B823C /* Reset Source: POR */
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_RXCTL_DIV_VAL_TBW_50G_L_S 0
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_RXCTL_DIV_VAL_TBW_50G_L_M MAKEMASK(0x7, 0)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_RXCTL_DIV_VAL_TBW_25G_L_S 3
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_RXCTL_DIV_VAL_TBW_25G_L_M MAKEMASK(0x7, 3)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_RXCTL_DIV_VAL_TBW_10G_L_S 6
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_RXCTL_DIV_VAL_TBW_10G_L_M MAKEMASK(0x7, 6)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_RXCTL_DIV_VAL_TBW_4G_L_S 9
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_RXCTL_DIV_VAL_TBW_4G_L_M MAKEMASK(0x7, 9)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_RXCTL_DIV_VAL_TBW_A50G_L_S 12
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_RXCTL_DIV_VAL_TBW_A50G_L_M MAKEMASK(0x7, 12)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_UANA	0x000B8248 /* Reset Source: POR */
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_UANA_DIV_VAL_TBW_50G_L_S 0
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_UANA_DIV_VAL_TBW_50G_L_M MAKEMASK(0x7, 0)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_UANA_DIV_VAL_TBW_25G_L_S 3
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_UANA_DIV_VAL_TBW_25G_L_M MAKEMASK(0x7, 3)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_UANA_DIV_VAL_TBW_10G_L_S 6
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_UANA_DIV_VAL_TBW_10G_L_M MAKEMASK(0x7, 6)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_UANA_DIV_VAL_TBW_4G_L_S 9
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_UANA_DIV_VAL_TBW_4G_L_M MAKEMASK(0x7, 9)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_UANA_DIV_VAL_TBW_A50G_L_S 12
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_UANA_DIV_VAL_TBW_A50G_L_M MAKEMASK(0x7, 12)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_UCLK	0x000B8238 /* Reset Source: POR */
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_UCLK_DIV_VAL_TBW_50G_L_S 0
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_UCLK_DIV_VAL_TBW_50G_L_M MAKEMASK(0x7, 0)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_UCLK_DIV_VAL_TBW_25G_L_S 3
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_UCLK_DIV_VAL_TBW_25G_L_M MAKEMASK(0x7, 3)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_UCLK_DIV_VAL_TBW_10G_L_S 6
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_UCLK_DIV_VAL_TBW_10G_L_M MAKEMASK(0x7, 6)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_UCLK_DIV_VAL_TBW_4G_L_S 9
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_UCLK_DIV_VAL_TBW_4G_L_M MAKEMASK(0x7, 9)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_UCLK_DIV_VAL_TBW_A50G_L_S 12
#define GL_PWR_MODE_DIVIDE_S0_CTRL_L_UCLK_DIV_VAL_TBW_A50G_L_M MAKEMASK(0x7, 12)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_LCLK	0x000B8230 /* Reset Source: POR */
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_LCLK_DIV_VAL_TBW_50G_M_S 0
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_LCLK_DIV_VAL_TBW_50G_M_M MAKEMASK(0x7, 0)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_LCLK_DIV_VAL_TBW_25G_M_S 3
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_LCLK_DIV_VAL_TBW_25G_M_M MAKEMASK(0x7, 3)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_LCLK_DIV_VAL_TBW_10G_M_S 6
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_LCLK_DIV_VAL_TBW_10G_M_M MAKEMASK(0x7, 6)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_LCLK_DIV_VAL_TBW_4G_M_S 9
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_LCLK_DIV_VAL_TBW_4G_M_M MAKEMASK(0x7, 9)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_LCLK_DIV_VAL_TBW_A50G_M_S 12
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_LCLK_DIV_VAL_TBW_A50G_M_M MAKEMASK(0x7, 12)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_PECLK	0x000B821C /* Reset Source: POR */
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_PECLK_DIV_VAL_TBW_50G_M_S 0
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_PECLK_DIV_VAL_TBW_50G_M_M MAKEMASK(0x7, 0)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_PECLK_DIV_VAL_TBW_25G_M_S 3
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_PECLK_DIV_VAL_TBW_25G_M_M MAKEMASK(0x7, 3)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_PECLK_DIV_VAL_TBW_10G_M_S 6
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_PECLK_DIV_VAL_TBW_10G_M_M MAKEMASK(0x7, 6)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_PECLK_DIV_VAL_TBW_4G_M_S 9
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_PECLK_DIV_VAL_TBW_4G_M_M MAKEMASK(0x7, 9)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_PECLK_DIV_VAL_TBW_A50G_M_S 12
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_PECLK_DIV_VAL_TBW_A50G_M_M MAKEMASK(0x7, 12)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_PSM	0x000B822C /* Reset Source: POR */
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_PSM_DIV_VAL_TBW_50G_M_S 0
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_PSM_DIV_VAL_TBW_50G_M_M MAKEMASK(0x7, 0)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_PSM_DIV_VAL_TBW_25G_M_S 3
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_PSM_DIV_VAL_TBW_25G_M_M MAKEMASK(0x7, 3)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_PSM_DIV_VAL_TBW_10G_M_S 6
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_PSM_DIV_VAL_TBW_10G_M_M MAKEMASK(0x7, 6)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_PSM_DIV_VAL_TBW_4G_M_S 9
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_PSM_DIV_VAL_TBW_4G_M_M MAKEMASK(0x7, 9)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_PSM_DIV_VAL_TBW_A50G_M_S 12
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_PSM_DIV_VAL_TBW_A50G_M_M MAKEMASK(0x7, 12)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_RXCTL	0x000B8228 /* Reset Source: POR */
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_RXCTL_DIV_VAL_TBW_50G_M_S 0
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_RXCTL_DIV_VAL_TBW_50G_M_M MAKEMASK(0x7, 0)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_RXCTL_DIV_VAL_TBW_25G_M_S 3
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_RXCTL_DIV_VAL_TBW_25G_M_M MAKEMASK(0x7, 3)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_RXCTL_DIV_VAL_TBW_10G_M_S 6
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_RXCTL_DIV_VAL_TBW_10G_M_M MAKEMASK(0x7, 6)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_RXCTL_DIV_VAL_TBW_4G_M_S 9
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_RXCTL_DIV_VAL_TBW_4G_M_M MAKEMASK(0x7, 9)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_RXCTL_DIV_VAL_TBW_A50G_M_S 12
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_RXCTL_DIV_VAL_TBW_A50G_M_M MAKEMASK(0x7, 12)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_UANA	0x000B8234 /* Reset Source: POR */
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_UANA_DIV_VAL_TBW_50G_M_S 0
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_UANA_DIV_VAL_TBW_50G_M_M MAKEMASK(0x7, 0)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_UANA_DIV_VAL_TBW_25G_M_S 3
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_UANA_DIV_VAL_TBW_25G_M_M MAKEMASK(0x7, 3)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_UANA_DIV_VAL_TBW_10G_M_S 6
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_UANA_DIV_VAL_TBW_10G_M_M MAKEMASK(0x7, 6)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_UANA_DIV_VAL_TBW_4G_M_S 9
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_UANA_DIV_VAL_TBW_4G_M_M MAKEMASK(0x7, 9)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_UANA_DIV_VAL_TBW_A50G_M_S 12
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_UANA_DIV_VAL_TBW_A50G_M_M MAKEMASK(0x7, 12)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_UCLK	0x000B8224 /* Reset Source: POR */
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_UCLK_DIV_VAL_TBW_50G_M_S 0
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_UCLK_DIV_VAL_TBW_50G_M_M MAKEMASK(0x7, 0)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_UCLK_DIV_VAL_TBW_25G_M_S 3
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_UCLK_DIV_VAL_TBW_25G_M_M MAKEMASK(0x7, 3)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_UCLK_DIV_VAL_TBW_10G_M_S 6
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_UCLK_DIV_VAL_TBW_10G_M_M MAKEMASK(0x7, 6)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_UCLK_DIV_VAL_TBW_4G_M_S 9
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_UCLK_DIV_VAL_TBW_4G_M_M MAKEMASK(0x7, 9)
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_UCLK_DIV_VAL_TBW_A50G_M_S 12
#define GL_PWR_MODE_DIVIDE_S0_CTRL_M_UCLK_DIV_VAL_TBW_A50G_M_M MAKEMASK(0x7, 12)
#define GL_PWR_MODE_DIVIDE_S5_H_CTRL		0x000B81EC /* Reset Source: POR */
#define GL_PWR_MODE_DIVIDE_S5_H_CTRL_DIV_VAL_TBW_50G_H_S 0
#define GL_PWR_MODE_DIVIDE_S5_H_CTRL_DIV_VAL_TBW_50G_H_M MAKEMASK(0x7, 0)
#define GL_PWR_MODE_DIVIDE_S5_H_CTRL_DIV_VAL_TBW_25G_H_S 3
#define GL_PWR_MODE_DIVIDE_S5_H_CTRL_DIV_VAL_TBW_25G_H_M MAKEMASK(0x7, 3)
#define GL_PWR_MODE_DIVIDE_S5_H_CTRL_DIV_VAL_TBW_10G_H_S 6
#define GL_PWR_MODE_DIVIDE_S5_H_CTRL_DIV_VAL_TBW_10G_H_M MAKEMASK(0x7, 6)
#define GL_PWR_MODE_DIVIDE_S5_H_CTRL_DIV_VAL_TBW_4G_H_S 9
#define GL_PWR_MODE_DIVIDE_S5_H_CTRL_DIV_VAL_TBW_4G_H_M MAKEMASK(0x7, 9)
#define GL_PWR_MODE_DIVIDE_S5_H_CTRL_DIV_VAL_TBW_A50G_H_S 12
#define GL_PWR_MODE_DIVIDE_S5_H_CTRL_DIV_VAL_TBW_A50G_H_M MAKEMASK(0xF, 12)
#define GL_PWR_MODE_DIVIDE_S5_L_CTRL		0x000B824C /* Reset Source: POR */
#define GL_PWR_MODE_DIVIDE_S5_L_CTRL_DIV_VAL_TBW_50G_L_S 0
#define GL_PWR_MODE_DIVIDE_S5_L_CTRL_DIV_VAL_TBW_50G_L_M MAKEMASK(0x7, 0)
#define GL_PWR_MODE_DIVIDE_S5_L_CTRL_DIV_VAL_TBW_25G_L_S 3
#define GL_PWR_MODE_DIVIDE_S5_L_CTRL_DIV_VAL_TBW_25G_L_M MAKEMASK(0x7, 3)
#define GL_PWR_MODE_DIVIDE_S5_L_CTRL_DIV_VAL_TBW_10G_L_S 6
#define GL_PWR_MODE_DIVIDE_S5_L_CTRL_DIV_VAL_TBW_10G_L_M MAKEMASK(0x7, 6)
#define GL_PWR_MODE_DIVIDE_S5_L_CTRL_DIV_VAL_TBW_4G_L_S 9
#define GL_PWR_MODE_DIVIDE_S5_L_CTRL_DIV_VAL_TBW_4G_L_M MAKEMASK(0x7, 9)
#define GL_PWR_MODE_DIVIDE_S5_L_CTRL_DIV_VAL_TBW_A50G_L_S 12
#define GL_PWR_MODE_DIVIDE_S5_L_CTRL_DIV_VAL_TBW_A50G_L_M MAKEMASK(0x7, 12)
#define GL_PWR_MODE_DIVIDE_S5_M_CTRL		0x000B8250 /* Reset Source: POR */
#define GL_PWR_MODE_DIVIDE_S5_M_CTRL_DIV_VAL_TBW_50G_M_S 0
#define GL_PWR_MODE_DIVIDE_S5_M_CTRL_DIV_VAL_TBW_50G_M_M MAKEMASK(0x7, 0)
#define GL_PWR_MODE_DIVIDE_S5_M_CTRL_DIV_VAL_TBW_25G_M_S 3
#define GL_PWR_MODE_DIVIDE_S5_M_CTRL_DIV_VAL_TBW_25G_M_M MAKEMASK(0x7, 3)
#define GL_PWR_MODE_DIVIDE_S5_M_CTRL_DIV_VAL_TBW_10G_M_S 6
#define GL_PWR_MODE_DIVIDE_S5_M_CTRL_DIV_VAL_TBW_10G_M_M MAKEMASK(0x7, 6)
#define GL_PWR_MODE_DIVIDE_S5_M_CTRL_DIV_VAL_TBW_4G_M_S 9
#define GL_PWR_MODE_DIVIDE_S5_M_CTRL_DIV_VAL_TBW_4G_M_M MAKEMASK(0x7, 9)
#define GL_PWR_MODE_DIVIDE_S5_M_CTRL_DIV_VAL_TBW_A50G_M_S 12
#define GL_PWR_MODE_DIVIDE_S5_M_CTRL_DIV_VAL_TBW_A50G_M_M MAKEMASK(0x7, 12)
#define GL_S5_PWR_MODE_EXIT_CTL			0x000B8270 /* Reset Source: POR */
#define GL_S5_PWR_MODE_EXIT_CTL_S5_PWR_MODE_AUTO_EXIT_S 0
#define GL_S5_PWR_MODE_EXIT_CTL_S5_PWR_MODE_AUTO_EXIT_M BIT(0)
#define GL_S5_PWR_MODE_EXIT_CTL_S5_PWR_MODE_FW_EXIT_S 1
#define GL_S5_PWR_MODE_EXIT_CTL_S5_PWR_MODE_FW_EXIT_M BIT(1)
#define GL_S5_PWR_MODE_EXIT_CTL_S5_PWR_MODE_PRST_FLOWS_ON_CORER_S 3
#define GL_S5_PWR_MODE_EXIT_CTL_S5_PWR_MODE_PRST_FLOWS_ON_CORER_M BIT(3)
#define GLGEN_PME_TO				0x000B81BC /* Reset Source: POR */
#define GLGEN_PME_TO_PME_TO_FOR_PE_S		0
#define GLGEN_PME_TO_PME_TO_FOR_PE_M		BIT(0)
#define PRTPM_EEE_STAT				0x001E4320 /* Reset Source: GLOBR */
#define PRTPM_EEE_STAT_EEE_NEG_S		29
#define PRTPM_EEE_STAT_EEE_NEG_M		BIT(29)
#define PRTPM_EEE_STAT_RX_LPI_STATUS_S		30
#define PRTPM_EEE_STAT_RX_LPI_STATUS_M		BIT(30)
#define PRTPM_EEE_STAT_TX_LPI_STATUS_S		31
#define PRTPM_EEE_STAT_TX_LPI_STATUS_M		BIT(31)
#define PRTPM_EEEC				0x001E4380 /* Reset Source: GLOBR */
#define PRTPM_EEEC_TW_WAKE_MIN_S		16
#define PRTPM_EEEC_TW_WAKE_MIN_M		MAKEMASK(0x3F, 16)
#define PRTPM_EEEC_TX_LU_LPI_DLY_S		24
#define PRTPM_EEEC_TX_LU_LPI_DLY_M		MAKEMASK(0x3, 24)
#define PRTPM_EEEC_TEEE_DLY_S			26
#define PRTPM_EEEC_TEEE_DLY_M			MAKEMASK(0x3F, 26)
#define PRTPM_EEEFWD				0x001E4400 /* Reset Source: GLOBR */
#define PRTPM_EEEFWD_EEE_FW_CONFIG_DONE_S	31
#define PRTPM_EEEFWD_EEE_FW_CONFIG_DONE_M	BIT(31)
#define PRTPM_EEER				0x001E4360 /* Reset Source: GLOBR */
#define PRTPM_EEER_TW_SYSTEM_S			0
#define PRTPM_EEER_TW_SYSTEM_M			MAKEMASK(0xFFFF, 0)
#define PRTPM_EEER_TX_LPI_EN_S			16
#define PRTPM_EEER_TX_LPI_EN_M			BIT(16)
#define PRTPM_EEETXC				0x001E43E0 /* Reset Source: GLOBR */
#define PRTPM_EEETXC_TW_PHY_S			0
#define PRTPM_EEETXC_TW_PHY_M			MAKEMASK(0xFFFF, 0)
#define PRTPM_RLPIC				0x001E43A0 /* Reset Source: GLOBR */
#define PRTPM_RLPIC_ERLPIC_S			0
#define PRTPM_RLPIC_ERLPIC_M			MAKEMASK(0xFFFFFFFF, 0)
#define PRTPM_TLPIC				0x001E43C0 /* Reset Source: GLOBR */
#define PRTPM_TLPIC_ETLPIC_S			0
#define PRTPM_TLPIC_ETLPIC_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLRPB_DHW(_i)				(0x000AC000 + ((_i) * 4)) /* _i=0...15 */ /* Reset Source: CORER */
#define GLRPB_DHW_MAX_INDEX			15
#define GLRPB_DHW_DHW_TCN_S			0
#define GLRPB_DHW_DHW_TCN_M			MAKEMASK(0xFFFFF, 0)
#define GLRPB_DLW(_i)				(0x000AC044 + ((_i) * 4)) /* _i=0...15 */ /* Reset Source: CORER */
#define GLRPB_DLW_MAX_INDEX			15
#define GLRPB_DLW_DLW_TCN_S			0
#define GLRPB_DLW_DLW_TCN_M			MAKEMASK(0xFFFFF, 0)
#define GLRPB_DPS(_i)				(0x000AC084 + ((_i) * 4)) /* _i=0...15 */ /* Reset Source: CORER */
#define GLRPB_DPS_MAX_INDEX			15
#define GLRPB_DPS_DPS_TCN_S			0
#define GLRPB_DPS_DPS_TCN_M			MAKEMASK(0xFFFFF, 0)
#define GLRPB_DSI_EN				0x000AC324 /* Reset Source: CORER */
#define GLRPB_DSI_EN_DSI_EN_S			0
#define GLRPB_DSI_EN_DSI_EN_M			BIT(0)
#define GLRPB_DSI_EN_DSI_L2_MAC_ERR_DROP_EN_S	1
#define GLRPB_DSI_EN_DSI_L2_MAC_ERR_DROP_EN_M	BIT(1)
#define GLRPB_SHW(_i)				(0x000AC120 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLRPB_SHW_MAX_INDEX			7
#define GLRPB_SHW_SHW_S				0
#define GLRPB_SHW_SHW_M				MAKEMASK(0xFFFFF, 0)
#define GLRPB_SLW(_i)				(0x000AC140 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLRPB_SLW_MAX_INDEX			7
#define GLRPB_SLW_SLW_S				0
#define GLRPB_SLW_SLW_M				MAKEMASK(0xFFFFF, 0)
#define GLRPB_SPS(_i)				(0x000AC0C4 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLRPB_SPS_MAX_INDEX			7
#define GLRPB_SPS_SPS_TCN_S			0
#define GLRPB_SPS_SPS_TCN_M			MAKEMASK(0xFFFFF, 0)
#define GLRPB_TC_CFG(_i)			(0x000AC2A4 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLRPB_TC_CFG_MAX_INDEX			31
#define GLRPB_TC_CFG_D_POOL_S			0
#define GLRPB_TC_CFG_D_POOL_M			MAKEMASK(0xFFFF, 0)
#define GLRPB_TC_CFG_S_POOL_S			16
#define GLRPB_TC_CFG_S_POOL_M			MAKEMASK(0xFFFF, 16)
#define GLRPB_TCHW(_i)				(0x000AC330 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLRPB_TCHW_MAX_INDEX			31
#define GLRPB_TCHW_TCHW_S			0
#define GLRPB_TCHW_TCHW_M			MAKEMASK(0xFFFFF, 0)
#define GLRPB_TCLW(_i)				(0x000AC3B0 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLRPB_TCLW_MAX_INDEX			31
#define GLRPB_TCLW_TCLW_S			0
#define GLRPB_TCLW_TCLW_M			MAKEMASK(0xFFFFF, 0)
#define GLQF_APBVT(_i)				(0x00450000 + ((_i) * 4)) /* _i=0...2047 */ /* Reset Source: CORER */
#define GLQF_APBVT_MAX_INDEX			2047
#define GLQF_APBVT_APBVT_S			0
#define GLQF_APBVT_APBVT_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLQF_FD_CLSN_0				0x00460028 /* Reset Source: CORER */
#define GLQF_FD_CLSN_0_HITSBCNT_S		0
#define GLQF_FD_CLSN_0_HITSBCNT_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLQF_FD_CLSN1				0x00460030 /* Reset Source: CORER */
#define GLQF_FD_CLSN1_HITLBCNT_S		0
#define GLQF_FD_CLSN1_HITLBCNT_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLQF_FD_CNT				0x00460018 /* Reset Source: CORER */
#define GLQF_FD_CNT_FD_GCNT_S			0
#define GLQF_FD_CNT_FD_GCNT_M			MAKEMASK(0x7FFF, 0)
#define GLQF_FD_CNT_FD_BCNT_S			16
#define GLQF_FD_CNT_FD_BCNT_M			MAKEMASK(0x7FFF, 16)
#define GLQF_FD_CTL				0x00460000 /* Reset Source: CORER */
#define GLQF_FD_CTL_FDLONG_S			0
#define GLQF_FD_CTL_FDLONG_M			MAKEMASK(0xF, 0)
#define GLQF_FD_CTL_HASH_REPORT_S		4
#define GLQF_FD_CTL_HASH_REPORT_M		BIT(4)
#define GLQF_FD_CTL_FLT_ADDR_REPORT_S		5
#define GLQF_FD_CTL_FLT_ADDR_REPORT_M		BIT(5)
#define GLQF_FD_SIZE				0x00460010 /* Reset Source: CORER */
#define GLQF_FD_SIZE_FD_GSIZE_S			0
#define GLQF_FD_SIZE_FD_GSIZE_M			MAKEMASK(0x7FFF, 0)
#define GLQF_FD_SIZE_FD_BSIZE_S			16
#define GLQF_FD_SIZE_FD_BSIZE_M			MAKEMASK(0x7FFF, 16)
#define GLQF_FDCNT_0				0x00460020 /* Reset Source: CORER */
#define GLQF_FDCNT_0_BUCKETCNT_S		0
#define GLQF_FDCNT_0_BUCKETCNT_M		MAKEMASK(0x7FFF, 0)
#define GLQF_FDCNT_0_CNT_NOT_VLD_S		31
#define GLQF_FDCNT_0_CNT_NOT_VLD_M		BIT(31)
#define GLQF_FDEVICTENA(_i)			(0x00452000 + ((_i) * 4)) /* _i=0...3 */ /* Reset Source: CORER */
#define GLQF_FDEVICTENA_MAX_INDEX		3
#define GLQF_FDEVICTENA_FDEVICTENA_S		0
#define GLQF_FDEVICTENA_FDEVICTENA_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLQF_FDINSET(_i, _j)			(0x00412000 + ((_i) * 4 + (_j) * 512)) /* _i=0...127, _j=0...5 */ /* Reset Source: CORER */
#define GLQF_FDINSET_MAX_INDEX			127
#define GLQF_FDINSET_FV_WORD_INDX0_S		0
#define GLQF_FDINSET_FV_WORD_INDX0_M		MAKEMASK(0x1F, 0)
#define GLQF_FDINSET_FV_WORD_VAL0_S		7
#define GLQF_FDINSET_FV_WORD_VAL0_M		BIT(7)
#define GLQF_FDINSET_FV_WORD_INDX1_S		8
#define GLQF_FDINSET_FV_WORD_INDX1_M		MAKEMASK(0x1F, 8)
#define GLQF_FDINSET_FV_WORD_VAL1_S		15
#define GLQF_FDINSET_FV_WORD_VAL1_M		BIT(15)
#define GLQF_FDINSET_FV_WORD_INDX2_S		16
#define GLQF_FDINSET_FV_WORD_INDX2_M		MAKEMASK(0x1F, 16)
#define GLQF_FDINSET_FV_WORD_VAL2_S		23
#define GLQF_FDINSET_FV_WORD_VAL2_M		BIT(23)
#define GLQF_FDINSET_FV_WORD_INDX3_S		24
#define GLQF_FDINSET_FV_WORD_INDX3_M		MAKEMASK(0x1F, 24)
#define GLQF_FDINSET_FV_WORD_VAL3_S		31
#define GLQF_FDINSET_FV_WORD_VAL3_M		BIT(31)
#define GLQF_FDMASK(_i)				(0x00410800 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLQF_FDMASK_MAX_INDEX			31
#define GLQF_FDMASK_MSK_INDEX_S			0
#define GLQF_FDMASK_MSK_INDEX_M			MAKEMASK(0x1F, 0)
#define GLQF_FDMASK_MASK_S			16
#define GLQF_FDMASK_MASK_M			MAKEMASK(0xFFFF, 16)
#define GLQF_FDMASK_SEL(_i)			(0x00410400 + ((_i) * 4)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLQF_FDMASK_SEL_MAX_INDEX		127
#define GLQF_FDMASK_SEL_MASK_SEL_S		0
#define GLQF_FDMASK_SEL_MASK_SEL_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLQF_FDSWAP(_i, _j)			(0x00413000 + ((_i) * 4 + (_j) * 512)) /* _i=0...127, _j=0...5 */ /* Reset Source: CORER */
#define GLQF_FDSWAP_MAX_INDEX			127
#define GLQF_FDSWAP_FV_WORD_INDX0_S		0
#define GLQF_FDSWAP_FV_WORD_INDX0_M		MAKEMASK(0x1F, 0)
#define GLQF_FDSWAP_FV_WORD_VAL0_S		7
#define GLQF_FDSWAP_FV_WORD_VAL0_M		BIT(7)
#define GLQF_FDSWAP_FV_WORD_INDX1_S		8
#define GLQF_FDSWAP_FV_WORD_INDX1_M		MAKEMASK(0x1F, 8)
#define GLQF_FDSWAP_FV_WORD_VAL1_S		15
#define GLQF_FDSWAP_FV_WORD_VAL1_M		BIT(15)
#define GLQF_FDSWAP_FV_WORD_INDX2_S		16
#define GLQF_FDSWAP_FV_WORD_INDX2_M		MAKEMASK(0x1F, 16)
#define GLQF_FDSWAP_FV_WORD_VAL2_S		23
#define GLQF_FDSWAP_FV_WORD_VAL2_M		BIT(23)
#define GLQF_FDSWAP_FV_WORD_INDX3_S		24
#define GLQF_FDSWAP_FV_WORD_INDX3_M		MAKEMASK(0x1F, 24)
#define GLQF_FDSWAP_FV_WORD_VAL3_S		31
#define GLQF_FDSWAP_FV_WORD_VAL3_M		BIT(31)
#define GLQF_HINSET(_i, _j)			(0x0040E000 + ((_i) * 4 + (_j) * 512)) /* _i=0...127, _j=0...5 */ /* Reset Source: CORER */
#define GLQF_HINSET_MAX_INDEX			127
#define GLQF_HINSET_FV_WORD_INDX0_S		0
#define GLQF_HINSET_FV_WORD_INDX0_M		MAKEMASK(0x1F, 0)
#define GLQF_HINSET_FV_WORD_VAL0_S		7
#define GLQF_HINSET_FV_WORD_VAL0_M		BIT(7)
#define GLQF_HINSET_FV_WORD_INDX1_S		8
#define GLQF_HINSET_FV_WORD_INDX1_M		MAKEMASK(0x1F, 8)
#define GLQF_HINSET_FV_WORD_VAL1_S		15
#define GLQF_HINSET_FV_WORD_VAL1_M		BIT(15)
#define GLQF_HINSET_FV_WORD_INDX2_S		16
#define GLQF_HINSET_FV_WORD_INDX2_M		MAKEMASK(0x1F, 16)
#define GLQF_HINSET_FV_WORD_VAL2_S		23
#define GLQF_HINSET_FV_WORD_VAL2_M		BIT(23)
#define GLQF_HINSET_FV_WORD_INDX3_S		24
#define GLQF_HINSET_FV_WORD_INDX3_M		MAKEMASK(0x1F, 24)
#define GLQF_HINSET_FV_WORD_VAL3_S		31
#define GLQF_HINSET_FV_WORD_VAL3_M		BIT(31)
#define GLQF_HKEY(_i)				(0x00456000 + ((_i) * 4)) /* _i=0...12 */ /* Reset Source: CORER */
#define GLQF_HKEY_MAX_INDEX			12
#define GLQF_HKEY_KEY_0_S			0
#define GLQF_HKEY_KEY_0_M			MAKEMASK(0xFF, 0)
#define GLQF_HKEY_KEY_1_S			8
#define GLQF_HKEY_KEY_1_M			MAKEMASK(0xFF, 8)
#define GLQF_HKEY_KEY_2_S			16
#define GLQF_HKEY_KEY_2_M			MAKEMASK(0xFF, 16)
#define GLQF_HKEY_KEY_3_S			24
#define GLQF_HKEY_KEY_3_M			MAKEMASK(0xFF, 24)
#define GLQF_HLUT(_i, _j)			(0x00438000 + ((_i) * 4 + (_j) * 512)) /* _i=0...127, _j=0...15 */ /* Reset Source: CORER */
#define GLQF_HLUT_MAX_INDEX			127
#define GLQF_HLUT_LUT0_S			0
#define GLQF_HLUT_LUT0_M			MAKEMASK(0x3F, 0)
#define GLQF_HLUT_LUT1_S			8
#define GLQF_HLUT_LUT1_M			MAKEMASK(0x3F, 8)
#define GLQF_HLUT_LUT2_S			16
#define GLQF_HLUT_LUT2_M			MAKEMASK(0x3F, 16)
#define GLQF_HLUT_LUT3_S			24
#define GLQF_HLUT_LUT3_M			MAKEMASK(0x3F, 24)
#define GLQF_HLUT_SIZE(_i)			(0x00455400 + ((_i) * 4)) /* _i=0...15 */ /* Reset Source: CORER */
#define GLQF_HLUT_SIZE_MAX_INDEX		15
#define GLQF_HLUT_SIZE_HSIZE_S			0
#define GLQF_HLUT_SIZE_HSIZE_M			BIT(0)
#define GLQF_HMASK(_i)				(0x0040FC00 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLQF_HMASK_MAX_INDEX			31
#define GLQF_HMASK_MSK_INDEX_S			0
#define GLQF_HMASK_MSK_INDEX_M			MAKEMASK(0x1F, 0)
#define GLQF_HMASK_MASK_S			16
#define GLQF_HMASK_MASK_M			MAKEMASK(0xFFFF, 16)
#define GLQF_HMASK_SEL(_i)			(0x00410000 + ((_i) * 4)) /* _i=0...127 */ /* Reset Source: CORER */
#define GLQF_HMASK_SEL_MAX_INDEX		127
#define GLQF_HMASK_SEL_MASK_SEL_S		0
#define GLQF_HMASK_SEL_MASK_SEL_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLQF_HSYMM(_i, _j)			(0x0040F000 + ((_i) * 4 + (_j) * 512)) /* _i=0...127, _j=0...5 */ /* Reset Source: CORER */
#define GLQF_HSYMM_MAX_INDEX			127
#define GLQF_HSYMM_FV_SYMM_INDX0_S		0
#define GLQF_HSYMM_FV_SYMM_INDX0_M		MAKEMASK(0x1F, 0)
#define GLQF_HSYMM_SYMM0_ENA_S			7
#define GLQF_HSYMM_SYMM0_ENA_M			BIT(7)
#define GLQF_HSYMM_FV_SYMM_INDX1_S		8
#define GLQF_HSYMM_FV_SYMM_INDX1_M		MAKEMASK(0x1F, 8)
#define GLQF_HSYMM_SYMM1_ENA_S			15
#define GLQF_HSYMM_SYMM1_ENA_M			BIT(15)
#define GLQF_HSYMM_FV_SYMM_INDX2_S		16
#define GLQF_HSYMM_FV_SYMM_INDX2_M		MAKEMASK(0x1F, 16)
#define GLQF_HSYMM_SYMM2_ENA_S			23
#define GLQF_HSYMM_SYMM2_ENA_M			BIT(23)
#define GLQF_HSYMM_FV_SYMM_INDX3_S		24
#define GLQF_HSYMM_FV_SYMM_INDX3_M		MAKEMASK(0x1F, 24)
#define GLQF_HSYMM_SYMM3_ENA_S			31
#define GLQF_HSYMM_SYMM3_ENA_M			BIT(31)
#define GLQF_PE_APBVT_CNT			0x00455500 /* Reset Source: CORER */
#define GLQF_PE_APBVT_CNT_APBVT_LAN_S		0
#define GLQF_PE_APBVT_CNT_APBVT_LAN_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLQF_PE_CMD				0x00471080 /* Reset Source: CORER */
#define GLQF_PE_CMD_ADDREM_STS_S		0
#define GLQF_PE_CMD_ADDREM_STS_M		MAKEMASK(0xFFFFFF, 0)
#define GLQF_PE_CMD_ADDREM_ID_S			28
#define GLQF_PE_CMD_ADDREM_ID_M			MAKEMASK(0xF, 28)
#define GLQF_PE_CTL				0x004710C0 /* Reset Source: CORER */
#define GLQF_PE_CTL_PELONG_S			0
#define GLQF_PE_CTL_PELONG_M			MAKEMASK(0xF, 0)
#define GLQF_PE_CTL2(_i)			(0x00455200 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLQF_PE_CTL2_MAX_INDEX			31
#define GLQF_PE_CTL2_TO_QH_S			0
#define GLQF_PE_CTL2_TO_QH_M			MAKEMASK(0x3, 0)
#define GLQF_PE_CTL2_APBVT_ENA_S		2
#define GLQF_PE_CTL2_APBVT_ENA_M		BIT(2)
#define GLQF_PE_FVE				0x0020E514 /* Reset Source: CORER */
#define GLQF_PE_FVE_W_ENA_S			0
#define GLQF_PE_FVE_W_ENA_M			MAKEMASK(0xFFFFFF, 0)
#define GLQF_PE_OSR_STS				0x00471040 /* Reset Source: CORER */
#define GLQF_PE_OSR_STS_QH_SRCH_MAXOSR_S	0
#define GLQF_PE_OSR_STS_QH_SRCH_MAXOSR_M	MAKEMASK(0x3FF, 0)
#define GLQF_PE_OSR_STS_QH_CMD_MAXOSR_S		16
#define GLQF_PE_OSR_STS_QH_CMD_MAXOSR_M		MAKEMASK(0x3FF, 16)
#define GLQF_PEINSET(_i, _j)			(0x00415000 + ((_i) * 4 + (_j) * 128)) /* _i=0...31, _j=0...5 */ /* Reset Source: CORER */
#define GLQF_PEINSET_MAX_INDEX			31
#define GLQF_PEINSET_FV_WORD_INDX0_S		0
#define GLQF_PEINSET_FV_WORD_INDX0_M		MAKEMASK(0x1F, 0)
#define GLQF_PEINSET_FV_WORD_VAL0_S		7
#define GLQF_PEINSET_FV_WORD_VAL0_M		BIT(7)
#define GLQF_PEINSET_FV_WORD_INDX1_S		8
#define GLQF_PEINSET_FV_WORD_INDX1_M		MAKEMASK(0x1F, 8)
#define GLQF_PEINSET_FV_WORD_VAL1_S		15
#define GLQF_PEINSET_FV_WORD_VAL1_M		BIT(15)
#define GLQF_PEINSET_FV_WORD_INDX2_S		16
#define GLQF_PEINSET_FV_WORD_INDX2_M		MAKEMASK(0x1F, 16)
#define GLQF_PEINSET_FV_WORD_VAL2_S		23
#define GLQF_PEINSET_FV_WORD_VAL2_M		BIT(23)
#define GLQF_PEINSET_FV_WORD_INDX3_S		24
#define GLQF_PEINSET_FV_WORD_INDX3_M		MAKEMASK(0x1F, 24)
#define GLQF_PEINSET_FV_WORD_VAL3_S		31
#define GLQF_PEINSET_FV_WORD_VAL3_M		BIT(31)
#define GLQF_PEMASK(_i)				(0x00415400 + ((_i) * 4)) /* _i=0...15 */ /* Reset Source: CORER */
#define GLQF_PEMASK_MAX_INDEX			15
#define GLQF_PEMASK_MSK_INDEX_S			0
#define GLQF_PEMASK_MSK_INDEX_M			MAKEMASK(0x1F, 0)
#define GLQF_PEMASK_MASK_S			16
#define GLQF_PEMASK_MASK_M			MAKEMASK(0xFFFF, 16)
#define GLQF_PEMASK_SEL(_i)			(0x00415500 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLQF_PEMASK_SEL_MAX_INDEX		31
#define GLQF_PEMASK_SEL_MASK_SEL_S		0
#define GLQF_PEMASK_SEL_MASK_SEL_M		MAKEMASK(0xFFFF, 0)
#define GLQF_PETABLE_CLR(_i)			(0x000AA078 + ((_i) * 4)) /* _i=0...1 */ /* Reset Source: CORER */
#define GLQF_PETABLE_CLR_MAX_INDEX		1
#define GLQF_PETABLE_CLR_VM_VF_NUM_S		0
#define GLQF_PETABLE_CLR_VM_VF_NUM_M		MAKEMASK(0x3FF, 0)
#define GLQF_PETABLE_CLR_VM_VF_TYPE_S		10
#define GLQF_PETABLE_CLR_VM_VF_TYPE_M		MAKEMASK(0x3, 10)
#define GLQF_PETABLE_CLR_PF_NUM_S		12
#define GLQF_PETABLE_CLR_PF_NUM_M		MAKEMASK(0x7, 12)
#define GLQF_PETABLE_CLR_PE_BUSY_S		16
#define GLQF_PETABLE_CLR_PE_BUSY_M		BIT(16)
#define GLQF_PETABLE_CLR_PE_CLEAR_S		17
#define GLQF_PETABLE_CLR_PE_CLEAR_M		BIT(17)
#define GLQF_PROF2TC(_i, _j)			(0x0044D000 + ((_i) * 4 + (_j) * 512)) /* _i=0...127, _j=0...3 */ /* Reset Source: CORER */
#define GLQF_PROF2TC_MAX_INDEX			127
#define GLQF_PROF2TC_OVERRIDE_ENA_0_S		0
#define GLQF_PROF2TC_OVERRIDE_ENA_0_M		BIT(0)
#define GLQF_PROF2TC_REGION_0_S			1
#define GLQF_PROF2TC_REGION_0_M			MAKEMASK(0x7, 1)
#define GLQF_PROF2TC_OVERRIDE_ENA_1_S		4
#define GLQF_PROF2TC_OVERRIDE_ENA_1_M		BIT(4)
#define GLQF_PROF2TC_REGION_1_S			5
#define GLQF_PROF2TC_REGION_1_M			MAKEMASK(0x7, 5)
#define GLQF_PROF2TC_OVERRIDE_ENA_2_S		8
#define GLQF_PROF2TC_OVERRIDE_ENA_2_M		BIT(8)
#define GLQF_PROF2TC_REGION_2_S			9
#define GLQF_PROF2TC_REGION_2_M			MAKEMASK(0x7, 9)
#define GLQF_PROF2TC_OVERRIDE_ENA_3_S		12
#define GLQF_PROF2TC_OVERRIDE_ENA_3_M		BIT(12)
#define GLQF_PROF2TC_REGION_3_S			13
#define GLQF_PROF2TC_REGION_3_M			MAKEMASK(0x7, 13)
#define GLQF_PROF2TC_OVERRIDE_ENA_4_S		16
#define GLQF_PROF2TC_OVERRIDE_ENA_4_M		BIT(16)
#define GLQF_PROF2TC_REGION_4_S			17
#define GLQF_PROF2TC_REGION_4_M			MAKEMASK(0x7, 17)
#define GLQF_PROF2TC_OVERRIDE_ENA_5_S		20
#define GLQF_PROF2TC_OVERRIDE_ENA_5_M		BIT(20)
#define GLQF_PROF2TC_REGION_5_S			21
#define GLQF_PROF2TC_REGION_5_M			MAKEMASK(0x7, 21)
#define GLQF_PROF2TC_OVERRIDE_ENA_6_S		24
#define GLQF_PROF2TC_OVERRIDE_ENA_6_M		BIT(24)
#define GLQF_PROF2TC_REGION_6_S			25
#define GLQF_PROF2TC_REGION_6_M			MAKEMASK(0x7, 25)
#define GLQF_PROF2TC_OVERRIDE_ENA_7_S		28
#define GLQF_PROF2TC_OVERRIDE_ENA_7_M		BIT(28)
#define GLQF_PROF2TC_REGION_7_S			29
#define GLQF_PROF2TC_REGION_7_M			MAKEMASK(0x7, 29)
#define PFQF_FD_CNT				0x00460180 /* Reset Source: CORER */
#define PFQF_FD_CNT_FD_GCNT_S			0
#define PFQF_FD_CNT_FD_GCNT_M			MAKEMASK(0x7FFF, 0)
#define PFQF_FD_CNT_FD_BCNT_S			16
#define PFQF_FD_CNT_FD_BCNT_M			MAKEMASK(0x7FFF, 16)
#define PFQF_FD_ENA				0x0043A000 /* Reset Source: CORER */
#define PFQF_FD_ENA_FD_ENA_S			0
#define PFQF_FD_ENA_FD_ENA_M			BIT(0)
#define PFQF_FD_SIZE				0x00460100 /* Reset Source: CORER */
#define PFQF_FD_SIZE_FD_GSIZE_S			0
#define PFQF_FD_SIZE_FD_GSIZE_M			MAKEMASK(0x7FFF, 0)
#define PFQF_FD_SIZE_FD_BSIZE_S			16
#define PFQF_FD_SIZE_FD_BSIZE_M			MAKEMASK(0x7FFF, 16)
#define PFQF_FD_SUBTRACT			0x00460200 /* Reset Source: CORER */
#define PFQF_FD_SUBTRACT_FD_GCNT_S		0
#define PFQF_FD_SUBTRACT_FD_GCNT_M		MAKEMASK(0x7FFF, 0)
#define PFQF_FD_SUBTRACT_FD_BCNT_S		16
#define PFQF_FD_SUBTRACT_FD_BCNT_M		MAKEMASK(0x7FFF, 16)
#define PFQF_HLUT(_i)				(0x00430000 + ((_i) * 64)) /* _i=0...511 */ /* Reset Source: CORER */
#define PFQF_HLUT_MAX_INDEX			511
#define PFQF_HLUT_LUT0_S			0
#define PFQF_HLUT_LUT0_M			MAKEMASK(0xFF, 0)
#define PFQF_HLUT_LUT1_S			8
#define PFQF_HLUT_LUT1_M			MAKEMASK(0xFF, 8)
#define PFQF_HLUT_LUT2_S			16
#define PFQF_HLUT_LUT2_M			MAKEMASK(0xFF, 16)
#define PFQF_HLUT_LUT3_S			24
#define PFQF_HLUT_LUT3_M			MAKEMASK(0xFF, 24)
#define PFQF_HLUT_SIZE				0x00455480 /* Reset Source: CORER */
#define PFQF_HLUT_SIZE_HSIZE_S			0
#define PFQF_HLUT_SIZE_HSIZE_M			MAKEMASK(0x3, 0)
#define PFQF_PE_CLSN0				0x00470480 /* Reset Source: CORER */
#define PFQF_PE_CLSN0_HITSBCNT_S		0
#define PFQF_PE_CLSN0_HITSBCNT_M		MAKEMASK(0xFFFFFFFF, 0)
#define PFQF_PE_CLSN1				0x00470500 /* Reset Source: CORER */
#define PFQF_PE_CLSN1_HITLBCNT_S		0
#define PFQF_PE_CLSN1_HITLBCNT_M		MAKEMASK(0xFFFFFFFF, 0)
#define PFQF_PE_CTL1				0x00470000 /* Reset Source: CORER */
#define PFQF_PE_CTL1_PEHSIZE_S			0
#define PFQF_PE_CTL1_PEHSIZE_M			MAKEMASK(0xF, 0)
#define PFQF_PE_CTL2				0x00470040 /* Reset Source: CORER */
#define PFQF_PE_CTL2_PEDSIZE_S			0
#define PFQF_PE_CTL2_PEDSIZE_M			MAKEMASK(0xF, 0)
#define PFQF_PE_FILTERING_ENA			0x0043A080 /* Reset Source: CORER */
#define PFQF_PE_FILTERING_ENA_PE_ENA_S		0
#define PFQF_PE_FILTERING_ENA_PE_ENA_M		BIT(0)
#define PFQF_PE_FLHD				0x00470100 /* Reset Source: CORER */
#define PFQF_PE_FLHD_FLHD_S			0
#define PFQF_PE_FLHD_FLHD_M			MAKEMASK(0xFFFFFF, 0)
#define PFQF_PE_ST_CTL				0x00470400 /* Reset Source: CORER */
#define PFQF_PE_ST_CTL_PF_CNT_EN_S		0
#define PFQF_PE_ST_CTL_PF_CNT_EN_M		BIT(0)
#define PFQF_PE_ST_CTL_VFS_CNT_EN_S		1
#define PFQF_PE_ST_CTL_VFS_CNT_EN_M		BIT(1)
#define PFQF_PE_ST_CTL_VF_CNT_EN_S		2
#define PFQF_PE_ST_CTL_VF_CNT_EN_M		BIT(2)
#define PFQF_PE_ST_CTL_VF_NUM_S			16
#define PFQF_PE_ST_CTL_VF_NUM_M			MAKEMASK(0xFF, 16)
#define PFQF_PE_TC_CTL				0x00452080 /* Reset Source: CORER */
#define PFQF_PE_TC_CTL_TC_EN_PF_S		0
#define PFQF_PE_TC_CTL_TC_EN_PF_M		MAKEMASK(0xFF, 0)
#define PFQF_PE_TC_CTL_TC_EN_VF_S		16
#define PFQF_PE_TC_CTL_TC_EN_VF_M		MAKEMASK(0xFF, 16)
#define PFQF_PECNT_0				0x00470200 /* Reset Source: CORER */
#define PFQF_PECNT_0_BUCKETCNT_S		0
#define PFQF_PECNT_0_BUCKETCNT_M		MAKEMASK(0x3FFFF, 0)
#define PFQF_PECNT_1				0x00470300 /* Reset Source: CORER */
#define PFQF_PECNT_1_FLTCNT_S			0
#define PFQF_PECNT_1_FLTCNT_M			MAKEMASK(0x3FFFF, 0)
#define VPQF_PE_CTL1(_VF)			(0x00474000 + ((_VF) * 4)) /* _i=0...255 */ /* Reset Source: CORER */
#define VPQF_PE_CTL1_MAX_INDEX			255
#define VPQF_PE_CTL1_PEHSIZE_S			0
#define VPQF_PE_CTL1_PEHSIZE_M			MAKEMASK(0xF, 0)
#define VPQF_PE_CTL2(_VF)			(0x00474800 + ((_VF) * 4)) /* _i=0...255 */ /* Reset Source: CORER */
#define VPQF_PE_CTL2_MAX_INDEX			255
#define VPQF_PE_CTL2_PEDSIZE_S			0
#define VPQF_PE_CTL2_PEDSIZE_M			MAKEMASK(0xF, 0)
#define VPQF_PE_FILTERING_ENA(_VF)		(0x00455800 + ((_VF) * 4)) /* _i=0...255 */ /* Reset Source: CORER */
#define VPQF_PE_FILTERING_ENA_MAX_INDEX		255
#define VPQF_PE_FILTERING_ENA_PE_ENA_S		0
#define VPQF_PE_FILTERING_ENA_PE_ENA_M		BIT(0)
#define VPQF_PE_FLHD(_VF)			(0x00472000 + ((_VF) * 4)) /* _i=0...255 */ /* Reset Source: CORER */
#define VPQF_PE_FLHD_MAX_INDEX			255
#define VPQF_PE_FLHD_FLHD_S			0
#define VPQF_PE_FLHD_FLHD_M			MAKEMASK(0xFFFFFF, 0)
#define VPQF_PECNT_0(_VF)			(0x00472800 + ((_VF) * 4)) /* _i=0...255 */ /* Reset Source: CORER */
#define VPQF_PECNT_0_MAX_INDEX			255
#define VPQF_PECNT_0_BUCKETCNT_S		0
#define VPQF_PECNT_0_BUCKETCNT_M		MAKEMASK(0x3FFFF, 0)
#define VPQF_PECNT_1(_VF)			(0x00473000 + ((_VF) * 4)) /* _i=0...255 */ /* Reset Source: CORER */
#define VPQF_PECNT_1_MAX_INDEX			255
#define VPQF_PECNT_1_FLTCNT_S			0
#define VPQF_PECNT_1_FLTCNT_M			MAKEMASK(0x3FFFF, 0)
#define GLDCB_RMPMC				0x001223C8 /* Reset Source: CORER */
#define GLDCB_RMPMC_RSPM_S			0
#define GLDCB_RMPMC_RSPM_M			MAKEMASK(0x3F, 0)
#define GLDCB_RMPMC_MIQ_NODROP_MODE_S		6
#define GLDCB_RMPMC_MIQ_NODROP_MODE_M		MAKEMASK(0x1F, 6)
#define GLDCB_RMPMC_RPM_DIS_S			31
#define GLDCB_RMPMC_RPM_DIS_M			BIT(31)
#define GLDCB_RMPMS				0x001223CC /* Reset Source: CORER */
#define GLDCB_RMPMS_RMPM_S			0
#define GLDCB_RMPMS_RMPM_M			MAKEMASK(0xFFFF, 0)
#define GLDCB_RPCC				0x00122260 /* Reset Source: CORER */
#define GLDCB_RPCC_EN_S				0
#define GLDCB_RPCC_EN_M				BIT(0)
#define GLDCB_RPCC_SCL_FACT_S			4
#define GLDCB_RPCC_SCL_FACT_M			MAKEMASK(0x1F, 4)
#define GLDCB_RPCC_THRSH_S			16
#define GLDCB_RPCC_THRSH_M			MAKEMASK(0xFFF, 16)
#define GLDCB_RSPMC				0x001223C4 /* Reset Source: CORER */
#define GLDCB_RSPMC_RSPM_S			0
#define GLDCB_RSPMC_RSPM_M			MAKEMASK(0xFF, 0)
#define GLDCB_RSPMC_RPM_MODE_S			8
#define GLDCB_RSPMC_RPM_MODE_M			MAKEMASK(0x3, 8)
#define GLDCB_RSPMC_PRR_MAX_EXP_S		10
#define GLDCB_RSPMC_PRR_MAX_EXP_M		MAKEMASK(0xF, 10)
#define GLDCB_RSPMC_PFCTIMER_S			14
#define GLDCB_RSPMC_PFCTIMER_M			MAKEMASK(0x3FFF, 14)
#define GLDCB_RSPMC_RPM_DIS_S			31
#define GLDCB_RSPMC_RPM_DIS_M			BIT(31)
#define GLDCB_RSPMS				0x001223C0 /* Reset Source: CORER */
#define GLDCB_RSPMS_RSPM_S			0
#define GLDCB_RSPMS_RSPM_M			MAKEMASK(0x3FFFF, 0)
#define GLDCB_RTCTI				0x001223D0 /* Reset Source: CORER */
#define GLDCB_RTCTI_PFCTIMEOUT_TC_S		0
#define GLDCB_RTCTI_PFCTIMEOUT_TC_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLDCB_RTCTQ(_i)				(0x001222C0 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLDCB_RTCTQ_MAX_INDEX			31
#define GLDCB_RTCTQ_RXQNUM_S			0
#define GLDCB_RTCTQ_RXQNUM_M			MAKEMASK(0x7FF, 0)
#define GLDCB_RTCTQ_IS_PF_Q_S			16
#define GLDCB_RTCTQ_IS_PF_Q_M			BIT(16)
#define GLDCB_RTCTS(_i)				(0x00122340 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLDCB_RTCTS_MAX_INDEX			31
#define GLDCB_RTCTS_PFCTIMER_S			0
#define GLDCB_RTCTS_PFCTIMER_M			MAKEMASK(0x3FFF, 0)
#define GLRCB_CFG_COTF_CNT(_i)			(0x001223D4 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLRCB_CFG_COTF_CNT_MAX_INDEX		7
#define GLRCB_CFG_COTF_CNT_MRKR_COTF_CNT_S	0
#define GLRCB_CFG_COTF_CNT_MRKR_COTF_CNT_M	MAKEMASK(0x3F, 0)
#define GLRCB_CFG_COTF_ST			0x001223F4 /* Reset Source: CORER */
#define GLRCB_CFG_COTF_ST_MRKR_COTF_ST_S	0
#define GLRCB_CFG_COTF_ST_MRKR_COTF_ST_M	MAKEMASK(0xFF, 0)
#define GLRPRS_PMCFG_DHW(_i)			(0x00200388 + ((_i) * 4)) /* _i=0...15 */ /* Reset Source: CORER */
#define GLRPRS_PMCFG_DHW_MAX_INDEX		15
#define GLRPRS_PMCFG_DHW_DHW_S			0
#define GLRPRS_PMCFG_DHW_DHW_M			MAKEMASK(0xFFFFF, 0)
#define GLRPRS_PMCFG_DLW(_i)			(0x002003C8 + ((_i) * 4)) /* _i=0...15 */ /* Reset Source: CORER */
#define GLRPRS_PMCFG_DLW_MAX_INDEX		15
#define GLRPRS_PMCFG_DLW_DLW_S			0
#define GLRPRS_PMCFG_DLW_DLW_M			MAKEMASK(0xFFFFF, 0)
#define GLRPRS_PMCFG_DPS(_i)			(0x00200308 + ((_i) * 4)) /* _i=0...15 */ /* Reset Source: CORER */
#define GLRPRS_PMCFG_DPS_MAX_INDEX		15
#define GLRPRS_PMCFG_DPS_DPS_S			0
#define GLRPRS_PMCFG_DPS_DPS_M			MAKEMASK(0xFFFFF, 0)
#define GLRPRS_PMCFG_SHW(_i)			(0x00200448 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLRPRS_PMCFG_SHW_MAX_INDEX		7
#define GLRPRS_PMCFG_SHW_SHW_S			0
#define GLRPRS_PMCFG_SHW_SHW_M			MAKEMASK(0xFFFFF, 0)
#define GLRPRS_PMCFG_SLW(_i)			(0x00200468 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLRPRS_PMCFG_SLW_MAX_INDEX		7
#define GLRPRS_PMCFG_SLW_SLW_S			0
#define GLRPRS_PMCFG_SLW_SLW_M			MAKEMASK(0xFFFFF, 0)
#define GLRPRS_PMCFG_SPS(_i)			(0x00200408 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLRPRS_PMCFG_SPS_MAX_INDEX		7
#define GLRPRS_PMCFG_SPS_SPS_S			0
#define GLRPRS_PMCFG_SPS_SPS_M			MAKEMASK(0xFFFFF, 0)
#define GLRPRS_PMCFG_TC_CFG(_i)			(0x00200488 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLRPRS_PMCFG_TC_CFG_MAX_INDEX		31
#define GLRPRS_PMCFG_TC_CFG_D_POOL_S		0
#define GLRPRS_PMCFG_TC_CFG_D_POOL_M		MAKEMASK(0xF, 0)
#define GLRPRS_PMCFG_TC_CFG_S_POOL_S		16
#define GLRPRS_PMCFG_TC_CFG_S_POOL_M		MAKEMASK(0x7, 16)
#define GLRPRS_PMCFG_TCHW(_i)			(0x00200588 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLRPRS_PMCFG_TCHW_MAX_INDEX		31
#define GLRPRS_PMCFG_TCHW_TCHW_S		0
#define GLRPRS_PMCFG_TCHW_TCHW_M		MAKEMASK(0xFFFFF, 0)
#define GLRPRS_PMCFG_TCLW(_i)			(0x00200608 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLRPRS_PMCFG_TCLW_MAX_INDEX		31
#define GLRPRS_PMCFG_TCLW_TCLW_S		0
#define GLRPRS_PMCFG_TCLW_TCLW_M		MAKEMASK(0xFFFFF, 0)
#define GLSWT_PMCFG_TC_CFG(_i)			(0x00204900 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLSWT_PMCFG_TC_CFG_MAX_INDEX		31
#define GLSWT_PMCFG_TC_CFG_D_POOL_S		0
#define GLSWT_PMCFG_TC_CFG_D_POOL_M		MAKEMASK(0xF, 0)
#define GLSWT_PMCFG_TC_CFG_S_POOL_S		16
#define GLSWT_PMCFG_TC_CFG_S_POOL_M		MAKEMASK(0x7, 16)
#define PRTDCB_RLANPMS				0x00122280 /* Reset Source: CORER */
#define PRTDCB_RLANPMS_LANRPPM_S		0
#define PRTDCB_RLANPMS_LANRPPM_M		MAKEMASK(0x3FFFF, 0)
#define PRTDCB_RPPMC				0x00122240 /* Reset Source: CORER */
#define PRTDCB_RPPMC_LANRPPM_S			0
#define PRTDCB_RPPMC_LANRPPM_M			MAKEMASK(0xFF, 0)
#define PRTDCB_RPPMC_RDMARPPM_S			8
#define PRTDCB_RPPMC_RDMARPPM_M			MAKEMASK(0xFF, 8)
#define PRTDCB_RRDMAPMS				0x00122120 /* Reset Source: CORER */
#define PRTDCB_RRDMAPMS_RDMARPPM_S		0
#define PRTDCB_RRDMAPMS_RDMARPPM_M		MAKEMASK(0x3FFFF, 0)
#define GL_STAT_SWR_BPCH(_i)			(0x00347804 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GL_STAT_SWR_BPCH_MAX_INDEX		127
#define GL_STAT_SWR_BPCH_VLBPCH_S		0
#define GL_STAT_SWR_BPCH_VLBPCH_M		MAKEMASK(0xFF, 0)
#define GL_STAT_SWR_BPCL(_i)			(0x00347800 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GL_STAT_SWR_BPCL_MAX_INDEX		127
#define GL_STAT_SWR_BPCL_VLBPCL_S		0
#define GL_STAT_SWR_BPCL_VLBPCL_M		MAKEMASK(0xFFFFFFFF, 0)
#define GL_STAT_SWR_GORCH(_i)			(0x00342004 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GL_STAT_SWR_GORCH_MAX_INDEX		127
#define GL_STAT_SWR_GORCH_VLBCH_S		0
#define GL_STAT_SWR_GORCH_VLBCH_M		MAKEMASK(0xFF, 0)
#define GL_STAT_SWR_GORCL(_i)			(0x00342000 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GL_STAT_SWR_GORCL_MAX_INDEX		127
#define GL_STAT_SWR_GORCL_VLBCL_S		0
#define GL_STAT_SWR_GORCL_VLBCL_M		MAKEMASK(0xFFFFFFFF, 0)
#define GL_STAT_SWR_GOTCH(_i)			(0x00304004 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GL_STAT_SWR_GOTCH_MAX_INDEX		127
#define GL_STAT_SWR_GOTCH_VLBCH_S		0
#define GL_STAT_SWR_GOTCH_VLBCH_M		MAKEMASK(0xFF, 0)
#define GL_STAT_SWR_GOTCL(_i)			(0x00304000 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GL_STAT_SWR_GOTCL_MAX_INDEX		127
#define GL_STAT_SWR_GOTCL_VLBCL_S		0
#define GL_STAT_SWR_GOTCL_VLBCL_M		MAKEMASK(0xFFFFFFFF, 0)
#define GL_STAT_SWR_MPCH(_i)			(0x00347404 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GL_STAT_SWR_MPCH_MAX_INDEX		127
#define GL_STAT_SWR_MPCH_VLMPCH_S		0
#define GL_STAT_SWR_MPCH_VLMPCH_M		MAKEMASK(0xFF, 0)
#define GL_STAT_SWR_MPCL(_i)			(0x00347400 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GL_STAT_SWR_MPCL_MAX_INDEX		127
#define GL_STAT_SWR_MPCL_VLMPCL_S		0
#define GL_STAT_SWR_MPCL_VLMPCL_M		MAKEMASK(0xFFFFFFFF, 0)
#define GL_STAT_SWR_UPCH(_i)			(0x00347004 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GL_STAT_SWR_UPCH_MAX_INDEX		127
#define GL_STAT_SWR_UPCH_VLUPCH_S		0
#define GL_STAT_SWR_UPCH_VLUPCH_M		MAKEMASK(0xFF, 0)
#define GL_STAT_SWR_UPCL(_i)			(0x00347000 + ((_i) * 8)) /* _i=0...127 */ /* Reset Source: CORER */
#define GL_STAT_SWR_UPCL_MAX_INDEX		127
#define GL_STAT_SWR_UPCL_VLUPCL_S		0
#define GL_STAT_SWR_UPCL_VLUPCL_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_AORCL(_i)				(0x003812C0 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_AORCL_MAX_INDEX			7
#define GLPRT_AORCL_AORCL_S			0
#define GLPRT_AORCL_AORCL_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_BPRCH(_i)				(0x00381384 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_BPRCH_MAX_INDEX			7
#define GLPRT_BPRCH_UPRCH_S			0
#define GLPRT_BPRCH_UPRCH_M			MAKEMASK(0xFF, 0)
#define GLPRT_BPRCL(_i)				(0x00381380 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_BPRCL_MAX_INDEX			7
#define GLPRT_BPRCL_UPRCH_S			0
#define GLPRT_BPRCL_UPRCH_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_BPTCH(_i)				(0x00381244 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_BPTCH_MAX_INDEX			7
#define GLPRT_BPTCH_UPRCH_S			0
#define GLPRT_BPTCH_UPRCH_M			MAKEMASK(0xFF, 0)
#define GLPRT_BPTCL(_i)				(0x00381240 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_BPTCL_MAX_INDEX			7
#define GLPRT_BPTCL_UPRCH_S			0
#define GLPRT_BPTCL_UPRCH_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_CRCERRS(_i)			(0x00380100 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_CRCERRS_MAX_INDEX			7
#define GLPRT_CRCERRS_CRCERRS_S			0
#define GLPRT_CRCERRS_CRCERRS_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_CRCERRS_H(_i)			(0x00380104 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_CRCERRS_H_MAX_INDEX		7
#define GLPRT_CRCERRS_H_CRCERRS_S		0
#define GLPRT_CRCERRS_H_CRCERRS_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_GORCH(_i)				(0x00380004 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_GORCH_MAX_INDEX			7
#define GLPRT_GORCH_GORCH_S			0
#define GLPRT_GORCH_GORCH_M			MAKEMASK(0xFF, 0)
#define GLPRT_GORCL(_i)				(0x00380000 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_GORCL_MAX_INDEX			7
#define GLPRT_GORCL_GORCL_S			0
#define GLPRT_GORCL_GORCL_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_GOTCH(_i)				(0x00380B44 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_GOTCH_MAX_INDEX			7
#define GLPRT_GOTCH_GOTCH_S			0
#define GLPRT_GOTCH_GOTCH_M			MAKEMASK(0xFF, 0)
#define GLPRT_GOTCL(_i)				(0x00380B40 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_GOTCL_MAX_INDEX			7
#define GLPRT_GOTCL_GOTCL_S			0
#define GLPRT_GOTCL_GOTCL_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_ILLERRC(_i)			(0x003801C0 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_ILLERRC_MAX_INDEX			7
#define GLPRT_ILLERRC_ILLERRC_S			0
#define GLPRT_ILLERRC_ILLERRC_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_ILLERRC_H(_i)			(0x003801C4 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_ILLERRC_H_MAX_INDEX		7
#define GLPRT_ILLERRC_H_ILLERRC_S		0
#define GLPRT_ILLERRC_H_ILLERRC_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_LXOFFRXC(_i)			(0x003802C0 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_LXOFFRXC_MAX_INDEX		7
#define GLPRT_LXOFFRXC_LXOFFRXCNT_S		0
#define GLPRT_LXOFFRXC_LXOFFRXCNT_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_LXOFFRXC_H(_i)			(0x003802C4 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_LXOFFRXC_H_MAX_INDEX		7
#define GLPRT_LXOFFRXC_H_LXOFFRXCNT_S		0
#define GLPRT_LXOFFRXC_H_LXOFFRXCNT_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_LXOFFTXC(_i)			(0x00381180 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_LXOFFTXC_MAX_INDEX		7
#define GLPRT_LXOFFTXC_LXOFFTXC_S		0
#define GLPRT_LXOFFTXC_LXOFFTXC_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_LXOFFTXC_H(_i)			(0x00381184 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_LXOFFTXC_H_MAX_INDEX		7
#define GLPRT_LXOFFTXC_H_LXOFFTXC_S		0
#define GLPRT_LXOFFTXC_H_LXOFFTXC_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_LXONRXC(_i)			(0x00380280 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_LXONRXC_MAX_INDEX			7
#define GLPRT_LXONRXC_LXONRXCNT_S		0
#define GLPRT_LXONRXC_LXONRXCNT_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_LXONRXC_H(_i)			(0x00380284 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_LXONRXC_H_MAX_INDEX		7
#define GLPRT_LXONRXC_H_LXONRXCNT_S		0
#define GLPRT_LXONRXC_H_LXONRXCNT_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_LXONTXC(_i)			(0x00381140 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_LXONTXC_MAX_INDEX			7
#define GLPRT_LXONTXC_LXONTXC_S			0
#define GLPRT_LXONTXC_LXONTXC_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_LXONTXC_H(_i)			(0x00381144 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_LXONTXC_H_MAX_INDEX		7
#define GLPRT_LXONTXC_H_LXONTXC_S		0
#define GLPRT_LXONTXC_H_LXONTXC_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_MLFC(_i)				(0x00380040 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_MLFC_MAX_INDEX			7
#define GLPRT_MLFC_MLFC_S			0
#define GLPRT_MLFC_MLFC_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_MLFC_H(_i)			(0x00380044 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_MLFC_H_MAX_INDEX			7
#define GLPRT_MLFC_H_MLFC_S			0
#define GLPRT_MLFC_H_MLFC_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_MPRCH(_i)				(0x00381344 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_MPRCH_MAX_INDEX			7
#define GLPRT_MPRCH_MPRCH_S			0
#define GLPRT_MPRCH_MPRCH_M			MAKEMASK(0xFF, 0)
#define GLPRT_MPRCL(_i)				(0x00381340 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_MPRCL_MAX_INDEX			7
#define GLPRT_MPRCL_MPRCL_S			0
#define GLPRT_MPRCL_MPRCL_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_MPTCH(_i)				(0x00381204 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_MPTCH_MAX_INDEX			7
#define GLPRT_MPTCH_MPTCH_S			0
#define GLPRT_MPTCH_MPTCH_M			MAKEMASK(0xFF, 0)
#define GLPRT_MPTCL(_i)				(0x00381200 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_MPTCL_MAX_INDEX			7
#define GLPRT_MPTCL_MPTCL_S			0
#define GLPRT_MPTCL_MPTCL_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_MRFC(_i)				(0x00380080 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_MRFC_MAX_INDEX			7
#define GLPRT_MRFC_MRFC_S			0
#define GLPRT_MRFC_MRFC_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_MRFC_H(_i)			(0x00380084 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_MRFC_H_MAX_INDEX			7
#define GLPRT_MRFC_H_MRFC_S			0
#define GLPRT_MRFC_H_MRFC_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_PRC1023H(_i)			(0x00380A04 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_PRC1023H_MAX_INDEX		7
#define GLPRT_PRC1023H_PRC1023H_S		0
#define GLPRT_PRC1023H_PRC1023H_M		MAKEMASK(0xFF, 0)
#define GLPRT_PRC1023L(_i)			(0x00380A00 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_PRC1023L_MAX_INDEX		7
#define GLPRT_PRC1023L_PRC1023L_S		0
#define GLPRT_PRC1023L_PRC1023L_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_PRC127H(_i)			(0x00380944 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_PRC127H_MAX_INDEX			7
#define GLPRT_PRC127H_PRC127H_S			0
#define GLPRT_PRC127H_PRC127H_M			MAKEMASK(0xFF, 0)
#define GLPRT_PRC127L(_i)			(0x00380940 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_PRC127L_MAX_INDEX			7
#define GLPRT_PRC127L_PRC127L_S			0
#define GLPRT_PRC127L_PRC127L_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_PRC1522H(_i)			(0x00380A44 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_PRC1522H_MAX_INDEX		7
#define GLPRT_PRC1522H_PRC1522H_S		0
#define GLPRT_PRC1522H_PRC1522H_M		MAKEMASK(0xFF, 0)
#define GLPRT_PRC1522L(_i)			(0x00380A40 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_PRC1522L_MAX_INDEX		7
#define GLPRT_PRC1522L_PRC1522L_S		0
#define GLPRT_PRC1522L_PRC1522L_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_PRC255H(_i)			(0x00380984 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_PRC255H_MAX_INDEX			7
#define GLPRT_PRC255H_PRTPRC255H_S		0
#define GLPRT_PRC255H_PRTPRC255H_M		MAKEMASK(0xFF, 0)
#define GLPRT_PRC255L(_i)			(0x00380980 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_PRC255L_MAX_INDEX			7
#define GLPRT_PRC255L_PRC255L_S			0
#define GLPRT_PRC255L_PRC255L_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_PRC511H(_i)			(0x003809C4 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_PRC511H_MAX_INDEX			7
#define GLPRT_PRC511H_PRC511H_S			0
#define GLPRT_PRC511H_PRC511H_M			MAKEMASK(0xFF, 0)
#define GLPRT_PRC511L(_i)			(0x003809C0 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_PRC511L_MAX_INDEX			7
#define GLPRT_PRC511L_PRC511L_S			0
#define GLPRT_PRC511L_PRC511L_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_PRC64H(_i)			(0x00380904 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_PRC64H_MAX_INDEX			7
#define GLPRT_PRC64H_PRC64H_S			0
#define GLPRT_PRC64H_PRC64H_M			MAKEMASK(0xFF, 0)
#define GLPRT_PRC64L(_i)			(0x00380900 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_PRC64L_MAX_INDEX			7
#define GLPRT_PRC64L_PRC64L_S			0
#define GLPRT_PRC64L_PRC64L_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_PRC9522H(_i)			(0x00380A84 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_PRC9522H_MAX_INDEX		7
#define GLPRT_PRC9522H_PRC1522H_S		0
#define GLPRT_PRC9522H_PRC1522H_M		MAKEMASK(0xFF, 0)
#define GLPRT_PRC9522L(_i)			(0x00380A80 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_PRC9522L_MAX_INDEX		7
#define GLPRT_PRC9522L_PRC1522L_S		0
#define GLPRT_PRC9522L_PRC1522L_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_PTC1023H(_i)			(0x00380C84 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_PTC1023H_MAX_INDEX		7
#define GLPRT_PTC1023H_PTC1023H_S		0
#define GLPRT_PTC1023H_PTC1023H_M		MAKEMASK(0xFF, 0)
#define GLPRT_PTC1023L(_i)			(0x00380C80 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_PTC1023L_MAX_INDEX		7
#define GLPRT_PTC1023L_PTC1023L_S		0
#define GLPRT_PTC1023L_PTC1023L_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_PTC127H(_i)			(0x00380BC4 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_PTC127H_MAX_INDEX			7
#define GLPRT_PTC127H_PTC127H_S			0
#define GLPRT_PTC127H_PTC127H_M			MAKEMASK(0xFF, 0)
#define GLPRT_PTC127L(_i)			(0x00380BC0 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_PTC127L_MAX_INDEX			7
#define GLPRT_PTC127L_PTC127L_S			0
#define GLPRT_PTC127L_PTC127L_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_PTC1522H(_i)			(0x00380CC4 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_PTC1522H_MAX_INDEX		7
#define GLPRT_PTC1522H_PTC1522H_S		0
#define GLPRT_PTC1522H_PTC1522H_M		MAKEMASK(0xFF, 0)
#define GLPRT_PTC1522L(_i)			(0x00380CC0 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_PTC1522L_MAX_INDEX		7
#define GLPRT_PTC1522L_PTC1522L_S		0
#define GLPRT_PTC1522L_PTC1522L_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_PTC255H(_i)			(0x00380C04 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_PTC255H_MAX_INDEX			7
#define GLPRT_PTC255H_PTC255H_S			0
#define GLPRT_PTC255H_PTC255H_M			MAKEMASK(0xFF, 0)
#define GLPRT_PTC255L(_i)			(0x00380C00 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_PTC255L_MAX_INDEX			7
#define GLPRT_PTC255L_PTC255L_S			0
#define GLPRT_PTC255L_PTC255L_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_PTC511H(_i)			(0x00380C44 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_PTC511H_MAX_INDEX			7
#define GLPRT_PTC511H_PTC511H_S			0
#define GLPRT_PTC511H_PTC511H_M			MAKEMASK(0xFF, 0)
#define GLPRT_PTC511L(_i)			(0x00380C40 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_PTC511L_MAX_INDEX			7
#define GLPRT_PTC511L_PTC511L_S			0
#define GLPRT_PTC511L_PTC511L_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_PTC64H(_i)			(0x00380B84 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_PTC64H_MAX_INDEX			7
#define GLPRT_PTC64H_PTC64H_S			0
#define GLPRT_PTC64H_PTC64H_M			MAKEMASK(0xFF, 0)
#define GLPRT_PTC64L(_i)			(0x00380B80 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_PTC64L_MAX_INDEX			7
#define GLPRT_PTC64L_PTC64L_S			0
#define GLPRT_PTC64L_PTC64L_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_PTC9522H(_i)			(0x00380D04 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_PTC9522H_MAX_INDEX		7
#define GLPRT_PTC9522H_PTC9522H_S		0
#define GLPRT_PTC9522H_PTC9522H_M		MAKEMASK(0xFF, 0)
#define GLPRT_PTC9522L(_i)			(0x00380D00 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_PTC9522L_MAX_INDEX		7
#define GLPRT_PTC9522L_PTC9522L_S		0
#define GLPRT_PTC9522L_PTC9522L_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_PXOFFRXC(_i, _j)			(0x00380500 + ((_i) * 8 + (_j) * 64)) /* _i=0...7, _j=0...7 */ /* Reset Source: CORER */
#define GLPRT_PXOFFRXC_MAX_INDEX		7
#define GLPRT_PXOFFRXC_PRPXOFFRXCNT_S		0
#define GLPRT_PXOFFRXC_PRPXOFFRXCNT_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_PXOFFRXC_H(_i, _j)		(0x00380504 + ((_i) * 8 + (_j) * 64)) /* _i=0...7, _j=0...7 */ /* Reset Source: CORER */
#define GLPRT_PXOFFRXC_H_MAX_INDEX		7
#define GLPRT_PXOFFRXC_H_PRPXOFFRXCNT_S		0
#define GLPRT_PXOFFRXC_H_PRPXOFFRXCNT_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_PXOFFTXC(_i, _j)			(0x00380F40 + ((_i) * 8 + (_j) * 64)) /* _i=0...7, _j=0...7 */ /* Reset Source: CORER */
#define GLPRT_PXOFFTXC_MAX_INDEX		7
#define GLPRT_PXOFFTXC_PRPXOFFTXCNT_S		0
#define GLPRT_PXOFFTXC_PRPXOFFTXCNT_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_PXOFFTXC_H(_i, _j)		(0x00380F44 + ((_i) * 8 + (_j) * 64)) /* _i=0...7, _j=0...7 */ /* Reset Source: CORER */
#define GLPRT_PXOFFTXC_H_MAX_INDEX		7
#define GLPRT_PXOFFTXC_H_PRPXOFFTXCNT_S		0
#define GLPRT_PXOFFTXC_H_PRPXOFFTXCNT_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_PXONRXC(_i, _j)			(0x00380300 + ((_i) * 8 + (_j) * 64)) /* _i=0...7, _j=0...7 */ /* Reset Source: CORER */
#define GLPRT_PXONRXC_MAX_INDEX			7
#define GLPRT_PXONRXC_PRPXONRXCNT_S		0
#define GLPRT_PXONRXC_PRPXONRXCNT_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_PXONRXC_H(_i, _j)			(0x00380304 + ((_i) * 8 + (_j) * 64)) /* _i=0...7, _j=0...7 */ /* Reset Source: CORER */
#define GLPRT_PXONRXC_H_MAX_INDEX		7
#define GLPRT_PXONRXC_H_PRPXONRXCNT_S		0
#define GLPRT_PXONRXC_H_PRPXONRXCNT_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_PXONTXC(_i, _j)			(0x00380D40 + ((_i) * 8 + (_j) * 64)) /* _i=0...7, _j=0...7 */ /* Reset Source: CORER */
#define GLPRT_PXONTXC_MAX_INDEX			7
#define GLPRT_PXONTXC_PRPXONTXC_S		0
#define GLPRT_PXONTXC_PRPXONTXC_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_PXONTXC_H(_i, _j)			(0x00380D44 + ((_i) * 8 + (_j) * 64)) /* _i=0...7, _j=0...7 */ /* Reset Source: CORER */
#define GLPRT_PXONTXC_H_MAX_INDEX		7
#define GLPRT_PXONTXC_H_PRPXONTXC_S		0
#define GLPRT_PXONTXC_H_PRPXONTXC_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_RFC(_i)				(0x00380AC0 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_RFC_MAX_INDEX			7
#define GLPRT_RFC_RFC_S				0
#define GLPRT_RFC_RFC_M				MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_RFC_H(_i)				(0x00380AC4 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_RFC_H_MAX_INDEX			7
#define GLPRT_RFC_H_RFC_S			0
#define GLPRT_RFC_H_RFC_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_RJC(_i)				(0x00380B00 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_RJC_MAX_INDEX			7
#define GLPRT_RJC_RJC_S				0
#define GLPRT_RJC_RJC_M				MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_RJC_H(_i)				(0x00380B04 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_RJC_H_MAX_INDEX			7
#define GLPRT_RJC_H_RJC_S			0
#define GLPRT_RJC_H_RJC_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_RLEC(_i)				(0x00380140 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_RLEC_MAX_INDEX			7
#define GLPRT_RLEC_RLEC_S			0
#define GLPRT_RLEC_RLEC_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_RLEC_H(_i)			(0x00380144 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_RLEC_H_MAX_INDEX			7
#define GLPRT_RLEC_H_RLEC_S			0
#define GLPRT_RLEC_H_RLEC_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_ROC(_i)				(0x00380240 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_ROC_MAX_INDEX			7
#define GLPRT_ROC_ROC_S				0
#define GLPRT_ROC_ROC_M				MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_ROC_H(_i)				(0x00380244 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_ROC_H_MAX_INDEX			7
#define GLPRT_ROC_H_ROC_S			0
#define GLPRT_ROC_H_ROC_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_RUC(_i)				(0x00380200 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_RUC_MAX_INDEX			7
#define GLPRT_RUC_RUC_S				0
#define GLPRT_RUC_RUC_M				MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_RUC_H(_i)				(0x00380204 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_RUC_H_MAX_INDEX			7
#define GLPRT_RUC_H_RUC_S			0
#define GLPRT_RUC_H_RUC_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_RXON2OFFCNT(_i, _j)		(0x00380700 + ((_i) * 8 + (_j) * 64)) /* _i=0...7, _j=0...7 */ /* Reset Source: CORER */
#define GLPRT_RXON2OFFCNT_MAX_INDEX		7
#define GLPRT_RXON2OFFCNT_PRRXON2OFFCNT_S	0
#define GLPRT_RXON2OFFCNT_PRRXON2OFFCNT_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_RXON2OFFCNT_H(_i, _j)		(0x00380704 + ((_i) * 8 + (_j) * 64)) /* _i=0...7, _j=0...7 */ /* Reset Source: CORER */
#define GLPRT_RXON2OFFCNT_H_MAX_INDEX		7
#define GLPRT_RXON2OFFCNT_H_PRRXON2OFFCNT_S	0
#define GLPRT_RXON2OFFCNT_H_PRRXON2OFFCNT_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_STDC(_i)				(0x00340000 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_STDC_MAX_INDEX			7
#define GLPRT_STDC_STDC_S			0
#define GLPRT_STDC_STDC_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_TDOLD(_i)				(0x00381280 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_TDOLD_MAX_INDEX			7
#define GLPRT_TDOLD_GLPRT_TDOLD_S		0
#define GLPRT_TDOLD_GLPRT_TDOLD_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_TDOLD_H(_i)			(0x00381284 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_TDOLD_H_MAX_INDEX			7
#define GLPRT_TDOLD_H_GLPRT_TDOLD_S		0
#define GLPRT_TDOLD_H_GLPRT_TDOLD_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_UPRCH(_i)				(0x00381304 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_UPRCH_MAX_INDEX			7
#define GLPRT_UPRCH_UPRCH_S			0
#define GLPRT_UPRCH_UPRCH_M			MAKEMASK(0xFF, 0)
#define GLPRT_UPRCL(_i)				(0x00381300 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_UPRCL_MAX_INDEX			7
#define GLPRT_UPRCL_UPRCL_S			0
#define GLPRT_UPRCL_UPRCL_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLPRT_UPTCH(_i)				(0x003811C4 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_UPTCH_MAX_INDEX			7
#define GLPRT_UPTCH_UPTCH_S			0
#define GLPRT_UPTCH_UPTCH_M			MAKEMASK(0xFF, 0)
#define GLPRT_UPTCL(_i)				(0x003811C0 + ((_i) * 8)) /* _i=0...7 */ /* Reset Source: CORER */
#define GLPRT_UPTCL_MAX_INDEX			7
#define GLPRT_UPTCL_VUPTCH_S			0
#define GLPRT_UPTCL_VUPTCH_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLSTAT_ACL_CNT_0_H(_i)			(0x00388004 + ((_i) * 8)) /* _i=0...511 */ /* Reset Source: CORER */
#define GLSTAT_ACL_CNT_0_H_MAX_INDEX		511
#define GLSTAT_ACL_CNT_0_H_CNT_MSB_S		0
#define GLSTAT_ACL_CNT_0_H_CNT_MSB_M		MAKEMASK(0xFF, 0)
#define GLSTAT_ACL_CNT_0_L(_i)			(0x00388000 + ((_i) * 8)) /* _i=0...511 */ /* Reset Source: CORER */
#define GLSTAT_ACL_CNT_0_L_MAX_INDEX		511
#define GLSTAT_ACL_CNT_0_L_CNT_LSB_S		0
#define GLSTAT_ACL_CNT_0_L_CNT_LSB_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLSTAT_ACL_CNT_1_H(_i)			(0x00389004 + ((_i) * 8)) /* _i=0...511 */ /* Reset Source: CORER */
#define GLSTAT_ACL_CNT_1_H_MAX_INDEX		511
#define GLSTAT_ACL_CNT_1_H_CNT_MSB_S		0
#define GLSTAT_ACL_CNT_1_H_CNT_MSB_M		MAKEMASK(0xFF, 0)
#define GLSTAT_ACL_CNT_1_L(_i)			(0x00389000 + ((_i) * 8)) /* _i=0...511 */ /* Reset Source: CORER */
#define GLSTAT_ACL_CNT_1_L_MAX_INDEX		511
#define GLSTAT_ACL_CNT_1_L_CNT_LSB_S		0
#define GLSTAT_ACL_CNT_1_L_CNT_LSB_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLSTAT_ACL_CNT_2_H(_i)			(0x0038A004 + ((_i) * 8)) /* _i=0...511 */ /* Reset Source: CORER */
#define GLSTAT_ACL_CNT_2_H_MAX_INDEX		511
#define GLSTAT_ACL_CNT_2_H_CNT_MSB_S		0
#define GLSTAT_ACL_CNT_2_H_CNT_MSB_M		MAKEMASK(0xFF, 0)
#define GLSTAT_ACL_CNT_2_L(_i)			(0x0038A000 + ((_i) * 8)) /* _i=0...511 */ /* Reset Source: CORER */
#define GLSTAT_ACL_CNT_2_L_MAX_INDEX		511
#define GLSTAT_ACL_CNT_2_L_CNT_LSB_S		0
#define GLSTAT_ACL_CNT_2_L_CNT_LSB_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLSTAT_ACL_CNT_3_H(_i)			(0x0038B004 + ((_i) * 8)) /* _i=0...511 */ /* Reset Source: CORER */
#define GLSTAT_ACL_CNT_3_H_MAX_INDEX		511
#define GLSTAT_ACL_CNT_3_H_CNT_MSB_S		0
#define GLSTAT_ACL_CNT_3_H_CNT_MSB_M		MAKEMASK(0xFF, 0)
#define GLSTAT_ACL_CNT_3_L(_i)			(0x0038B000 + ((_i) * 8)) /* _i=0...511 */ /* Reset Source: CORER */
#define GLSTAT_ACL_CNT_3_L_MAX_INDEX		511
#define GLSTAT_ACL_CNT_3_L_CNT_LSB_S		0
#define GLSTAT_ACL_CNT_3_L_CNT_LSB_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLSTAT_FD_CNT0H(_i)			(0x003A0004 + ((_i) * 8)) /* _i=0...4095 */ /* Reset Source: CORER */
#define GLSTAT_FD_CNT0H_MAX_INDEX		4095
#define GLSTAT_FD_CNT0H_FD0_CNT_H_S		0
#define GLSTAT_FD_CNT0H_FD0_CNT_H_M		MAKEMASK(0xFF, 0)
#define GLSTAT_FD_CNT0L(_i)			(0x003A0000 + ((_i) * 8)) /* _i=0...4095 */ /* Reset Source: CORER */
#define GLSTAT_FD_CNT0L_MAX_INDEX		4095
#define GLSTAT_FD_CNT0L_FD0_CNT_L_S		0
#define GLSTAT_FD_CNT0L_FD0_CNT_L_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLSTAT_FD_CNT1H(_i)			(0x003A8004 + ((_i) * 8)) /* _i=0...4095 */ /* Reset Source: CORER */
#define GLSTAT_FD_CNT1H_MAX_INDEX		4095
#define GLSTAT_FD_CNT1H_FD0_CNT_H_S		0
#define GLSTAT_FD_CNT1H_FD0_CNT_H_M		MAKEMASK(0xFF, 0)
#define GLSTAT_FD_CNT1L(_i)			(0x003A8000 + ((_i) * 8)) /* _i=0...4095 */ /* Reset Source: CORER */
#define GLSTAT_FD_CNT1L_MAX_INDEX		4095
#define GLSTAT_FD_CNT1L_FD0_CNT_L_S		0
#define GLSTAT_FD_CNT1L_FD0_CNT_L_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLSW_BPRCH(_i)				(0x00346204 + ((_i) * 8)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLSW_BPRCH_MAX_INDEX			31
#define GLSW_BPRCH_BPRCH_S			0
#define GLSW_BPRCH_BPRCH_M			MAKEMASK(0xFF, 0)
#define GLSW_BPRCL(_i)				(0x00346200 + ((_i) * 8)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLSW_BPRCL_MAX_INDEX			31
#define GLSW_BPRCL_BPRCL_S			0
#define GLSW_BPRCL_BPRCL_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLSW_BPTCH(_i)				(0x00310204 + ((_i) * 8)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLSW_BPTCH_MAX_INDEX			31
#define GLSW_BPTCH_BPTCH_S			0
#define GLSW_BPTCH_BPTCH_M			MAKEMASK(0xFF, 0)
#define GLSW_BPTCL(_i)				(0x00310200 + ((_i) * 8)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLSW_BPTCL_MAX_INDEX			31
#define GLSW_BPTCL_BPTCL_S			0
#define GLSW_BPTCL_BPTCL_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLSW_GORCH(_i)				(0x00341004 + ((_i) * 8)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLSW_GORCH_MAX_INDEX			31
#define GLSW_GORCH_GORCH_S			0
#define GLSW_GORCH_GORCH_M			MAKEMASK(0xFF, 0)
#define GLSW_GORCL(_i)				(0x00341000 + ((_i) * 8)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLSW_GORCL_MAX_INDEX			31
#define GLSW_GORCL_GORCL_S			0
#define GLSW_GORCL_GORCL_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLSW_GOTCH(_i)				(0x00302004 + ((_i) * 8)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLSW_GOTCH_MAX_INDEX			31
#define GLSW_GOTCH_GOTCH_S			0
#define GLSW_GOTCH_GOTCH_M			MAKEMASK(0xFF, 0)
#define GLSW_GOTCL(_i)				(0x00302000 + ((_i) * 8)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLSW_GOTCL_MAX_INDEX			31
#define GLSW_GOTCL_GOTCL_S			0
#define GLSW_GOTCL_GOTCL_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLSW_MPRCH(_i)				(0x00346104 + ((_i) * 8)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLSW_MPRCH_MAX_INDEX			31
#define GLSW_MPRCH_MPRCH_S			0
#define GLSW_MPRCH_MPRCH_M			MAKEMASK(0xFF, 0)
#define GLSW_MPRCL(_i)				(0x00346100 + ((_i) * 8)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLSW_MPRCL_MAX_INDEX			31
#define GLSW_MPRCL_MPRCL_S			0
#define GLSW_MPRCL_MPRCL_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLSW_MPTCH(_i)				(0x00310104 + ((_i) * 8)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLSW_MPTCH_MAX_INDEX			31
#define GLSW_MPTCH_MPTCH_S			0
#define GLSW_MPTCH_MPTCH_M			MAKEMASK(0xFF, 0)
#define GLSW_MPTCL(_i)				(0x00310100 + ((_i) * 8)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLSW_MPTCL_MAX_INDEX			31
#define GLSW_MPTCL_MPTCL_S			0
#define GLSW_MPTCL_MPTCL_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLSW_UPRCH(_i)				(0x00346004 + ((_i) * 8)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLSW_UPRCH_MAX_INDEX			31
#define GLSW_UPRCH_UPRCH_S			0
#define GLSW_UPRCH_UPRCH_M			MAKEMASK(0xFF, 0)
#define GLSW_UPRCL(_i)				(0x00346000 + ((_i) * 8)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLSW_UPRCL_MAX_INDEX			31
#define GLSW_UPRCL_UPRCL_S			0
#define GLSW_UPRCL_UPRCL_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLSW_UPTCH(_i)				(0x00310004 + ((_i) * 8)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLSW_UPTCH_MAX_INDEX			31
#define GLSW_UPTCH_UPTCH_S			0
#define GLSW_UPTCH_UPTCH_M			MAKEMASK(0xFF, 0)
#define GLSW_UPTCL(_i)				(0x00310000 + ((_i) * 8)) /* _i=0...31 */ /* Reset Source: CORER */
#define GLSW_UPTCL_MAX_INDEX			31
#define GLSW_UPTCL_UPTCL_S			0
#define GLSW_UPTCL_UPTCL_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLSWID_RUPP(_i)				(0x00345000 + ((_i) * 4)) /* _i=0...255 */ /* Reset Source: CORER */
#define GLSWID_RUPP_MAX_INDEX			255
#define GLSWID_RUPP_RUPP_S			0
#define GLSWID_RUPP_RUPP_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLV_BPRCH(_i)				(0x003B6004 + ((_i) * 8)) /* _i=0...767 */ /* Reset Source: CORER */
#define GLV_BPRCH_MAX_INDEX			767
#define GLV_BPRCH_BPRCH_S			0
#define GLV_BPRCH_BPRCH_M			MAKEMASK(0xFF, 0)
#define GLV_BPRCL(_i)				(0x003B6000 + ((_i) * 8)) /* _i=0...767 */ /* Reset Source: CORER */
#define GLV_BPRCL_MAX_INDEX			767
#define GLV_BPRCL_BPRCL_S			0
#define GLV_BPRCL_BPRCL_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLV_BPTCH(_i)				(0x0030E004 + ((_i) * 8)) /* _i=0...767 */ /* Reset Source: CORER */
#define GLV_BPTCH_MAX_INDEX			767
#define GLV_BPTCH_BPTCH_S			0
#define GLV_BPTCH_BPTCH_M			MAKEMASK(0xFF, 0)
#define GLV_BPTCL(_i)				(0x0030E000 + ((_i) * 8)) /* _i=0...767 */ /* Reset Source: CORER */
#define GLV_BPTCL_MAX_INDEX			767
#define GLV_BPTCL_BPTCL_S			0
#define GLV_BPTCL_BPTCL_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLV_GORCH(_i)				(0x003B0004 + ((_i) * 8)) /* _i=0...767 */ /* Reset Source: CORER */
#define GLV_GORCH_MAX_INDEX			767
#define GLV_GORCH_GORCH_S			0
#define GLV_GORCH_GORCH_M			MAKEMASK(0xFF, 0)
#define GLV_GORCL(_i)				(0x003B0000 + ((_i) * 8)) /* _i=0...767 */ /* Reset Source: CORER */
#define GLV_GORCL_MAX_INDEX			767
#define GLV_GORCL_GORCL_S			0
#define GLV_GORCL_GORCL_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLV_GOTCH(_i)				(0x00300004 + ((_i) * 8)) /* _i=0...767 */ /* Reset Source: CORER */
#define GLV_GOTCH_MAX_INDEX			767
#define GLV_GOTCH_GOTCH_S			0
#define GLV_GOTCH_GOTCH_M			MAKEMASK(0xFF, 0)
#define GLV_GOTCL(_i)				(0x00300000 + ((_i) * 8)) /* _i=0...767 */ /* Reset Source: CORER */
#define GLV_GOTCL_MAX_INDEX			767
#define GLV_GOTCL_GOTCL_S			0
#define GLV_GOTCL_GOTCL_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLV_MPRCH(_i)				(0x003B4004 + ((_i) * 8)) /* _i=0...767 */ /* Reset Source: CORER */
#define GLV_MPRCH_MAX_INDEX			767
#define GLV_MPRCH_MPRCH_S			0
#define GLV_MPRCH_MPRCH_M			MAKEMASK(0xFF, 0)
#define GLV_MPRCL(_i)				(0x003B4000 + ((_i) * 8)) /* _i=0...767 */ /* Reset Source: CORER */
#define GLV_MPRCL_MAX_INDEX			767
#define GLV_MPRCL_MPRCL_S			0
#define GLV_MPRCL_MPRCL_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLV_MPTCH(_i)				(0x0030C004 + ((_i) * 8)) /* _i=0...767 */ /* Reset Source: CORER */
#define GLV_MPTCH_MAX_INDEX			767
#define GLV_MPTCH_MPTCH_S			0
#define GLV_MPTCH_MPTCH_M			MAKEMASK(0xFF, 0)
#define GLV_MPTCL(_i)				(0x0030C000 + ((_i) * 8)) /* _i=0...767 */ /* Reset Source: CORER */
#define GLV_MPTCL_MAX_INDEX			767
#define GLV_MPTCL_MPTCL_S			0
#define GLV_MPTCL_MPTCL_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLV_RDPC(_i)				(0x00294C04 + ((_i) * 4)) /* _i=0...767 */ /* Reset Source: CORER */
#define GLV_RDPC_MAX_INDEX			767
#define GLV_RDPC_RDPC_S				0
#define GLV_RDPC_RDPC_M				MAKEMASK(0xFFFFFFFF, 0)
#define GLV_REPC(_i)				(0x00295804 + ((_i) * 4)) /* _i=0...767 */ /* Reset Source: CORER */
#define GLV_REPC_MAX_INDEX			767
#define GLV_REPC_NO_DESC_CNT_S			0
#define GLV_REPC_NO_DESC_CNT_M			MAKEMASK(0xFFFF, 0)
#define GLV_REPC_ERROR_CNT_S			16
#define GLV_REPC_ERROR_CNT_M			MAKEMASK(0xFFFF, 16)
#define GLV_TEPC(_VSI)				(0x00312000 + ((_VSI) * 4)) /* _i=0...767 */ /* Reset Source: CORER */
#define GLV_TEPC_MAX_INDEX			767
#define GLV_TEPC_TEPC_S				0
#define GLV_TEPC_TEPC_M				MAKEMASK(0xFFFFFFFF, 0)
#define GLV_UPRCH(_i)				(0x003B2004 + ((_i) * 8)) /* _i=0...767 */ /* Reset Source: CORER */
#define GLV_UPRCH_MAX_INDEX			767
#define GLV_UPRCH_UPRCH_S			0
#define GLV_UPRCH_UPRCH_M			MAKEMASK(0xFF, 0)
#define GLV_UPRCL(_i)				(0x003B2000 + ((_i) * 8)) /* _i=0...767 */ /* Reset Source: CORER */
#define GLV_UPRCL_MAX_INDEX			767
#define GLV_UPRCL_UPRCL_S			0
#define GLV_UPRCL_UPRCL_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLV_UPTCH(_i)				(0x0030A004 + ((_i) * 8)) /* _i=0...767 */ /* Reset Source: CORER */
#define GLV_UPTCH_MAX_INDEX			767
#define GLV_UPTCH_GLVUPTCH_S			0
#define GLV_UPTCH_GLVUPTCH_M			MAKEMASK(0xFF, 0)
#define GLV_UPTCL(_i)				(0x0030A000 + ((_i) * 8)) /* _i=0...767 */ /* Reset Source: CORER */
#define GLV_UPTCL_MAX_INDEX			767
#define GLV_UPTCL_UPTCL_S			0
#define GLV_UPTCL_UPTCL_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLVEBUP_RBCH(_i, _j)			(0x00343004 + ((_i) * 8 + (_j) * 64)) /* _i=0...7, _j=0...31 */ /* Reset Source: CORER */
#define GLVEBUP_RBCH_MAX_INDEX			7
#define GLVEBUP_RBCH_UPBCH_S			0
#define GLVEBUP_RBCH_UPBCH_M			MAKEMASK(0xFF, 0)
#define GLVEBUP_RBCL(_i, _j)			(0x00343000 + ((_i) * 8 + (_j) * 64)) /* _i=0...7, _j=0...31 */ /* Reset Source: CORER */
#define GLVEBUP_RBCL_MAX_INDEX			7
#define GLVEBUP_RBCL_UPBCL_S			0
#define GLVEBUP_RBCL_UPBCL_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLVEBUP_RPCH(_i, _j)			(0x00344004 + ((_i) * 8 + (_j) * 64)) /* _i=0...7, _j=0...31 */ /* Reset Source: CORER */
#define GLVEBUP_RPCH_MAX_INDEX			7
#define GLVEBUP_RPCH_UPPCH_S			0
#define GLVEBUP_RPCH_UPPCH_M			MAKEMASK(0xFF, 0)
#define GLVEBUP_RPCL(_i, _j)			(0x00344000 + ((_i) * 8 + (_j) * 64)) /* _i=0...7, _j=0...31 */ /* Reset Source: CORER */
#define GLVEBUP_RPCL_MAX_INDEX			7
#define GLVEBUP_RPCL_UPPCL_S			0
#define GLVEBUP_RPCL_UPPCL_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLVEBUP_TBCH(_i, _j)			(0x00306004 + ((_i) * 8 + (_j) * 64)) /* _i=0...7, _j=0...31 */ /* Reset Source: CORER */
#define GLVEBUP_TBCH_MAX_INDEX			7
#define GLVEBUP_TBCH_UPBCH_S			0
#define GLVEBUP_TBCH_UPBCH_M			MAKEMASK(0xFF, 0)
#define GLVEBUP_TBCL(_i, _j)			(0x00306000 + ((_i) * 8 + (_j) * 64)) /* _i=0...7, _j=0...31 */ /* Reset Source: CORER */
#define GLVEBUP_TBCL_MAX_INDEX			7
#define GLVEBUP_TBCL_UPBCL_S			0
#define GLVEBUP_TBCL_UPBCL_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLVEBUP_TPCH(_i, _j)			(0x00308004 + ((_i) * 8 + (_j) * 64)) /* _i=0...7, _j=0...31 */ /* Reset Source: CORER */
#define GLVEBUP_TPCH_MAX_INDEX			7
#define GLVEBUP_TPCH_UPPCH_S			0
#define GLVEBUP_TPCH_UPPCH_M			MAKEMASK(0xFF, 0)
#define GLVEBUP_TPCL(_i, _j)			(0x00308000 + ((_i) * 8 + (_j) * 64)) /* _i=0...7, _j=0...31 */ /* Reset Source: CORER */
#define GLVEBUP_TPCL_MAX_INDEX			7
#define GLVEBUP_TPCL_UPPCL_S			0
#define GLVEBUP_TPCL_UPPCL_M			MAKEMASK(0xFFFFFFFF, 0)
#define PRTRPB_LDPC				0x000AC280 /* Reset Source: CORER */
#define PRTRPB_LDPC_CRCERRS_S			0
#define PRTRPB_LDPC_CRCERRS_M			MAKEMASK(0xFFFFFFFF, 0)
#define PRTRPB_RDPC				0x000AC260 /* Reset Source: CORER */
#define PRTRPB_RDPC_CRCERRS_S			0
#define PRTRPB_RDPC_CRCERRS_M			MAKEMASK(0xFFFFFFFF, 0)
#define PRTTPB_STAT_TC_BYTES_SENTL(_i)		(0x00098200 + ((_i) * 4)) /* _i=0...63 */ /* Reset Source: CORER */
#define PRTTPB_STAT_TC_BYTES_SENTL_MAX_INDEX	63
#define PRTTPB_STAT_TC_BYTES_SENTL_TCCNT_S	0
#define PRTTPB_STAT_TC_BYTES_SENTL_TCCNT_M	MAKEMASK(0xFFFFFFFF, 0)
#define TPB_PRTTPB_STAT_PKT_SENT(_i)		(0x00099470 + ((_i) * 4)) /* _i=0...7 */ /* Reset Source: CORER */
#define TPB_PRTTPB_STAT_PKT_SENT_MAX_INDEX	7
#define TPB_PRTTPB_STAT_PKT_SENT_PKTCNT_S	0
#define TPB_PRTTPB_STAT_PKT_SENT_PKTCNT_M	MAKEMASK(0xFFFFFFFF, 0)
#define TPB_PRTTPB_STAT_TC_BYTES_SENT(_i)	(0x00099094 + ((_i) * 4)) /* _i=0...63 */ /* Reset Source: CORER */
#define TPB_PRTTPB_STAT_TC_BYTES_SENT_MAX_INDEX 63
#define TPB_PRTTPB_STAT_TC_BYTES_SENT_TCCNT_S	0
#define TPB_PRTTPB_STAT_TC_BYTES_SENT_TCCNT_M	MAKEMASK(0xFFFFFFFF, 0)
#define EMP_SWT_PRUNIND				0x00204020 /* Reset Source: CORER */
#define EMP_SWT_PRUNIND_OPCODE_S		0
#define EMP_SWT_PRUNIND_OPCODE_M		MAKEMASK(0xF, 0)
#define EMP_SWT_PRUNIND_LIST_INDEX_NUM_S	4
#define EMP_SWT_PRUNIND_LIST_INDEX_NUM_M	MAKEMASK(0x3FF, 4)
#define EMP_SWT_PRUNIND_VSI_NUM_S		16
#define EMP_SWT_PRUNIND_VSI_NUM_M		MAKEMASK(0x3FF, 16)
#define EMP_SWT_PRUNIND_BIT_VALUE_S		31
#define EMP_SWT_PRUNIND_BIT_VALUE_M		BIT(31)
#define EMP_SWT_REPIND				0x0020401C /* Reset Source: CORER */
#define EMP_SWT_REPIND_OPCODE_S			0
#define EMP_SWT_REPIND_OPCODE_M			MAKEMASK(0xF, 0)
#define EMP_SWT_REPIND_LIST_INDEX_NUMBER_S	4
#define EMP_SWT_REPIND_LIST_INDEX_NUMBER_M	MAKEMASK(0x3FF, 4)
#define EMP_SWT_REPIND_VSI_NUM_S		16
#define EMP_SWT_REPIND_VSI_NUM_M		MAKEMASK(0x3FF, 16)
#define EMP_SWT_REPIND_BIT_VALUE_S		31
#define EMP_SWT_REPIND_BIT_VALUE_M		BIT(31)
#define GL_OVERRIDEC				0x002040A4 /* Reset Source: CORER */
#define GL_OVERRIDEC_OVERRIDE_ATTEMPTC_S	0
#define GL_OVERRIDEC_OVERRIDE_ATTEMPTC_M	MAKEMASK(0xFFFF, 0)
#define GL_OVERRIDEC_LAST_VSI_S			16
#define GL_OVERRIDEC_LAST_VSI_M			MAKEMASK(0x3FF, 16)
#define GL_PLG_AVG_CALC_CFG			0x0020A5AC /* Reset Source: CORER */
#define GL_PLG_AVG_CALC_CFG_CYCLE_LEN_S		0
#define GL_PLG_AVG_CALC_CFG_CYCLE_LEN_M		MAKEMASK(0x7FFFFFFF, 0)
#define GL_PLG_AVG_CALC_CFG_MODE_S		31
#define GL_PLG_AVG_CALC_CFG_MODE_M		BIT(31)
#define GL_PLG_AVG_CALC_ST			0x0020A5B0 /* Reset Source: CORER */
#define GL_PLG_AVG_CALC_ST_IN_DATA_S		0
#define GL_PLG_AVG_CALC_ST_IN_DATA_M		MAKEMASK(0x7FFF, 0)
#define GL_PLG_AVG_CALC_ST_OUT_DATA_S		16
#define GL_PLG_AVG_CALC_ST_OUT_DATA_M		MAKEMASK(0x7FFF, 16)
#define GL_PLG_AVG_CALC_ST_VALID_S		31
#define GL_PLG_AVG_CALC_ST_VALID_M		BIT(31)
#define GL_PRE_CFG_CMD				0x00214090 /* Reset Source: CORER */
#define GL_PRE_CFG_CMD_ADDR_S			0
#define GL_PRE_CFG_CMD_ADDR_M			MAKEMASK(0x1FFF, 0)
#define GL_PRE_CFG_CMD_TBLIDX_S			16
#define GL_PRE_CFG_CMD_TBLIDX_M			MAKEMASK(0x7, 16)
#define GL_PRE_CFG_CMD_CMD_S			29
#define GL_PRE_CFG_CMD_CMD_M			BIT(29)
#define GL_PRE_CFG_CMD_DONE_S			31
#define GL_PRE_CFG_CMD_DONE_M			BIT(31)
#define GL_PRE_CFG_DATA(_i)			(0x00214074 + ((_i) * 4)) /* _i=0...6 */ /* Reset Source: CORER */
#define GL_PRE_CFG_DATA_MAX_INDEX		6
#define GL_PRE_CFG_DATA_GL_PRE_RCP_DATA_S	0
#define GL_PRE_CFG_DATA_GL_PRE_RCP_DATA_M	MAKEMASK(0xFFFFFFFF, 0)
#define GL_SWT_FUNCFILT				0x001D2698 /* Reset Source: CORER */
#define GL_SWT_FUNCFILT_FUNCFILT_S		0
#define GL_SWT_FUNCFILT_FUNCFILT_M		BIT(0)
#define GL_SWT_FW_STS(_i)			(0x00216000 + ((_i) * 4)) /* _i=0...5 */ /* Reset Source: CORER */
#define GL_SWT_FW_STS_MAX_INDEX			5
#define GL_SWT_FW_STS_GL_SWT_FW_STS_S		0
#define GL_SWT_FW_STS_GL_SWT_FW_STS_M		MAKEMASK(0xFFFFFFFF, 0)
#define GL_SWT_LAT_DOUBLE			0x00204004 /* Reset Source: CORER */
#define GL_SWT_LAT_DOUBLE_BASE_S		0
#define GL_SWT_LAT_DOUBLE_BASE_M		MAKEMASK(0x7FF, 0)
#define GL_SWT_LAT_DOUBLE_SIZE_S		16
#define GL_SWT_LAT_DOUBLE_SIZE_M		MAKEMASK(0x7FF, 16)
#define GL_SWT_LAT_QUAD				0x00204008 /* Reset Source: CORER */
#define GL_SWT_LAT_QUAD_BASE_S			0
#define GL_SWT_LAT_QUAD_BASE_M			MAKEMASK(0x7FF, 0)
#define GL_SWT_LAT_QUAD_SIZE_S			16
#define GL_SWT_LAT_QUAD_SIZE_M			MAKEMASK(0x7FF, 16)
#define GL_SWT_LAT_SINGLE			0x00204000 /* Reset Source: CORER */
#define GL_SWT_LAT_SINGLE_BASE_S		0
#define GL_SWT_LAT_SINGLE_BASE_M		MAKEMASK(0x7FF, 0)
#define GL_SWT_LAT_SINGLE_SIZE_S		16
#define GL_SWT_LAT_SINGLE_SIZE_M		MAKEMASK(0x7FF, 16)
#define GL_SWT_MD_PRI				0x002040AC /* Reset Source: CORER */
#define GL_SWT_MD_PRI_VSI_PRI_S			0
#define GL_SWT_MD_PRI_VSI_PRI_M			MAKEMASK(0x7, 0)
#define GL_SWT_MD_PRI_LB_PRI_S			4
#define GL_SWT_MD_PRI_LB_PRI_M			MAKEMASK(0x7, 4)
#define GL_SWT_MD_PRI_LAN_EN_PRI_S		8
#define GL_SWT_MD_PRI_LAN_EN_PRI_M		MAKEMASK(0x7, 8)
#define GL_SWT_MD_PRI_QH_PRI_S			12
#define GL_SWT_MD_PRI_QH_PRI_M			MAKEMASK(0x7, 12)
#define GL_SWT_MD_PRI_QL_PRI_S			16
#define GL_SWT_MD_PRI_QL_PRI_M			MAKEMASK(0x7, 16)
#define GL_SWT_MIRTARVSI(_i)			(0x00204500 + ((_i) * 4)) /* _i=0...63 */ /* Reset Source: CORER */
#define GL_SWT_MIRTARVSI_MAX_INDEX		63
#define GL_SWT_MIRTARVSI_VFVMNUMBER_S		0
#define GL_SWT_MIRTARVSI_VFVMNUMBER_M		MAKEMASK(0x3FF, 0)
#define GL_SWT_MIRTARVSI_FUNCTIONTYPE_S		10
#define GL_SWT_MIRTARVSI_FUNCTIONTYPE_M		MAKEMASK(0x3, 10)
#define GL_SWT_MIRTARVSI_PFNUMBER_S		12
#define GL_SWT_MIRTARVSI_PFNUMBER_M		MAKEMASK(0x7, 12)
#define GL_SWT_MIRTARVSI_TARGETVSI_S		20
#define GL_SWT_MIRTARVSI_TARGETVSI_M		MAKEMASK(0x3FF, 20)
#define GL_SWT_MIRTARVSI_RULEENABLE_S		31
#define GL_SWT_MIRTARVSI_RULEENABLE_M		BIT(31)
#define GL_SWT_SWIDFVIDX			0x00214114 /* Reset Source: CORER */
#define GL_SWT_SWIDFVIDX_SWIDFVIDX_S		0
#define GL_SWT_SWIDFVIDX_SWIDFVIDX_M		MAKEMASK(0x3F, 0)
#define GL_SWT_SWIDFVIDX_PORT_TYPE_S		31
#define GL_SWT_SWIDFVIDX_PORT_TYPE_M		BIT(31)
#define GL_VP_SWITCHID(_i)			(0x00214094 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define GL_VP_SWITCHID_MAX_INDEX		31
#define GL_VP_SWITCHID_SWITCHID_S		0
#define GL_VP_SWITCHID_SWITCHID_M		MAKEMASK(0xFF, 0)
#define GLSWID_STAT_BLOCK(_i)			(0x0020A1A4 + ((_i) * 4)) /* _i=0...255 */ /* Reset Source: PFR */
#define GLSWID_STAT_BLOCK_MAX_INDEX		255
#define GLSWID_STAT_BLOCK_VEBID_S		0
#define GLSWID_STAT_BLOCK_VEBID_M		MAKEMASK(0x1F, 0)
#define GLSWID_STAT_BLOCK_VEBID_VALID_S		31
#define GLSWID_STAT_BLOCK_VEBID_VALID_M		BIT(31)
#define GLSWT_ACT_RESP_0			0x0020A5A4 /* Reset Source: CORER */
#define GLSWT_ACT_RESP_0_GLSWT_ACT_RESP_S	0
#define GLSWT_ACT_RESP_0_GLSWT_ACT_RESP_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLSWT_ACT_RESP_1			0x0020A5A8 /* Reset Source: CORER */
#define GLSWT_ACT_RESP_1_GLSWT_ACT_RESP_S	0
#define GLSWT_ACT_RESP_1_GLSWT_ACT_RESP_M	MAKEMASK(0xFFFFFFFF, 0)
#define GLSWT_ARB_MODE				0x0020A674 /* Reset Source: CORER */
#define GLSWT_ARB_MODE_FLU_PRI_SHM_S		0
#define GLSWT_ARB_MODE_FLU_PRI_SHM_M		BIT(0)
#define GLSWT_ARB_MODE_TX_RX_FWD_PRI_S		1
#define GLSWT_ARB_MODE_TX_RX_FWD_PRI_M		BIT(1)
#define PRT_SBPVSI				0x00204120 /* Reset Source: CORER */
#define PRT_SBPVSI_BAD_FRAMES_VSI_S		0
#define PRT_SBPVSI_BAD_FRAMES_VSI_M		MAKEMASK(0x3FF, 0)
#define PRT_SBPVSI_SBP_S			31
#define PRT_SBPVSI_SBP_M			BIT(31)
#define PRT_SCSTS				0x00204140 /* Reset Source: CORER */
#define PRT_SCSTS_BSCA_S			0
#define PRT_SCSTS_BSCA_M			BIT(0)
#define PRT_SCSTS_BSCAP_S			1
#define PRT_SCSTS_BSCAP_M			BIT(1)
#define PRT_SCSTS_MSCA_S			2
#define PRT_SCSTS_MSCA_M			BIT(2)
#define PRT_SCSTS_MSCAP_S			3
#define PRT_SCSTS_MSCAP_M			BIT(3)
#define PRT_SWT_BSCCNT				0x00204160 /* Reset Source: CORER */
#define PRT_SWT_BSCCNT_CCOUNT_S			0
#define PRT_SWT_BSCCNT_CCOUNT_M			MAKEMASK(0x1FFFFFF, 0)
#define PRT_SWT_BSCTRH				0x00204180 /* Reset Source: CORER */
#define PRT_SWT_BSCTRH_UTRESH_S			0
#define PRT_SWT_BSCTRH_UTRESH_M			MAKEMASK(0x7FFFF, 0)
#define PRT_SWT_MIREG				0x002042A0 /* Reset Source: CORER */
#define PRT_SWT_MIREG_MIRRULE_S			0
#define PRT_SWT_MIREG_MIRRULE_M			MAKEMASK(0x3F, 0)
#define PRT_SWT_MIREG_MIRENA_S			7
#define PRT_SWT_MIREG_MIRENA_M			BIT(7)
#define PRT_SWT_MIRIG				0x00204280 /* Reset Source: CORER */
#define PRT_SWT_MIRIG_MIRRULE_S			0
#define PRT_SWT_MIRIG_MIRRULE_M			MAKEMASK(0x3F, 0)
#define PRT_SWT_MIRIG_MIRENA_S			7
#define PRT_SWT_MIRIG_MIRENA_M			BIT(7)
#define PRT_SWT_MSCCNT				0x00204100 /* Reset Source: CORER */
#define PRT_SWT_MSCCNT_CCOUNT_S			0
#define PRT_SWT_MSCCNT_CCOUNT_M			MAKEMASK(0x1FFFFFF, 0)
#define PRT_SWT_MSCTRH				0x002041C0 /* Reset Source: CORER */
#define PRT_SWT_MSCTRH_UTRESH_S			0
#define PRT_SWT_MSCTRH_UTRESH_M			MAKEMASK(0x7FFFF, 0)
#define PRT_SWT_SCBI				0x002041E0 /* Reset Source: CORER */
#define PRT_SWT_SCBI_BI_S			0
#define PRT_SWT_SCBI_BI_M			MAKEMASK(0x1FFFFFF, 0)
#define PRT_SWT_SCCRL				0x00204200 /* Reset Source: CORER */
#define PRT_SWT_SCCRL_MDIPW_S			0
#define PRT_SWT_SCCRL_MDIPW_M			BIT(0)
#define PRT_SWT_SCCRL_MDICW_S			1
#define PRT_SWT_SCCRL_MDICW_M			BIT(1)
#define PRT_SWT_SCCRL_BDIPW_S			2
#define PRT_SWT_SCCRL_BDIPW_M			BIT(2)
#define PRT_SWT_SCCRL_BDICW_S			3
#define PRT_SWT_SCCRL_BDICW_M			BIT(3)
#define PRT_SWT_SCCRL_INTERVAL_S		8
#define PRT_SWT_SCCRL_INTERVAL_M		MAKEMASK(0xFFFFF, 8)
#define PRT_TCTUPR(_i)				(0x00040840 + ((_i) * 4)) /* _i=0...31 */ /* Reset Source: CORER */
#define PRT_TCTUPR_MAX_INDEX			31
#define PRT_TCTUPR_UP0_S			0
#define PRT_TCTUPR_UP0_M			MAKEMASK(0x7, 0)
#define PRT_TCTUPR_UP1_S			4
#define PRT_TCTUPR_UP1_M			MAKEMASK(0x7, 4)
#define PRT_TCTUPR_UP2_S			8
#define PRT_TCTUPR_UP2_M			MAKEMASK(0x7, 8)
#define PRT_TCTUPR_UP3_S			12
#define PRT_TCTUPR_UP3_M			MAKEMASK(0x7, 12)
#define PRT_TCTUPR_UP4_S			16
#define PRT_TCTUPR_UP4_M			MAKEMASK(0x7, 16)
#define PRT_TCTUPR_UP5_S			20
#define PRT_TCTUPR_UP5_M			MAKEMASK(0x7, 20)
#define PRT_TCTUPR_UP6_S			24
#define PRT_TCTUPR_UP6_M			MAKEMASK(0x7, 24)
#define PRT_TCTUPR_UP7_S			28
#define PRT_TCTUPR_UP7_M			MAKEMASK(0x7, 28)
#define GLHH_ART_CTL				0x000A41D4 /* Reset Source: POR */
#define GLHH_ART_CTL_ACTIVE_S			0
#define GLHH_ART_CTL_ACTIVE_M			BIT(0)
#define GLHH_ART_CTL_TIME_OUT1_S		1
#define GLHH_ART_CTL_TIME_OUT1_M		BIT(1)
#define GLHH_ART_CTL_TIME_OUT2_S		2
#define GLHH_ART_CTL_TIME_OUT2_M		BIT(2)
#define GLHH_ART_CTL_RESET_HH_S			31
#define GLHH_ART_CTL_RESET_HH_M			BIT(31)
#define GLHH_ART_DATA				0x000A41E0 /* Reset Source: POR */
#define GLHH_ART_DATA_AGENT_TYPE_S		0
#define GLHH_ART_DATA_AGENT_TYPE_M		MAKEMASK(0x7, 0)
#define GLHH_ART_DATA_SYNC_TYPE_S		3
#define GLHH_ART_DATA_SYNC_TYPE_M		BIT(3)
#define GLHH_ART_DATA_MAX_DELAY_S		4
#define GLHH_ART_DATA_MAX_DELAY_M		MAKEMASK(0xF, 4)
#define GLHH_ART_DATA_TIME_BASE_S		8
#define GLHH_ART_DATA_TIME_BASE_M		MAKEMASK(0xF, 8)
#define GLHH_ART_DATA_RSV_DATA_S		12
#define GLHH_ART_DATA_RSV_DATA_M		MAKEMASK(0xFFFFF, 12)
#define GLHH_ART_TIME_H				0x000A41D8 /* Reset Source: POR */
#define GLHH_ART_TIME_H_ART_TIME_H_S		0
#define GLHH_ART_TIME_H_ART_TIME_H_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLHH_ART_TIME_L				0x000A41DC /* Reset Source: POR */
#define GLHH_ART_TIME_L_ART_TIME_L_S		0
#define GLHH_ART_TIME_L_ART_TIME_L_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLTSYN_AUX_IN_0(_i)			(0x000889D8 + ((_i) * 4)) /* _i=0...1 */ /* Reset Source: CORER */
#define GLTSYN_AUX_IN_0_MAX_INDEX		1
#define GLTSYN_AUX_IN_0_EVNTLVL_S		0
#define GLTSYN_AUX_IN_0_EVNTLVL_M		MAKEMASK(0x3, 0)
#define GLTSYN_AUX_IN_0_INT_ENA_S		4
#define GLTSYN_AUX_IN_0_INT_ENA_M		BIT(4)
#define GLTSYN_AUX_IN_1(_i)			(0x000889E0 + ((_i) * 4)) /* _i=0...1 */ /* Reset Source: CORER */
#define GLTSYN_AUX_IN_1_MAX_INDEX		1
#define GLTSYN_AUX_IN_1_EVNTLVL_S		0
#define GLTSYN_AUX_IN_1_EVNTLVL_M		MAKEMASK(0x3, 0)
#define GLTSYN_AUX_IN_1_INT_ENA_S		4
#define GLTSYN_AUX_IN_1_INT_ENA_M		BIT(4)
#define GLTSYN_AUX_IN_2(_i)			(0x000889E8 + ((_i) * 4)) /* _i=0...1 */ /* Reset Source: CORER */
#define GLTSYN_AUX_IN_2_MAX_INDEX		1
#define GLTSYN_AUX_IN_2_EVNTLVL_S		0
#define GLTSYN_AUX_IN_2_EVNTLVL_M		MAKEMASK(0x3, 0)
#define GLTSYN_AUX_IN_2_INT_ENA_S		4
#define GLTSYN_AUX_IN_2_INT_ENA_M		BIT(4)
#define GLTSYN_AUX_OUT_0(_i)			(0x00088998 + ((_i) * 4)) /* _i=0...1 */ /* Reset Source: CORER */
#define GLTSYN_AUX_OUT_0_MAX_INDEX		1
#define GLTSYN_AUX_OUT_0_OUT_ENA_S		0
#define GLTSYN_AUX_OUT_0_OUT_ENA_M		BIT(0)
#define GLTSYN_AUX_OUT_0_OUTMOD_S		1
#define GLTSYN_AUX_OUT_0_OUTMOD_M		MAKEMASK(0x3, 1)
#define GLTSYN_AUX_OUT_0_OUTLVL_S		3
#define GLTSYN_AUX_OUT_0_OUTLVL_M		BIT(3)
#define GLTSYN_AUX_OUT_0_INT_ENA_S		4
#define GLTSYN_AUX_OUT_0_INT_ENA_M		BIT(4)
#define GLTSYN_AUX_OUT_0_PULSEW_S		8
#define GLTSYN_AUX_OUT_0_PULSEW_M		MAKEMASK(0xF, 8)
#define GLTSYN_AUX_OUT_1(_i)			(0x000889A0 + ((_i) * 4)) /* _i=0...1 */ /* Reset Source: CORER */
#define GLTSYN_AUX_OUT_1_MAX_INDEX		1
#define GLTSYN_AUX_OUT_1_OUT_ENA_S		0
#define GLTSYN_AUX_OUT_1_OUT_ENA_M		BIT(0)
#define GLTSYN_AUX_OUT_1_OUTMOD_S		1
#define GLTSYN_AUX_OUT_1_OUTMOD_M		MAKEMASK(0x3, 1)
#define GLTSYN_AUX_OUT_1_OUTLVL_S		3
#define GLTSYN_AUX_OUT_1_OUTLVL_M		BIT(3)
#define GLTSYN_AUX_OUT_1_INT_ENA_S		4
#define GLTSYN_AUX_OUT_1_INT_ENA_M		BIT(4)
#define GLTSYN_AUX_OUT_1_PULSEW_S		8
#define GLTSYN_AUX_OUT_1_PULSEW_M		MAKEMASK(0xF, 8)
#define GLTSYN_AUX_OUT_2(_i)			(0x000889A8 + ((_i) * 4)) /* _i=0...1 */ /* Reset Source: CORER */
#define GLTSYN_AUX_OUT_2_MAX_INDEX		1
#define GLTSYN_AUX_OUT_2_OUT_ENA_S		0
#define GLTSYN_AUX_OUT_2_OUT_ENA_M		BIT(0)
#define GLTSYN_AUX_OUT_2_OUTMOD_S		1
#define GLTSYN_AUX_OUT_2_OUTMOD_M		MAKEMASK(0x3, 1)
#define GLTSYN_AUX_OUT_2_OUTLVL_S		3
#define GLTSYN_AUX_OUT_2_OUTLVL_M		BIT(3)
#define GLTSYN_AUX_OUT_2_INT_ENA_S		4
#define GLTSYN_AUX_OUT_2_INT_ENA_M		BIT(4)
#define GLTSYN_AUX_OUT_2_PULSEW_S		8
#define GLTSYN_AUX_OUT_2_PULSEW_M		MAKEMASK(0xF, 8)
#define GLTSYN_AUX_OUT_3(_i)			(0x000889B0 + ((_i) * 4)) /* _i=0...1 */ /* Reset Source: CORER */
#define GLTSYN_AUX_OUT_3_MAX_INDEX		1
#define GLTSYN_AUX_OUT_3_OUT_ENA_S		0
#define GLTSYN_AUX_OUT_3_OUT_ENA_M		BIT(0)
#define GLTSYN_AUX_OUT_3_OUTMOD_S		1
#define GLTSYN_AUX_OUT_3_OUTMOD_M		MAKEMASK(0x3, 1)
#define GLTSYN_AUX_OUT_3_OUTLVL_S		3
#define GLTSYN_AUX_OUT_3_OUTLVL_M		BIT(3)
#define GLTSYN_AUX_OUT_3_INT_ENA_S		4
#define GLTSYN_AUX_OUT_3_INT_ENA_M		BIT(4)
#define GLTSYN_AUX_OUT_3_PULSEW_S		8
#define GLTSYN_AUX_OUT_3_PULSEW_M		MAKEMASK(0xF, 8)
#define GLTSYN_CLKO_0(_i)			(0x000889B8 + ((_i) * 4)) /* _i=0...1 */ /* Reset Source: CORER */
#define GLTSYN_CLKO_0_MAX_INDEX			1
#define GLTSYN_CLKO_0_TSYNCLKO_S		0
#define GLTSYN_CLKO_0_TSYNCLKO_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLTSYN_CLKO_1(_i)			(0x000889C0 + ((_i) * 4)) /* _i=0...1 */ /* Reset Source: CORER */
#define GLTSYN_CLKO_1_MAX_INDEX			1
#define GLTSYN_CLKO_1_TSYNCLKO_S		0
#define GLTSYN_CLKO_1_TSYNCLKO_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLTSYN_CLKO_2(_i)			(0x000889C8 + ((_i) * 4)) /* _i=0...1 */ /* Reset Source: CORER */
#define GLTSYN_CLKO_2_MAX_INDEX			1
#define GLTSYN_CLKO_2_TSYNCLKO_S		0
#define GLTSYN_CLKO_2_TSYNCLKO_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLTSYN_CLKO_3(_i)			(0x000889D0 + ((_i) * 4)) /* _i=0...1 */ /* Reset Source: CORER */
#define GLTSYN_CLKO_3_MAX_INDEX			1
#define GLTSYN_CLKO_3_TSYNCLKO_S		0
#define GLTSYN_CLKO_3_TSYNCLKO_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLTSYN_CMD				0x00088810 /* Reset Source: CORER */
#define GLTSYN_CMD_CMD_S			0
#define GLTSYN_CMD_CMD_M			MAKEMASK(0xFF, 0)
#define GLTSYN_CMD_SEL_MASTER_S			8
#define GLTSYN_CMD_SEL_MASTER_M			BIT(8)
#define GLTSYN_CMD_SYNC				0x00088814 /* Reset Source: CORER */
#define GLTSYN_CMD_SYNC_SYNC_S			0
#define GLTSYN_CMD_SYNC_SYNC_M			MAKEMASK(0x3, 0)
#define GLTSYN_ENA(_i)				(0x00088808 + ((_i) * 4)) /* _i=0...1 */ /* Reset Source: CORER */
#define GLTSYN_ENA_MAX_INDEX			1
#define GLTSYN_ENA_TSYN_ENA_S			0
#define GLTSYN_ENA_TSYN_ENA_M			BIT(0)
#define GLTSYN_EVNT_H_0(_i)			(0x00088970 + ((_i) * 4)) /* _i=0...1 */ /* Reset Source: CORER */
#define GLTSYN_EVNT_H_0_MAX_INDEX		1
#define GLTSYN_EVNT_H_0_TSYNEVNT_H_S		0
#define GLTSYN_EVNT_H_0_TSYNEVNT_H_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLTSYN_EVNT_H_1(_i)			(0x00088980 + ((_i) * 4)) /* _i=0...1 */ /* Reset Source: CORER */
#define GLTSYN_EVNT_H_1_MAX_INDEX		1
#define GLTSYN_EVNT_H_1_TSYNEVNT_H_S		0
#define GLTSYN_EVNT_H_1_TSYNEVNT_H_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLTSYN_EVNT_H_2(_i)			(0x00088990 + ((_i) * 4)) /* _i=0...1 */ /* Reset Source: CORER */
#define GLTSYN_EVNT_H_2_MAX_INDEX		1
#define GLTSYN_EVNT_H_2_TSYNEVNT_H_S		0
#define GLTSYN_EVNT_H_2_TSYNEVNT_H_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLTSYN_EVNT_L_0(_i)			(0x00088968 + ((_i) * 4)) /* _i=0...1 */ /* Reset Source: CORER */
#define GLTSYN_EVNT_L_0_MAX_INDEX		1
#define GLTSYN_EVNT_L_0_TSYNEVNT_L_S		0
#define GLTSYN_EVNT_L_0_TSYNEVNT_L_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLTSYN_EVNT_L_1(_i)			(0x00088978 + ((_i) * 4)) /* _i=0...1 */ /* Reset Source: CORER */
#define GLTSYN_EVNT_L_1_MAX_INDEX		1
#define GLTSYN_EVNT_L_1_TSYNEVNT_L_S		0
#define GLTSYN_EVNT_L_1_TSYNEVNT_L_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLTSYN_EVNT_L_2(_i)			(0x00088988 + ((_i) * 4)) /* _i=0...1 */ /* Reset Source: CORER */
#define GLTSYN_EVNT_L_2_MAX_INDEX		1
#define GLTSYN_EVNT_L_2_TSYNEVNT_L_S		0
#define GLTSYN_EVNT_L_2_TSYNEVNT_L_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLTSYN_HHTIME_H(_i)			(0x00088900 + ((_i) * 4)) /* _i=0...1 */ /* Reset Source: CORER */
#define GLTSYN_HHTIME_H_MAX_INDEX		1
#define GLTSYN_HHTIME_H_TSYNEVNT_H_S		0
#define GLTSYN_HHTIME_H_TSYNEVNT_H_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLTSYN_HHTIME_L(_i)			(0x000888F8 + ((_i) * 4)) /* _i=0...1 */ /* Reset Source: CORER */
#define GLTSYN_HHTIME_L_MAX_INDEX		1
#define GLTSYN_HHTIME_L_TSYNEVNT_L_S		0
#define GLTSYN_HHTIME_L_TSYNEVNT_L_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLTSYN_INCVAL_H(_i)			(0x00088920 + ((_i) * 4)) /* _i=0...1 */ /* Reset Source: CORER */
#define GLTSYN_INCVAL_H_MAX_INDEX		1
#define GLTSYN_INCVAL_H_INCVAL_H_S		0
#define GLTSYN_INCVAL_H_INCVAL_H_M		MAKEMASK(0xFF, 0)
#define GLTSYN_INCVAL_L(_i)			(0x00088918 + ((_i) * 4)) /* _i=0...1 */ /* Reset Source: CORER */
#define GLTSYN_INCVAL_L_MAX_INDEX		1
#define GLTSYN_INCVAL_L_INCVAL_L_S		0
#define GLTSYN_INCVAL_L_INCVAL_L_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLTSYN_SHADJ_H(_i)			(0x00088910 + ((_i) * 4)) /* _i=0...1 */ /* Reset Source: CORER */
#define GLTSYN_SHADJ_H_MAX_INDEX		1
#define GLTSYN_SHADJ_H_ADJUST_H_S		0
#define GLTSYN_SHADJ_H_ADJUST_H_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLTSYN_SHADJ_L(_i)			(0x00088908 + ((_i) * 4)) /* _i=0...1 */ /* Reset Source: CORER */
#define GLTSYN_SHADJ_L_MAX_INDEX		1
#define GLTSYN_SHADJ_L_ADJUST_L_S		0
#define GLTSYN_SHADJ_L_ADJUST_L_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLTSYN_SHTIME_0(_i)			(0x000888E0 + ((_i) * 4)) /* _i=0...1 */ /* Reset Source: CORER */
#define GLTSYN_SHTIME_0_MAX_INDEX		1
#define GLTSYN_SHTIME_0_TSYNTIME_0_S		0
#define GLTSYN_SHTIME_0_TSYNTIME_0_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLTSYN_SHTIME_H(_i)			(0x000888F0 + ((_i) * 4)) /* _i=0...1 */ /* Reset Source: CORER */
#define GLTSYN_SHTIME_H_MAX_INDEX		1
#define GLTSYN_SHTIME_H_TSYNTIME_H_S		0
#define GLTSYN_SHTIME_H_TSYNTIME_H_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLTSYN_SHTIME_L(_i)			(0x000888E8 + ((_i) * 4)) /* _i=0...1 */ /* Reset Source: CORER */
#define GLTSYN_SHTIME_L_MAX_INDEX		1
#define GLTSYN_SHTIME_L_TSYNTIME_L_S		0
#define GLTSYN_SHTIME_L_TSYNTIME_L_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLTSYN_STAT(_i)				(0x000888C0 + ((_i) * 4)) /* _i=0...1 */ /* Reset Source: CORER */
#define GLTSYN_STAT_MAX_INDEX			1
#define GLTSYN_STAT_EVENT0_S			0
#define GLTSYN_STAT_EVENT0_M			BIT(0)
#define GLTSYN_STAT_EVENT1_S			1
#define GLTSYN_STAT_EVENT1_M			BIT(1)
#define GLTSYN_STAT_EVENT2_S			2
#define GLTSYN_STAT_EVENT2_M			BIT(2)
#define GLTSYN_STAT_TGT0_S			4
#define GLTSYN_STAT_TGT0_M			BIT(4)
#define GLTSYN_STAT_TGT1_S			5
#define GLTSYN_STAT_TGT1_M			BIT(5)
#define GLTSYN_STAT_TGT2_S			6
#define GLTSYN_STAT_TGT2_M			BIT(6)
#define GLTSYN_STAT_TGT3_S			7
#define GLTSYN_STAT_TGT3_M			BIT(7)
#define GLTSYN_SYNC_DLAY			0x00088818 /* Reset Source: CORER */
#define GLTSYN_SYNC_DLAY_SYNC_DELAY_S		0
#define GLTSYN_SYNC_DLAY_SYNC_DELAY_M		MAKEMASK(0x1F, 0)
#define GLTSYN_TGT_H_0(_i)			(0x00088930 + ((_i) * 4)) /* _i=0...1 */ /* Reset Source: CORER */
#define GLTSYN_TGT_H_0_MAX_INDEX		1
#define GLTSYN_TGT_H_0_TSYNTGTT_H_S		0
#define GLTSYN_TGT_H_0_TSYNTGTT_H_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLTSYN_TGT_H_1(_i)			(0x00088940 + ((_i) * 4)) /* _i=0...1 */ /* Reset Source: CORER */
#define GLTSYN_TGT_H_1_MAX_INDEX		1
#define GLTSYN_TGT_H_1_TSYNTGTT_H_S		0
#define GLTSYN_TGT_H_1_TSYNTGTT_H_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLTSYN_TGT_H_2(_i)			(0x00088950 + ((_i) * 4)) /* _i=0...1 */ /* Reset Source: CORER */
#define GLTSYN_TGT_H_2_MAX_INDEX		1
#define GLTSYN_TGT_H_2_TSYNTGTT_H_S		0
#define GLTSYN_TGT_H_2_TSYNTGTT_H_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLTSYN_TGT_H_3(_i)			(0x00088960 + ((_i) * 4)) /* _i=0...1 */ /* Reset Source: CORER */
#define GLTSYN_TGT_H_3_MAX_INDEX		1
#define GLTSYN_TGT_H_3_TSYNTGTT_H_S		0
#define GLTSYN_TGT_H_3_TSYNTGTT_H_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLTSYN_TGT_L_0(_i)			(0x00088928 + ((_i) * 4)) /* _i=0...1 */ /* Reset Source: CORER */
#define GLTSYN_TGT_L_0_MAX_INDEX		1
#define GLTSYN_TGT_L_0_TSYNTGTT_L_S		0
#define GLTSYN_TGT_L_0_TSYNTGTT_L_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLTSYN_TGT_L_1(_i)			(0x00088938 + ((_i) * 4)) /* _i=0...1 */ /* Reset Source: CORER */
#define GLTSYN_TGT_L_1_MAX_INDEX		1
#define GLTSYN_TGT_L_1_TSYNTGTT_L_S		0
#define GLTSYN_TGT_L_1_TSYNTGTT_L_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLTSYN_TGT_L_2(_i)			(0x00088948 + ((_i) * 4)) /* _i=0...1 */ /* Reset Source: CORER */
#define GLTSYN_TGT_L_2_MAX_INDEX		1
#define GLTSYN_TGT_L_2_TSYNTGTT_L_S		0
#define GLTSYN_TGT_L_2_TSYNTGTT_L_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLTSYN_TGT_L_3(_i)			(0x00088958 + ((_i) * 4)) /* _i=0...1 */ /* Reset Source: CORER */
#define GLTSYN_TGT_L_3_MAX_INDEX		1
#define GLTSYN_TGT_L_3_TSYNTGTT_L_S		0
#define GLTSYN_TGT_L_3_TSYNTGTT_L_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLTSYN_TIME_0(_i)			(0x000888C8 + ((_i) * 4)) /* _i=0...1 */ /* Reset Source: CORER */
#define GLTSYN_TIME_0_MAX_INDEX			1
#define GLTSYN_TIME_0_TSYNTIME_0_S		0
#define GLTSYN_TIME_0_TSYNTIME_0_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLTSYN_TIME_H(_i)			(0x000888D8 + ((_i) * 4)) /* _i=0...1 */ /* Reset Source: CORER */
#define GLTSYN_TIME_H_MAX_INDEX			1
#define GLTSYN_TIME_H_TSYNTIME_H_S		0
#define GLTSYN_TIME_H_TSYNTIME_H_M		MAKEMASK(0xFFFFFFFF, 0)
#define GLTSYN_TIME_L(_i)			(0x000888D0 + ((_i) * 4)) /* _i=0...1 */ /* Reset Source: CORER */
#define GLTSYN_TIME_L_MAX_INDEX			1
#define GLTSYN_TIME_L_TSYNTIME_L_S		0
#define GLTSYN_TIME_L_TSYNTIME_L_M		MAKEMASK(0xFFFFFFFF, 0)
#define PFHH_SEM				0x000A4200 /* Reset Source: PFR */
#define PFHH_SEM_BUSY_S				0
#define PFHH_SEM_BUSY_M				BIT(0)
#define PFHH_SEM_PF_OWNER_S			4
#define PFHH_SEM_PF_OWNER_M			MAKEMASK(0x7, 4)
#define PFTSYN_SEM				0x00088880 /* Reset Source: PFR */
#define PFTSYN_SEM_BUSY_S			0
#define PFTSYN_SEM_BUSY_M			BIT(0)
#define PFTSYN_SEM_PF_OWNER_S			4
#define PFTSYN_SEM_PF_OWNER_M			MAKEMASK(0x7, 4)
#define GLPE_TSCD_FLR(_i)			(0x0051E24C + ((_i) * 4)) /* _i=0...3 */ /* Reset Source: CORER */
#define GLPE_TSCD_FLR_MAX_INDEX			3
#define GLPE_TSCD_FLR_DRAIN_VCTR_ID_S		0
#define GLPE_TSCD_FLR_DRAIN_VCTR_ID_M		MAKEMASK(0x3, 0)
#define GLPE_TSCD_FLR_PORT_S			2
#define GLPE_TSCD_FLR_PORT_M			MAKEMASK(0x7, 2)
#define GLPE_TSCD_FLR_PF_NUM_S			5
#define GLPE_TSCD_FLR_PF_NUM_M			MAKEMASK(0x7, 5)
#define GLPE_TSCD_FLR_VM_VF_TYPE_S		8
#define GLPE_TSCD_FLR_VM_VF_TYPE_M		MAKEMASK(0x3, 8)
#define GLPE_TSCD_FLR_VM_VF_NUM_S		16
#define GLPE_TSCD_FLR_VM_VF_NUM_M		MAKEMASK(0x3FF, 16)
#define GLPE_TSCD_FLR_VLD_S			31
#define GLPE_TSCD_FLR_VLD_M			BIT(31)
#define GLPE_TSCD_PEPM				0x0051E228 /* Reset Source: CORER */
#define GLPE_TSCD_PEPM_MDQ_CREDITS_S		0
#define GLPE_TSCD_PEPM_MDQ_CREDITS_M		MAKEMASK(0xFF, 0)
#define PF_VIRT_VSTATUS				0x0009E680 /* Reset Source: PFR */
#define PF_VIRT_VSTATUS_NUM_VFS_S		0
#define PF_VIRT_VSTATUS_NUM_VFS_M		MAKEMASK(0xFF, 0)
#define PF_VIRT_VSTATUS_TOTAL_VFS_S		8
#define PF_VIRT_VSTATUS_TOTAL_VFS_M		MAKEMASK(0xFF, 8)
#define PF_VIRT_VSTATUS_IOV_ACTIVE_S		16
#define PF_VIRT_VSTATUS_IOV_ACTIVE_M		BIT(16)
#define PF_VT_PFALLOC				0x001D2480 /* Reset Source: CORER */
#define PF_VT_PFALLOC_FIRSTVF_S			0
#define PF_VT_PFALLOC_FIRSTVF_M			MAKEMASK(0xFF, 0)
#define PF_VT_PFALLOC_LASTVF_S			8
#define PF_VT_PFALLOC_LASTVF_M			MAKEMASK(0xFF, 8)
#define PF_VT_PFALLOC_VALID_S			31
#define PF_VT_PFALLOC_VALID_M			BIT(31)
#define PF_VT_PFALLOC_HIF			0x0009DD80 /* Reset Source: PCIR */
#define PF_VT_PFALLOC_HIF_FIRSTVF_S		0
#define PF_VT_PFALLOC_HIF_FIRSTVF_M		MAKEMASK(0xFF, 0)
#define PF_VT_PFALLOC_HIF_LASTVF_S		8
#define PF_VT_PFALLOC_HIF_LASTVF_M		MAKEMASK(0xFF, 8)
#define PF_VT_PFALLOC_HIF_VALID_S		31
#define PF_VT_PFALLOC_HIF_VALID_M		BIT(31)
#define PF_VT_PFALLOC_PCIE			0x000BE080 /* Reset Source: PCIR */
#define PF_VT_PFALLOC_PCIE_FIRSTVF_S		0
#define PF_VT_PFALLOC_PCIE_FIRSTVF_M		MAKEMASK(0xFF, 0)
#define PF_VT_PFALLOC_PCIE_LASTVF_S		8
#define PF_VT_PFALLOC_PCIE_LASTVF_M		MAKEMASK(0xFF, 8)
#define PF_VT_PFALLOC_PCIE_VALID_S		31
#define PF_VT_PFALLOC_PCIE_VALID_M		BIT(31)
#define VSI_L2TAGSTXVALID(_VSI)			(0x00046000 + ((_VSI) * 4)) /* _i=0...767 */ /* Reset Source: CORER */
#define VSI_L2TAGSTXVALID_MAX_INDEX		767
#define VSI_L2TAGSTXVALID_L2TAG1INSERTID_S	0
#define VSI_L2TAGSTXVALID_L2TAG1INSERTID_M	MAKEMASK(0x7, 0)
#define VSI_L2TAGSTXVALID_L2TAG1INSERTID_VALID_S 3
#define VSI_L2TAGSTXVALID_L2TAG1INSERTID_VALID_M BIT(3)
#define VSI_L2TAGSTXVALID_L2TAG2INSERTID_S	4
#define VSI_L2TAGSTXVALID_L2TAG2INSERTID_M	MAKEMASK(0x7, 4)
#define VSI_L2TAGSTXVALID_L2TAG2INSERTID_VALID_S 7
#define VSI_L2TAGSTXVALID_L2TAG2INSERTID_VALID_M BIT(7)
#define VSI_L2TAGSTXVALID_TIR0INSERTID_S	16
#define VSI_L2TAGSTXVALID_TIR0INSERTID_M	MAKEMASK(0x7, 16)
#define VSI_L2TAGSTXVALID_TIR0_INSERT_S		19
#define VSI_L2TAGSTXVALID_TIR0_INSERT_M		BIT(19)
#define VSI_L2TAGSTXVALID_TIR1INSERTID_S	20
#define VSI_L2TAGSTXVALID_TIR1INSERTID_M	MAKEMASK(0x7, 20)
#define VSI_L2TAGSTXVALID_TIR1_INSERT_S		23
#define VSI_L2TAGSTXVALID_TIR1_INSERT_M		BIT(23)
#define VSI_L2TAGSTXVALID_TIR2INSERTID_S	24
#define VSI_L2TAGSTXVALID_TIR2INSERTID_M	MAKEMASK(0x7, 24)
#define VSI_L2TAGSTXVALID_TIR2_INSERT_S		27
#define VSI_L2TAGSTXVALID_TIR2_INSERT_M		BIT(27)
#define VSI_PASID(_VSI)				(0x0009C000 + ((_VSI) * 4)) /* _i=0...767 */ /* Reset Source: PFR */
#define VSI_PASID_MAX_INDEX			767
#define VSI_PASID_PASID_S			0
#define VSI_PASID_PASID_M			MAKEMASK(0xFFFFF, 0)
#define VSI_PASID_EN_S				31
#define VSI_PASID_EN_M				BIT(31)
#define VSI_RUPR(_VSI)				(0x00050000 + ((_VSI) * 4)) /* _i=0...767 */ /* Reset Source: CORER */
#define VSI_RUPR_MAX_INDEX			767
#define VSI_RUPR_UP0_S				0
#define VSI_RUPR_UP0_M				MAKEMASK(0x7, 0)
#define VSI_RUPR_UP1_S				3
#define VSI_RUPR_UP1_M				MAKEMASK(0x7, 3)
#define VSI_RUPR_UP2_S				6
#define VSI_RUPR_UP2_M				MAKEMASK(0x7, 6)
#define VSI_RUPR_UP3_S				9
#define VSI_RUPR_UP3_M				MAKEMASK(0x7, 9)
#define VSI_RUPR_UP4_S				12
#define VSI_RUPR_UP4_M				MAKEMASK(0x7, 12)
#define VSI_RUPR_UP5_S				15
#define VSI_RUPR_UP5_M				MAKEMASK(0x7, 15)
#define VSI_RUPR_UP6_S				18
#define VSI_RUPR_UP6_M				MAKEMASK(0x7, 18)
#define VSI_RUPR_UP7_S				21
#define VSI_RUPR_UP7_M				MAKEMASK(0x7, 21)
#define VSI_RXSWCTRL(_VSI)			(0x00205000 + ((_VSI) * 4)) /* _i=0...767 */ /* Reset Source: CORER */
#define VSI_RXSWCTRL_MAX_INDEX			767
#define VSI_RXSWCTRL_MACVSIPRUNEENABLE_S	8
#define VSI_RXSWCTRL_MACVSIPRUNEENABLE_M	BIT(8)
#define VSI_RXSWCTRL_PRUNEENABLE_S		9
#define VSI_RXSWCTRL_PRUNEENABLE_M		MAKEMASK(0xF, 9)
#define VSI_RXSWCTRL_SRCPRUNEENABLE_S		13
#define VSI_RXSWCTRL_SRCPRUNEENABLE_M		BIT(13)
#define VSI_SRCSWCTRL(_VSI)			(0x00209000 + ((_VSI) * 4)) /* _i=0...767 */ /* Reset Source: CORER */
#define VSI_SRCSWCTRL_MAX_INDEX			767
#define VSI_SRCSWCTRL_ALLOWDESTOVERRIDE_S	0
#define VSI_SRCSWCTRL_ALLOWDESTOVERRIDE_M	BIT(0)
#define VSI_SRCSWCTRL_ALLOWLOOPBACK_S		1
#define VSI_SRCSWCTRL_ALLOWLOOPBACK_M		BIT(1)
#define VSI_SRCSWCTRL_LANENABLE_S		2
#define VSI_SRCSWCTRL_LANENABLE_M		BIT(2)
#define VSI_SRCSWCTRL_MACAS_S			3
#define VSI_SRCSWCTRL_MACAS_M			BIT(3)
#define VSI_SRCSWCTRL_PRUNEENABLE_S		4
#define VSI_SRCSWCTRL_PRUNEENABLE_M		MAKEMASK(0xF, 4)
#define VSI_SWITCHID(_VSI)			(0x00215000 + ((_VSI) * 4)) /* _i=0...767 */ /* Reset Source: CORER */
#define VSI_SWITCHID_MAX_INDEX			767
#define VSI_SWITCHID_SWITCHID_S			0
#define VSI_SWITCHID_SWITCHID_M			MAKEMASK(0xFF, 0)
#define VSI_SWT_MIREG(_VSI)			(0x00207000 + ((_VSI) * 4)) /* _i=0...767 */ /* Reset Source: CORER */
#define VSI_SWT_MIREG_MAX_INDEX			767
#define VSI_SWT_MIREG_MIRRULE_S			0
#define VSI_SWT_MIREG_MIRRULE_M			MAKEMASK(0x3F, 0)
#define VSI_SWT_MIREG_MIRENA_S			7
#define VSI_SWT_MIREG_MIRENA_M			BIT(7)
#define VSI_SWT_MIRIG(_VSI)			(0x00208000 + ((_VSI) * 4)) /* _i=0...767 */ /* Reset Source: CORER */
#define VSI_SWT_MIRIG_MAX_INDEX			767
#define VSI_SWT_MIRIG_MIRRULE_S			0
#define VSI_SWT_MIRIG_MIRRULE_M			MAKEMASK(0x3F, 0)
#define VSI_SWT_MIRIG_MIRENA_S			7
#define VSI_SWT_MIRIG_MIRENA_M			BIT(7)
#define VSI_TAIR(_VSI)				(0x00044000 + ((_VSI) * 4)) /* _i=0...767 */ /* Reset Source: PFR */
#define VSI_TAIR_MAX_INDEX			767
#define VSI_TAIR_PORT_TAG_ID_S			0
#define VSI_TAIR_PORT_TAG_ID_M			MAKEMASK(0xFFFF, 0)
#define VSI_TAR(_VSI)				(0x00045000 + ((_VSI) * 4)) /* _i=0...767 */ /* Reset Source: CORER */
#define VSI_TAR_MAX_INDEX			767
#define VSI_TAR_ACCEPTTAGGED_S			0
#define VSI_TAR_ACCEPTTAGGED_M			MAKEMASK(0x3FF, 0)
#define VSI_TAR_ACCEPTUNTAGGED_S		16
#define VSI_TAR_ACCEPTUNTAGGED_M		MAKEMASK(0x3FF, 16)
#define VSI_TIR_0(_VSI)				(0x00041000 + ((_VSI) * 4)) /* _i=0...767 */ /* Reset Source: CORER */
#define VSI_TIR_0_MAX_INDEX			767
#define VSI_TIR_0_PORT_TAG_ID_S			0
#define VSI_TIR_0_PORT_TAG_ID_M			MAKEMASK(0xFFFF, 0)
#define VSI_TIR_1(_VSI)				(0x00042000 + ((_VSI) * 4)) /* _i=0...767 */ /* Reset Source: CORER */
#define VSI_TIR_1_MAX_INDEX			767
#define VSI_TIR_1_PORT_TAG_ID_S			0
#define VSI_TIR_1_PORT_TAG_ID_M			MAKEMASK(0xFFFFFFFF, 0)
#define VSI_TIR_2(_VSI)				(0x00043000 + ((_VSI) * 4)) /* _i=0...767 */ /* Reset Source: CORER */
#define VSI_TIR_2_MAX_INDEX			767
#define VSI_TIR_2_PORT_TAG_ID_S			0
#define VSI_TIR_2_PORT_TAG_ID_M			MAKEMASK(0xFFFF, 0)
#define VSI_TSR(_VSI)				(0x00051000 + ((_VSI) * 4)) /* _i=0...767 */ /* Reset Source: CORER */
#define VSI_TSR_MAX_INDEX			767
#define VSI_TSR_STRIPTAG_S			0
#define VSI_TSR_STRIPTAG_M			MAKEMASK(0x3FF, 0)
#define VSI_TSR_SHOWTAG_S			10
#define VSI_TSR_SHOWTAG_M			MAKEMASK(0x3FF, 10)
#define VSI_TSR_SHOWPRIONLY_S			20
#define VSI_TSR_SHOWPRIONLY_M			MAKEMASK(0x3FF, 20)
#define VSI_TUPIOM(_VSI)			(0x00048000 + ((_VSI) * 4)) /* _i=0...767 */ /* Reset Source: CORER */
#define VSI_TUPIOM_MAX_INDEX			767
#define VSI_TUPIOM_UP0_S			0
#define VSI_TUPIOM_UP0_M			MAKEMASK(0x7, 0)
#define VSI_TUPIOM_UP1_S			3
#define VSI_TUPIOM_UP1_M			MAKEMASK(0x7, 3)
#define VSI_TUPIOM_UP2_S			6
#define VSI_TUPIOM_UP2_M			MAKEMASK(0x7, 6)
#define VSI_TUPIOM_UP3_S			9
#define VSI_TUPIOM_UP3_M			MAKEMASK(0x7, 9)
#define VSI_TUPIOM_UP4_S			12
#define VSI_TUPIOM_UP4_M			MAKEMASK(0x7, 12)
#define VSI_TUPIOM_UP5_S			15
#define VSI_TUPIOM_UP5_M			MAKEMASK(0x7, 15)
#define VSI_TUPIOM_UP6_S			18
#define VSI_TUPIOM_UP6_M			MAKEMASK(0x7, 18)
#define VSI_TUPIOM_UP7_S			21
#define VSI_TUPIOM_UP7_M			MAKEMASK(0x7, 21)
#define VSI_TUPR(_VSI)				(0x00047000 + ((_VSI) * 4)) /* _i=0...767 */ /* Reset Source: CORER */
#define VSI_TUPR_MAX_INDEX			767
#define VSI_TUPR_UP0_S				0
#define VSI_TUPR_UP0_M				MAKEMASK(0x7, 0)
#define VSI_TUPR_UP1_S				3
#define VSI_TUPR_UP1_M				MAKEMASK(0x7, 3)
#define VSI_TUPR_UP2_S				6
#define VSI_TUPR_UP2_M				MAKEMASK(0x7, 6)
#define VSI_TUPR_UP3_S				9
#define VSI_TUPR_UP3_M				MAKEMASK(0x7, 9)
#define VSI_TUPR_UP4_S				12
#define VSI_TUPR_UP4_M				MAKEMASK(0x7, 12)
#define VSI_TUPR_UP5_S				15
#define VSI_TUPR_UP5_M				MAKEMASK(0x7, 15)
#define VSI_TUPR_UP6_S				18
#define VSI_TUPR_UP6_M				MAKEMASK(0x7, 18)
#define VSI_TUPR_UP7_S				21
#define VSI_TUPR_UP7_M				MAKEMASK(0x7, 21)
#define VSI_VSI2F(_VSI)				(0x001D0000 + ((_VSI) * 4)) /* _i=0...767 */ /* Reset Source: PFR */
#define VSI_VSI2F_MAX_INDEX			767
#define VSI_VSI2F_VFVMNUMBER_S			0
#define VSI_VSI2F_VFVMNUMBER_M			MAKEMASK(0x3FF, 0)
#define VSI_VSI2F_FUNCTIONTYPE_S		10
#define VSI_VSI2F_FUNCTIONTYPE_M		MAKEMASK(0x3, 10)
#define VSI_VSI2F_PFNUMBER_S			12
#define VSI_VSI2F_PFNUMBER_M			MAKEMASK(0x7, 12)
#define VSI_VSI2F_BUFFERNUMBER_S		16
#define VSI_VSI2F_BUFFERNUMBER_M		MAKEMASK(0x7, 16)
#define VSI_VSI2F_VSI_NUMBER_S			20
#define VSI_VSI2F_VSI_NUMBER_M			MAKEMASK(0x3FF, 20)
#define VSI_VSI2F_VSI_ENABLE_S			31
#define VSI_VSI2F_VSI_ENABLE_M			BIT(31)
#define VSIQF_FD_CNT(_VSI)			(0x00464000 + ((_VSI) * 4)) /* _i=0...767 */ /* Reset Source: PFR */
#define VSIQF_FD_CNT_MAX_INDEX			767
#define VSIQF_FD_CNT_FD_GCNT_S			0
#define VSIQF_FD_CNT_FD_GCNT_M			MAKEMASK(0x3FFF, 0)
#define VSIQF_FD_CNT_FD_BCNT_S			16
#define VSIQF_FD_CNT_FD_BCNT_M			MAKEMASK(0x3FFF, 16)
#define VSIQF_FD_CTL1(_VSI)			(0x00411000 + ((_VSI) * 4)) /* _i=0...767 */ /* Reset Source: CORER */
#define VSIQF_FD_CTL1_MAX_INDEX			767
#define VSIQF_FD_CTL1_FLT_ENA_S			0
#define VSIQF_FD_CTL1_FLT_ENA_M			BIT(0)
#define VSIQF_FD_CTL1_CFG_ENA_S			1
#define VSIQF_FD_CTL1_CFG_ENA_M			BIT(1)
#define VSIQF_FD_CTL1_EVICT_ENA_S		2
#define VSIQF_FD_CTL1_EVICT_ENA_M		BIT(2)
#define VSIQF_FD_DFLT(_VSI)			(0x00457000 + ((_VSI) * 4)) /* _i=0...767 */ /* Reset Source: CORER */
#define VSIQF_FD_DFLT_MAX_INDEX			767
#define VSIQF_FD_DFLT_DEFLT_QINDX_S		0
#define VSIQF_FD_DFLT_DEFLT_QINDX_M		MAKEMASK(0x7FF, 0)
#define VSIQF_FD_DFLT_DEFLT_TOQUEUE_S		12
#define VSIQF_FD_DFLT_DEFLT_TOQUEUE_M		MAKEMASK(0x7, 12)
#define VSIQF_FD_DFLT_COMP_QINDX_S		16
#define VSIQF_FD_DFLT_COMP_QINDX_M		MAKEMASK(0x7FF, 16)
#define VSIQF_FD_DFLT_DEFLT_QINDX_PRIO_S	28
#define VSIQF_FD_DFLT_DEFLT_QINDX_PRIO_M	MAKEMASK(0x7, 28)
#define VSIQF_FD_DFLT_DEFLT_DROP_S		31
#define VSIQF_FD_DFLT_DEFLT_DROP_M		BIT(31)
#define VSIQF_FD_SIZE(_VSI)			(0x00462000 + ((_VSI) * 4)) /* _i=0...767 */ /* Reset Source: CORER */
#define VSIQF_FD_SIZE_MAX_INDEX			767
#define VSIQF_FD_SIZE_FD_GSIZE_S		0
#define VSIQF_FD_SIZE_FD_GSIZE_M		MAKEMASK(0x3FFF, 0)
#define VSIQF_FD_SIZE_FD_BSIZE_S		16
#define VSIQF_FD_SIZE_FD_BSIZE_M		MAKEMASK(0x3FFF, 16)
#define VSIQF_HASH_CTL(_VSI)			(0x0040D000 + ((_VSI) * 4)) /* _i=0...767 */ /* Reset Source: CORER */
#define VSIQF_HASH_CTL_MAX_INDEX		767
#define VSIQF_HASH_CTL_HASH_LUT_SEL_S		0
#define VSIQF_HASH_CTL_HASH_LUT_SEL_M		MAKEMASK(0x3, 0)
#define VSIQF_HASH_CTL_GLOB_LUT_S		2
#define VSIQF_HASH_CTL_GLOB_LUT_M		MAKEMASK(0xF, 2)
#define VSIQF_HASH_CTL_HASH_SCHEME_S		6
#define VSIQF_HASH_CTL_HASH_SCHEME_M		MAKEMASK(0x3, 6)
#define VSIQF_HASH_CTL_TC_OVER_SEL_S		8
#define VSIQF_HASH_CTL_TC_OVER_SEL_M		MAKEMASK(0x1F, 8)
#define VSIQF_HASH_CTL_TC_OVER_ENA_S		15
#define VSIQF_HASH_CTL_TC_OVER_ENA_M		BIT(15)
#define VSIQF_HKEY(_i, _VSI)			(0x00400000 + ((_i) * 4096 + (_VSI) * 4)) /* _i=0...12, _VSI=0...767 */ /* Reset Source: PFR */
#define VSIQF_HKEY_MAX_INDEX			12
#define VSIQF_HKEY_KEY_0_S			0
#define VSIQF_HKEY_KEY_0_M			MAKEMASK(0xFF, 0)
#define VSIQF_HKEY_KEY_1_S			8
#define VSIQF_HKEY_KEY_1_M			MAKEMASK(0xFF, 8)
#define VSIQF_HKEY_KEY_2_S			16
#define VSIQF_HKEY_KEY_2_M			MAKEMASK(0xFF, 16)
#define VSIQF_HKEY_KEY_3_S			24
#define VSIQF_HKEY_KEY_3_M			MAKEMASK(0xFF, 24)
#define VSIQF_HLUT(_i, _VSI)			(0x00420000 + ((_i) * 4096 + (_VSI) * 4)) /* _i=0...15, _VSI=0...767 */ /* Reset Source: PFR */
#define VSIQF_HLUT_MAX_INDEX			15
#define VSIQF_HLUT_LUT0_S			0
#define VSIQF_HLUT_LUT0_M			MAKEMASK(0xF, 0)
#define VSIQF_HLUT_LUT1_S			8
#define VSIQF_HLUT_LUT1_M			MAKEMASK(0xF, 8)
#define VSIQF_HLUT_LUT2_S			16
#define VSIQF_HLUT_LUT2_M			MAKEMASK(0xF, 16)
#define VSIQF_HLUT_LUT3_S			24
#define VSIQF_HLUT_LUT3_M			MAKEMASK(0xF, 24)
#define VSIQF_PE_CTL1(_VSI)			(0x00414000 + ((_VSI) * 4)) /* _i=0...767 */ /* Reset Source: CORER */
#define VSIQF_PE_CTL1_MAX_INDEX			767
#define VSIQF_PE_CTL1_PE_FLTENA_S		0
#define VSIQF_PE_CTL1_PE_FLTENA_M		BIT(0)
#define VSIQF_TC_REGION(_i, _VSI)		(0x00448000 + ((_i) * 4096 + (_VSI) * 4)) /* _i=0...3, _VSI=0...767 */ /* Reset Source: CORER */
#define VSIQF_TC_REGION_MAX_INDEX		3
#define VSIQF_TC_REGION_TC_BASE0_S		0
#define VSIQF_TC_REGION_TC_BASE0_M		MAKEMASK(0x7FF, 0)
#define VSIQF_TC_REGION_TC_SIZE0_S		11
#define VSIQF_TC_REGION_TC_SIZE0_M		MAKEMASK(0xF, 11)
#define VSIQF_TC_REGION_TC_BASE1_S		16
#define VSIQF_TC_REGION_TC_BASE1_M		MAKEMASK(0x7FF, 16)
#define VSIQF_TC_REGION_TC_SIZE1_S		27
#define VSIQF_TC_REGION_TC_SIZE1_M		MAKEMASK(0xF, 27)
#define GLPM_WUMC				0x0009DEE4 /* Reset Source: POR */
#define GLPM_WUMC_MNG_WU_PF_S			16
#define GLPM_WUMC_MNG_WU_PF_M			MAKEMASK(0xFF, 16)
#define PFPM_APM				0x000B8080 /* Reset Source: POR */
#define PFPM_APM_APME_S				0
#define PFPM_APM_APME_M				BIT(0)
#define PFPM_WUC				0x0009DC80 /* Reset Source: POR */
#define PFPM_WUC_EN_APM_D0_S			5
#define PFPM_WUC_EN_APM_D0_M			BIT(5)
#define PFPM_WUFC				0x0009DC00 /* Reset Source: POR */
#define PFPM_WUFC_LNKC_S			0
#define PFPM_WUFC_LNKC_M			BIT(0)
#define PFPM_WUFC_MAG_S				1
#define PFPM_WUFC_MAG_M				BIT(1)
#define PFPM_WUFC_MNG_S				3
#define PFPM_WUFC_MNG_M				BIT(3)
#define PFPM_WUFC_FLX0_ACT_S			4
#define PFPM_WUFC_FLX0_ACT_M			BIT(4)
#define PFPM_WUFC_FLX1_ACT_S			5
#define PFPM_WUFC_FLX1_ACT_M			BIT(5)
#define PFPM_WUFC_FLX2_ACT_S			6
#define PFPM_WUFC_FLX2_ACT_M			BIT(6)
#define PFPM_WUFC_FLX3_ACT_S			7
#define PFPM_WUFC_FLX3_ACT_M			BIT(7)
#define PFPM_WUFC_FLX4_ACT_S			8
#define PFPM_WUFC_FLX4_ACT_M			BIT(8)
#define PFPM_WUFC_FLX5_ACT_S			9
#define PFPM_WUFC_FLX5_ACT_M			BIT(9)
#define PFPM_WUFC_FLX6_ACT_S			10
#define PFPM_WUFC_FLX6_ACT_M			BIT(10)
#define PFPM_WUFC_FLX7_ACT_S			11
#define PFPM_WUFC_FLX7_ACT_M			BIT(11)
#define PFPM_WUFC_FLX0_S			16
#define PFPM_WUFC_FLX0_M			BIT(16)
#define PFPM_WUFC_FLX1_S			17
#define PFPM_WUFC_FLX1_M			BIT(17)
#define PFPM_WUFC_FLX2_S			18
#define PFPM_WUFC_FLX2_M			BIT(18)
#define PFPM_WUFC_FLX3_S			19
#define PFPM_WUFC_FLX3_M			BIT(19)
#define PFPM_WUFC_FLX4_S			20
#define PFPM_WUFC_FLX4_M			BIT(20)
#define PFPM_WUFC_FLX5_S			21
#define PFPM_WUFC_FLX5_M			BIT(21)
#define PFPM_WUFC_FLX6_S			22
#define PFPM_WUFC_FLX6_M			BIT(22)
#define PFPM_WUFC_FLX7_S			23
#define PFPM_WUFC_FLX7_M			BIT(23)
#define PFPM_WUFC_FW_RST_WK_S			31
#define PFPM_WUFC_FW_RST_WK_M			BIT(31)
#define PFPM_WUS				0x0009DB80 /* Reset Source: POR */
#define PFPM_WUS_LNKC_S				0
#define PFPM_WUS_LNKC_M				BIT(0)
#define PFPM_WUS_MAG_S				1
#define PFPM_WUS_MAG_M				BIT(1)
#define PFPM_WUS_PME_STATUS_S			2
#define PFPM_WUS_PME_STATUS_M			BIT(2)
#define PFPM_WUS_MNG_S				3
#define PFPM_WUS_MNG_M				BIT(3)
#define PFPM_WUS_FLX0_S				16
#define PFPM_WUS_FLX0_M				BIT(16)
#define PFPM_WUS_FLX1_S				17
#define PFPM_WUS_FLX1_M				BIT(17)
#define PFPM_WUS_FLX2_S				18
#define PFPM_WUS_FLX2_M				BIT(18)
#define PFPM_WUS_FLX3_S				19
#define PFPM_WUS_FLX3_M				BIT(19)
#define PFPM_WUS_FLX4_S				20
#define PFPM_WUS_FLX4_M				BIT(20)
#define PFPM_WUS_FLX5_S				21
#define PFPM_WUS_FLX5_M				BIT(21)
#define PFPM_WUS_FLX6_S				22
#define PFPM_WUS_FLX6_M				BIT(22)
#define PFPM_WUS_FLX7_S				23
#define PFPM_WUS_FLX7_M				BIT(23)
#define PFPM_WUS_FW_RST_WK_S			31
#define PFPM_WUS_FW_RST_WK_M			BIT(31)
#define PRTPM_SAH(_i)				(0x001E3BA0 + ((_i) * 32)) /* _i=0...3 */ /* Reset Source: PFR */
#define PRTPM_SAH_MAX_INDEX			3
#define PRTPM_SAH_PFPM_SAH_S			0
#define PRTPM_SAH_PFPM_SAH_M			MAKEMASK(0xFFFF, 0)
#define PRTPM_SAH_PF_NUM_S			26
#define PRTPM_SAH_PF_NUM_M			MAKEMASK(0xF, 26)
#define PRTPM_SAH_MC_MAG_EN_S			30
#define PRTPM_SAH_MC_MAG_EN_M			BIT(30)
#define PRTPM_SAH_AV_S				31
#define PRTPM_SAH_AV_M				BIT(31)
#define PRTPM_SAL(_i)				(0x001E3B20 + ((_i) * 32)) /* _i=0...3 */ /* Reset Source: PFR */
#define PRTPM_SAL_MAX_INDEX			3
#define PRTPM_SAL_PFPM_SAL_S			0
#define PRTPM_SAL_PFPM_SAL_M			MAKEMASK(0xFFFFFFFF, 0)
#define GLPE_CQM_FUNC_INVALIDATE		0x00503300 /* Reset Source: CORER */
#define GLPE_CQM_FUNC_INVALIDATE_PF_NUM_S	0
#define GLPE_CQM_FUNC_INVALIDATE_PF_NUM_M	MAKEMASK(0x7, 0)
#define GLPE_CQM_FUNC_INVALIDATE_VM_VF_NUM_S	3
#define GLPE_CQM_FUNC_INVALIDATE_VM_VF_NUM_M	MAKEMASK(0x3FF, 3)
#define GLPE_CQM_FUNC_INVALIDATE_VM_VF_TYPE_S	13
#define GLPE_CQM_FUNC_INVALIDATE_VM_VF_TYPE_M	MAKEMASK(0x3, 13)
#define GLPE_CQM_FUNC_INVALIDATE_ENABLE_S	31
#define GLPE_CQM_FUNC_INVALIDATE_ENABLE_M	BIT(31)
#define VFPE_MRTEIDXMASK			0x00009000 /* Reset Source: PFR */
#define VFPE_MRTEIDXMASK_MRTEIDXMASKBITS_S	0
#define VFPE_MRTEIDXMASK_MRTEIDXMASKBITS_M	MAKEMASK(0x1F, 0)
#define GLTSYN_HH_DLAY				0x0008881C /* Reset Source: CORER */
#define GLTSYN_HH_DLAY_SYNC_DELAY_S		0
#define GLTSYN_HH_DLAY_SYNC_DELAY_M		MAKEMASK(0xF, 0)
#define VF_MBX_ARQBAH1				0x00006000 /* Reset Source: CORER */
#define VF_MBX_ARQBAH1_ARQBAH_S			0
#define VF_MBX_ARQBAH1_ARQBAH_M			MAKEMASK(0xFFFFFFFF, 0)
#define VF_MBX_ARQBAL1				0x00006C00 /* Reset Source: CORER */
#define VF_MBX_ARQBAL1_ARQBAL_LSB_S		0
#define VF_MBX_ARQBAL1_ARQBAL_LSB_M		MAKEMASK(0x3F, 0)
#define VF_MBX_ARQBAL1_ARQBAL_S			6
#define VF_MBX_ARQBAL1_ARQBAL_M			MAKEMASK(0x3FFFFFF, 6)
#define VF_MBX_ARQH1				0x00007400 /* Reset Source: CORER */
#define VF_MBX_ARQH1_ARQH_S			0
#define VF_MBX_ARQH1_ARQH_M			MAKEMASK(0x3FF, 0)
#define VF_MBX_ARQLEN1				0x00008000 /* Reset Source: PFR */
#define VF_MBX_ARQLEN1_ARQLEN_S			0
#define VF_MBX_ARQLEN1_ARQLEN_M			MAKEMASK(0x3FF, 0)
#define VF_MBX_ARQLEN1_ARQVFE_S			28
#define VF_MBX_ARQLEN1_ARQVFE_M			BIT(28)
#define VF_MBX_ARQLEN1_ARQOVFL_S		29
#define VF_MBX_ARQLEN1_ARQOVFL_M		BIT(29)
#define VF_MBX_ARQLEN1_ARQCRIT_S		30
#define VF_MBX_ARQLEN1_ARQCRIT_M		BIT(30)
#define VF_MBX_ARQLEN1_ARQENABLE_S		31
#define VF_MBX_ARQLEN1_ARQENABLE_M		BIT(31)
#define VF_MBX_ARQT1				0x00007000 /* Reset Source: CORER */
#define VF_MBX_ARQT1_ARQT_S			0
#define VF_MBX_ARQT1_ARQT_M			MAKEMASK(0x3FF, 0)
#define VF_MBX_ATQBAH1				0x00007800 /* Reset Source: CORER */
#define VF_MBX_ATQBAH1_ATQBAH_S			0
#define VF_MBX_ATQBAH1_ATQBAH_M			MAKEMASK(0xFFFFFFFF, 0)
#define VF_MBX_ATQBAL1				0x00007C00 /* Reset Source: CORER */
#define VF_MBX_ATQBAL1_ATQBAL_S			6
#define VF_MBX_ATQBAL1_ATQBAL_M			MAKEMASK(0x3FFFFFF, 6)
#define VF_MBX_ATQH1				0x00006400 /* Reset Source: CORER */
#define VF_MBX_ATQH1_ATQH_S			0
#define VF_MBX_ATQH1_ATQH_M			MAKEMASK(0x3FF, 0)
#define VF_MBX_ATQLEN1				0x00006800 /* Reset Source: PFR */
#define VF_MBX_ATQLEN1_ATQLEN_S			0
#define VF_MBX_ATQLEN1_ATQLEN_M			MAKEMASK(0x3FF, 0)
#define VF_MBX_ATQLEN1_ATQVFE_S			28
#define VF_MBX_ATQLEN1_ATQVFE_M			BIT(28)
#define VF_MBX_ATQLEN1_ATQOVFL_S		29
#define VF_MBX_ATQLEN1_ATQOVFL_M		BIT(29)
#define VF_MBX_ATQLEN1_ATQCRIT_S		30
#define VF_MBX_ATQLEN1_ATQCRIT_M		BIT(30)
#define VF_MBX_ATQLEN1_ATQENABLE_S		31
#define VF_MBX_ATQLEN1_ATQENABLE_M		BIT(31)
#define VF_MBX_ATQT1				0x00008400 /* Reset Source: CORER */
#define VF_MBX_ATQT1_ATQT_S			0
#define VF_MBX_ATQT1_ATQT_M			MAKEMASK(0x3FF, 0)
#define PFPCI_VF_FLUSH_DONE1			0x0000E400 /* Reset Source: PCIR */
#define PFPCI_VF_FLUSH_DONE1_FLUSH_DONE_S	0
#define PFPCI_VF_FLUSH_DONE1_FLUSH_DONE_M	BIT(0)
#define VFGEN_RSTAT1				0x00008800 /* Reset Source: VFR */
#define VFGEN_RSTAT1_VFR_STATE_S		0
#define VFGEN_RSTAT1_VFR_STATE_M		MAKEMASK(0x3, 0)
#define VFINT_DYN_CTL0				0x00005C00 /* Reset Source: CORER */
#define VFINT_DYN_CTL0_INTENA_S			0
#define VFINT_DYN_CTL0_INTENA_M			BIT(0)
#define VFINT_DYN_CTL0_CLEARPBA_S		1
#define VFINT_DYN_CTL0_CLEARPBA_M		BIT(1)
#define VFINT_DYN_CTL0_SWINT_TRIG_S		2
#define VFINT_DYN_CTL0_SWINT_TRIG_M		BIT(2)
#define VFINT_DYN_CTL0_ITR_INDX_S		3
#define VFINT_DYN_CTL0_ITR_INDX_M		MAKEMASK(0x3, 3)
#define VFINT_DYN_CTL0_INTERVAL_S		5
#define VFINT_DYN_CTL0_INTERVAL_M		MAKEMASK(0xFFF, 5)
#define VFINT_DYN_CTL0_SW_ITR_INDX_ENA_S	24
#define VFINT_DYN_CTL0_SW_ITR_INDX_ENA_M	BIT(24)
#define VFINT_DYN_CTL0_SW_ITR_INDX_S		25
#define VFINT_DYN_CTL0_SW_ITR_INDX_M		MAKEMASK(0x3, 25)
#define VFINT_DYN_CTL0_WB_ON_ITR_S		30
#define VFINT_DYN_CTL0_WB_ON_ITR_M		BIT(30)
#define VFINT_DYN_CTL0_INTENA_MSK_S		31
#define VFINT_DYN_CTL0_INTENA_MSK_M		BIT(31)
#define VFINT_DYN_CTLN(_i)			(0x00003800 + ((_i) * 4)) /* _i=0...63 */ /* Reset Source: CORER */
#define VFINT_DYN_CTLN_MAX_INDEX		63
#define VFINT_DYN_CTLN_INTENA_S			0
#define VFINT_DYN_CTLN_INTENA_M			BIT(0)
#define VFINT_DYN_CTLN_CLEARPBA_S		1
#define VFINT_DYN_CTLN_CLEARPBA_M		BIT(1)
#define VFINT_DYN_CTLN_SWINT_TRIG_S		2
#define VFINT_DYN_CTLN_SWINT_TRIG_M		BIT(2)
#define VFINT_DYN_CTLN_ITR_INDX_S		3
#define VFINT_DYN_CTLN_ITR_INDX_M		MAKEMASK(0x3, 3)
#define VFINT_DYN_CTLN_INTERVAL_S		5
#define VFINT_DYN_CTLN_INTERVAL_M		MAKEMASK(0xFFF, 5)
#define VFINT_DYN_CTLN_SW_ITR_INDX_ENA_S	24
#define VFINT_DYN_CTLN_SW_ITR_INDX_ENA_M	BIT(24)
#define VFINT_DYN_CTLN_SW_ITR_INDX_S		25
#define VFINT_DYN_CTLN_SW_ITR_INDX_M		MAKEMASK(0x3, 25)
#define VFINT_DYN_CTLN_WB_ON_ITR_S		30
#define VFINT_DYN_CTLN_WB_ON_ITR_M		BIT(30)
#define VFINT_DYN_CTLN_INTENA_MSK_S		31
#define VFINT_DYN_CTLN_INTENA_MSK_M		BIT(31)
#define VFINT_ITR0(_i)				(0x00004C00 + ((_i) * 4)) /* _i=0...2 */ /* Reset Source: CORER */
#define VFINT_ITR0_MAX_INDEX			2
#define VFINT_ITR0_INTERVAL_S			0
#define VFINT_ITR0_INTERVAL_M			MAKEMASK(0xFFF, 0)
#define VFINT_ITRN(_i, _j)			(0x00002800 + ((_i) * 4 + (_j) * 12)) /* _i=0...2, _j=0...63 */ /* Reset Source: CORER */
#define VFINT_ITRN_MAX_INDEX			2
#define VFINT_ITRN_INTERVAL_S			0
#define VFINT_ITRN_INTERVAL_M			MAKEMASK(0xFFF, 0)
#define QRX_TAIL1(_QRX)				(0x00002000 + ((_QRX) * 4)) /* _i=0...255 */ /* Reset Source: CORER */
#define QRX_TAIL1_MAX_INDEX			255
#define QRX_TAIL1_TAIL_S			0
#define QRX_TAIL1_TAIL_M			MAKEMASK(0x1FFF, 0)
#define QTX_TAIL(_DBQM)				(0x00000000 + ((_DBQM) * 4)) /* _i=0...255 */ /* Reset Source: CORER */
#define QTX_TAIL_MAX_INDEX			255
#define QTX_TAIL_QTX_COMM_DBELL_S		0
#define QTX_TAIL_QTX_COMM_DBELL_M		MAKEMASK(0xFFFFFFFF, 0)
#define VF_MBX_CPM_ARQBAH1			0x0000F060 /* Reset Source: CORER */
#define VF_MBX_CPM_ARQBAH1_ARQBAH_S		0
#define VF_MBX_CPM_ARQBAH1_ARQBAH_M		MAKEMASK(0xFFFFFFFF, 0)
#define VF_MBX_CPM_ARQBAL1			0x0000F050 /* Reset Source: CORER */
#define VF_MBX_CPM_ARQBAL1_ARQBAL_LSB_S		0
#define VF_MBX_CPM_ARQBAL1_ARQBAL_LSB_M		MAKEMASK(0x3F, 0)
#define VF_MBX_CPM_ARQBAL1_ARQBAL_S		6
#define VF_MBX_CPM_ARQBAL1_ARQBAL_M		MAKEMASK(0x3FFFFFF, 6)
#define VF_MBX_CPM_ARQH1			0x0000F080 /* Reset Source: CORER */
#define VF_MBX_CPM_ARQH1_ARQH_S			0
#define VF_MBX_CPM_ARQH1_ARQH_M			MAKEMASK(0x3FF, 0)
#define VF_MBX_CPM_ARQLEN1			0x0000F070 /* Reset Source: PFR */
#define VF_MBX_CPM_ARQLEN1_ARQLEN_S		0
#define VF_MBX_CPM_ARQLEN1_ARQLEN_M		MAKEMASK(0x3FF, 0)
#define VF_MBX_CPM_ARQLEN1_ARQVFE_S		28
#define VF_MBX_CPM_ARQLEN1_ARQVFE_M		BIT(28)
#define VF_MBX_CPM_ARQLEN1_ARQOVFL_S		29
#define VF_MBX_CPM_ARQLEN1_ARQOVFL_M		BIT(29)
#define VF_MBX_CPM_ARQLEN1_ARQCRIT_S		30
#define VF_MBX_CPM_ARQLEN1_ARQCRIT_M		BIT(30)
#define VF_MBX_CPM_ARQLEN1_ARQENABLE_S		31
#define VF_MBX_CPM_ARQLEN1_ARQENABLE_M		BIT(31)
#define VF_MBX_CPM_ARQT1			0x0000F090 /* Reset Source: CORER */
#define VF_MBX_CPM_ARQT1_ARQT_S			0
#define VF_MBX_CPM_ARQT1_ARQT_M			MAKEMASK(0x3FF, 0)
#define VF_MBX_CPM_ATQBAH1			0x0000F010 /* Reset Source: CORER */
#define VF_MBX_CPM_ATQBAH1_ATQBAH_S		0
#define VF_MBX_CPM_ATQBAH1_ATQBAH_M		MAKEMASK(0xFFFFFFFF, 0)
#define VF_MBX_CPM_ATQBAL1			0x0000F000 /* Reset Source: CORER */
#define VF_MBX_CPM_ATQBAL1_ATQBAL_S		6
#define VF_MBX_CPM_ATQBAL1_ATQBAL_M		MAKEMASK(0x3FFFFFF, 6)
#define VF_MBX_CPM_ATQH1			0x0000F030 /* Reset Source: CORER */
#define VF_MBX_CPM_ATQH1_ATQH_S			0
#define VF_MBX_CPM_ATQH1_ATQH_M			MAKEMASK(0x3FF, 0)
#define VF_MBX_CPM_ATQLEN1			0x0000F020 /* Reset Source: PFR */
#define VF_MBX_CPM_ATQLEN1_ATQLEN_S		0
#define VF_MBX_CPM_ATQLEN1_ATQLEN_M		MAKEMASK(0x3FF, 0)
#define VF_MBX_CPM_ATQLEN1_ATQVFE_S		28
#define VF_MBX_CPM_ATQLEN1_ATQVFE_M		BIT(28)
#define VF_MBX_CPM_ATQLEN1_ATQOVFL_S		29
#define VF_MBX_CPM_ATQLEN1_ATQOVFL_M		BIT(29)
#define VF_MBX_CPM_ATQLEN1_ATQCRIT_S		30
#define VF_MBX_CPM_ATQLEN1_ATQCRIT_M		BIT(30)
#define VF_MBX_CPM_ATQLEN1_ATQENABLE_S		31
#define VF_MBX_CPM_ATQLEN1_ATQENABLE_M		BIT(31)
#define VF_MBX_CPM_ATQT1			0x0000F040 /* Reset Source: CORER */
#define VF_MBX_CPM_ATQT1_ATQT_S			0
#define VF_MBX_CPM_ATQT1_ATQT_M			MAKEMASK(0x3FF, 0)
#define VF_MBX_HLP_ARQBAH1			0x00020060 /* Reset Source: CORER */
#define VF_MBX_HLP_ARQBAH1_ARQBAH_S		0
#define VF_MBX_HLP_ARQBAH1_ARQBAH_M		MAKEMASK(0xFFFFFFFF, 0)
#define VF_MBX_HLP_ARQBAL1			0x00020050 /* Reset Source: CORER */
#define VF_MBX_HLP_ARQBAL1_ARQBAL_LSB_S		0
#define VF_MBX_HLP_ARQBAL1_ARQBAL_LSB_M		MAKEMASK(0x3F, 0)
#define VF_MBX_HLP_ARQBAL1_ARQBAL_S		6
#define VF_MBX_HLP_ARQBAL1_ARQBAL_M		MAKEMASK(0x3FFFFFF, 6)
#define VF_MBX_HLP_ARQH1			0x00020080 /* Reset Source: CORER */
#define VF_MBX_HLP_ARQH1_ARQH_S			0
#define VF_MBX_HLP_ARQH1_ARQH_M			MAKEMASK(0x3FF, 0)
#define VF_MBX_HLP_ARQLEN1			0x00020070 /* Reset Source: PFR */
#define VF_MBX_HLP_ARQLEN1_ARQLEN_S		0
#define VF_MBX_HLP_ARQLEN1_ARQLEN_M		MAKEMASK(0x3FF, 0)
#define VF_MBX_HLP_ARQLEN1_ARQVFE_S		28
#define VF_MBX_HLP_ARQLEN1_ARQVFE_M		BIT(28)
#define VF_MBX_HLP_ARQLEN1_ARQOVFL_S		29
#define VF_MBX_HLP_ARQLEN1_ARQOVFL_M		BIT(29)
#define VF_MBX_HLP_ARQLEN1_ARQCRIT_S		30
#define VF_MBX_HLP_ARQLEN1_ARQCRIT_M		BIT(30)
#define VF_MBX_HLP_ARQLEN1_ARQENABLE_S		31
#define VF_MBX_HLP_ARQLEN1_ARQENABLE_M		BIT(31)
#define VF_MBX_HLP_ARQT1			0x00020090 /* Reset Source: CORER */
#define VF_MBX_HLP_ARQT1_ARQT_S			0
#define VF_MBX_HLP_ARQT1_ARQT_M			MAKEMASK(0x3FF, 0)
#define VF_MBX_HLP_ATQBAH1			0x00020010 /* Reset Source: CORER */
#define VF_MBX_HLP_ATQBAH1_ATQBAH_S		0
#define VF_MBX_HLP_ATQBAH1_ATQBAH_M		MAKEMASK(0xFFFFFFFF, 0)
#define VF_MBX_HLP_ATQBAL1			0x00020000 /* Reset Source: CORER */
#define VF_MBX_HLP_ATQBAL1_ATQBAL_S		6
#define VF_MBX_HLP_ATQBAL1_ATQBAL_M		MAKEMASK(0x3FFFFFF, 6)
#define VF_MBX_HLP_ATQH1			0x00020030 /* Reset Source: CORER */
#define VF_MBX_HLP_ATQH1_ATQH_S			0
#define VF_MBX_HLP_ATQH1_ATQH_M			MAKEMASK(0x3FF, 0)
#define VF_MBX_HLP_ATQLEN1			0x00020020 /* Reset Source: PFR */
#define VF_MBX_HLP_ATQLEN1_ATQLEN_S		0
#define VF_MBX_HLP_ATQLEN1_ATQLEN_M		MAKEMASK(0x3FF, 0)
#define VF_MBX_HLP_ATQLEN1_ATQVFE_S		28
#define VF_MBX_HLP_ATQLEN1_ATQVFE_M		BIT(28)
#define VF_MBX_HLP_ATQLEN1_ATQOVFL_S		29
#define VF_MBX_HLP_ATQLEN1_ATQOVFL_M		BIT(29)
#define VF_MBX_HLP_ATQLEN1_ATQCRIT_S		30
#define VF_MBX_HLP_ATQLEN1_ATQCRIT_M		BIT(30)
#define VF_MBX_HLP_ATQLEN1_ATQENABLE_S		31
#define VF_MBX_HLP_ATQLEN1_ATQENABLE_M		BIT(31)
#define VF_MBX_HLP_ATQT1			0x00020040 /* Reset Source: CORER */
#define VF_MBX_HLP_ATQT1_ATQT_S			0
#define VF_MBX_HLP_ATQT1_ATQT_M			MAKEMASK(0x3FF, 0)
#define VF_MBX_PSM_ARQBAH1			0x00021060 /* Reset Source: CORER */
#define VF_MBX_PSM_ARQBAH1_ARQBAH_S		0
#define VF_MBX_PSM_ARQBAH1_ARQBAH_M		MAKEMASK(0xFFFFFFFF, 0)
#define VF_MBX_PSM_ARQBAL1			0x00021050 /* Reset Source: CORER */
#define VF_MBX_PSM_ARQBAL1_ARQBAL_LSB_S		0
#define VF_MBX_PSM_ARQBAL1_ARQBAL_LSB_M		MAKEMASK(0x3F, 0)
#define VF_MBX_PSM_ARQBAL1_ARQBAL_S		6
#define VF_MBX_PSM_ARQBAL1_ARQBAL_M		MAKEMASK(0x3FFFFFF, 6)
#define VF_MBX_PSM_ARQH1			0x00021080 /* Reset Source: CORER */
#define VF_MBX_PSM_ARQH1_ARQH_S			0
#define VF_MBX_PSM_ARQH1_ARQH_M			MAKEMASK(0x3FF, 0)
#define VF_MBX_PSM_ARQLEN1			0x00021070 /* Reset Source: PFR */
#define VF_MBX_PSM_ARQLEN1_ARQLEN_S		0
#define VF_MBX_PSM_ARQLEN1_ARQLEN_M		MAKEMASK(0x3FF, 0)
#define VF_MBX_PSM_ARQLEN1_ARQVFE_S		28
#define VF_MBX_PSM_ARQLEN1_ARQVFE_M		BIT(28)
#define VF_MBX_PSM_ARQLEN1_ARQOVFL_S		29
#define VF_MBX_PSM_ARQLEN1_ARQOVFL_M		BIT(29)
#define VF_MBX_PSM_ARQLEN1_ARQCRIT_S		30
#define VF_MBX_PSM_ARQLEN1_ARQCRIT_M		BIT(30)
#define VF_MBX_PSM_ARQLEN1_ARQENABLE_S		31
#define VF_MBX_PSM_ARQLEN1_ARQENABLE_M		BIT(31)
#define VF_MBX_PSM_ARQT1			0x00021090 /* Reset Source: CORER */
#define VF_MBX_PSM_ARQT1_ARQT_S			0
#define VF_MBX_PSM_ARQT1_ARQT_M			MAKEMASK(0x3FF, 0)
#define VF_MBX_PSM_ATQBAH1			0x00021010 /* Reset Source: CORER */
#define VF_MBX_PSM_ATQBAH1_ATQBAH_S		0
#define VF_MBX_PSM_ATQBAH1_ATQBAH_M		MAKEMASK(0xFFFFFFFF, 0)
#define VF_MBX_PSM_ATQBAL1			0x00021000 /* Reset Source: CORER */
#define VF_MBX_PSM_ATQBAL1_ATQBAL_S		6
#define VF_MBX_PSM_ATQBAL1_ATQBAL_M		MAKEMASK(0x3FFFFFF, 6)
#define VF_MBX_PSM_ATQH1			0x00021030 /* Reset Source: CORER */
#define VF_MBX_PSM_ATQH1_ATQH_S			0
#define VF_MBX_PSM_ATQH1_ATQH_M			MAKEMASK(0x3FF, 0)
#define VF_MBX_PSM_ATQLEN1			0x00021020 /* Reset Source: PFR */
#define VF_MBX_PSM_ATQLEN1_ATQLEN_S		0
#define VF_MBX_PSM_ATQLEN1_ATQLEN_M		MAKEMASK(0x3FF, 0)
#define VF_MBX_PSM_ATQLEN1_ATQVFE_S		28
#define VF_MBX_PSM_ATQLEN1_ATQVFE_M		BIT(28)
#define VF_MBX_PSM_ATQLEN1_ATQOVFL_S		29
#define VF_MBX_PSM_ATQLEN1_ATQOVFL_M		BIT(29)
#define VF_MBX_PSM_ATQLEN1_ATQCRIT_S		30
#define VF_MBX_PSM_ATQLEN1_ATQCRIT_M		BIT(30)
#define VF_MBX_PSM_ATQLEN1_ATQENABLE_S		31
#define VF_MBX_PSM_ATQLEN1_ATQENABLE_M		BIT(31)
#define VF_MBX_PSM_ATQT1			0x00021040 /* Reset Source: CORER */
#define VF_MBX_PSM_ATQT1_ATQT_S			0
#define VF_MBX_PSM_ATQT1_ATQT_M			MAKEMASK(0x3FF, 0)
#define VF_SB_CPM_ARQBAH1			0x0000F160 /* Reset Source: CORER */
#define VF_SB_CPM_ARQBAH1_ARQBAH_S		0
#define VF_SB_CPM_ARQBAH1_ARQBAH_M		MAKEMASK(0xFFFFFFFF, 0)
#define VF_SB_CPM_ARQBAL1			0x0000F150 /* Reset Source: CORER */
#define VF_SB_CPM_ARQBAL1_ARQBAL_LSB_S		0
#define VF_SB_CPM_ARQBAL1_ARQBAL_LSB_M		MAKEMASK(0x3F, 0)
#define VF_SB_CPM_ARQBAL1_ARQBAL_S		6
#define VF_SB_CPM_ARQBAL1_ARQBAL_M		MAKEMASK(0x3FFFFFF, 6)
#define VF_SB_CPM_ARQH1				0x0000F180 /* Reset Source: CORER */
#define VF_SB_CPM_ARQH1_ARQH_S			0
#define VF_SB_CPM_ARQH1_ARQH_M			MAKEMASK(0x3FF, 0)
#define VF_SB_CPM_ARQLEN1			0x0000F170 /* Reset Source: PFR */
#define VF_SB_CPM_ARQLEN1_ARQLEN_S		0
#define VF_SB_CPM_ARQLEN1_ARQLEN_M		MAKEMASK(0x3FF, 0)
#define VF_SB_CPM_ARQLEN1_ARQVFE_S		28
#define VF_SB_CPM_ARQLEN1_ARQVFE_M		BIT(28)
#define VF_SB_CPM_ARQLEN1_ARQOVFL_S		29
#define VF_SB_CPM_ARQLEN1_ARQOVFL_M		BIT(29)
#define VF_SB_CPM_ARQLEN1_ARQCRIT_S		30
#define VF_SB_CPM_ARQLEN1_ARQCRIT_M		BIT(30)
#define VF_SB_CPM_ARQLEN1_ARQENABLE_S		31
#define VF_SB_CPM_ARQLEN1_ARQENABLE_M		BIT(31)
#define VF_SB_CPM_ARQT1				0x0000F190 /* Reset Source: CORER */
#define VF_SB_CPM_ARQT1_ARQT_S			0
#define VF_SB_CPM_ARQT1_ARQT_M			MAKEMASK(0x3FF, 0)
#define VF_SB_CPM_ATQBAH1			0x0000F110 /* Reset Source: CORER */
#define VF_SB_CPM_ATQBAH1_ATQBAH_S		0
#define VF_SB_CPM_ATQBAH1_ATQBAH_M		MAKEMASK(0xFFFFFFFF, 0)
#define VF_SB_CPM_ATQBAL1			0x0000F100 /* Reset Source: CORER */
#define VF_SB_CPM_ATQBAL1_ATQBAL_S		6
#define VF_SB_CPM_ATQBAL1_ATQBAL_M		MAKEMASK(0x3FFFFFF, 6)
#define VF_SB_CPM_ATQH1				0x0000F130 /* Reset Source: CORER */
#define VF_SB_CPM_ATQH1_ATQH_S			0
#define VF_SB_CPM_ATQH1_ATQH_M			MAKEMASK(0x3FF, 0)
#define VF_SB_CPM_ATQLEN1			0x0000F120 /* Reset Source: PFR */
#define VF_SB_CPM_ATQLEN1_ATQLEN_S		0
#define VF_SB_CPM_ATQLEN1_ATQLEN_M		MAKEMASK(0x3FF, 0)
#define VF_SB_CPM_ATQLEN1_ATQVFE_S		28
#define VF_SB_CPM_ATQLEN1_ATQVFE_M		BIT(28)
#define VF_SB_CPM_ATQLEN1_ATQOVFL_S		29
#define VF_SB_CPM_ATQLEN1_ATQOVFL_M		BIT(29)
#define VF_SB_CPM_ATQLEN1_ATQCRIT_S		30
#define VF_SB_CPM_ATQLEN1_ATQCRIT_M		BIT(30)
#define VF_SB_CPM_ATQLEN1_ATQENABLE_S		31
#define VF_SB_CPM_ATQLEN1_ATQENABLE_M		BIT(31)
#define VF_SB_CPM_ATQT1				0x0000F140 /* Reset Source: CORER */
#define VF_SB_CPM_ATQT1_ATQT_S			0
#define VF_SB_CPM_ATQT1_ATQT_M			MAKEMASK(0x3FF, 0)
#define VFINT_DYN_CTL(_i)			(0x00023000 + ((_i) * 4096)) /* _i=0...7 */ /* Reset Source: CORER */
#define VFINT_DYN_CTL_MAX_INDEX			7
#define VFINT_DYN_CTL_INTENA_S			0
#define VFINT_DYN_CTL_INTENA_M			BIT(0)
#define VFINT_DYN_CTL_CLEARPBA_S		1
#define VFINT_DYN_CTL_CLEARPBA_M		BIT(1)
#define VFINT_DYN_CTL_SWINT_TRIG_S		2
#define VFINT_DYN_CTL_SWINT_TRIG_M		BIT(2)
#define VFINT_DYN_CTL_ITR_INDX_S		3
#define VFINT_DYN_CTL_ITR_INDX_M		MAKEMASK(0x3, 3)
#define VFINT_DYN_CTL_INTERVAL_S		5
#define VFINT_DYN_CTL_INTERVAL_M		MAKEMASK(0xFFF, 5)
#define VFINT_DYN_CTL_SW_ITR_INDX_ENA_S		24
#define VFINT_DYN_CTL_SW_ITR_INDX_ENA_M		BIT(24)
#define VFINT_DYN_CTL_SW_ITR_INDX_S		25
#define VFINT_DYN_CTL_SW_ITR_INDX_M		MAKEMASK(0x3, 25)
#define VFINT_DYN_CTL_WB_ON_ITR_S		30
#define VFINT_DYN_CTL_WB_ON_ITR_M		BIT(30)
#define VFINT_DYN_CTL_INTENA_MSK_S		31
#define VFINT_DYN_CTL_INTENA_MSK_M		BIT(31)
#define VFINT_ITR_0(_i)				(0x00023004 + ((_i) * 4096)) /* _i=0...7 */ /* Reset Source: CORER */
#define VFINT_ITR_0_MAX_INDEX			7
#define VFINT_ITR_0_INTERVAL_S			0
#define VFINT_ITR_0_INTERVAL_M			MAKEMASK(0xFFF, 0)
#define VFINT_ITR_1(_i)				(0x00023008 + ((_i) * 4096)) /* _i=0...7 */ /* Reset Source: CORER */
#define VFINT_ITR_1_MAX_INDEX			7
#define VFINT_ITR_1_INTERVAL_S			0
#define VFINT_ITR_1_INTERVAL_M			MAKEMASK(0xFFF, 0)
#define VFINT_ITR_2(_i)				(0x0002300C + ((_i) * 4096)) /* _i=0...7 */ /* Reset Source: CORER */
#define VFINT_ITR_2_MAX_INDEX			7
#define VFINT_ITR_2_INTERVAL_S			0
#define VFINT_ITR_2_INTERVAL_M			MAKEMASK(0xFFF, 0)
#define VFQRX_TAIL(_QRX)			(0x0002E000 + ((_QRX) * 4)) /* _i=0...255 */ /* Reset Source: CORER */
#define VFQRX_TAIL_MAX_INDEX			255
#define VFQRX_TAIL_TAIL_S			0
#define VFQRX_TAIL_TAIL_M			MAKEMASK(0x1FFF, 0)
#define VFQTX_COMM_DBELL(_DBQM)			(0x00030000 + ((_DBQM) * 4)) /* _i=0...255 */ /* Reset Source: CORER */
#define VFQTX_COMM_DBELL_MAX_INDEX		255
#define VFQTX_COMM_DBELL_QTX_COMM_DBELL_S	0
#define VFQTX_COMM_DBELL_QTX_COMM_DBELL_M	MAKEMASK(0xFFFFFFFF, 0)
#define VFQTX_COMM_DBLQ_DBELL(_DBLQ)		(0x00022000 + ((_DBLQ) * 4)) /* _i=0...3 */ /* Reset Source: CORER */
#define VFQTX_COMM_DBLQ_DBELL_MAX_INDEX		3
#define VFQTX_COMM_DBLQ_DBELL_TAIL_S		0
#define VFQTX_COMM_DBLQ_DBELL_TAIL_M		MAKEMASK(0x1FFF, 0)
#define MSIX_TMSG1(_i)				(0x00000008 + ((_i) * 16)) /* _i=0...64 */ /* Reset Source: FLR */
#define MSIX_TMSG1_MAX_INDEX			64
#define MSIX_TMSG1_MSIXTMSG_S			0
#define MSIX_TMSG1_MSIXTMSG_M			MAKEMASK(0xFFFFFFFF, 0)
#define VFPE_AEQALLOC1				0x0000A400 /* Reset Source: VFR */
#define VFPE_AEQALLOC1_AECOUNT_S		0
#define VFPE_AEQALLOC1_AECOUNT_M		MAKEMASK(0xFFFFFFFF, 0)
#define VFPE_CCQPHIGH1				0x00009800 /* Reset Source: VFR */
#define VFPE_CCQPHIGH1_PECCQPHIGH_S		0
#define VFPE_CCQPHIGH1_PECCQPHIGH_M		MAKEMASK(0xFFFFFFFF, 0)
#define VFPE_CCQPLOW1				0x0000AC00 /* Reset Source: VFR */
#define VFPE_CCQPLOW1_PECCQPLOW_S		0
#define VFPE_CCQPLOW1_PECCQPLOW_M		MAKEMASK(0xFFFFFFFF, 0)
#define VFPE_CCQPSTATUS1			0x0000B800 /* Reset Source: VFR */
#define VFPE_CCQPSTATUS1_CCQP_DONE_S		0
#define VFPE_CCQPSTATUS1_CCQP_DONE_M		BIT(0)
#define VFPE_CCQPSTATUS1_HMC_PROFILE_S		4
#define VFPE_CCQPSTATUS1_HMC_PROFILE_M		MAKEMASK(0x7, 4)
#define VFPE_CCQPSTATUS1_RDMA_EN_VFS_S		16
#define VFPE_CCQPSTATUS1_RDMA_EN_VFS_M		MAKEMASK(0x3F, 16)
#define VFPE_CCQPSTATUS1_CCQP_ERR_S		31
#define VFPE_CCQPSTATUS1_CCQP_ERR_M		BIT(31)
#define VFPE_CQACK1				0x0000B000 /* Reset Source: VFR */
#define VFPE_CQACK1_PECQID_S			0
#define VFPE_CQACK1_PECQID_M			MAKEMASK(0x7FFFF, 0)
#define VFPE_CQARM1				0x0000B400 /* Reset Source: VFR */
#define VFPE_CQARM1_PECQID_S			0
#define VFPE_CQARM1_PECQID_M			MAKEMASK(0x7FFFF, 0)
#define VFPE_CQPDB1				0x0000BC00 /* Reset Source: VFR */
#define VFPE_CQPDB1_WQHEAD_S			0
#define VFPE_CQPDB1_WQHEAD_M			MAKEMASK(0x7FF, 0)
#define VFPE_CQPERRCODES1			0x00009C00 /* Reset Source: VFR */
#define VFPE_CQPERRCODES1_CQP_MINOR_CODE_S	0
#define VFPE_CQPERRCODES1_CQP_MINOR_CODE_M	MAKEMASK(0xFFFF, 0)
#define VFPE_CQPERRCODES1_CQP_MAJOR_CODE_S	16
#define VFPE_CQPERRCODES1_CQP_MAJOR_CODE_M	MAKEMASK(0xFFFF, 16)
#define VFPE_CQPTAIL1				0x0000A000 /* Reset Source: VFR */
#define VFPE_CQPTAIL1_WQTAIL_S			0
#define VFPE_CQPTAIL1_WQTAIL_M			MAKEMASK(0x7FF, 0)
#define VFPE_CQPTAIL1_CQP_OP_ERR_S		31
#define VFPE_CQPTAIL1_CQP_OP_ERR_M		BIT(31)
#define VFPE_IPCONFIG01				0x00008C00 /* Reset Source: VFR */
#define VFPE_IPCONFIG01_PEIPID_S		0
#define VFPE_IPCONFIG01_PEIPID_M		MAKEMASK(0xFFFF, 0)
#define VFPE_IPCONFIG01_USEENTIREIDRANGE_S	16
#define VFPE_IPCONFIG01_USEENTIREIDRANGE_M	BIT(16)
#define VFPE_IPCONFIG01_UDP_SRC_PORT_MASK_EN_S	17
#define VFPE_IPCONFIG01_UDP_SRC_PORT_MASK_EN_M	BIT(17)
#define VFPE_MRTEIDXMASK1(_VF)			(0x00509800 + ((_VF) * 4)) /* _i=0...255 */ /* Reset Source: PFR */
#define VFPE_MRTEIDXMASK1_MAX_INDEX		255
#define VFPE_MRTEIDXMASK1_MRTEIDXMASKBITS_S	0
#define VFPE_MRTEIDXMASK1_MRTEIDXMASKBITS_M	MAKEMASK(0x1F, 0)
#define VFPE_RCVUNEXPECTEDERROR1		0x00009400 /* Reset Source: VFR */
#define VFPE_RCVUNEXPECTEDERROR1_TCP_RX_UNEXP_ERR_S 0
#define VFPE_RCVUNEXPECTEDERROR1_TCP_RX_UNEXP_ERR_M MAKEMASK(0xFFFFFF, 0)
#define VFPE_TCPNOWTIMER1			0x0000A800 /* Reset Source: VFR */
#define VFPE_TCPNOWTIMER1_TCP_NOW_S		0
#define VFPE_TCPNOWTIMER1_TCP_NOW_M		MAKEMASK(0xFFFFFFFF, 0)
#define VFPE_WQEALLOC1				0x0000C000 /* Reset Source: VFR */
#define VFPE_WQEALLOC1_PEQPID_S			0
#define VFPE_WQEALLOC1_PEQPID_M			MAKEMASK(0x3FFFF, 0)
#define VFPE_WQEALLOC1_WQE_DESC_INDEX_S		20
#define VFPE_WQEALLOC1_WQE_DESC_INDEX_M		MAKEMASK(0xFFF, 20)

#endif
