/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * Copyright (C) 2016 Gvozden Nešković. All rights reserved.
 */

#include <sys/isa_defs.h>

#if defined(__x86_64) && defined(HAVE_SSSE3)

#include <sys/types.h>
#include <sys/simd.h>

#ifdef __linux__
#define	__asm __asm__ __volatile__
#endif

#define	_REG_CNT(_0, _1, _2, _3, _4, _5, _6, _7, N, ...) N
#define	REG_CNT(r...) _REG_CNT(r, 8, 7, 6, 5, 4, 3, 2, 1)

#define	VR0_(REG, ...) "xmm"#REG
#define	VR1_(_1, REG, ...) "xmm"#REG
#define	VR2_(_1, _2, REG, ...) "xmm"#REG
#define	VR3_(_1, _2, _3, REG, ...) "xmm"#REG
#define	VR4_(_1, _2, _3, _4, REG, ...) "xmm"#REG
#define	VR5_(_1, _2, _3, _4, _5, REG, ...) "xmm"#REG
#define	VR6_(_1, _2, _3, _4, _5, _6, REG, ...) "xmm"#REG
#define	VR7_(_1, _2, _3, _4, _5, _6, _7, REG, ...) "xmm"#REG

#define	VR0(r...) VR0_(r)
#define	VR1(r...) VR1_(r)
#define	VR2(r...) VR2_(r, 1)
#define	VR3(r...) VR3_(r, 1, 2)
#define	VR4(r...) VR4_(r, 1, 2)
#define	VR5(r...) VR5_(r, 1, 2, 3)
#define	VR6(r...) VR6_(r, 1, 2, 3, 4)
#define	VR7(r...) VR7_(r, 1, 2, 3, 4, 5)

#define	R_01(REG1, REG2, ...) REG1, REG2
#define	_R_23(_0, _1, REG2, REG3, ...) REG2, REG3
#define	R_23(REG...) _R_23(REG, 1, 2, 3)

#define	ZFS_ASM_BUG()	ASSERT(0)

const uint8_t gf_clmul_mod_lt[4*256][16];

#define	ELEM_SIZE 16

typedef struct v {
	uint8_t b[ELEM_SIZE] __attribute__((aligned(ELEM_SIZE)));
} v_t;


#define	XOR_ACC(src, r...) 						\
{									\
	switch (REG_CNT(r)) {						\
	case 4:								\
		__asm(							\
		    "pxor 0x00(%[SRC]), %%" VR0(r) "\n"			\
		    "pxor 0x10(%[SRC]), %%" VR1(r) "\n"			\
		    "pxor 0x20(%[SRC]), %%" VR2(r) "\n"			\
		    "pxor 0x30(%[SRC]), %%" VR3(r) "\n"			\
		    : : [SRC] "r" (src));				\
		break;							\
	case 2:								\
		__asm(							\
		    "pxor 0x00(%[SRC]), %%" VR0(r) "\n"			\
		    "pxor 0x10(%[SRC]), %%" VR1(r) "\n"			\
		    : : [SRC] "r" (src));				\
		break;							\
	default:							\
		ZFS_ASM_BUG();						\
	}								\
}

#define	XOR(r...)							\
{									\
	switch (REG_CNT(r)) {						\
	case 8:								\
		__asm(							\
		    "pxor %" VR0(r) ", %" VR4(r) "\n"			\
		    "pxor %" VR1(r) ", %" VR5(r) "\n"			\
		    "pxor %" VR2(r) ", %" VR6(r) "\n"			\
		    "pxor %" VR3(r) ", %" VR7(r));			\
		break;							\
	case 4:								\
		__asm(							\
		    "pxor %" VR0(r) ", %" VR2(r) "\n"			\
		    "pxor %" VR1(r) ", %" VR3(r));			\
		break;							\
	default:							\
		ZFS_ASM_BUG();						\
	}								\
}

#define	ZERO(r...)	XOR(r, r)

#define	COPY(r...) 							\
{									\
	switch (REG_CNT(r)) {						\
	case 8:								\
		__asm(							\
		    "movdqa %" VR0(r) ", %" VR4(r) "\n"			\
		    "movdqa %" VR1(r) ", %" VR5(r) "\n"			\
		    "movdqa %" VR2(r) ", %" VR6(r) "\n"			\
		    "movdqa %" VR3(r) ", %" VR7(r));			\
		break;							\
	case 4:								\
		__asm(							\
		    "movdqa %" VR0(r) ", %" VR2(r) "\n"			\
		    "movdqa %" VR1(r) ", %" VR3(r));			\
		break;							\
	default:							\
		ZFS_ASM_BUG();						\
	}								\
}

#define	LOAD(src, r...) 						\
{									\
	switch (REG_CNT(r)) {						\
	case 4:								\
		__asm(							\
		    "movdqa 0x00(%[SRC]), %%" VR0(r) "\n"		\
		    "movdqa 0x10(%[SRC]), %%" VR1(r) "\n"		\
		    "movdqa 0x20(%[SRC]), %%" VR2(r) "\n"		\
		    "movdqa 0x30(%[SRC]), %%" VR3(r) "\n"		\
		    : : [SRC] "r" (src));				\
		break;							\
	case 2:								\
		__asm(							\
		    "movdqa 0x00(%[SRC]), %%" VR0(r) "\n"		\
		    "movdqa 0x10(%[SRC]), %%" VR1(r) "\n"		\
		    : : [SRC] "r" (src));				\
		break;							\
	default:							\
		ZFS_ASM_BUG();						\
	}								\
}

#define	STORE(dst, r...)						\
{									\
	switch (REG_CNT(r)) {						\
	case 4:								\
		__asm(							\
		    "movdqa %%" VR0(r)", 0x00(%[DST])\n"		\
		    "movdqa %%" VR1(r)", 0x10(%[DST])\n"		\
		    "movdqa %%" VR2(r)", 0x20(%[DST])\n"		\
		    "movdqa %%" VR3(r)", 0x30(%[DST])\n"		\
		    : : [DST] "r" (dst));				\
		break;							\
	case 2:								\
		__asm(							\
		    "movdqa %%" VR0(r)", 0x00(%[DST])\n"		\
		    "movdqa %%" VR1(r)", 0x10(%[DST])\n"		\
		    : : [DST] "r" (dst));				\
		break;							\
	default:							\
		ZFS_ASM_BUG();						\
	}								\
}

#define	MUL2_SETUP()							\
{   									\
	__asm(								\
	    "movd %[mask], %%xmm15\n"					\
	    "pshufd $0x0, %%xmm15, %%xmm15\n"				\
	    : : [mask] "r" (0x1d1d1d1d));				\
}

#define	_MUL2_x2(r...) 							\
{									\
	switch (REG_CNT(r)) {						\
	case 2:								\
		__asm(							\
		    "pxor    %xmm14,      %xmm14\n"			\
		    "pxor    %xmm13,      %xmm13\n"			\
		    "pcmpgtb %" VR0(r)",  %xmm14\n"			\
		    "pcmpgtb %" VR1(r)",  %xmm13\n"			\
		    "pand    %xmm15,      %xmm14\n"			\
		    "pand    %xmm15,      %xmm13\n"			\
		    "paddb   %" VR0(r)",  %" VR0(r) "\n"		\
		    "paddb   %" VR1(r)",  %" VR1(r) "\n"		\
		    "pxor    %xmm14,      %" VR0(r) "\n"		\
		    "pxor    %xmm13,      %" VR1(r));			\
		break;							\
	default:							\
		ZFS_ASM_BUG();						\
	}								\
}

#define	MUL2(r...)							\
{									\
	switch (REG_CNT(r)) {						\
	case 4:								\
		_MUL2_x2(R_01(r));					\
		_MUL2_x2(R_23(r));					\
		break;							\
	case 2:								\
		_MUL2_x2(r);						\
		break;							\
	default:							\
		ZFS_ASM_BUG();						\
	}								\
}

#define	MUL4(r...)							\
{									\
	MUL2(r);							\
	MUL2(r);							\
}

#define	_0f		"xmm15"
#define	_a_save		"xmm14"
#define	_b_save		"xmm13"
#define	_lt_mod_a	"xmm12"
#define	_lt_clmul_a	"xmm11"
#define	_lt_mod_b	"xmm10"
#define	_lt_clmul_b	"xmm15"

#define	_MULx2(c, r...)							\
{									\
	switch (REG_CNT(r)) {						\
	case 2:								\
		__asm(							\
		    /* lts for upper part */				\
		    "movd %[mask], %%" _0f "\n"				\
		    "pshufd $0x0, %%" _0f ", %%" _0f "\n"		\
		    "movdqa 0x00(%[lt]), %%" _lt_mod_a "\n"		\
		    "movdqa 0x10(%[lt]), %%" _lt_clmul_a "\n"		\
		    /* upper part */					\
		    "movdqa %%" VR0(r) ", %%" _a_save "\n"		\
		    "movdqa %%" VR1(r) ", %%" _b_save "\n"		\
		    "psraw $0x4, %%" VR0(r) "\n"			\
		    "psraw $0x4, %%" VR1(r) "\n"			\
		    "pand %%" _0f ", %%" _a_save "\n"			\
		    "pand %%" _0f ", %%" _b_save "\n"			\
		    "pand %%" _0f ", %%" VR0(r) "\n"			\
		    "pand %%" _0f ", %%" VR1(r) "\n"			\
									\
		    "movdqa %%" _lt_mod_a ", %%" _lt_mod_b "\n"		\
		    "movdqa %%" _lt_clmul_a ", %%" _lt_clmul_b "\n"	\
									\
		    "pshufb %%" VR0(r) ",%%" _lt_mod_a "\n"		\
		    "pshufb %%" VR1(r) ",%%" _lt_mod_b "\n"		\
		    "pshufb %%" VR0(r) ",%%" _lt_clmul_a "\n"		\
		    "pshufb %%" VR1(r) ",%%" _lt_clmul_b "\n"		\
									\
		    "pxor %%" _lt_mod_a ",%%" _lt_clmul_a "\n"		\
		    "pxor %%" _lt_mod_b ",%%" _lt_clmul_b "\n"		\
		    "movdqa %%" _lt_clmul_a ",%%" VR0(r) "\n"		\
		    "movdqa %%" _lt_clmul_b ",%%" VR1(r) "\n"		\
		    /* lts for lower part */				\
		    "movdqa 0x20(%[lt]), %%" _lt_mod_a "\n"		\
		    "movdqa 0x30(%[lt]), %%" _lt_clmul_a "\n"		\
		    "movdqa %%" _lt_mod_a ", %%" _lt_mod_b "\n"		\
		    "movdqa %%" _lt_clmul_a ", %%" _lt_clmul_b "\n"	\
		    /* lower part */					\
		    "pshufb %%" _a_save ",%%" _lt_mod_a "\n"		\
		    "pshufb %%" _b_save ",%%" _lt_mod_b "\n"		\
		    "pshufb %%" _a_save ",%%" _lt_clmul_a "\n"		\
		    "pshufb %%" _b_save ",%%" _lt_clmul_b "\n"		\
									\
		    "pxor %%" _lt_mod_a ",%%" VR0(r) "\n"		\
		    "pxor %%" _lt_mod_b ",%%" VR1(r) "\n"		\
		    "pxor %%" _lt_clmul_a ",%%" VR0(r) "\n"		\
		    "pxor %%" _lt_clmul_b ",%%" VR1(r) "\n"		\
		    : : [mask] "r" (0x0f0f0f0f),			\
		    [lt] "r" (gf_clmul_mod_lt[4*(c)]));			\
		break;							\
	default:							\
		ZFS_ASM_BUG();						\
	}								\
}

#define	MUL(c, r...) 							\
{									\
	switch (REG_CNT(r)) {						\
	case 4:								\
		_MULx2(c, R_23(r));					\
		_MULx2(c, R_01(r));					\
		break;							\
	case 2:								\
		_MULx2(c, R_01(r));					\
		break;							\
	default:							\
		ZFS_ASM_BUG();						\
	}								\
}

#define	raidz_math_begin()	kfpu_begin()
#define	raidz_math_end()	kfpu_end()


#define	SYN_STRIDE		4

#define	ZERO_STRIDE		4
#define	ZERO_DEFINE()		{}
#define	ZERO_D			0, 1, 2, 3

#define	COPY_STRIDE		4
#define	COPY_DEFINE()		{}
#define	COPY_D			0, 1, 2, 3

#define	ADD_STRIDE		4
#define	ADD_DEFINE()		{}
#define	ADD_D 			0, 1, 2, 3

#define	MUL_STRIDE		4
#define	MUL_DEFINE() 		{}
#define	MUL_D			0, 1, 2, 3

#define	GEN_P_STRIDE		4
#define	GEN_P_DEFINE()		{}
#define	GEN_P_P			0, 1, 2, 3

#define	GEN_PQ_STRIDE		4
#define	GEN_PQ_DEFINE() 	{}
#define	GEN_PQ_D		0, 1, 2, 3
#define	GEN_PQ_C		4, 5, 6, 7

#define	GEN_PQR_STRIDE		4
#define	GEN_PQR_DEFINE() 	{}
#define	GEN_PQR_D		0, 1, 2, 3
#define	GEN_PQR_C		4, 5, 6, 7

#define	SYN_Q_DEFINE()		{}
#define	SYN_Q_D			0, 1, 2, 3
#define	SYN_Q_X			4, 5, 6, 7

#define	SYN_R_DEFINE()		{}
#define	SYN_R_D			0, 1, 2, 3
#define	SYN_R_X			4, 5, 6, 7

#define	SYN_PQ_DEFINE() 	{}
#define	SYN_PQ_D		0, 1, 2, 3
#define	SYN_PQ_X		4, 5, 6, 7

#define	REC_PQ_STRIDE		2
#define	REC_PQ_DEFINE() 	{}
#define	REC_PQ_X		0, 1
#define	REC_PQ_Y		2, 3
#define	REC_PQ_T		4, 5

#define	SYN_PR_DEFINE() 	{}
#define	SYN_PR_D		0, 1, 2, 3
#define	SYN_PR_X		4, 5, 6, 7

#define	REC_PR_STRIDE		2
#define	REC_PR_DEFINE() 	{}
#define	REC_PR_X		0, 1
#define	REC_PR_Y		2, 3
#define	REC_PR_T		4, 5

#define	SYN_QR_DEFINE() 	{}
#define	SYN_QR_D		0, 1, 2, 3
#define	SYN_QR_X		4, 5, 6, 7

#define	REC_QR_STRIDE		2
#define	REC_QR_DEFINE() 	{}
#define	REC_QR_X		0, 1
#define	REC_QR_Y		2, 3
#define	REC_QR_T		4, 5

#define	SYN_PQR_DEFINE() 	{}
#define	SYN_PQR_D		0, 1, 2, 3
#define	SYN_PQR_X		4, 5, 6, 7

#define	REC_PQR_STRIDE		2
#define	REC_PQR_DEFINE() 	{}
#define	REC_PQR_X		0, 1
#define	REC_PQR_Y		2, 3
#define	REC_PQR_Z		4, 5
#define	REC_PQR_XS		6, 7
#define	REC_PQR_YS		8, 9


#include <sys/vdev_raidz_impl.h>
#include "vdev_raidz_math_impl.h"

DEFINE_GEN_METHODS(ssse3);
DEFINE_REC_METHODS(ssse3);

static boolean_t
raidz_will_ssse3_work(void)
{
	return (kfpu_allowed() && zfs_sse_available() &&
	    zfs_sse2_available() && zfs_ssse3_available());
}

const raidz_impl_ops_t vdev_raidz_ssse3_impl = {
	.init = NULL,
	.fini = NULL,
	.gen = RAIDZ_GEN_METHODS(ssse3),
	.rec = RAIDZ_REC_METHODS(ssse3),
	.is_supported = &raidz_will_ssse3_work,
	.name = "ssse3"
};

#endif /* defined(__x86_64) && defined(HAVE_SSSE3) */


#if defined(__x86_64)
#if defined(HAVE_SSSE3) || defined(HAVE_AVX2) || defined(HAVE_AVX512BW)
/* BEGIN CSTYLED */
const uint8_t
__attribute__((aligned(256))) gf_clmul_mod_lt[4*256][16] =
{
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70,
	    0x80, 0x90, 0xa0, 0xb0, 0xc0, 0xd0, 0xe0, 0xf0  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	    0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{ 0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0,
	    0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x02, 0x04, 0x06, 0x08, 0x0a, 0x0c, 0x0e,
	    0x10, 0x12, 0x14, 0x16, 0x18, 0x1a, 0x1c, 0x1e  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{ 0x00, 0x30, 0x60, 0x50, 0xc0, 0xf0, 0xa0, 0x90,
	    0x80, 0xb0, 0xe0, 0xd0, 0x40, 0x70, 0x20, 0x10  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x03, 0x06, 0x05, 0x0c, 0x0f, 0x0a, 0x09,
	    0x18, 0x1b, 0x1e, 0x1d, 0x14, 0x17, 0x12, 0x11  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{ 0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0,
	    0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x04, 0x08, 0x0c, 0x10, 0x14, 0x18, 0x1c,
	    0x20, 0x24, 0x28, 0x2c, 0x30, 0x34, 0x38, 0x3c  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{ 0x00, 0x50, 0xa0, 0xf0, 0x40, 0x10, 0xe0, 0xb0,
	    0x80, 0xd0, 0x20, 0x70, 0xc0, 0x90, 0x60, 0x30  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x05, 0x0a, 0x0f, 0x14, 0x11, 0x1e, 0x1b,
	    0x28, 0x2d, 0x22, 0x27, 0x3c, 0x39, 0x36, 0x33  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{ 0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20,
	    0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x06, 0x0c, 0x0a, 0x18, 0x1e, 0x14, 0x12,
	    0x30, 0x36, 0x3c, 0x3a, 0x28, 0x2e, 0x24, 0x22  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{ 0x00, 0x70, 0xe0, 0x90, 0xc0, 0xb0, 0x20, 0x50,
	    0x80, 0xf0, 0x60, 0x10, 0x40, 0x30, 0xa0, 0xd0  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x07, 0x0e, 0x09, 0x1c, 0x1b, 0x12, 0x15,
	    0x38, 0x3f, 0x36, 0x31, 0x24, 0x23, 0x2a, 0x2d  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{ 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80,
	    0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x08, 0x10, 0x18, 0x20, 0x28, 0x30, 0x38,
	    0x40, 0x48, 0x50, 0x58, 0x60, 0x68, 0x70, 0x78  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{ 0x00, 0x90, 0x20, 0xb0, 0x40, 0xd0, 0x60, 0xf0,
	    0x80, 0x10, 0xa0, 0x30, 0xc0, 0x50, 0xe0, 0x70  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x09, 0x12, 0x1b, 0x24, 0x2d, 0x36, 0x3f,
	    0x48, 0x41, 0x5a, 0x53, 0x6c, 0x65, 0x7e, 0x77  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{ 0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60,
	    0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x0a, 0x14, 0x1e, 0x28, 0x22, 0x3c, 0x36,
	    0x50, 0x5a, 0x44, 0x4e, 0x78, 0x72, 0x6c, 0x66  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{ 0x00, 0xb0, 0x60, 0xd0, 0xc0, 0x70, 0xa0, 0x10,
	    0x80, 0x30, 0xe0, 0x50, 0x40, 0xf0, 0x20, 0x90  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x0b, 0x16, 0x1d, 0x2c, 0x27, 0x3a, 0x31,
	    0x58, 0x53, 0x4e, 0x45, 0x74, 0x7f, 0x62, 0x69  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{ 0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40,
	    0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x0c, 0x18, 0x14, 0x30, 0x3c, 0x28, 0x24,
	    0x60, 0x6c, 0x78, 0x74, 0x50, 0x5c, 0x48, 0x44  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{ 0x00, 0xd0, 0xa0, 0x70, 0x40, 0x90, 0xe0, 0x30,
	    0x80, 0x50, 0x20, 0xf0, 0xc0, 0x10, 0x60, 0xb0  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x0d, 0x1a, 0x17, 0x34, 0x39, 0x2e, 0x23,
	    0x68, 0x65, 0x72, 0x7f, 0x5c, 0x51, 0x46, 0x4b  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{ 0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0,
	    0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x0e, 0x1c, 0x12, 0x38, 0x36, 0x24, 0x2a,
	    0x70, 0x7e, 0x6c, 0x62, 0x48, 0x46, 0x54, 0x5a  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{ 0x00, 0xf0, 0xe0, 0x10, 0xc0, 0x30, 0x20, 0xd0,
	    0x80, 0x70, 0x60, 0x90, 0x40, 0xb0, 0xa0, 0x50  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x0f, 0x1e, 0x11, 0x3c, 0x33, 0x22, 0x2d,
	    0x78, 0x77, 0x66, 0x69, 0x44, 0x4b, 0x5a, 0x55  },
	{ 0x00, 0x1d, 0x3a, 0x27, 0x74, 0x69, 0x4e, 0x53,
	    0xe8, 0xf5, 0xd2, 0xcf, 0x9c, 0x81, 0xa6, 0xbb  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70,
	    0x80, 0x90, 0xa0, 0xb0, 0xc0, 0xd0, 0xe0, 0xf0  },
	{ 0x00, 0x1d, 0x3a, 0x27, 0x74, 0x69, 0x4e, 0x53,
	    0xe8, 0xf5, 0xd2, 0xcf, 0x9c, 0x81, 0xa6, 0xbb  },
	{ 0x00, 0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70,
	    0x80, 0x90, 0xa0, 0xb0, 0xc0, 0xd0, 0xe0, 0xf0  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77,
	    0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff  },
	{ 0x00, 0x1d, 0x3a, 0x27, 0x74, 0x69, 0x4e, 0x53,
	    0xf5, 0xe8, 0xcf, 0xd2, 0x81, 0x9c, 0xbb, 0xa6  },
	{ 0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0,
	    0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x12, 0x24, 0x36, 0x48, 0x5a, 0x6c, 0x7e,
	    0x90, 0x82, 0xb4, 0xa6, 0xd8, 0xca, 0xfc, 0xee  },
	{ 0x00, 0x1d, 0x3a, 0x27, 0x74, 0x69, 0x4e, 0x53,
	    0xf5, 0xe8, 0xcf, 0xd2, 0x81, 0x9c, 0xbb, 0xa6  },
	{ 0x00, 0x30, 0x60, 0x50, 0xc0, 0xf0, 0xa0, 0x90,
	    0x80, 0xb0, 0xe0, 0xd0, 0x40, 0x70, 0x20, 0x10  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x13, 0x26, 0x35, 0x4c, 0x5f, 0x6a, 0x79,
	    0x98, 0x8b, 0xbe, 0xad, 0xd4, 0xc7, 0xf2, 0xe1  },
	{ 0x00, 0x1d, 0x3a, 0x27, 0x69, 0x74, 0x53, 0x4e,
	    0xd2, 0xcf, 0xe8, 0xf5, 0xbb, 0xa6, 0x81, 0x9c  },
	{ 0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0,
	    0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x14, 0x28, 0x3c, 0x50, 0x44, 0x78, 0x6c,
	    0xa0, 0xb4, 0x88, 0x9c, 0xf0, 0xe4, 0xd8, 0xcc  },
	{ 0x00, 0x1d, 0x3a, 0x27, 0x69, 0x74, 0x53, 0x4e,
	    0xd2, 0xcf, 0xe8, 0xf5, 0xbb, 0xa6, 0x81, 0x9c  },
	{ 0x00, 0x50, 0xa0, 0xf0, 0x40, 0x10, 0xe0, 0xb0,
	    0x80, 0xd0, 0x20, 0x70, 0xc0, 0x90, 0x60, 0x30  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x15, 0x2a, 0x3f, 0x54, 0x41, 0x7e, 0x6b,
	    0xa8, 0xbd, 0x82, 0x97, 0xfc, 0xe9, 0xd6, 0xc3  },
	{ 0x00, 0x1d, 0x3a, 0x27, 0x69, 0x74, 0x53, 0x4e,
	    0xcf, 0xd2, 0xf5, 0xe8, 0xa6, 0xbb, 0x9c, 0x81  },
	{ 0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20,
	    0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x16, 0x2c, 0x3a, 0x58, 0x4e, 0x74, 0x62,
	    0xb0, 0xa6, 0x9c, 0x8a, 0xe8, 0xfe, 0xc4, 0xd2  },
	{ 0x00, 0x1d, 0x3a, 0x27, 0x69, 0x74, 0x53, 0x4e,
	    0xcf, 0xd2, 0xf5, 0xe8, 0xa6, 0xbb, 0x9c, 0x81  },
	{ 0x00, 0x70, 0xe0, 0x90, 0xc0, 0xb0, 0x20, 0x50,
	    0x80, 0xf0, 0x60, 0x10, 0x40, 0x30, 0xa0, 0xd0  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x17, 0x2e, 0x39, 0x5c, 0x4b, 0x72, 0x65,
	    0xb8, 0xaf, 0x96, 0x81, 0xe4, 0xf3, 0xca, 0xdd  },
	{ 0x00, 0x1d, 0x27, 0x3a, 0x4e, 0x53, 0x69, 0x74,
	    0x9c, 0x81, 0xbb, 0xa6, 0xd2, 0xcf, 0xf5, 0xe8  },
	{ 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80,
	    0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x18, 0x30, 0x28, 0x60, 0x78, 0x50, 0x48,
	    0xc0, 0xd8, 0xf0, 0xe8, 0xa0, 0xb8, 0x90, 0x88  },
	{ 0x00, 0x1d, 0x27, 0x3a, 0x4e, 0x53, 0x69, 0x74,
	    0x9c, 0x81, 0xbb, 0xa6, 0xd2, 0xcf, 0xf5, 0xe8  },
	{ 0x00, 0x90, 0x20, 0xb0, 0x40, 0xd0, 0x60, 0xf0,
	    0x80, 0x10, 0xa0, 0x30, 0xc0, 0x50, 0xe0, 0x70  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x19, 0x32, 0x2b, 0x64, 0x7d, 0x56, 0x4f,
	    0xc8, 0xd1, 0xfa, 0xe3, 0xac, 0xb5, 0x9e, 0x87  },
	{ 0x00, 0x1d, 0x27, 0x3a, 0x4e, 0x53, 0x69, 0x74,
	    0x81, 0x9c, 0xa6, 0xbb, 0xcf, 0xd2, 0xe8, 0xf5  },
	{ 0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60,
	    0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x1a, 0x34, 0x2e, 0x68, 0x72, 0x5c, 0x46,
	    0xd0, 0xca, 0xe4, 0xfe, 0xb8, 0xa2, 0x8c, 0x96  },
	{ 0x00, 0x1d, 0x27, 0x3a, 0x4e, 0x53, 0x69, 0x74,
	    0x81, 0x9c, 0xa6, 0xbb, 0xcf, 0xd2, 0xe8, 0xf5  },
	{ 0x00, 0xb0, 0x60, 0xd0, 0xc0, 0x70, 0xa0, 0x10,
	    0x80, 0x30, 0xe0, 0x50, 0x40, 0xf0, 0x20, 0x90  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x1b, 0x36, 0x2d, 0x6c, 0x77, 0x5a, 0x41,
	    0xd8, 0xc3, 0xee, 0xf5, 0xb4, 0xaf, 0x82, 0x99  },
	{ 0x00, 0x1d, 0x27, 0x3a, 0x53, 0x4e, 0x74, 0x69,
	    0xa6, 0xbb, 0x81, 0x9c, 0xf5, 0xe8, 0xd2, 0xcf  },
	{ 0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40,
	    0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x1c, 0x38, 0x24, 0x70, 0x6c, 0x48, 0x54,
	    0xe0, 0xfc, 0xd8, 0xc4, 0x90, 0x8c, 0xa8, 0xb4  },
	{ 0x00, 0x1d, 0x27, 0x3a, 0x53, 0x4e, 0x74, 0x69,
	    0xa6, 0xbb, 0x81, 0x9c, 0xf5, 0xe8, 0xd2, 0xcf  },
	{ 0x00, 0xd0, 0xa0, 0x70, 0x40, 0x90, 0xe0, 0x30,
	    0x80, 0x50, 0x20, 0xf0, 0xc0, 0x10, 0x60, 0xb0  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x1d, 0x3a, 0x27, 0x74, 0x69, 0x4e, 0x53,
	    0xe8, 0xf5, 0xd2, 0xcf, 0x9c, 0x81, 0xa6, 0xbb  },
	{ 0x00, 0x1d, 0x27, 0x3a, 0x53, 0x4e, 0x74, 0x69,
	    0xbb, 0xa6, 0x9c, 0x81, 0xe8, 0xf5, 0xcf, 0xd2  },
	{ 0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0,
	    0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x1e, 0x3c, 0x22, 0x78, 0x66, 0x44, 0x5a,
	    0xf0, 0xee, 0xcc, 0xd2, 0x88, 0x96, 0xb4, 0xaa  },
	{ 0x00, 0x1d, 0x27, 0x3a, 0x53, 0x4e, 0x74, 0x69,
	    0xbb, 0xa6, 0x9c, 0x81, 0xe8, 0xf5, 0xcf, 0xd2  },
	{ 0x00, 0xf0, 0xe0, 0x10, 0xc0, 0x30, 0x20, 0xd0,
	    0x80, 0x70, 0x60, 0x90, 0x40, 0xb0, 0xa0, 0x50  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x1f, 0x3e, 0x21, 0x7c, 0x63, 0x42, 0x5d,
	    0xf8, 0xe7, 0xc6, 0xd9, 0x84, 0x9b, 0xba, 0xa5  },
	{ 0x00, 0x3a, 0x74, 0x4e, 0xe8, 0xd2, 0x9c, 0xa6,
	    0xcd, 0xf7, 0xb9, 0x83, 0x25, 0x1f, 0x51, 0x6b  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{ 0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0,
	    0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0  },
	{ 0x00, 0x3a, 0x74, 0x4e, 0xe8, 0xd2, 0x9c, 0xa6,
	    0xcd, 0xf7, 0xb9, 0x83, 0x25, 0x1f, 0x51, 0x6b  },
	{ 0x00, 0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70,
	    0x80, 0x90, 0xa0, 0xb0, 0xc0, 0xd0, 0xe0, 0xf0  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{ 0x00, 0x21, 0x42, 0x63, 0x84, 0xa5, 0xc6, 0xe7,
	    0x08, 0x29, 0x4a, 0x6b, 0x8c, 0xad, 0xce, 0xef  },
	{ 0x00, 0x3a, 0x74, 0x4e, 0xe8, 0xd2, 0x9c, 0xa6,
	    0xd0, 0xea, 0xa4, 0x9e, 0x38, 0x02, 0x4c, 0x76  },
	{ 0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0,
	    0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{ 0x00, 0x22, 0x44, 0x66, 0x88, 0xaa, 0xcc, 0xee,
	    0x10, 0x32, 0x54, 0x76, 0x98, 0xba, 0xdc, 0xfe  },
	{ 0x00, 0x3a, 0x74, 0x4e, 0xe8, 0xd2, 0x9c, 0xa6,
	    0xd0, 0xea, 0xa4, 0x9e, 0x38, 0x02, 0x4c, 0x76  },
	{ 0x00, 0x30, 0x60, 0x50, 0xc0, 0xf0, 0xa0, 0x90,
	    0x80, 0xb0, 0xe0, 0xd0, 0x40, 0x70, 0x20, 0x10  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{ 0x00, 0x23, 0x46, 0x65, 0x8c, 0xaf, 0xca, 0xe9,
	    0x18, 0x3b, 0x5e, 0x7d, 0x94, 0xb7, 0xd2, 0xf1  },
	{ 0x00, 0x3a, 0x74, 0x4e, 0xf5, 0xcf, 0x81, 0xbb,
	    0xf7, 0xcd, 0x83, 0xb9, 0x02, 0x38, 0x76, 0x4c  },
	{ 0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0,
	    0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{ 0x00, 0x24, 0x48, 0x6c, 0x90, 0xb4, 0xd8, 0xfc,
	    0x20, 0x04, 0x68, 0x4c, 0xb0, 0x94, 0xf8, 0xdc  },
	{ 0x00, 0x3a, 0x74, 0x4e, 0xf5, 0xcf, 0x81, 0xbb,
	    0xf7, 0xcd, 0x83, 0xb9, 0x02, 0x38, 0x76, 0x4c  },
	{ 0x00, 0x50, 0xa0, 0xf0, 0x40, 0x10, 0xe0, 0xb0,
	    0x80, 0xd0, 0x20, 0x70, 0xc0, 0x90, 0x60, 0x30  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{ 0x00, 0x25, 0x4a, 0x6f, 0x94, 0xb1, 0xde, 0xfb,
	    0x28, 0x0d, 0x62, 0x47, 0xbc, 0x99, 0xf6, 0xd3  },
	{ 0x00, 0x3a, 0x74, 0x4e, 0xf5, 0xcf, 0x81, 0xbb,
	    0xea, 0xd0, 0x9e, 0xa4, 0x1f, 0x25, 0x6b, 0x51  },
	{ 0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20,
	    0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{ 0x00, 0x26, 0x4c, 0x6a, 0x98, 0xbe, 0xd4, 0xf2,
	    0x30, 0x16, 0x7c, 0x5a, 0xa8, 0x8e, 0xe4, 0xc2  },
	{ 0x00, 0x3a, 0x74, 0x4e, 0xf5, 0xcf, 0x81, 0xbb,
	    0xea, 0xd0, 0x9e, 0xa4, 0x1f, 0x25, 0x6b, 0x51  },
	{ 0x00, 0x70, 0xe0, 0x90, 0xc0, 0xb0, 0x20, 0x50,
	    0x80, 0xf0, 0x60, 0x10, 0x40, 0x30, 0xa0, 0xd0  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{ 0x00, 0x27, 0x4e, 0x69, 0x9c, 0xbb, 0xd2, 0xf5,
	    0x38, 0x1f, 0x76, 0x51, 0xa4, 0x83, 0xea, 0xcd  },
	{ 0x00, 0x3a, 0x69, 0x53, 0xd2, 0xe8, 0xbb, 0x81,
	    0xb9, 0x83, 0xd0, 0xea, 0x6b, 0x51, 0x02, 0x38  },
	{ 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80,
	    0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{ 0x00, 0x28, 0x50, 0x78, 0xa0, 0x88, 0xf0, 0xd8,
	    0x40, 0x68, 0x10, 0x38, 0xe0, 0xc8, 0xb0, 0x98  },
	{ 0x00, 0x3a, 0x69, 0x53, 0xd2, 0xe8, 0xbb, 0x81,
	    0xb9, 0x83, 0xd0, 0xea, 0x6b, 0x51, 0x02, 0x38  },
	{ 0x00, 0x90, 0x20, 0xb0, 0x40, 0xd0, 0x60, 0xf0,
	    0x80, 0x10, 0xa0, 0x30, 0xc0, 0x50, 0xe0, 0x70  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{ 0x00, 0x29, 0x52, 0x7b, 0xa4, 0x8d, 0xf6, 0xdf,
	    0x48, 0x61, 0x1a, 0x33, 0xec, 0xc5, 0xbe, 0x97  },
	{ 0x00, 0x3a, 0x69, 0x53, 0xd2, 0xe8, 0xbb, 0x81,
	    0xa4, 0x9e, 0xcd, 0xf7, 0x76, 0x4c, 0x1f, 0x25  },
	{ 0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60,
	    0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{ 0x00, 0x2a, 0x54, 0x7e, 0xa8, 0x82, 0xfc, 0xd6,
	    0x50, 0x7a, 0x04, 0x2e, 0xf8, 0xd2, 0xac, 0x86  },
	{ 0x00, 0x3a, 0x69, 0x53, 0xd2, 0xe8, 0xbb, 0x81,
	    0xa4, 0x9e, 0xcd, 0xf7, 0x76, 0x4c, 0x1f, 0x25  },
	{ 0x00, 0xb0, 0x60, 0xd0, 0xc0, 0x70, 0xa0, 0x10,
	    0x80, 0x30, 0xe0, 0x50, 0x40, 0xf0, 0x20, 0x90  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{ 0x00, 0x2b, 0x56, 0x7d, 0xac, 0x87, 0xfa, 0xd1,
	    0x58, 0x73, 0x0e, 0x25, 0xf4, 0xdf, 0xa2, 0x89  },
	{ 0x00, 0x3a, 0x69, 0x53, 0xcf, 0xf5, 0xa6, 0x9c,
	    0x83, 0xb9, 0xea, 0xd0, 0x4c, 0x76, 0x25, 0x1f  },
	{ 0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40,
	    0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{ 0x00, 0x2c, 0x58, 0x74, 0xb0, 0x9c, 0xe8, 0xc4,
	    0x60, 0x4c, 0x38, 0x14, 0xd0, 0xfc, 0x88, 0xa4  },
	{ 0x00, 0x3a, 0x69, 0x53, 0xcf, 0xf5, 0xa6, 0x9c,
	    0x83, 0xb9, 0xea, 0xd0, 0x4c, 0x76, 0x25, 0x1f  },
	{ 0x00, 0xd0, 0xa0, 0x70, 0x40, 0x90, 0xe0, 0x30,
	    0x80, 0x50, 0x20, 0xf0, 0xc0, 0x10, 0x60, 0xb0  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{ 0x00, 0x2d, 0x5a, 0x77, 0xb4, 0x99, 0xee, 0xc3,
	    0x68, 0x45, 0x32, 0x1f, 0xdc, 0xf1, 0x86, 0xab  },
	{ 0x00, 0x3a, 0x69, 0x53, 0xcf, 0xf5, 0xa6, 0x9c,
	    0x9e, 0xa4, 0xf7, 0xcd, 0x51, 0x6b, 0x38, 0x02  },
	{ 0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0,
	    0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{ 0x00, 0x2e, 0x5c, 0x72, 0xb8, 0x96, 0xe4, 0xca,
	    0x70, 0x5e, 0x2c, 0x02, 0xc8, 0xe6, 0x94, 0xba  },
	{ 0x00, 0x3a, 0x69, 0x53, 0xcf, 0xf5, 0xa6, 0x9c,
	    0x9e, 0xa4, 0xf7, 0xcd, 0x51, 0x6b, 0x38, 0x02  },
	{ 0x00, 0xf0, 0xe0, 0x10, 0xc0, 0x30, 0x20, 0xd0,
	    0x80, 0x70, 0x60, 0x90, 0x40, 0xb0, 0xa0, 0x50  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{ 0x00, 0x2f, 0x5e, 0x71, 0xbc, 0x93, 0xe2, 0xcd,
	    0x78, 0x57, 0x26, 0x09, 0xc4, 0xeb, 0x9a, 0xb5  },
	{ 0x00, 0x27, 0x4e, 0x69, 0x9c, 0xbb, 0xd2, 0xf5,
	    0x25, 0x02, 0x6b, 0x4c, 0xb9, 0x9e, 0xf7, 0xd0  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{ 0x00, 0x30, 0x60, 0x50, 0xc0, 0xf0, 0xa0, 0x90,
	    0x80, 0xb0, 0xe0, 0xd0, 0x40, 0x70, 0x20, 0x10  },
	{ 0x00, 0x27, 0x4e, 0x69, 0x9c, 0xbb, 0xd2, 0xf5,
	    0x25, 0x02, 0x6b, 0x4c, 0xb9, 0x9e, 0xf7, 0xd0  },
	{ 0x00, 0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70,
	    0x80, 0x90, 0xa0, 0xb0, 0xc0, 0xd0, 0xe0, 0xf0  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{ 0x00, 0x31, 0x62, 0x53, 0xc4, 0xf5, 0xa6, 0x97,
	    0x88, 0xb9, 0xea, 0xdb, 0x4c, 0x7d, 0x2e, 0x1f  },
	{ 0x00, 0x27, 0x4e, 0x69, 0x9c, 0xbb, 0xd2, 0xf5,
	    0x38, 0x1f, 0x76, 0x51, 0xa4, 0x83, 0xea, 0xcd  },
	{ 0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0,
	    0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{ 0x00, 0x32, 0x64, 0x56, 0xc8, 0xfa, 0xac, 0x9e,
	    0x90, 0xa2, 0xf4, 0xc6, 0x58, 0x6a, 0x3c, 0x0e  },
	{ 0x00, 0x27, 0x4e, 0x69, 0x9c, 0xbb, 0xd2, 0xf5,
	    0x38, 0x1f, 0x76, 0x51, 0xa4, 0x83, 0xea, 0xcd  },
	{ 0x00, 0x30, 0x60, 0x50, 0xc0, 0xf0, 0xa0, 0x90,
	    0x80, 0xb0, 0xe0, 0xd0, 0x40, 0x70, 0x20, 0x10  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{ 0x00, 0x33, 0x66, 0x55, 0xcc, 0xff, 0xaa, 0x99,
	    0x98, 0xab, 0xfe, 0xcd, 0x54, 0x67, 0x32, 0x01  },
	{ 0x00, 0x27, 0x4e, 0x69, 0x81, 0xa6, 0xcf, 0xe8,
	    0x1f, 0x38, 0x51, 0x76, 0x9e, 0xb9, 0xd0, 0xf7  },
	{ 0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0,
	    0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{ 0x00, 0x34, 0x68, 0x5c, 0xd0, 0xe4, 0xb8, 0x8c,
	    0xa0, 0x94, 0xc8, 0xfc, 0x70, 0x44, 0x18, 0x2c  },
	{ 0x00, 0x27, 0x4e, 0x69, 0x81, 0xa6, 0xcf, 0xe8,
	    0x1f, 0x38, 0x51, 0x76, 0x9e, 0xb9, 0xd0, 0xf7  },
	{ 0x00, 0x50, 0xa0, 0xf0, 0x40, 0x10, 0xe0, 0xb0,
	    0x80, 0xd0, 0x20, 0x70, 0xc0, 0x90, 0x60, 0x30  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{ 0x00, 0x35, 0x6a, 0x5f, 0xd4, 0xe1, 0xbe, 0x8b,
	    0xa8, 0x9d, 0xc2, 0xf7, 0x7c, 0x49, 0x16, 0x23  },
	{ 0x00, 0x27, 0x4e, 0x69, 0x81, 0xa6, 0xcf, 0xe8,
	    0x02, 0x25, 0x4c, 0x6b, 0x83, 0xa4, 0xcd, 0xea  },
	{ 0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20,
	    0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{ 0x00, 0x36, 0x6c, 0x5a, 0xd8, 0xee, 0xb4, 0x82,
	    0xb0, 0x86, 0xdc, 0xea, 0x68, 0x5e, 0x04, 0x32  },
	{ 0x00, 0x27, 0x4e, 0x69, 0x81, 0xa6, 0xcf, 0xe8,
	    0x02, 0x25, 0x4c, 0x6b, 0x83, 0xa4, 0xcd, 0xea  },
	{ 0x00, 0x70, 0xe0, 0x90, 0xc0, 0xb0, 0x20, 0x50,
	    0x80, 0xf0, 0x60, 0x10, 0x40, 0x30, 0xa0, 0xd0  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{ 0x00, 0x37, 0x6e, 0x59, 0xdc, 0xeb, 0xb2, 0x85,
	    0xb8, 0x8f, 0xd6, 0xe1, 0x64, 0x53, 0x0a, 0x3d  },
	{ 0x00, 0x27, 0x53, 0x74, 0xa6, 0x81, 0xf5, 0xd2,
	    0x51, 0x76, 0x02, 0x25, 0xf7, 0xd0, 0xa4, 0x83  },
	{ 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80,
	    0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{ 0x00, 0x38, 0x70, 0x48, 0xe0, 0xd8, 0x90, 0xa8,
	    0xc0, 0xf8, 0xb0, 0x88, 0x20, 0x18, 0x50, 0x68  },
	{ 0x00, 0x27, 0x53, 0x74, 0xa6, 0x81, 0xf5, 0xd2,
	    0x51, 0x76, 0x02, 0x25, 0xf7, 0xd0, 0xa4, 0x83  },
	{ 0x00, 0x90, 0x20, 0xb0, 0x40, 0xd0, 0x60, 0xf0,
	    0x80, 0x10, 0xa0, 0x30, 0xc0, 0x50, 0xe0, 0x70  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{ 0x00, 0x39, 0x72, 0x4b, 0xe4, 0xdd, 0x96, 0xaf,
	    0xc8, 0xf1, 0xba, 0x83, 0x2c, 0x15, 0x5e, 0x67  },
	{ 0x00, 0x27, 0x53, 0x74, 0xa6, 0x81, 0xf5, 0xd2,
	    0x4c, 0x6b, 0x1f, 0x38, 0xea, 0xcd, 0xb9, 0x9e  },
	{ 0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60,
	    0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{ 0x00, 0x3a, 0x74, 0x4e, 0xe8, 0xd2, 0x9c, 0xa6,
	    0xd0, 0xea, 0xa4, 0x9e, 0x38, 0x02, 0x4c, 0x76  },
	{ 0x00, 0x27, 0x53, 0x74, 0xa6, 0x81, 0xf5, 0xd2,
	    0x4c, 0x6b, 0x1f, 0x38, 0xea, 0xcd, 0xb9, 0x9e  },
	{ 0x00, 0xb0, 0x60, 0xd0, 0xc0, 0x70, 0xa0, 0x10,
	    0x80, 0x30, 0xe0, 0x50, 0x40, 0xf0, 0x20, 0x90  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{ 0x00, 0x3b, 0x76, 0x4d, 0xec, 0xd7, 0x9a, 0xa1,
	    0xd8, 0xe3, 0xae, 0x95, 0x34, 0x0f, 0x42, 0x79  },
	{ 0x00, 0x27, 0x53, 0x74, 0xbb, 0x9c, 0xe8, 0xcf,
	    0x6b, 0x4c, 0x38, 0x1f, 0xd0, 0xf7, 0x83, 0xa4  },
	{ 0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40,
	    0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{ 0x00, 0x3c, 0x78, 0x44, 0xf0, 0xcc, 0x88, 0xb4,
	    0xe0, 0xdc, 0x98, 0xa4, 0x10, 0x2c, 0x68, 0x54  },
	{ 0x00, 0x27, 0x53, 0x74, 0xbb, 0x9c, 0xe8, 0xcf,
	    0x6b, 0x4c, 0x38, 0x1f, 0xd0, 0xf7, 0x83, 0xa4  },
	{ 0x00, 0xd0, 0xa0, 0x70, 0x40, 0x90, 0xe0, 0x30,
	    0x80, 0x50, 0x20, 0xf0, 0xc0, 0x10, 0x60, 0xb0  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{ 0x00, 0x3d, 0x7a, 0x47, 0xf4, 0xc9, 0x8e, 0xb3,
	    0xe8, 0xd5, 0x92, 0xaf, 0x1c, 0x21, 0x66, 0x5b  },
	{ 0x00, 0x27, 0x53, 0x74, 0xbb, 0x9c, 0xe8, 0xcf,
	    0x76, 0x51, 0x25, 0x02, 0xcd, 0xea, 0x9e, 0xb9  },
	{ 0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0,
	    0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{ 0x00, 0x3e, 0x7c, 0x42, 0xf8, 0xc6, 0x84, 0xba,
	    0xf0, 0xce, 0x8c, 0xb2, 0x08, 0x36, 0x74, 0x4a  },
	{ 0x00, 0x27, 0x53, 0x74, 0xbb, 0x9c, 0xe8, 0xcf,
	    0x76, 0x51, 0x25, 0x02, 0xcd, 0xea, 0x9e, 0xb9  },
	{ 0x00, 0xf0, 0xe0, 0x10, 0xc0, 0x30, 0x20, 0xd0,
	    0x80, 0x70, 0x60, 0x90, 0x40, 0xb0, 0xa0, 0x50  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{ 0x00, 0x3f, 0x7e, 0x41, 0xfc, 0xc3, 0x82, 0xbd,
	    0xf8, 0xc7, 0x86, 0xb9, 0x04, 0x3b, 0x7a, 0x45  },
	{ 0x00, 0x74, 0xe8, 0x9c, 0xcd, 0xb9, 0x25, 0x51,
	    0x87, 0xf3, 0x6f, 0x1b, 0x4a, 0x3e, 0xa2, 0xd6  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{ 0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0,
	    0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0  },
	{ 0x00, 0x74, 0xe8, 0x9c, 0xcd, 0xb9, 0x25, 0x51,
	    0x87, 0xf3, 0x6f, 0x1b, 0x4a, 0x3e, 0xa2, 0xd6  },
	{ 0x00, 0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70,
	    0x80, 0x90, 0xa0, 0xb0, 0xc0, 0xd0, 0xe0, 0xf0  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{ 0x00, 0x41, 0x82, 0xc3, 0x04, 0x45, 0x86, 0xc7,
	    0x08, 0x49, 0x8a, 0xcb, 0x0c, 0x4d, 0x8e, 0xcf  },
	{ 0x00, 0x74, 0xe8, 0x9c, 0xcd, 0xb9, 0x25, 0x51,
	    0x9a, 0xee, 0x72, 0x06, 0x57, 0x23, 0xbf, 0xcb  },
	{ 0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0,
	    0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{ 0x00, 0x42, 0x84, 0xc6, 0x08, 0x4a, 0x8c, 0xce,
	    0x10, 0x52, 0x94, 0xd6, 0x18, 0x5a, 0x9c, 0xde  },
	{ 0x00, 0x74, 0xe8, 0x9c, 0xcd, 0xb9, 0x25, 0x51,
	    0x9a, 0xee, 0x72, 0x06, 0x57, 0x23, 0xbf, 0xcb  },
	{ 0x00, 0x30, 0x60, 0x50, 0xc0, 0xf0, 0xa0, 0x90,
	    0x80, 0xb0, 0xe0, 0xd0, 0x40, 0x70, 0x20, 0x10  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{ 0x00, 0x43, 0x86, 0xc5, 0x0c, 0x4f, 0x8a, 0xc9,
	    0x18, 0x5b, 0x9e, 0xdd, 0x14, 0x57, 0x92, 0xd1  },
	{ 0x00, 0x74, 0xe8, 0x9c, 0xd0, 0xa4, 0x38, 0x4c,
	    0xbd, 0xc9, 0x55, 0x21, 0x6d, 0x19, 0x85, 0xf1  },
	{ 0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0,
	    0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{ 0x00, 0x44, 0x88, 0xcc, 0x10, 0x54, 0x98, 0xdc,
	    0x20, 0x64, 0xa8, 0xec, 0x30, 0x74, 0xb8, 0xfc  },
	{ 0x00, 0x74, 0xe8, 0x9c, 0xd0, 0xa4, 0x38, 0x4c,
	    0xbd, 0xc9, 0x55, 0x21, 0x6d, 0x19, 0x85, 0xf1  },
	{ 0x00, 0x50, 0xa0, 0xf0, 0x40, 0x10, 0xe0, 0xb0,
	    0x80, 0xd0, 0x20, 0x70, 0xc0, 0x90, 0x60, 0x30  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{ 0x00, 0x45, 0x8a, 0xcf, 0x14, 0x51, 0x9e, 0xdb,
	    0x28, 0x6d, 0xa2, 0xe7, 0x3c, 0x79, 0xb6, 0xf3  },
	{ 0x00, 0x74, 0xe8, 0x9c, 0xd0, 0xa4, 0x38, 0x4c,
	    0xa0, 0xd4, 0x48, 0x3c, 0x70, 0x04, 0x98, 0xec  },
	{ 0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20,
	    0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{ 0x00, 0x46, 0x8c, 0xca, 0x18, 0x5e, 0x94, 0xd2,
	    0x30, 0x76, 0xbc, 0xfa, 0x28, 0x6e, 0xa4, 0xe2  },
	{ 0x00, 0x74, 0xe8, 0x9c, 0xd0, 0xa4, 0x38, 0x4c,
	    0xa0, 0xd4, 0x48, 0x3c, 0x70, 0x04, 0x98, 0xec  },
	{ 0x00, 0x70, 0xe0, 0x90, 0xc0, 0xb0, 0x20, 0x50,
	    0x80, 0xf0, 0x60, 0x10, 0x40, 0x30, 0xa0, 0xd0  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{ 0x00, 0x47, 0x8e, 0xc9, 0x1c, 0x5b, 0x92, 0xd5,
	    0x38, 0x7f, 0xb6, 0xf1, 0x24, 0x63, 0xaa, 0xed  },
	{ 0x00, 0x74, 0xf5, 0x81, 0xf7, 0x83, 0x02, 0x76,
	    0xf3, 0x87, 0x06, 0x72, 0x04, 0x70, 0xf1, 0x85  },
	{ 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80,
	    0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{ 0x00, 0x48, 0x90, 0xd8, 0x20, 0x68, 0xb0, 0xf8,
	    0x40, 0x08, 0xd0, 0x98, 0x60, 0x28, 0xf0, 0xb8  },
	{ 0x00, 0x74, 0xf5, 0x81, 0xf7, 0x83, 0x02, 0x76,
	    0xf3, 0x87, 0x06, 0x72, 0x04, 0x70, 0xf1, 0x85  },
	{ 0x00, 0x90, 0x20, 0xb0, 0x40, 0xd0, 0x60, 0xf0,
	    0x80, 0x10, 0xa0, 0x30, 0xc0, 0x50, 0xe0, 0x70  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{ 0x00, 0x49, 0x92, 0xdb, 0x24, 0x6d, 0xb6, 0xff,
	    0x48, 0x01, 0xda, 0x93, 0x6c, 0x25, 0xfe, 0xb7  },
	{ 0x00, 0x74, 0xf5, 0x81, 0xf7, 0x83, 0x02, 0x76,
	    0xee, 0x9a, 0x1b, 0x6f, 0x19, 0x6d, 0xec, 0x98  },
	{ 0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60,
	    0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{ 0x00, 0x4a, 0x94, 0xde, 0x28, 0x62, 0xbc, 0xf6,
	    0x50, 0x1a, 0xc4, 0x8e, 0x78, 0x32, 0xec, 0xa6  },
	{ 0x00, 0x74, 0xf5, 0x81, 0xf7, 0x83, 0x02, 0x76,
	    0xee, 0x9a, 0x1b, 0x6f, 0x19, 0x6d, 0xec, 0x98  },
	{ 0x00, 0xb0, 0x60, 0xd0, 0xc0, 0x70, 0xa0, 0x10,
	    0x80, 0x30, 0xe0, 0x50, 0x40, 0xf0, 0x20, 0x90  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{ 0x00, 0x4b, 0x96, 0xdd, 0x2c, 0x67, 0xba, 0xf1,
	    0x58, 0x13, 0xce, 0x85, 0x74, 0x3f, 0xe2, 0xa9  },
	{ 0x00, 0x74, 0xf5, 0x81, 0xea, 0x9e, 0x1f, 0x6b,
	    0xc9, 0xbd, 0x3c, 0x48, 0x23, 0x57, 0xd6, 0xa2  },
	{ 0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40,
	    0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{ 0x00, 0x4c, 0x98, 0xd4, 0x30, 0x7c, 0xa8, 0xe4,
	    0x60, 0x2c, 0xf8, 0xb4, 0x50, 0x1c, 0xc8, 0x84  },
	{ 0x00, 0x74, 0xf5, 0x81, 0xea, 0x9e, 0x1f, 0x6b,
	    0xc9, 0xbd, 0x3c, 0x48, 0x23, 0x57, 0xd6, 0xa2  },
	{ 0x00, 0xd0, 0xa0, 0x70, 0x40, 0x90, 0xe0, 0x30,
	    0x80, 0x50, 0x20, 0xf0, 0xc0, 0x10, 0x60, 0xb0  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{ 0x00, 0x4d, 0x9a, 0xd7, 0x34, 0x79, 0xae, 0xe3,
	    0x68, 0x25, 0xf2, 0xbf, 0x5c, 0x11, 0xc6, 0x8b  },
	{ 0x00, 0x74, 0xf5, 0x81, 0xea, 0x9e, 0x1f, 0x6b,
	    0xd4, 0xa0, 0x21, 0x55, 0x3e, 0x4a, 0xcb, 0xbf  },
	{ 0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0,
	    0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{ 0x00, 0x4e, 0x9c, 0xd2, 0x38, 0x76, 0xa4, 0xea,
	    0x70, 0x3e, 0xec, 0xa2, 0x48, 0x06, 0xd4, 0x9a  },
	{ 0x00, 0x74, 0xf5, 0x81, 0xea, 0x9e, 0x1f, 0x6b,
	    0xd4, 0xa0, 0x21, 0x55, 0x3e, 0x4a, 0xcb, 0xbf  },
	{ 0x00, 0xf0, 0xe0, 0x10, 0xc0, 0x30, 0x20, 0xd0,
	    0x80, 0x70, 0x60, 0x90, 0x40, 0xb0, 0xa0, 0x50  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{ 0x00, 0x4f, 0x9e, 0xd1, 0x3c, 0x73, 0xa2, 0xed,
	    0x78, 0x37, 0xe6, 0xa9, 0x44, 0x0b, 0xda, 0x95  },
	{ 0x00, 0x69, 0xd2, 0xbb, 0xb9, 0xd0, 0x6b, 0x02,
	    0x6f, 0x06, 0xbd, 0xd4, 0xd6, 0xbf, 0x04, 0x6d  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{ 0x00, 0x50, 0xa0, 0xf0, 0x40, 0x10, 0xe0, 0xb0,
	    0x80, 0xd0, 0x20, 0x70, 0xc0, 0x90, 0x60, 0x30  },
	{ 0x00, 0x69, 0xd2, 0xbb, 0xb9, 0xd0, 0x6b, 0x02,
	    0x6f, 0x06, 0xbd, 0xd4, 0xd6, 0xbf, 0x04, 0x6d  },
	{ 0x00, 0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70,
	    0x80, 0x90, 0xa0, 0xb0, 0xc0, 0xd0, 0xe0, 0xf0  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{ 0x00, 0x51, 0xa2, 0xf3, 0x44, 0x15, 0xe6, 0xb7,
	    0x88, 0xd9, 0x2a, 0x7b, 0xcc, 0x9d, 0x6e, 0x3f  },
	{ 0x00, 0x69, 0xd2, 0xbb, 0xb9, 0xd0, 0x6b, 0x02,
	    0x72, 0x1b, 0xa0, 0xc9, 0xcb, 0xa2, 0x19, 0x70  },
	{ 0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0,
	    0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{ 0x00, 0x52, 0xa4, 0xf6, 0x48, 0x1a, 0xec, 0xbe,
	    0x90, 0xc2, 0x34, 0x66, 0xd8, 0x8a, 0x7c, 0x2e  },
	{ 0x00, 0x69, 0xd2, 0xbb, 0xb9, 0xd0, 0x6b, 0x02,
	    0x72, 0x1b, 0xa0, 0xc9, 0xcb, 0xa2, 0x19, 0x70  },
	{ 0x00, 0x30, 0x60, 0x50, 0xc0, 0xf0, 0xa0, 0x90,
	    0x80, 0xb0, 0xe0, 0xd0, 0x40, 0x70, 0x20, 0x10  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{ 0x00, 0x53, 0xa6, 0xf5, 0x4c, 0x1f, 0xea, 0xb9,
	    0x98, 0xcb, 0x3e, 0x6d, 0xd4, 0x87, 0x72, 0x21  },
	{ 0x00, 0x69, 0xd2, 0xbb, 0xa4, 0xcd, 0x76, 0x1f,
	    0x55, 0x3c, 0x87, 0xee, 0xf1, 0x98, 0x23, 0x4a  },
	{ 0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0,
	    0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{ 0x00, 0x54, 0xa8, 0xfc, 0x50, 0x04, 0xf8, 0xac,
	    0xa0, 0xf4, 0x08, 0x5c, 0xf0, 0xa4, 0x58, 0x0c  },
	{ 0x00, 0x69, 0xd2, 0xbb, 0xa4, 0xcd, 0x76, 0x1f,
	    0x55, 0x3c, 0x87, 0xee, 0xf1, 0x98, 0x23, 0x4a  },
	{ 0x00, 0x50, 0xa0, 0xf0, 0x40, 0x10, 0xe0, 0xb0,
	    0x80, 0xd0, 0x20, 0x70, 0xc0, 0x90, 0x60, 0x30  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{ 0x00, 0x55, 0xaa, 0xff, 0x54, 0x01, 0xfe, 0xab,
	    0xa8, 0xfd, 0x02, 0x57, 0xfc, 0xa9, 0x56, 0x03  },
	{ 0x00, 0x69, 0xd2, 0xbb, 0xa4, 0xcd, 0x76, 0x1f,
	    0x48, 0x21, 0x9a, 0xf3, 0xec, 0x85, 0x3e, 0x57  },
	{ 0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20,
	    0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{ 0x00, 0x56, 0xac, 0xfa, 0x58, 0x0e, 0xf4, 0xa2,
	    0xb0, 0xe6, 0x1c, 0x4a, 0xe8, 0xbe, 0x44, 0x12  },
	{ 0x00, 0x69, 0xd2, 0xbb, 0xa4, 0xcd, 0x76, 0x1f,
	    0x48, 0x21, 0x9a, 0xf3, 0xec, 0x85, 0x3e, 0x57  },
	{ 0x00, 0x70, 0xe0, 0x90, 0xc0, 0xb0, 0x20, 0x50,
	    0x80, 0xf0, 0x60, 0x10, 0x40, 0x30, 0xa0, 0xd0  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{ 0x00, 0x57, 0xae, 0xf9, 0x5c, 0x0b, 0xf2, 0xa5,
	    0xb8, 0xef, 0x16, 0x41, 0xe4, 0xb3, 0x4a, 0x1d  },
	{ 0x00, 0x69, 0xcf, 0xa6, 0x83, 0xea, 0x4c, 0x25,
	    0x1b, 0x72, 0xd4, 0xbd, 0x98, 0xf1, 0x57, 0x3e  },
	{ 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80,
	    0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{ 0x00, 0x58, 0xb0, 0xe8, 0x60, 0x38, 0xd0, 0x88,
	    0xc0, 0x98, 0x70, 0x28, 0xa0, 0xf8, 0x10, 0x48  },
	{ 0x00, 0x69, 0xcf, 0xa6, 0x83, 0xea, 0x4c, 0x25,
	    0x1b, 0x72, 0xd4, 0xbd, 0x98, 0xf1, 0x57, 0x3e  },
	{ 0x00, 0x90, 0x20, 0xb0, 0x40, 0xd0, 0x60, 0xf0,
	    0x80, 0x10, 0xa0, 0x30, 0xc0, 0x50, 0xe0, 0x70  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{ 0x00, 0x59, 0xb2, 0xeb, 0x64, 0x3d, 0xd6, 0x8f,
	    0xc8, 0x91, 0x7a, 0x23, 0xac, 0xf5, 0x1e, 0x47  },
	{ 0x00, 0x69, 0xcf, 0xa6, 0x83, 0xea, 0x4c, 0x25,
	    0x06, 0x6f, 0xc9, 0xa0, 0x85, 0xec, 0x4a, 0x23  },
	{ 0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60,
	    0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{ 0x00, 0x5a, 0xb4, 0xee, 0x68, 0x32, 0xdc, 0x86,
	    0xd0, 0x8a, 0x64, 0x3e, 0xb8, 0xe2, 0x0c, 0x56  },
	{ 0x00, 0x69, 0xcf, 0xa6, 0x83, 0xea, 0x4c, 0x25,
	    0x06, 0x6f, 0xc9, 0xa0, 0x85, 0xec, 0x4a, 0x23  },
	{ 0x00, 0xb0, 0x60, 0xd0, 0xc0, 0x70, 0xa0, 0x10,
	    0x80, 0x30, 0xe0, 0x50, 0x40, 0xf0, 0x20, 0x90  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{ 0x00, 0x5b, 0xb6, 0xed, 0x6c, 0x37, 0xda, 0x81,
	    0xd8, 0x83, 0x6e, 0x35, 0xb4, 0xef, 0x02, 0x59  },
	{ 0x00, 0x69, 0xcf, 0xa6, 0x9e, 0xf7, 0x51, 0x38,
	    0x21, 0x48, 0xee, 0x87, 0xbf, 0xd6, 0x70, 0x19  },
	{ 0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40,
	    0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{ 0x00, 0x5c, 0xb8, 0xe4, 0x70, 0x2c, 0xc8, 0x94,
	    0xe0, 0xbc, 0x58, 0x04, 0x90, 0xcc, 0x28, 0x74  },
	{ 0x00, 0x69, 0xcf, 0xa6, 0x9e, 0xf7, 0x51, 0x38,
	    0x21, 0x48, 0xee, 0x87, 0xbf, 0xd6, 0x70, 0x19  },
	{ 0x00, 0xd0, 0xa0, 0x70, 0x40, 0x90, 0xe0, 0x30,
	    0x80, 0x50, 0x20, 0xf0, 0xc0, 0x10, 0x60, 0xb0  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{ 0x00, 0x5d, 0xba, 0xe7, 0x74, 0x29, 0xce, 0x93,
	    0xe8, 0xb5, 0x52, 0x0f, 0x9c, 0xc1, 0x26, 0x7b  },
	{ 0x00, 0x69, 0xcf, 0xa6, 0x9e, 0xf7, 0x51, 0x38,
	    0x3c, 0x55, 0xf3, 0x9a, 0xa2, 0xcb, 0x6d, 0x04  },
	{ 0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0,
	    0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{ 0x00, 0x5e, 0xbc, 0xe2, 0x78, 0x26, 0xc4, 0x9a,
	    0xf0, 0xae, 0x4c, 0x12, 0x88, 0xd6, 0x34, 0x6a  },
	{ 0x00, 0x69, 0xcf, 0xa6, 0x9e, 0xf7, 0x51, 0x38,
	    0x3c, 0x55, 0xf3, 0x9a, 0xa2, 0xcb, 0x6d, 0x04  },
	{ 0x00, 0xf0, 0xe0, 0x10, 0xc0, 0x30, 0x20, 0xd0,
	    0x80, 0x70, 0x60, 0x90, 0x40, 0xb0, 0xa0, 0x50  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{ 0x00, 0x5f, 0xbe, 0xe1, 0x7c, 0x23, 0xc2, 0x9d,
	    0xf8, 0xa7, 0x46, 0x19, 0x84, 0xdb, 0x3a, 0x65  },
	{ 0x00, 0x4e, 0x9c, 0xd2, 0x25, 0x6b, 0xb9, 0xf7,
	    0x4a, 0x04, 0xd6, 0x98, 0x6f, 0x21, 0xf3, 0xbd  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{ 0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20,
	    0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20  },
	{ 0x00, 0x4e, 0x9c, 0xd2, 0x25, 0x6b, 0xb9, 0xf7,
	    0x4a, 0x04, 0xd6, 0x98, 0x6f, 0x21, 0xf3, 0xbd  },
	{ 0x00, 0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70,
	    0x80, 0x90, 0xa0, 0xb0, 0xc0, 0xd0, 0xe0, 0xf0  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{ 0x00, 0x61, 0xc2, 0xa3, 0x84, 0xe5, 0x46, 0x27,
	    0x08, 0x69, 0xca, 0xab, 0x8c, 0xed, 0x4e, 0x2f  },
	{ 0x00, 0x4e, 0x9c, 0xd2, 0x25, 0x6b, 0xb9, 0xf7,
	    0x57, 0x19, 0xcb, 0x85, 0x72, 0x3c, 0xee, 0xa0  },
	{ 0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0,
	    0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{ 0x00, 0x62, 0xc4, 0xa6, 0x88, 0xea, 0x4c, 0x2e,
	    0x10, 0x72, 0xd4, 0xb6, 0x98, 0xfa, 0x5c, 0x3e  },
	{ 0x00, 0x4e, 0x9c, 0xd2, 0x25, 0x6b, 0xb9, 0xf7,
	    0x57, 0x19, 0xcb, 0x85, 0x72, 0x3c, 0xee, 0xa0  },
	{ 0x00, 0x30, 0x60, 0x50, 0xc0, 0xf0, 0xa0, 0x90,
	    0x80, 0xb0, 0xe0, 0xd0, 0x40, 0x70, 0x20, 0x10  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{ 0x00, 0x63, 0xc6, 0xa5, 0x8c, 0xef, 0x4a, 0x29,
	    0x18, 0x7b, 0xde, 0xbd, 0x94, 0xf7, 0x52, 0x31  },
	{ 0x00, 0x4e, 0x9c, 0xd2, 0x38, 0x76, 0xa4, 0xea,
	    0x70, 0x3e, 0xec, 0xa2, 0x48, 0x06, 0xd4, 0x9a  },
	{ 0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0,
	    0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{ 0x00, 0x64, 0xc8, 0xac, 0x90, 0xf4, 0x58, 0x3c,
	    0x20, 0x44, 0xe8, 0x8c, 0xb0, 0xd4, 0x78, 0x1c  },
	{ 0x00, 0x4e, 0x9c, 0xd2, 0x38, 0x76, 0xa4, 0xea,
	    0x70, 0x3e, 0xec, 0xa2, 0x48, 0x06, 0xd4, 0x9a  },
	{ 0x00, 0x50, 0xa0, 0xf0, 0x40, 0x10, 0xe0, 0xb0,
	    0x80, 0xd0, 0x20, 0x70, 0xc0, 0x90, 0x60, 0x30  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{ 0x00, 0x65, 0xca, 0xaf, 0x94, 0xf1, 0x5e, 0x3b,
	    0x28, 0x4d, 0xe2, 0x87, 0xbc, 0xd9, 0x76, 0x13  },
	{ 0x00, 0x4e, 0x9c, 0xd2, 0x38, 0x76, 0xa4, 0xea,
	    0x6d, 0x23, 0xf1, 0xbf, 0x55, 0x1b, 0xc9, 0x87  },
	{ 0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20,
	    0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{ 0x00, 0x66, 0xcc, 0xaa, 0x98, 0xfe, 0x54, 0x32,
	    0x30, 0x56, 0xfc, 0x9a, 0xa8, 0xce, 0x64, 0x02  },
	{ 0x00, 0x4e, 0x9c, 0xd2, 0x38, 0x76, 0xa4, 0xea,
	    0x6d, 0x23, 0xf1, 0xbf, 0x55, 0x1b, 0xc9, 0x87  },
	{ 0x00, 0x70, 0xe0, 0x90, 0xc0, 0xb0, 0x20, 0x50,
	    0x80, 0xf0, 0x60, 0x10, 0x40, 0x30, 0xa0, 0xd0  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{ 0x00, 0x67, 0xce, 0xa9, 0x9c, 0xfb, 0x52, 0x35,
	    0x38, 0x5f, 0xf6, 0x91, 0xa4, 0xc3, 0x6a, 0x0d  },
	{ 0x00, 0x4e, 0x81, 0xcf, 0x1f, 0x51, 0x9e, 0xd0,
	    0x3e, 0x70, 0xbf, 0xf1, 0x21, 0x6f, 0xa0, 0xee  },
	{ 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80,
	    0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{ 0x00, 0x68, 0xd0, 0xb8, 0xa0, 0xc8, 0x70, 0x18,
	    0x40, 0x28, 0x90, 0xf8, 0xe0, 0x88, 0x30, 0x58  },
	{ 0x00, 0x4e, 0x81, 0xcf, 0x1f, 0x51, 0x9e, 0xd0,
	    0x3e, 0x70, 0xbf, 0xf1, 0x21, 0x6f, 0xa0, 0xee  },
	{ 0x00, 0x90, 0x20, 0xb0, 0x40, 0xd0, 0x60, 0xf0,
	    0x80, 0x10, 0xa0, 0x30, 0xc0, 0x50, 0xe0, 0x70  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{ 0x00, 0x69, 0xd2, 0xbb, 0xa4, 0xcd, 0x76, 0x1f,
	    0x48, 0x21, 0x9a, 0xf3, 0xec, 0x85, 0x3e, 0x57  },
	{ 0x00, 0x4e, 0x81, 0xcf, 0x1f, 0x51, 0x9e, 0xd0,
	    0x23, 0x6d, 0xa2, 0xec, 0x3c, 0x72, 0xbd, 0xf3  },
	{ 0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60,
	    0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{ 0x00, 0x6a, 0xd4, 0xbe, 0xa8, 0xc2, 0x7c, 0x16,
	    0x50, 0x3a, 0x84, 0xee, 0xf8, 0x92, 0x2c, 0x46  },
	{ 0x00, 0x4e, 0x81, 0xcf, 0x1f, 0x51, 0x9e, 0xd0,
	    0x23, 0x6d, 0xa2, 0xec, 0x3c, 0x72, 0xbd, 0xf3  },
	{ 0x00, 0xb0, 0x60, 0xd0, 0xc0, 0x70, 0xa0, 0x10,
	    0x80, 0x30, 0xe0, 0x50, 0x40, 0xf0, 0x20, 0x90  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{ 0x00, 0x6b, 0xd6, 0xbd, 0xac, 0xc7, 0x7a, 0x11,
	    0x58, 0x33, 0x8e, 0xe5, 0xf4, 0x9f, 0x22, 0x49  },
	{ 0x00, 0x4e, 0x81, 0xcf, 0x02, 0x4c, 0x83, 0xcd,
	    0x04, 0x4a, 0x85, 0xcb, 0x06, 0x48, 0x87, 0xc9  },
	{ 0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40,
	    0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{ 0x00, 0x6c, 0xd8, 0xb4, 0xb0, 0xdc, 0x68, 0x04,
	    0x60, 0x0c, 0xb8, 0xd4, 0xd0, 0xbc, 0x08, 0x64  },
	{ 0x00, 0x4e, 0x81, 0xcf, 0x02, 0x4c, 0x83, 0xcd,
	    0x04, 0x4a, 0x85, 0xcb, 0x06, 0x48, 0x87, 0xc9  },
	{ 0x00, 0xd0, 0xa0, 0x70, 0x40, 0x90, 0xe0, 0x30,
	    0x80, 0x50, 0x20, 0xf0, 0xc0, 0x10, 0x60, 0xb0  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{ 0x00, 0x6d, 0xda, 0xb7, 0xb4, 0xd9, 0x6e, 0x03,
	    0x68, 0x05, 0xb2, 0xdf, 0xdc, 0xb1, 0x06, 0x6b  },
	{ 0x00, 0x4e, 0x81, 0xcf, 0x02, 0x4c, 0x83, 0xcd,
	    0x19, 0x57, 0x98, 0xd6, 0x1b, 0x55, 0x9a, 0xd4  },
	{ 0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0,
	    0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{ 0x00, 0x6e, 0xdc, 0xb2, 0xb8, 0xd6, 0x64, 0x0a,
	    0x70, 0x1e, 0xac, 0xc2, 0xc8, 0xa6, 0x14, 0x7a  },
	{ 0x00, 0x4e, 0x81, 0xcf, 0x02, 0x4c, 0x83, 0xcd,
	    0x19, 0x57, 0x98, 0xd6, 0x1b, 0x55, 0x9a, 0xd4  },
	{ 0x00, 0xf0, 0xe0, 0x10, 0xc0, 0x30, 0x20, 0xd0,
	    0x80, 0x70, 0x60, 0x90, 0x40, 0xb0, 0xa0, 0x50  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{ 0x00, 0x6f, 0xde, 0xb1, 0xbc, 0xd3, 0x62, 0x0d,
	    0x78, 0x17, 0xa6, 0xc9, 0xc4, 0xab, 0x1a, 0x75  },
	{ 0x00, 0x53, 0xa6, 0xf5, 0x51, 0x02, 0xf7, 0xa4,
	    0xa2, 0xf1, 0x04, 0x57, 0xf3, 0xa0, 0x55, 0x06  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{ 0x00, 0x70, 0xe0, 0x90, 0xc0, 0xb0, 0x20, 0x50,
	    0x80, 0xf0, 0x60, 0x10, 0x40, 0x30, 0xa0, 0xd0  },
	{ 0x00, 0x53, 0xa6, 0xf5, 0x51, 0x02, 0xf7, 0xa4,
	    0xa2, 0xf1, 0x04, 0x57, 0xf3, 0xa0, 0x55, 0x06  },
	{ 0x00, 0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70,
	    0x80, 0x90, 0xa0, 0xb0, 0xc0, 0xd0, 0xe0, 0xf0  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{ 0x00, 0x71, 0xe2, 0x93, 0xc4, 0xb5, 0x26, 0x57,
	    0x88, 0xf9, 0x6a, 0x1b, 0x4c, 0x3d, 0xae, 0xdf  },
	{ 0x00, 0x53, 0xa6, 0xf5, 0x51, 0x02, 0xf7, 0xa4,
	    0xbf, 0xec, 0x19, 0x4a, 0xee, 0xbd, 0x48, 0x1b  },
	{ 0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0,
	    0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{ 0x00, 0x72, 0xe4, 0x96, 0xc8, 0xba, 0x2c, 0x5e,
	    0x90, 0xe2, 0x74, 0x06, 0x58, 0x2a, 0xbc, 0xce  },
	{ 0x00, 0x53, 0xa6, 0xf5, 0x51, 0x02, 0xf7, 0xa4,
	    0xbf, 0xec, 0x19, 0x4a, 0xee, 0xbd, 0x48, 0x1b  },
	{ 0x00, 0x30, 0x60, 0x50, 0xc0, 0xf0, 0xa0, 0x90,
	    0x80, 0xb0, 0xe0, 0xd0, 0x40, 0x70, 0x20, 0x10  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{ 0x00, 0x73, 0xe6, 0x95, 0xcc, 0xbf, 0x2a, 0x59,
	    0x98, 0xeb, 0x7e, 0x0d, 0x54, 0x27, 0xb2, 0xc1  },
	{ 0x00, 0x53, 0xa6, 0xf5, 0x4c, 0x1f, 0xea, 0xb9,
	    0x98, 0xcb, 0x3e, 0x6d, 0xd4, 0x87, 0x72, 0x21  },
	{ 0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0,
	    0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{ 0x00, 0x74, 0xe8, 0x9c, 0xd0, 0xa4, 0x38, 0x4c,
	    0xa0, 0xd4, 0x48, 0x3c, 0x70, 0x04, 0x98, 0xec  },
	{ 0x00, 0x53, 0xa6, 0xf5, 0x4c, 0x1f, 0xea, 0xb9,
	    0x98, 0xcb, 0x3e, 0x6d, 0xd4, 0x87, 0x72, 0x21  },
	{ 0x00, 0x50, 0xa0, 0xf0, 0x40, 0x10, 0xe0, 0xb0,
	    0x80, 0xd0, 0x20, 0x70, 0xc0, 0x90, 0x60, 0x30  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{ 0x00, 0x75, 0xea, 0x9f, 0xd4, 0xa1, 0x3e, 0x4b,
	    0xa8, 0xdd, 0x42, 0x37, 0x7c, 0x09, 0x96, 0xe3  },
	{ 0x00, 0x53, 0xa6, 0xf5, 0x4c, 0x1f, 0xea, 0xb9,
	    0x85, 0xd6, 0x23, 0x70, 0xc9, 0x9a, 0x6f, 0x3c  },
	{ 0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20,
	    0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{ 0x00, 0x76, 0xec, 0x9a, 0xd8, 0xae, 0x34, 0x42,
	    0xb0, 0xc6, 0x5c, 0x2a, 0x68, 0x1e, 0x84, 0xf2  },
	{ 0x00, 0x53, 0xa6, 0xf5, 0x4c, 0x1f, 0xea, 0xb9,
	    0x85, 0xd6, 0x23, 0x70, 0xc9, 0x9a, 0x6f, 0x3c  },
	{ 0x00, 0x70, 0xe0, 0x90, 0xc0, 0xb0, 0x20, 0x50,
	    0x80, 0xf0, 0x60, 0x10, 0x40, 0x30, 0xa0, 0xd0  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{ 0x00, 0x77, 0xee, 0x99, 0xdc, 0xab, 0x32, 0x45,
	    0xb8, 0xcf, 0x56, 0x21, 0x64, 0x13, 0x8a, 0xfd  },
	{ 0x00, 0x53, 0xbb, 0xe8, 0x6b, 0x38, 0xd0, 0x83,
	    0xd6, 0x85, 0x6d, 0x3e, 0xbd, 0xee, 0x06, 0x55  },
	{ 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80,
	    0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{ 0x00, 0x78, 0xf0, 0x88, 0xe0, 0x98, 0x10, 0x68,
	    0xc0, 0xb8, 0x30, 0x48, 0x20, 0x58, 0xd0, 0xa8  },
	{ 0x00, 0x53, 0xbb, 0xe8, 0x6b, 0x38, 0xd0, 0x83,
	    0xd6, 0x85, 0x6d, 0x3e, 0xbd, 0xee, 0x06, 0x55  },
	{ 0x00, 0x90, 0x20, 0xb0, 0x40, 0xd0, 0x60, 0xf0,
	    0x80, 0x10, 0xa0, 0x30, 0xc0, 0x50, 0xe0, 0x70  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{ 0x00, 0x79, 0xf2, 0x8b, 0xe4, 0x9d, 0x16, 0x6f,
	    0xc8, 0xb1, 0x3a, 0x43, 0x2c, 0x55, 0xde, 0xa7  },
	{ 0x00, 0x53, 0xbb, 0xe8, 0x6b, 0x38, 0xd0, 0x83,
	    0xcb, 0x98, 0x70, 0x23, 0xa0, 0xf3, 0x1b, 0x48  },
	{ 0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60,
	    0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{ 0x00, 0x7a, 0xf4, 0x8e, 0xe8, 0x92, 0x1c, 0x66,
	    0xd0, 0xaa, 0x24, 0x5e, 0x38, 0x42, 0xcc, 0xb6  },
	{ 0x00, 0x53, 0xbb, 0xe8, 0x6b, 0x38, 0xd0, 0x83,
	    0xcb, 0x98, 0x70, 0x23, 0xa0, 0xf3, 0x1b, 0x48  },
	{ 0x00, 0xb0, 0x60, 0xd0, 0xc0, 0x70, 0xa0, 0x10,
	    0x80, 0x30, 0xe0, 0x50, 0x40, 0xf0, 0x20, 0x90  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{ 0x00, 0x7b, 0xf6, 0x8d, 0xec, 0x97, 0x1a, 0x61,
	    0xd8, 0xa3, 0x2e, 0x55, 0x34, 0x4f, 0xc2, 0xb9  },
	{ 0x00, 0x53, 0xbb, 0xe8, 0x76, 0x25, 0xcd, 0x9e,
	    0xec, 0xbf, 0x57, 0x04, 0x9a, 0xc9, 0x21, 0x72  },
	{ 0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40,
	    0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{ 0x00, 0x7c, 0xf8, 0x84, 0xf0, 0x8c, 0x08, 0x74,
	    0xe0, 0x9c, 0x18, 0x64, 0x10, 0x6c, 0xe8, 0x94  },
	{ 0x00, 0x53, 0xbb, 0xe8, 0x76, 0x25, 0xcd, 0x9e,
	    0xec, 0xbf, 0x57, 0x04, 0x9a, 0xc9, 0x21, 0x72  },
	{ 0x00, 0xd0, 0xa0, 0x70, 0x40, 0x90, 0xe0, 0x30,
	    0x80, 0x50, 0x20, 0xf0, 0xc0, 0x10, 0x60, 0xb0  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{ 0x00, 0x7d, 0xfa, 0x87, 0xf4, 0x89, 0x0e, 0x73,
	    0xe8, 0x95, 0x12, 0x6f, 0x1c, 0x61, 0xe6, 0x9b  },
	{ 0x00, 0x53, 0xbb, 0xe8, 0x76, 0x25, 0xcd, 0x9e,
	    0xf1, 0xa2, 0x4a, 0x19, 0x87, 0xd4, 0x3c, 0x6f  },
	{ 0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0,
	    0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{ 0x00, 0x7e, 0xfc, 0x82, 0xf8, 0x86, 0x04, 0x7a,
	    0xf0, 0x8e, 0x0c, 0x72, 0x08, 0x76, 0xf4, 0x8a  },
	{ 0x00, 0x53, 0xbb, 0xe8, 0x76, 0x25, 0xcd, 0x9e,
	    0xf1, 0xa2, 0x4a, 0x19, 0x87, 0xd4, 0x3c, 0x6f  },
	{ 0x00, 0xf0, 0xe0, 0x10, 0xc0, 0x30, 0x20, 0xd0,
	    0x80, 0x70, 0x60, 0x90, 0x40, 0xb0, 0xa0, 0x50  },
	{ 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
	    0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{ 0x00, 0x7f, 0xfe, 0x81, 0xfc, 0x83, 0x02, 0x7d,
	    0xf8, 0x87, 0x06, 0x79, 0x04, 0x7b, 0xfa, 0x85  },
	{ 0x00, 0xe8, 0xcd, 0x25, 0x87, 0x6f, 0x4a, 0xa2,
	    0x13, 0xfb, 0xde, 0x36, 0x94, 0x7c, 0x59, 0xb1  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{ 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80,
	    0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80  },
	{ 0x00, 0xe8, 0xcd, 0x25, 0x87, 0x6f, 0x4a, 0xa2,
	    0x13, 0xfb, 0xde, 0x36, 0x94, 0x7c, 0x59, 0xb1  },
	{ 0x00, 0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70,
	    0x80, 0x90, 0xa0, 0xb0, 0xc0, 0xd0, 0xe0, 0xf0  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{ 0x00, 0x81, 0x02, 0x83, 0x04, 0x85, 0x06, 0x87,
	    0x08, 0x89, 0x0a, 0x8b, 0x0c, 0x8d, 0x0e, 0x8f  },
	{ 0x00, 0xe8, 0xcd, 0x25, 0x87, 0x6f, 0x4a, 0xa2,
	    0x0e, 0xe6, 0xc3, 0x2b, 0x89, 0x61, 0x44, 0xac  },
	{ 0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0,
	    0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{ 0x00, 0x82, 0x04, 0x86, 0x08, 0x8a, 0x0c, 0x8e,
	    0x10, 0x92, 0x14, 0x96, 0x18, 0x9a, 0x1c, 0x9e  },
	{ 0x00, 0xe8, 0xcd, 0x25, 0x87, 0x6f, 0x4a, 0xa2,
	    0x0e, 0xe6, 0xc3, 0x2b, 0x89, 0x61, 0x44, 0xac  },
	{ 0x00, 0x30, 0x60, 0x50, 0xc0, 0xf0, 0xa0, 0x90,
	    0x80, 0xb0, 0xe0, 0xd0, 0x40, 0x70, 0x20, 0x10  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{ 0x00, 0x83, 0x06, 0x85, 0x0c, 0x8f, 0x0a, 0x89,
	    0x18, 0x9b, 0x1e, 0x9d, 0x14, 0x97, 0x12, 0x91  },
	{ 0x00, 0xe8, 0xcd, 0x25, 0x9a, 0x72, 0x57, 0xbf,
	    0x29, 0xc1, 0xe4, 0x0c, 0xb3, 0x5b, 0x7e, 0x96  },
	{ 0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0,
	    0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{ 0x00, 0x84, 0x08, 0x8c, 0x10, 0x94, 0x18, 0x9c,
	    0x20, 0xa4, 0x28, 0xac, 0x30, 0xb4, 0x38, 0xbc  },
	{ 0x00, 0xe8, 0xcd, 0x25, 0x9a, 0x72, 0x57, 0xbf,
	    0x29, 0xc1, 0xe4, 0x0c, 0xb3, 0x5b, 0x7e, 0x96  },
	{ 0x00, 0x50, 0xa0, 0xf0, 0x40, 0x10, 0xe0, 0xb0,
	    0x80, 0xd0, 0x20, 0x70, 0xc0, 0x90, 0x60, 0x30  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{ 0x00, 0x85, 0x0a, 0x8f, 0x14, 0x91, 0x1e, 0x9b,
	    0x28, 0xad, 0x22, 0xa7, 0x3c, 0xb9, 0x36, 0xb3  },
	{ 0x00, 0xe8, 0xcd, 0x25, 0x9a, 0x72, 0x57, 0xbf,
	    0x34, 0xdc, 0xf9, 0x11, 0xae, 0x46, 0x63, 0x8b  },
	{ 0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20,
	    0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{ 0x00, 0x86, 0x0c, 0x8a, 0x18, 0x9e, 0x14, 0x92,
	    0x30, 0xb6, 0x3c, 0xba, 0x28, 0xae, 0x24, 0xa2  },
	{ 0x00, 0xe8, 0xcd, 0x25, 0x9a, 0x72, 0x57, 0xbf,
	    0x34, 0xdc, 0xf9, 0x11, 0xae, 0x46, 0x63, 0x8b  },
	{ 0x00, 0x70, 0xe0, 0x90, 0xc0, 0xb0, 0x20, 0x50,
	    0x80, 0xf0, 0x60, 0x10, 0x40, 0x30, 0xa0, 0xd0  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{ 0x00, 0x87, 0x0e, 0x89, 0x1c, 0x9b, 0x12, 0x95,
	    0x38, 0xbf, 0x36, 0xb1, 0x24, 0xa3, 0x2a, 0xad  },
	{ 0x00, 0xe8, 0xd0, 0x38, 0xbd, 0x55, 0x6d, 0x85,
	    0x67, 0x8f, 0xb7, 0x5f, 0xda, 0x32, 0x0a, 0xe2  },
	{ 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80,
	    0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{ 0x00, 0x88, 0x10, 0x98, 0x20, 0xa8, 0x30, 0xb8,
	    0x40, 0xc8, 0x50, 0xd8, 0x60, 0xe8, 0x70, 0xf8  },
	{ 0x00, 0xe8, 0xd0, 0x38, 0xbd, 0x55, 0x6d, 0x85,
	    0x67, 0x8f, 0xb7, 0x5f, 0xda, 0x32, 0x0a, 0xe2  },
	{ 0x00, 0x90, 0x20, 0xb0, 0x40, 0xd0, 0x60, 0xf0,
	    0x80, 0x10, 0xa0, 0x30, 0xc0, 0x50, 0xe0, 0x70  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{ 0x00, 0x89, 0x12, 0x9b, 0x24, 0xad, 0x36, 0xbf,
	    0x48, 0xc1, 0x5a, 0xd3, 0x6c, 0xe5, 0x7e, 0xf7  },
	{ 0x00, 0xe8, 0xd0, 0x38, 0xbd, 0x55, 0x6d, 0x85,
	    0x7a, 0x92, 0xaa, 0x42, 0xc7, 0x2f, 0x17, 0xff  },
	{ 0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60,
	    0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{ 0x00, 0x8a, 0x14, 0x9e, 0x28, 0xa2, 0x3c, 0xb6,
	    0x50, 0xda, 0x44, 0xce, 0x78, 0xf2, 0x6c, 0xe6  },
	{ 0x00, 0xe8, 0xd0, 0x38, 0xbd, 0x55, 0x6d, 0x85,
	    0x7a, 0x92, 0xaa, 0x42, 0xc7, 0x2f, 0x17, 0xff  },
	{ 0x00, 0xb0, 0x60, 0xd0, 0xc0, 0x70, 0xa0, 0x10,
	    0x80, 0x30, 0xe0, 0x50, 0x40, 0xf0, 0x20, 0x90  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{ 0x00, 0x8b, 0x16, 0x9d, 0x2c, 0xa7, 0x3a, 0xb1,
	    0x58, 0xd3, 0x4e, 0xc5, 0x74, 0xff, 0x62, 0xe9  },
	{ 0x00, 0xe8, 0xd0, 0x38, 0xa0, 0x48, 0x70, 0x98,
	    0x5d, 0xb5, 0x8d, 0x65, 0xfd, 0x15, 0x2d, 0xc5  },
	{ 0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40,
	    0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{ 0x00, 0x8c, 0x18, 0x94, 0x30, 0xbc, 0x28, 0xa4,
	    0x60, 0xec, 0x78, 0xf4, 0x50, 0xdc, 0x48, 0xc4  },
	{ 0x00, 0xe8, 0xd0, 0x38, 0xa0, 0x48, 0x70, 0x98,
	    0x5d, 0xb5, 0x8d, 0x65, 0xfd, 0x15, 0x2d, 0xc5  },
	{ 0x00, 0xd0, 0xa0, 0x70, 0x40, 0x90, 0xe0, 0x30,
	    0x80, 0x50, 0x20, 0xf0, 0xc0, 0x10, 0x60, 0xb0  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{ 0x00, 0x8d, 0x1a, 0x97, 0x34, 0xb9, 0x2e, 0xa3,
	    0x68, 0xe5, 0x72, 0xff, 0x5c, 0xd1, 0x46, 0xcb  },
	{ 0x00, 0xe8, 0xd0, 0x38, 0xa0, 0x48, 0x70, 0x98,
	    0x40, 0xa8, 0x90, 0x78, 0xe0, 0x08, 0x30, 0xd8  },
	{ 0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0,
	    0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{ 0x00, 0x8e, 0x1c, 0x92, 0x38, 0xb6, 0x24, 0xaa,
	    0x70, 0xfe, 0x6c, 0xe2, 0x48, 0xc6, 0x54, 0xda  },
	{ 0x00, 0xe8, 0xd0, 0x38, 0xa0, 0x48, 0x70, 0x98,
	    0x40, 0xa8, 0x90, 0x78, 0xe0, 0x08, 0x30, 0xd8  },
	{ 0x00, 0xf0, 0xe0, 0x10, 0xc0, 0x30, 0x20, 0xd0,
	    0x80, 0x70, 0x60, 0x90, 0x40, 0xb0, 0xa0, 0x50  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{ 0x00, 0x8f, 0x1e, 0x91, 0x3c, 0xb3, 0x22, 0xad,
	    0x78, 0xf7, 0x66, 0xe9, 0x44, 0xcb, 0x5a, 0xd5  },
	{ 0x00, 0xf5, 0xf7, 0x02, 0xf3, 0x06, 0x04, 0xf1,
	    0xfb, 0x0e, 0x0c, 0xf9, 0x08, 0xfd, 0xff, 0x0a  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{ 0x00, 0x90, 0x20, 0xb0, 0x40, 0xd0, 0x60, 0xf0,
	    0x80, 0x10, 0xa0, 0x30, 0xc0, 0x50, 0xe0, 0x70  },
	{ 0x00, 0xf5, 0xf7, 0x02, 0xf3, 0x06, 0x04, 0xf1,
	    0xfb, 0x0e, 0x0c, 0xf9, 0x08, 0xfd, 0xff, 0x0a  },
	{ 0x00, 0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70,
	    0x80, 0x90, 0xa0, 0xb0, 0xc0, 0xd0, 0xe0, 0xf0  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{ 0x00, 0x91, 0x22, 0xb3, 0x44, 0xd5, 0x66, 0xf7,
	    0x88, 0x19, 0xaa, 0x3b, 0xcc, 0x5d, 0xee, 0x7f  },
	{ 0x00, 0xf5, 0xf7, 0x02, 0xf3, 0x06, 0x04, 0xf1,
	    0xe6, 0x13, 0x11, 0xe4, 0x15, 0xe0, 0xe2, 0x17  },
	{ 0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0,
	    0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{ 0x00, 0x92, 0x24, 0xb6, 0x48, 0xda, 0x6c, 0xfe,
	    0x90, 0x02, 0xb4, 0x26, 0xd8, 0x4a, 0xfc, 0x6e  },
	{ 0x00, 0xf5, 0xf7, 0x02, 0xf3, 0x06, 0x04, 0xf1,
	    0xe6, 0x13, 0x11, 0xe4, 0x15, 0xe0, 0xe2, 0x17  },
	{ 0x00, 0x30, 0x60, 0x50, 0xc0, 0xf0, 0xa0, 0x90,
	    0x80, 0xb0, 0xe0, 0xd0, 0x40, 0x70, 0x20, 0x10  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{ 0x00, 0x93, 0x26, 0xb5, 0x4c, 0xdf, 0x6a, 0xf9,
	    0x98, 0x0b, 0xbe, 0x2d, 0xd4, 0x47, 0xf2, 0x61  },
	{ 0x00, 0xf5, 0xf7, 0x02, 0xee, 0x1b, 0x19, 0xec,
	    0xc1, 0x34, 0x36, 0xc3, 0x2f, 0xda, 0xd8, 0x2d  },
	{ 0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0,
	    0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{ 0x00, 0x94, 0x28, 0xbc, 0x50, 0xc4, 0x78, 0xec,
	    0xa0, 0x34, 0x88, 0x1c, 0xf0, 0x64, 0xd8, 0x4c  },
	{ 0x00, 0xf5, 0xf7, 0x02, 0xee, 0x1b, 0x19, 0xec,
	    0xc1, 0x34, 0x36, 0xc3, 0x2f, 0xda, 0xd8, 0x2d  },
	{ 0x00, 0x50, 0xa0, 0xf0, 0x40, 0x10, 0xe0, 0xb0,
	    0x80, 0xd0, 0x20, 0x70, 0xc0, 0x90, 0x60, 0x30  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{ 0x00, 0x95, 0x2a, 0xbf, 0x54, 0xc1, 0x7e, 0xeb,
	    0xa8, 0x3d, 0x82, 0x17, 0xfc, 0x69, 0xd6, 0x43  },
	{ 0x00, 0xf5, 0xf7, 0x02, 0xee, 0x1b, 0x19, 0xec,
	    0xdc, 0x29, 0x2b, 0xde, 0x32, 0xc7, 0xc5, 0x30  },
	{ 0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20,
	    0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{ 0x00, 0x96, 0x2c, 0xba, 0x58, 0xce, 0x74, 0xe2,
	    0xb0, 0x26, 0x9c, 0x0a, 0xe8, 0x7e, 0xc4, 0x52  },
	{ 0x00, 0xf5, 0xf7, 0x02, 0xee, 0x1b, 0x19, 0xec,
	    0xdc, 0x29, 0x2b, 0xde, 0x32, 0xc7, 0xc5, 0x30  },
	{ 0x00, 0x70, 0xe0, 0x90, 0xc0, 0xb0, 0x20, 0x50,
	    0x80, 0xf0, 0x60, 0x10, 0x40, 0x30, 0xa0, 0xd0  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{ 0x00, 0x97, 0x2e, 0xb9, 0x5c, 0xcb, 0x72, 0xe5,
	    0xb8, 0x2f, 0x96, 0x01, 0xe4, 0x73, 0xca, 0x5d  },
	{ 0x00, 0xf5, 0xea, 0x1f, 0xc9, 0x3c, 0x23, 0xd6,
	    0x8f, 0x7a, 0x65, 0x90, 0x46, 0xb3, 0xac, 0x59  },
	{ 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80,
	    0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{ 0x00, 0x98, 0x30, 0xa8, 0x60, 0xf8, 0x50, 0xc8,
	    0xc0, 0x58, 0xf0, 0x68, 0xa0, 0x38, 0x90, 0x08  },
	{ 0x00, 0xf5, 0xea, 0x1f, 0xc9, 0x3c, 0x23, 0xd6,
	    0x8f, 0x7a, 0x65, 0x90, 0x46, 0xb3, 0xac, 0x59  },
	{ 0x00, 0x90, 0x20, 0xb0, 0x40, 0xd0, 0x60, 0xf0,
	    0x80, 0x10, 0xa0, 0x30, 0xc0, 0x50, 0xe0, 0x70  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{ 0x00, 0x99, 0x32, 0xab, 0x64, 0xfd, 0x56, 0xcf,
	    0xc8, 0x51, 0xfa, 0x63, 0xac, 0x35, 0x9e, 0x07  },
	{ 0x00, 0xf5, 0xea, 0x1f, 0xc9, 0x3c, 0x23, 0xd6,
	    0x92, 0x67, 0x78, 0x8d, 0x5b, 0xae, 0xb1, 0x44  },
	{ 0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60,
	    0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{ 0x00, 0x9a, 0x34, 0xae, 0x68, 0xf2, 0x5c, 0xc6,
	    0xd0, 0x4a, 0xe4, 0x7e, 0xb8, 0x22, 0x8c, 0x16  },
	{ 0x00, 0xf5, 0xea, 0x1f, 0xc9, 0x3c, 0x23, 0xd6,
	    0x92, 0x67, 0x78, 0x8d, 0x5b, 0xae, 0xb1, 0x44  },
	{ 0x00, 0xb0, 0x60, 0xd0, 0xc0, 0x70, 0xa0, 0x10,
	    0x80, 0x30, 0xe0, 0x50, 0x40, 0xf0, 0x20, 0x90  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{ 0x00, 0x9b, 0x36, 0xad, 0x6c, 0xf7, 0x5a, 0xc1,
	    0xd8, 0x43, 0xee, 0x75, 0xb4, 0x2f, 0x82, 0x19  },
	{ 0x00, 0xf5, 0xea, 0x1f, 0xd4, 0x21, 0x3e, 0xcb,
	    0xb5, 0x40, 0x5f, 0xaa, 0x61, 0x94, 0x8b, 0x7e  },
	{ 0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40,
	    0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{ 0x00, 0x9c, 0x38, 0xa4, 0x70, 0xec, 0x48, 0xd4,
	    0xe0, 0x7c, 0xd8, 0x44, 0x90, 0x0c, 0xa8, 0x34  },
	{ 0x00, 0xf5, 0xea, 0x1f, 0xd4, 0x21, 0x3e, 0xcb,
	    0xb5, 0x40, 0x5f, 0xaa, 0x61, 0x94, 0x8b, 0x7e  },
	{ 0x00, 0xd0, 0xa0, 0x70, 0x40, 0x90, 0xe0, 0x30,
	    0x80, 0x50, 0x20, 0xf0, 0xc0, 0x10, 0x60, 0xb0  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{ 0x00, 0x9d, 0x3a, 0xa7, 0x74, 0xe9, 0x4e, 0xd3,
	    0xe8, 0x75, 0xd2, 0x4f, 0x9c, 0x01, 0xa6, 0x3b  },
	{ 0x00, 0xf5, 0xea, 0x1f, 0xd4, 0x21, 0x3e, 0xcb,
	    0xa8, 0x5d, 0x42, 0xb7, 0x7c, 0x89, 0x96, 0x63  },
	{ 0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0,
	    0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{ 0x00, 0x9e, 0x3c, 0xa2, 0x78, 0xe6, 0x44, 0xda,
	    0xf0, 0x6e, 0xcc, 0x52, 0x88, 0x16, 0xb4, 0x2a  },
	{ 0x00, 0xf5, 0xea, 0x1f, 0xd4, 0x21, 0x3e, 0xcb,
	    0xa8, 0x5d, 0x42, 0xb7, 0x7c, 0x89, 0x96, 0x63  },
	{ 0x00, 0xf0, 0xe0, 0x10, 0xc0, 0x30, 0x20, 0xd0,
	    0x80, 0x70, 0x60, 0x90, 0x40, 0xb0, 0xa0, 0x50  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{ 0x00, 0x9f, 0x3e, 0xa1, 0x7c, 0xe3, 0x42, 0xdd,
	    0xf8, 0x67, 0xc6, 0x59, 0x84, 0x1b, 0xba, 0x25  },
	{ 0x00, 0xd2, 0xb9, 0x6b, 0x6f, 0xbd, 0xd6, 0x04,
	    0xde, 0x0c, 0x67, 0xb5, 0xb1, 0x63, 0x08, 0xda  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{ 0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60,
	    0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60  },
	{ 0x00, 0xd2, 0xb9, 0x6b, 0x6f, 0xbd, 0xd6, 0x04,
	    0xde, 0x0c, 0x67, 0xb5, 0xb1, 0x63, 0x08, 0xda  },
	{ 0x00, 0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70,
	    0x80, 0x90, 0xa0, 0xb0, 0xc0, 0xd0, 0xe0, 0xf0  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{ 0x00, 0xa1, 0x42, 0xe3, 0x84, 0x25, 0xc6, 0x67,
	    0x08, 0xa9, 0x4a, 0xeb, 0x8c, 0x2d, 0xce, 0x6f  },
	{ 0x00, 0xd2, 0xb9, 0x6b, 0x6f, 0xbd, 0xd6, 0x04,
	    0xc3, 0x11, 0x7a, 0xa8, 0xac, 0x7e, 0x15, 0xc7  },
	{ 0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0,
	    0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{ 0x00, 0xa2, 0x44, 0xe6, 0x88, 0x2a, 0xcc, 0x6e,
	    0x10, 0xb2, 0x54, 0xf6, 0x98, 0x3a, 0xdc, 0x7e  },
	{ 0x00, 0xd2, 0xb9, 0x6b, 0x6f, 0xbd, 0xd6, 0x04,
	    0xc3, 0x11, 0x7a, 0xa8, 0xac, 0x7e, 0x15, 0xc7  },
	{ 0x00, 0x30, 0x60, 0x50, 0xc0, 0xf0, 0xa0, 0x90,
	    0x80, 0xb0, 0xe0, 0xd0, 0x40, 0x70, 0x20, 0x10  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{ 0x00, 0xa3, 0x46, 0xe5, 0x8c, 0x2f, 0xca, 0x69,
	    0x18, 0xbb, 0x5e, 0xfd, 0x94, 0x37, 0xd2, 0x71  },
	{ 0x00, 0xd2, 0xb9, 0x6b, 0x72, 0xa0, 0xcb, 0x19,
	    0xe4, 0x36, 0x5d, 0x8f, 0x96, 0x44, 0x2f, 0xfd  },
	{ 0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0,
	    0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{ 0x00, 0xa4, 0x48, 0xec, 0x90, 0x34, 0xd8, 0x7c,
	    0x20, 0x84, 0x68, 0xcc, 0xb0, 0x14, 0xf8, 0x5c  },
	{ 0x00, 0xd2, 0xb9, 0x6b, 0x72, 0xa0, 0xcb, 0x19,
	    0xe4, 0x36, 0x5d, 0x8f, 0x96, 0x44, 0x2f, 0xfd  },
	{ 0x00, 0x50, 0xa0, 0xf0, 0x40, 0x10, 0xe0, 0xb0,
	    0x80, 0xd0, 0x20, 0x70, 0xc0, 0x90, 0x60, 0x30  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{ 0x00, 0xa5, 0x4a, 0xef, 0x94, 0x31, 0xde, 0x7b,
	    0x28, 0x8d, 0x62, 0xc7, 0xbc, 0x19, 0xf6, 0x53  },
	{ 0x00, 0xd2, 0xb9, 0x6b, 0x72, 0xa0, 0xcb, 0x19,
	    0xf9, 0x2b, 0x40, 0x92, 0x8b, 0x59, 0x32, 0xe0  },
	{ 0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20,
	    0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{ 0x00, 0xa6, 0x4c, 0xea, 0x98, 0x3e, 0xd4, 0x72,
	    0x30, 0x96, 0x7c, 0xda, 0xa8, 0x0e, 0xe4, 0x42  },
	{ 0x00, 0xd2, 0xb9, 0x6b, 0x72, 0xa0, 0xcb, 0x19,
	    0xf9, 0x2b, 0x40, 0x92, 0x8b, 0x59, 0x32, 0xe0  },
	{ 0x00, 0x70, 0xe0, 0x90, 0xc0, 0xb0, 0x20, 0x50,
	    0x80, 0xf0, 0x60, 0x10, 0x40, 0x30, 0xa0, 0xd0  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{ 0x00, 0xa7, 0x4e, 0xe9, 0x9c, 0x3b, 0xd2, 0x75,
	    0x38, 0x9f, 0x76, 0xd1, 0xa4, 0x03, 0xea, 0x4d  },
	{ 0x00, 0xd2, 0xa4, 0x76, 0x55, 0x87, 0xf1, 0x23,
	    0xaa, 0x78, 0x0e, 0xdc, 0xff, 0x2d, 0x5b, 0x89  },
	{ 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80,
	    0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{ 0x00, 0xa8, 0x50, 0xf8, 0xa0, 0x08, 0xf0, 0x58,
	    0x40, 0xe8, 0x10, 0xb8, 0xe0, 0x48, 0xb0, 0x18  },
	{ 0x00, 0xd2, 0xa4, 0x76, 0x55, 0x87, 0xf1, 0x23,
	    0xaa, 0x78, 0x0e, 0xdc, 0xff, 0x2d, 0x5b, 0x89  },
	{ 0x00, 0x90, 0x20, 0xb0, 0x40, 0xd0, 0x60, 0xf0,
	    0x80, 0x10, 0xa0, 0x30, 0xc0, 0x50, 0xe0, 0x70  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{ 0x00, 0xa9, 0x52, 0xfb, 0xa4, 0x0d, 0xf6, 0x5f,
	    0x48, 0xe1, 0x1a, 0xb3, 0xec, 0x45, 0xbe, 0x17  },
	{ 0x00, 0xd2, 0xa4, 0x76, 0x55, 0x87, 0xf1, 0x23,
	    0xb7, 0x65, 0x13, 0xc1, 0xe2, 0x30, 0x46, 0x94  },
	{ 0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60,
	    0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{ 0x00, 0xaa, 0x54, 0xfe, 0xa8, 0x02, 0xfc, 0x56,
	    0x50, 0xfa, 0x04, 0xae, 0xf8, 0x52, 0xac, 0x06  },
	{ 0x00, 0xd2, 0xa4, 0x76, 0x55, 0x87, 0xf1, 0x23,
	    0xb7, 0x65, 0x13, 0xc1, 0xe2, 0x30, 0x46, 0x94  },
	{ 0x00, 0xb0, 0x60, 0xd0, 0xc0, 0x70, 0xa0, 0x10,
	    0x80, 0x30, 0xe0, 0x50, 0x40, 0xf0, 0x20, 0x90  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{ 0x00, 0xab, 0x56, 0xfd, 0xac, 0x07, 0xfa, 0x51,
	    0x58, 0xf3, 0x0e, 0xa5, 0xf4, 0x5f, 0xa2, 0x09  },
	{ 0x00, 0xd2, 0xa4, 0x76, 0x48, 0x9a, 0xec, 0x3e,
	    0x90, 0x42, 0x34, 0xe6, 0xd8, 0x0a, 0x7c, 0xae  },
	{ 0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40,
	    0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{ 0x00, 0xac, 0x58, 0xf4, 0xb0, 0x1c, 0xe8, 0x44,
	    0x60, 0xcc, 0x38, 0x94, 0xd0, 0x7c, 0x88, 0x24  },
	{ 0x00, 0xd2, 0xa4, 0x76, 0x48, 0x9a, 0xec, 0x3e,
	    0x90, 0x42, 0x34, 0xe6, 0xd8, 0x0a, 0x7c, 0xae  },
	{ 0x00, 0xd0, 0xa0, 0x70, 0x40, 0x90, 0xe0, 0x30,
	    0x80, 0x50, 0x20, 0xf0, 0xc0, 0x10, 0x60, 0xb0  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{ 0x00, 0xad, 0x5a, 0xf7, 0xb4, 0x19, 0xee, 0x43,
	    0x68, 0xc5, 0x32, 0x9f, 0xdc, 0x71, 0x86, 0x2b  },
	{ 0x00, 0xd2, 0xa4, 0x76, 0x48, 0x9a, 0xec, 0x3e,
	    0x8d, 0x5f, 0x29, 0xfb, 0xc5, 0x17, 0x61, 0xb3  },
	{ 0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0,
	    0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{ 0x00, 0xae, 0x5c, 0xf2, 0xb8, 0x16, 0xe4, 0x4a,
	    0x70, 0xde, 0x2c, 0x82, 0xc8, 0x66, 0x94, 0x3a  },
	{ 0x00, 0xd2, 0xa4, 0x76, 0x48, 0x9a, 0xec, 0x3e,
	    0x8d, 0x5f, 0x29, 0xfb, 0xc5, 0x17, 0x61, 0xb3  },
	{ 0x00, 0xf0, 0xe0, 0x10, 0xc0, 0x30, 0x20, 0xd0,
	    0x80, 0x70, 0x60, 0x90, 0x40, 0xb0, 0xa0, 0x50  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{ 0x00, 0xaf, 0x5e, 0xf1, 0xbc, 0x13, 0xe2, 0x4d,
	    0x78, 0xd7, 0x26, 0x89, 0xc4, 0x6b, 0x9a, 0x35  },
	{ 0x00, 0xcf, 0x83, 0x4c, 0x1b, 0xd4, 0x98, 0x57,
	    0x36, 0xf9, 0xb5, 0x7a, 0x2d, 0xe2, 0xae, 0x61  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{ 0x00, 0xb0, 0x60, 0xd0, 0xc0, 0x70, 0xa0, 0x10,
	    0x80, 0x30, 0xe0, 0x50, 0x40, 0xf0, 0x20, 0x90  },
	{ 0x00, 0xcf, 0x83, 0x4c, 0x1b, 0xd4, 0x98, 0x57,
	    0x36, 0xf9, 0xb5, 0x7a, 0x2d, 0xe2, 0xae, 0x61  },
	{ 0x00, 0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70,
	    0x80, 0x90, 0xa0, 0xb0, 0xc0, 0xd0, 0xe0, 0xf0  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{ 0x00, 0xb1, 0x62, 0xd3, 0xc4, 0x75, 0xa6, 0x17,
	    0x88, 0x39, 0xea, 0x5b, 0x4c, 0xfd, 0x2e, 0x9f  },
	{ 0x00, 0xcf, 0x83, 0x4c, 0x1b, 0xd4, 0x98, 0x57,
	    0x2b, 0xe4, 0xa8, 0x67, 0x30, 0xff, 0xb3, 0x7c  },
	{ 0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0,
	    0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{ 0x00, 0xb2, 0x64, 0xd6, 0xc8, 0x7a, 0xac, 0x1e,
	    0x90, 0x22, 0xf4, 0x46, 0x58, 0xea, 0x3c, 0x8e  },
	{ 0x00, 0xcf, 0x83, 0x4c, 0x1b, 0xd4, 0x98, 0x57,
	    0x2b, 0xe4, 0xa8, 0x67, 0x30, 0xff, 0xb3, 0x7c  },
	{ 0x00, 0x30, 0x60, 0x50, 0xc0, 0xf0, 0xa0, 0x90,
	    0x80, 0xb0, 0xe0, 0xd0, 0x40, 0x70, 0x20, 0x10  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{ 0x00, 0xb3, 0x66, 0xd5, 0xcc, 0x7f, 0xaa, 0x19,
	    0x98, 0x2b, 0xfe, 0x4d, 0x54, 0xe7, 0x32, 0x81  },
	{ 0x00, 0xcf, 0x83, 0x4c, 0x06, 0xc9, 0x85, 0x4a,
	    0x0c, 0xc3, 0x8f, 0x40, 0x0a, 0xc5, 0x89, 0x46  },
	{ 0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0,
	    0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{ 0x00, 0xb4, 0x68, 0xdc, 0xd0, 0x64, 0xb8, 0x0c,
	    0xa0, 0x14, 0xc8, 0x7c, 0x70, 0xc4, 0x18, 0xac  },
	{ 0x00, 0xcf, 0x83, 0x4c, 0x06, 0xc9, 0x85, 0x4a,
	    0x0c, 0xc3, 0x8f, 0x40, 0x0a, 0xc5, 0x89, 0x46  },
	{ 0x00, 0x50, 0xa0, 0xf0, 0x40, 0x10, 0xe0, 0xb0,
	    0x80, 0xd0, 0x20, 0x70, 0xc0, 0x90, 0x60, 0x30  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{ 0x00, 0xb5, 0x6a, 0xdf, 0xd4, 0x61, 0xbe, 0x0b,
	    0xa8, 0x1d, 0xc2, 0x77, 0x7c, 0xc9, 0x16, 0xa3  },
	{ 0x00, 0xcf, 0x83, 0x4c, 0x06, 0xc9, 0x85, 0x4a,
	    0x11, 0xde, 0x92, 0x5d, 0x17, 0xd8, 0x94, 0x5b  },
	{ 0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20,
	    0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{ 0x00, 0xb6, 0x6c, 0xda, 0xd8, 0x6e, 0xb4, 0x02,
	    0xb0, 0x06, 0xdc, 0x6a, 0x68, 0xde, 0x04, 0xb2  },
	{ 0x00, 0xcf, 0x83, 0x4c, 0x06, 0xc9, 0x85, 0x4a,
	    0x11, 0xde, 0x92, 0x5d, 0x17, 0xd8, 0x94, 0x5b  },
	{ 0x00, 0x70, 0xe0, 0x90, 0xc0, 0xb0, 0x20, 0x50,
	    0x80, 0xf0, 0x60, 0x10, 0x40, 0x30, 0xa0, 0xd0  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{ 0x00, 0xb7, 0x6e, 0xd9, 0xdc, 0x6b, 0xb2, 0x05,
	    0xb8, 0x0f, 0xd6, 0x61, 0x64, 0xd3, 0x0a, 0xbd  },
	{ 0x00, 0xcf, 0x9e, 0x51, 0x21, 0xee, 0xbf, 0x70,
	    0x42, 0x8d, 0xdc, 0x13, 0x63, 0xac, 0xfd, 0x32  },
	{ 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80,
	    0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{ 0x00, 0xb8, 0x70, 0xc8, 0xe0, 0x58, 0x90, 0x28,
	    0xc0, 0x78, 0xb0, 0x08, 0x20, 0x98, 0x50, 0xe8  },
	{ 0x00, 0xcf, 0x9e, 0x51, 0x21, 0xee, 0xbf, 0x70,
	    0x42, 0x8d, 0xdc, 0x13, 0x63, 0xac, 0xfd, 0x32  },
	{ 0x00, 0x90, 0x20, 0xb0, 0x40, 0xd0, 0x60, 0xf0,
	    0x80, 0x10, 0xa0, 0x30, 0xc0, 0x50, 0xe0, 0x70  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{ 0x00, 0xb9, 0x72, 0xcb, 0xe4, 0x5d, 0x96, 0x2f,
	    0xc8, 0x71, 0xba, 0x03, 0x2c, 0x95, 0x5e, 0xe7  },
	{ 0x00, 0xcf, 0x9e, 0x51, 0x21, 0xee, 0xbf, 0x70,
	    0x5f, 0x90, 0xc1, 0x0e, 0x7e, 0xb1, 0xe0, 0x2f  },
	{ 0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60,
	    0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{ 0x00, 0xba, 0x74, 0xce, 0xe8, 0x52, 0x9c, 0x26,
	    0xd0, 0x6a, 0xa4, 0x1e, 0x38, 0x82, 0x4c, 0xf6  },
	{ 0x00, 0xcf, 0x9e, 0x51, 0x21, 0xee, 0xbf, 0x70,
	    0x5f, 0x90, 0xc1, 0x0e, 0x7e, 0xb1, 0xe0, 0x2f  },
	{ 0x00, 0xb0, 0x60, 0xd0, 0xc0, 0x70, 0xa0, 0x10,
	    0x80, 0x30, 0xe0, 0x50, 0x40, 0xf0, 0x20, 0x90  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{ 0x00, 0xbb, 0x76, 0xcd, 0xec, 0x57, 0x9a, 0x21,
	    0xd8, 0x63, 0xae, 0x15, 0x34, 0x8f, 0x42, 0xf9  },
	{ 0x00, 0xcf, 0x9e, 0x51, 0x3c, 0xf3, 0xa2, 0x6d,
	    0x78, 0xb7, 0xe6, 0x29, 0x44, 0x8b, 0xda, 0x15  },
	{ 0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40,
	    0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{ 0x00, 0xbc, 0x78, 0xc4, 0xf0, 0x4c, 0x88, 0x34,
	    0xe0, 0x5c, 0x98, 0x24, 0x10, 0xac, 0x68, 0xd4  },
	{ 0x00, 0xcf, 0x9e, 0x51, 0x3c, 0xf3, 0xa2, 0x6d,
	    0x78, 0xb7, 0xe6, 0x29, 0x44, 0x8b, 0xda, 0x15  },
	{ 0x00, 0xd0, 0xa0, 0x70, 0x40, 0x90, 0xe0, 0x30,
	    0x80, 0x50, 0x20, 0xf0, 0xc0, 0x10, 0x60, 0xb0  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{ 0x00, 0xbd, 0x7a, 0xc7, 0xf4, 0x49, 0x8e, 0x33,
	    0xe8, 0x55, 0x92, 0x2f, 0x1c, 0xa1, 0x66, 0xdb  },
	{ 0x00, 0xcf, 0x9e, 0x51, 0x3c, 0xf3, 0xa2, 0x6d,
	    0x65, 0xaa, 0xfb, 0x34, 0x59, 0x96, 0xc7, 0x08  },
	{ 0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0,
	    0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{ 0x00, 0xbe, 0x7c, 0xc2, 0xf8, 0x46, 0x84, 0x3a,
	    0xf0, 0x4e, 0x8c, 0x32, 0x08, 0xb6, 0x74, 0xca  },
	{ 0x00, 0xcf, 0x9e, 0x51, 0x3c, 0xf3, 0xa2, 0x6d,
	    0x65, 0xaa, 0xfb, 0x34, 0x59, 0x96, 0xc7, 0x08  },
	{ 0x00, 0xf0, 0xe0, 0x10, 0xc0, 0x30, 0x20, 0xd0,
	    0x80, 0x70, 0x60, 0x90, 0x40, 0xb0, 0xa0, 0x50  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
	    0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{ 0x00, 0xbf, 0x7e, 0xc1, 0xfc, 0x43, 0x82, 0x3d,
	    0xf8, 0x47, 0x86, 0x39, 0x04, 0xbb, 0x7a, 0xc5  },
	{ 0x00, 0x9c, 0x25, 0xb9, 0x4a, 0xd6, 0x6f, 0xf3,
	    0x94, 0x08, 0xb1, 0x2d, 0xde, 0x42, 0xfb, 0x67  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{ 0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40,
	    0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40  },
	{ 0x00, 0x9c, 0x25, 0xb9, 0x4a, 0xd6, 0x6f, 0xf3,
	    0x94, 0x08, 0xb1, 0x2d, 0xde, 0x42, 0xfb, 0x67  },
	{ 0x00, 0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70,
	    0x80, 0x90, 0xa0, 0xb0, 0xc0, 0xd0, 0xe0, 0xf0  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{ 0x00, 0xc1, 0x82, 0x43, 0x04, 0xc5, 0x86, 0x47,
	    0x08, 0xc9, 0x8a, 0x4b, 0x0c, 0xcd, 0x8e, 0x4f  },
	{ 0x00, 0x9c, 0x25, 0xb9, 0x4a, 0xd6, 0x6f, 0xf3,
	    0x89, 0x15, 0xac, 0x30, 0xc3, 0x5f, 0xe6, 0x7a  },
	{ 0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0,
	    0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{ 0x00, 0xc2, 0x84, 0x46, 0x08, 0xca, 0x8c, 0x4e,
	    0x10, 0xd2, 0x94, 0x56, 0x18, 0xda, 0x9c, 0x5e  },
	{ 0x00, 0x9c, 0x25, 0xb9, 0x4a, 0xd6, 0x6f, 0xf3,
	    0x89, 0x15, 0xac, 0x30, 0xc3, 0x5f, 0xe6, 0x7a  },
	{ 0x00, 0x30, 0x60, 0x50, 0xc0, 0xf0, 0xa0, 0x90,
	    0x80, 0xb0, 0xe0, 0xd0, 0x40, 0x70, 0x20, 0x10  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{ 0x00, 0xc3, 0x86, 0x45, 0x0c, 0xcf, 0x8a, 0x49,
	    0x18, 0xdb, 0x9e, 0x5d, 0x14, 0xd7, 0x92, 0x51  },
	{ 0x00, 0x9c, 0x25, 0xb9, 0x57, 0xcb, 0x72, 0xee,
	    0xae, 0x32, 0x8b, 0x17, 0xf9, 0x65, 0xdc, 0x40  },
	{ 0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0,
	    0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{ 0x00, 0xc4, 0x88, 0x4c, 0x10, 0xd4, 0x98, 0x5c,
	    0x20, 0xe4, 0xa8, 0x6c, 0x30, 0xf4, 0xb8, 0x7c  },
	{ 0x00, 0x9c, 0x25, 0xb9, 0x57, 0xcb, 0x72, 0xee,
	    0xae, 0x32, 0x8b, 0x17, 0xf9, 0x65, 0xdc, 0x40  },
	{ 0x00, 0x50, 0xa0, 0xf0, 0x40, 0x10, 0xe0, 0xb0,
	    0x80, 0xd0, 0x20, 0x70, 0xc0, 0x90, 0x60, 0x30  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{ 0x00, 0xc5, 0x8a, 0x4f, 0x14, 0xd1, 0x9e, 0x5b,
	    0x28, 0xed, 0xa2, 0x67, 0x3c, 0xf9, 0xb6, 0x73  },
	{ 0x00, 0x9c, 0x25, 0xb9, 0x57, 0xcb, 0x72, 0xee,
	    0xb3, 0x2f, 0x96, 0x0a, 0xe4, 0x78, 0xc1, 0x5d  },
	{ 0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20,
	    0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{ 0x00, 0xc6, 0x8c, 0x4a, 0x18, 0xde, 0x94, 0x52,
	    0x30, 0xf6, 0xbc, 0x7a, 0x28, 0xee, 0xa4, 0x62  },
	{ 0x00, 0x9c, 0x25, 0xb9, 0x57, 0xcb, 0x72, 0xee,
	    0xb3, 0x2f, 0x96, 0x0a, 0xe4, 0x78, 0xc1, 0x5d  },
	{ 0x00, 0x70, 0xe0, 0x90, 0xc0, 0xb0, 0x20, 0x50,
	    0x80, 0xf0, 0x60, 0x10, 0x40, 0x30, 0xa0, 0xd0  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{ 0x00, 0xc7, 0x8e, 0x49, 0x1c, 0xdb, 0x92, 0x55,
	    0x38, 0xff, 0xb6, 0x71, 0x24, 0xe3, 0xaa, 0x6d  },
	{ 0x00, 0x9c, 0x38, 0xa4, 0x70, 0xec, 0x48, 0xd4,
	    0xe0, 0x7c, 0xd8, 0x44, 0x90, 0x0c, 0xa8, 0x34  },
	{ 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80,
	    0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{ 0x00, 0xc8, 0x90, 0x58, 0x20, 0xe8, 0xb0, 0x78,
	    0x40, 0x88, 0xd0, 0x18, 0x60, 0xa8, 0xf0, 0x38  },
	{ 0x00, 0x9c, 0x38, 0xa4, 0x70, 0xec, 0x48, 0xd4,
	    0xe0, 0x7c, 0xd8, 0x44, 0x90, 0x0c, 0xa8, 0x34  },
	{ 0x00, 0x90, 0x20, 0xb0, 0x40, 0xd0, 0x60, 0xf0,
	    0x80, 0x10, 0xa0, 0x30, 0xc0, 0x50, 0xe0, 0x70  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{ 0x00, 0xc9, 0x92, 0x5b, 0x24, 0xed, 0xb6, 0x7f,
	    0x48, 0x81, 0xda, 0x13, 0x6c, 0xa5, 0xfe, 0x37  },
	{ 0x00, 0x9c, 0x38, 0xa4, 0x70, 0xec, 0x48, 0xd4,
	    0xfd, 0x61, 0xc5, 0x59, 0x8d, 0x11, 0xb5, 0x29  },
	{ 0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60,
	    0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{ 0x00, 0xca, 0x94, 0x5e, 0x28, 0xe2, 0xbc, 0x76,
	    0x50, 0x9a, 0xc4, 0x0e, 0x78, 0xb2, 0xec, 0x26  },
	{ 0x00, 0x9c, 0x38, 0xa4, 0x70, 0xec, 0x48, 0xd4,
	    0xfd, 0x61, 0xc5, 0x59, 0x8d, 0x11, 0xb5, 0x29  },
	{ 0x00, 0xb0, 0x60, 0xd0, 0xc0, 0x70, 0xa0, 0x10,
	    0x80, 0x30, 0xe0, 0x50, 0x40, 0xf0, 0x20, 0x90  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{ 0x00, 0xcb, 0x96, 0x5d, 0x2c, 0xe7, 0xba, 0x71,
	    0x58, 0x93, 0xce, 0x05, 0x74, 0xbf, 0xe2, 0x29  },
	{ 0x00, 0x9c, 0x38, 0xa4, 0x6d, 0xf1, 0x55, 0xc9,
	    0xda, 0x46, 0xe2, 0x7e, 0xb7, 0x2b, 0x8f, 0x13  },
	{ 0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40,
	    0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{ 0x00, 0xcc, 0x98, 0x54, 0x30, 0xfc, 0xa8, 0x64,
	    0x60, 0xac, 0xf8, 0x34, 0x50, 0x9c, 0xc8, 0x04  },
	{ 0x00, 0x9c, 0x38, 0xa4, 0x6d, 0xf1, 0x55, 0xc9,
	    0xda, 0x46, 0xe2, 0x7e, 0xb7, 0x2b, 0x8f, 0x13  },
	{ 0x00, 0xd0, 0xa0, 0x70, 0x40, 0x90, 0xe0, 0x30,
	    0x80, 0x50, 0x20, 0xf0, 0xc0, 0x10, 0x60, 0xb0  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{ 0x00, 0xcd, 0x9a, 0x57, 0x34, 0xf9, 0xae, 0x63,
	    0x68, 0xa5, 0xf2, 0x3f, 0x5c, 0x91, 0xc6, 0x0b  },
	{ 0x00, 0x9c, 0x38, 0xa4, 0x6d, 0xf1, 0x55, 0xc9,
	    0xc7, 0x5b, 0xff, 0x63, 0xaa, 0x36, 0x92, 0x0e  },
	{ 0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0,
	    0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{ 0x00, 0xce, 0x9c, 0x52, 0x38, 0xf6, 0xa4, 0x6a,
	    0x70, 0xbe, 0xec, 0x22, 0x48, 0x86, 0xd4, 0x1a  },
	{ 0x00, 0x9c, 0x38, 0xa4, 0x6d, 0xf1, 0x55, 0xc9,
	    0xc7, 0x5b, 0xff, 0x63, 0xaa, 0x36, 0x92, 0x0e  },
	{ 0x00, 0xf0, 0xe0, 0x10, 0xc0, 0x30, 0x20, 0xd0,
	    0x80, 0x70, 0x60, 0x90, 0x40, 0xb0, 0xa0, 0x50  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{ 0x00, 0xcf, 0x9e, 0x51, 0x3c, 0xf3, 0xa2, 0x6d,
	    0x78, 0xb7, 0xe6, 0x29, 0x44, 0x8b, 0xda, 0x15  },
	{ 0x00, 0x81, 0x1f, 0x9e, 0x3e, 0xbf, 0x21, 0xa0,
	    0x7c, 0xfd, 0x63, 0xe2, 0x42, 0xc3, 0x5d, 0xdc  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{ 0x00, 0xd0, 0xa0, 0x70, 0x40, 0x90, 0xe0, 0x30,
	    0x80, 0x50, 0x20, 0xf0, 0xc0, 0x10, 0x60, 0xb0  },
	{ 0x00, 0x81, 0x1f, 0x9e, 0x3e, 0xbf, 0x21, 0xa0,
	    0x7c, 0xfd, 0x63, 0xe2, 0x42, 0xc3, 0x5d, 0xdc  },
	{ 0x00, 0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70,
	    0x80, 0x90, 0xa0, 0xb0, 0xc0, 0xd0, 0xe0, 0xf0  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{ 0x00, 0xd1, 0xa2, 0x73, 0x44, 0x95, 0xe6, 0x37,
	    0x88, 0x59, 0x2a, 0xfb, 0xcc, 0x1d, 0x6e, 0xbf  },
	{ 0x00, 0x81, 0x1f, 0x9e, 0x3e, 0xbf, 0x21, 0xa0,
	    0x61, 0xe0, 0x7e, 0xff, 0x5f, 0xde, 0x40, 0xc1  },
	{ 0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0,
	    0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{ 0x00, 0xd2, 0xa4, 0x76, 0x48, 0x9a, 0xec, 0x3e,
	    0x90, 0x42, 0x34, 0xe6, 0xd8, 0x0a, 0x7c, 0xae  },
	{ 0x00, 0x81, 0x1f, 0x9e, 0x3e, 0xbf, 0x21, 0xa0,
	    0x61, 0xe0, 0x7e, 0xff, 0x5f, 0xde, 0x40, 0xc1  },
	{ 0x00, 0x30, 0x60, 0x50, 0xc0, 0xf0, 0xa0, 0x90,
	    0x80, 0xb0, 0xe0, 0xd0, 0x40, 0x70, 0x20, 0x10  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{ 0x00, 0xd3, 0xa6, 0x75, 0x4c, 0x9f, 0xea, 0x39,
	    0x98, 0x4b, 0x3e, 0xed, 0xd4, 0x07, 0x72, 0xa1  },
	{ 0x00, 0x81, 0x1f, 0x9e, 0x23, 0xa2, 0x3c, 0xbd,
	    0x46, 0xc7, 0x59, 0xd8, 0x65, 0xe4, 0x7a, 0xfb  },
	{ 0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0,
	    0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{ 0x00, 0xd4, 0xa8, 0x7c, 0x50, 0x84, 0xf8, 0x2c,
	    0xa0, 0x74, 0x08, 0xdc, 0xf0, 0x24, 0x58, 0x8c  },
	{ 0x00, 0x81, 0x1f, 0x9e, 0x23, 0xa2, 0x3c, 0xbd,
	    0x46, 0xc7, 0x59, 0xd8, 0x65, 0xe4, 0x7a, 0xfb  },
	{ 0x00, 0x50, 0xa0, 0xf0, 0x40, 0x10, 0xe0, 0xb0,
	    0x80, 0xd0, 0x20, 0x70, 0xc0, 0x90, 0x60, 0x30  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{ 0x00, 0xd5, 0xaa, 0x7f, 0x54, 0x81, 0xfe, 0x2b,
	    0xa8, 0x7d, 0x02, 0xd7, 0xfc, 0x29, 0x56, 0x83  },
	{ 0x00, 0x81, 0x1f, 0x9e, 0x23, 0xa2, 0x3c, 0xbd,
	    0x5b, 0xda, 0x44, 0xc5, 0x78, 0xf9, 0x67, 0xe6  },
	{ 0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20,
	    0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{ 0x00, 0xd6, 0xac, 0x7a, 0x58, 0x8e, 0xf4, 0x22,
	    0xb0, 0x66, 0x1c, 0xca, 0xe8, 0x3e, 0x44, 0x92  },
	{ 0x00, 0x81, 0x1f, 0x9e, 0x23, 0xa2, 0x3c, 0xbd,
	    0x5b, 0xda, 0x44, 0xc5, 0x78, 0xf9, 0x67, 0xe6  },
	{ 0x00, 0x70, 0xe0, 0x90, 0xc0, 0xb0, 0x20, 0x50,
	    0x80, 0xf0, 0x60, 0x10, 0x40, 0x30, 0xa0, 0xd0  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{ 0x00, 0xd7, 0xae, 0x79, 0x5c, 0x8b, 0xf2, 0x25,
	    0xb8, 0x6f, 0x16, 0xc1, 0xe4, 0x33, 0x4a, 0x9d  },
	{ 0x00, 0x81, 0x02, 0x83, 0x04, 0x85, 0x06, 0x87,
	    0x08, 0x89, 0x0a, 0x8b, 0x0c, 0x8d, 0x0e, 0x8f  },
	{ 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80,
	    0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{ 0x00, 0xd8, 0xb0, 0x68, 0x60, 0xb8, 0xd0, 0x08,
	    0xc0, 0x18, 0x70, 0xa8, 0xa0, 0x78, 0x10, 0xc8  },
	{ 0x00, 0x81, 0x02, 0x83, 0x04, 0x85, 0x06, 0x87,
	    0x08, 0x89, 0x0a, 0x8b, 0x0c, 0x8d, 0x0e, 0x8f  },
	{ 0x00, 0x90, 0x20, 0xb0, 0x40, 0xd0, 0x60, 0xf0,
	    0x80, 0x10, 0xa0, 0x30, 0xc0, 0x50, 0xe0, 0x70  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{ 0x00, 0xd9, 0xb2, 0x6b, 0x64, 0xbd, 0xd6, 0x0f,
	    0xc8, 0x11, 0x7a, 0xa3, 0xac, 0x75, 0x1e, 0xc7  },
	{ 0x00, 0x81, 0x02, 0x83, 0x04, 0x85, 0x06, 0x87,
	    0x15, 0x94, 0x17, 0x96, 0x11, 0x90, 0x13, 0x92  },
	{ 0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60,
	    0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{ 0x00, 0xda, 0xb4, 0x6e, 0x68, 0xb2, 0xdc, 0x06,
	    0xd0, 0x0a, 0x64, 0xbe, 0xb8, 0x62, 0x0c, 0xd6  },
	{ 0x00, 0x81, 0x02, 0x83, 0x04, 0x85, 0x06, 0x87,
	    0x15, 0x94, 0x17, 0x96, 0x11, 0x90, 0x13, 0x92  },
	{ 0x00, 0xb0, 0x60, 0xd0, 0xc0, 0x70, 0xa0, 0x10,
	    0x80, 0x30, 0xe0, 0x50, 0x40, 0xf0, 0x20, 0x90  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{ 0x00, 0xdb, 0xb6, 0x6d, 0x6c, 0xb7, 0xda, 0x01,
	    0xd8, 0x03, 0x6e, 0xb5, 0xb4, 0x6f, 0x02, 0xd9  },
	{ 0x00, 0x81, 0x02, 0x83, 0x19, 0x98, 0x1b, 0x9a,
	    0x32, 0xb3, 0x30, 0xb1, 0x2b, 0xaa, 0x29, 0xa8  },
	{ 0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40,
	    0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{ 0x00, 0xdc, 0xb8, 0x64, 0x70, 0xac, 0xc8, 0x14,
	    0xe0, 0x3c, 0x58, 0x84, 0x90, 0x4c, 0x28, 0xf4  },
	{ 0x00, 0x81, 0x02, 0x83, 0x19, 0x98, 0x1b, 0x9a,
	    0x32, 0xb3, 0x30, 0xb1, 0x2b, 0xaa, 0x29, 0xa8  },
	{ 0x00, 0xd0, 0xa0, 0x70, 0x40, 0x90, 0xe0, 0x30,
	    0x80, 0x50, 0x20, 0xf0, 0xc0, 0x10, 0x60, 0xb0  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{ 0x00, 0xdd, 0xba, 0x67, 0x74, 0xa9, 0xce, 0x13,
	    0xe8, 0x35, 0x52, 0x8f, 0x9c, 0x41, 0x26, 0xfb  },
	{ 0x00, 0x81, 0x02, 0x83, 0x19, 0x98, 0x1b, 0x9a,
	    0x2f, 0xae, 0x2d, 0xac, 0x36, 0xb7, 0x34, 0xb5  },
	{ 0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0,
	    0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{ 0x00, 0xde, 0xbc, 0x62, 0x78, 0xa6, 0xc4, 0x1a,
	    0xf0, 0x2e, 0x4c, 0x92, 0x88, 0x56, 0x34, 0xea  },
	{ 0x00, 0x81, 0x02, 0x83, 0x19, 0x98, 0x1b, 0x9a,
	    0x2f, 0xae, 0x2d, 0xac, 0x36, 0xb7, 0x34, 0xb5  },
	{ 0x00, 0xf0, 0xe0, 0x10, 0xc0, 0x30, 0x20, 0xd0,
	    0x80, 0x70, 0x60, 0x90, 0x40, 0xb0, 0xa0, 0x50  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{ 0x00, 0xdf, 0xbe, 0x61, 0x7c, 0xa3, 0xc2, 0x1d,
	    0xf8, 0x27, 0x46, 0x99, 0x84, 0x5b, 0x3a, 0xe5  },
	{ 0x00, 0xa6, 0x51, 0xf7, 0xa2, 0x04, 0xf3, 0x55,
	    0x59, 0xff, 0x08, 0xae, 0xfb, 0x5d, 0xaa, 0x0c  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{ 0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0,
	    0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0  },
	{ 0x00, 0xa6, 0x51, 0xf7, 0xa2, 0x04, 0xf3, 0x55,
	    0x59, 0xff, 0x08, 0xae, 0xfb, 0x5d, 0xaa, 0x0c  },
	{ 0x00, 0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70,
	    0x80, 0x90, 0xa0, 0xb0, 0xc0, 0xd0, 0xe0, 0xf0  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{ 0x00, 0xe1, 0xc2, 0x23, 0x84, 0x65, 0x46, 0xa7,
	    0x08, 0xe9, 0xca, 0x2b, 0x8c, 0x6d, 0x4e, 0xaf  },
	{ 0x00, 0xa6, 0x51, 0xf7, 0xa2, 0x04, 0xf3, 0x55,
	    0x44, 0xe2, 0x15, 0xb3, 0xe6, 0x40, 0xb7, 0x11  },
	{ 0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0,
	    0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{ 0x00, 0xe2, 0xc4, 0x26, 0x88, 0x6a, 0x4c, 0xae,
	    0x10, 0xf2, 0xd4, 0x36, 0x98, 0x7a, 0x5c, 0xbe  },
	{ 0x00, 0xa6, 0x51, 0xf7, 0xa2, 0x04, 0xf3, 0x55,
	    0x44, 0xe2, 0x15, 0xb3, 0xe6, 0x40, 0xb7, 0x11  },
	{ 0x00, 0x30, 0x60, 0x50, 0xc0, 0xf0, 0xa0, 0x90,
	    0x80, 0xb0, 0xe0, 0xd0, 0x40, 0x70, 0x20, 0x10  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{ 0x00, 0xe3, 0xc6, 0x25, 0x8c, 0x6f, 0x4a, 0xa9,
	    0x18, 0xfb, 0xde, 0x3d, 0x94, 0x77, 0x52, 0xb1  },
	{ 0x00, 0xa6, 0x51, 0xf7, 0xbf, 0x19, 0xee, 0x48,
	    0x63, 0xc5, 0x32, 0x94, 0xdc, 0x7a, 0x8d, 0x2b  },
	{ 0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0,
	    0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{ 0x00, 0xe4, 0xc8, 0x2c, 0x90, 0x74, 0x58, 0xbc,
	    0x20, 0xc4, 0xe8, 0x0c, 0xb0, 0x54, 0x78, 0x9c  },
	{ 0x00, 0xa6, 0x51, 0xf7, 0xbf, 0x19, 0xee, 0x48,
	    0x63, 0xc5, 0x32, 0x94, 0xdc, 0x7a, 0x8d, 0x2b  },
	{ 0x00, 0x50, 0xa0, 0xf0, 0x40, 0x10, 0xe0, 0xb0,
	    0x80, 0xd0, 0x20, 0x70, 0xc0, 0x90, 0x60, 0x30  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{ 0x00, 0xe5, 0xca, 0x2f, 0x94, 0x71, 0x5e, 0xbb,
	    0x28, 0xcd, 0xe2, 0x07, 0xbc, 0x59, 0x76, 0x93  },
	{ 0x00, 0xa6, 0x51, 0xf7, 0xbf, 0x19, 0xee, 0x48,
	    0x7e, 0xd8, 0x2f, 0x89, 0xc1, 0x67, 0x90, 0x36  },
	{ 0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20,
	    0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{ 0x00, 0xe6, 0xcc, 0x2a, 0x98, 0x7e, 0x54, 0xb2,
	    0x30, 0xd6, 0xfc, 0x1a, 0xa8, 0x4e, 0x64, 0x82  },
	{ 0x00, 0xa6, 0x51, 0xf7, 0xbf, 0x19, 0xee, 0x48,
	    0x7e, 0xd8, 0x2f, 0x89, 0xc1, 0x67, 0x90, 0x36  },
	{ 0x00, 0x70, 0xe0, 0x90, 0xc0, 0xb0, 0x20, 0x50,
	    0x80, 0xf0, 0x60, 0x10, 0x40, 0x30, 0xa0, 0xd0  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{ 0x00, 0xe7, 0xce, 0x29, 0x9c, 0x7b, 0x52, 0xb5,
	    0x38, 0xdf, 0xf6, 0x11, 0xa4, 0x43, 0x6a, 0x8d  },
	{ 0x00, 0xa6, 0x4c, 0xea, 0x98, 0x3e, 0xd4, 0x72,
	    0x2d, 0x8b, 0x61, 0xc7, 0xb5, 0x13, 0xf9, 0x5f  },
	{ 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80,
	    0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{ 0x00, 0xe8, 0xd0, 0x38, 0xa0, 0x48, 0x70, 0x98,
	    0x40, 0xa8, 0x90, 0x78, 0xe0, 0x08, 0x30, 0xd8  },
	{ 0x00, 0xa6, 0x4c, 0xea, 0x98, 0x3e, 0xd4, 0x72,
	    0x2d, 0x8b, 0x61, 0xc7, 0xb5, 0x13, 0xf9, 0x5f  },
	{ 0x00, 0x90, 0x20, 0xb0, 0x40, 0xd0, 0x60, 0xf0,
	    0x80, 0x10, 0xa0, 0x30, 0xc0, 0x50, 0xe0, 0x70  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{ 0x00, 0xe9, 0xd2, 0x3b, 0xa4, 0x4d, 0x76, 0x9f,
	    0x48, 0xa1, 0x9a, 0x73, 0xec, 0x05, 0x3e, 0xd7  },
	{ 0x00, 0xa6, 0x4c, 0xea, 0x98, 0x3e, 0xd4, 0x72,
	    0x30, 0x96, 0x7c, 0xda, 0xa8, 0x0e, 0xe4, 0x42  },
	{ 0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60,
	    0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{ 0x00, 0xea, 0xd4, 0x3e, 0xa8, 0x42, 0x7c, 0x96,
	    0x50, 0xba, 0x84, 0x6e, 0xf8, 0x12, 0x2c, 0xc6  },
	{ 0x00, 0xa6, 0x4c, 0xea, 0x98, 0x3e, 0xd4, 0x72,
	    0x30, 0x96, 0x7c, 0xda, 0xa8, 0x0e, 0xe4, 0x42  },
	{ 0x00, 0xb0, 0x60, 0xd0, 0xc0, 0x70, 0xa0, 0x10,
	    0x80, 0x30, 0xe0, 0x50, 0x40, 0xf0, 0x20, 0x90  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{ 0x00, 0xeb, 0xd6, 0x3d, 0xac, 0x47, 0x7a, 0x91,
	    0x58, 0xb3, 0x8e, 0x65, 0xf4, 0x1f, 0x22, 0xc9  },
	{ 0x00, 0xa6, 0x4c, 0xea, 0x85, 0x23, 0xc9, 0x6f,
	    0x17, 0xb1, 0x5b, 0xfd, 0x92, 0x34, 0xde, 0x78  },
	{ 0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40,
	    0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{ 0x00, 0xec, 0xd8, 0x34, 0xb0, 0x5c, 0x68, 0x84,
	    0x60, 0x8c, 0xb8, 0x54, 0xd0, 0x3c, 0x08, 0xe4  },
	{ 0x00, 0xa6, 0x4c, 0xea, 0x85, 0x23, 0xc9, 0x6f,
	    0x17, 0xb1, 0x5b, 0xfd, 0x92, 0x34, 0xde, 0x78  },
	{ 0x00, 0xd0, 0xa0, 0x70, 0x40, 0x90, 0xe0, 0x30,
	    0x80, 0x50, 0x20, 0xf0, 0xc0, 0x10, 0x60, 0xb0  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{ 0x00, 0xed, 0xda, 0x37, 0xb4, 0x59, 0x6e, 0x83,
	    0x68, 0x85, 0xb2, 0x5f, 0xdc, 0x31, 0x06, 0xeb  },
	{ 0x00, 0xa6, 0x4c, 0xea, 0x85, 0x23, 0xc9, 0x6f,
	    0x0a, 0xac, 0x46, 0xe0, 0x8f, 0x29, 0xc3, 0x65  },
	{ 0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0,
	    0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{ 0x00, 0xee, 0xdc, 0x32, 0xb8, 0x56, 0x64, 0x8a,
	    0x70, 0x9e, 0xac, 0x42, 0xc8, 0x26, 0x14, 0xfa  },
	{ 0x00, 0xa6, 0x4c, 0xea, 0x85, 0x23, 0xc9, 0x6f,
	    0x0a, 0xac, 0x46, 0xe0, 0x8f, 0x29, 0xc3, 0x65  },
	{ 0x00, 0xf0, 0xe0, 0x10, 0xc0, 0x30, 0x20, 0xd0,
	    0x80, 0x70, 0x60, 0x90, 0x40, 0xb0, 0xa0, 0x50  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{ 0x00, 0xef, 0xde, 0x31, 0xbc, 0x53, 0x62, 0x8d,
	    0x78, 0x97, 0xa6, 0x49, 0xc4, 0x2b, 0x1a, 0xf5  },
	{ 0x00, 0xbb, 0x6b, 0xd0, 0xd6, 0x6d, 0xbd, 0x06,
	    0xb1, 0x0a, 0xda, 0x61, 0x67, 0xdc, 0x0c, 0xb7  },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{ 0x00, 0xf0, 0xe0, 0x10, 0xc0, 0x30, 0x20, 0xd0,
	    0x80, 0x70, 0x60, 0x90, 0x40, 0xb0, 0xa0, 0x50  },
	{ 0x00, 0xbb, 0x6b, 0xd0, 0xd6, 0x6d, 0xbd, 0x06,
	    0xb1, 0x0a, 0xda, 0x61, 0x67, 0xdc, 0x0c, 0xb7  },
	{ 0x00, 0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70,
	    0x80, 0x90, 0xa0, 0xb0, 0xc0, 0xd0, 0xe0, 0xf0  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{ 0x00, 0xf1, 0xe2, 0x13, 0xc4, 0x35, 0x26, 0xd7,
	    0x88, 0x79, 0x6a, 0x9b, 0x4c, 0xbd, 0xae, 0x5f  },
	{ 0x00, 0xbb, 0x6b, 0xd0, 0xd6, 0x6d, 0xbd, 0x06,
	    0xac, 0x17, 0xc7, 0x7c, 0x7a, 0xc1, 0x11, 0xaa  },
	{ 0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0,
	    0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{ 0x00, 0xf2, 0xe4, 0x16, 0xc8, 0x3a, 0x2c, 0xde,
	    0x90, 0x62, 0x74, 0x86, 0x58, 0xaa, 0xbc, 0x4e  },
	{ 0x00, 0xbb, 0x6b, 0xd0, 0xd6, 0x6d, 0xbd, 0x06,
	    0xac, 0x17, 0xc7, 0x7c, 0x7a, 0xc1, 0x11, 0xaa  },
	{ 0x00, 0x30, 0x60, 0x50, 0xc0, 0xf0, 0xa0, 0x90,
	    0x80, 0xb0, 0xe0, 0xd0, 0x40, 0x70, 0x20, 0x10  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{ 0x00, 0xf3, 0xe6, 0x15, 0xcc, 0x3f, 0x2a, 0xd9,
	    0x98, 0x6b, 0x7e, 0x8d, 0x54, 0xa7, 0xb2, 0x41  },
	{ 0x00, 0xbb, 0x6b, 0xd0, 0xcb, 0x70, 0xa0, 0x1b,
	    0x8b, 0x30, 0xe0, 0x5b, 0x40, 0xfb, 0x2b, 0x90  },
	{ 0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0,
	    0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{ 0x00, 0xf4, 0xe8, 0x1c, 0xd0, 0x24, 0x38, 0xcc,
	    0xa0, 0x54, 0x48, 0xbc, 0x70, 0x84, 0x98, 0x6c  },
	{ 0x00, 0xbb, 0x6b, 0xd0, 0xcb, 0x70, 0xa0, 0x1b,
	    0x8b, 0x30, 0xe0, 0x5b, 0x40, 0xfb, 0x2b, 0x90  },
	{ 0x00, 0x50, 0xa0, 0xf0, 0x40, 0x10, 0xe0, 0xb0,
	    0x80, 0xd0, 0x20, 0x70, 0xc0, 0x90, 0x60, 0x30  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{ 0x00, 0xf5, 0xea, 0x1f, 0xd4, 0x21, 0x3e, 0xcb,
	    0xa8, 0x5d, 0x42, 0xb7, 0x7c, 0x89, 0x96, 0x63  },
	{ 0x00, 0xbb, 0x6b, 0xd0, 0xcb, 0x70, 0xa0, 0x1b,
	    0x96, 0x2d, 0xfd, 0x46, 0x5d, 0xe6, 0x36, 0x8d  },
	{ 0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20,
	    0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{ 0x00, 0xf6, 0xec, 0x1a, 0xd8, 0x2e, 0x34, 0xc2,
	    0xb0, 0x46, 0x5c, 0xaa, 0x68, 0x9e, 0x84, 0x72  },
	{ 0x00, 0xbb, 0x6b, 0xd0, 0xcb, 0x70, 0xa0, 0x1b,
	    0x96, 0x2d, 0xfd, 0x46, 0x5d, 0xe6, 0x36, 0x8d  },
	{ 0x00, 0x70, 0xe0, 0x90, 0xc0, 0xb0, 0x20, 0x50,
	    0x80, 0xf0, 0x60, 0x10, 0x40, 0x30, 0xa0, 0xd0  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{ 0x00, 0xf7, 0xee, 0x19, 0xdc, 0x2b, 0x32, 0xc5,
	    0xb8, 0x4f, 0x56, 0xa1, 0x64, 0x93, 0x8a, 0x7d  },
	{ 0x00, 0xbb, 0x76, 0xcd, 0xec, 0x57, 0x9a, 0x21,
	    0xc5, 0x7e, 0xb3, 0x08, 0x29, 0x92, 0x5f, 0xe4  },
	{ 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80,
	    0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{ 0x00, 0xf8, 0xf0, 0x08, 0xe0, 0x18, 0x10, 0xe8,
	    0xc0, 0x38, 0x30, 0xc8, 0x20, 0xd8, 0xd0, 0x28  },
	{ 0x00, 0xbb, 0x76, 0xcd, 0xec, 0x57, 0x9a, 0x21,
	    0xc5, 0x7e, 0xb3, 0x08, 0x29, 0x92, 0x5f, 0xe4  },
	{ 0x00, 0x90, 0x20, 0xb0, 0x40, 0xd0, 0x60, 0xf0,
	    0x80, 0x10, 0xa0, 0x30, 0xc0, 0x50, 0xe0, 0x70  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{ 0x00, 0xf9, 0xf2, 0x0b, 0xe4, 0x1d, 0x16, 0xef,
	    0xc8, 0x31, 0x3a, 0xc3, 0x2c, 0xd5, 0xde, 0x27  },
	{ 0x00, 0xbb, 0x76, 0xcd, 0xec, 0x57, 0x9a, 0x21,
	    0xd8, 0x63, 0xae, 0x15, 0x34, 0x8f, 0x42, 0xf9  },
	{ 0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60,
	    0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{ 0x00, 0xfa, 0xf4, 0x0e, 0xe8, 0x12, 0x1c, 0xe6,
	    0xd0, 0x2a, 0x24, 0xde, 0x38, 0xc2, 0xcc, 0x36  },
	{ 0x00, 0xbb, 0x76, 0xcd, 0xec, 0x57, 0x9a, 0x21,
	    0xd8, 0x63, 0xae, 0x15, 0x34, 0x8f, 0x42, 0xf9  },
	{ 0x00, 0xb0, 0x60, 0xd0, 0xc0, 0x70, 0xa0, 0x10,
	    0x80, 0x30, 0xe0, 0x50, 0x40, 0xf0, 0x20, 0x90  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{ 0x00, 0xfb, 0xf6, 0x0d, 0xec, 0x17, 0x1a, 0xe1,
	    0xd8, 0x23, 0x2e, 0xd5, 0x34, 0xcf, 0xc2, 0x39  },
	{ 0x00, 0xbb, 0x76, 0xcd, 0xf1, 0x4a, 0x87, 0x3c,
	    0xff, 0x44, 0x89, 0x32, 0x0e, 0xb5, 0x78, 0xc3  },
	{ 0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40,
	    0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{ 0x00, 0xfc, 0xf8, 0x04, 0xf0, 0x0c, 0x08, 0xf4,
	    0xe0, 0x1c, 0x18, 0xe4, 0x10, 0xec, 0xe8, 0x14  },
	{ 0x00, 0xbb, 0x76, 0xcd, 0xf1, 0x4a, 0x87, 0x3c,
	    0xff, 0x44, 0x89, 0x32, 0x0e, 0xb5, 0x78, 0xc3  },
	{ 0x00, 0xd0, 0xa0, 0x70, 0x40, 0x90, 0xe0, 0x30,
	    0x80, 0x50, 0x20, 0xf0, 0xc0, 0x10, 0x60, 0xb0  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{ 0x00, 0xfd, 0xfa, 0x07, 0xf4, 0x09, 0x0e, 0xf3,
	    0xe8, 0x15, 0x12, 0xef, 0x1c, 0xe1, 0xe6, 0x1b  },
	{ 0x00, 0xbb, 0x76, 0xcd, 0xf1, 0x4a, 0x87, 0x3c,
	    0xe2, 0x59, 0x94, 0x2f, 0x13, 0xa8, 0x65, 0xde  },
	{ 0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0,
	    0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{ 0x00, 0xfe, 0xfc, 0x02, 0xf8, 0x06, 0x04, 0xfa,
	    0xf0, 0x0e, 0x0c, 0xf2, 0x08, 0xf6, 0xf4, 0x0a  },
	{ 0x00, 0xbb, 0x76, 0xcd, 0xf1, 0x4a, 0x87, 0x3c,
	    0xe2, 0x59, 0x94, 0x2f, 0x13, 0xa8, 0x65, 0xde  },
	{ 0x00, 0xf0, 0xe0, 0x10, 0xc0, 0x30, 0x20, 0xd0,
	    0x80, 0x70, 0x60, 0x90, 0x40, 0xb0, 0xa0, 0x50  },
	{ 0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
	    0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{ 0x00, 0xff, 0xfe, 0x01, 0xfc, 0x03, 0x02, 0xfd,
	    0xf8, 0x07, 0x06, 0xf9, 0x04, 0xfb, 0xfa, 0x05  }
};
/* END CSTYLED */
#endif /* defined(HAVE_SSSE3) || defined(HAVE_AVX2) || defined(HAVE_AVX512BW) */
#endif /* defined(__x86_64) */
