/*
 * Data for approximation of erff.
 *
 * Copyright (c) 2023, Arm Limited.
 * SPDX-License-Identifier: MIT OR Apache-2.0 WITH LLVM-exception
 */

#include "math_config.h"

/* Lookup table used in erff.
   For each possible rounded input r (multiples of 1/128), between
   r = 0.0 and r = 4.0 (513 values):
   - the first entry __erff_data.tab.erf contains the values of erf(r),
   - the second entry __erff_data.tab.scale contains the values of
   2/sqrt(pi)*exp(-r^2). Note that indices 0 and 1 are never hit by the
   algorithm, since lookup is performed only for x >= 1/64-1/512.  */
const struct erff_data __erff_data = {
  .tab = { { 0x0.000000p+0, 0x1.20dd76p+0 },
	   { 0x1.20dbf4p-7, 0x1.20d8f2p+0 },
	   { 0x1.20d770p-6, 0x1.20cb68p+0 },
	   { 0x1.b137e0p-6, 0x1.20b4d8p+0 },
	   { 0x1.20c564p-5, 0x1.209546p+0 },
	   { 0x1.68e5d4p-5, 0x1.206cb4p+0 },
	   { 0x1.b0fafep-5, 0x1.203b26p+0 },
	   { 0x1.f902a8p-5, 0x1.2000a0p+0 },
	   { 0x1.207d48p-4, 0x1.1fbd28p+0 },
	   { 0x1.44703ep-4, 0x1.1f70c4p+0 },
	   { 0x1.68591ap-4, 0x1.1f1b7ap+0 },
	   { 0x1.8c36bep-4, 0x1.1ebd56p+0 },
	   { 0x1.b00812p-4, 0x1.1e565cp+0 },
	   { 0x1.d3cbf8p-4, 0x1.1de698p+0 },
	   { 0x1.f7815ap-4, 0x1.1d6e14p+0 },
	   { 0x1.0d9390p-3, 0x1.1cecdcp+0 },
	   { 0x1.1f5e1ap-3, 0x1.1c62fap+0 },
	   { 0x1.311fc2p-3, 0x1.1bd07cp+0 },
	   { 0x1.42d7fcp-3, 0x1.1b3572p+0 },
	   { 0x1.548642p-3, 0x1.1a91e6p+0 },
	   { 0x1.662a0cp-3, 0x1.19e5eap+0 },
	   { 0x1.77c2d2p-3, 0x1.19318cp+0 },
	   { 0x1.895010p-3, 0x1.1874dep+0 },
	   { 0x1.9ad142p-3, 0x1.17aff0p+0 },
	   { 0x1.ac45e4p-3, 0x1.16e2d8p+0 },
	   { 0x1.bdad72p-3, 0x1.160da4p+0 },
	   { 0x1.cf076ep-3, 0x1.153068p+0 },
	   { 0x1.e05354p-3, 0x1.144b3cp+0 },
	   { 0x1.f190aap-3, 0x1.135e30p+0 },
	   { 0x1.015f78p-2, 0x1.12695ep+0 },
	   { 0x1.09eed6p-2, 0x1.116cd8p+0 },
	   { 0x1.127632p-2, 0x1.1068bap+0 },
	   { 0x1.1af54ep-2, 0x1.0f5d16p+0 },
	   { 0x1.236bf0p-2, 0x1.0e4a08p+0 },
	   { 0x1.2bd9dcp-2, 0x1.0d2fa6p+0 },
	   { 0x1.343ed6p-2, 0x1.0c0e0ap+0 },
	   { 0x1.3c9aa8p-2, 0x1.0ae550p+0 },
	   { 0x1.44ed18p-2, 0x1.09b590p+0 },
	   { 0x1.4d35f0p-2, 0x1.087ee4p+0 },
	   { 0x1.5574f4p-2, 0x1.07416cp+0 },
	   { 0x1.5da9f4p-2, 0x1.05fd3ep+0 },
	   { 0x1.65d4b8p-2, 0x1.04b27cp+0 },
	   { 0x1.6df50ap-2, 0x1.036140p+0 },
	   { 0x1.760abap-2, 0x1.0209a6p+0 },
	   { 0x1.7e1594p-2, 0x1.00abd0p+0 },
	   { 0x1.861566p-2, 0x1.fe8fb0p-1 },
	   { 0x1.8e0a02p-2, 0x1.fbbbbep-1 },
	   { 0x1.95f336p-2, 0x1.f8dc0ap-1 },
	   { 0x1.9dd0d2p-2, 0x1.f5f0cep-1 },
	   { 0x1.a5a2acp-2, 0x1.f2fa4cp-1 },
	   { 0x1.ad6896p-2, 0x1.eff8c4p-1 },
	   { 0x1.b52264p-2, 0x1.ecec78p-1 },
	   { 0x1.bccfecp-2, 0x1.e9d5a8p-1 },
	   { 0x1.c47104p-2, 0x1.e6b498p-1 },
	   { 0x1.cc0584p-2, 0x1.e38988p-1 },
	   { 0x1.d38d44p-2, 0x1.e054bep-1 },
	   { 0x1.db081cp-2, 0x1.dd167cp-1 },
	   { 0x1.e275eap-2, 0x1.d9cf06p-1 },
	   { 0x1.e9d68ap-2, 0x1.d67ea2p-1 },
	   { 0x1.f129d4p-2, 0x1.d32592p-1 },
	   { 0x1.f86faap-2, 0x1.cfc41ep-1 },
	   { 0x1.ffa7eap-2, 0x1.cc5a8ap-1 },
	   { 0x1.03693ap-1, 0x1.c8e91cp-1 },
	   { 0x1.06f794p-1, 0x1.c5701ap-1 },
	   { 0x1.0a7ef6p-1, 0x1.c1efcap-1 },
	   { 0x1.0dff50p-1, 0x1.be6872p-1 },
	   { 0x1.117894p-1, 0x1.bada5ap-1 },
	   { 0x1.14eab4p-1, 0x1.b745c6p-1 },
	   { 0x1.1855a6p-1, 0x1.b3aafcp-1 },
	   { 0x1.1bb95cp-1, 0x1.b00a46p-1 },
	   { 0x1.1f15ccp-1, 0x1.ac63e8p-1 },
	   { 0x1.226ae8p-1, 0x1.a8b828p-1 },
	   { 0x1.25b8a8p-1, 0x1.a5074ep-1 },
	   { 0x1.28ff02p-1, 0x1.a1519ep-1 },
	   { 0x1.2c3decp-1, 0x1.9d9762p-1 },
	   { 0x1.2f755cp-1, 0x1.99d8dap-1 },
	   { 0x1.32a54cp-1, 0x1.961650p-1 },
	   { 0x1.35cdb4p-1, 0x1.925008p-1 },
	   { 0x1.38ee8ap-1, 0x1.8e8646p-1 },
	   { 0x1.3c07cap-1, 0x1.8ab950p-1 },
	   { 0x1.3f196ep-1, 0x1.86e96ap-1 },
	   { 0x1.42236ep-1, 0x1.8316d6p-1 },
	   { 0x1.4525c8p-1, 0x1.7f41dcp-1 },
	   { 0x1.482074p-1, 0x1.7b6abcp-1 },
	   { 0x1.4b1372p-1, 0x1.7791b8p-1 },
	   { 0x1.4dfebap-1, 0x1.73b714p-1 },
	   { 0x1.50e24cp-1, 0x1.6fdb12p-1 },
	   { 0x1.53be26p-1, 0x1.6bfdf0p-1 },
	   { 0x1.569244p-1, 0x1.681ff2p-1 },
	   { 0x1.595ea6p-1, 0x1.644156p-1 },
	   { 0x1.5c2348p-1, 0x1.60625cp-1 },
	   { 0x1.5ee02ep-1, 0x1.5c8342p-1 },
	   { 0x1.619556p-1, 0x1.58a446p-1 },
	   { 0x1.6442c0p-1, 0x1.54c5a6p-1 },
	   { 0x1.66e86ep-1, 0x1.50e79ep-1 },
	   { 0x1.69865ep-1, 0x1.4d0a68p-1 },
	   { 0x1.6c1c98p-1, 0x1.492e42p-1 },
	   { 0x1.6eab18p-1, 0x1.455366p-1 },
	   { 0x1.7131e6p-1, 0x1.417a0cp-1 },
	   { 0x1.73b102p-1, 0x1.3da26ep-1 },
	   { 0x1.762870p-1, 0x1.39ccc2p-1 },
	   { 0x1.789836p-1, 0x1.35f940p-1 },
	   { 0x1.7b0058p-1, 0x1.32281ep-1 },
	   { 0x1.7d60d8p-1, 0x1.2e5992p-1 },
	   { 0x1.7fb9c0p-1, 0x1.2a8dcep-1 },
	   { 0x1.820b12p-1, 0x1.26c508p-1 },
	   { 0x1.8454d6p-1, 0x1.22ff72p-1 },
	   { 0x1.869712p-1, 0x1.1f3d3cp-1 },
	   { 0x1.88d1cep-1, 0x1.1b7e98p-1 },
	   { 0x1.8b050ep-1, 0x1.17c3b6p-1 },
	   { 0x1.8d30dep-1, 0x1.140cc4p-1 },
	   { 0x1.8f5544p-1, 0x1.1059eep-1 },
	   { 0x1.91724ap-1, 0x1.0cab62p-1 },
	   { 0x1.9387f6p-1, 0x1.09014cp-1 },
	   { 0x1.959652p-1, 0x1.055bd6p-1 },
	   { 0x1.979d68p-1, 0x1.01bb2cp-1 },
	   { 0x1.999d42p-1, 0x1.fc3ee6p-2 },
	   { 0x1.9b95e8p-1, 0x1.f511aap-2 },
	   { 0x1.9d8768p-1, 0x1.edeeeep-2 },
	   { 0x1.9f71cap-1, 0x1.e6d700p-2 },
	   { 0x1.a1551ap-1, 0x1.dfca26p-2 },
	   { 0x1.a33162p-1, 0x1.d8c8aap-2 },
	   { 0x1.a506b0p-1, 0x1.d1d2d0p-2 },
	   { 0x1.a6d50cp-1, 0x1.cae8dap-2 },
	   { 0x1.a89c86p-1, 0x1.c40b08p-2 },
	   { 0x1.aa5d26p-1, 0x1.bd3998p-2 },
	   { 0x1.ac16fcp-1, 0x1.b674c8p-2 },
	   { 0x1.adca14p-1, 0x1.afbcd4p-2 },
	   { 0x1.af767ap-1, 0x1.a911f0p-2 },
	   { 0x1.b11c3cp-1, 0x1.a27456p-2 },
	   { 0x1.b2bb68p-1, 0x1.9be438p-2 },
	   { 0x1.b4540ap-1, 0x1.9561c8p-2 },
	   { 0x1.b5e630p-1, 0x1.8eed36p-2 },
	   { 0x1.b771e8p-1, 0x1.8886b2p-2 },
	   { 0x1.b8f742p-1, 0x1.822e66p-2 },
	   { 0x1.ba764ap-1, 0x1.7be47ap-2 },
	   { 0x1.bbef10p-1, 0x1.75a91ap-2 },
	   { 0x1.bd61a2p-1, 0x1.6f7c6ap-2 },
	   { 0x1.bece0ep-1, 0x1.695e8cp-2 },
	   { 0x1.c03464p-1, 0x1.634fa6p-2 },
	   { 0x1.c194b2p-1, 0x1.5d4fd4p-2 },
	   { 0x1.c2ef08p-1, 0x1.575f34p-2 },
	   { 0x1.c44376p-1, 0x1.517de6p-2 },
	   { 0x1.c5920ap-1, 0x1.4bac00p-2 },
	   { 0x1.c6dad2p-1, 0x1.45e99cp-2 },
	   { 0x1.c81de2p-1, 0x1.4036d0p-2 },
	   { 0x1.c95b46p-1, 0x1.3a93b2p-2 },
	   { 0x1.ca930ep-1, 0x1.350052p-2 },
	   { 0x1.cbc54cp-1, 0x1.2f7cc4p-2 },
	   { 0x1.ccf20cp-1, 0x1.2a0916p-2 },
	   { 0x1.ce1962p-1, 0x1.24a554p-2 },
	   { 0x1.cf3b5cp-1, 0x1.1f518ap-2 },
	   { 0x1.d0580cp-1, 0x1.1a0dc6p-2 },
	   { 0x1.d16f7ep-1, 0x1.14da0ap-2 },
	   { 0x1.d281c4p-1, 0x1.0fb662p-2 },
	   { 0x1.d38ef0p-1, 0x1.0aa2d0p-2 },
	   { 0x1.d49710p-1, 0x1.059f5ap-2 },
	   { 0x1.d59a34p-1, 0x1.00ac00p-2 },
	   { 0x1.d6986cp-1, 0x1.f79184p-3 },
	   { 0x1.d791cap-1, 0x1.edeb40p-3 },
	   { 0x1.d8865ep-1, 0x1.e46530p-3 },
	   { 0x1.d97636p-1, 0x1.daff4ap-3 },
	   { 0x1.da6162p-1, 0x1.d1b982p-3 },
	   { 0x1.db47f4p-1, 0x1.c893cep-3 },
	   { 0x1.dc29fcp-1, 0x1.bf8e1cp-3 },
	   { 0x1.dd0788p-1, 0x1.b6a856p-3 },
	   { 0x1.dde0aap-1, 0x1.ade26cp-3 },
	   { 0x1.deb570p-1, 0x1.a53c42p-3 },
	   { 0x1.df85eap-1, 0x1.9cb5bep-3 },
	   { 0x1.e0522ap-1, 0x1.944ec2p-3 },
	   { 0x1.e11a3ep-1, 0x1.8c0732p-3 },
	   { 0x1.e1de36p-1, 0x1.83deeap-3 },
	   { 0x1.e29e22p-1, 0x1.7bd5c8p-3 },
	   { 0x1.e35a12p-1, 0x1.73eba4p-3 },
	   { 0x1.e41214p-1, 0x1.6c2056p-3 },
	   { 0x1.e4c638p-1, 0x1.6473b6p-3 },
	   { 0x1.e5768cp-1, 0x1.5ce596p-3 },
	   { 0x1.e62322p-1, 0x1.5575c8p-3 },
	   { 0x1.e6cc08p-1, 0x1.4e241ep-3 },
	   { 0x1.e7714ap-1, 0x1.46f066p-3 },
	   { 0x1.e812fcp-1, 0x1.3fda6cp-3 },
	   { 0x1.e8b12ap-1, 0x1.38e1fap-3 },
	   { 0x1.e94be4p-1, 0x1.3206dcp-3 },
	   { 0x1.e9e336p-1, 0x1.2b48dap-3 },
	   { 0x1.ea7730p-1, 0x1.24a7b8p-3 },
	   { 0x1.eb07e2p-1, 0x1.1e233ep-3 },
	   { 0x1.eb9558p-1, 0x1.17bb2cp-3 },
	   { 0x1.ec1fa2p-1, 0x1.116f48p-3 },
	   { 0x1.eca6ccp-1, 0x1.0b3f52p-3 },
	   { 0x1.ed2ae6p-1, 0x1.052b0cp-3 },
	   { 0x1.edabfcp-1, 0x1.fe6460p-4 },
	   { 0x1.ee2a1ep-1, 0x1.f2a902p-4 },
	   { 0x1.eea556p-1, 0x1.e72372p-4 },
	   { 0x1.ef1db4p-1, 0x1.dbd32ap-4 },
	   { 0x1.ef9344p-1, 0x1.d0b7a0p-4 },
	   { 0x1.f00614p-1, 0x1.c5d04ap-4 },
	   { 0x1.f07630p-1, 0x1.bb1c98p-4 },
	   { 0x1.f0e3a6p-1, 0x1.b09bfcp-4 },
	   { 0x1.f14e82p-1, 0x1.a64de6p-4 },
	   { 0x1.f1b6d0p-1, 0x1.9c31c6p-4 },
	   { 0x1.f21ca0p-1, 0x1.92470ap-4 },
	   { 0x1.f27ff8p-1, 0x1.888d1ep-4 },
	   { 0x1.f2e0eap-1, 0x1.7f036cp-4 },
	   { 0x1.f33f7ep-1, 0x1.75a960p-4 },
	   { 0x1.f39bc2p-1, 0x1.6c7e64p-4 },
	   { 0x1.f3f5c2p-1, 0x1.6381e2p-4 },
	   { 0x1.f44d88p-1, 0x1.5ab342p-4 },
	   { 0x1.f4a31ep-1, 0x1.5211ecp-4 },
	   { 0x1.f4f694p-1, 0x1.499d48p-4 },
	   { 0x1.f547f2p-1, 0x1.4154bcp-4 },
	   { 0x1.f59742p-1, 0x1.3937b2p-4 },
	   { 0x1.f5e490p-1, 0x1.31458ep-4 },
	   { 0x1.f62fe8p-1, 0x1.297dbap-4 },
	   { 0x1.f67952p-1, 0x1.21df9ap-4 },
	   { 0x1.f6c0dcp-1, 0x1.1a6a96p-4 },
	   { 0x1.f7068cp-1, 0x1.131e14p-4 },
	   { 0x1.f74a6ep-1, 0x1.0bf97ep-4 },
	   { 0x1.f78c8cp-1, 0x1.04fc3ap-4 },
	   { 0x1.f7cceep-1, 0x1.fc4b5ep-5 },
	   { 0x1.f80ba2p-1, 0x1.eeea8cp-5 },
	   { 0x1.f848acp-1, 0x1.e1d4d0p-5 },
	   { 0x1.f8841ap-1, 0x1.d508fap-5 },
	   { 0x1.f8bdf2p-1, 0x1.c885e0p-5 },
	   { 0x1.f8f63ep-1, 0x1.bc4a54p-5 },
	   { 0x1.f92d08p-1, 0x1.b05530p-5 },
	   { 0x1.f96256p-1, 0x1.a4a54ap-5 },
	   { 0x1.f99634p-1, 0x1.99397ap-5 },
	   { 0x1.f9c8a8p-1, 0x1.8e109cp-5 },
	   { 0x1.f9f9bap-1, 0x1.83298ep-5 },
	   { 0x1.fa2974p-1, 0x1.78832cp-5 },
	   { 0x1.fa57dep-1, 0x1.6e1c58p-5 },
	   { 0x1.fa84fep-1, 0x1.63f3f6p-5 },
	   { 0x1.fab0dep-1, 0x1.5a08e8p-5 },
	   { 0x1.fadb84p-1, 0x1.505a18p-5 },
	   { 0x1.fb04f6p-1, 0x1.46e66cp-5 },
	   { 0x1.fb2d40p-1, 0x1.3dacd2p-5 },
	   { 0x1.fb5464p-1, 0x1.34ac36p-5 },
	   { 0x1.fb7a6cp-1, 0x1.2be38cp-5 },
	   { 0x1.fb9f60p-1, 0x1.2351c2p-5 },
	   { 0x1.fbc344p-1, 0x1.1af5d2p-5 },
	   { 0x1.fbe61ep-1, 0x1.12ceb4p-5 },
	   { 0x1.fc07fap-1, 0x1.0adb60p-5 },
	   { 0x1.fc28d8p-1, 0x1.031ad6p-5 },
	   { 0x1.fc48c2p-1, 0x1.f7182ap-6 },
	   { 0x1.fc67bcp-1, 0x1.e85c44p-6 },
	   { 0x1.fc85d0p-1, 0x1.da0006p-6 },
	   { 0x1.fca2fep-1, 0x1.cc0180p-6 },
	   { 0x1.fcbf52p-1, 0x1.be5ecep-6 },
	   { 0x1.fcdaccp-1, 0x1.b1160ap-6 },
	   { 0x1.fcf576p-1, 0x1.a4255ap-6 },
	   { 0x1.fd0f54p-1, 0x1.978ae8p-6 },
	   { 0x1.fd286ap-1, 0x1.8b44e6p-6 },
	   { 0x1.fd40bep-1, 0x1.7f5188p-6 },
	   { 0x1.fd5856p-1, 0x1.73af0cp-6 },
	   { 0x1.fd6f34p-1, 0x1.685bb6p-6 },
	   { 0x1.fd8562p-1, 0x1.5d55ccp-6 },
	   { 0x1.fd9ae2p-1, 0x1.529b9ep-6 },
	   { 0x1.fdafb8p-1, 0x1.482b84p-6 },
	   { 0x1.fdc3e8p-1, 0x1.3e03d8p-6 },
	   { 0x1.fdd77ap-1, 0x1.3422fep-6 },
	   { 0x1.fdea6ep-1, 0x1.2a875cp-6 },
	   { 0x1.fdfcccp-1, 0x1.212f62p-6 },
	   { 0x1.fe0e96p-1, 0x1.181984p-6 },
	   { 0x1.fe1fd0p-1, 0x1.0f443ep-6 },
	   { 0x1.fe3080p-1, 0x1.06ae14p-6 },
	   { 0x1.fe40a6p-1, 0x1.fcab14p-7 },
	   { 0x1.fe504cp-1, 0x1.ec7262p-7 },
	   { 0x1.fe5f70p-1, 0x1.dcaf36p-7 },
	   { 0x1.fe6e18p-1, 0x1.cd5ecap-7 },
	   { 0x1.fe7c46p-1, 0x1.be7e5ap-7 },
	   { 0x1.fe8a00p-1, 0x1.b00b38p-7 },
	   { 0x1.fe9748p-1, 0x1.a202bep-7 },
	   { 0x1.fea422p-1, 0x1.94624ep-7 },
	   { 0x1.feb090p-1, 0x1.87275ep-7 },
	   { 0x1.febc96p-1, 0x1.7a4f6ap-7 },
	   { 0x1.fec836p-1, 0x1.6dd7fep-7 },
	   { 0x1.fed374p-1, 0x1.61beaep-7 },
	   { 0x1.fede52p-1, 0x1.56011cp-7 },
	   { 0x1.fee8d4p-1, 0x1.4a9cf6p-7 },
	   { 0x1.fef2fep-1, 0x1.3f8ff6p-7 },
	   { 0x1.fefccep-1, 0x1.34d7dcp-7 },
	   { 0x1.ff064cp-1, 0x1.2a727ap-7 },
	   { 0x1.ff0f76p-1, 0x1.205dacp-7 },
	   { 0x1.ff1852p-1, 0x1.169756p-7 },
	   { 0x1.ff20e0p-1, 0x1.0d1d6ap-7 },
	   { 0x1.ff2924p-1, 0x1.03ede2p-7 },
	   { 0x1.ff3120p-1, 0x1.f60d8ap-8 },
	   { 0x1.ff38d6p-1, 0x1.e4cc4ap-8 },
	   { 0x1.ff4048p-1, 0x1.d4143ap-8 },
	   { 0x1.ff4778p-1, 0x1.c3e1a6p-8 },
	   { 0x1.ff4e68p-1, 0x1.b430ecp-8 },
	   { 0x1.ff551ap-1, 0x1.a4fe84p-8 },
	   { 0x1.ff5b90p-1, 0x1.9646f4p-8 },
	   { 0x1.ff61ccp-1, 0x1.8806d8p-8 },
	   { 0x1.ff67d0p-1, 0x1.7a3adep-8 },
	   { 0x1.ff6d9ep-1, 0x1.6cdfccp-8 },
	   { 0x1.ff7338p-1, 0x1.5ff276p-8 },
	   { 0x1.ff789ep-1, 0x1.536fc2p-8 },
	   { 0x1.ff7dd4p-1, 0x1.4754acp-8 },
	   { 0x1.ff82dap-1, 0x1.3b9e40p-8 },
	   { 0x1.ff87b2p-1, 0x1.30499cp-8 },
	   { 0x1.ff8c5cp-1, 0x1.2553eep-8 },
	   { 0x1.ff90dcp-1, 0x1.1aba78p-8 },
	   { 0x1.ff9532p-1, 0x1.107a8cp-8 },
	   { 0x1.ff9960p-1, 0x1.06918cp-8 },
	   { 0x1.ff9d68p-1, 0x1.f9f9d0p-9 },
	   { 0x1.ffa14ap-1, 0x1.e77448p-9 },
	   { 0x1.ffa506p-1, 0x1.d58da6p-9 },
	   { 0x1.ffa8a0p-1, 0x1.c4412cp-9 },
	   { 0x1.ffac18p-1, 0x1.b38a3ap-9 },
	   { 0x1.ffaf6ep-1, 0x1.a36454p-9 },
	   { 0x1.ffb2a6p-1, 0x1.93cb12p-9 },
	   { 0x1.ffb5bep-1, 0x1.84ba30p-9 },
	   { 0x1.ffb8b8p-1, 0x1.762d84p-9 },
	   { 0x1.ffbb98p-1, 0x1.682100p-9 },
	   { 0x1.ffbe5ap-1, 0x1.5a90b0p-9 },
	   { 0x1.ffc102p-1, 0x1.4d78bcp-9 },
	   { 0x1.ffc390p-1, 0x1.40d564p-9 },
	   { 0x1.ffc606p-1, 0x1.34a306p-9 },
	   { 0x1.ffc862p-1, 0x1.28de12p-9 },
	   { 0x1.ffcaa8p-1, 0x1.1d8318p-9 },
	   { 0x1.ffccd8p-1, 0x1.128ebap-9 },
	   { 0x1.ffcef4p-1, 0x1.07fdb4p-9 },
	   { 0x1.ffd0fap-1, 0x1.fb99b8p-10 },
	   { 0x1.ffd2eap-1, 0x1.e7f232p-10 },
	   { 0x1.ffd4cap-1, 0x1.d4fed8p-10 },
	   { 0x1.ffd696p-1, 0x1.c2b9d0p-10 },
	   { 0x1.ffd84ep-1, 0x1.b11d70p-10 },
	   { 0x1.ffd9f8p-1, 0x1.a02436p-10 },
	   { 0x1.ffdb90p-1, 0x1.8fc8c8p-10 },
	   { 0x1.ffdd18p-1, 0x1.8005f0p-10 },
	   { 0x1.ffde90p-1, 0x1.70d6a4p-10 },
	   { 0x1.ffdffap-1, 0x1.6235fcp-10 },
	   { 0x1.ffe154p-1, 0x1.541f34p-10 },
	   { 0x1.ffe2a2p-1, 0x1.468daep-10 },
	   { 0x1.ffe3e2p-1, 0x1.397ceep-10 },
	   { 0x1.ffe514p-1, 0x1.2ce898p-10 },
	   { 0x1.ffe63cp-1, 0x1.20cc76p-10 },
	   { 0x1.ffe756p-1, 0x1.15246ep-10 },
	   { 0x1.ffe866p-1, 0x1.09ec86p-10 },
	   { 0x1.ffe96ap-1, 0x1.fe41cep-11 },
	   { 0x1.ffea64p-1, 0x1.e97ba4p-11 },
	   { 0x1.ffeb54p-1, 0x1.d57f52p-11 },
	   { 0x1.ffec3ap-1, 0x1.c245d4p-11 },
	   { 0x1.ffed16p-1, 0x1.afc85ep-11 },
	   { 0x1.ffedeap-1, 0x1.9e0058p-11 },
	   { 0x1.ffeeb4p-1, 0x1.8ce75ep-11 },
	   { 0x1.ffef76p-1, 0x1.7c7744p-11 },
	   { 0x1.fff032p-1, 0x1.6caa0ep-11 },
	   { 0x1.fff0e4p-1, 0x1.5d79ecp-11 },
	   { 0x1.fff18ep-1, 0x1.4ee142p-11 },
	   { 0x1.fff232p-1, 0x1.40daa4p-11 },
	   { 0x1.fff2d0p-1, 0x1.3360ccp-11 },
	   { 0x1.fff366p-1, 0x1.266ea8p-11 },
	   { 0x1.fff3f6p-1, 0x1.19ff46p-11 },
	   { 0x1.fff480p-1, 0x1.0e0de8p-11 },
	   { 0x1.fff504p-1, 0x1.0295f0p-11 },
	   { 0x1.fff582p-1, 0x1.ef25d4p-12 },
	   { 0x1.fff5fcp-1, 0x1.da0110p-12 },
	   { 0x1.fff670p-1, 0x1.c5b542p-12 },
	   { 0x1.fff6dep-1, 0x1.b23a5ap-12 },
	   { 0x1.fff74ap-1, 0x1.9f8894p-12 },
	   { 0x1.fff7aep-1, 0x1.8d986ap-12 },
	   { 0x1.fff810p-1, 0x1.7c629ap-12 },
	   { 0x1.fff86cp-1, 0x1.6be022p-12 },
	   { 0x1.fff8c6p-1, 0x1.5c0a38p-12 },
	   { 0x1.fff91cp-1, 0x1.4cda54p-12 },
	   { 0x1.fff96cp-1, 0x1.3e4a24p-12 },
	   { 0x1.fff9bap-1, 0x1.305390p-12 },
	   { 0x1.fffa04p-1, 0x1.22f0b4p-12 },
	   { 0x1.fffa4cp-1, 0x1.161be4p-12 },
	   { 0x1.fffa90p-1, 0x1.09cfa4p-12 },
	   { 0x1.fffad0p-1, 0x1.fc0d56p-13 },
	   { 0x1.fffb0ep-1, 0x1.e577bcp-13 },
	   { 0x1.fffb4ap-1, 0x1.cfd4a6p-13 },
	   { 0x1.fffb82p-1, 0x1.bb1a96p-13 },
	   { 0x1.fffbb8p-1, 0x1.a74068p-13 },
	   { 0x1.fffbecp-1, 0x1.943d4ap-13 },
	   { 0x1.fffc1ep-1, 0x1.8208bcp-13 },
	   { 0x1.fffc4ep-1, 0x1.709a8ep-13 },
	   { 0x1.fffc7ap-1, 0x1.5feadap-13 },
	   { 0x1.fffca6p-1, 0x1.4ff208p-13 },
	   { 0x1.fffccep-1, 0x1.40a8c2p-13 },
	   { 0x1.fffcf6p-1, 0x1.3207fcp-13 },
	   { 0x1.fffd1ap-1, 0x1.2408eap-13 },
	   { 0x1.fffd3ep-1, 0x1.16a502p-13 },
	   { 0x1.fffd60p-1, 0x1.09d5f8p-13 },
	   { 0x1.fffd80p-1, 0x1.fb2b7ap-14 },
	   { 0x1.fffda0p-1, 0x1.e3bcf4p-14 },
	   { 0x1.fffdbep-1, 0x1.cd5528p-14 },
	   { 0x1.fffddap-1, 0x1.b7e946p-14 },
	   { 0x1.fffdf4p-1, 0x1.a36eecp-14 },
	   { 0x1.fffe0ep-1, 0x1.8fdc1cp-14 },
	   { 0x1.fffe26p-1, 0x1.7d2738p-14 },
	   { 0x1.fffe3ep-1, 0x1.6b4702p-14 },
	   { 0x1.fffe54p-1, 0x1.5a329cp-14 },
	   { 0x1.fffe68p-1, 0x1.49e178p-14 },
	   { 0x1.fffe7ep-1, 0x1.3a4b60p-14 },
	   { 0x1.fffe90p-1, 0x1.2b6876p-14 },
	   { 0x1.fffea2p-1, 0x1.1d3120p-14 },
	   { 0x1.fffeb4p-1, 0x1.0f9e1cp-14 },
	   { 0x1.fffec4p-1, 0x1.02a868p-14 },
	   { 0x1.fffed4p-1, 0x1.ec929ap-15 },
	   { 0x1.fffee4p-1, 0x1.d4f4b4p-15 },
	   { 0x1.fffef2p-1, 0x1.be6abcp-15 },
	   { 0x1.ffff00p-1, 0x1.a8e8ccp-15 },
	   { 0x1.ffff0cp-1, 0x1.94637ep-15 },
	   { 0x1.ffff18p-1, 0x1.80cfdcp-15 },
	   { 0x1.ffff24p-1, 0x1.6e2368p-15 },
	   { 0x1.ffff30p-1, 0x1.5c540cp-15 },
	   { 0x1.ffff3ap-1, 0x1.4b581cp-15 },
	   { 0x1.ffff44p-1, 0x1.3b2652p-15 },
	   { 0x1.ffff4ep-1, 0x1.2bb5ccp-15 },
	   { 0x1.ffff56p-1, 0x1.1cfe02p-15 },
	   { 0x1.ffff60p-1, 0x1.0ef6c4p-15 },
	   { 0x1.ffff68p-1, 0x1.019842p-15 },
	   { 0x1.ffff70p-1, 0x1.e9b5e8p-16 },
	   { 0x1.ffff78p-1, 0x1.d16f58p-16 },
	   { 0x1.ffff7ep-1, 0x1.ba4f04p-16 },
	   { 0x1.ffff84p-1, 0x1.a447b8p-16 },
	   { 0x1.ffff8cp-1, 0x1.8f4cccp-16 },
	   { 0x1.ffff92p-1, 0x1.7b5224p-16 },
	   { 0x1.ffff98p-1, 0x1.684c22p-16 },
	   { 0x1.ffff9cp-1, 0x1.562facp-16 },
	   { 0x1.ffffa2p-1, 0x1.44f21ep-16 },
	   { 0x1.ffffa6p-1, 0x1.34894ap-16 },
	   { 0x1.ffffacp-1, 0x1.24eb72p-16 },
	   { 0x1.ffffb0p-1, 0x1.160f44p-16 },
	   { 0x1.ffffb4p-1, 0x1.07ebd2p-16 },
	   { 0x1.ffffb8p-1, 0x1.f4f12ep-17 },
	   { 0x1.ffffbcp-1, 0x1.db5ad0p-17 },
	   { 0x1.ffffc0p-1, 0x1.c304f0p-17 },
	   { 0x1.ffffc4p-1, 0x1.abe09ep-17 },
	   { 0x1.ffffc6p-1, 0x1.95df98p-17 },
	   { 0x1.ffffcap-1, 0x1.80f43ap-17 },
	   { 0x1.ffffccp-1, 0x1.6d1178p-17 },
	   { 0x1.ffffd0p-1, 0x1.5a2ae0p-17 },
	   { 0x1.ffffd2p-1, 0x1.483488p-17 },
	   { 0x1.ffffd4p-1, 0x1.372310p-17 },
	   { 0x1.ffffd6p-1, 0x1.26eb9ep-17 },
	   { 0x1.ffffd8p-1, 0x1.1783cep-17 },
	   { 0x1.ffffdcp-1, 0x1.08e1bap-17 },
	   { 0x1.ffffdep-1, 0x1.f5f7d8p-18 },
	   { 0x1.ffffdep-1, 0x1.db92b6p-18 },
	   { 0x1.ffffe0p-1, 0x1.c282cep-18 },
	   { 0x1.ffffe2p-1, 0x1.aab7acp-18 },
	   { 0x1.ffffe4p-1, 0x1.94219cp-18 },
	   { 0x1.ffffe6p-1, 0x1.7eb1a2p-18 },
	   { 0x1.ffffe8p-1, 0x1.6a5972p-18 },
	   { 0x1.ffffe8p-1, 0x1.570b6ap-18 },
	   { 0x1.ffffeap-1, 0x1.44ba86p-18 },
	   { 0x1.ffffeap-1, 0x1.335a62p-18 },
	   { 0x1.ffffecp-1, 0x1.22df2ap-18 },
	   { 0x1.ffffeep-1, 0x1.133d96p-18 },
	   { 0x1.ffffeep-1, 0x1.046aeap-18 },
	   { 0x1.fffff0p-1, 0x1.ecb9d0p-19 },
	   { 0x1.fffff0p-1, 0x1.d21398p-19 },
	   { 0x1.fffff2p-1, 0x1.b8d094p-19 },
	   { 0x1.fffff2p-1, 0x1.a0df10p-19 },
	   { 0x1.fffff2p-1, 0x1.8a2e26p-19 },
	   { 0x1.fffff4p-1, 0x1.74adc8p-19 },
	   { 0x1.fffff4p-1, 0x1.604ea8p-19 },
	   { 0x1.fffff4p-1, 0x1.4d0232p-19 },
	   { 0x1.fffff6p-1, 0x1.3aba86p-19 },
	   { 0x1.fffff6p-1, 0x1.296a70p-19 },
	   { 0x1.fffff6p-1, 0x1.190562p-19 },
	   { 0x1.fffff8p-1, 0x1.097f62p-19 },
	   { 0x1.fffff8p-1, 0x1.f59a20p-20 },
	   { 0x1.fffff8p-1, 0x1.d9c736p-20 },
	   { 0x1.fffff8p-1, 0x1.bf716cp-20 },
	   { 0x1.fffffap-1, 0x1.a6852cp-20 },
	   { 0x1.fffffap-1, 0x1.8eefd8p-20 },
	   { 0x1.fffffap-1, 0x1.789fb8p-20 },
	   { 0x1.fffffap-1, 0x1.6383f8p-20 },
	   { 0x1.fffffap-1, 0x1.4f8c96p-20 },
	   { 0x1.fffffap-1, 0x1.3caa62p-20 },
	   { 0x1.fffffcp-1, 0x1.2acee2p-20 },
	   { 0x1.fffffcp-1, 0x1.19ec60p-20 },
	   { 0x1.fffffcp-1, 0x1.09f5d0p-20 },
	   { 0x1.fffffcp-1, 0x1.f5bd96p-21 },
	   { 0x1.fffffcp-1, 0x1.d9371ep-21 },
	   { 0x1.fffffcp-1, 0x1.be41dep-21 },
	   { 0x1.fffffcp-1, 0x1.a4c89ep-21 },
	   { 0x1.fffffcp-1, 0x1.8cb738p-21 },
	   { 0x1.fffffep-1, 0x1.75fa8ep-21 },
	   { 0x1.fffffep-1, 0x1.608078p-21 },
	   { 0x1.fffffep-1, 0x1.4c37c0p-21 },
	   { 0x1.fffffep-1, 0x1.39100ep-21 },
	   { 0x1.fffffep-1, 0x1.26f9e0p-21 },
	   { 0x1.fffffep-1, 0x1.15e682p-21 },
	   { 0x1.fffffep-1, 0x1.05c804p-21 },
	   { 0x1.fffffep-1, 0x1.ed2254p-22 },
	   { 0x1.fffffep-1, 0x1.d06ad6p-22 },
	   { 0x1.fffffep-1, 0x1.b551c8p-22 },
	   { 0x1.fffffep-1, 0x1.9bc0a0p-22 },
	   { 0x1.fffffep-1, 0x1.83a200p-22 },
	   { 0x1.fffffep-1, 0x1.6ce1aap-22 },
	   { 0x1.fffffep-1, 0x1.576c72p-22 },
	   { 0x1.fffffep-1, 0x1.43302cp-22 },
	   { 0x1.fffffep-1, 0x1.301ba2p-22 },
	   { 0x1.fffffep-1, 0x1.1e1e86p-22 },
	   { 0x1.fffffep-1, 0x1.0d2966p-22 },
	   { 0x1.000000p+0, 0x1.fa5b50p-23 },
	   { 0x1.000000p+0, 0x1.dc3ae4p-23 },
	   { 0x1.000000p+0, 0x1.bfd756p-23 },
	   { 0x1.000000p+0, 0x1.a517dap-23 },
	   { 0x1.000000p+0, 0x1.8be4f8p-23 },
	   { 0x1.000000p+0, 0x1.74287ep-23 },
	   { 0x1.000000p+0, 0x1.5dcd66p-23 },
	   { 0x1.000000p+0, 0x1.48bfd4p-23 },
	   { 0x1.000000p+0, 0x1.34ecf8p-23 },
	   { 0x1.000000p+0, 0x1.224310p-23 },
	   { 0x1.000000p+0, 0x1.10b148p-23 },
  },
};
